/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.cap.AppletComponent;
import com.sun.javacard.jcasm.cap.AppletXml;
import com.sun.javacard.jcasm.cap.ClassComponent;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcasm.cap.ConstantPoolComponent;
import com.sun.javacard.jcasm.cap.DescriptorComponent;
import com.sun.javacard.jcasm.cap.DirectoryComponent;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.cap.HeaderComponent;
import com.sun.javacard.jcasm.cap.ImportComponent;
import com.sun.javacard.jcasm.cap.JavacardXml;
import com.sun.javacard.jcasm.cap.MethodComponent;
import com.sun.javacard.jcasm.cap.ReferenceLocationComponent;
import com.sun.javacard.jcasm.cap.StaticFieldComponent;
import com.sun.javacard.jcasm.cap.Xml;
import com.sun.javacard.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CapWriter {
    private static final Attributes.Name TIMESTAMP = new Attributes.Name("Java-Card-CAP-Creation-Time");
    private static final Attributes.Name CAP_FILE_VERSION = new Attributes.Name("Java-Card-CAP-File-Version");
    private static final Attributes.Name CONVERTER_VERSION = new Attributes.Name("Java-Card-Converter-Version");
    private static final Attributes.Name CONVERTER_PROVIDER = new Attributes.Name("Java-Card-Converter-Provider");
    private static final Attributes.Name PACKAGE_VERSION = new Attributes.Name("Java-Card-Package-Version");
    private static final Attributes.Name PACKAGE_NAME = new Attributes.Name("Java-Card-Package-Name");
    private static final Attributes.Name PACKAGE_AID = new Attributes.Name("Java-Card-Package-AID");
    private static final Attributes.Name INTEGER_SUPPORT = new Attributes.Name("Java-Card-Integer-Support-Required");
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    private static final Attributes.Name JCRD_VERSION = new Attributes.Name("Runtime-Descriptor-Version");
    private static final Attributes.Name APPLICATION_TYPE = new Attributes.Name("Application-Type");
    private static final Attributes.Name SEALED = new Attributes.Name("Sealed");
    private static final Attributes.Name CLASSIC_PKG_AID = new Attributes.Name("Classic-Package-AID");
    protected File file;
    protected String packageName;
    protected long timeStamp;
    private Hashtable<String, JarEntryData> capEntries = new Hashtable();

    public CapWriter(File file, String packageName) {
        this.file = file;
        this.packageName = packageName;
        this.timeStamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readInputCap(String capFileName) {
        JarFile f = null;
        try {
            JarEntry je = null;
            f = new JarFile(capFileName);
            Enumeration<JarEntry> e = f.entries();
            while (e.hasMoreElements()) {
                je = e.nextElement();
                if (je.getSize() == 0L) continue;
                JarEntryData jed = new JarEntryData();
                jed.je = je;
                long dataSize = je.getSize();
                long offset = 0L;
                byte[] data = new byte[(int)je.getSize()];
                InputStream is = f.getInputStream(je);
                for (offset = (long)is.read(data); offset < dataSize; offset += (long)is.read(data, (int)offset, 1024)) {
                }
                jed.data = data;
                this.capEntries.put(je.getName(), jed);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String findPackageName() {
        String pkgName = null;
        Enumeration<String> names = this.capEntries.keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toLowerCase();
            if (!name.endsWith("/javacard/header.cap")) continue;
            pkgName = name.substring(0, name.indexOf("/header.cap"));
            break;
        }
        return pkgName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(File[] jClasses, File[] sioProxies, AppletXml appletXml, JavacardXml javacardXml, ConversionProfile cp, HeaderComponent header) {
        this.readInputCap(cp.inputCapName);
        String startingString = this.findPackageName();
        ZipOutputStream jos = null;
        ZipInputStream jis = null;
        try {
            try {
                FileInputStream fis = new FileInputStream(cp.inputCapName);
                jis = new JarInputStream(fis);
                Manifest mf = ((JarInputStream)jis).getManifest();
                boolean b = appletXml != null;
                jos = new JarOutputStream((OutputStream)new FileOutputStream(this.file), this.getJarManifest(header.getParentPackage(), mf, b));
            }
            catch (IOException e) {
                Object[] arguments = new Object[]{this.file.getAbsolutePath()};
                Msg.error("capWriter.1", arguments);
                if (jis != null) {
                    try {
                        jis.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (jos != null) {
                    try {
                        jos.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                return;
            }
            jos.setMethod(0);
            Enumeration<String> names = this.capEntries.keys();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                if (!name.toLowerCase().startsWith(startingString)) continue;
                JarEntryData jed = this.capEntries.get(name);
                this.addJarEntry((JarOutputStream)jos, jed.je, jed.data);
            }
            this.publishCommon((JarOutputStream)jos, jClasses, sioProxies, appletXml, javacardXml);
            jos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (IOException ex) {}
            }
            if (jos != null) {
                try {
                    jos.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(HeaderComponent header, DirectoryComponent directory, AppletComponent applet, ImportComponent imports, ConstantPoolComponent constantPool, ClassComponent classes, MethodComponent methods, StaticFieldComponent staticFields, ReferenceLocationComponent referenceLocation, ExportComponent export, DescriptorComponent descriptor, DebugComponent debugCmp, File[] jClasses, File[] sioProxies, AppletXml appletXml, JavacardXml javacardXml) throws IOException {
        ZipOutputStream jos = null;
        try {
            try {
                boolean b = appletXml != null;
                jos = new JarOutputStream((OutputStream)new FileOutputStream(this.file), this.getJarManifest(header.getParentPackage(), null, b));
            }
            catch (IOException e) {
                Object[] arguments = new Object[]{this.file.getAbsolutePath()};
                Msg.error("capWriter.1", arguments);
                if (jos != null) {
                    try {
                        jos.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                return;
            }
            jos.setMethod(0);
            this.addJarEntry((JarOutputStream)jos, "Header.cap", header);
            this.addJarEntry((JarOutputStream)jos, "Directory.cap", directory);
            if (applet != null) {
                this.addJarEntry((JarOutputStream)jos, "Applet.cap", applet);
            }
            this.addJarEntry((JarOutputStream)jos, "Import.cap", imports);
            this.addJarEntry((JarOutputStream)jos, "ConstantPool.cap", constantPool);
            this.addJarEntry((JarOutputStream)jos, "Class.cap", classes);
            this.addJarEntry((JarOutputStream)jos, "Method.cap", methods);
            this.addJarEntry((JarOutputStream)jos, "StaticField.cap", staticFields);
            this.addJarEntry((JarOutputStream)jos, "RefLocation.cap", referenceLocation);
            if (export != null) {
                this.addJarEntry((JarOutputStream)jos, "Export.cap", export);
            }
            if (descriptor != null) {
                this.addJarEntry((JarOutputStream)jos, "Descriptor.cap", descriptor);
            }
            if (debugCmp != null) {
                byte[] debugData = this.mergeDebugOffsets(classes, methods, staticFields);
                this.addJarEntry((JarOutputStream)jos, "Debug.cap", debugData);
            }
            this.publishCommon((JarOutputStream)jos, jClasses, sioProxies, appletXml, javacardXml);
        }
        finally {
            if (jos != null) {
                try {
                    jos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishUsingCapComponents(ConversionProfile cp, HeaderComponent header, File[] sioProxies, AppletXml appletXml, JavacardXml javacardXml) throws IOException {
        ZipOutputStream jos = null;
        try {
            try {
                boolean b = appletXml != null;
                jos = new JarOutputStream((OutputStream)new FileOutputStream(this.file), this.getJarManifest(header.getParentPackage(), null, b));
            }
            catch (IOException e) {
                Object[] arguments = new Object[]{this.file.getAbsolutePath()};
                Msg.error("capWriter.1", arguments);
                if (jos != null) {
                    try {
                        jos.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                return;
            }
            jos.setMethod(0);
            String dir = cp.class_root + "/" + this.packageName + "/javacard";
            Vector<File> vf = FileUtils.listAllFilesInFolder(new File(dir), ".cap");
            for (File f : vf) {
                RandomAccessFile raf = new RandomAccessFile(f.getAbsoluteFile(), "r");
                byte[] rafData = new byte[(int)raf.length()];
                raf.readFully(rafData);
                this.addJarEntry((JarOutputStream)jos, f.getName(), rafData);
            }
            this.publishCommon((JarOutputStream)jos, cp.classes, sioProxies, appletXml, javacardXml);
        }
        finally {
            if (jos != null) {
                try {
                    jos.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private void publishCommon(JarOutputStream jos, File[] jClasses, File[] sioProxies, AppletXml appletXml, JavacardXml javacardXml) throws IOException {
        if (javacardXml != null) {
            this.addJarEntry(jos, "META-INF/javacard.xml", javacardXml);
        }
        if (jClasses != null) {
            if (appletXml != null) {
                this.addJarEntry(jos, "APPLET-INF/applet.xml", appletXml);
                this.addJarEntry(jos, "APPLET-INF/classes/" + this.packageName, jClasses);
                if (sioProxies != null) {
                    this.addJarEntry(jos, "APPLET-INF/classes/" + this.packageName + "/proxy", sioProxies);
                }
            } else {
                this.addJarEntry(jos, this.packageName, jClasses);
                if (sioProxies != null) {
                    this.addJarEntry(jos, this.packageName + "/proxy", sioProxies);
                }
            }
        }
    }

    private Manifest getJarManifest(JCPackage jcPkg, Manifest baseManifest, boolean isClassicAppletPackage) throws IOException {
        Manifest mf = null;
        mf = baseManifest == null ? new Manifest() : new Manifest(baseManifest);
        Attributes mfa = mf.getMainAttributes();
        String entryName = jcPkg.getName();
        Attributes entryAttributes = mf.getAttributes(entryName);
        if (entryAttributes == null) {
            entryAttributes = new Attributes();
        }
        mfa.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mfa.put(CREATED_BY, System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        mfa.put(JCRD_VERSION, "3.0");
        mfa.put(APPLICATION_TYPE, "classic-applet");
        String aid = Strings.toAidURI(jcPkg.getIdentifier().getAid().toByteArray());
        mfa.put(CLASSIC_PKG_AID, aid);
        mfa.put(SEALED, "true");
        Date d = new Date(this.timeStamp);
        entryAttributes.put(TIMESTAMP, d.toString());
        entryAttributes.put(CONVERTER_VERSION, ToolsVersion.getVersion(1));
        entryAttributes.put(CONVERTER_PROVIDER, "Oracle Corporation");
        if (jcPkg.is22Package()) {
            entryAttributes.put(CAP_FILE_VERSION, "2.2");
        } else {
            entryAttributes.put(CAP_FILE_VERSION, "2.1");
        }
        entryAttributes.put(PACKAGE_VERSION, jcPkg.getIdentifier().getMajorVersion() + "." + jcPkg.getIdentifier().getMinorVersion());
        entryAttributes.put(PACKAGE_NAME, jcPkg.getName().replace('/', '.'));
        entryAttributes.put(PACKAGE_AID, jcPkg.getIdentifier().getAid().toString());
        int i = 1;
        Enumeration<Object> f = jcPkg.appletElements();
        while (f.hasMoreElements()) {
            AppletDeclarator ad = f.nextElement();
            entryAttributes.put(new Attributes.Name("Java-Card-Applet-" + i + "-Name"), ad.getName());
            entryAttributes.put(new Attributes.Name("Java-Card-Applet-" + i + "-AID"), ad.getAid().toString());
            ++i;
        }
        i = 1;
        f = jcPkg.importElements();
        while (f.hasMoreElements()) {
            PackageIdentifier pi = (PackageIdentifier)f.nextElement();
            entryAttributes.put(new Attributes.Name("Java-Card-Imported-Package-" + i + "-AID"), pi.getAid().toString());
            entryAttributes.put(new Attributes.Name("Java-Card-Imported-Package-" + i + "-Version"), pi.getMajorVersion() + "." + pi.getMinorVersion());
            ++i;
        }
        if (jcPkg.usesIntegers()) {
            entryAttributes.put(INTEGER_SUPPORT, "TRUE");
        } else {
            entryAttributes.put(INTEGER_SUPPORT, "FALSE");
        }
        mf.getEntries().put(entryName, entryAttributes);
        return mf;
    }

    private void addJarEntry(JarOutputStream jos, JarEntry sourceEntry, byte[] data) throws IOException {
        if (data == null) {
            throw new NullPointerException("Bad Data:" + sourceEntry.getName());
        }
        JarEntry je = new JarEntry(sourceEntry.getName());
        je.setSize(data.length);
        je.setTime(sourceEntry.getTime());
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        je.setCrc(crc.getValue());
        jos.putNextEntry(je);
        jos.write(data, 0, data.length);
    }

    private void addJarEntry(JarOutputStream jos, String fileName, Xml file) throws IOException {
        byte[] data = file.toByteArray();
        JarEntry je = new JarEntry(fileName);
        je.setSize(data.length);
        je.setTime(this.timeStamp);
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        je.setCrc(crc.getValue());
        jos.putNextEntry(je);
        jos.write(data, 0, data.length);
    }

    private void addJarEntry(JarOutputStream jos, String path, File[] pkgClasses) throws IOException {
        for (int i = 0; i < pkgClasses.length; ++i) {
            File c = pkgClasses[i];
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(c)));
            byte[] data = new byte[dis.available()];
            dis.read(data);
            dis.close();
            String entryName = path + "/" + c.getName();
            JarEntry je = new JarEntry(entryName);
            je.setSize(data.length);
            je.setTime(this.timeStamp);
            CRC32 crc = new CRC32();
            crc.update(data, 0, data.length);
            je.setCrc(crc.getValue());
            jos.putNextEntry(je);
            jos.write(data, 0, data.length);
        }
    }

    private void addJarEntry(JarOutputStream jos, String name, Component component) throws IOException {
        byte[] data = component.toByteArray();
        if (data == null) {
            throw new NullPointerException("Bad Component:" + name);
        }
        JarEntry je = new JarEntry(this.packageName + "/javacard/" + name);
        je.setSize(data.length);
        je.setTime(this.timeStamp);
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        je.setCrc(crc.getValue());
        jos.putNextEntry(je);
        jos.write(data, 0, data.length);
    }

    private void addJarEntry(JarOutputStream jos, String name, byte[] data) throws IOException {
        JarEntry je = new JarEntry(this.packageName + "/javacard/" + name);
        je.setSize(data.length);
        je.setTime(this.timeStamp);
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        je.setCrc(crc.getValue());
        jos.putNextEntry(je);
        jos.write(data, 0, data.length);
    }

    private byte[] mergeDebugOffsets(ClassComponent classes, MethodComponent methods, StaticFieldComponent staticFields) {
        Hashtable<String, Integer> offsets = new Hashtable<String, Integer>();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        classes.getDebugOffsets(offsets);
        methods.getDebugOffsets(offsets);
        staticFields.getDebugOffsets(offsets);
        try {
            if (Globals.outputDebugData != null) {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(Globals.outputDebugData));
                this.mergeDebugComponent(dis, dos, offsets);
            }
            bos.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    private void mergeDebugComponent(DataInputStream dis, DataOutputStream dos, Map<String, Integer> offsets) throws IOException {
        dos.writeByte(dis.readUnsignedByte());
        dos.writeShort(dis.readUnsignedShort());
        int string_count = dis.readUnsignedShort();
        dos.writeShort(string_count);
        String[] strings = new String[string_count];
        for (int s = 0; s < string_count; ++s) {
            strings[s] = dis.readUTF();
            dos.writeUTF(strings[s]);
        }
        dos.writeShort(dis.readUnsignedShort());
        int class_count = dis.readUnsignedShort();
        dos.writeShort(class_count);
        for (int c = 0; c < class_count; ++c) {
            this.mergeClassDebugInfo(dis, dos, strings, offsets);
        }
    }

    private void mergeClassDebugInfo(DataInputStream dis, DataOutputStream dos, String[] strings, Map<String, Integer> offsets) throws IOException {
        int name_index = dis.readUnsignedShort();
        dos.writeShort(name_index);
        dos.writeShort(dis.readUnsignedShort());
        dis.readUnsignedShort();
        String name = strings[name_index];
        Integer offset = offsets.get(name);
        dos.writeShort(offset);
        dos.writeShort(dis.readUnsignedShort());
        dos.writeShort(dis.readUnsignedShort());
        int interface_count = dis.readUnsignedByte();
        dos.writeByte(interface_count);
        int field_count = dis.readUnsignedShort();
        dos.writeShort(field_count);
        int method_count = dis.readUnsignedShort();
        dos.writeShort(method_count);
        for (int i = 0; i < interface_count; ++i) {
            dos.writeShort(dis.readUnsignedShort());
        }
        for (int f = 0; f < field_count; ++f) {
            this.mergeFieldDebugInfo(dis, dos, strings, offsets, name);
        }
        for (int m = 0; m < method_count; ++m) {
            this.mergeMethodDebugInfo(dis, dos, strings, offsets, name);
        }
    }

    private void mergeMethodDebugInfo(DataInputStream dis, DataOutputStream dos, String[] strings, Map<String, Integer> offsets, String className) throws IOException {
        int ACC_ABSTRACT = 1024;
        int name_index = dis.readUnsignedShort();
        dos.writeShort(name_index);
        int descriptor_index = dis.readUnsignedShort();
        dos.writeShort(descriptor_index);
        int access_flags = dis.readUnsignedShort();
        dos.writeShort(access_flags);
        boolean isAbstract = (access_flags & 0x400) != 0;
        dis.readUnsignedShort();
        if (isAbstract) {
            dos.writeShort(0);
        } else {
            String name = strings[name_index];
            String descriptor = strings[descriptor_index];
            String signature = className + "/" + name + descriptor;
            Integer offset = offsets.get(signature);
            dos.writeShort(offset);
        }
        dos.writeByte(dis.readUnsignedByte());
        dos.writeShort(dis.readUnsignedShort());
        int variable_count = dis.readUnsignedShort();
        dos.writeShort(variable_count);
        int line_count = dis.readUnsignedShort();
        dos.writeShort(line_count);
        for (int v = 0; v < variable_count; ++v) {
            dos.writeByte(dis.readUnsignedByte());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
        }
        for (int k = 0; k < line_count; ++k) {
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
        }
    }

    private void mergeFieldDebugInfo(DataInputStream dis, DataOutputStream dos, String[] strings, Map<String, Integer> offsets, String className) throws IOException {
        int ACC_STATIC = 8;
        int ACC_FINAL = 16;
        int name_index = dis.readUnsignedShort();
        dos.writeShort(name_index);
        int descriptor_index = dis.readUnsignedShort();
        dos.writeShort(descriptor_index);
        int access_flags = dis.readUnsignedShort();
        dos.writeShort(access_flags);
        boolean isStatic = (access_flags & 8) != 0;
        boolean isFinal = (access_flags & 0x10) != 0;
        boolean isPrimitive = strings[descriptor_index].length() == 1;
        if (isStatic & !(isFinal & isPrimitive)) {
            dos.writeShort(dis.readUnsignedShort());
            dis.readUnsignedShort();
            String name = className + "/" + strings[name_index];
            Integer offset = offsets.get(name);
            dos.writeShort(offset);
        } else {
            dos.writeInt(dis.readInt());
        }
    }

    class JarEntryData {
        JarEntry je;
        byte[] data;

        JarEntryData() {
        }
    }
}

