/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndFieldDescriptor;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ExportedClass;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.FieldTypeAndFlags;
import com.sun.javacard.offcardverifier.Fieldref;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfElement;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.util.TreeSet;
import java.util.Vector;

class ExportComponent
extends Safeptr {
    Vector<Integer> exportedClasses = new Vector();
    ExportFile exportfile = null;
    ExportFile thisExportFile = null;

    ExportComponent(byte[] data) {
        super(data, "Export");
    }

    int classCount() {
        return this.u1(0);
    }

    ExportedClass firstExportedClass() {
        return new ExportedClass(this.offset(1));
    }

    void findExportFile() {
        PackageInfo pkg = Cap.Header.thisPackage();
        this.exportfile = ImportComponent.findExportByAidAndVersion(pkg);
        this.thisExportFile = ImportComponent.findExportByAidAndVersion(pkg);
        if (this.exportfile == null) {
            throw new VerifierError("ExportComponent.1", (Object)AID.pretty(pkg), pkg.majorVersion(), pkg.minorVersion());
        }
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("ExportComponent.101");
        }
        if (this.classCount() >= 256) {
            throw new VerifierError("ExportComponent.2", this.classCount());
        }
        if (this.classCount() == 0) {
            throw new VerifierError("ExportComponent.44");
        }
        ExportedClass ecls = this.firstExportedClass();
        for (int i = 0; i < this.classCount(); ++i) {
            this.verifyClass(i, ecls);
            this.exportedClasses.add(new Integer(ecls.classOffset()));
            ecls.next();
        }
        if (!ecls.atComponentEnd()) {
            throw new VerifierError("ExportComponent.3");
        }
        if (Verifier.verbose >= 2) {
            Messages.println("ExportComponent.102", this.exportfile.file);
        }
        this.verifyExport();
    }

    private void verifyClass(int token, ExportedClass ecls) {
        int ofs;
        int i;
        ClassDescriptor cdesc = Classref.checkInternal(ecls.classOffset());
        if ((cdesc.flags() & 1) == 0) {
            throw new VerifierError("ExportComponent.6", token);
        }
        if (cdesc.token() != token) {
            throw new VerifierError("ExportComponent.7", cdesc.token(), token);
        }
        if (ecls.staticFieldCount() > 256) {
            throw new VerifierError("ExportComponent.8", token, ecls.staticFieldCount());
        }
        for (i = 0; i < ecls.staticFieldCount(); ++i) {
            ofs = ecls.staticFieldOffset(i);
            ClassAndFieldDescriptor cfdesc = Fieldref.findDescr(ofs);
            FieldDescriptor fdesc = cfdesc.fieldDescr;
            if ((fdesc.flags() & 5) == 0) {
                throw new VerifierError("ExportComponent.9", ofs);
            }
            if (fdesc.token() != i) {
                throw new VerifierError("ExportComponent.10", fdesc.token(), i);
            }
            if (cfdesc.classDescr.thisClass() == ecls.classOffset()) continue;
            throw new VerifierError("ExportComponent.47", i, cfdesc.classDescr.thisClass(), ecls.classOffset());
        }
        if (ecls.staticFieldCount() != cdesc.num_exported_static_fields()) {
            throw new VerifierError("ExportComponent.45", ecls.classOffset());
        }
        if (ecls.staticMethodCount() > 256) {
            throw new VerifierError("ExportComponent.11", token);
        }
        for (i = 0; i < ecls.staticMethodCount(); ++i) {
            ofs = ecls.staticMethodOffset(i);
            ClassAndMethodDescriptor cmdesc = Methodref.findDescr(ofs);
            MethodDescriptor mdesc = cmdesc.methodDescr;
            if ((mdesc.flags() & 0x88) == 0) {
                throw new VerifierError("ExportComponent.12", ofs);
            }
            if ((mdesc.flags() & 5) == 0) {
                throw new VerifierError("ExportComponent.13", ofs);
            }
            if (mdesc.token() != i) {
                throw new VerifierError("ExportComponent.14", mdesc.token(), i);
            }
            if (cmdesc.classDescr.thisClass() == ecls.classOffset()) continue;
            throw new VerifierError("ExportComponent.48", i, cmdesc.classDescr.thisClass(), ecls.classOffset());
        }
        if (ecls.staticMethodCount() != cdesc.num_exported_static_methods()) {
            throw new VerifierError("ExportComponent.46", ecls.classOffset());
        }
    }

    private void verifyExport() {
        boolean accApplet;
        if (!Cap.packageDirectory.equals(this.exportfile.thisName())) {
            throw new VerifierError("ExportComponent.39", (Object)this.exportfile.thisName(), (Object)Cap.packageDirectory);
        }
        boolean accLibrary = (this.exportfile.thisPackage().flags & 1) != 0;
        if (accLibrary != !(accApplet = (Cap.Header.flags() & 4) != 0)) {
            throw new VerifierError("ExportComponent.40");
        }
        for (EfClass ec : this.exportfile.classes) {
            this.checkExportClass(ec);
        }
        if (this.exportfile.classes.length != Cap.Export.classCount()) {
            throw new VerifierError("ExportComponent.41");
        }
    }

    private void checkExportClass(EfClass ec) {
        try {
            int cref = Classref.forExportToken(ec.token);
            ClassDescriptor cdesc = Classref.checkInternal(cref);
            int flags = 0;
            if ((ec.accessFlag & 1) != 0) {
                flags |= 1;
            }
            if ((ec.accessFlag & 0x10) != 0) {
                flags |= 0x10;
            }
            if ((ec.accessFlag & 0x200) != 0) {
                flags |= 0x40;
            }
            if ((ec.accessFlag & 0x400) != 0) {
                flags |= 0x80;
            }
            if (flags != cdesc.flags()) {
                throw new VerifierError("ExportComponent.18");
            }
            if (!this.allClaimedInterfaces(ec).equals(this.allActualInterfaces(cref))) {
                throw new VerifierError("ExportComponent.19");
            }
            if (!this.allClaimedSuperclasses(ec).equals(this.allActualSuperclasses(cref))) {
                throw new VerifierError("ExportComponent.20");
            }
            int numExportedFields = 0;
            for (EfField efField : ec.fields) {
                if (efField.token == 255) {
                    if (!efField.sig().equals("I")) continue;
                    Cap.Header.useInts();
                    continue;
                }
                this.checkExportField(ec, efField, cdesc.thisClass());
                ++numExportedFields;
            }
            if (numExportedFields != this.numPublicFields(cdesc)) {
                throw new VerifierError("ExportComponent.42");
            }
            for (EfElement efElement : ec.methods) {
                ExportComponent.checkExportMethod(ec, (EfMethod)efElement, cdesc.thisClass());
            }
            if (ec.methods.length != this.numPublicMethods(cdesc)) {
                throw new VerifierError("ExportComponent.43");
            }
        }
        catch (VerifierError e) {
            throw new VerifierError("ExportComponent.21", (Object)ec, (Object)e.getMessage());
        }
    }

    private void checkExportField(EfClass ec, EfField ef, int classref) {
        try {
            boolean isStatic = (ef.accessFlag & 8) != 0;
            FieldTypeAndFlags ftyf = Fieldref.findByToken(classref, ef.token, isStatic);
            int flags = 0;
            if ((ef.accessFlag & 1) != 0) {
                flags |= 1;
            }
            if ((ef.accessFlag & 4) != 0) {
                flags |= 4;
            }
            if ((ef.accessFlag & 8) != 0) {
                flags |= 8;
            }
            if ((ef.accessFlag & 0x10) != 0) {
                flags |= 0x10;
            }
            if (flags != ftyf.flags) {
                throw new VerifierError("ExportComponent.28");
            }
            Type ty = Type.parseExport(ef.sig());
            if (!ty.equals(ftyf.fty)) {
                throw new VerifierError("ExportComponent.29");
            }
        }
        catch (VerifierError e) {
            throw new VerifierError("ExportComponent.30", (Object)ef, (Object)e.getMessage());
        }
    }

    public static void checkExportMethod(EfClass ec, EfMethod em, int classref) {
        try {
            boolean isStatic = (em.accessFlag & 8) != 0 || em.name().equals("<init>");
            MethodTypeAndFlags mtyf = Methodref.findByToken(classref, em.token, isStatic);
            if (mtyf == null) {
                throw new VerifierError("ExportComponent.38");
            }
            int flags = 0;
            if ((em.accessFlag & 1) != 0) {
                flags |= 1;
            }
            if ((em.accessFlag & 4) != 0) {
                flags |= 4;
            }
            if ((em.accessFlag & 8) != 0) {
                flags |= 8;
            }
            if ((em.accessFlag & 0x10) != 0) {
                flags |= 0x10;
            }
            if ((em.accessFlag & 0x400) != 0) {
                flags |= 0x40;
            }
            if (em.name().equals("<init>")) {
                flags |= 0x80;
            }
            if (flags != mtyf.flags) {
                throw new VerifierError("ExportComponent.33");
            }
            TypeMethod ty = TypeMethod.parseExport(em.sig());
            if (!ty.equals(mtyf.mty)) {
                throw new VerifierError("ExportComponent.34");
            }
        }
        catch (VerifierError e) {
            throw new VerifierError("ExportComponent.35", (Object)em, (Object)e.getMessage());
        }
    }

    private TreeSet<String> allClaimedSuperclasses(EfClass ec) {
        TreeSet<String> allSuper = new TreeSet<String>();
        for (int i = 0; i < ec.supers.length; ++i) {
            allSuper.add(ec.superName(i));
        }
        return allSuper;
    }

    private TreeSet<String> allClaimedInterfaces(EfClass ec) {
        TreeSet<String> allIntf = new TreeSet<String>();
        for (int i = 0; i < ec.interfaces.length; ++i) {
            allIntf.add(ec.interfaceName(i));
        }
        return allIntf;
    }

    private TreeSet<String> allActualSuperclasses(int cref) {
        EfClass ec;
        TreeSet<String> allSuper = new TreeSet<String>();
        if ((Cap.Class.infoOfs(cref).flags() & 8) != 0) {
            allSuper.add("java/lang/Object");
            return allSuper;
        }
        do {
            if ((cref = Cap.Class.infoOfs(cref).superclass()) == 65535) {
                return allSuper;
            }
            ec = Classref.toExportClass(cref);
            if (ec == null) continue;
            allSuper.add(ec.thisName());
        } while (!Classref.isExternal(cref));
        ec = Classref.toExportClass(cref);
        allSuper.add(ec.thisName());
        for (int i = 0; i < ec.supers.length; ++i) {
            allSuper.add(ec.superName(i));
        }
        return allSuper;
    }

    private TreeSet<String> allActualInterfaces(int cref) {
        TreeSet<String> allIntf = new TreeSet<String>();
        ClassInfo cinfo = Cap.Class.infoOfs(cref);
        if ((cinfo.flags() & 8) != 0) {
            for (int i = 0; i < cinfo.interfaceCount(); ++i) {
                int iref = cinfo.superinterface(i);
                this.addInterfaceAndSuperinterfaces(allIntf, iref);
            }
        } else {
            ClassDescriptor cdesc = Classref.checkInternal(cref);
            for (int i = 0; i < cdesc.interfaceCount(); ++i) {
                int iref = cdesc.interfaceRef(i);
                EfClass ec = Classref.toExportClass(iref);
                if (ec == null) continue;
                allIntf.add(ec.thisName());
            }
            allIntf.addAll(this.allActualInterfacesFromSupers(cref));
        }
        return allIntf;
    }

    private TreeSet<String> allActualInterfacesFromSupers(int cref) {
        TreeSet<String> allIntf = new TreeSet<String>();
        if (cref != 65535) {
            EfClass ec = Classref.toExportClass(cref);
            if (Classref.isExternal(cref)) {
                for (int i = 0; i < ec.interfaces.length; ++i) {
                    allIntf.add(ec.interfaceName(i));
                }
            } else {
                ClassDescriptor cdesc = Classref.checkInternal(cref);
                for (int i = 0; i < cdesc.interfaceCount(); ++i) {
                    int iref = cdesc.interfaceRef(i);
                    EfClass ei = Classref.toExportClass(iref);
                    if (ei == null) continue;
                    allIntf.add(ei.thisName());
                }
                ClassInfo cinfo = Cap.Class.infoOfs(cdesc.thisClass());
                allIntf.addAll(this.allActualInterfacesFromSupers(cinfo.superclass()));
            }
        }
        return allIntf;
    }

    private void addInterfaceAndSuperinterfaces(TreeSet<String> allIntf, int iref) {
        EfClass ec = Classref.toExportClass(iref);
        allIntf.add(ec.thisName());
        if (Classref.isExternal(iref)) {
            for (int i = 0; i < ec.interfaces.length; ++i) {
                allIntf.add(ec.interfaceName(i));
            }
        } else {
            ClassInfo cinfo = Cap.Class.infoOfs(iref);
            for (int i = 0; i < cinfo.interfaceCount(); ++i) {
                int siref = cinfo.superinterface(i);
                this.addInterfaceAndSuperinterfaces(allIntf, siref);
            }
        }
    }

    private boolean checkImplementedInterface(int cref, String intfname) {
        if (!Classref.isExternal(cref)) {
            ClassDescriptor cdesc = Classref.checkInternal(cref);
            for (int i = 0; i < cdesc.interfaceCount(); ++i) {
                int iref = cdesc.interfaceRef(i);
                EfClass ec = Classref.toExportClass(iref);
                if (ec != null && intfname.equals(ec.thisName())) {
                    return true;
                }
                if (!this.checkImplementedInterface(iref, intfname)) continue;
                return true;
            }
            return false;
        }
        EfClass ec = Classref.toExportClass(cref);
        for (int i = 0; i < ec.interfaces.length; ++i) {
            if (!intfname.equals(ec.interfaceName(i))) continue;
            return true;
        }
        return false;
    }

    boolean isExported(int ref) {
        Integer refInt = new Integer(ref);
        return this.exportedClasses.contains(refInt);
    }

    EfClass exportclassForToken(int token) {
        for (EfClass ec : this.exportfile.classes) {
            if (ec.token != token) continue;
            return ec;
        }
        throw new VerifierError("ExportComponent.36", token);
    }

    private int numPublicFields(ClassDescriptor c) {
        int n = 0;
        for (int i = 0; i < c.fieldCount(); ++i) {
            FieldDescriptor fd = c.fieldDescr(i);
            if ((fd.flags() & 5) == 0) continue;
            ++n;
        }
        return n;
    }

    private int numPublicMethods(ClassDescriptor c) {
        int nstatic = 0;
        TreeSet<Integer> tokens = new TreeSet<Integer>();
        for (int i = 0; i < c.methodCount(); ++i) {
            MethodDescriptor md = c.methodDescr(i);
            if ((md.flags() & 5) == 0) continue;
            if ((md.flags() & 0x88) != 0) {
                ++nstatic;
                continue;
            }
            tokens.add(new Integer(md.token()));
        }
        if ((c.flags() & 0x40) == 0) {
            int cref = c.thisClass();
            while (!Classref.isExternal(cref = Cap.Class.infoOfs(cref).superclass())) {
                ClassDescriptor cd = Classref.checkInternal(cref);
                for (int i = 0; i < cd.methodCount(); ++i) {
                    MethodDescriptor md = cd.methodDescr(i);
                    if ((md.flags() & 5) == 0 || (md.flags() & 0x88) != 0) continue;
                    tokens.add(new Integer(md.token()));
                }
            }
            if (cref != 65535) {
                EfClass ec = Classref.checkExternal(cref);
                for (EfMethod em : ec.methods) {
                    if (em.isStaticOrInit()) continue;
                    tokens.add(new Integer(em.token));
                }
            }
        }
        return nstatic + tokens.size();
    }
}

