/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfAttribute;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Integer;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.IOException;

public class EfAttributeConstantValue
extends EfAttribute {
    int constantvalueIndex;

    EfAttributeConstantValue(ExportFile ef) {
        super(ef);
    }

    @Override
    void read() throws IOException {
        if (this.attributeLength != 2) {
            throw new VerifierError("EfAttributeConstantValue.1", this.attributeLength);
        }
        this.constantvalueIndex = this.ef.in.readUnsignedShort();
        this.ef.checkIntegerIndex(this.constantvalueIndex);
    }

    int value() {
        return ((EfConstant_Integer)this.ef.constantPool[this.constantvalueIndex]).value();
    }

    void verify(String descr) {
        int max;
        int min;
        int val = this.value();
        if (descr.equals("Z")) {
            min = 0;
            max = 1;
        } else if (descr.equals("B")) {
            min = -128;
            max = 127;
        } else if (descr.equals("S")) {
            min = Short.MIN_VALUE;
            max = Short.MAX_VALUE;
        } else if (descr.equals("I")) {
            min = Integer.MIN_VALUE;
            max = Integer.MAX_VALUE;
        } else {
            throw new VerifierError("EfAttributeConstantValue.2");
        }
        if (val < min || val > max) {
            throw new VerifierError("EfAttributeConstantValue.3", val);
        }
    }
}

