/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager.model;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.Packager;
import com.sun.javacard.packager.model.ClassicModule;
import com.sun.javacard.packager.model.ClassicModuleJCRD;
import com.sun.javacard.packager.model.ExtendedModule;
import com.sun.javacard.packager.model.ExtendedModuleJCRD;
import com.sun.javacard.packager.model.FolderOrJar;
import com.sun.javacard.packager.model.JavaCardXML;
import com.sun.javacard.packager.model.ModuleJCRD;
import com.sun.javacard.packager.model.WebModule;
import com.sun.javacard.packager.model.WebModuleJCRD;
import com.sun.javacard.util.FileUtils;
import java.io.File;

public abstract class Module
extends FolderOrJar {
    private JavaCardXML javaCardXML;
    protected ModuleJCRD jcrd;

    public Module(String path) {
        super(path);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.isOk()) {
            return;
        }
        File runtimeDescriptorFile = new File(this.folder, "META-INF/MANIFEST.MF");
        if (!runtimeDescriptorFile.exists()) {
            this.addError(ErrorKey.JCRDDoesNotExist, new Object[0]);
        } else {
            if (this instanceof WebModule) {
                this.jcrd = new WebModuleJCRD(this, runtimeDescriptorFile);
            } else if (this instanceof ExtendedModule) {
                this.jcrd = new ExtendedModuleJCRD(this, runtimeDescriptorFile);
            } else if (this instanceof ClassicModule) {
                this.jcrd = new ClassicModuleJCRD(this, runtimeDescriptorFile);
            }
            this.addItem(this.jcrd);
            this.jcrd.initialize();
        }
        File javaCardDescriptorFile = new File(this.folder, "META-INF/javacard.xml");
        if (javaCardDescriptorFile.exists()) {
            this.javaCardXML = new JavaCardXML(javaCardDescriptorFile);
            this.addItem(this.javaCardXML);
            this.javaCardXML.initialize();
        }
    }

    @Override
    public void processInternal() {
        File toFolder;
        if (!this.isOk()) {
            return;
        }
        this.jcrd.process();
        if (this.javaCardXML != null) {
            this.javaCardXML.process();
        }
        if (!(toFolder = new File(Packager.getPackager().getWorkDir().getAbsolutePath())).equals(this.folder)) {
            toFolder.mkdirs();
            try {
                FileUtils.copyDir(this.folder, toFolder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.javaCardXML != null) {
            try {
                this.javaCardXML.saveCanonicalizedTo(new File(toFolder, "META-INF/javacard.xml"));
            }
            catch (Exception e) {
                this.addError(ErrorKey.UnexpectedException, e.toString());
            }
        }
    }

    @Override
    public String getItemDisplayName() {
        return "Module[" + this.folder + "]";
    }

    public JavaCardXML getJavaCardXML() {
        return this.javaCardXML;
    }

    public ModuleJCRD getJCRD() {
        return this.jcrd;
    }
}

