/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Aid;
import com.sun.javacard.jcasm.Assert;

public class PackageIdentifier {
    protected int majorVersion;
    protected int minorVersion;
    protected Aid aid;
    protected short eca;

    public PackageIdentifier(Aid aid, int majorVersion, int minorVersion) {
        Assert.PreCondition(aid != null, "aid != null");
        Assert.PreCondition(majorVersion >= 0, "majorVersion >= 0");
        Assert.PreCondition(majorVersion <= 255, "majorVersion <= 255");
        Assert.PreCondition(minorVersion >= 0, "minorVersion >= 0");
        Assert.PreCondition(minorVersion <= 255, "minorVersion <= 255");
        this.aid = aid;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public Aid getAid() {
        return this.aid;
    }

    public void setECA(short addr) {
        this.eca = addr;
    }

    public short getECA() {
        return this.eca;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PackageIdentifier)) {
            return false;
        }
        return ((PackageIdentifier)obj).getAid().equals(this.aid) && ((PackageIdentifier)obj).majorVersion == this.majorVersion && ((PackageIdentifier)obj).minorVersion == this.minorVersion;
    }

    public int hashCode() {
        return this.aid.hashCode() + this.majorVersion + this.minorVersion;
    }

    public String toString() {
        return this.aid.toString() + " " + this.majorVersion + "." + this.minorVersion;
    }
}

