/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.Msg;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionTable {
    protected Vector<ExceptionTableEntry> entryVector;
    protected int relocAddr;
    protected boolean relocated;
    protected JCMethod parentMethod;

    ExceptionTable(JCMethod parent) {
        this.parentMethod = parent;
        this.entryVector = new Vector();
    }

    public void addExceptionEntry(ExceptionTableEntry entry) {
        this.entryVector.addElement(entry);
    }

    public Enumeration<ExceptionTableEntry> elements() {
        return this.entryVector.elements();
    }

    public int size() {
        return this.entryVector.size() * ExceptionTableEntry.size();
    }

    public int count() {
        return this.entryVector.size();
    }

    public void relocate(int address) {
        this.relocAddr = address;
        this.relocated = true;
    }

    public boolean isRelocated() {
        return this.relocated;
    }

    public int getRelocAddr() {
        assert (this.relocated) : "!relocated";
        return this.relocAddr;
    }

    protected void fixup(Hashtable<String, Integer> symbolTable) {
        if (this.entryVector.size() == 0) {
            return;
        }
        for (ExceptionTableEntry exe : this.entryVector) {
            exe.fixup(symbolTable);
        }
        for (int i = 0; i < this.entryVector.size(); ++i) {
            boolean base_is_outside = true;
            ExceptionTableEntry base_entry = this.entryVector.get(i);
            for (int j = i + 1; j < this.entryVector.size(); ++j) {
                ExceptionTableEntry following_entry = this.entryVector.get(j);
                if (following_entry.getStartOffset() > base_entry.getStartOffset() || following_entry.getStartOffset() + following_entry.getActiveLength() < base_entry.getStartOffset() + base_entry.getActiveLength()) continue;
                base_is_outside = false;
            }
            base_entry.isOuterMost = base_is_outside;
        }
    }

    public byte[] toByteArray() {
        byte[] array = new byte[this.size()];
        int offset = 0;
        for (ExceptionTableEntry exe : this.entryVector) {
            byte[] entry = exe.toByteArray();
            System.arraycopy(entry, 0, array, offset, entry.length);
            offset += entry.length;
        }
        return array;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(".exceptionTable {" + Msg.eol);
        for (ExceptionTableEntry exe : this.entryVector) {
            sb.append(exe.toString() + Msg.eol);
        }
        sb.append("}");
        return sb.toString();
    }
}

