/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.Statement;

public class InstrLookupSwitch {
    Instruction instr;
    public int dfl;
    public int ncases;
    public int[] keys;
    public int[] offsets;

    public InstrLookupSwitch(int pc, Instruction instr, Statement[] code) {
        this.instr = instr;
        this.setupInstruction(pc, code);
    }

    private void setupInstruction(int pc, Statement[] code) {
        this.dfl = this.getJumpInstructionOffset(pc, this.instr.operandVector.elementAt(0).getValue(), code);
        int opSize = this.instr.operandVector.size();
        int switchSize = (opSize - 2) / 2;
        this.offsets = new int[switchSize];
        int i = 2;
        int j = 0;
        while (i < opSize) {
            this.offsets[j] = this.getJumpInstructionOffset(pc, this.instr.operandVector.elementAt(i + 1).getValue(), code);
            i += 2;
            ++j;
        }
    }

    int getJumpInstructionOffset(int pc, int requiredJumpSize, Statement[] code) {
        int jumpSize = 0;
        while (jumpSize < requiredJumpSize) {
            jumpSize += code[pc].size();
            ++pc;
        }
        return pc;
    }
}

