/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcbytecodeprofiler.cryptoanalyzer;

import com.sun.javacard.jcasm.ClassRefInfo;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.InstrLookupSwitch;
import com.sun.javacard.jcasm.InstrTableSwitch;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.StaticMethodRefInfo;
import com.sun.javacard.jcbytecodeprofiler.CryptoAlgorithmInfo;
import com.sun.javacard.jcbytecodeprofiler.CryptoAlgorithmList;
import com.sun.javacard.jcbytecodeprofiler.cryptoanalyzer.State;
import com.sun.javacard.jcbytecodeprofiler.cryptoanalyzer.Type;
import com.sun.javacard.jcbytecodeprofiler.cryptoanalyzer.TypeArray;
import com.sun.javacard.jcbytecodeprofiler.cryptoanalyzer.TypeBase;
import com.sun.javacard.jcbytecodeprofiler.cryptoanalyzer.TypeClass;
import com.sun.javacard.jcbytecodeprofiler.cryptoanalyzer.TypeNull;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class CryptoCallAnalyzer {
    static final String WARNING_MSG_1 = "* Please verify usage of ";
    static final String WARNING_MSG_2 = " for more algorithms in ";
    static final String WARNING_MSG_3 = " at PC ";
    static final String WARNING_MSG_NON_VERBOSE_1 = "* Please verify ";
    static final String WARNING_MSG_NON_VERBOSE_2 = " algorithm use ";
    private static final int REGULAR_METHOD = 0;
    private static final int INIT_METHOD = 1;
    private static Type actualSelfType;
    private static int methodInitStatus;
    static boolean printTrace;
    private static Hashtable<State, State> seenStates;
    private static JCPackage currentPkg;
    private static Stack<State> pendingStates;
    private static Type[][] stackEffect;
    static JCClass currentClass;
    static JCMethod currentMethod;
    static boolean showVerbose;
    public static Vector<String> cryptoAlgoNames;
    public static boolean allCryptoAlgosFound;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void simulate(JCClass c, JCMethod m) {
        String value = System.getenv("JC_TRIMMING_TOOL_CRYPTO_VERBOSE");
        if (value != null) {
            showVerbose = value.equalsIgnoreCase("true");
        }
        cryptoAlgoNames.clear();
        allCryptoAlgosFound = true;
        currentClass = c;
        currentMethod = m;
        Vector<Statement> methodStatements = m.getStatements();
        currentPkg = m.getParentClass().getParentPackage();
        seenStates = new Hashtable(51);
        pendingStates = new Stack();
        Type[] initStack = new Type[m.stack];
        Type[] initLocal = new Type[m.locals + m.getParams()];
        int numStatements = methodStatements.size();
        Statement[] code = new Statement[numStatements];
        for (int i = 0; i < numStatements; ++i) {
            Statement stmt = methodStatements.elementAt(i);
            stmt.processForExceptionHandlers(m);
            code[i] = stmt;
        }
        m.setMethodLocals(initLocal);
        CryptoCallAnalyzer.enterState(0, initLocal, initStack, 0);
        methodInitStatus = m.isInit() ? 1 : 0;
        try {
            while (!pendingStates.empty()) {
                State s = pendingStates.pop();
                CryptoCallAnalyzer.transition(code, s);
            }
            Object var11_11 = null;
            seenStates = null;
            pendingStates = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            seenStates = null;
            pendingStates = null;
            throw throwable;
        }
    }

    static void transition(Statement[] code, State before) {
        Statement instr = code[before.pc];
        Type[] newStack = (Type[])before.stack.clone();
        Type[] newLocals = before.locals;
        int newSp = 0;
        switch (instr.getInstruction().getOpcode()) {
            case 16: 
            case 17: {
                TypeBase shortType = new TypeBase(4, instr.getInstruction().getOperand(0).getValue());
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, shortType);
                break;
            }
            case 20: {
                TypeBase intType = new TypeBase(5, instr.getInstruction().getOperand(0).getValue());
                TypeBase int2Type = new TypeBase(6, instr.getInstruction().getOperand(1).getValue());
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, intType);
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, int2Type);
                break;
            }
            case 92: {
                TypeBase shortType = (TypeBase)before.stack[before.sp - 1];
                newSp = before.sp - 1;
                int value = (Integer)shortType.value;
                TypeBase intType = new TypeBase(5, 0);
                TypeBase int2Type = new TypeBase(6, value);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, intType);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, int2Type);
                break;
            }
            case 94: {
                TypeBase intType = (TypeBase)before.stack[before.sp - 2];
                newSp = before.sp - 2;
                int value = (Integer)intType.value;
                TypeBase shortType = new TypeBase(4, value);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, intType);
                break;
            }
            case 21: {
                Type ty = before.locals[instr.getInstruction().getOperand(0).getValue()];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                break;
            }
            case 24: {
                Type ty = before.locals[0];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                break;
            }
            case 25: {
                Type ty = before.locals[1];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                break;
            }
            case 26: {
                Type ty = before.locals[2];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                break;
            }
            case 27: {
                Type ty = before.locals[3];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                break;
            }
            case 22: {
                Type ty = before.locals[instr.getInstruction().getOperand(0).getValue()];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                break;
            }
            case 28: {
                Type ty = before.locals[0];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                break;
            }
            case 29: {
                Type ty = before.locals[1];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                break;
            }
            case 30: {
                Type ty = before.locals[2];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                break;
            }
            case 31: {
                Type ty = before.locals[3];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                break;
            }
            case 23: {
                Type ty = before.locals[instr.getInstruction().getOperand(0).getValue()];
                Type ty2 = before.locals[instr.getInstruction().getOperand(0).getValue() + 1];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, ty2);
                break;
            }
            case 32: {
                Type ty = before.locals[0];
                Type ty2 = before.locals[1];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, ty2);
                break;
            }
            case 33: {
                Type ty = before.locals[1];
                Type ty2 = before.locals[2];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, ty2);
                break;
            }
            case 34: {
                Type ty = before.locals[2];
                Type ty2 = before.locals[3];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, ty2);
                break;
            }
            case 35: {
                Type ty = before.locals[3];
                Type ty2 = before.locals[4];
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, ty);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, ty2);
                break;
            }
            case 36: {
                Type[] stackEffectAaload = new Type[]{new TypeArray(new TypeClass(0)), Type.Short, null, null};
                newSp = CryptoCallAnalyzer.matchStack(stackEffectAaload, newStack, before.sp);
                Type ty = before.stack[before.sp - 2];
                if (ty instanceof TypeArray) {
                    ty = ((TypeArray)ty).eltType;
                } else if (ty instanceof TypeNull) {
                    ty = Type.Null;
                }
                newSp = CryptoCallAnalyzer.push(newStack, newSp, ty);
                break;
            }
            case 40: {
                Type ty = before.stack[before.sp - 1];
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, instr.getInstruction().getOperand(0).getValue(), ty);
                newSp = before.sp - 1;
                break;
            }
            case 43: {
                Type ty = before.stack[before.sp - 1];
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, 0, ty);
                newSp = before.sp - 1;
                break;
            }
            case 44: {
                Type ty = before.stack[before.sp - 1];
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, 1, ty);
                newSp = before.sp - 1;
                break;
            }
            case 45: {
                Type ty = before.stack[before.sp - 1];
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, 2, ty);
                newSp = before.sp - 1;
                break;
            }
            case 46: {
                Type ty = before.stack[before.sp - 1];
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, 3, ty);
                newSp = before.sp - 1;
                break;
            }
            case 41: {
                TypeBase shortType = (TypeBase)before.stack[before.sp - 1];
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, Type.Short);
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, instr.getInstruction().getOperand(0).getValue(), shortType);
                break;
            }
            case 47: {
                TypeBase shortType = (TypeBase)before.stack[before.sp - 1];
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, Type.Short);
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, 0, shortType);
                break;
            }
            case 48: {
                TypeBase shortType = (TypeBase)before.stack[before.sp - 1];
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, Type.Short);
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, 1, shortType);
                break;
            }
            case 49: {
                TypeBase shortType = (TypeBase)before.stack[before.sp - 1];
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, Type.Short);
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, 2, shortType);
                break;
            }
            case 50: {
                TypeBase shortType = (TypeBase)before.stack[before.sp - 1];
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, Type.Short);
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, 3, shortType);
                break;
            }
            case 42: {
                TypeBase intType = (TypeBase)before.stack[before.sp - 2];
                TypeBase int2Type = (TypeBase)before.stack[before.sp - 1];
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, Type.Int);
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, instr.getInstruction().getOperand(0).getValue(), intType, int2Type);
                break;
            }
            case 51: {
                TypeBase intType = (TypeBase)before.stack[before.sp - 2];
                TypeBase int2Type = (TypeBase)before.stack[before.sp - 1];
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, Type.Int);
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, 0, intType, int2Type);
                break;
            }
            case 52: {
                TypeBase intType = (TypeBase)before.stack[before.sp - 2];
                TypeBase int2Type = (TypeBase)before.stack[before.sp - 1];
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, Type.Int);
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, 1, intType, int2Type);
                break;
            }
            case 53: {
                TypeBase intType = (TypeBase)before.stack[before.sp - 2];
                TypeBase int2Type = (TypeBase)before.stack[before.sp - 1];
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, Type.Int);
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, 2, intType, int2Type);
                break;
            }
            case 54: {
                TypeBase intType = (TypeBase)before.stack[before.sp - 2];
                TypeBase int2Type = (TypeBase)before.stack[before.sp - 1];
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, Type.Int);
                newLocals = CryptoCallAnalyzer.updateLocals(before.locals, 3, intType, int2Type);
                break;
            }
            case 55: {
                Type[] stackEffectAastore = new Type[]{new TypeArray(new TypeClass(0)), Type.Short, new TypeClass(0), null, null};
                newSp = CryptoCallAnalyzer.matchStack(stackEffectAastore, newStack, before.sp);
                break;
            }
            case 59: {
                newSp = before.sp - 1;
                break;
            }
            case 60: {
                newSp = before.sp - 2;
                break;
            }
            case 61: {
                newStack[before.sp] = newStack[before.sp - 1];
                newSp = before.sp + 1;
                break;
            }
            case 62: {
                newStack[before.sp] = newStack[before.sp - 2];
                newStack[before.sp + 1] = newStack[before.sp - 1];
                newSp = before.sp + 2;
                break;
            }
            case 63: {
                int m = instr.getInstruction().getOperand(0).getValue();
                int n = instr.getInstruction().getOperand(1).getValue();
                System.arraycopy(before.stack, before.sp - n, newStack, before.sp - n + m, n);
                System.arraycopy(before.stack, before.sp - m, newStack, before.sp - n, m);
                newSp = before.sp + m;
                break;
            }
            case 64: {
                int m = instr.getInstruction().getOperand(0).getValue();
                int n = instr.getInstruction().getOperand(1).getValue();
                System.arraycopy(before.stack, before.sp - m, newStack, before.sp - m - n, m);
                System.arraycopy(before.stack, before.sp - m - n, newStack, before.sp - n, n);
                newSp = before.sp;
                break;
            }
            case 89: {
                Type ty;
                int value;
                TypeBase shortType = (TypeBase)before.locals[instr.getInstruction().getOperand(0).getValue()];
                if (shortType.value != null) {
                    value = (Integer)((TypeBase)before.locals[instr.getInstruction().getOperand((int)0).getValue()]).value;
                    TypeBase typeBase = new TypeBase(4, value += instr.getInstruction().getOperand(1).getValue());
                    before.locals[instr.getInstruction().getOperand((int)0).getValue()] = typeBase;
                    ty = typeBase;
                } else {
                    ty = before.locals[instr.getInstruction().getOperand(0).getValue()];
                }
                newSp = before.sp;
                break;
            }
            case 150: {
                Type ty;
                int value;
                TypeBase shortType = (TypeBase)before.locals[instr.getInstruction().getOperand(0).getValue()];
                if (shortType.value != null) {
                    value = (short)(instr.getInstruction().getOperand(1).getValue() << 8 | instr.getInstruction().getOperand(2).getValue());
                    TypeBase typeBase = new TypeBase(4, value += ((Integer)((TypeBase)before.locals[instr.getInstruction().getOperand((int)0).getValue()]).value).intValue());
                    before.locals[instr.getInstruction().getOperand((int)0).getValue()] = typeBase;
                    ty = typeBase;
                } else {
                    ty = before.locals[instr.getInstruction().getOperand(0).getValue()];
                }
                newSp = before.sp;
                break;
            }
            case 90: {
                int intValue = instr.getInstruction().getOperand(1).getValue();
                int value1 = (Integer)((TypeBase)before.locals[instr.getInstruction().getOperand((int)0).getValue()]).value;
                int value2 = (Integer)((TypeBase)before.locals[instr.getInstruction().getOperand((int)0).getValue() + 1]).value;
                TypeBase typeBase = new TypeBase(5, (intValue += value1 << 16 | value2) >> 16 & 0xFFFF);
                before.locals[instr.getInstruction().getOperand((int)0).getValue()] = typeBase;
                Type ty = typeBase;
                TypeBase typeBase2 = new TypeBase(5, intValue & 0xFFFF);
                before.locals[instr.getInstruction().getOperand((int)0).getValue() + 1] = typeBase2;
                Type ty2 = typeBase2;
                newSp = before.sp;
                break;
            }
            case 151: {
                int intValue = instr.getInstruction().getOperand(1).getValue() << 8 | instr.getInstruction().getOperand(2).getValue();
                int value1 = (Integer)((TypeBase)before.locals[instr.getInstruction().getOperand((int)0).getValue()]).value;
                int value2 = (Integer)((TypeBase)before.locals[instr.getInstruction().getOperand((int)0).getValue() + 1]).value;
                TypeBase typeBase = new TypeBase(5, (intValue += value1 << 16 | value2) >> 16 & 0xFFFF);
                before.locals[instr.getInstruction().getOperand((int)0).getValue()] = typeBase;
                Type ty = typeBase;
                TypeBase typeBase3 = new TypeBase(5, intValue & 0xFFFF);
                before.locals[instr.getInstruction().getOperand((int)0).getValue() + 1] = typeBase3;
                Type ty2 = typeBase3;
                newSp = before.sp;
                break;
            }
            case 119: {
                Type ty = before.stack[before.sp - 1];
                newSp = 0;
                break;
            }
            case 120: {
                Type ty = before.stack[before.sp - 1];
                newSp = 0;
                break;
            }
            case 121: {
                Type ty = before.stack[before.sp - 2];
                Type ty2 = before.stack[before.sp - 1];
                newSp = 0;
                break;
            }
            case 122: {
                newSp = 0;
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, CryptoCallAnalyzer.findCpoolReferenceFieldType(instr.getInstruction().getOperand(0).getValue()));
                break;
            }
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, CryptoCallAnalyzer.findCpoolReferenceFieldType(instr.getInstruction().getOperand(0).getValue()));
                break;
            }
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 169: 
            case 170: 
            case 171: 
            case 172: {
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, Type.Reference);
                newSp = CryptoCallAnalyzer.push(newStack, newSp, CryptoCallAnalyzer.findCpoolReferenceFieldType(instr.getInstruction().getOperand(0).getValue()));
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 177: 
            case 178: 
            case 179: 
            case 180: {
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, CryptoCallAnalyzer.findCpoolReferenceFieldType(instr.getInstruction().getOperand(0).getValue()));
                newSp = CryptoCallAnalyzer.popMatch(before.stack, newSp, Type.Reference);
                break;
            }
            case 139: {
                newSp = CryptoCallAnalyzer.popArgumentsAndPushResult(newStack, before.sp, CryptoCallAnalyzer.findCpoolReferenceMethod(instr.getInstruction().getOperand(0).getValue()));
                break;
            }
            case 140: {
                int initStatus = 0;
                JCMethod m = CryptoCallAnalyzer.findCpoolReferenceMethod(instr.getInstruction().getOperand(0).getValue());
                if (m.isInit()) {
                    initStatus = 1 + methodInitStatus;
                }
                newSp = CryptoCallAnalyzer.popArgumentsAndPushResult(newStack, before.sp, CryptoCallAnalyzer.findCpoolReferenceMethod(instr.getInstruction().getOperand(0).getValue()));
                if (initStatus == 0) break;
                newStack = CryptoCallAnalyzer.initializeInstance(newStack, newSp);
                newLocals = CryptoCallAnalyzer.initializeInstance(newLocals, newLocals.length);
                break;
            }
            case 141: {
                Operand op = instr.getInstruction().getOperands().elementAt(0);
                StaticMethodRefInfo calledMethodInfo = (StaticMethodRefInfo)op.resolve();
                Integer lookback = CryptoAlgorithmList.getBCLookBack(calledMethodInfo.getName());
                if (lookback != null) {
                    if (lookback < 0) {
                        boolean successful = CryptoCallAnalyzer.listFlexAlgorithms(before.sp, lookback, newStack);
                        if (!successful) {
                            allCryptoAlgosFound = false;
                        } else {
                            CryptoCallAnalyzer.constructAndAddWarningMessage(before.pc, code, calledMethodInfo);
                        }
                    } else {
                        Type typeOnStack = newStack[before.sp - lookback];
                        if (typeOnStack instanceof TypeBase) {
                            TypeBase valueType = (TypeBase)typeOnStack;
                            if (valueType.value != null) {
                                int theValue = (Integer)valueType.value;
                                CryptoCallAnalyzer.listCryptoAlgorithmUsed((JCMethod)calledMethodInfo.resolve(), theValue);
                                CryptoCallAnalyzer.constructAndAddWarningMessage(before.pc, code, calledMethodInfo);
                            } else {
                                allCryptoAlgosFound = false;
                            }
                        } else {
                            allCryptoAlgosFound = false;
                        }
                    }
                }
                newSp = CryptoCallAnalyzer.popArgumentsAndPushResult(newStack, before.sp, CryptoCallAnalyzer.findCpoolReferenceMethod(instr.getInstruction().getOperand(0).getValue()));
                break;
            }
            case 142: {
                ClassRefInfo cinfo = (ClassRefInfo)currentPkg.getConstantPool().getConstantPoolEntry(instr.getInstruction().getOperand(1).getValue());
                JCClass c = (JCClass)cinfo.resolve();
                JCMethod m = c.findMethodWithToken(instr.getInstruction().getOperand(2).getValue());
                newSp = CryptoCallAnalyzer.popArgumentsAndPushResult(newStack, before.sp, m);
                break;
            }
            case 143: {
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, Type.Reference);
                break;
            }
            case 144: {
                newSp = CryptoCallAnalyzer.popMatch(newStack, before.sp, Type.Short);
                Type tyElt = null;
                switch (instr.getInstruction().getOperand(0).getValue()) {
                    case 10: 
                    case 11: {
                        tyElt = Type.Byte;
                        break;
                    }
                    case 12: {
                        tyElt = Type.Short;
                        break;
                    }
                    case 13: {
                        tyElt = Type.Int;
                    }
                }
                newSp = CryptoCallAnalyzer.push(newStack, newSp, new TypeArray(tyElt));
                break;
            }
            case 145: {
                newSp = CryptoCallAnalyzer.popMatch(newStack, before.sp, Type.Short);
                TypeArray tyElt = new TypeArray(new TypeClass(0));
                newSp = CryptoCallAnalyzer.push(newStack, newSp, tyElt);
                break;
            }
            case 146: {
                newSp = before.sp - 1;
                Type ty = before.stack[newSp];
                newSp = CryptoCallAnalyzer.push(newStack, newSp, Type.Short);
                break;
            }
            case 148: {
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, new TypeClass(0));
                Type tyRes = null;
                switch (instr.getInstruction().getOperand(0).getValue()) {
                    case 0: {
                        tyRes = new TypeClass(0);
                        break;
                    }
                    case 10: 
                    case 11: {
                        tyRes = new TypeArray(Type.Byte);
                        break;
                    }
                    case 12: {
                        tyRes = new TypeArray(Type.Short);
                        break;
                    }
                    case 13: {
                        tyRes = new TypeArray(Type.Int);
                        break;
                    }
                    case 14: {
                        tyRes = new TypeArray(new TypeClass(0));
                    }
                }
                newSp = CryptoCallAnalyzer.push(newStack, newSp, tyRes);
                break;
            }
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                newSp = CryptoCallAnalyzer.push(newStack, before.sp, CryptoCallAnalyzer.findCpoolReferenceFieldType(instr.getInstruction().getOperand(0).getValue()));
                break;
            }
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                newSp = CryptoCallAnalyzer.popMatch(before.stack, before.sp, CryptoCallAnalyzer.findCpoolReferenceFieldType(instr.getInstruction().getOperand(0).getValue()));
                break;
            }
            default: {
                newSp = CryptoCallAnalyzer.matchStack(stackEffect[instr.getInstruction().getOpcode()], newStack, before.sp);
            }
        }
        switch (instr.getInstruction().getOpcode()) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: {
                CryptoCallAnalyzer.enterState(before.pc + 1, newLocals, newStack, newSp);
                CryptoCallAnalyzer.enterState(CryptoCallAnalyzer.getJumpInstructionOffset(before.pc, instr.getInstruction().getOperand(0).getValue(), code), newLocals, newStack, newSp);
                break;
            }
            case 112: 
            case 168: {
                CryptoCallAnalyzer.enterState(CryptoCallAnalyzer.getJumpInstructionOffset(before.pc, instr.getInstruction().getOperand(0).getValue(), code), newLocals, newStack, newSp);
                break;
            }
            case 115: 
            case 116: {
                InstrTableSwitch ts = new InstrTableSwitch(before.pc, instr.getInstruction(), code);
                for (int element : ts.offsets) {
                    CryptoCallAnalyzer.enterState(element, newLocals, newStack, newSp);
                }
                CryptoCallAnalyzer.enterState(ts.dfl, newLocals, newStack, newSp);
                break;
            }
            case 117: 
            case 118: {
                InstrLookupSwitch ls = new InstrLookupSwitch(before.pc, instr.getInstruction(), code);
                for (int element : ls.offsets) {
                    CryptoCallAnalyzer.enterState(element, newLocals, newStack, newSp);
                }
                CryptoCallAnalyzer.enterState(ls.dfl, newLocals, newStack, newSp);
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 147: {
                break;
            }
            default: {
                CryptoCallAnalyzer.enterState(before.pc + 1, newLocals, newStack, newSp);
            }
        }
        for (ExceptionTableEntry e : instr.getExceptionHandlers()) {
            Type[] exnStack = new Type[before.stack.length];
            CryptoCallAnalyzer.push(exnStack, 0, e.catchType);
            CryptoCallAnalyzer.enterState(CryptoCallAnalyzer.getJumpInstructionOffset(0, e.catchOffset, code), newLocals, exnStack, 1);
        }
    }

    private static int matchStack(Type[] effect, Type[] stack, int sp) {
        int i = 0;
        int nargs = 0;
        while (effect[i] != null) {
            ++nargs;
            ++i;
        }
        sp -= nargs;
        ++i;
        while (effect[i] != null) {
            stack[sp] = effect[i];
            ++sp;
            ++i;
        }
        return sp;
    }

    private static int push(Type[] stack, int sp, Type ty) {
        stack[sp] = ty;
        if (ty == Type.Int) {
            return CryptoCallAnalyzer.push(stack, sp + 1, Type.Int2);
        }
        return sp + 1;
    }

    private static int popMatch(Type[] stack, int sp, Type ty) {
        if (ty == Type.Int) {
            sp = CryptoCallAnalyzer.popMatch(stack, sp, Type.Int2);
        }
        return sp - 1;
    }

    private static int popArgumentsAndPushResult(Type[] stack, int sp, JCMethod m) {
        int numArgs = m.getParams();
        sp -= numArgs;
        Type returnType = m.getMethodReturnType();
        if (returnType != Type.Void) {
            sp = CryptoCallAnalyzer.push(stack, sp, returnType);
        }
        return sp;
    }

    private static Type[] initializeInstance(Type[] ty, int n) {
        actualSelfType = new TypeClass(0);
        Type[] newty = (Type[])ty.clone();
        TypeClass initialized = new TypeClass(0);
        for (int i = 0; i < n; ++i) {
            if (!actualSelfType.equals(newty[i])) continue;
            newty[i] = initialized;
        }
        return newty;
    }

    private static Type[] updateLocals(Type[] oldLocals, int idx, Type ty) {
        Type[] newLocals = (Type[])oldLocals.clone();
        newLocals[idx] = ty;
        return newLocals;
    }

    private static Type[] updateLocals(Type[] oldLocals, int idx, Type ty1, Type ty2) {
        Type[] newLocals = (Type[])oldLocals.clone();
        newLocals[idx] = ty1;
        newLocals[idx + 1] = ty2;
        return newLocals;
    }

    private static Type findCpoolReferenceFieldType(int idx) {
        Field f = (Field)currentPkg.getConstantPool().getConstantPoolEntry(idx).resolve();
        FieldDescriptor fd = f.getDescriptor();
        if (fd.isPrimitive()) {
            String desc = fd.getDescriptorString();
            if (desc.equals("I")) {
                return Type.Int;
            }
            if (desc.equals("S")) {
                return Type.Short;
            }
            if (desc.equals("B")) {
                return Type.Byte;
            }
            if (desc.equals("Z")) {
                return Type.Boolean;
            }
        }
        return Type.Reference;
    }

    private static JCMethod findCpoolReferenceMethod(int idx) {
        JCMethod m = (JCMethod)currentPkg.getConstantPool().getConstantPoolEntry(idx).resolve();
        return m;
    }

    private static int getJumpInstructionOffset(int pc, int requiredJumpSize, Statement[] code) {
        int jumpSize = 0;
        while (jumpSize < requiredJumpSize) {
            jumpSize += code[pc].size();
            ++pc;
        }
        return pc;
    }

    private static int getPCForInstructionOffset(int instructionOffset, Statement[] code) {
        int pc = 0;
        for (int i = 0; i < instructionOffset; ++i) {
            pc += code[i].size();
        }
        return pc;
    }

    private static void enterState(int pc, Type[] locals, Type[] stack, int sp) {
        Type mergedty;
        Type newty;
        Type oldty;
        int i;
        boolean cloneCreated = false;
        State newstate = new State(pc, locals, stack, sp);
        State oldstate = seenStates.get(newstate);
        if (oldstate == null) {
            seenStates.put(newstate, newstate);
            pendingStates.push(newstate);
            return;
        }
        boolean unchanged = true;
        for (i = 0; i < oldstate.locals.length; ++i) {
            oldty = oldstate.locals[i];
            newty = newstate.locals[i];
            if (oldty == null) continue;
            Type type = mergedty = newty != null ? oldty.lub(newty) : null;
            if (mergedty != null && mergedty instanceof TypeBase) {
                ((TypeBase)mergedty).value = ((TypeBase)oldty).value;
            }
            if (!cloneCreated && (newty == null && mergedty != null || newty == null || !newty.equals(mergedty))) {
                newstate.locals = (Type[])newstate.locals.clone();
                cloneCreated = true;
            }
            newstate.locals[i] = mergedty;
            unchanged = unchanged && oldty.equals(mergedty);
        }
        cloneCreated = false;
        for (i = 0; i < oldstate.sp; ++i) {
            oldty = oldstate.stack[i];
            newty = newstate.stack[i];
            mergedty = oldty.lub(newty);
            if (mergedty != null && mergedty instanceof TypeBase) {
                ((TypeBase)mergedty).value = ((TypeBase)oldty).value;
            }
            if (!cloneCreated && !mergedty.equals(newty)) {
                newstate.stack = (Type[])newstate.stack.clone();
                cloneCreated = true;
            }
            newstate.stack[i] = mergedty;
            unchanged = unchanged && oldty.equals(mergedty);
        }
        if (!unchanged) {
            pendingStates.push(newstate);
        }
    }

    static void constructAndAddWarningMessage(int instructionOffset, Statement[] code, StaticMethodRefInfo calledMethodInfo) {
        String msg = null;
        if (showVerbose) {
            int pc = CryptoCallAnalyzer.getPCForInstructionOffset(instructionOffset, code);
            msg = WARNING_MSG_1 + calledMethodInfo.getName() + WARNING_MSG_2 + currentMethod.getName() + WARNING_MSG_3 + pc;
        } else {
            String methodName = calledMethodInfo.getName();
            int index = methodName.indexOf(40);
            methodName = methodName.substring(0, index).replace('/', '.');
            String className = methodName.substring(0, methodName.lastIndexOf(46));
            msg = WARNING_MSG_NON_VERBOSE_1 + className + WARNING_MSG_NON_VERBOSE_2;
        }
        if (!cryptoAlgoNames.contains(msg)) {
            cryptoAlgoNames.add(msg);
        }
    }

    static void listCryptoAlgorithmUsed(JCMethod m, int value) {
        int lastDot;
        String fullCryptoClassName = m.getParentClass().getName().replace('/', '.');
        String name = fullCryptoClassName.substring((lastDot = fullCryptoClassName.lastIndexOf(".")) + 1) + "." + CryptoAlgorithmList.getAlgoName(value, fullCryptoClassName);
        if (!cryptoAlgoNames.contains(name)) {
            cryptoAlgoNames.add(name);
        }
    }

    static boolean listFlexAlgorithms(int sp, int id, Type[] newStack) {
        switch (id) {
            case -1: {
                return CryptoCallAnalyzer.listFlexKeyBuilderAlgorithms(newStack, sp);
            }
            case -2: {
                return CryptoCallAnalyzer.listFlexSignatureAlgorithms(newStack, sp);
            }
            case -3: {
                return CryptoCallAnalyzer.listFlexCipherAlgorithms(newStack, sp);
            }
        }
        return false;
    }

    static int getValueFromStack(Type[] newStack, int sp, int offset) {
        Type typeOnStack = newStack[sp - offset];
        int theValue = -1;
        if (typeOnStack instanceof TypeBase) {
            TypeBase valueType = (TypeBase)typeOnStack;
            if (valueType.value != null) {
                theValue = (Integer)valueType.value;
            } else {
                allCryptoAlgosFound = false;
            }
        } else {
            allCryptoAlgosFound = false;
        }
        return theValue;
    }

    static boolean listFlexKeyBuilderAlgorithms(Type[] newStack, int sp) {
        int cipherAlgorithmValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 3);
        int memValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 2);
        int lengthValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 1);
        if (cipherAlgorithmValue == -1 || memValue == -1 || lengthValue == -1) {
            return false;
        }
        String algoName = CryptoAlgorithmList.getAlgoName(cipherAlgorithmValue, "javacard.security.KeyBuilder", CryptoAlgorithmInfo.TYPE_FLEX_CIPHER_ALG);
        String memType = CryptoAlgorithmList.getAlgoName(memValue, "javacard.security.KeyBuilder", CryptoAlgorithmInfo.TYPE_FLEX_MEM);
        String length = CryptoAlgorithmList.getAlgoName(lengthValue, "javacard.security.KeyBuilder", CryptoAlgorithmInfo.TYPE_FLEX_KEY_LENGTH);
        if (algoName == null || memType == null || length == null) {
            return false;
        }
        String fullName = algoName + ", " + memType + "," + length;
        if (!cryptoAlgoNames.contains(fullName)) {
            cryptoAlgoNames.add(fullName);
        }
        return true;
    }

    static boolean listFlexSignatureAlgorithms(Type[] newStack, int sp) {
        int MDAlgorithmValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 4);
        int cipherAlgorithmValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 3);
        int padAlgValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 2);
        if (cipherAlgorithmValue == -1 || MDAlgorithmValue == -1 || padAlgValue == -1) {
            return false;
        }
        String MDAlgoName = CryptoAlgorithmList.getAlgoName(MDAlgorithmValue, "javacard.security.MessageDigest", CryptoAlgorithmInfo.TYPE_NON_FLEX);
        String cipherAlgoName = CryptoAlgorithmList.getAlgoName(cipherAlgorithmValue, "javacard.security.Signature", CryptoAlgorithmInfo.TYPE_FLEX_CIPHER_ALG);
        String padAlgoName = CryptoAlgorithmList.getAlgoName(padAlgValue, "javacardx.crypto.Cipher", CryptoAlgorithmInfo.TYPE_FLEX_PAD_ALG);
        if (padAlgoName == null || cipherAlgoName == null || MDAlgoName == null) {
            return false;
        }
        String fullName = MDAlgoName + ", " + cipherAlgoName + "," + padAlgoName;
        if (!cryptoAlgoNames.contains(fullName)) {
            cryptoAlgoNames.add(fullName);
        }
        return true;
    }

    static boolean listFlexCipherAlgorithms(Type[] newStack, int sp) {
        int cipherAlgorithmValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 3);
        int padAlgValue = CryptoCallAnalyzer.getValueFromStack(newStack, sp, 2);
        if (cipherAlgorithmValue == -1 || padAlgValue == -1) {
            return false;
        }
        String cipherAlgoName = CryptoAlgorithmList.getAlgoName(cipherAlgorithmValue, "javacardx.crypto.Cipher", CryptoAlgorithmInfo.TYPE_FLEX_CIPHER_ALG);
        String paddingAlgoName = CryptoAlgorithmList.getAlgoName(padAlgValue, "javacardx.crypto.Cipher", CryptoAlgorithmInfo.TYPE_FLEX_PAD_ALG);
        if (cipherAlgoName == null || paddingAlgoName == null) {
            return false;
        }
        String fullName = cipherAlgoName + ", " + paddingAlgoName;
        if (!cryptoAlgoNames.contains(fullName)) {
            cryptoAlgoNames.add(fullName);
        }
        return true;
    }

    static {
        printTrace = false;
        Type[][] se = new Type[][]{{null, null}, {null, Type.Null, null}, {null, new TypeBase(4, -1), null}, {null, new TypeBase(4, 0), null}, {null, new TypeBase(4, 1), null}, {null, new TypeBase(4, 2), null}, {null, new TypeBase(4, 3), null}, {null, new TypeBase(4, 4), null}, {null, new TypeBase(4, 5), null}, {null, new TypeBase(5, -1), new TypeBase(6, -1), null}, {null, new TypeBase(5, 0), new TypeBase(6, 0), null}, {null, new TypeBase(5, 0), new TypeBase(6, 1), null}, {null, new TypeBase(5, 0), new TypeBase(6, 2), null}, {null, new TypeBase(5, 0), new TypeBase(6, 3), null}, {null, new TypeBase(5, 0), new TypeBase(6, 4), null}, {null, new TypeBase(5, 0), new TypeBase(6, 5), null}, {null, Type.Short, null}, {null, Type.Short, null}, {null, Type.Int, Type.Int2, null}, {null, Type.Int, Type.Int2, null}, {null, Type.Int, Type.Int2, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {Type.ByteArray, Type.Short, null, Type.Short, null}, {Type.ShortArray, Type.Short, null, Type.Short, null}, {Type.IntArray, Type.Short, null, Type.Int, Type.Int2, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {Type.ByteArray, Type.Short, Type.Short, null, null}, {Type.ShortArray, Type.Short, Type.Short, null, null}, {Type.IntArray, Type.Short, Type.Int, Type.Int2, null, null}, null, null, null, null, null, null, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, null, null, {Type.Short, null, Type.Short, null}, {Type.Short, null, Type.Int, Type.Int2, null}, {Type.Int, Type.Int2, null, Type.Short, null}, {Type.Int, Type.Int2, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Short, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {new TypeClass(0), null, null}, {new TypeClass(0), null, null}, {new TypeClass(0), new TypeClass(0), null, null}, {new TypeClass(0), new TypeClass(0), null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {null, null}, null, null, {Type.Short, null, null}, {Type.Int, Type.Int2, null, null}, {Type.Short, null, null}, {Type.Int, Type.Int2, null, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {new TypeClass(1), null, null}, null, {new TypeClass(0), null, Type.Short, null}, null, null, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {new TypeClass(0), null, null}, {new TypeClass(0), null, null}, {new TypeClass(0), new TypeClass(0), null, null}, {new TypeClass(0), new TypeClass(0), null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {null, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        stackEffect = se;
        showVerbose = false;
        cryptoAlgoNames = new Vector();
        allCryptoAlgosFound = true;
    }
}

