/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.util;

import com.sun.javacard.converter.util.DataType;

public class MethodDescriptor {
    public static int getParamSize(String descriptor) {
        int[] param_type_list = MethodDescriptor.getParamTypes(descriptor);
        if (param_type_list == null) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < param_type_list.length; ++i) {
            if (param_type_list[i] == 3) {
                size += 2;
                continue;
            }
            ++size;
        }
        return size;
    }

    public static int[] getParamTypes(String descriptor) {
        String[] param_descs = MethodDescriptor.getParamDescriptors(descriptor);
        int[] param_types = new int[param_descs.length];
        for (int i = 0; i < param_types.length; ++i) {
            param_types[i] = DataType.getType(param_descs[i]);
        }
        return param_types;
    }

    public static String[] getParamDescriptors(String descriptor) {
        if (descriptor == null) {
            throw new ClassFormatError();
        }
        if (!descriptor.startsWith("(")) {
            throw new ClassFormatError();
        }
        int index = 1;
        String[] param_descs = new String[descriptor.length()];
        int num_params = 0;
        while (index != descriptor.length() && descriptor.charAt(index) != ')') {
            int prev_index = index;
            if (descriptor.charAt(index) == 'L') {
                index = descriptor.indexOf(";", index) + 1;
            } else if (descriptor.charAt(index) == '[') {
                while (descriptor.charAt(index) == '[') {
                    ++index;
                }
                index = descriptor.charAt(index) == 'L' ? descriptor.indexOf(";", index) + 1 : ++index;
            } else {
                ++index;
            }
            String a_param = descriptor.substring(prev_index, index);
            param_descs[num_params++] = a_param;
        }
        if (index == descriptor.length()) {
            throw new ClassFormatError();
        }
        String[] actual_param_descs = new String[num_params];
        System.arraycopy(param_descs, 0, actual_param_descs, 0, num_params);
        return actual_param_descs;
    }

    public static int getReturnType(String descriptor) {
        int index = descriptor.lastIndexOf(")");
        String return_type = descriptor.substring(++index);
        return DataType.getType(return_type);
    }

    public static String getReturnDescriptor(String descriptor) {
        int index = descriptor.lastIndexOf(")");
        String return_string = descriptor.substring(++index);
        return return_string;
    }
}

