/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.jcwde.Globals;
import com.sun.javacard.jcwde.MaskedApplets;
import com.sun.javacard.jcwde.SimAPDU;
import com.sun.javacard.jcwde.SimulationException;
import java.text.MessageFormat;
import javacard.framework.JCWDEDispatcher;

public class Main
implements Runnable {
    int port;
    String configFile;
    static boolean nobanner;
    static boolean verbose;

    public Main(int port, String configFile) {
        this.port = port;
        this.configFile = configFile;
        Main.banner();
        SimAPDU.port = port;
        Object[] msg1Args = new Object[]{new Integer(port)};
        System.out.println(MessageFormat.format(Globals._messages.getString("main.listening"), msg1Args));
        MaskedApplets.readConfigFile(configFile);
    }

    private static void banner() {
        if (nobanner) {
            return;
        }
        Object[] args = new Object[]{new Integer(0), new Integer(18)};
        String banner = MessageFormat.format(Globals._messages.getString("main.banner1"), args);
        System.out.println(banner);
        System.out.println(Globals._messages.getString("main.banner2"));
    }

    public static void main(String[] argv) {
        Main jcwde = null;
        String configFileParam = null;
        int port = 9025;
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-p")) {
                try {
                    port = Integer.parseInt(argv[++i]);
                }
                catch (NumberFormatException numberFormatException) {
                    Main.usage(true);
                    System.exit(1);
                }
            } else if (argv[i].equals("-help")) {
                Main.usage(false);
                System.exit(0);
            } else if (argv[i].equals("-nobanner")) {
                nobanner = true;
            } else if (argv[i].equals("-version")) {
                Main.banner();
                System.exit(0);
            } else if (argv[i].equals("-verbose")) {
                verbose = true;
            } else if (i + 1 == argv.length) {
                configFileParam = argv[i];
            } else {
                Main.usage(true);
                System.exit(1);
            }
            ++i;
        }
        if (configFileParam == null) {
            Main.usage(true);
            System.exit(1);
        }
        try {
            jcwde = new Main(port, configFileParam);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        try {
            jcwde.run();
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            System.exit(1);
        }
    }

    public void run() {
        try {
            JCWDEDispatcher.main();
        }
        catch (SimulationException e) {
            System.err.println(Globals._messages.getString("Exception"));
            throw e;
        }
        System.err.println(Globals._messages.getString("DispatcherTerminated"));
    }

    private static void usage(boolean isError) {
        if (isError) {
            System.err.println(Globals._messages.getString("main.usage"));
        } else {
            System.out.println(Globals._messages.getString("main.usage"));
        }
    }
}

