/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.constants;

import com.sun.javacard.classfile.constants.JConstant;
import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.constants.JConstantUtf8;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class JConstantNameAndType
extends JConstant {
    private int name_index;
    private int descriptor_index;
    private String name;
    private String descriptor;

    public JConstantNameAndType(JConstantPool cp) {
        super(cp);
    }

    public void dump(PrintWriter w) {
        w.println("JConstantNameAndType  " + this.name_index + "," + this.descriptor_index + " " + this.cp.getConstantUtf8(this.name_index).getString() + " " + this.cp.getConstantUtf8(this.descriptor_index).getString());
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public int getDescriptorIndex() {
        return this.descriptor_index;
    }

    public String getName() {
        return this.name;
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public void parse(DataInputStream dis) throws IOException {
        this.name_index = dis.readUnsignedShort();
        this.descriptor_index = dis.readUnsignedShort();
    }

    public void resolve() {
        if (this.resolved) {
            return;
        }
        JConstantUtf8 constant = this.cp.getConstantUtf8(this.name_index);
        if (!constant.resolved) {
            constant.resolve();
        }
        this.name = constant.getString();
        constant = this.cp.getConstantUtf8(this.descriptor_index);
        if (!constant.resolved) {
            constant.resolve();
        }
        this.descriptor = constant.getString();
        this.resolved = true;
    }
}

