/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.classfile.instructions.JInstrByteValue;
import com.sun.javacard.classfile.instructions.JInstrCpByteRef;
import com.sun.javacard.classfile.instructions.JInstrCpShortRef;
import com.sun.javacard.classfile.instructions.JInstrFieldRef;
import com.sun.javacard.classfile.instructions.JInstrShortValue;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.ClinitStackEntry;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import java.util.Stack;

public class ClinitConverter {
    private JMethod clinit_method;
    private JcClass jc_class;
    private Stack operand_stack;

    public ClinitConverter(JMethod clinit_method, JcClass jc_class) {
        this.clinit_method = clinit_method;
        this.jc_class = jc_class;
        this.operand_stack = new Stack();
    }

    public void convert() {
        JInstruction java_instr = this.clinit_method.getCode();
        while (java_instr != null) {
            int java_opcode = java_instr.getOpcode();
            switch (java_opcode) {
                case 1: {
                    this.operand_stack.push(new ClinitStackEntry(10, 0));
                    break;
                }
                case 2: {
                    this.operand_stack.push(new ClinitStackEntry(3, -1));
                    break;
                }
                case 3: {
                    this.operand_stack.push(new ClinitStackEntry(3, 0));
                    break;
                }
                case 4: {
                    this.operand_stack.push(new ClinitStackEntry(3, 1));
                    break;
                }
                case 5: {
                    this.operand_stack.push(new ClinitStackEntry(3, 2));
                    break;
                }
                case 6: {
                    this.operand_stack.push(new ClinitStackEntry(3, 3));
                    break;
                }
                case 7: {
                    this.operand_stack.push(new ClinitStackEntry(3, 4));
                    break;
                }
                case 8: {
                    this.operand_stack.push(new ClinitStackEntry(3, 5));
                    break;
                }
                case 16: {
                    this.operand_stack.push(new ClinitStackEntry(3, ((JInstrByteValue)java_instr).getValue()));
                    break;
                }
                case 17: {
                    this.operand_stack.push(new ClinitStackEntry(3, ((JInstrShortValue)java_instr).getValue()));
                    break;
                }
                case 18: {
                    this.operand_stack.push(new ClinitStackEntry(3, ((JInstrCpByteRef)java_instr).getIntValue()));
                    break;
                }
                case 19: {
                    this.operand_stack.push(new ClinitStackEntry(3, ((JInstrCpShortRef)java_instr).getIntValue()));
                    break;
                }
                case 188: {
                    ClinitStackEntry count = (ClinitStackEntry)this.operand_stack.pop();
                    if (DataType.getType(count.getIntValue()) == 3) {
                        Notifier.error(java_instr.getSourceLineNumber(), "int.20", this.jc_class.getClassName().replace('/', '.'));
                    }
                    int atype = ((JInstrByteIndex)java_instr).getIndex();
                    int[] array_value = new int[count.getIntValue()];
                    this.operand_stack.push(new ClinitStackEntry(10, atype, array_value));
                    break;
                }
                case 89: {
                    Object entry = this.operand_stack.pop();
                    this.operand_stack.push(entry);
                    this.operand_stack.push(entry);
                    break;
                }
                case 79: 
                case 84: 
                case 86: {
                    int value = ((ClinitStackEntry)this.operand_stack.pop()).getIntValue();
                    int index = ((ClinitStackEntry)this.operand_stack.pop()).getIntValue();
                    int[] array_value = ((ClinitStackEntry)this.operand_stack.pop()).getArrayValue();
                    array_value[index] = value;
                    break;
                }
                case 179: {
                    JInstrFieldRef field_ref = (JInstrFieldRef)java_instr;
                    String class_name = field_ref.getClassName();
                    String field_name = field_ref.getFieldName();
                    String descriptor = field_ref.getDescriptor();
                    JcField[] jc_fields = this.jc_class.getFields();
                    int i = 0;
                    while (i < jc_fields.length) {
                        JcField jc_field = jc_fields[i];
                        if (jc_field.getFieldName().equals(field_name)) {
                            ClinitStackEntry value_entry = (ClinitStackEntry)this.operand_stack.pop();
                            int[] values = null;
                            if (DataType.getType(descriptor) == 10) {
                                values = value_entry.getArrayValue();
                            } else if (value_entry.getIntValue() != 0) {
                                values = new int[]{value_entry.getIntValue()};
                            }
                            jc_field.setValue(values);
                            break;
                        }
                        ++i;
                    }
                    if (i != jc_fields.length) break;
                    throw new ConverterInternalError();
                }
                default: {
                    throw new ConverterInternalError();
                }
                case 177: 
            }
            java_instr = java_instr.getNextInstr();
        }
    }
}

