/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.instructions.JInstrFieldRef;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.constants.JcConstantInstanceFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.constants.JcConstantStaticFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstrByteValue;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstrIntValue;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstrShortValue;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;

class InstrFieldRefConverter
extends InstructionConverter {
    private int[][] bc_conversion_table = new int[][]{{180, 169, 170, 172, 171}, {181, 177, 178, 180, 179}, {178, 123, 124, 126, 125}, {179, 127, 128, 130, 129}};
    private static final byte TYPE_REFERENCE = 1;
    private static final byte TYPE_BYTE = 2;
    private static final byte TYPE_INT = 3;
    private static final byte TYPE_SHORT = 4;

    public InstrFieldRefConverter(InstrContainer instr_container, MethodConverter method_converter) {
        super(instr_container, method_converter);
    }

    private void checkTypeCompatibility(int field_type) {
        OperandStackEntry stack_entry = this.operand_stack.peek(1);
        if (field_type == 3 && stack_entry.getType() != 3) {
            stack_entry.rollBack();
        }
    }

    public JcInstruction convert() throws Exception {
        JInstrFieldRef field_instr = (JInstrFieldRef)this.java_instr;
        int java_opcode = field_instr.getOpcode();
        String class_name = field_instr.getClassName();
        String field_name = field_instr.getFieldName();
        String descriptor = field_instr.getDescriptor();
        int field_type = DataType.getType(descriptor);
        switch (java_opcode) {
            case 181: {
                this.checkTypeCompatibility(field_type);
                this.operand_stack.pop();
                this.operand_stack.pop();
                int jc_opcode = this.determineJcOpcode(java_opcode, field_type, class_name, field_name);
                JcConstantPool jc_cp = this.method_converter.getJcConstantPool();
                JcConstantInstanceFieldRef fieldref = jc_cp.addConstantInstanceFieldRef(class_name, field_name, descriptor);
                this.jc_instr = new JcInstrFieldRef(jc_opcode, fieldref);
                ((JcInstrFieldRef)this.jc_instr).setWideInstr(true);
                return this.jc_instr;
            }
            case 180: {
                this.operand_stack.pop();
                int jc_opcode = this.determineJcOpcode(java_opcode, field_type, class_name, field_name);
                JcConstantPool jc_cp = this.method_converter.getJcConstantPool();
                JcConstantInstanceFieldRef fieldref = jc_cp.addConstantInstanceFieldRef(class_name, field_name, descriptor);
                this.jc_instr = new JcInstrFieldRef(jc_opcode, fieldref);
                ((JcInstrFieldRef)this.jc_instr).setWideInstr(true);
                this.operand_stack.push(field_type, this.instr_container);
                return this.jc_instr;
            }
            case 179: {
                this.checkTypeCompatibility(field_type);
                this.operand_stack.pop();
                int jc_opcode = this.determineJcOpcode(java_opcode, field_type, class_name, field_name);
                JcConstantPool jc_cp = this.method_converter.getJcConstantPool();
                JcConstantStaticFieldRef fieldref = jc_cp.addConstantStaticFieldRef(class_name, field_name, descriptor);
                this.jc_instr = new JcInstrFieldRef(jc_opcode, fieldref);
                return this.jc_instr;
            }
            case 178: {
                if (this.determineInLine(class_name, field_name, descriptor)) {
                    return this.jc_instr;
                }
                int jc_opcode = this.determineJcOpcode(java_opcode, field_type, class_name, field_name);
                JcConstantPool jc_cp = this.method_converter.getJcConstantPool();
                JcConstantStaticFieldRef fieldref = jc_cp.addConstantStaticFieldRef(class_name, field_name, descriptor);
                this.jc_instr = new JcInstrFieldRef(jc_opcode, fieldref);
                this.operand_stack.push(field_type, this.instr_container);
                return this.jc_instr;
            }
        }
        throw new ConverterInternalError();
    }

    private boolean determineInLine(String field_class_name, String field_name, String descriptor) throws Exception {
        if (DataType.getType(descriptor) == 10) {
            return false;
        }
        String current_class = this.method_converter.getClassName();
        if (Names.getPackageName(current_class).equals(Names.getPackageName(field_class_name))) {
            JClassFile[] java_classes = this.method_converter.getPackageConverter().getJavaPackage().getClasses();
            int i = 0;
            while (i < java_classes.length) {
                if (java_classes[i].getClassName().equals(field_class_name)) {
                    JField[] java_fields = java_classes[i].getFields();
                    int j = 0;
                    while (j < java_fields.length) {
                        if (java_fields[j].getFieldName().equals(field_name)) {
                            int access_flags = java_fields[j].getAccessFlags();
                            if (Modifier.isFinal(access_flags)) {
                                int value = java_fields[j].getValue()[0];
                                this.loadConstant(field_class_name, field_name, descriptor, value);
                                return true;
                            }
                            return false;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            Object[] args = new Object[]{this.method_converter.getClassName().replace('/', '.'), field_name, field_class_name.replace('/', '.')};
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.13", args);
            throw new ConversionException();
        }
        ExportFileManager ef_manager = this.method_converter.getPackageConverter().getExportFileManager();
        EfField ef_field = ef_manager.getField(field_class_name, field_name, descriptor);
        if (ef_field == null) {
            Object[] args = new Object[]{this.method_converter.getClassName().replace('/', '.'), field_name, field_class_name.replace('/', '.'), Names.getExportFileName(Names.getPackageName(field_class_name))};
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.12", args);
            throw new ConversionException();
        }
        int access_flags = ef_field.getAccessFlags();
        if (Modifier.isFinal(access_flags)) {
            int value = ef_field.getValue()[0];
            this.loadConstant(field_class_name, field_name, descriptor, value);
            return true;
        }
        return false;
    }

    private int determineJcOpcode(int java_opcode, int field_type, String class_name, String field_name) throws Exception {
        if (field_type == 3) {
            if (this.method_converter.isIntSupported()) {
                Object[] args = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(String.valueOf(class_name.replace('/', '.')) + "." + field_name)};
                Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.1", args);
                this.method_converter.getPackageConverter().setIntFlag(true);
            } else {
                Object[] args = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(String.valueOf(class_name.replace('/', '.')) + "." + field_name)};
                Notifier.error(this.java_instr.getSourceLineNumber(), "int.1", args);
                throw new ConversionException();
            }
        }
        int type = 0;
        switch (field_type) {
            case 10: {
                type = 1;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 2: {
                type = 4;
                break;
            }
            case 3: {
                type = 3;
                break;
            }
            default: {
                throw new ConverterInternalError();
            }
        }
        int i = 0;
        while (i < this.bc_conversion_table.length) {
            if (this.bc_conversion_table[i][0] == java_opcode) {
                return this.bc_conversion_table[i][type];
            }
            ++i;
        }
        throw new ConverterInternalError();
    }

    private void loadConstant(String field_class_name, String field_name, String descriptor, int value) throws Exception {
        int type = DataType.getType(value);
        switch (type) {
            case 3: {
                if (!this.method_converter.isIntSupported()) {
                    Object[] args = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(String.valueOf(field_class_name.replace('/', '.')) + "." + field_name)};
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.1", args);
                    throw new ConversionException();
                }
                Object[] args = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(String.valueOf(field_class_name.replace('/', '.')) + "." + field_name)};
                Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.1", args);
                this.method_converter.getPackageConverter().setIntFlag(true);
                this.jc_instr = new JcInstrIntValue(20, value);
                this.operand_stack.push(3, this.instr_container);
                return;
            }
            case 2: {
                this.jc_instr = new JcInstrShortValue(17, value);
                this.operand_stack.push(2, this.instr_container);
                return;
            }
            case 1: {
                switch (value) {
                    case -1: {
                        this.jc_instr = new JcInstrNoOperands(2);
                        break;
                    }
                    case 0: {
                        this.jc_instr = new JcInstrNoOperands(3);
                        break;
                    }
                    case 1: {
                        this.jc_instr = new JcInstrNoOperands(4);
                        break;
                    }
                    case 2: {
                        this.jc_instr = new JcInstrNoOperands(5);
                        break;
                    }
                    case 3: {
                        this.jc_instr = new JcInstrNoOperands(6);
                        break;
                    }
                    case 4: {
                        this.jc_instr = new JcInstrNoOperands(7);
                        break;
                    }
                    case 5: {
                        this.jc_instr = new JcInstrNoOperands(8);
                        break;
                    }
                    default: {
                        this.jc_instr = new JcInstrByteValue(16, value);
                    }
                }
                this.operand_stack.push(1, this.instr_container);
                return;
            }
        }
        throw new ConverterInternalError();
    }
}

