/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfExportFile;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ExportFileManager {
    private String[] export_path;
    private Vector export_files;

    public ExportFileManager(String[] export_path) {
        this.export_path = export_path;
        this.export_files = new Vector(20);
    }

    private void checkBinaryCompatibility(EfExportFile export_file) throws Exception {
        if (export_file.getMajorVersion() != 2) {
            Object[] args = new Object[]{Names.getExportFileName(export_file.getPackageName()), "major"};
            Notifier.error("binary.1", args);
            throw new ConverterException();
        }
        if (export_file.getMinorVersion() != 1) {
            Object[] args = new Object[]{Names.getExportFileName(export_file.getPackageName()), "minor"};
            Notifier.error("binary.1", args);
            throw new ConverterException();
        }
    }

    public EfClass getClass(String class_name) throws Exception {
        String package_name = Names.getPackageName(class_name);
        EfExportFile ef_file = this.getExportFile(package_name);
        if (ef_file == null) {
            return null;
        }
        return ef_file.getClass(class_name);
    }

    public EfExportFile getExportFile(String package_name) throws Exception {
        Enumeration e = this.export_files.elements();
        while (e.hasMoreElements()) {
            EfExportFile export_file = (EfExportFile)e.nextElement();
            if (!export_file.getPackageName().equals(package_name)) continue;
            return export_file;
        }
        return this.load(package_name);
    }

    public EfExportFile[] getExportFiles() {
        Object[] ef_files = new EfExportFile[this.export_files.size()];
        this.export_files.copyInto(ef_files);
        return ef_files;
    }

    public EfField getField(String class_name, String field_name, String field_descriptor) throws Exception {
        EfClass ef_class = this.getClass(class_name);
        if (ef_class == null) {
            return null;
        }
        return ef_class.getField(field_name, field_descriptor);
    }

    public EfMethod getMethod(String class_name, String method_name, String method_descriptor) throws Exception {
        EfClass ef_class = this.getClass(class_name);
        if (ef_class == null) {
            return null;
        }
        return ef_class.getMethod(method_name, method_descriptor);
    }

    public EfExportFile load(String package_name) throws Exception {
        char c = File.separatorChar;
        String ef_name = new String(String.valueOf(package_name.replace('/', c)) + c + "javacard" + c + Names.getExportFileName(package_name));
        int i = 0;
        while (i < this.export_path.length) {
            File file;
            String path = this.export_path[i];
            if (!path.endsWith(".jar") && (file = new File(path, ef_name)).isFile()) {
                EfExportFile export_file = new EfExportFile();
                try {
                    Notifier.progress("progress.1", file.getCanonicalPath());
                    DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                    export_file.parse(dis);
                    export_file.resolve();
                    this.export_files.addElement(export_file);
                    dis.close();
                    this.checkBinaryCompatibility(export_file);
                    return export_file;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Object[] args = new String[]{Names.getExportFileName(package_name), package_name.replace('/', '.')};
                    Notifier.error("linking.1", args);
                    throw new ConverterException();
                }
                catch (IOException iOException) {
                    Notifier.error("converter.1", Names.getExportFileName(package_name));
                    throw new ConverterException();
                }
            }
            ++i;
        }
        Object[] args = new String[]{Names.getExportFileName(package_name), package_name.replace('/', '.')};
        Notifier.error("linking.1", args);
        throw new ConverterException();
    }
}

