/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.util.j2me;

import com.sun.javacard.impl.NativeMethods;
import java.util.TimeZone;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class TimeZoneImpl
extends TimeZone {
    static String HOME_ID = null;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private String ID;
    static String[] ids = null;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int startYear;
    private int rawOffset;
    private boolean useDaylight = false;
    private static final int millisPerHour = 3600000;
    private static final int millisPerDay = 86400000;
    private static final byte[] staticMonthLength = new byte[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int startMode;
    private int endMode;
    private int dstSavings;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    static TimeZone[] zones;

    public TimeZoneImpl() {
    }

    private TimeZoneImpl(int rawOffset, String ID) {
        this.rawOffset = rawOffset;
        this.ID = ID;
        this.dstSavings = 3600000;
    }

    @Override
    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("Illegal month " + month);
        }
        return this.getOffset(era, year, month, day, dayOfWeek, millis, staticMonthLength[month]);
    }

    int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis, int monthLength) {
        if (era != 0 && era != 1 || month < 0 || month > 11 || day < 1 || day > monthLength || dayOfWeek < 1 || dayOfWeek > 7 || millis < 0 || millis >= 86400000 || monthLength < 28 || monthLength > 31) {
            throw new IllegalArgumentException();
        }
        int result = this.rawOffset;
        if (!this.useDaylight || year < this.startYear || era != 1) {
            return result;
        }
        boolean southern = this.startMonth > this.endMonth;
        int startCompare = TimeZoneImpl.compareToRule(month, monthLength, day, dayOfWeek, millis, this.startMode, this.startMonth, this.startDayOfWeek, this.startDay, this.startTime);
        int endCompare = 0;
        if (southern != startCompare >= 0) {
            millis += this.dstSavings;
            while (millis >= 86400000) {
                millis -= 86400000;
                dayOfWeek = 1 + dayOfWeek % 7;
                if (++day <= monthLength) continue;
                day = 1;
                ++month;
            }
            endCompare = TimeZoneImpl.compareToRule(month, monthLength, day, dayOfWeek, millis, this.endMode, this.endMonth, this.endDayOfWeek, this.endDay, this.endTime);
        }
        if (!southern && startCompare >= 0 && endCompare < 0 || southern && (startCompare >= 0 || endCompare < 0)) {
            result += this.dstSavings;
        }
        return result;
    }

    private static int compareToRule(int month, int monthLen, int dayOfMonth, int dayOfWeek, int millis, int ruleMode, int ruleMonth, int ruleDayOfWeek, int ruleDay, int ruleMillis) {
        if (month < ruleMonth) {
            return -1;
        }
        if (month > ruleMonth) {
            return 1;
        }
        int ruleDayOfMonth = 0;
        switch (ruleMode) {
            case 1: {
                ruleDayOfMonth = ruleDay;
                break;
            }
            case 2: {
                if (ruleDay > 0) {
                    ruleDayOfMonth = 1 + (ruleDay - 1) * 7 + (7 + ruleDayOfWeek - (dayOfWeek - dayOfMonth + 1)) % 7;
                    break;
                }
                ruleDayOfMonth = monthLen + (ruleDay + 1) * 7 - (7 + dayOfWeek + monthLen - dayOfMonth - ruleDayOfWeek) % 7;
                break;
            }
            case 3: {
                ruleDayOfMonth = ruleDay + (49 + ruleDayOfWeek - ruleDay - dayOfWeek + dayOfMonth) % 7;
                break;
            }
            case 4: {
                ruleDayOfMonth = ruleDay - (49 - ruleDayOfWeek + ruleDay + dayOfWeek - dayOfMonth) % 7;
            }
        }
        if (dayOfMonth < ruleDayOfMonth) {
            return -1;
        }
        if (dayOfMonth > ruleDayOfMonth) {
            return 1;
        }
        if (millis < ruleMillis) {
            return -1;
        }
        if (millis > ruleMillis) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getRawOffset() {
        return this.rawOffset;
    }

    @Override
    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    @Override
    public String getID() {
        return this.ID;
    }

    public synchronized TimeZone getInstance(String ID) {
        if (ID == null) {
            if (HOME_ID == null && (HOME_ID = System.getProperty("com.sun.cldc.util.j2me.TimeZoneImpl.timezone")) == null) {
                HOME_ID = "UTC";
            }
            ID = HOME_ID;
        }
        for (TimeZone element : zones) {
            if (!element.getID().equals(ID)) continue;
            return element;
        }
        return null;
    }

    public synchronized String[] getIDs() {
        if (ids == null) {
            ids = new String[zones.length];
            for (int i = 0; i < zones.length; ++i) {
                TimeZoneImpl.ids[i] = zones[i].getID();
            }
        }
        String[] idsToReturn = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            idsToReturn[i] = ids[i];
        }
        NativeMethods.transferOwnershipToPreviousContext(idsToReturn);
        return idsToReturn;
    }

    static {
        for (TimeZone element : zones = new TimeZone[]{new TimeZoneImpl(0, "GMT"), new TimeZoneImpl(0, "UTC")}) {
            NativeMethods.setJCREentry(element, false);
        }
    }
}

