/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl;

import com.sun.javacard.ApplicationModuleClassLoader;
import com.sun.javacard.ClassLoader;
import com.sun.javacard.ClassicApplicationClassLoader;
import com.sun.javacard.ClassicLibraryClassLoader;
import com.sun.javacard.ExtensionLibraryClassLoader;
import com.sun.javacard.JarExtractor;
import com.sun.javacard.Logger;
import com.sun.javacard.cm.impl.ApplicationBundleImpl;
import com.sun.javacard.cm.impl.ApplicationModule;
import com.sun.javacard.cm.impl.IDManager;
import com.sun.javacard.cm.impl.LibraryImpl;
import com.sun.javacard.cm.impl.PackageSealer;
import com.sun.javacard.cm.impl.jcad.JCPlatformAppDesc;
import com.sun.javacard.cm.impl.jcrd.JCRuntimeDesc;
import com.sun.javacard.cm.impl.jcrd.Util;
import com.sun.javacard.file.FileConnection;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.spi.cardmgmt.DeploymentException;
import com.sun.javacard.spi.cardmgmt.DeploymentUnit;
import com.sun.javacard.spi.cardmgmt.DeploymentUnitLoader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class DeploymentUnitLoaderImpl {
    private static final String JC_FILE_ROOT = "/eeprom/apps/_appbundle_";
    private static int classicAppBundleLoadCount = 0;
    private static int extendedAppBundleLoadCount = 0;
    private static int webAppBundleLoadCount = 0;
    private static int classicLibLoadCount = 0;
    private static int extensionLibLoadCount = 0;
    private static Vector<DeploymentUnit> loadedDeploymentUnits = new Vector();
    private static String BUNDLE_MANIFEST = "META-INF/MANIFEST.MF";
    private static DeploymentUnitLoaderImpl myInstance = new DeploymentUnitLoaderImpl();
    private Vector<String> restrictedPackages = new Vector<String>(){
        {
            this.addElement("com.sun.cldc.");
            this.addElement("com.sun.javacard.");
            this.addElement("com.sun.javacardx.");
            this.addElement("com.sun.midp.");
            this.addElement("com.sun.spot.");
            this.addElement("com.sun.spotx.");
            this.addElement("org.mortbay.");
        }
    };

    public static DeploymentUnitLoaderImpl getDeploymentUnitLoaderImpl() {
        return myInstance;
    }

    public Enumeration<DeploymentUnit> getLoadedDeploymentUnits() {
        return loadedDeploymentUnits.elements();
    }

    public void addToLoadedBundlesList(ApplicationBundleImpl appBundle) {
        loadedDeploymentUnits.addElement(appBundle);
    }

    public Enumeration<DeploymentUnit> getLoadedDeploymentUnits(byte type) {
        Vector<DeploymentUnit> deploymentUnitsOfReqType = new Vector<DeploymentUnit>();
        for (DeploymentUnit du : loadedDeploymentUnits) {
            if (du.getType() != type) continue;
            deploymentUnitsOfReqType.addElement(du);
        }
        return deploymentUnitsOfReqType.elements();
    }

    public static void removeDeploymentUnit(DeploymentUnit du) {
        loadedDeploymentUnits.removeElement(du);
    }

    public DeploymentUnit load(byte type, InputStream is) throws IllegalArgumentException, DeploymentException, IOException {
        if (is != null) {
            NativeMethods.checkPreviousContextAccess(is);
        }
        NativeMethods.transferOwnershiptoContext(is, 0, 0);
        int newBundleId = IDManager.getNextBundleId();
        byte[] jarData = this.readCompletely(is);
        String bundlePath = this.getFilePathForNewBundle(type);
        FileConnection fc = new FileConnection(bundlePath);
        DeploymentUnit newlyLoadedDeploymentUnit = null;
        NativeMethods.setNonPreemptive(Thread.currentThread());
        try {
            switch (type) {
                case 10: 
                case 11: 
                case 12: {
                    try {
                        this.extract(fc, jarData, null);
                    }
                    catch (OutOfMemoryError err) {
                        throw new DeploymentException(err.getMessage(), err);
                    }
                    newlyLoadedDeploymentUnit = this.loadApplicationBundle(fc, type, bundlePath, newBundleId);
                    break;
                }
                case 0: 
                case 1: {
                    newlyLoadedDeploymentUnit = this.loadLibrary(fc, type, jarData, bundlePath, newBundleId);
                }
            }
            loadedDeploymentUnits.addElement(newlyLoadedDeploymentUnit);
            this.removeClassFiles(fc);
            return newlyLoadedDeploymentUnit;
        }
        catch (IllegalArgumentException ile) {
            this.cleanupAfterFailedLoad(fc, newBundleId);
            throw ile;
        }
        catch (IOException ioe) {
            this.cleanupAfterFailedLoad(fc, newBundleId);
            throw ioe;
        }
        catch (DeploymentException de) {
            this.cleanupAfterFailedLoad(fc, newBundleId);
            throw de;
        }
        catch (Exception e) {
            this.cleanupAfterFailedLoad(fc, newBundleId);
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    private void cleanupAfterFailedLoad(FileConnection fc, int bundleId) {
        try {
            fc.delete();
        }
        catch (IOException e) {
            Logger.debug("FileConnection.delete threw IOException");
            e.printStackTrace();
        }
        IDManager.removeBundleId(bundleId);
        NativeMethods.setIsLoading(0);
    }

    private void removeClassFiles(FileConnection fc) throws IOException {
        for (FileConnection child : fc.listFiles()) {
            if (child.isFile() && child.getName().endsWith(".class")) {
                child.delete();
                continue;
            }
            if (!child.isDirectory()) continue;
            this.removeClassFiles(child);
        }
    }

    private byte[] readCompletely(InputStream is) throws IOException {
        int newlyRead;
        ByteArrayOutputStream aos = new ByteArrayOutputStream(is.available());
        byte[] buffer = new byte[256];
        while ((newlyRead = is.read(buffer)) > 0) {
            aos.write(buffer, 0, newlyRead);
        }
        return aos.toByteArray();
    }

    private DeploymentUnit loadLibrary(FileConnection bundleDir, byte type, byte[] jarData, String bundlePath, int newBundleId) throws IOException, DeploymentException {
        ClassLoader classLoader = null;
        Vector<String> libraryClasses = new Vector<String>();
        try {
            this.extract(bundleDir, jarData, libraryClasses);
        }
        catch (OutOfMemoryError err) {
            throw new DeploymentException(err.getMessage(), err);
        }
        Vector<String> sealedPackages = null;
        FileConnection mf = new FileConnection(bundleDir, BUNDLE_MANIFEST);
        if (mf.exists()) {
            InputStream is = mf.openInputStream();
            try {
                int bundleDirNameLength = bundleDir.getAbsolutePath().length();
                sealedPackages = this.getSealedPkgsList(new BufferedReader(new InputStreamReader(is)), bundleDirNameLength, bundleDir);
                for (String pkgName : sealedPackages) {
                    if (type == 1) {
                        PackageSealer.sealExtLibrayPackageByManifest(pkgName, newBundleId);
                        continue;
                    }
                    PackageSealer.sealClassicLibrayPackageByManifest(pkgName, newBundleId);
                }
            }
            catch (Exception e) {
                throw new DeploymentException(e.getMessage(), e);
            }
        }
        switch (type) {
            case 0: {
                classLoader = ClassicLibraryClassLoader.getClassicLibraryClassLoader();
                break;
            }
            case 1: {
                classLoader = ExtensionLibraryClassLoader.getExtensionLibraryClassLoader();
            }
        }
        classLoader.setBundleID(newBundleId);
        NativeMethods.transferOwnershiptoContext(sealedPackages, newBundleId, 0);
        NativeMethods.setIsLoading(classLoader.getBundleID());
        classLoader.initSIPromoting(null, sealedPackages);
        switch (type) {
            case 0: {
                classLoader.setClassPath(bundlePath);
                for (String className : libraryClasses) {
                    try {
                        classLoader.loadClass(className);
                    }
                    catch (Exception e) {
                        NativeMethods.removeBundleDependencies(newBundleId);
                        classLoader.freeClasses(newBundleId);
                        throw new DeploymentException(e.getMessage(), e);
                    }
                }
                break;
            }
            case 1: {
                try {
                    ((ExtensionLibraryClassLoader)classLoader).loadEL(libraryClasses, bundlePath);
                    break;
                }
                catch (Exception e) {
                    NativeMethods.removeBundleDependencies(newBundleId);
                    classLoader.freeClasses(newBundleId);
                    throw new DeploymentException(e.getMessage(), e);
                }
            }
        }
        classLoader.processShareables();
        classLoader.doneSIPromoting();
        NativeMethods.setIsLoading(0);
        return new LibraryImpl(type, classLoader, bundleDir, newBundleId);
    }

    public DeploymentUnit loadApplicationBundle(FileConnection bundleDir, byte type, String bundlePath, int newBundleId) throws IOException, DeploymentException, UnsupportedEncodingException {
        InputStream is = null;
        JCRuntimeDesc jcrd = null;
        Vector<String> sealedPackages = null;
        FileConnection mf = new FileConnection(bundleDir, BUNDLE_MANIFEST);
        if (mf.exists()) {
            is = mf.openInputStream();
            try {
                FileConnection infClassesFolder = new FileConnection(bundleDir, type == 10 ? "WEB-INF/classes/" : "APPLET-INF/classes/");
                int bundleDirNameLength = infClassesFolder.getAbsolutePath().length();
                sealedPackages = this.getSealedPkgsList(new BufferedReader(new InputStreamReader(is)), bundleDirNameLength, infClassesFolder);
            }
            catch (Exception e) {
                throw new DeploymentException(e.getMessage(), e);
            }
        }
        if (!(mf = new FileConnection(bundleDir, BUNDLE_MANIFEST)).exists()) {
            throw new IOException("4093");
        }
        is = mf.openInputStream();
        try {
            jcrd = new JCRuntimeDesc(new BufferedReader(new InputStreamReader(is)));
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), e);
        }
        if (jcrd.getAppType() != type) {
            throw new IllegalArgumentException("4090");
        }
        NativeMethods.transferOwnershiptoContext(bundlePath, newBundleId, 0);
        NativeMethods.switchContext(newBundleId, 0);
        ClassLoader bundleClassLoader = type == 12 ? new ClassicApplicationClassLoader(bundlePath, newBundleId) : new ApplicationModuleClassLoader(bundlePath, newBundleId, (int)type);
        NativeMethods.switchContext(0, 0);
        ApplicationBundleImpl bundle = null;
        try {
            bundle = new ApplicationBundleImpl(type, jcrd, bundlePath, bundleClassLoader, newBundleId);
        }
        catch (Exception e) {
            if (e instanceof UnsupportedEncodingException) {
                throw new UnsupportedEncodingException(e.getMessage());
            }
            if (e instanceof IOException) {
                throw new IOException(e.getMessage());
            }
            throw new DeploymentException(e.getMessage(), e);
        }
        Vector<ApplicationModule> appModules = bundle.getAppModules();
        try {
            for (ApplicationModule am : appModules) {
                Vector<String> dynamicallyLoadedClasses;
                String appClassPath = am.getAppClassPath();
                if (appClassPath == null) continue;
                JCPlatformAppDesc jcad = am.getJCAppDesc();
                NativeMethods.transferOwnershiptoContext(appClassPath, newBundleId, 0);
                bundleClassLoader.setClassPath(appClassPath);
                Vector<String> classes = null;
                Vector<String> shareableClasses = null;
                switch (type) {
                    case 10: {
                        classes = am.getWebAppDesc().getClassesToLoad();
                        break;
                    }
                    case 11: 
                    case 12: {
                        classes = am.getAppletAppDesc().getAppletClasses();
                    }
                }
                if (jcad != null && (dynamicallyLoadedClasses = jcad.getDynamicallyLoadedClasses()) != null) {
                    for (String className : dynamicallyLoadedClasses) {
                        if (this.isRestrictedPackage(className)) {
                            throw new SecurityException("Restricted package name in dynamically loaded class : " + className);
                        }
                        classes.addElement(className);
                    }
                }
                if ((shareableClasses = am.getExposedSIList()) != null) {
                    for (String className : shareableClasses) {
                        classes.addElement(className);
                    }
                }
                int shareableClassesOwner = NativeMethods.objectOwner(shareableClasses);
                int shareableClassesContext = NativeMethods.objectContext(shareableClasses);
                NativeMethods.transferOwnershiptoContext(shareableClasses, newBundleId, 0);
                NativeMethods.transferOwnershiptoContext(sealedPackages, newBundleId, 0);
                NativeMethods.transferOwnershiptoContext(classes, newBundleId, 0);
                NativeMethods.setIsLoading(newBundleId);
                bundleClassLoader.initSIPromoting(shareableClasses, sealedPackages);
                for (String aClass : classes) {
                    NativeMethods.transferOwnershiptoContext(aClass, newBundleId, 0);
                    bundleClassLoader.loadClass(aClass);
                }
                bundleClassLoader.processShareables();
                bundleClassLoader.doneSIPromoting();
                NativeMethods.transferOwnershiptoContext(shareableClasses, shareableClassesContext, shareableClassesOwner);
            }
            bundleClassLoader.setPreloaded(true);
            NativeMethods.setIsLoading(0);
        }
        catch (Throwable t) {
            NativeMethods.removeBundleDependencies(newBundleId);
            bundleClassLoader.freeClasses(newBundleId);
            throw new DeploymentException(t.getMessage(), t);
        }
        if (is != null) {
            is.close();
        }
        return bundle;
    }

    private static void getListOfPkgsInLibrary(int bundleDirNameLength, Vector<String> pkgList, FileConnection rootDir) {
        if (rootDir.isFile()) {
            FileConnection parent = rootDir.getParentFile();
            String dirName = null;
            if (parent.getAbsolutePath().length() == bundleDirNameLength) {
                dirName = "<default>";
            } else {
                dirName = parent.getAbsolutePath().substring(bundleDirNameLength);
                if (dirName.startsWith("/")) {
                    dirName = dirName.substring(1);
                }
                if (dirName.endsWith("/")) {
                    dirName = dirName.substring(0, dirName.length() - 1);
                }
            }
            if (!pkgList.contains(dirName)) {
                pkgList.addElement(dirName);
            }
        } else {
            FileConnection[] children = null;
            try {
                children = rootDir.listFiles();
            }
            catch (IOException e) {
                Logger.debug("FileConnection.list threw IOException");
                e.printStackTrace();
            }
            if (children != null) {
                for (FileConnection fc : children) {
                    if (fc.getName().equals("META-INF")) continue;
                    DeploymentUnitLoaderImpl.getListOfPkgsInLibrary(bundleDirNameLength, pkgList, fc);
                }
            }
        }
    }

    private Vector<String> getSealedPkgsList(BufferedReader br, int bundleDirNameLength, FileConnection rootDir) throws Exception {
        boolean inMainSection = true;
        Vector<String> sealedPkgsList = new Vector<String>();
        StringBuffer lastLine = new StringBuffer();
        StringBuffer name = new StringBuffer();
        StringBuffer value = new StringBuffer();
        String pkgName = null;
        Util.startNewFile();
        while (!Util.fileEndReached) {
            Util.readAttribute(br, name, value, lastLine);
            if (name.toString().equalsIgnoreCase("Name")) {
                pkgName = value.toString();
                if (pkgName.charAt(pkgName.length() - 1) == '/') {
                    pkgName = pkgName.substring(0, pkgName.length() - 1);
                }
            } else if (name.toString().equalsIgnoreCase("Sealed")) {
                boolean isSealed = value.toString().equalsIgnoreCase("true");
                if (isSealed && inMainSection) {
                    DeploymentUnitLoaderImpl.getListOfPkgsInLibrary(bundleDirNameLength, sealedPkgsList, rootDir);
                } else if (isSealed && pkgName != null) {
                    if (!sealedPkgsList.contains(pkgName)) {
                        sealedPkgsList.addElement(pkgName);
                    }
                    pkgName = null;
                } else if (!isSealed && pkgName != null && sealedPkgsList.contains(pkgName)) {
                    sealedPkgsList.removeElement(pkgName);
                }
            }
            if (!Util.atSectionEnd()) continue;
            pkgName = null;
            inMainSection = false;
            Util.startReadNewSection();
        }
        return sealedPkgsList;
    }

    private String getFilePathForNewBundle(byte type) {
        switch (type) {
            case 10: {
                return "/eeprom/apps/_appbundle_/webApp" + ++webAppBundleLoadCount + "/docroot";
            }
            case 11: {
                return "/eeprom/apps/_appbundle_/extendedApp" + ++extendedAppBundleLoadCount;
            }
            case 12: {
                return "/eeprom/apps/_appbundle_/classicApp" + ++classicAppBundleLoadCount;
            }
            case 0: {
                return "/eeprom/apps/_appbundle_/classicLib" + ++classicLibLoadCount;
            }
            case 1: {
                return "/eeprom/apps/_appbundle_/extensionLib" + ++extensionLibLoadCount;
            }
        }
        return null;
    }

    private void extract(FileConnection fcRoot, byte[] jarData, Vector<String> classNames) throws IOException {
        fcRoot.mkdirs();
        String fileName = null;
        byte[] fileData = null;
        Hashtable<String, byte[]> ht = JarExtractor.extractFilesToHashtable(jarData);
        Enumeration<String> en = ht.keys();
        while (en.hasMoreElements()) {
            fileName = en.nextElement();
            fileData = ht.get(fileName);
            Logger.debug("Extracting \"" + fileName + "\" with length = " + fileData.length);
            this.createFile(fcRoot, fileName, fileData);
            if (classNames == null || !fileName.endsWith(".class")) continue;
            fileName = fileName.replace('/', '.');
            classNames.addElement(fileName.substring(0, fileName.length() - 6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(FileConnection fcRoot, String fileName, byte[] fileData) {
        FileConnection fc = new FileConnection(fcRoot, fileName);
        try {
            if (!fc.exists()) {
                fc.create();
            }
        }
        catch (IOException e) {
            Logger.debug("FileConnection threw IOException");
            e.printStackTrace();
        }
        OutputStream os = null;
        try {
            os = fc.openOutputStream();
            os.write(fileData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean isRestrictedPackage(String classname) {
        for (String h : this.restrictedPackages) {
            if (!classname.startsWith(h)) continue;
            return true;
        }
        return false;
    }

    static {
        DeploymentUnitLoader.getDeploymentUnitLoader();
    }
}

