/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.util;

import com.sun.javacard.URI;
import com.sun.javacard.cm.impl.ApplicationImpl;
import com.sun.javacard.impl.NativeMethods;
import javacardx.framework.JCSystem;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public final class URIUtils {
    public static final String PLATFORM_BASE_URI = "/platform";
    public static final String STANDARD_BASE_URI = "/standard";
    private static final String SLASH = "/";
    private static final String DOUBLE_SLASH = "//";
    private static final String COLON = ":";
    private static final String AID_AUTHORITY = "aid";

    public static String canonicalize(String uri) throws IllegalArgumentException {
        String appURI = URIUtils.getAppURI();
        if (appURI != null) {
            StringBuffer sb = new StringBuffer(appURI);
            sb.append(SLASH);
            URI currentURI = new URI(sb.toString());
            return currentURI.resolve(uri).normalize().toString();
        }
        URI newURI = new URI(uri);
        return newURI.normalize().toString();
    }

    public static boolean isAppURI(String uri) {
        if (uri == null) {
            return false;
        }
        if (uri.equals("///standard") || uri.startsWith("///standard/") || uri.equals(STANDARD_BASE_URI) || uri.startsWith("/standard/")) {
            return false;
        }
        if (uri.equals("///platform") || uri.startsWith("///platform/") || uri.equals(PLATFORM_BASE_URI) || uri.startsWith("/platform/")) {
            return false;
        }
        return !(uri.startsWith(DOUBLE_SLASH) ? !uri.startsWith("///") && !uri.startsWith("//aid/") : !uri.startsWith(SLASH));
    }

    public static boolean haveSamePathPrefix(String uri1, String uri2) {
        URI _uri1 = URI.create(uri1);
        URI _uri2 = URI.create(uri2);
        String auth1 = _uri1.getRawAuthority();
        String auth2 = _uri2.getRawAuthority();
        if (!(auth1 == null && auth2 == null || auth1 != null && auth1.equals(auth2))) {
            return false;
        }
        String path1 = _uri1.getRawPath();
        String path2 = _uri2.getRawPath();
        NativeMethods.transferOwnershipToPreviousContext(path1);
        NativeMethods.transferOwnershipToPreviousContext(path2);
        int i = path1.indexOf(47, 1);
        if (i > 1 && auth1 != null && auth1.equals(AID_AUTHORITY)) {
            i = path1.indexOf(47, i + 1);
        }
        return i > 1 && path2.regionMatches(false, 0, path1, 0, i + 1);
    }

    public static boolean isInAppNamespace(String uri) throws IllegalArgumentException {
        String appURI = URIUtils.getAppURI();
        if (appURI == null) {
            return false;
        }
        URI current = URI.create(appURI);
        URI candidate = URI.create(uri);
        String currentPath = current.getRawPath();
        String uriPath = candidate.getRawPath();
        if (uriPath.startsWith("/~")) {
            return true;
        }
        return currentPath != null && uriPath != null && (uriPath.equals(currentPath) || uriPath.startsWith(currentPath + SLASH));
    }

    public static String normalizeReservedURI(String serviceURI) {
        URI uri = URI.create(serviceURI);
        uri.normalize();
        String path = uri.getRawPath();
        if (path != null && (path.startsWith(STANDARD_BASE_URI) || path.startsWith(PLATFORM_BASE_URI))) {
            String authority = uri.getRawAuthority();
            if (uri.isAbsolute() && authority != null && authority.equals(AID_AUTHORITY)) {
                StringBuffer sb = new StringBuffer(uri.getScheme());
                sb.append(COLON);
                sb.append(DOUBLE_SLASH);
                sb.append(path);
                return sb.toString();
            }
        }
        return uri.toString();
    }

    public static String getRootURI(String scheme, String appURI) {
        if (appURI.startsWith(DOUBLE_SLASH)) {
            return new StringBuffer(scheme).append(COLON).append(appURI).toString();
        }
        if (appURI.startsWith(SLASH)) {
            return new StringBuffer(scheme).append(COLON).append(DOUBLE_SLASH).append(appURI).toString();
        }
        throw new IllegalArgumentException();
    }

    public static String getAppRootURIPath() {
        return URIUtils.getPath(URIUtils.getAppURI());
    }

    public static boolean isInStandardNamespace(String uri) {
        String path = URI.create(uri).getRawPath();
        return path.equals(STANDARD_BASE_URI) || path.startsWith("/standard/");
    }

    public static boolean isInPlatformNamespace(String uri) {
        String path = URI.create(uri).getRawPath();
        return path.equals(PLATFORM_BASE_URI) || path.startsWith("/platform/");
    }

    public static boolean isInNamespace(String uri1, String uri2) {
        String path1 = URI.create(uri1).getRawPath();
        String path2 = URI.create(uri2).getRawPath();
        NativeMethods.transferOwnershipToPreviousContext(path1);
        NativeMethods.transferOwnershipToPreviousContext(path2);
        return path1.equals(path2) || path1.startsWith((path2 + SLASH).intern());
    }

    public static boolean isAbsolute(String uri) {
        return URI.create(uri).isAbsolute();
    }

    public static boolean isOpaque(String uri) {
        return URI.create(uri).isOpaque();
    }

    public static boolean hasScheme(String uri, String scheme) {
        return scheme.equals(new URI(uri).getScheme());
    }

    public static boolean hasScheme(String uri) {
        return new URI(uri).getScheme() != null;
    }

    public static String normalize(String uri) throws IllegalArgumentException {
        URI uriInstance = URI.create(uri).normalize();
        String uriComponent = uriInstance.getRawAuthority();
        if (uriComponent != null && uriComponent.equals(AID_AUTHORITY)) {
            StringBuffer sb = new StringBuffer();
            uriComponent = uriInstance.getScheme();
            if (uriComponent != null) {
                sb.append(uriComponent + "://aid");
            } else {
                sb.append("//aid");
            }
            uriComponent = uriInstance.getRawPath();
            if (uriComponent != null && !uriComponent.startsWith(STANDARD_BASE_URI) && !uriComponent.startsWith(PLATFORM_BASE_URI)) {
                int slashIndex = uriComponent.indexOf(SLASH, 1);
                if ((slashIndex = uriComponent.indexOf(SLASH, slashIndex + 1)) != -1) {
                    sb.append(uriComponent.substring(0, slashIndex).toUpperCase());
                    sb.append(uriComponent.substring(slashIndex));
                } else {
                    sb.append(uriComponent.toUpperCase());
                }
                uriComponent = uriInstance.getRawQuery();
                if (uriComponent != null) {
                    sb.append("?" + uriComponent);
                }
                if ((uriComponent = uriInstance.getRawFragment()) != null) {
                    sb.append("#" + uriComponent);
                }
                return sb.toString();
            }
            return uriInstance.toString();
        }
        return uriInstance.toString();
    }

    public static String resolve(String uri) throws IllegalArgumentException {
        return URIUtils.resolve(URIUtils.getAppURI(), uri);
    }

    public static String resolve(String baseURI, String uri) throws IllegalArgumentException {
        if (!baseURI.endsWith(SLASH)) {
            StringBuffer sb = new StringBuffer(baseURI);
            sb.append(SLASH);
            baseURI = sb.toString();
        }
        URI base = URI.create(baseURI);
        return base.resolve(uri).toString();
    }

    public static String resolveWithScheme(String scheme, String uri) throws IllegalArgumentException {
        if (scheme != null) {
            URI resolvent = URI.create(uri);
            if (resolvent.isAbsolute()) {
                if (scheme.equals(resolvent.getScheme())) {
                    return uri;
                }
                throw new IllegalArgumentException();
            }
            String current = URIUtils.getAppURI();
            assert (current != null) : "Can't resolve relative URIs in JCRE mode.";
            StringBuffer sb = new StringBuffer(current);
            sb.append(SLASH);
            URI baseURI = new URI(scheme, sb.toString(), null);
            return baseURI.resolve(resolvent).toString();
        }
        URI resolvent = URI.create(uri);
        if (resolvent.isAbsolute()) {
            return uri;
        }
        if (uri.startsWith(SLASH)) {
            return uri;
        }
        String current = URIUtils.getAppURI();
        assert (current != null) : "Can't resolve relative URIs in JCRE mode.";
        StringBuffer sb = new StringBuffer(current);
        sb.append(SLASH);
        URI baseURI = new URI(sb.toString());
        return baseURI.resolve(resolvent).toString();
    }

    public static boolean isAIDBasedURI(String uri) throws IllegalArgumentException {
        URI baseURI = URI.create(uri);
        String scheme = baseURI.getScheme();
        String authority = baseURI.getRawAuthority();
        return scheme == null && authority != null && authority.equals(AID_AUTHORITY);
    }

    public static String getAppURI() {
        if (NativeMethods.getCurrentContext() == 0) {
            byte appId = NativeMethods.getPreviousAppId();
            return ApplicationImpl.getAppURIForAppId(appId);
        }
        return JCSystem.getURI();
    }

    public static String getPath(String uri) {
        return new URI(uri).getRawPath();
    }

    private URIUtils() {
    }
}

