/*
 * Decompiled with CFR 0.152.
 */
package javacardx.facilities;

import com.sun.javacard.cm.impl.SecurityUtil;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.util.JCSystemAccessor;
import com.sun.javacard.util.PathLookupTable;
import com.sun.javacard.util.URIUtils;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Vector;
import javacard.framework.AID;
import javacard.framework.Shareable;
import javacardx.facilities.ServiceFactory;
import javacardx.facilities.ServiceRegistryPermission;
import javacardx.framework.JCSystem;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public final class ServiceRegistry {
    private static final String SIO_ROOT_URI = "sio:///";
    public static final String SERVICE_STANDARD_AUTH_URI = "sio:///standard/auth/";
    public static final String SERVICE_STANDARD_GLOBAL_HOLDER_AUTH_URI = "sio:///standard/auth/holder/global/";
    public static final String SERVICE_STANDARD_SESSION_HOLDER_AUTH_URI = "sio:///standard/auth/holder/session/";
    public static final String SERVICE_STANDARD_SESSION_USER_AUTH_URI = "sio:///standard/auth/user/session/";
    private static final String SIO_SCHEME = "sio";
    private PathLookupTable<ServiceFactory> registry = new PathLookupTable();
    private static ServiceRegistry serviceRegistry = null;

    public static final synchronized ServiceRegistry getServiceRegistry() {
        if (serviceRegistry == null) {
            serviceRegistry = new ServiceRegistry();
            NativeMethods.setJCREentry(serviceRegistry, false);
        }
        return serviceRegistry;
    }

    private ServiceRegistry() {
        JCSystemAccessor.getJCSystemAccessor().setServiceRegistry(this.registry);
    }

    public synchronized Enumeration<ServiceFactory> list() {
        Vector<ServiceFactory> w = new Vector<ServiceFactory>();
        Enumeration<ServiceFactory> enumeration = this.registry.elements();
        byte previousContext = NativeMethods.getPreviousContext();
        while (enumeration.hasMoreElements()) {
            ServiceFactory factory = enumeration.nextElement();
            int objectContext = NativeMethods.objectContext(factory);
            if (previousContext != objectContext) continue;
            w.addElement(factory);
        }
        NativeMethods.transferOwnershipToPreviousContext(w);
        return w.elements();
    }

    public Shareable lookup(String serviceURI) {
        if (serviceURI != null) {
            NativeMethods.checkPreviousContextAccess(serviceURI);
        }
        return this.doLookup(serviceURI, null);
    }

    public Shareable lookup(String serverURI, String serviceURI) {
        if (serverURI != null) {
            NativeMethods.checkPreviousContextAccess(serverURI);
        }
        if (serviceURI != null) {
            NativeMethods.checkPreviousContextAccess(serviceURI);
        }
        return this.doLookup(serverURI, serviceURI, null);
    }

    public Shareable lookup(String serviceURI, Object parameter) {
        if (serviceURI != null) {
            NativeMethods.checkPreviousContextAccess(serviceURI);
        }
        return this.doLookup(serviceURI, parameter);
    }

    private Shareable doLookup(String serviceURI, Object parameter) {
        String strToTrim;
        String originalServiceURI = serviceURI;
        if (serviceURI == null) {
            throw new NullPointerException();
        }
        if (URIUtils.isOpaque(serviceURI)) {
            throw new IllegalArgumentException();
        }
        boolean isAbsolute = URIUtils.isAbsolute(serviceURI);
        if (!isAbsolute) {
            serviceURI = URIUtils.resolveWithScheme(SIO_SCHEME, serviceURI);
        }
        serviceURI = URIUtils.normalize(serviceURI);
        serviceURI = URIUtils.normalizeReservedURI(serviceURI);
        AccessController.checkPermission(new ServiceRegistryPermission(serviceURI, "lookup"));
        ServiceFactory factory = null;
        PathLookupTable.Entry entry = this.get(serviceURI);
        if (entry != null) {
            factory = (ServiceFactory)entry.getResource();
        }
        if (factory != null) {
            NativeMethods.transferOwnershipUsingSecondObject(serviceURI, factory);
            return factory.create(serviceURI, parameter);
        }
        if (!(parameter instanceof Byte)) {
            return null;
        }
        byte b = (Byte)parameter;
        if (URIUtils.isAbsolute(originalServiceURI) && originalServiceURI.indexOf(strToTrim = "sio:") > -1) {
            originalServiceURI = originalServiceURI.substring(strToTrim.length());
        }
        if (URIUtils.isAIDBasedURI(originalServiceURI)) {
            if (originalServiceURI.endsWith("/")) {
                originalServiceURI = originalServiceURI.substring(0, originalServiceURI.lastIndexOf(47));
            }
            AID aid = JCSystem.getAID(URIUtils.normalize(originalServiceURI));
            return javacard.framework.JCSystem.getAppletShareableInterfaceObject(aid, b);
        }
        return null;
    }

    public Shareable lookup(String serverURI, String serviceURI, Object parameter) {
        if (serverURI != null) {
            NativeMethods.checkPreviousContextAccess(serverURI);
        }
        if (serviceURI != null) {
            NativeMethods.checkPreviousContextAccess(serviceURI);
        }
        return this.doLookup(serverURI, serviceURI, parameter);
    }

    private Shareable doLookup(String serverURI, String serviceURI, Object parameter) {
        String strToTrim;
        if (serverURI != null && !URIUtils.isAppURI(serverURI = URIUtils.normalize(serverURI))) {
            throw new IllegalArgumentException();
        }
        if (serviceURI == null) {
            throw new NullPointerException();
        }
        if (URIUtils.isOpaque(serviceURI)) {
            throw new IllegalArgumentException();
        }
        String originalServiceURI = serviceURI;
        boolean isAbsolute = URIUtils.isAbsolute(serviceURI);
        if (!isAbsolute) {
            if (serverURI == null) {
                serviceURI = URIUtils.resolveWithScheme(SIO_SCHEME, serviceURI);
            } else {
                String sioRootURI = URIUtils.getRootURI(SIO_SCHEME, serverURI);
                serviceURI = URIUtils.resolve(sioRootURI, serviceURI);
            }
        }
        serviceURI = URIUtils.normalize(serviceURI);
        serviceURI = URIUtils.normalizeReservedURI(serviceURI);
        AccessController.checkPermission(new ServiceRegistryPermission(serviceURI, "lookup"));
        ServiceFactory factory = null;
        PathLookupTable.Entry entry = this.get(serviceURI);
        if (entry != null && (serverURI == null || entry.getRegisterer().equals(serverURI))) {
            factory = (ServiceFactory)entry.getResource();
        }
        if (factory != null) {
            NativeMethods.transferOwnershipUsingSecondObject(serviceURI, factory);
            return factory.create(serviceURI, parameter);
        }
        if (!(parameter instanceof Byte)) {
            return null;
        }
        byte b = (Byte)parameter;
        if (URIUtils.isAbsolute(originalServiceURI) && originalServiceURI.indexOf(strToTrim = "sio:") > -1) {
            originalServiceURI = originalServiceURI.substring(strToTrim.length());
        }
        if (URIUtils.isAIDBasedURI(originalServiceURI)) {
            if (originalServiceURI.endsWith("/")) {
                originalServiceURI = originalServiceURI.substring(0, originalServiceURI.lastIndexOf(47));
            }
            AID aid = JCSystem.getAID(URIUtils.normalize(originalServiceURI));
            return javacard.framework.JCSystem.getAppletShareableInterfaceObject(aid, b);
        }
        return null;
    }

    public synchronized void register(String serviceURI, ServiceFactory factory) {
        int objectContext;
        if (serviceURI == null || factory == null) {
            throw new NullPointerException();
        }
        NativeMethods.checkPreviousContextAccess(serviceURI);
        NativeMethods.checkPreviousContextAccess(factory);
        if (URIUtils.isOpaque(serviceURI)) {
            throw new IllegalArgumentException();
        }
        boolean isAbsolute = URIUtils.isAbsolute(serviceURI);
        if (!isAbsolute) {
            serviceURI = URIUtils.resolveWithScheme(SIO_SCHEME, serviceURI);
        }
        serviceURI = URIUtils.normalize(serviceURI);
        if ((serviceURI = URIUtils.normalizeReservedURI(serviceURI)).startsWith(SERVICE_STANDARD_AUTH_URI) && !serviceURI.startsWith(SERVICE_STANDARD_GLOBAL_HOLDER_AUTH_URI) && !serviceURI.startsWith(SERVICE_STANDARD_SESSION_HOLDER_AUTH_URI) && !serviceURI.startsWith(SERVICE_STANDARD_SESSION_USER_AUTH_URI)) {
            throw new IllegalArgumentException();
        }
        if (!URIUtils.hasScheme(serviceURI, SIO_SCHEME)) {
            throw new IllegalArgumentException();
        }
        if (!this.isValidForRegistration(serviceURI)) {
            throw new SecurityException();
        }
        byte previousContext = NativeMethods.getPreviousContext();
        ServiceFactory f = null;
        PathLookupTable.Entry entry = this.get(serviceURI);
        if (entry != null) {
            f = (ServiceFactory)entry.getResource();
        }
        if (f != null && previousContext != (objectContext = NativeMethods.objectContext(f))) {
            throw new SecurityException();
        }
        objectContext = NativeMethods.objectContext(factory);
        if (previousContext != objectContext) {
            throw new SecurityException();
        }
        AccessController.checkPermission(new ServiceRegistryPermission(serviceURI, "register"));
        String currentAppURI = URIUtils.getAppURI();
        if (currentAppURI != null && serviceURI.startsWith("sio:///standard/") && !this.registry.containsStandardURI(currentAppURI)) {
            SecurityUtil.updatePDMatrixForStandardNS(currentAppURI, serviceURI);
        }
        this.put(serviceURI, URIUtils.getAppURI(), factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String serviceURI) {
        if (serviceURI == null) {
            throw new NullPointerException();
        }
        NativeMethods.checkPreviousContextAccess(serviceURI);
        if (URIUtils.isOpaque(serviceURI)) {
            throw new IllegalArgumentException();
        }
        boolean isAbsolute = URIUtils.isAbsolute(serviceURI);
        if (!isAbsolute) {
            serviceURI = URIUtils.resolveWithScheme(SIO_SCHEME, serviceURI);
        }
        serviceURI = URIUtils.normalize(serviceURI);
        serviceURI = URIUtils.normalizeReservedURI(serviceURI);
        AccessController.checkPermission(new ServiceRegistryPermission(serviceURI, "unregister"));
        if (!URIUtils.isInAppNamespace(serviceURI) && !URIUtils.isInStandardNamespace(serviceURI)) {
            throw new SecurityException();
        }
        ServiceRegistry serviceRegistry = ServiceRegistry.serviceRegistry;
        synchronized (serviceRegistry) {
            ServiceFactory factory = null;
            PathLookupTable.Entry entry = this.get(serviceURI);
            if (entry != null && entry.getRegisterer() != null && entry.getRegisterer().equals(URIUtils.getAppURI())) {
                factory = (ServiceFactory)entry.getResource();
            }
            if (factory == null && entry != null) {
                throw new SecurityException();
            }
            this.registry.remove(serviceURI);
            String currentAppURI = URIUtils.getAppURI();
            if (currentAppURI != null && serviceURI.startsWith("sio:///standard/") && !this.registry.containsStandardURI(currentAppURI)) {
                SecurityUtil.updatePDMatrixForStandardNS(currentAppURI, null);
            }
        }
    }

    private PathLookupTable.Entry get(String serviceURI) {
        Enumeration<PathLookupTable.Entry> e = this.registry.lookup(serviceURI);
        if (e.hasMoreElements()) {
            PathLookupTable.Entry entry = e.nextElement();
            return entry;
        }
        return null;
    }

    private void put(String serviceURI, String serverURI, ServiceFactory factory) {
        this.registry.clear(serviceURI);
        this.registry.insert(serverURI, serviceURI, factory, null);
    }

    private boolean isValidForRegistration(String uri) {
        return URIUtils.isInAppNamespace(uri) || URIUtils.isInStandardNamespace(uri);
    }
}

