/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.bio;

import java.io.IOException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.microedition.io.SocketConnection;
import org.mortbay.io.bio.StreamEndPoint;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class SocketEndPoint
extends StreamEndPoint {
    SocketConnection socketConnection;

    public SocketEndPoint(SocketConnection socket) throws IOException {
        super(socket.openInputStream(), socket.openOutputStream());
        this.socketConnection = socket;
    }

    public boolean isClosed() {
        return this.socketConnection == null;
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.socketConnection != null) {
            this.socketConnection.close();
        }
        this.inputStream = null;
        this.outputStream = null;
        this.socketConnection = null;
    }

    @Override
    public String getLocalAddr() {
        try {
            return this.socketConnection.getLocalAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "NOT_OPENED";
        }
    }

    @Override
    public String getLocalHost() {
        try {
            return this.socketConnection.getLocalAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "NOT_OPENED";
        }
    }

    @Override
    public int getLocalPort() {
        try {
            return this.socketConnection.getLocalPort();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public String getRemoteAddr() {
        try {
            return this.socketConnection.getAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "NOT_OPENED";
        }
    }

    @Override
    public String getRemoteHost() {
        try {
            return this.socketConnection.getAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "NOT_OPENED";
        }
    }

    @Override
    public int getRemotePort() {
        try {
            return this.socketConnection.getPort();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public Object getConnection() {
        return this.socketConnection;
    }
}

