/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import com.sun.javacard.Logger;
import com.sun.javacard.ThreadHashtable;
import com.sun.javacard.cm.impl.ApplicationImpl;
import com.sun.javacard.cm.impl.jcrd.ModuleInfo;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.jcre.JCRuntime;
import com.sun.javacard.spi.cardmgmt.Application;
import com.sun.javacard.util.JCSystemAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.microedition.io.SocketConnection;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpContent;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpFieldsWrapper;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpMethods;
import org.mortbay.jetty.HttpParser;
import org.mortbay.jetty.HttpURI;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.WebConnector;
import org.mortbay.jetty.WebServer;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.util.URIUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class HttpConnection {
    static int UNKNOWN = -2;
    private static ThreadHashtable<HttpConnection> CURRENT_CONNECTIONS = HttpConnection.getThreadHashtableForConnections();
    private long timeStamp = System.currentTimeMillis();
    private int requests;
    WebConnector connector;
    private EndPoint endp;
    private WebServer server;
    private SocketConnection socket;
    private boolean idle = true;
    HttpURI uri = new HttpURI();
    HttpParser parser;
    HttpFields requestFields;
    HttpFieldsWrapper requestFieldsWrapper;
    Request request;
    private HttpParser.Input input;
    HttpGenerator generator;
    HttpFields responseFields;
    HttpFieldsWrapper responseFieldsWrapper;
    private Response response;
    Output output;
    private OutputWriter outputWriter;
    private PrintWriter printWriter;
    int include;
    private Object associatedObject;
    transient int connection = UNKNOWN;
    transient int expect = UNKNOWN;
    transient int version = UNKNOWN;
    transient boolean head = false;
    transient boolean host = false;

    private static ThreadHashtable<HttpConnection> getThreadHashtableForConnections() {
        ThreadHashtable<HttpConnection> th = new ThreadHashtable<HttpConnection>();
        NativeMethods.setJCREentry(th, false);
        return th;
    }

    public static HttpConnection getCurrentConnection() {
        return CURRENT_CONNECTIONS.get();
    }

    protected static void setCurrentConnection(HttpConnection connection) {
        CURRENT_CONNECTIONS.set(connection);
    }

    public HttpConnection(WebConnector connector, EndPoint endpoint, WebServer server, SocketConnection sock) {
        NativeMethods.setJCREentry(this, false);
        NativeMethods.setJCREentry(connector, false);
        NativeMethods.setJCREentry(endpoint, false);
        NativeMethods.setJCREentry(sock, false);
        this.socket = sock;
        this.connector = connector;
        this.endp = endpoint;
        this.parser = new HttpParser(this.connector, endpoint, new RequestHandler(), this.connector.getHeaderBufferSize(), this.connector.getRequestBufferSize());
        this.requestFields = new HttpFields();
        this.requestFieldsWrapper = new HttpFieldsWrapper(this.requestFields);
        NativeMethods.setJCREentry(this.requestFieldsWrapper, false);
        this.responseFields = new HttpFields();
        this.responseFieldsWrapper = new HttpFieldsWrapper(this.responseFields);
        NativeMethods.setJCREentry(this.responseFieldsWrapper, false);
        this.request = new Request(this);
        this.response = new Response(this);
        this.generator = new HttpGenerator(this, this.connector, this.endp, this.connector.getHeaderBufferSize(), this.connector.getResponseBufferSize());
        NativeMethods.setJCREentry(this.generator, false);
        this.server = server;
    }

    public void destroy() {
        if (this.parser != null) {
            this.parser.reset(true);
        }
        if (this.generator != null) {
            this.generator.reset(true);
        }
        if (this.requestFields != null) {
            this.requestFields.destroy();
        }
        if (this.responseFields != null) {
            this.responseFields.destroy();
        }
        this.server = null;
    }

    public int getRequests() {
        return this.requests;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Object getAssociatedObject() {
        return this.associatedObject;
    }

    public void setAssociatedObject(Object associatedObject) {
        this.associatedObject = associatedObject;
    }

    public WebConnector getConnector() {
        return this.connector;
    }

    public HttpFieldsWrapper getRequestFields() {
        return this.requestFieldsWrapper;
    }

    public HttpFieldsWrapper getResponseFields() {
        return this.responseFieldsWrapper;
    }

    public void resetHttpGeneratorBuffer() {
        this.generator.resetBuffer();
    }

    public boolean isConfidential(Request request) {
        if (this.connector != null) {
            return this.connector.isConfidential(request);
        }
        return false;
    }

    public boolean isIntegral(Request request) {
        if (this.connector != null) {
            return this.connector.isIntegral(request);
        }
        return false;
    }

    public EndPoint getEndPoint() {
        return this.endp;
    }

    public SocketConnection getSocketConnection() {
        return this.socket;
    }

    public String getLocalAddr() {
        String addr;
        String string = addr = this.endp == null ? null : this.endp.getLocalAddr();
        if (addr != null) {
            NativeMethods.transferOwnershipToPreviousContext(addr);
        }
        return addr;
    }

    public String getLocalName() {
        String host;
        String string = host = this.endp == null ? null : this.endp.getLocalHost();
        if (host != null) {
            NativeMethods.transferOwnershipToPreviousContext(host);
        }
        return host;
    }

    public int getLocalPort() {
        return this.endp == null ? 0 : this.endp.getLocalPort();
    }

    public String getRemoteAddr() {
        String remoteAddr;
        String string = remoteAddr = this.endp == null ? null : this.endp.getRemoteAddr();
        if (remoteAddr != null) {
            NativeMethods.transferOwnershipToPreviousContext(remoteAddr);
        }
        return remoteAddr;
    }

    public String getRemoteHost() {
        String remoteHost;
        String string = remoteHost = this.endp == null ? null : this.endp.getRemoteHost();
        if (remoteHost != null) {
            NativeMethods.transferOwnershipToPreviousContext(remoteHost);
        }
        return remoteHost;
    }

    public int getRemotePort() {
        return this.endp == null ? 0 : this.endp.getRemotePort();
    }

    public boolean getResolveNames() {
        return this.connector.getResolveNames();
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public ServletInputStream getInputStream() {
        if (this.input == null) {
            this.input = new HttpParser.Input(this.parser, this.connector.getMaxIdleTime());
            NativeMethods.setJCREentry(this.input, false);
        }
        return this.input;
    }

    public ServletOutputStream getOutputStream() {
        if (this.output == null) {
            this.output = new Output();
            NativeMethods.setJCREentry(this.output, false);
        }
        return this.output;
    }

    public PrintWriter getPrintWriter(String encoding) throws UnsupportedEncodingException {
        this.getOutputStream();
        if (this.outputWriter == null) {
            this.outputWriter = new OutputWriter();
            NativeMethods.setJCREentry(this.outputWriter, false);
            this.printWriter = new PrintWriter(this.outputWriter){

                @Override
                public void close() {
                    try {
                        HttpConnection.this.output.close();
                    }
                    catch (IOException e) {
                        Logger.debug(e);
                        this.setError();
                    }
                }
            };
            NativeMethods.setJCREentry(this.printWriter, false);
        }
        this.outputWriter.setCharacterEncoding(encoding);
        return this.printWriter;
    }

    public boolean isResponseCommitted() {
        return this.generator.isCommitted();
    }

    public void handle() throws IOException {
        boolean more_in_buffer = true;
        int no_progress = 0;
        while (more_in_buffer && this.endp.isOpen()) {
            block13: {
                this.idle = false;
                try {
                    HttpConnection.setCurrentConnection(this);
                    long io = 0L;
                    if (!this.parser.isState(0)) {
                        io = this.parser.parseAvailable();
                    }
                    if (this.generator.isState(3) || this.generator.isState(2)) {
                        io += this.generator.flushBuffers();
                    }
                    if (io > 0L) {
                        no_progress = 0;
                        break block13;
                    }
                    if (no_progress++ <= 10) break block13;
                }
                catch (HttpException e) {
                    try {
                        Logger.debug("uri=" + this.uri);
                        Logger.debug("fields=" + this.requestFields);
                        Logger.debug(e);
                        this.generator.sendError(e.getStatus(), e.getReason(), null, true);
                        Buffer header = this.parser.getHeaderBuffer();
                        header.skip(header.length());
                        throw e;
                    }
                    catch (Throwable throwable) {
                        HttpConnection.setCurrentConnection(null);
                        Buffer header = this.parser.getHeaderBuffer();
                        boolean bl = more_in_buffer = header != null && header.length() > 0;
                        if (this.parser.isState(0) && this.generator.isComplete()) {
                            this.idle = true;
                            if (!this.generator.isPersistent()) {
                                header.skip(header.length());
                            }
                            this.parser.reset(!more_in_buffer);
                            this.requestFields.clear();
                            this.request = new Request(this);
                            this.generator.reset(!more_in_buffer);
                            this.responseFields.clear();
                            this.response = new Response(this);
                            this.uri = new HttpURI();
                        }
                        throw throwable;
                    }
                }
                HttpConnection.setCurrentConnection(null);
                Buffer header = this.parser.getHeaderBuffer();
                boolean bl = more_in_buffer = header != null && header.length() > 0;
                if (this.parser.isState(0) && this.generator.isComplete()) {
                    this.idle = true;
                    if (!this.generator.isPersistent()) {
                        header.skip(header.length());
                    }
                    this.parser.reset(!more_in_buffer);
                    this.requestFields.clear();
                    this.request = new Request(this);
                    this.generator.reset(!more_in_buffer);
                    this.responseFields.clear();
                    this.response = new Response(this);
                    this.uri = new HttpURI();
                }
                return;
            }
            HttpConnection.setCurrentConnection(null);
            Buffer header = this.parser.getHeaderBuffer();
            boolean bl = more_in_buffer = header != null && header.length() > 0;
            if (!this.parser.isState(0) || !this.generator.isComplete()) continue;
            this.idle = true;
            if (!this.generator.isPersistent()) {
                header.skip(header.length());
            }
            this.parser.reset(!more_in_buffer);
            this.requestFields.clear();
            this.request = new Request(this);
            this.generator.reset(!more_in_buffer);
            this.responseFields.clear();
            this.response = new Response(this);
            this.uri = new HttpURI();
        }
    }

    private boolean shouldRedirectToHTTPS(String contextURIString) throws IOException {
        if (contextURIString == null) {
            return false;
        }
        int currentPort = this.getLocalPort();
        if (contextURIString.startsWith("/cardmanager")) {
            return false;
        }
        JCSystemAccessor accessor = JCSystemAccessor.getJCSystemAccessor();
        ApplicationImpl applicationInstance = (ApplicationImpl)Application.lookup(contextURIString);
        Logger.debug("########### shouldRedirectToHTTPS ################" + (applicationInstance == null));
        if (applicationInstance == null) {
            return false;
        }
        ModuleInfo moduleInfo = applicationInstance.getModuleInfo();
        if (moduleInfo != null && moduleInfo.isWebSecureAccessOnly()) {
            int portForModule = moduleInfo.getWebSecurePort();
            if (portForModule == -1) {
                if (!accessor.isContextInRedirectTable(contextURIString)) {
                    if (currentPort == this.connector.getPort()) {
                        return true;
                    }
                    throw new HttpException(404);
                }
                portForModule = accessor.getPortFromContext(contextURIString);
                Logger.debug("########### shouldRedirectToHTTPS ################ port for module" + (portForModule != currentPort));
                if (portForModule != currentPort) {
                    if (currentPort == this.connector.getPort()) {
                        return true;
                    }
                    throw new HttpException(404);
                }
                return false;
            }
            if (portForModule != currentPort) {
                if (currentPort == this.connector.getPort()) {
                    return true;
                }
                throw new HttpException(404);
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest() throws IOException {
        Logger.debug("########### handleRequest ################");
        int port = -1;
        boolean retry = false;
        boolean error = false;
        boolean requestIsHTTPS = false;
        if (this.uri.toString().startsWith("/shutdown")) {
            JCRuntime.exit(0);
        }
        try {
            ServletContext ctx;
            JCSystemAccessor accessor = JCSystemAccessor.getJCSystemAccessor();
            String contextURIStr = null;
            if (this.server != null && (ctx = this.server.getContext(this.uri.toString())) != null) {
                contextURIStr = ((ContextHandler.Context)ctx).getContextPath();
            }
            requestIsHTTPS = this.connector.isIntegral(this.request);
            Logger.debug("########### handleRequest ################" + contextURIStr + " " + requestIsHTTPS + " " + this.shouldRedirectToHTTPS(contextURIStr));
            if (contextURIStr != null && !requestIsHTTPS && this.shouldRedirectToHTTPS(contextURIStr)) {
                HttpConnection.doRedirect(this.request, this.response, contextURIStr);
                return;
            }
            if (contextURIStr != null && requestIsHTTPS) {
                if (!accessor.isContextInRedirectTable(contextURIStr)) {
                    throw new HttpException(404);
                }
                if (this.request.getServerPort() != accessor.getPortFromContext(contextURIStr)) {
                    throw new HttpException(404);
                }
            }
            if (this.server != null) {
                String info = URIUtil.canonicalPath(this.uri.getDecodedPath());
                if (info == null) {
                    throw new HttpException(400);
                }
                this.request.setPathInfo(info);
                if (this.output != null) {
                    this.output.reopen();
                }
                this.connector.customize(this.endp, this.request);
                this.server.handle(this);
            }
        }
        catch (RetryRequest r) {
            Logger.debug(r);
            retry = true;
        }
        catch (EofException e) {
            Logger.debug(e);
            error = true;
        }
        catch (ServletException e) {
            Logger.debug(e);
            this.request.setHandled(true);
            this.generator.sendError(500, null, null, true);
        }
        catch (HttpException e) {
            Logger.debug(e);
            this.request.setHandled(true);
            this.response.sendError(e.getStatus(), e.getReason());
        }
        catch (Exception ex) {
            Logger.debug(ex);
            this.request.setHandled(true);
            this.response.addIntHeader("JC-Status", 8888);
            this.response.sendError(500, "Unexpected Error.");
        }
        finally {
            if (!retry) {
                ++this.requests;
                if (!error && this.endp.isOpen()) {
                    if (!this.response.isCommitted() && !this.request.isHandled()) {
                        this.response.sendError(404);
                    }
                    this.response.complete();
                }
            }
        }
    }

    public void commitResponse(boolean last) throws IOException {
        if (!this.generator.isCommitted()) {
            this.generator.setResponse(this.response.getStatus(), this.response.getReason());
            this.generator.completeHeader(this.responseFields, last);
        }
        if (last) {
            this.generator.complete();
        }
    }

    public void completeResponse() throws IOException {
        if (!this.generator.isCommitted()) {
            this.generator.setResponse(this.response.getStatus(), this.response.getReason());
            this.generator.completeHeader(this.responseFields, true);
        }
        this.generator.complete();
    }

    public void flushResponse() throws IOException {
        try {
            this.commitResponse(false);
            this.generator.flushBuffers();
        }
        catch (IOException e) {
            throw e instanceof EofException ? e : new EofException(e);
        }
    }

    HttpGenerator getGenerator() {
        return this.generator;
    }

    public boolean isIncluding() {
        return this.include > 0;
    }

    public void include() {
        ++this.include;
    }

    public void included() {
        --this.include;
        if (this.output != null) {
            this.output.reopen();
        }
    }

    public boolean isIdle() {
        return this.idle;
    }

    public static void doRedirect(Request request, Response response, String contextURI) throws IOException {
        int redirectCode;
        int port;
        JCSystemAccessor accessor = JCSystemAccessor.getJCSystemAccessor();
        if (contextURI == null) {
            contextURI = request.getContextPath();
        }
        String uri = request.getRequestURI();
        if (!accessor.isContextInStaticRedirectTable(contextURI)) {
            if (!accessor.isContextInDynamicRedirectTable(contextURI)) {
                Logger.debug("########### Create dynamic connector ################");
                port = accessor.startNewConnector(contextURI);
            } else {
                port = accessor.getPortFromContext(contextURI);
            }
            redirectCode = 307;
        } else {
            port = accessor.getPortFromContext(contextURI);
            Logger.debug("org.mortbay.jetty.HttpConnection.handleRequest() -> Static port = " + port);
            redirectCode = 301;
        }
        if (port != -1) {
            StringBuffer sb = new StringBuffer();
            sb.append("https:");
            sb.append("//");
            sb.append(request.getServerName());
            sb.append(":");
            sb.append(port);
            sb.append(uri);
            if (request.getQueryString() != null) {
                sb.append("?");
                sb.append(request.getQueryString());
            }
            response.setContentLength(0);
            response.sendRedirect(sb.toString(), redirectCode);
        } else {
            response.sendError(500, "Secure port not open");
        }
    }

    public class OutputWriter
    extends HttpGenerator.OutputWriter {
        OutputWriter() {
            super(HttpConnection.this.output);
        }
    }

    public class Output
    extends HttpGenerator.Output {
        Output() {
            super(HttpConnection.this.generator, HttpConnection.this.connector.getMaxIdleTime());
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (!HttpConnection.this.isIncluding() && !this.generator.isCommitted()) {
                HttpConnection.this.commitResponse(true);
            } else {
                HttpConnection.this.flushResponse();
            }
            super.close();
        }

        @Override
        public void flush() throws IOException {
            if (!this.generator.isCommitted()) {
                HttpConnection.this.commitResponse(false);
            }
            super.flush();
        }

        @Override
        public void print(String s) throws IOException {
            if (this.closed) {
                throw new IOException("Closed");
            }
            PrintWriter writer = HttpConnection.this.getPrintWriter(null);
            writer.print(s);
        }

        public void sendContent(Object content) throws IOException {
            if (this.closed) {
                throw new IOException("Closed");
            }
            if (this.generator.getContentWritten() > 0L) {
                throw new IllegalStateException("!empty");
            }
            if (content instanceof HttpContent) {
                HttpContent c = (HttpContent)content;
                if (c.getContentType() != null && !HttpConnection.this.responseFieldsWrapper.containsKey(HttpHeaders.CONTENT_TYPE_BUFFER)) {
                    HttpConnection.this.responseFieldsWrapper.add(HttpHeaders.CONTENT_TYPE_BUFFER, c.getContentType());
                }
                if (c.getContentLength() > 0L) {
                    HttpConnection.this.responseFieldsWrapper.addLongField(HttpHeaders.CONTENT_LENGTH_BUFFER, c.getContentLength());
                }
                if (c.getLastModified() != null) {
                    HttpConnection.this.responseFieldsWrapper.add(HttpHeaders.LAST_MODIFIED_BUFFER, c.getLastModified());
                }
                if ((content = c.getBuffer()) == null) {
                    content = c.getInputStream();
                }
            }
            if (content instanceof Buffer) {
                this.generator.addContent((Buffer)content, true);
                HttpConnection.this.commitResponse(true);
            } else if (content instanceof InputStream) {
                InputStream in = (InputStream)content;
                int max = this.generator.prepareUncheckedAddContent();
                Buffer buffer = this.generator.getUncheckedBuffer();
                if (buffer instanceof ByteArrayBuffer) {
                    NativeMethods.transferOwnershipToPreviousContext(buffer.array());
                }
                int len = buffer.readFrom(in, max);
                while (len >= 0) {
                    this.generator.completeUncheckedAddContent();
                    HttpConnection.this.output.flush();
                    max = this.generator.prepareUncheckedAddContent();
                    buffer = this.generator.getUncheckedBuffer();
                    len = buffer.readFrom(in, max);
                }
                this.generator.completeUncheckedAddContent();
                HttpConnection.this.output.flush();
            } else {
                throw new IllegalArgumentException("unknown content type?");
            }
        }
    }

    class RequestHandler
    extends HttpParser.EventHandler {
        boolean delayedHandling = false;

        RequestHandler() {
        }

        @Override
        public void startRequest(Buffer method, Buffer uri, Buffer version) throws IOException {
            HttpConnection.this.host = false;
            HttpConnection.this.expect = UNKNOWN;
            HttpConnection.this.connection = UNKNOWN;
            this.delayedHandling = false;
            HttpConnection.this.request.setTimeStamp(System.currentTimeMillis());
            HttpConnection.this.request.setMethod(method.toString());
            try {
                byte[] uriArray = uri.array();
                byte[] tempArray = new byte[uriArray.length];
                System.arraycopy(uriArray, 0, tempArray, 0, uriArray.length);
                NativeMethods.transferOwnershipUsingSecondObject(tempArray, HttpConnection.this.uri);
                HttpConnection.this.uri.parse(tempArray, uri.getReadIndex(), uri.length());
                HttpConnection.this.request.setUri(HttpConnection.this.uri);
                if (version == null) {
                    version = HttpVersions.HTTP_0_9_BUFFER;
                }
                HttpConnection.this.version = HttpVersions.CACHE.getOrdinal(version);
                if (HttpConnection.this.version <= 0) {
                    HttpConnection.this.version = 10;
                }
                HttpConnection.this.request.setProtocol(version.toString());
                HttpConnection.this.head = method == HttpMethods.HEAD_BUFFER;
            }
            catch (Exception e) {
                throw new HttpException(400, null, e);
            }
        }

        @Override
        public void parsedHeader(Buffer name, Buffer value) {
            int ho = HttpHeaders.CACHE.getOrdinal(name);
            switch (ho) {
                case 27: {
                    HttpConnection.this.host = true;
                    break;
                }
                case 24: {
                    HttpConnection.this.expect = HttpHeaderValues.CACHE.getOrdinal(value);
                    break;
                }
                case 21: {
                    value = HttpHeaderValues.CACHE.lookup(value);
                    break;
                }
                case 16: {
                    String str = value.toString();
                    int ci = str.indexOf("charset=");
                    if (ci == -1) break;
                    HttpConnection.this.request._setCharacterEncoding(str.substring(ci += 8));
                    break;
                }
                case 1: {
                    HttpConnection.this.connection = HttpHeaderValues.CACHE.getOrdinal(value);
                    if (HttpConnection.this.connection < 0) {
                        HttpConnection.this.responseFields.put(HttpHeaders.CONNECTION_BUFFER, value);
                        break;
                    }
                    value = HttpHeaderValues.CACHE.get(HttpConnection.this.connection);
                    HttpConnection.this.responseFields.put(HttpHeaders.CONNECTION_BUFFER, value);
                }
            }
            HttpConnection.this.requestFields.add(name, value);
        }

        @Override
        public void headerComplete() throws IOException {
            HttpConnection.this.generator.setVersion(HttpConnection.this.version);
            switch (HttpConnection.this.version) {
                case 9: {
                    break;
                }
                case 10: {
                    HttpConnection.this.generator.setHead(HttpConnection.this.head);
                    break;
                }
                case 11: {
                    HttpConnection.this.generator.setHead(HttpConnection.this.head);
                    if (!HttpConnection.this.host) {
                        HttpConnection.this.generator.setResponse(400, null);
                        HttpConnection.this.responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                        HttpConnection.this.generator.completeHeader(HttpConnection.this.responseFields, true);
                        HttpConnection.this.generator.complete();
                        return;
                    }
                    if (HttpConnection.this.expect == UNKNOWN) break;
                    if (HttpConnection.this.expect == HttpHeaderValues.CONTINUE_ORDINAL) {
                        if (HttpConnection.this.parser.getHeaderBuffer() != null && HttpConnection.this.parser.getHeaderBuffer().length() >= 2) break;
                        HttpConnection.this.generator.setResponse(100, null);
                        HttpConnection.this.generator.completeHeader(null, true);
                        HttpConnection.this.generator.complete();
                        HttpConnection.this.generator.reset(false);
                        break;
                    }
                    HttpConnection.this.generator.sendError(417, null, null, true);
                    return;
                }
            }
            if (HttpConnection.this.parser.getContentLength() <= 0 && !HttpConnection.this.parser.isChunking()) {
                HttpConnection.this.handleRequest();
            } else {
                this.delayedHandling = true;
            }
        }

        @Override
        public void content(Buffer ref) throws IOException {
            if (this.delayedHandling) {
                this.delayedHandling = false;
                HttpConnection.this.handleRequest();
            }
        }

        @Override
        public void messageComplete(int contextLength) {
        }

        @Override
        public void startResponse(Buffer version, int status, Buffer reason) {
            throw new IllegalStateException("response");
        }
    }
}

