/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.io.Writer;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.StringUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ErrorHandler
extends AbstractHandler {
    boolean showStacks = true;

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException {
        HttpConnection.getCurrentConnection().getRequest().setHandled(true);
        response.setContentType("text/html; charset=ISO-8859-1");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(1024);
        HttpConnection connection = HttpConnection.getCurrentConnection();
        this.handleErrorPage(request, writer, connection.getResponse().getStatus(), connection.getResponse().getReason());
        writer.flush();
        response.setContentLength(writer.size());
        writer.writeTo(response.getOutputStream());
        writer.destroy();
    }

    protected void handleErrorPage(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
        ErrorHandler.writeErrorPage(request, writer, code, message, this.showStacks);
    }

    public static void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
        Throwable th;
        String uri;
        if (message != null) {
            message = StringUtil.replace(message, "&", "&amp;");
            message = StringUtil.replace(message, "<", "&lt;");
            message = StringUtil.replace(message, ">", "&gt;");
        }
        if ((uri = request.getRequestURI()) != null) {
            uri = StringUtil.replace(uri, "&", "&amp;");
            uri = StringUtil.replace(uri, "<", "&lt;");
            uri = StringUtil.replace(uri, ">", "&gt;");
        }
        writer.write("<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\"/>\n");
        writer.write("<title>Error ");
        writer.write(Integer.toString(code));
        writer.write(32);
        if (message == null) {
            message = HttpGenerator.getReason(code);
        }
        writer.write(message);
        writer.write("</title>\n</head>\n<body>\n<h2>HTTP ERROR: ");
        writer.write(Integer.toString(code));
        writer.write("</h2><pre>");
        writer.write(message);
        writer.write("</pre>\n");
        writer.write("<p>RequestURI=");
        writer.write(uri);
        writer.write("</p>\n<p><i><small><a href=\"http://jetty.mortbay.org\">Powered by Jetty://</a></small></i></p>");
        if (showStacks && (th = (Throwable)request.getAttribute("javax.servlet.error.exception")) != null) {
            writer.write("<h3>Caused by:</h3><pre>");
            th.printStackTrace();
            writer.write(th + ": " + th.getMessage());
            writer.write("</pre>\n");
        }
        for (int i = 0; i < 20; ++i) {
            writer.write("\n                                                ");
        }
        writer.write("\n</body>\n</html>\n");
    }

    public boolean isShowStacks() {
        return this.showStacks;
    }

    public void setShowStacks(boolean showStacks) {
        this.showStacks = showStacks;
    }
}

