/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.jetty.security.Credential;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Password
extends Credential {
    private String password;

    public Password(String password) {
        this.password = password;
        while (this.password != null && this.password.startsWith("OBF:")) {
            this.password = Password.deobfuscate(this.password);
        }
    }

    public String toString() {
        return this.password;
    }

    public String toStarString() {
        return "*****************************************************".substring(0, this.password.length());
    }

    @Override
    public boolean check(Object credentials) {
        if (this == credentials) {
            return true;
        }
        if (credentials instanceof Password) {
            return credentials.equals(this.password);
        }
        if (credentials instanceof String) {
            return credentials.equals(this.password);
        }
        if (credentials instanceof Credential) {
            return ((Credential)credentials).check(this.password);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o) {
            return false;
        }
        if (o instanceof Password) {
            Password p = (Password)o;
            return p.password == this.password || null != this.password && this.password.equals(p.password);
        }
        if (o instanceof String) {
            return o.equals(this.password);
        }
        return false;
    }

    public int hashCode() {
        return null == this.password ? super.hashCode() : this.password.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obfuscate(String s) {
        StringBuffer buf = new StringBuffer();
        byte[] b = s.getBytes();
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            buf.append("OBF:");
            for (int i = 0; i < b.length; ++i) {
                byte b1 = b[i];
                byte b2 = b[s.length() - (i + 1)];
                int i1 = 127 + b1 + b2;
                int i2 = 127 + b1 - b2;
                int i0 = i1 * 256 + i2;
                String x = Integer.toString(i0, 36);
                switch (x.length()) {
                    case 1: {
                        buf.append('0');
                    }
                    case 2: {
                        buf.append('0');
                    }
                    case 3: {
                        buf.append('0');
                    }
                }
                buf.append(x);
            }
            return buf.toString();
        }
    }

    public static String deobfuscate(String s) {
        if (s.startsWith("OBF:")) {
            s = s.substring(4);
        }
        byte[] b = new byte[s.length() / 2];
        int l = 0;
        for (int i = 0; i < s.length(); i += 4) {
            String x = s.substring(i, i + 4);
            int i0 = Integer.parseInt(x, 36);
            int i1 = i0 / 256;
            int i2 = i0 % 256;
            b[l++] = (byte)((i1 + i2 - 254) / 2);
        }
        return new String(b, 0, l);
    }
}

