/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import com.sun.javacard.impl.NativeMethods;
import java.util.Random;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.util.MultiMap;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class HashSessionIdManager
extends AbstractLifeCycle
implements SessionIdManager {
    private static final String NEW_SESSION_ID = "org.mortbay.jetty.newSessionId";
    MultiMap<HttpSession> sessions;
    protected Random random;
    private String workerName;

    public HashSessionIdManager() {
    }

    public HashSessionIdManager(Random random) {
        this.random = random;
    }

    public String getWorkerName() {
        return this.workerName;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }

    @Override
    protected void doStart() {
        if (this.random == null) {
            this.random = new Random();
        }
        this.random.nextLong();
        this.sessions = new MultiMap();
    }

    @Override
    protected void doStop() {
        if (this.sessions != null) {
            this.sessions.clear();
        }
        this.sessions = null;
    }

    @Override
    public boolean idInUse(String id) {
        return this.sessions.containsKey(id);
    }

    @Override
    public void addSession(HttpSession session) {
        this.sessions.add(session.getId(), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll(String id) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            while (this.sessions.containsKey(id)) {
                AbstractSessionManager.Session session = (AbstractSessionManager.Session)this.sessions.getValue(id, 0);
                if (session.isValid()) {
                    session.invalidate();
                    continue;
                }
                this.sessions.removeValue(id, session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String newSessionId(HttpServletRequest request, long created) {
        HashSessionIdManager hashSessionIdManager = this;
        synchronized (hashSessionIdManager) {
            String requested_id = request.getRequestedSessionId();
            if (requested_id != null && this.idInUse(requested_id)) {
                return requested_id;
            }
            String new_id = (String)request.getAttribute(NEW_SESSION_ID);
            if (new_id != null && this.idInUse(new_id)) {
                return new_id;
            }
            String id = null;
            while (id == null || id.length() == 0 || this.idInUse(id)) {
                long r = this.random.nextLong();
                if (r < 0L) {
                    r = -r;
                }
                id = Long.toString(r, 30 + (int)(created % 7L));
                String worker = (String)request.getAttribute("org.mortbay.http.ajp.JVMRoute");
                if (worker != null) {
                    id = id + "." + worker;
                    continue;
                }
                if (this.workerName == null) continue;
                id = id + "." + this.workerName;
            }
            NativeMethods.transferOwnershipToPreviousContext(id);
            request.setAttribute(NEW_SESSION_ID, id);
            return id;
        }
    }
}

