/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import com.sun.javacard.Logger;
import java.io.IOException;
import java.util.EventListener;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.servlet.HashSessionManager;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class SessionHandler
extends HandlerWrapper {
    private SessionManager sessionManager;

    public SessionHandler() {
        this(new HashSessionManager());
    }

    public SessionHandler(SessionManager manager) {
        this.setSessionManager(manager);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        SessionManager old_session_manager = this.sessionManager;
        if (sessionManager != null) {
            sessionManager.setSessionHandler(this);
        }
        this.sessionManager = sessionManager;
        if (old_session_manager != null) {
            old_session_manager.setSessionHandler(null);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.sessionManager.start();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.sessionManager.stop();
    }

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        SessionManager old_session_manager = null;
        HttpSession old_session = null;
        try {
            String requested_session_id = request.getRequestedSessionId();
            if (dispatch == 1 && requested_session_id == null) {
                boolean requested_session_id_from_cookie = false;
                Cookie[] cookies = request.getCookies();
                if (cookies != null && cookies.length > 0) {
                    for (Cookie element : cookies) {
                        if (!this.sessionManager.getSessionCookie().equalsIgnoreCase(element.getName())) continue;
                        if (requested_session_id != null && this.sessionManager.getHttpSession(requested_session_id) != null) break;
                        requested_session_id = element.getValue();
                        requested_session_id_from_cookie = true;
                        Logger.debug("Got Session ID " + requested_session_id + " from cookie");
                    }
                }
                if (requested_session_id == null) {
                    String path_params;
                    Logger.debug("SESSION HANDLER: session id: is null ");
                    String uri = request.getRequestURI();
                    Logger.debug("SESSION HANDLER: uri: " + uri);
                    int semi = uri.lastIndexOf(59);
                    if (semi >= 0 && (path_params = uri.substring(semi + 1)) != null && path_params.startsWith(this.sessionManager.getSessionURL())) {
                        requested_session_id = path_params.substring(this.sessionManager.getSessionURL().length() + 1);
                        Logger.debug("Got Session ID " + requested_session_id + " from URL");
                    }
                }
                base_request.setRequestedSessionId(requested_session_id);
                base_request.setRequestedSessionIdFromCookie(requested_session_id != null && requested_session_id_from_cookie);
            }
            old_session_manager = base_request.getSessionManager();
            old_session = base_request.getSession(false);
            if (old_session_manager != this.sessionManager) {
                base_request.setSessionManager(this.sessionManager);
                base_request.setSession(null);
            }
            HttpSession session = null;
            if (this.sessionManager != null) {
                Logger.debug("session@" + request.getSession(false));
                session = request.getSession(false);
                if (session != null) {
                    if (session != old_session) {
                        this.sessionManager.access(session);
                    }
                } else {
                    session = base_request.recoverNewSession(this.sessionManager);
                    Logger.debug("session#" + session);
                    if (session != null) {
                        base_request.setSession(session);
                    }
                }
            } else {
                Logger.debug("sessionManager=" + this.sessionManager);
                Logger.debug("session=" + session);
            }
            this.getHandler().handle(target, request, response, dispatch);
        }
        catch (RetryRequest r) {
            HttpSession session = base_request.getSession(false);
            if (session != null && session.isNew()) {
                base_request.saveNewSession(this.sessionManager, session);
            }
            throw r;
        }
        finally {
            HttpSession session = request.getSession(false);
            if (session != null && session != old_session) {
                this.getSessionManager().complete(session);
            }
            base_request.setSessionManager(old_session_manager);
            base_request.setSession(old_session);
        }
    }

    public void addEventListener(EventListener listener) {
        if (this.sessionManager != null) {
            this.sessionManager.addEventListener(listener);
        }
    }

    public void clearEventListeners() {
        if (this.sessionManager != null) {
            this.sessionManager.clearEventListeners();
        }
    }
}

