/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.thread;

import com.sun.javacard.Logger;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Timeout {
    private long duration;
    private long now;
    private Task head = new Task();

    public Timeout() {
        this.head.timeout = this;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setNow() {
        this.now = System.currentTimeMillis();
    }

    public long getNow() {
        return this.now;
    }

    public void setNow(long now) {
        this.now = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task expired() {
        long _expiry = this.now - this.duration;
        if (this.head.next != this.head) {
            Task task = this.head.next;
            if (task.timestamp > _expiry) {
                return null;
            }
            task.unlink();
            Task task2 = task;
            synchronized (task2) {
                task.expired = true;
            }
            return task;
        }
        return null;
    }

    public void tick() {
        long _expiry = this.now - this.duration;
        while (this.head.next != this.head) {
            Task task = this.head.next;
            if (task.timestamp > _expiry) break;
            task.unlink();
            try {
                task.doExpire();
            }
            catch (Throwable th) {
                Logger.debug(th);
            }
        }
    }

    public void schedule(Task task) {
        this.schedule(task, 0L);
    }

    public void schedule(Task task, long delay) {
        if (task.timestamp != 0L) {
            task.unlink();
            task.timestamp = 0L;
        }
        task.expired = false;
        task.delay = delay;
        task.timestamp = this.now + delay;
        Task last = this.head.prev;
        while (last != this.head && last.timestamp > task.timestamp) {
            last = last.prev;
        }
        last.setNext(task);
    }

    public void cancelAll() {
        this.head.next = this.head.prev = this.head;
    }

    public boolean isEmpty() {
        return this.head.next == this.head;
    }

    public long getTimeToNext() {
        if (this.head.next == this.head) {
            return -1L;
        }
        long to_next = this.duration + this.head.next.timestamp - this.now;
        return to_next < 0L ? 0L : to_next;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        Task task = this.head.next;
        while (task != this.head) {
            buf.append("-->");
            buf.append(task);
            task = task.next;
        }
        return buf.toString();
    }

    public static class Task {
        Task next = this.prev = this;
        Task prev;
        Timeout timeout;
        long delay;
        long timestamp = 0L;
        boolean expired = false;

        public void unlink() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
            this.next = this.prev = this;
            this.timeout = null;
            this.expired = false;
        }

        public void setNext(Task task) {
            if (this.timeout == null || task.timeout != null && task.timeout != this.timeout || task.next != task) {
                throw new IllegalStateException();
            }
            Task next_next = this.next;
            this.next.prev = task;
            this.next = task;
            this.next.next = next_next;
            this.next.prev = this;
            this.next.timeout = this.timeout;
        }

        public void schedule(Timeout timer) {
            this.unlink();
            timer.schedule(this);
        }

        public void schedule(Timeout timer, long delay) {
            this.unlink();
            timer.schedule(this, delay);
        }

        public void reschedule() {
            Timeout timer = this.timeout;
            this.unlink();
            timer.schedule(this, this.delay);
        }

        public void cancel() {
            this.timestamp = 0L;
            this.unlink();
        }

        public boolean isExpired() {
            return this.expired;
        }

        public void expire() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doExpire() {
            Task task = this;
            synchronized (task) {
                this.expired = true;
                this.expire();
            }
        }
    }
}

