/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.StringUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ByteArrayISO8859Writer
extends Writer {
    private byte[] buffer;
    private int size;
    private ByteArrayOutputStream2 bos = null;
    private OutputStreamWriter writer = null;
    private boolean fixed = false;

    public ByteArrayISO8859Writer() {
        this.buffer = new byte[2048];
    }

    public ByteArrayISO8859Writer(int capacity) {
        this.buffer = new byte[capacity];
    }

    public ByteArrayISO8859Writer(byte[] buf) {
        this.buffer = buf;
        this.fixed = true;
    }

    public Object getLock() {
        return this.lock;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int spareCapacity() {
        return this.buffer.length - this.size;
    }

    public void setLength(int l) {
        this.size = l;
    }

    public byte[] getBuf() {
        return this.buffer;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.size);
    }

    public void write(char c) throws IOException {
        this.ensureSpareCapacity(1);
        if (c >= '\u0000' && c <= '\u007f') {
            this.buffer[this.size++] = (byte)c;
        } else {
            char[] ca = new char[]{c};
            this.writeEncoded(ca, 0, 1);
        }
    }

    @Override
    public void write(char[] ca) throws IOException {
        this.ensureSpareCapacity(ca.length);
        for (int i = 0; i < ca.length; ++i) {
            char c = ca[i];
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(ca, i, ca.length - i);
                break;
            }
            this.buffer[this.size++] = (byte)c;
        }
    }

    @Override
    public void write(char[] ca, int offset, int length) throws IOException {
        this.ensureSpareCapacity(length);
        for (int i = 0; i < length; ++i) {
            char c = ca[offset + i];
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(ca, offset + i, length - i);
                break;
            }
            this.buffer[this.size++] = (byte)c;
        }
    }

    @Override
    public void write(String s) throws IOException {
        if (s == null) {
            this.write("null", 0, 4);
            return;
        }
        int length = s.length();
        this.ensureSpareCapacity(length);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(s.toCharArray(), i, length - i);
                break;
            }
            this.buffer[this.size++] = (byte)c;
        }
    }

    @Override
    public void write(String s, int offset, int length) throws IOException {
        this.ensureSpareCapacity(length);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(offset + i);
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(s.toCharArray(), offset + i, length - i);
                break;
            }
            this.buffer[this.size++] = (byte)c;
        }
    }

    private void writeEncoded(char[] ca, int offset, int length) throws IOException {
        if (this.bos == null) {
            this.bos = new ByteArrayOutputStream2(2 * length);
            this.writer = new OutputStreamWriter(this.bos, StringUtil.ISO_8859_1);
        } else {
            this.bos.reset();
        }
        this.writer.write(ca, offset, length);
        this.writer.flush();
        this.ensureSpareCapacity(this.bos.getCount());
        System.arraycopy(this.bos.getBuf(), 0, this.buffer, this.size, this.bos.getCount());
        this.size += this.bos.getCount();
    }

    @Override
    public void flush() {
    }

    public void resetWriter() {
        this.size = 0;
    }

    @Override
    public void close() {
    }

    public void destroy() {
        this.buffer = null;
    }

    public void ensureSpareCapacity(int n) throws IOException {
        if (this.size + n > this.buffer.length) {
            if (this.fixed) {
                throw new IOException("Buffer overflow: " + this.buffer.length);
            }
            byte[] buf = new byte[(this.buffer.length + n) * 4 / 3];
            System.arraycopy(this.buffer, 0, buf, 0, this.size);
            this.buffer = buf;
        }
    }

    public byte[] getByteArray() {
        byte[] data = new byte[this.size];
        System.arraycopy(this.buffer, 0, data, 0, this.size);
        return data;
    }
}

