/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.instructions.JInstrMethodRef;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.constants.JcConstantStaticMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantVirtualMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstrInterfaceRef;
import com.sun.javacard.jcfile.instructions.JcInstrMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;

class InstrMethodRefConverter
extends InstructionConverter {
    public InstrMethodRefConverter(InstrContainer instrContainer, MethodConverter methodConverter) {
        super(instrContainer, methodConverter);
    }

    @Override
    public JcInstruction convert() throws Exception {
        JInstrMethodRef jInstrMethodRef = (JInstrMethodRef)this.java_instr;
        String string = jInstrMethodRef.getClassName();
        String string2 = jInstrMethodRef.getMethodName();
        String string3 = jInstrMethodRef.getDescriptor();
        this.checkParamAndReturnTypes(string, string2, string3);
        int[] nArray = MethodDescriptor.getParamTypes(string3);
        int n = MethodDescriptor.getReturnType(string3);
        this.checkParamTypesAgainstStackEntryTypes(nArray);
        for (int n2 : nArray) {
            this.operand_stack.pop();
        }
        int n3 = jInstrMethodRef.getOpcode();
        JcConstantPool jcConstantPool = this.method_converter.getJcConstantPool();
        switch (n3) {
            case 182: {
                this.operand_stack.pop();
                JcConstantVirtualMethodRef jcConstantVirtualMethodRef = jcConstantPool.addConstantVirtualMethodRef(string, string2, string3);
                this.checkRef(jcConstantVirtualMethodRef);
                this.jc_instr = new JcInstrMethodRef(139, jcConstantVirtualMethodRef);
                if (n != 9) {
                    this.operand_stack.push(n, this.instr_container);
                }
                return this.jc_instr;
            }
            case 183: {
                this.operand_stack.pop();
                JcConstantMethodRef jcConstantMethodRef = this.getMethodRef(string, string2, string3);
                this.jc_instr = new JcInstrMethodRef(140, jcConstantMethodRef);
                if (n != 9) {
                    this.operand_stack.push(n, this.instr_container);
                }
                return this.jc_instr;
            }
            case 184: {
                JcConstantStaticMethodRef jcConstantStaticMethodRef = jcConstantPool.addConstantStaticMethodRef(string, string2, string3);
                this.jc_instr = new JcInstrMethodRef(141, jcConstantStaticMethodRef);
                if (n != 9) {
                    this.operand_stack.push(n, this.instr_container);
                }
                return this.jc_instr;
            }
            case 185: {
                int n2;
                this.operand_stack.pop();
                JcConstantClassRef jcConstantClassRef = jcConstantPool.addConstantClassRef(string);
                n2 = MethodDescriptor.getParamSize(string3) + 1;
                int n4 = this.getMethodToken(string, string2, string3);
                this.jc_instr = new JcInstrInterfaceRef(142, n2, jcConstantClassRef, n4);
                if (n != 9) {
                    this.operand_stack.push(n, this.instr_container);
                }
                return this.jc_instr;
            }
        }
        throw new ConverterInternalError();
    }

    private JcConstantMethodRef getMethodRef(String string, String string2, String string3) {
        JMethod[] jMethodArray;
        JcConstantPool jcConstantPool = this.method_converter.getJcConstantPool();
        if (string2.equals("<init>")) {
            return jcConstantPool.addConstantStaticMethodRef(string, string2, string3);
        }
        JClassFile jClassFile = this.method_converter.getClassConverter().getJavaClass();
        for (JMethod jMethod : jMethodArray = jClassFile.getMethods()) {
            int n = jMethod.getAccessFlags();
            if (!Modifier.isPrivate(n) || !jMethod.getMethodName().equals(string2) || !jMethod.getMethodDescriptor().equals(string3)) continue;
            return jcConstantPool.addConstantStaticMethodRef(string, string2, string3);
        }
        return jcConstantPool.addConstantSuperMethodRef(jClassFile.getClassName(), string2, string3);
    }

    private void checkParamAndReturnTypes(String string, String string2, String string3) throws Exception {
        String[] stringArray = MethodDescriptor.getParamDescriptors(string3);
        String string4 = MethodDescriptor.getReturnDescriptor(string3);
        for (int i = stringArray.length - 1; i >= 0; --i) {
            Object[] objectArray;
            if (!stringArray[i].equals("I") && !stringArray[i].equals("[I")) continue;
            if (this.method_converter.isIntSupported()) {
                objectArray = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(string.replace('/', '.') + "." + string2)};
                Notifier.progress(this.java_instr.getSourceLineNumber(), "warning.2", objectArray);
                this.method_converter.getPackageConverter().setIntFlag(true);
                continue;
            }
            objectArray = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(string.replace('/', '.') + "." + string2)};
            Notifier.error(this.java_instr.getSourceLineNumber(), "int.2", objectArray);
            throw new ConversionException();
        }
        if (string4.equals("I") || string4.equals("[I")) {
            if (this.method_converter.isIntSupported()) {
                Object[] objectArray = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(string.replace('/', '.') + "." + string2)};
                Notifier.progress(this.java_instr.getSourceLineNumber(), "warning.3", objectArray);
                this.method_converter.getPackageConverter().setIntFlag(true);
            } else {
                Object[] objectArray = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(string.replace('/', '.') + "." + string2)};
                Notifier.error(this.java_instr.getSourceLineNumber(), "int.3", objectArray);
                throw new ConversionException();
            }
        }
    }

    private void checkParamTypesAgainstStackEntryTypes(int[] nArray) throws Exception {
        block5: for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray.length - i;
            OperandStackEntry operandStackEntry = this.operand_stack.peek(n);
            switch (nArray[i]) {
                case 3: {
                    if (operandStackEntry.getType() == 3) continue block5;
                    operandStackEntry.rollBack();
                    continue block5;
                }
                case 2: {
                    if (operandStackEntry.getType() != 3) continue block5;
                    if (this.method_converter.getLocalVariableConverter().getDefinedLocalVariablesSize() == 0) {
                        operandStackEntry.rollBack(true);
                        continue block5;
                    }
                    Object[] objectArray = new Object[]{this.method_converter.getClassName().replace('/', '.'), "" + i};
                    Notifier.error(this.java_instr.getSourceLineNumber(), "conversion.21", objectArray);
                    throw new ConversionException();
                }
                case 1: {
                    if (operandStackEntry.getType() != 3) continue block5;
                    if (this.method_converter.getLocalVariableConverter().getDefinedLocalVariablesSize() == 0) {
                        operandStackEntry.rollBack(true);
                        continue block5;
                    }
                    Object[] objectArray = new Object[]{this.method_converter.getClassName().replace('/', '.'), "" + i};
                    Notifier.error(this.java_instr.getSourceLineNumber(), "conversion.21", objectArray);
                    throw new ConversionException();
                }
            }
        }
    }

    private int getMethodToken(String string, String string2, String string3) throws Exception {
        PackageConverter packageConverter = this.method_converter.getPackageConverter();
        String string4 = packageConverter.getJcPackage().getPackageName();
        if (Names.getPackageName(string).equals(string4)) {
            JcClass jcClass = packageConverter.getJcClass(string);
            if (jcClass == null) {
                Object[] objectArray = new String[]{this.method_converter.getClassName().replace('/', '.'), string.replace('/', '.')};
                Notifier.error(this.java_instr.getSourceLineNumber(), "linking.21", objectArray);
                throw new ConversionException();
            }
            MethodDefinition[] methodDefinitionArray = jcClass.getPublicMethodTable().getMethods();
            for (int i = 0; i < methodDefinitionArray.length; ++i) {
                if (!methodDefinitionArray[i].getMethodName().equals(string2) || !methodDefinitionArray[i].getMethodDescriptor().equals(string3)) continue;
                return i;
            }
            Object[] objectArray = new String[]{this.method_converter.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(string2, string3), string.replace('/', '.')};
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.17", objectArray);
            throw new ConversionException();
        }
        ExportFileManager exportFileManager = packageConverter.getExportFileManager();
        EfClass efClass = exportFileManager.getClass(string);
        if (efClass == null) {
            Object[] objectArray = new String[]{this.method_converter.getClassName().replace('/', '.'), string.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string))};
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.20", objectArray);
            throw new ConversionException();
        }
        EfMethod efMethod = efClass.getMethod(string2, string3);
        if (efMethod == null) {
            Object[] objectArray = new String[]{this.method_converter.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(string2, string3), string.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string))};
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.20", objectArray);
            throw new ConversionException();
        }
        return efMethod.getMethodToken();
    }

    private void checkRef(JcConstantVirtualMethodRef jcConstantVirtualMethodRef) throws Exception {
        if (this.method_converter.getClassName().equals(jcConstantVirtualMethodRef.getClassName())) {
            return;
        }
        PackageConverter packageConverter = this.method_converter.getPackageConverter();
        JcClass jcClass = packageConverter.getJcClass(jcConstantVirtualMethodRef.getClassName());
        if (jcClass == null) {
            return;
        }
        JcMethod jcMethod = jcClass.getMethod(jcConstantVirtualMethodRef.getMethodName(), jcConstantVirtualMethodRef.getDescriptor());
        Object[] objectArray = new String[]{this.method_converter.getMethodName(), this.method_converter.getClassName().replace('/', '.'), jcConstantVirtualMethodRef.getMethodName(), jcConstantVirtualMethodRef.getClassName().replace('/', '.')};
        if (jcMethod == null && !jcClass.hasVirtualMethod(jcConstantVirtualMethodRef.getMethodName(), jcConstantVirtualMethodRef.getDescriptor())) {
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.26", objectArray);
            throw new ConversionException();
        }
        if (jcMethod != null && jcMethod.isPrivate()) {
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.25", objectArray);
            throw new ConversionException();
        }
    }
}

