// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "BSSAP_Types.hh"

namespace BSSAP__Types {

/* Member functions of C++ classes */

BSSMAP__FIELD__LAC__RNC__CI::BSSMAP__FIELD__LAC__RNC__CI()
{
}

BSSMAP__FIELD__LAC__RNC__CI::BSSMAP__FIELD__LAC__RNC__CI(const OCTETSTRING& par_mcc__mnc,
    const OCTETSTRING& par_lac,
    const OCTETSTRING& par_rncId,
    const OCTETSTRING& par_ci)
  :   field_mcc__mnc(par_mcc__mnc),
  field_lac(par_lac),
  field_rncId(par_rncId),
  field_ci(par_ci)
{
}

BSSMAP__FIELD__LAC__RNC__CI::BSSMAP__FIELD__LAC__RNC__CI(const BSSMAP__FIELD__LAC__RNC__CI& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
if (other_value.mcc__mnc().is_bound()) field_mcc__mnc = other_value.mcc__mnc();
else field_mcc__mnc.clean_up();
if (other_value.lac().is_bound()) field_lac = other_value.lac();
else field_lac.clean_up();
if (other_value.rncId().is_bound()) field_rncId = other_value.rncId();
else field_rncId.clean_up();
if (other_value.ci().is_bound()) field_ci = other_value.ci();
else field_ci.clean_up();
}

void BSSMAP__FIELD__LAC__RNC__CI::clean_up()
{
field_mcc__mnc.clean_up();
field_lac.clean_up();
field_rncId.clean_up();
field_ci.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__FIELD__LAC__RNC__CI::get_descriptor() const { return &BSSMAP__FIELD__LAC__RNC__CI_descr_; }
BSSMAP__FIELD__LAC__RNC__CI& BSSMAP__FIELD__LAC__RNC__CI::operator=(const BSSMAP__FIELD__LAC__RNC__CI& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
  if (other_value.mcc__mnc().is_bound()) field_mcc__mnc = other_value.mcc__mnc();
  else field_mcc__mnc.clean_up();
  if (other_value.lac().is_bound()) field_lac = other_value.lac();
  else field_lac.clean_up();
  if (other_value.rncId().is_bound()) field_rncId = other_value.rncId();
  else field_rncId.clean_up();
  if (other_value.ci().is_bound()) field_ci = other_value.ci();
  else field_ci.clean_up();
}
return *this;
}

boolean BSSMAP__FIELD__LAC__RNC__CI::operator==(const BSSMAP__FIELD__LAC__RNC__CI& other_value) const
{
return field_mcc__mnc==other_value.field_mcc__mnc
  && field_lac==other_value.field_lac
  && field_rncId==other_value.field_rncId
  && field_ci==other_value.field_ci;
}

boolean BSSMAP__FIELD__LAC__RNC__CI::is_bound() const
{
return (field_mcc__mnc.is_bound())
  || (field_lac.is_bound())
  || (field_rncId.is_bound())
  || (field_ci.is_bound());
}
boolean BSSMAP__FIELD__LAC__RNC__CI::is_value() const
{
return field_mcc__mnc.is_value()
  && field_lac.is_value()
  && field_rncId.is_value()
  && field_ci.is_value();
}
void BSSMAP__FIELD__LAC__RNC__CI::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ mcc_mnc := ");
field_mcc__mnc.log();
TTCN_Logger::log_event_str(", lac := ");
field_lac.log();
TTCN_Logger::log_event_str(", rncId := ");
field_rncId.log();
TTCN_Logger::log_event_str(", ci := ");
field_ci.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__FIELD__LAC__RNC__CI::set_implicit_omit()
{
if (mcc__mnc().is_bound()) mcc__mnc().set_implicit_omit();
if (lac().is_bound()) lac().set_implicit_omit();
if (rncId().is_bound()) rncId().set_implicit_omit();
if (ci().is_bound()) ci().set_implicit_omit();
}

void BSSMAP__FIELD__LAC__RNC__CI::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) mcc__mnc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lac().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rncId().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ci().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcc_mnc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcc__mnc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rncId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rncId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ci")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ci().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI");
  }
}

void BSSMAP__FIELD__LAC__RNC__CI::encode_text(Text_Buf& text_buf) const
{
field_mcc__mnc.encode_text(text_buf);
field_lac.encode_text(text_buf);
field_rncId.encode_text(text_buf);
field_ci.encode_text(text_buf);
}

void BSSMAP__FIELD__LAC__RNC__CI::decode_text(Text_Buf& text_buf)
{
field_mcc__mnc.decode_text(text_buf);
field_lac.decode_text(text_buf);
field_rncId.decode_text(text_buf);
field_ci.decode_text(text_buf);
}

void BSSMAP__FIELD__LAC__RNC__CI::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__LAC__RNC__CI::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__LAC__RNC__CI::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT3_descr_.raw->forceomit);
  decoded_field_length = field_mcc__mnc.RAW_decode(General__Types::OCT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_lac.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_rncId.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_ci.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__FIELD__LAC__RNC__CI::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT3_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT2_descr_.raw);
  encoded_length += field_mcc__mnc.RAW_encode(General__Types::OCT3_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_lac.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_rncId.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_ci.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct BSSMAP__FIELD__LAC__RNC__CI_template::single_value_struct {
OCTETSTRING_template field_mcc__mnc;
OCTETSTRING_template field_lac;
OCTETSTRING_template field_rncId;
OCTETSTRING_template field_ci;
};

void BSSMAP__FIELD__LAC__RNC__CI_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_mcc__mnc = ANY_VALUE;
single_value->field_lac = ANY_VALUE;
single_value->field_rncId = ANY_VALUE;
single_value->field_ci = ANY_VALUE;
}
}
}

void BSSMAP__FIELD__LAC__RNC__CI_template::copy_value(const BSSMAP__FIELD__LAC__RNC__CI& other_value)
{
single_value = new single_value_struct;
if (other_value.mcc__mnc().is_bound()) {
  single_value->field_mcc__mnc = other_value.mcc__mnc();
} else {
  single_value->field_mcc__mnc.clean_up();
}
if (other_value.lac().is_bound()) {
  single_value->field_lac = other_value.lac();
} else {
  single_value->field_lac.clean_up();
}
if (other_value.rncId().is_bound()) {
  single_value->field_rncId = other_value.rncId();
} else {
  single_value->field_rncId.clean_up();
}
if (other_value.ci().is_bound()) {
  single_value->field_ci = other_value.ci();
} else {
  single_value->field_ci.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__LAC__RNC__CI_template::copy_template(const BSSMAP__FIELD__LAC__RNC__CI_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.mcc__mnc().get_selection()) {
single_value->field_mcc__mnc = other_value.mcc__mnc();
} else {
single_value->field_mcc__mnc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lac().get_selection()) {
single_value->field_lac = other_value.lac();
} else {
single_value->field_lac.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rncId().get_selection()) {
single_value->field_rncId = other_value.rncId();
} else {
single_value->field_rncId.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ci().get_selection()) {
single_value->field_ci = other_value.ci();
} else {
single_value->field_ci.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__LAC__RNC__CI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__LAC__RNC__CI_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__LAC__RNC__CI_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
break;
}
set_selection(other_value);
}

BSSMAP__FIELD__LAC__RNC__CI_template::BSSMAP__FIELD__LAC__RNC__CI_template()
{
}

BSSMAP__FIELD__LAC__RNC__CI_template::BSSMAP__FIELD__LAC__RNC__CI_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__LAC__RNC__CI_template::BSSMAP__FIELD__LAC__RNC__CI_template(const BSSMAP__FIELD__LAC__RNC__CI& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__LAC__RNC__CI_template::BSSMAP__FIELD__LAC__RNC__CI_template(const OPTIONAL<BSSMAP__FIELD__LAC__RNC__CI>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__LAC__RNC__CI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI from an unbound optional field.");
}
}

BSSMAP__FIELD__LAC__RNC__CI_template::BSSMAP__FIELD__LAC__RNC__CI_template(BSSMAP__FIELD__LAC__RNC__CI_template* p_precondition, BSSMAP__FIELD__LAC__RNC__CI_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__LAC__RNC__CI_template::BSSMAP__FIELD__LAC__RNC__CI_template(Dynamic_Match_Interface<BSSMAP__FIELD__LAC__RNC__CI>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__LAC__RNC__CI>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__LAC__RNC__CI_template::BSSMAP__FIELD__LAC__RNC__CI_template(const BSSMAP__FIELD__LAC__RNC__CI_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__FIELD__LAC__RNC__CI_template::~BSSMAP__FIELD__LAC__RNC__CI_template()
{
clean_up();
}

BSSMAP__FIELD__LAC__RNC__CI_template& BSSMAP__FIELD__LAC__RNC__CI_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__LAC__RNC__CI_template& BSSMAP__FIELD__LAC__RNC__CI_template::operator=(const BSSMAP__FIELD__LAC__RNC__CI& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__LAC__RNC__CI_template& BSSMAP__FIELD__LAC__RNC__CI_template::operator=(const OPTIONAL<BSSMAP__FIELD__LAC__RNC__CI>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__LAC__RNC__CI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
}
return *this;
}

BSSMAP__FIELD__LAC__RNC__CI_template& BSSMAP__FIELD__LAC__RNC__CI_template::operator=(const BSSMAP__FIELD__LAC__RNC__CI_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__FIELD__LAC__RNC__CI_template::match(const BSSMAP__FIELD__LAC__RNC__CI& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.mcc__mnc().is_bound()) return FALSE;
if(!single_value->field_mcc__mnc.match(other_value.mcc__mnc(), legacy))return FALSE;
if(!other_value.lac().is_bound()) return FALSE;
if(!single_value->field_lac.match(other_value.lac(), legacy))return FALSE;
if(!other_value.rncId().is_bound()) return FALSE;
if(!single_value->field_rncId.match(other_value.rncId(), legacy))return FALSE;
if(!other_value.ci().is_bound()) return FALSE;
if(!single_value->field_ci.match(other_value.ci(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
}
return FALSE;
}

boolean BSSMAP__FIELD__LAC__RNC__CI_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_mcc__mnc.is_bound()
 || single_value->field_lac.is_bound()
 || single_value->field_rncId.is_bound()
 || single_value->field_ci.is_bound();
}

boolean BSSMAP__FIELD__LAC__RNC__CI_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_mcc__mnc.is_value()
 && single_value->field_lac.is_value()
 && single_value->field_rncId.is_value()
 && single_value->field_ci.is_value();
}

void BSSMAP__FIELD__LAC__RNC__CI_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__LAC__RNC__CI BSSMAP__FIELD__LAC__RNC__CI_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
BSSMAP__FIELD__LAC__RNC__CI ret_val;
if (single_value->field_mcc__mnc.is_bound()) {
ret_val.mcc__mnc() = single_value->field_mcc__mnc.valueof();
}
if (single_value->field_lac.is_bound()) {
ret_val.lac() = single_value->field_lac.valueof();
}
if (single_value->field_rncId.is_bound()) {
ret_val.rncId() = single_value->field_rncId.valueof();
}
if (single_value->field_ci.is_bound()) {
ret_val.ci() = single_value->field_ci.valueof();
}
return ret_val;
}

void BSSMAP__FIELD__LAC__RNC__CI_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__LAC__RNC__CI_template[list_length];
}

BSSMAP__FIELD__LAC__RNC__CI_template& BSSMAP__FIELD__LAC__RNC__CI_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__FIELD__LAC__RNC__CI_template::mcc__mnc()
{
set_specific();
return single_value->field_mcc__mnc;
}

const OCTETSTRING_template& BSSMAP__FIELD__LAC__RNC__CI_template::mcc__mnc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mcc_mnc of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
return single_value->field_mcc__mnc;
}

OCTETSTRING_template& BSSMAP__FIELD__LAC__RNC__CI_template::lac()
{
set_specific();
return single_value->field_lac;
}

const OCTETSTRING_template& BSSMAP__FIELD__LAC__RNC__CI_template::lac() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lac of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
return single_value->field_lac;
}

OCTETSTRING_template& BSSMAP__FIELD__LAC__RNC__CI_template::rncId()
{
set_specific();
return single_value->field_rncId;
}

const OCTETSTRING_template& BSSMAP__FIELD__LAC__RNC__CI_template::rncId() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rncId of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
return single_value->field_rncId;
}

OCTETSTRING_template& BSSMAP__FIELD__LAC__RNC__CI_template::ci()
{
set_specific();
return single_value->field_ci;
}

const OCTETSTRING_template& BSSMAP__FIELD__LAC__RNC__CI_template::ci() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ci of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
return single_value->field_ci;
}

int BSSMAP__FIELD__LAC__RNC__CI_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
  }
  return 0;
}

void BSSMAP__FIELD__LAC__RNC__CI_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ mcc_mnc := ");
single_value->field_mcc__mnc.log();
TTCN_Logger::log_event_str(", lac := ");
single_value->field_lac.log();
TTCN_Logger::log_event_str(", rncId := ");
single_value->field_rncId.log();
TTCN_Logger::log_event_str(", ci := ");
single_value->field_ci.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__FIELD__LAC__RNC__CI_template::log_match(const BSSMAP__FIELD__LAC__RNC__CI& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_mcc__mnc.match(match_value.mcc__mnc(), legacy)){
TTCN_Logger::log_logmatch_info(".mcc_mnc");
single_value->field_mcc__mnc.log_match(match_value.mcc__mnc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lac.match(match_value.lac(), legacy)){
TTCN_Logger::log_logmatch_info(".lac");
single_value->field_lac.log_match(match_value.lac(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rncId.match(match_value.rncId(), legacy)){
TTCN_Logger::log_logmatch_info(".rncId");
single_value->field_rncId.log_match(match_value.rncId(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ci.match(match_value.ci(), legacy)){
TTCN_Logger::log_logmatch_info(".ci");
single_value->field_ci.log_match(match_value.ci(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ mcc_mnc := ");
single_value->field_mcc__mnc.log_match(match_value.mcc__mnc(), legacy);
TTCN_Logger::log_event_str(", lac := ");
single_value->field_lac.log_match(match_value.lac(), legacy);
TTCN_Logger::log_event_str(", rncId := ");
single_value->field_rncId.log_match(match_value.rncId(), legacy);
TTCN_Logger::log_event_str(", ci := ");
single_value->field_ci.log_match(match_value.ci(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__LAC__RNC__CI_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (mcc__mnc().is_bound()) mcc__mnc().set_implicit_omit();
if (lac().is_bound()) lac().set_implicit_omit();
if (rncId().is_bound()) rncId().set_implicit_omit();
if (ci().is_bound()) ci().set_implicit_omit();
}

void BSSMAP__FIELD__LAC__RNC__CI_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_mcc__mnc.encode_text(text_buf);
single_value->field_lac.encode_text(text_buf);
single_value->field_rncId.encode_text(text_buf);
single_value->field_ci.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
}
}

void BSSMAP__FIELD__LAC__RNC__CI_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_mcc__mnc.decode_text(text_buf);
single_value->field_lac.decode_text(text_buf);
single_value->field_rncId.decode_text(text_buf);
single_value->field_ci.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__LAC__RNC__CI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI.");
}
}

void BSSMAP__FIELD__LAC__RNC__CI_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__LAC__RNC__CI_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) mcc__mnc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lac().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rncId().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ci().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcc_mnc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcc__mnc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rncId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rncId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ci")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ci().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__LAC__RNC__CI_template* precondition = new BSSMAP__FIELD__LAC__RNC__CI_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__FIELD__LAC__RNC__CI_template* implied_template = new BSSMAP__FIELD__LAC__RNC__CI_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__FIELD__LAC__RNC__CI_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__FIELD__LAC__RNC__CI_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_mcc__mnc.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI");
single_value->field_lac.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI");
single_value->field_rncId.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI");
single_value->field_ci.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_LAC_RNC_CI");
}

boolean BSSMAP__FIELD__LAC__RNC__CI_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__LAC__RNC__CI_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__CellIdentifier::BSSMAP__IE__CellIdentifier()
{
}

BSSMAP__IE__CellIdentifier::BSSMAP__IE__CellIdentifier(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_cellIdentifierDiscriminator,
    const BITSTRING& par_spare1__4,
    const BSSMAP__FIELD__CellIdentification& par_cellIdentification)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_cellIdentifierDiscriminator(par_cellIdentifierDiscriminator),
  field_spare1__4(par_spare1__4),
  field_cellIdentification(par_cellIdentification)
{
}

BSSMAP__IE__CellIdentifier::BSSMAP__IE__CellIdentifier(const BSSMAP__IE__CellIdentifier& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.cellIdentifierDiscriminator().is_bound()) field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
else field_cellIdentifierDiscriminator.clean_up();
if (other_value.spare1__4().is_bound()) field_spare1__4 = other_value.spare1__4();
else field_spare1__4.clean_up();
if (other_value.cellIdentification().is_bound()) field_cellIdentification = other_value.cellIdentification();
else field_cellIdentification.clean_up();
}

void BSSMAP__IE__CellIdentifier::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_cellIdentifierDiscriminator.clean_up();
field_spare1__4.clean_up();
field_cellIdentification.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__CellIdentifier::get_descriptor() const { return &BSSMAP__IE__CellIdentifier_descr_; }
BSSMAP__IE__CellIdentifier& BSSMAP__IE__CellIdentifier::operator=(const BSSMAP__IE__CellIdentifier& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.cellIdentifierDiscriminator().is_bound()) field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
  else field_cellIdentifierDiscriminator.clean_up();
  if (other_value.spare1__4().is_bound()) field_spare1__4 = other_value.spare1__4();
  else field_spare1__4.clean_up();
  if (other_value.cellIdentification().is_bound()) field_cellIdentification = other_value.cellIdentification();
  else field_cellIdentification.clean_up();
}
return *this;
}

boolean BSSMAP__IE__CellIdentifier::operator==(const BSSMAP__IE__CellIdentifier& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_cellIdentifierDiscriminator==other_value.field_cellIdentifierDiscriminator
  && field_spare1__4==other_value.field_spare1__4
  && field_cellIdentification==other_value.field_cellIdentification;
}

boolean BSSMAP__IE__CellIdentifier::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_cellIdentifierDiscriminator.is_bound())
  || (field_spare1__4.is_bound())
  || (field_cellIdentification.is_bound());
}
boolean BSSMAP__IE__CellIdentifier::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_cellIdentifierDiscriminator.is_value()
  && field_spare1__4.is_value()
  && field_cellIdentification.is_value();
}
void BSSMAP__IE__CellIdentifier::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", cellIdentifierDiscriminator := ");
field_cellIdentifierDiscriminator.log();
TTCN_Logger::log_event_str(", spare1_4 := ");
field_spare1__4.log();
TTCN_Logger::log_event_str(", cellIdentification := ");
field_cellIdentification.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__CellIdentifier::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (cellIdentifierDiscriminator().is_bound()) cellIdentifierDiscriminator().set_implicit_omit();
if (spare1__4().is_bound()) spare1__4().set_implicit_omit();
if (cellIdentification().is_bound()) cellIdentification().set_implicit_omit();
}

void BSSMAP__IE__CellIdentifier::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_CellIdentifier has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cellIdentifierDiscriminator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare1__4().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) cellIdentification().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifierDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifierDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare1_4")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare1__4().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentification")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentification().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CellIdentifier: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_CellIdentifier");
  }
}

void BSSMAP__IE__CellIdentifier::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_cellIdentifierDiscriminator.encode_text(text_buf);
field_spare1__4.encode_text(text_buf);
field_cellIdentification.encode_text(text_buf);
}

void BSSMAP__IE__CellIdentifier::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_cellIdentifierDiscriminator.decode_text(text_buf);
field_spare1__4.decode_text(text_buf);
field_cellIdentification.decode_text(text_buf);
}

void BSSMAP__IE__CellIdentifier::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__CellIdentifier::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__CellIdentifier::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__CellIdentifier_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__CellIdentifier_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__CellIdentifier_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentifierDiscriminator.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare1__4.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_cellIdentifierDiscriminator ==  bs_0) selected_field = 0;
  else if (field_cellIdentifierDiscriminator ==  bs_1) selected_field = 1;
  else if (field_cellIdentifierDiscriminator ==  bs_2) selected_field = 2;
  else if (field_cellIdentifierDiscriminator ==  bs_3) selected_field = 3;
  else if (field_cellIdentifierDiscriminator ==  bs_4) selected_field = 4;
  else if (field_cellIdentifierDiscriminator ==  bs_5) selected_field = 5;
  else if (field_cellIdentifierDiscriminator ==  bs_6) selected_field = 6;
  else if (field_cellIdentifierDiscriminator ==  bs_7) selected_field = 7;
  else if (field_cellIdentifierDiscriminator ==  bs_8) selected_field = 8;
  else selected_field = -1;
  RAW_Force_Omit field_4_force_omit(4, force_omit, BSSMAP__IE__CellIdentifier_cellIdentification_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentification.RAW_decode(BSSMAP__IE__CellIdentifier_cellIdentification_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, selected_field, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_24) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__CellIdentifier::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__CellIdentifier_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BSSMAP__IE__CellIdentifier_cellIdentification_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__CellIdentifier_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_cellIdentifierDiscriminator.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_spare1__4.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_cellIdentification.RAW_encode(BSSMAP__IE__CellIdentifier_cellIdentification_descr_, *myleaf.body.node.nodes[4]);
  switch (field_cellIdentification.get_selection()) {
  case BSSMAP__FIELD__CellIdentification::ALT_cI__CGI:
  if (field_cellIdentifierDiscriminator !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentification::ALT_cI__LAC__CI:
  if (field_cellIdentifierDiscriminator !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentification::ALT_cI__CI:
  if (field_cellIdentifierDiscriminator !=  bs_2) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_2.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentification::ALT_cI__noCell:
  if (field_cellIdentifierDiscriminator !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentification::ALT_cI__PLMN__LAC__RNC:
  if (field_cellIdentifierDiscriminator !=  bs_4) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_4.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentification::ALT_cI__RNC:
  if (field_cellIdentifierDiscriminator !=  bs_5) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_5.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentification::ALT_cI__LAC__RNC:
  if (field_cellIdentifierDiscriminator !=  bs_6) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_6.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentification::ALT_cI__SAI:
  if (field_cellIdentifierDiscriminator !=  bs_7) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_7.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentification::ALT_ci__LAC__RNC__CI:
  if (field_cellIdentifierDiscriminator !=  bs_8) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_8.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_elementIdentifier !=  os_24) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_24.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__CellIdentifier_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_cellIdentifierDiscriminator;
BITSTRING_template field_spare1__4;
BSSMAP__FIELD__CellIdentification_template field_cellIdentification;
};

void BSSMAP__IE__CellIdentifier_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_cellIdentifierDiscriminator = ANY_VALUE;
single_value->field_spare1__4 = ANY_VALUE;
single_value->field_cellIdentification = ANY_VALUE;
}
}
}

void BSSMAP__IE__CellIdentifier_template::copy_value(const BSSMAP__IE__CellIdentifier& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.cellIdentifierDiscriminator().is_bound()) {
  single_value->field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
} else {
  single_value->field_cellIdentifierDiscriminator.clean_up();
}
if (other_value.spare1__4().is_bound()) {
  single_value->field_spare1__4 = other_value.spare1__4();
} else {
  single_value->field_spare1__4.clean_up();
}
if (other_value.cellIdentification().is_bound()) {
  single_value->field_cellIdentification = other_value.cellIdentification();
} else {
  single_value->field_cellIdentification.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__CellIdentifier_template::copy_template(const BSSMAP__IE__CellIdentifier_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentifierDiscriminator().get_selection()) {
single_value->field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
} else {
single_value->field_cellIdentifierDiscriminator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare1__4().get_selection()) {
single_value->field_spare1__4 = other_value.spare1__4();
} else {
single_value->field_spare1__4.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentification().get_selection()) {
single_value->field_cellIdentification = other_value.cellIdentification();
} else {
single_value->field_cellIdentification.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__CellIdentifier_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__CellIdentifier_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__CellIdentifier_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__CellIdentifier_template::BSSMAP__IE__CellIdentifier_template()
{
}

BSSMAP__IE__CellIdentifier_template::BSSMAP__IE__CellIdentifier_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__CellIdentifier_template::BSSMAP__IE__CellIdentifier_template(const BSSMAP__IE__CellIdentifier& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__CellIdentifier_template::BSSMAP__IE__CellIdentifier_template(const OPTIONAL<BSSMAP__IE__CellIdentifier>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CellIdentifier&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier from an unbound optional field.");
}
}

BSSMAP__IE__CellIdentifier_template::BSSMAP__IE__CellIdentifier_template(BSSMAP__IE__CellIdentifier_template* p_precondition, BSSMAP__IE__CellIdentifier_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__CellIdentifier_template::BSSMAP__IE__CellIdentifier_template(Dynamic_Match_Interface<BSSMAP__IE__CellIdentifier>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__CellIdentifier>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__CellIdentifier_template::BSSMAP__IE__CellIdentifier_template(const BSSMAP__IE__CellIdentifier_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__CellIdentifier_template::~BSSMAP__IE__CellIdentifier_template()
{
clean_up();
}

BSSMAP__IE__CellIdentifier_template& BSSMAP__IE__CellIdentifier_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__CellIdentifier_template& BSSMAP__IE__CellIdentifier_template::operator=(const BSSMAP__IE__CellIdentifier& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__CellIdentifier_template& BSSMAP__IE__CellIdentifier_template::operator=(const OPTIONAL<BSSMAP__IE__CellIdentifier>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CellIdentifier&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
}
return *this;
}

BSSMAP__IE__CellIdentifier_template& BSSMAP__IE__CellIdentifier_template::operator=(const BSSMAP__IE__CellIdentifier_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__CellIdentifier_template::match(const BSSMAP__IE__CellIdentifier& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.cellIdentifierDiscriminator().is_bound()) return FALSE;
if(!single_value->field_cellIdentifierDiscriminator.match(other_value.cellIdentifierDiscriminator(), legacy))return FALSE;
if(!other_value.spare1__4().is_bound()) return FALSE;
if(!single_value->field_spare1__4.match(other_value.spare1__4(), legacy))return FALSE;
if(!other_value.cellIdentification().is_bound()) return FALSE;
if(!single_value->field_cellIdentification.match(other_value.cellIdentification(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
}
return FALSE;
}

boolean BSSMAP__IE__CellIdentifier_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_cellIdentifierDiscriminator.is_bound()
 || single_value->field_spare1__4.is_bound()
 || single_value->field_cellIdentification.is_bound();
}

boolean BSSMAP__IE__CellIdentifier_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_cellIdentifierDiscriminator.is_value()
 && single_value->field_spare1__4.is_value()
 && single_value->field_cellIdentification.is_value();
}

void BSSMAP__IE__CellIdentifier_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__CellIdentifier BSSMAP__IE__CellIdentifier_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
BSSMAP__IE__CellIdentifier ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_cellIdentifierDiscriminator.is_bound()) {
ret_val.cellIdentifierDiscriminator() = single_value->field_cellIdentifierDiscriminator.valueof();
}
if (single_value->field_spare1__4.is_bound()) {
ret_val.spare1__4() = single_value->field_spare1__4.valueof();
}
if (single_value->field_cellIdentification.is_bound()) {
ret_val.cellIdentification() = single_value->field_cellIdentification.valueof();
}
return ret_val;
}

void BSSMAP__IE__CellIdentifier_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__CellIdentifier_template[list_length];
}

BSSMAP__IE__CellIdentifier_template& BSSMAP__IE__CellIdentifier_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__CellIdentifier_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__CellIdentifier_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__CellIdentifier_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__CellIdentifier_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& BSSMAP__IE__CellIdentifier_template::cellIdentifierDiscriminator()
{
set_specific();
return single_value->field_cellIdentifierDiscriminator;
}

const BITSTRING_template& BSSMAP__IE__CellIdentifier_template::cellIdentifierDiscriminator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentifierDiscriminator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
return single_value->field_cellIdentifierDiscriminator;
}

BITSTRING_template& BSSMAP__IE__CellIdentifier_template::spare1__4()
{
set_specific();
return single_value->field_spare1__4;
}

const BITSTRING_template& BSSMAP__IE__CellIdentifier_template::spare1__4() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare1_4 of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
return single_value->field_spare1__4;
}

BSSMAP__FIELD__CellIdentification_template& BSSMAP__IE__CellIdentifier_template::cellIdentification()
{
set_specific();
return single_value->field_cellIdentification;
}

const BSSMAP__FIELD__CellIdentification_template& BSSMAP__IE__CellIdentifier_template::cellIdentification() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentification of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
return single_value->field_cellIdentification;
}

int BSSMAP__IE__CellIdentifier_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
  }
  return 0;
}

void BSSMAP__IE__CellIdentifier_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", cellIdentifierDiscriminator := ");
single_value->field_cellIdentifierDiscriminator.log();
TTCN_Logger::log_event_str(", spare1_4 := ");
single_value->field_spare1__4.log();
TTCN_Logger::log_event_str(", cellIdentification := ");
single_value->field_cellIdentification.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__CellIdentifier_template::log_match(const BSSMAP__IE__CellIdentifier& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cellIdentifierDiscriminator.match(match_value.cellIdentifierDiscriminator(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentifierDiscriminator");
single_value->field_cellIdentifierDiscriminator.log_match(match_value.cellIdentifierDiscriminator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare1__4.match(match_value.spare1__4(), legacy)){
TTCN_Logger::log_logmatch_info(".spare1_4");
single_value->field_spare1__4.log_match(match_value.spare1__4(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cellIdentification.match(match_value.cellIdentification(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentification");
single_value->field_cellIdentification.log_match(match_value.cellIdentification(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", cellIdentifierDiscriminator := ");
single_value->field_cellIdentifierDiscriminator.log_match(match_value.cellIdentifierDiscriminator(), legacy);
TTCN_Logger::log_event_str(", spare1_4 := ");
single_value->field_spare1__4.log_match(match_value.spare1__4(), legacy);
TTCN_Logger::log_event_str(", cellIdentification := ");
single_value->field_cellIdentification.log_match(match_value.cellIdentification(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__CellIdentifier_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (cellIdentifierDiscriminator().is_bound()) cellIdentifierDiscriminator().set_implicit_omit();
if (spare1__4().is_bound()) spare1__4().set_implicit_omit();
if (cellIdentification().is_bound()) cellIdentification().set_implicit_omit();
}

void BSSMAP__IE__CellIdentifier_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_cellIdentifierDiscriminator.encode_text(text_buf);
single_value->field_spare1__4.encode_text(text_buf);
single_value->field_cellIdentification.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
}
}

void BSSMAP__IE__CellIdentifier_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_cellIdentifierDiscriminator.decode_text(text_buf);
single_value->field_spare1__4.decode_text(text_buf);
single_value->field_cellIdentification.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__CellIdentifier_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier.");
}
}

void BSSMAP__IE__CellIdentifier_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__CellIdentifier_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_CellIdentifier has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cellIdentifierDiscriminator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare1__4().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) cellIdentification().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifierDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifierDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare1_4")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare1__4().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentification")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentification().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CellIdentifier: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__CellIdentifier_template* precondition = new BSSMAP__IE__CellIdentifier_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__CellIdentifier_template* implied_template = new BSSMAP__IE__CellIdentifier_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__CellIdentifier_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_CellIdentifier");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__CellIdentifier_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifier");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifier");
single_value->field_cellIdentifierDiscriminator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifier");
single_value->field_spare1__4.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifier");
single_value->field_cellIdentification.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifier");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifier");
}

boolean BSSMAP__IE__CellIdentifier_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__CellIdentifier_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__FIELD__CellIdentification__LAI::BSSMAP__FIELD__CellIdentification__LAI()
{
}

BSSMAP__FIELD__CellIdentification__LAI::BSSMAP__FIELD__CellIdentification__LAI(const OCTETSTRING& par_mcc__mnc,
    const OCTETSTRING& par_lac)
  :   field_mcc__mnc(par_mcc__mnc),
  field_lac(par_lac)
{
}

BSSMAP__FIELD__CellIdentification__LAI::BSSMAP__FIELD__CellIdentification__LAI(const BSSMAP__FIELD__CellIdentification__LAI& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
if (other_value.mcc__mnc().is_bound()) field_mcc__mnc = other_value.mcc__mnc();
else field_mcc__mnc.clean_up();
if (other_value.lac().is_bound()) field_lac = other_value.lac();
else field_lac.clean_up();
}

void BSSMAP__FIELD__CellIdentification__LAI::clean_up()
{
field_mcc__mnc.clean_up();
field_lac.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__FIELD__CellIdentification__LAI::get_descriptor() const { return &BSSMAP__FIELD__CellIdentification__LAI_descr_; }
BSSMAP__FIELD__CellIdentification__LAI& BSSMAP__FIELD__CellIdentification__LAI::operator=(const BSSMAP__FIELD__CellIdentification__LAI& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
  if (other_value.mcc__mnc().is_bound()) field_mcc__mnc = other_value.mcc__mnc();
  else field_mcc__mnc.clean_up();
  if (other_value.lac().is_bound()) field_lac = other_value.lac();
  else field_lac.clean_up();
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentification__LAI::operator==(const BSSMAP__FIELD__CellIdentification__LAI& other_value) const
{
return field_mcc__mnc==other_value.field_mcc__mnc
  && field_lac==other_value.field_lac;
}

boolean BSSMAP__FIELD__CellIdentification__LAI::is_bound() const
{
return (field_mcc__mnc.is_bound())
  || (field_lac.is_bound());
}
boolean BSSMAP__FIELD__CellIdentification__LAI::is_value() const
{
return field_mcc__mnc.is_value()
  && field_lac.is_value();
}
void BSSMAP__FIELD__CellIdentification__LAI::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ mcc_mnc := ");
field_mcc__mnc.log();
TTCN_Logger::log_event_str(", lac := ");
field_lac.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__FIELD__CellIdentification__LAI::set_implicit_omit()
{
if (mcc__mnc().is_bound()) mcc__mnc().set_implicit_omit();
if (lac().is_bound()) lac().set_implicit_omit();
}

void BSSMAP__FIELD__CellIdentification__LAI::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) mcc__mnc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lac().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcc_mnc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcc__mnc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI");
  }
}

void BSSMAP__FIELD__CellIdentification__LAI::encode_text(Text_Buf& text_buf) const
{
field_mcc__mnc.encode_text(text_buf);
field_lac.encode_text(text_buf);
}

void BSSMAP__FIELD__CellIdentification__LAI::decode_text(Text_Buf& text_buf)
{
field_mcc__mnc.decode_text(text_buf);
field_lac.decode_text(text_buf);
}

void BSSMAP__FIELD__CellIdentification__LAI::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__CellIdentification__LAI::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__CellIdentification__LAI::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT3_descr_.raw->forceomit);
  decoded_field_length = field_mcc__mnc.RAW_decode(General__Types::OCT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_lac.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__FIELD__CellIdentification__LAI::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT3_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT2_descr_.raw);
  encoded_length += field_mcc__mnc.RAW_encode(General__Types::OCT3_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_lac.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct BSSMAP__FIELD__CellIdentification__LAI_template::single_value_struct {
OCTETSTRING_template field_mcc__mnc;
OCTETSTRING_template field_lac;
};

void BSSMAP__FIELD__CellIdentification__LAI_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_mcc__mnc = ANY_VALUE;
single_value->field_lac = ANY_VALUE;
}
}
}

void BSSMAP__FIELD__CellIdentification__LAI_template::copy_value(const BSSMAP__FIELD__CellIdentification__LAI& other_value)
{
single_value = new single_value_struct;
if (other_value.mcc__mnc().is_bound()) {
  single_value->field_mcc__mnc = other_value.mcc__mnc();
} else {
  single_value->field_mcc__mnc.clean_up();
}
if (other_value.lac().is_bound()) {
  single_value->field_lac = other_value.lac();
} else {
  single_value->field_lac.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__CellIdentification__LAI_template::copy_template(const BSSMAP__FIELD__CellIdentification__LAI_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.mcc__mnc().get_selection()) {
single_value->field_mcc__mnc = other_value.mcc__mnc();
} else {
single_value->field_mcc__mnc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lac().get_selection()) {
single_value->field_lac = other_value.lac();
} else {
single_value->field_lac.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__CellIdentification__LAI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__CellIdentification__LAI_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__CellIdentification__LAI_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
break;
}
set_selection(other_value);
}

BSSMAP__FIELD__CellIdentification__LAI_template::BSSMAP__FIELD__CellIdentification__LAI_template()
{
}

BSSMAP__FIELD__CellIdentification__LAI_template::BSSMAP__FIELD__CellIdentification__LAI_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__CellIdentification__LAI_template::BSSMAP__FIELD__CellIdentification__LAI_template(const BSSMAP__FIELD__CellIdentification__LAI& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentification__LAI_template::BSSMAP__FIELD__CellIdentification__LAI_template(const OPTIONAL<BSSMAP__FIELD__CellIdentification__LAI>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentification__LAI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI from an unbound optional field.");
}
}

BSSMAP__FIELD__CellIdentification__LAI_template::BSSMAP__FIELD__CellIdentification__LAI_template(BSSMAP__FIELD__CellIdentification__LAI_template* p_precondition, BSSMAP__FIELD__CellIdentification__LAI_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__CellIdentification__LAI_template::BSSMAP__FIELD__CellIdentification__LAI_template(Dynamic_Match_Interface<BSSMAP__FIELD__CellIdentification__LAI>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__CellIdentification__LAI>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__CellIdentification__LAI_template::BSSMAP__FIELD__CellIdentification__LAI_template(const BSSMAP__FIELD__CellIdentification__LAI_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__FIELD__CellIdentification__LAI_template::~BSSMAP__FIELD__CellIdentification__LAI_template()
{
clean_up();
}

BSSMAP__FIELD__CellIdentification__LAI_template& BSSMAP__FIELD__CellIdentification__LAI_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentification__LAI_template& BSSMAP__FIELD__CellIdentification__LAI_template::operator=(const BSSMAP__FIELD__CellIdentification__LAI& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentification__LAI_template& BSSMAP__FIELD__CellIdentification__LAI_template::operator=(const OPTIONAL<BSSMAP__FIELD__CellIdentification__LAI>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentification__LAI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
}
return *this;
}

BSSMAP__FIELD__CellIdentification__LAI_template& BSSMAP__FIELD__CellIdentification__LAI_template::operator=(const BSSMAP__FIELD__CellIdentification__LAI_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentification__LAI_template::match(const BSSMAP__FIELD__CellIdentification__LAI& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.mcc__mnc().is_bound()) return FALSE;
if(!single_value->field_mcc__mnc.match(other_value.mcc__mnc(), legacy))return FALSE;
if(!other_value.lac().is_bound()) return FALSE;
if(!single_value->field_lac.match(other_value.lac(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
}
return FALSE;
}

boolean BSSMAP__FIELD__CellIdentification__LAI_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_mcc__mnc.is_bound()
 || single_value->field_lac.is_bound();
}

boolean BSSMAP__FIELD__CellIdentification__LAI_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_mcc__mnc.is_value()
 && single_value->field_lac.is_value();
}

void BSSMAP__FIELD__CellIdentification__LAI_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__CellIdentification__LAI BSSMAP__FIELD__CellIdentification__LAI_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
BSSMAP__FIELD__CellIdentification__LAI ret_val;
if (single_value->field_mcc__mnc.is_bound()) {
ret_val.mcc__mnc() = single_value->field_mcc__mnc.valueof();
}
if (single_value->field_lac.is_bound()) {
ret_val.lac() = single_value->field_lac.valueof();
}
return ret_val;
}

void BSSMAP__FIELD__CellIdentification__LAI_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__CellIdentification__LAI_template[list_length];
}

BSSMAP__FIELD__CellIdentification__LAI_template& BSSMAP__FIELD__CellIdentification__LAI_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__FIELD__CellIdentification__LAI_template::mcc__mnc()
{
set_specific();
return single_value->field_mcc__mnc;
}

const OCTETSTRING_template& BSSMAP__FIELD__CellIdentification__LAI_template::mcc__mnc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mcc_mnc of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
return single_value->field_mcc__mnc;
}

OCTETSTRING_template& BSSMAP__FIELD__CellIdentification__LAI_template::lac()
{
set_specific();
return single_value->field_lac;
}

const OCTETSTRING_template& BSSMAP__FIELD__CellIdentification__LAI_template::lac() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lac of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
return single_value->field_lac;
}

int BSSMAP__FIELD__CellIdentification__LAI_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
  }
  return 0;
}

void BSSMAP__FIELD__CellIdentification__LAI_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ mcc_mnc := ");
single_value->field_mcc__mnc.log();
TTCN_Logger::log_event_str(", lac := ");
single_value->field_lac.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__FIELD__CellIdentification__LAI_template::log_match(const BSSMAP__FIELD__CellIdentification__LAI& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_mcc__mnc.match(match_value.mcc__mnc(), legacy)){
TTCN_Logger::log_logmatch_info(".mcc_mnc");
single_value->field_mcc__mnc.log_match(match_value.mcc__mnc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lac.match(match_value.lac(), legacy)){
TTCN_Logger::log_logmatch_info(".lac");
single_value->field_lac.log_match(match_value.lac(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ mcc_mnc := ");
single_value->field_mcc__mnc.log_match(match_value.mcc__mnc(), legacy);
TTCN_Logger::log_event_str(", lac := ");
single_value->field_lac.log_match(match_value.lac(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__CellIdentification__LAI_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (mcc__mnc().is_bound()) mcc__mnc().set_implicit_omit();
if (lac().is_bound()) lac().set_implicit_omit();
}

void BSSMAP__FIELD__CellIdentification__LAI_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_mcc__mnc.encode_text(text_buf);
single_value->field_lac.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
}
}

void BSSMAP__FIELD__CellIdentification__LAI_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_mcc__mnc.decode_text(text_buf);
single_value->field_lac.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__CellIdentification__LAI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI.");
}
}

void BSSMAP__FIELD__CellIdentification__LAI_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__CellIdentification__LAI_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) mcc__mnc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lac().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcc_mnc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcc__mnc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__CellIdentification__LAI_template* precondition = new BSSMAP__FIELD__CellIdentification__LAI_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__FIELD__CellIdentification__LAI_template* implied_template = new BSSMAP__FIELD__CellIdentification__LAI_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__FIELD__CellIdentification__LAI_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__FIELD__CellIdentification__LAI_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_mcc__mnc.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI");
single_value->field_lac.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentification_LAI");
}

boolean BSSMAP__FIELD__CellIdentification__LAI_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__CellIdentification__LAI_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationList::copy_value(const BSSMAP__FIELD__CellIdentificationList& other_value)
{
switch (other_value.union_selection) {
case ALT_cIl__CGI:
field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI(*other_value.field_cIl__CGI);
break;
case ALT_cIl__LAC__CI:
field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI(*other_value.field_cIl__LAC__CI);
break;
case ALT_cIl__CI:
field_cIl__CI = new RecordOfOCT2(*other_value.field_cIl__CI);
break;
case ALT_cIl__noCell:
field_cIl__noCell = new OCTETSTRING(*other_value.field_cIl__noCell);
break;
case ALT_cIl__LAI:
field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI(*other_value.field_cIl__LAI);
break;
case ALT_cIl__LAC:
field_cIl__LAC = new RecordOfOCT2(*other_value.field_cIl__LAC);
break;
case ALT_cIl__allInBSS:
field_cIl__allInBSS = new OCTETSTRING(*other_value.field_cIl__allInBSS);
break;
case ALT_cIl__PLMN__LAC__RNC:
field_cIl__PLMN__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC(*other_value.field_cIl__PLMN__LAC__RNC);
break;
case ALT_cIl__RNC:
field_cIl__RNC = new RecordOfOCT2(*other_value.field_cIl__RNC);
break;
case ALT_cIl__LAC__RNC:
field_cIl__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC(*other_value.field_cIl__LAC__RNC);
break;
default:
TTCN_error("Assignment of an unbound union value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
union_selection = other_value.union_selection;
}

BSSMAP__FIELD__CellIdentificationList::BSSMAP__FIELD__CellIdentificationList()
{
union_selection = UNBOUND_VALUE;
}

BSSMAP__FIELD__CellIdentificationList::BSSMAP__FIELD__CellIdentificationList(const BSSMAP__FIELD__CellIdentificationList& other_value)
: Base_Type(){
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationList::~BSSMAP__FIELD__CellIdentificationList()
{
clean_up();
}

BSSMAP__FIELD__CellIdentificationList& BSSMAP__FIELD__CellIdentificationList::operator=(const BSSMAP__FIELD__CellIdentificationList& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationList::operator==(const BSSMAP__FIELD__CellIdentificationList& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_cIl__CGI:
return *field_cIl__CGI == *other_value.field_cIl__CGI;
case ALT_cIl__LAC__CI:
return *field_cIl__LAC__CI == *other_value.field_cIl__LAC__CI;
case ALT_cIl__CI:
return *field_cIl__CI == *other_value.field_cIl__CI;
case ALT_cIl__noCell:
return *field_cIl__noCell == *other_value.field_cIl__noCell;
case ALT_cIl__LAI:
return *field_cIl__LAI == *other_value.field_cIl__LAI;
case ALT_cIl__LAC:
return *field_cIl__LAC == *other_value.field_cIl__LAC;
case ALT_cIl__allInBSS:
return *field_cIl__allInBSS == *other_value.field_cIl__allInBSS;
case ALT_cIl__PLMN__LAC__RNC:
return *field_cIl__PLMN__LAC__RNC == *other_value.field_cIl__PLMN__LAC__RNC;
case ALT_cIl__RNC:
return *field_cIl__RNC == *other_value.field_cIl__RNC;
case ALT_cIl__LAC__RNC:
return *field_cIl__LAC__RNC == *other_value.field_cIl__LAC__RNC;
default:
return FALSE;
}
}

BSSMAP__FIELD__CellIdentificationList__CGI& BSSMAP__FIELD__CellIdentificationList::cIl__CGI()
{
if (union_selection != ALT_cIl__CGI) {
clean_up();
field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI;
union_selection = ALT_cIl__CGI;
}
return *field_cIl__CGI;
}

const BSSMAP__FIELD__CellIdentificationList__CGI& BSSMAP__FIELD__CellIdentificationList::cIl__CGI() const
{
if (union_selection != ALT_cIl__CGI) TTCN_error("Using non-selected field cIl_CGI in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *field_cIl__CGI;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI& BSSMAP__FIELD__CellIdentificationList::cIl__LAC__CI()
{
if (union_selection != ALT_cIl__LAC__CI) {
clean_up();
field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI;
union_selection = ALT_cIl__LAC__CI;
}
return *field_cIl__LAC__CI;
}

const BSSMAP__FIELD__CellIdentificationList__LAC__CI& BSSMAP__FIELD__CellIdentificationList::cIl__LAC__CI() const
{
if (union_selection != ALT_cIl__LAC__CI) TTCN_error("Using non-selected field cIl_LAC_CI in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *field_cIl__LAC__CI;
}

RecordOfOCT2& BSSMAP__FIELD__CellIdentificationList::cIl__CI()
{
if (union_selection != ALT_cIl__CI) {
clean_up();
field_cIl__CI = new RecordOfOCT2;
union_selection = ALT_cIl__CI;
}
return *field_cIl__CI;
}

const RecordOfOCT2& BSSMAP__FIELD__CellIdentificationList::cIl__CI() const
{
if (union_selection != ALT_cIl__CI) TTCN_error("Using non-selected field cIl_CI in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *field_cIl__CI;
}

OCTETSTRING& BSSMAP__FIELD__CellIdentificationList::cIl__noCell()
{
if (union_selection != ALT_cIl__noCell) {
clean_up();
field_cIl__noCell = new OCTETSTRING;
union_selection = ALT_cIl__noCell;
}
return *field_cIl__noCell;
}

const OCTETSTRING& BSSMAP__FIELD__CellIdentificationList::cIl__noCell() const
{
if (union_selection != ALT_cIl__noCell) TTCN_error("Using non-selected field cIl_noCell in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *field_cIl__noCell;
}

BSSMAP__FIELD__CellIdentificationList__LAI& BSSMAP__FIELD__CellIdentificationList::cIl__LAI()
{
if (union_selection != ALT_cIl__LAI) {
clean_up();
field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI;
union_selection = ALT_cIl__LAI;
}
return *field_cIl__LAI;
}

const BSSMAP__FIELD__CellIdentificationList__LAI& BSSMAP__FIELD__CellIdentificationList::cIl__LAI() const
{
if (union_selection != ALT_cIl__LAI) TTCN_error("Using non-selected field cIl_LAI in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *field_cIl__LAI;
}

RecordOfOCT2& BSSMAP__FIELD__CellIdentificationList::cIl__LAC()
{
if (union_selection != ALT_cIl__LAC) {
clean_up();
field_cIl__LAC = new RecordOfOCT2;
union_selection = ALT_cIl__LAC;
}
return *field_cIl__LAC;
}

const RecordOfOCT2& BSSMAP__FIELD__CellIdentificationList::cIl__LAC() const
{
if (union_selection != ALT_cIl__LAC) TTCN_error("Using non-selected field cIl_LAC in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *field_cIl__LAC;
}

OCTETSTRING& BSSMAP__FIELD__CellIdentificationList::cIl__allInBSS()
{
if (union_selection != ALT_cIl__allInBSS) {
clean_up();
field_cIl__allInBSS = new OCTETSTRING;
union_selection = ALT_cIl__allInBSS;
}
return *field_cIl__allInBSS;
}

const OCTETSTRING& BSSMAP__FIELD__CellIdentificationList::cIl__allInBSS() const
{
if (union_selection != ALT_cIl__allInBSS) TTCN_error("Using non-selected field cIl_allInBSS in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *field_cIl__allInBSS;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& BSSMAP__FIELD__CellIdentificationList::cIl__PLMN__LAC__RNC()
{
if (union_selection != ALT_cIl__PLMN__LAC__RNC) {
clean_up();
field_cIl__PLMN__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC;
union_selection = ALT_cIl__PLMN__LAC__RNC;
}
return *field_cIl__PLMN__LAC__RNC;
}

const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& BSSMAP__FIELD__CellIdentificationList::cIl__PLMN__LAC__RNC() const
{
if (union_selection != ALT_cIl__PLMN__LAC__RNC) TTCN_error("Using non-selected field cIl_PLMN_LAC_RNC in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *field_cIl__PLMN__LAC__RNC;
}

RecordOfOCT2& BSSMAP__FIELD__CellIdentificationList::cIl__RNC()
{
if (union_selection != ALT_cIl__RNC) {
clean_up();
field_cIl__RNC = new RecordOfOCT2;
union_selection = ALT_cIl__RNC;
}
return *field_cIl__RNC;
}

const RecordOfOCT2& BSSMAP__FIELD__CellIdentificationList::cIl__RNC() const
{
if (union_selection != ALT_cIl__RNC) TTCN_error("Using non-selected field cIl_RNC in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *field_cIl__RNC;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC& BSSMAP__FIELD__CellIdentificationList::cIl__LAC__RNC()
{
if (union_selection != ALT_cIl__LAC__RNC) {
clean_up();
field_cIl__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC;
union_selection = ALT_cIl__LAC__RNC;
}
return *field_cIl__LAC__RNC;
}

const BSSMAP__FIELD__CellIdentificationList__LAC__RNC& BSSMAP__FIELD__CellIdentificationList::cIl__LAC__RNC() const
{
if (union_selection != ALT_cIl__LAC__RNC) TTCN_error("Using non-selected field cIl_LAC_RNC in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *field_cIl__LAC__RNC;
}

boolean BSSMAP__FIELD__CellIdentificationList::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return union_selection == checked_selection;
}

boolean BSSMAP__FIELD__CellIdentificationList::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean BSSMAP__FIELD__CellIdentificationList::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_cIl__CGI: return field_cIl__CGI->is_value();
case ALT_cIl__LAC__CI: return field_cIl__LAC__CI->is_value();
case ALT_cIl__CI: return field_cIl__CI->is_value();
case ALT_cIl__noCell: return field_cIl__noCell->is_value();
case ALT_cIl__LAI: return field_cIl__LAI->is_value();
case ALT_cIl__LAC: return field_cIl__LAC->is_value();
case ALT_cIl__allInBSS: return field_cIl__allInBSS->is_value();
case ALT_cIl__PLMN__LAC__RNC: return field_cIl__PLMN__LAC__RNC->is_value();
case ALT_cIl__RNC: return field_cIl__RNC->is_value();
case ALT_cIl__LAC__RNC: return field_cIl__LAC__RNC->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void BSSMAP__FIELD__CellIdentificationList::clean_up()
{
switch (union_selection) {
case ALT_cIl__CGI:
  delete field_cIl__CGI;
  break;
case ALT_cIl__LAC__CI:
  delete field_cIl__LAC__CI;
  break;
case ALT_cIl__CI:
  delete field_cIl__CI;
  break;
case ALT_cIl__noCell:
  delete field_cIl__noCell;
  break;
case ALT_cIl__LAI:
  delete field_cIl__LAI;
  break;
case ALT_cIl__LAC:
  delete field_cIl__LAC;
  break;
case ALT_cIl__allInBSS:
  delete field_cIl__allInBSS;
  break;
case ALT_cIl__PLMN__LAC__RNC:
  delete field_cIl__PLMN__LAC__RNC;
  break;
case ALT_cIl__RNC:
  delete field_cIl__RNC;
  break;
case ALT_cIl__LAC__RNC:
  delete field_cIl__LAC__RNC;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void BSSMAP__FIELD__CellIdentificationList::log() const
{
switch (union_selection) {
case ALT_cIl__CGI:
TTCN_Logger::log_event_str("{ cIl_CGI := ");
field_cIl__CGI->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__LAC__CI:
TTCN_Logger::log_event_str("{ cIl_LAC_CI := ");
field_cIl__LAC__CI->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__CI:
TTCN_Logger::log_event_str("{ cIl_CI := ");
field_cIl__CI->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__noCell:
TTCN_Logger::log_event_str("{ cIl_noCell := ");
field_cIl__noCell->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__LAI:
TTCN_Logger::log_event_str("{ cIl_LAI := ");
field_cIl__LAI->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__LAC:
TTCN_Logger::log_event_str("{ cIl_LAC := ");
field_cIl__LAC->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__allInBSS:
TTCN_Logger::log_event_str("{ cIl_allInBSS := ");
field_cIl__allInBSS->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__PLMN__LAC__RNC:
TTCN_Logger::log_event_str("{ cIl_PLMN_LAC_RNC := ");
field_cIl__PLMN__LAC__RNC->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__RNC:
TTCN_Logger::log_event_str("{ cIl_RNC := ");
field_cIl__RNC->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__LAC__RNC:
TTCN_Logger::log_event_str("{ cIl_LAC_RNC := ");
field_cIl__LAC__RNC->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void BSSMAP__FIELD__CellIdentificationList::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "cIl_CGI")) {
    cIl__CGI().set_param(*mp_last);
    if (!cIl__CGI().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_LAC_CI")) {
    cIl__LAC__CI().set_param(*mp_last);
    if (!cIl__LAC__CI().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_CI")) {
    cIl__CI().set_param(*mp_last);
    if (!cIl__CI().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_noCell")) {
    cIl__noCell().set_param(*mp_last);
    if (!cIl__noCell().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_LAI")) {
    cIl__LAI().set_param(*mp_last);
    if (!cIl__LAI().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_LAC")) {
    cIl__LAC().set_param(*mp_last);
    if (!cIl__LAC().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_allInBSS")) {
    cIl__allInBSS().set_param(*mp_last);
    if (!cIl__allInBSS().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_PLMN_LAC_RNC")) {
    cIl__PLMN__LAC__RNC().set_param(*mp_last);
    if (!cIl__PLMN__LAC__RNC().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_RNC")) {
    cIl__RNC().set_param(*mp_last);
    if (!cIl__RNC().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_LAC_RNC")) {
    cIl__LAC__RNC().set_param(*mp_last);
    if (!cIl__LAC__RNC().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.", last_name);
}

void BSSMAP__FIELD__CellIdentificationList::set_implicit_omit()
{
switch (union_selection) {
case ALT_cIl__CGI:
field_cIl__CGI->set_implicit_omit(); break;
case ALT_cIl__LAC__CI:
field_cIl__LAC__CI->set_implicit_omit(); break;
case ALT_cIl__CI:
field_cIl__CI->set_implicit_omit(); break;
case ALT_cIl__noCell:
field_cIl__noCell->set_implicit_omit(); break;
case ALT_cIl__LAI:
field_cIl__LAI->set_implicit_omit(); break;
case ALT_cIl__LAC:
field_cIl__LAC->set_implicit_omit(); break;
case ALT_cIl__allInBSS:
field_cIl__allInBSS->set_implicit_omit(); break;
case ALT_cIl__PLMN__LAC__RNC:
field_cIl__PLMN__LAC__RNC->set_implicit_omit(); break;
case ALT_cIl__RNC:
field_cIl__RNC->set_implicit_omit(); break;
case ALT_cIl__LAC__RNC:
field_cIl__LAC__RNC->set_implicit_omit(); break;
default: break;
}
}

void BSSMAP__FIELD__CellIdentificationList::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_cIl__CGI:
field_cIl__CGI->encode_text(text_buf);
break;
case ALT_cIl__LAC__CI:
field_cIl__LAC__CI->encode_text(text_buf);
break;
case ALT_cIl__CI:
field_cIl__CI->encode_text(text_buf);
break;
case ALT_cIl__noCell:
field_cIl__noCell->encode_text(text_buf);
break;
case ALT_cIl__LAI:
field_cIl__LAI->encode_text(text_buf);
break;
case ALT_cIl__LAC:
field_cIl__LAC->encode_text(text_buf);
break;
case ALT_cIl__allInBSS:
field_cIl__allInBSS->encode_text(text_buf);
break;
case ALT_cIl__PLMN__LAC__RNC:
field_cIl__PLMN__LAC__RNC->encode_text(text_buf);
break;
case ALT_cIl__RNC:
field_cIl__RNC->encode_text(text_buf);
break;
case ALT_cIl__LAC__RNC:
field_cIl__LAC__RNC->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
}

void BSSMAP__FIELD__CellIdentificationList::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_cIl__CGI:
cIl__CGI().decode_text(text_buf);
break;
case ALT_cIl__LAC__CI:
cIl__LAC__CI().decode_text(text_buf);
break;
case ALT_cIl__CI:
cIl__CI().decode_text(text_buf);
break;
case ALT_cIl__noCell:
cIl__noCell().decode_text(text_buf);
break;
case ALT_cIl__LAI:
cIl__LAI().decode_text(text_buf);
break;
case ALT_cIl__LAC:
cIl__LAC().decode_text(text_buf);
break;
case ALT_cIl__allInBSS:
cIl__allInBSS().decode_text(text_buf);
break;
case ALT_cIl__PLMN__LAC__RNC:
cIl__PLMN__LAC__RNC().decode_text(text_buf);
break;
case ALT_cIl__RNC:
cIl__RNC().decode_text(text_buf);
break;
case ALT_cIl__LAC__RNC:
cIl__LAC__RNC().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
}

void BSSMAP__FIELD__CellIdentificationList::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__CellIdentificationList::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__CellIdentificationList::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, BSSMAP__FIELD__CellIdentificationList__CGI_descr_.raw->forceomit);
      decoded_length = cIl__CGI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__CGI_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, BSSMAP__FIELD__CellIdentificationList__LAC__CI_descr_.raw->forceomit);
      decoded_length = cIl__LAC__CI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAC__CI_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, RecordOfOCT2_descr_.raw->forceomit);
      decoded_length = cIl__CI().RAW_decode(RecordOfOCT2_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, General__Types::OCT0_descr_.raw->forceomit);
      decoded_length = cIl__noCell().RAW_decode(General__Types::OCT0_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 4: {
      RAW_Force_Omit field_force_omit(4, force_omit, BSSMAP__FIELD__CellIdentificationList__LAI_descr_.raw->forceomit);
      decoded_length = cIl__LAI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAI_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 5: {
      RAW_Force_Omit field_force_omit(5, force_omit, RecordOfOCT2_descr_.raw->forceomit);
      decoded_length = cIl__LAC().RAW_decode(RecordOfOCT2_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 6: {
      RAW_Force_Omit field_force_omit(6, force_omit, General__Types::OCT0_descr_.raw->forceomit);
      decoded_length = cIl__allInBSS().RAW_decode(General__Types::OCT0_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 7: {
      RAW_Force_Omit field_force_omit(7, force_omit, BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_descr_.raw->forceomit);
      decoded_length = cIl__PLMN__LAC__RNC().RAW_decode(BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 8: {
      RAW_Force_Omit field_force_omit(8, force_omit, RecordOfOCT2_descr_.raw->forceomit);
      decoded_length = cIl__RNC().RAW_decode(RecordOfOCT2_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 9: {
      RAW_Force_Omit field_force_omit(9, force_omit, BSSMAP__FIELD__CellIdentificationList__LAC__RNC_descr_.raw->forceomit);
      decoded_length = cIl__LAC__RNC().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAC__RNC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, BSSMAP__FIELD__CellIdentificationList__CGI_descr_.raw->forceomit);
      decoded_length = cIl__CGI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__CGI_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__FIELD__CellIdentificationList__LAC__CI_descr_.raw->forceomit);
      decoded_length = cIl__LAC__CI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAC__CI_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, RecordOfOCT2_descr_.raw->forceomit);
      decoded_length = cIl__CI().RAW_decode(RecordOfOCT2_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT0_descr_.raw->forceomit);
      decoded_length = cIl__noCell().RAW_decode(General__Types::OCT0_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_3_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_4_force_omit(4, force_omit, BSSMAP__FIELD__CellIdentificationList__LAI_descr_.raw->forceomit);
      decoded_length = cIl__LAI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAI_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_4_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_5_force_omit(5, force_omit, RecordOfOCT2_descr_.raw->forceomit);
      decoded_length = cIl__LAC().RAW_decode(RecordOfOCT2_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_5_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_6_force_omit(6, force_omit, General__Types::OCT0_descr_.raw->forceomit);
      decoded_length = cIl__allInBSS().RAW_decode(General__Types::OCT0_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_6_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_7_force_omit(7, force_omit, BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_descr_.raw->forceomit);
      decoded_length = cIl__PLMN__LAC__RNC().RAW_decode(BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_7_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_8_force_omit(8, force_omit, RecordOfOCT2_descr_.raw->forceomit);
      decoded_length = cIl__RNC().RAW_decode(RecordOfOCT2_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_8_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_9_force_omit(9, force_omit, BSSMAP__FIELD__CellIdentificationList__LAC__RNC_descr_.raw->forceomit);
      decoded_length = cIl__LAC__RNC().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAC__RNC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_9_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int BSSMAP__FIELD__CellIdentificationList::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 10;  myleaf.body.node.nodes = init_nodes_of_enc_tree(10);
  memset(myleaf.body.node.nodes, 0, 10 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_cIl__CGI:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, BSSMAP__FIELD__CellIdentificationList__CGI_descr_.raw);
    encoded_length = field_cIl__CGI->RAW_encode(BSSMAP__FIELD__CellIdentificationList__CGI_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &BSSMAP__FIELD__CellIdentificationList__CGI_descr_;
    break;
  case ALT_cIl__LAC__CI:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, BSSMAP__FIELD__CellIdentificationList__LAC__CI_descr_.raw);
    encoded_length = field_cIl__LAC__CI->RAW_encode(BSSMAP__FIELD__CellIdentificationList__LAC__CI_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__FIELD__CellIdentificationList__LAC__CI_descr_;
    break;
  case ALT_cIl__CI:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, RecordOfOCT2_descr_.raw);
    encoded_length = field_cIl__CI->RAW_encode(RecordOfOCT2_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &RecordOfOCT2_descr_;
    break;
  case ALT_cIl__noCell:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, General__Types::OCT0_descr_.raw);
    encoded_length = field_cIl__noCell->RAW_encode(General__Types::OCT0_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &General__Types::OCT0_descr_;
    break;
  case ALT_cIl__LAI:
    myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 4, BSSMAP__FIELD__CellIdentificationList__LAI_descr_.raw);
    encoded_length = field_cIl__LAI->RAW_encode(BSSMAP__FIELD__CellIdentificationList__LAI_descr_, *myleaf.body.node.nodes[4]);
    myleaf.body.node.nodes[4]->coding_descr = &BSSMAP__FIELD__CellIdentificationList__LAI_descr_;
    break;
  case ALT_cIl__LAC:
    myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 5, RecordOfOCT2_descr_.raw);
    encoded_length = field_cIl__LAC->RAW_encode(RecordOfOCT2_descr_, *myleaf.body.node.nodes[5]);
    myleaf.body.node.nodes[5]->coding_descr = &RecordOfOCT2_descr_;
    break;
  case ALT_cIl__allInBSS:
    myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 6, General__Types::OCT0_descr_.raw);
    encoded_length = field_cIl__allInBSS->RAW_encode(General__Types::OCT0_descr_, *myleaf.body.node.nodes[6]);
    myleaf.body.node.nodes[6]->coding_descr = &General__Types::OCT0_descr_;
    break;
  case ALT_cIl__PLMN__LAC__RNC:
    myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 7, BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_descr_.raw);
    encoded_length = field_cIl__PLMN__LAC__RNC->RAW_encode(BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_descr_, *myleaf.body.node.nodes[7]);
    myleaf.body.node.nodes[7]->coding_descr = &BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_descr_;
    break;
  case ALT_cIl__RNC:
    myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 8, RecordOfOCT2_descr_.raw);
    encoded_length = field_cIl__RNC->RAW_encode(RecordOfOCT2_descr_, *myleaf.body.node.nodes[8]);
    myleaf.body.node.nodes[8]->coding_descr = &RecordOfOCT2_descr_;
    break;
  case ALT_cIl__LAC__RNC:
    myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 9, BSSMAP__FIELD__CellIdentificationList__LAC__RNC_descr_.raw);
    encoded_length = field_cIl__LAC__RNC->RAW_encode(BSSMAP__FIELD__CellIdentificationList__LAC__RNC_descr_, *myleaf.body.node.nodes[9]);
    myleaf.body.node.nodes[9]->coding_descr = &BSSMAP__FIELD__CellIdentificationList__LAC__RNC_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void BSSMAP__FIELD__CellIdentificationList_template::copy_value(const BSSMAP__FIELD__CellIdentificationList& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI:
single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template(other_value.cIl__CGI());
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI_template(other_value.cIl__LAC__CI());
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI:
single_value.field_cIl__CI = new RecordOfOCT2_template(other_value.cIl__CI());
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell:
single_value.field_cIl__noCell = new OCTETSTRING_template(other_value.cIl__noCell());
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI:
single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template(other_value.cIl__LAI());
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC:
single_value.field_cIl__LAC = new RecordOfOCT2_template(other_value.cIl__LAC());
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS = new OCTETSTRING_template(other_value.cIl__allInBSS());
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC:
single_value.field_cIl__PLMN__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template(other_value.cIl__PLMN__LAC__RNC());
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC:
single_value.field_cIl__RNC = new RecordOfOCT2_template(other_value.cIl__RNC());
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC:
single_value.field_cIl__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template(other_value.cIl__LAC__RNC());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__CellIdentificationList_template::copy_template(const BSSMAP__FIELD__CellIdentificationList_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI:
single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template(*other_value.single_value.field_cIl__CGI);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI_template(*other_value.single_value.field_cIl__LAC__CI);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI:
single_value.field_cIl__CI = new RecordOfOCT2_template(*other_value.single_value.field_cIl__CI);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell:
single_value.field_cIl__noCell = new OCTETSTRING_template(*other_value.single_value.field_cIl__noCell);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI:
single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template(*other_value.single_value.field_cIl__LAI);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC:
single_value.field_cIl__LAC = new RecordOfOCT2_template(*other_value.single_value.field_cIl__LAC);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS = new OCTETSTRING_template(*other_value.single_value.field_cIl__allInBSS);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC:
single_value.field_cIl__PLMN__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template(*other_value.single_value.field_cIl__PLMN__LAC__RNC);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC:
single_value.field_cIl__RNC = new RecordOfOCT2_template(*other_value.single_value.field_cIl__RNC);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC:
single_value.field_cIl__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template(*other_value.single_value.field_cIl__LAC__RNC);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__CellIdentificationList_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__CellIdentificationList_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
set_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationList_template::BSSMAP__FIELD__CellIdentificationList_template()
{
}

BSSMAP__FIELD__CellIdentificationList_template::BSSMAP__FIELD__CellIdentificationList_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationList_template::BSSMAP__FIELD__CellIdentificationList_template(const BSSMAP__FIELD__CellIdentificationList& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationList_template::BSSMAP__FIELD__CellIdentificationList_template(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList from an unbound optional field.");
}
}

BSSMAP__FIELD__CellIdentificationList_template::BSSMAP__FIELD__CellIdentificationList_template(BSSMAP__FIELD__CellIdentificationList_template* p_precondition, BSSMAP__FIELD__CellIdentificationList_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__CellIdentificationList_template::BSSMAP__FIELD__CellIdentificationList_template(Dynamic_Match_Interface<BSSMAP__FIELD__CellIdentificationList>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__CellIdentificationList>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__CellIdentificationList_template::BSSMAP__FIELD__CellIdentificationList_template(const BSSMAP__FIELD__CellIdentificationList_template& other_value)
: Base_Template(){
copy_template(other_value);
}

BSSMAP__FIELD__CellIdentificationList_template::~BSSMAP__FIELD__CellIdentificationList_template()
{
clean_up();
}

void BSSMAP__FIELD__CellIdentificationList_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI:
delete single_value.field_cIl__CGI;
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI:
delete single_value.field_cIl__LAC__CI;
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI:
delete single_value.field_cIl__CI;
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell:
delete single_value.field_cIl__noCell;
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI:
delete single_value.field_cIl__LAI;
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC:
delete single_value.field_cIl__LAC;
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS:
delete single_value.field_cIl__allInBSS;
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC:
delete single_value.field_cIl__PLMN__LAC__RNC;
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC:
delete single_value.field_cIl__RNC;
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC:
delete single_value.field_cIl__LAC__RNC;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__CellIdentificationList_template& BSSMAP__FIELD__CellIdentificationList_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList_template& BSSMAP__FIELD__CellIdentificationList_template::operator=(const BSSMAP__FIELD__CellIdentificationList& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList_template& BSSMAP__FIELD__CellIdentificationList_template::operator=(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
return *this;
}

BSSMAP__FIELD__CellIdentificationList_template& BSSMAP__FIELD__CellIdentificationList_template::operator=(const BSSMAP__FIELD__CellIdentificationList_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationList_template::match(const BSSMAP__FIELD__CellIdentificationList& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
BSSMAP__FIELD__CellIdentificationList::union_selection_type value_selection = other_value.get_selection();
if (value_selection == BSSMAP__FIELD__CellIdentificationList::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI:
return single_value.field_cIl__CGI->match(other_value.cIl__CGI(), legacy);
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI:
return single_value.field_cIl__LAC__CI->match(other_value.cIl__LAC__CI(), legacy);
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI:
return single_value.field_cIl__CI->match(other_value.cIl__CI(), legacy);
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell:
return single_value.field_cIl__noCell->match(other_value.cIl__noCell(), legacy);
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI:
return single_value.field_cIl__LAI->match(other_value.cIl__LAI(), legacy);
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC:
return single_value.field_cIl__LAC->match(other_value.cIl__LAC(), legacy);
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS:
return single_value.field_cIl__allInBSS->match(other_value.cIl__allInBSS(), legacy);
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC:
return single_value.field_cIl__PLMN__LAC__RNC->match(other_value.cIl__PLMN__LAC__RNC(), legacy);
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC:
return single_value.field_cIl__RNC->match(other_value.cIl__RNC(), legacy);
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC:
return single_value.field_cIl__LAC__RNC->match(other_value.cIl__LAC__RNC(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
return FALSE;
}

boolean BSSMAP__FIELD__CellIdentificationList_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI:
return single_value.field_cIl__CGI->is_value();
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI:
return single_value.field_cIl__LAC__CI->is_value();
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI:
return single_value.field_cIl__CI->is_value();
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell:
return single_value.field_cIl__noCell->is_value();
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI:
return single_value.field_cIl__LAI->is_value();
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC:
return single_value.field_cIl__LAC->is_value();
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS:
return single_value.field_cIl__allInBSS->is_value();
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC:
return single_value.field_cIl__PLMN__LAC__RNC->is_value();
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC:
return single_value.field_cIl__RNC->is_value();
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC:
return single_value.field_cIl__LAC__RNC->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
}

BSSMAP__FIELD__CellIdentificationList BSSMAP__FIELD__CellIdentificationList_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
BSSMAP__FIELD__CellIdentificationList ret_val;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI:
ret_val.cIl__CGI() = single_value.field_cIl__CGI->valueof();
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI:
ret_val.cIl__LAC__CI() = single_value.field_cIl__LAC__CI->valueof();
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI:
ret_val.cIl__CI() = single_value.field_cIl__CI->valueof();
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell:
ret_val.cIl__noCell() = single_value.field_cIl__noCell->valueof();
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI:
ret_val.cIl__LAI() = single_value.field_cIl__LAI->valueof();
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC:
ret_val.cIl__LAC() = single_value.field_cIl__LAC->valueof();
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS:
ret_val.cIl__allInBSS() = single_value.field_cIl__allInBSS->valueof();
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC:
ret_val.cIl__PLMN__LAC__RNC() = single_value.field_cIl__PLMN__LAC__RNC->valueof();
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC:
ret_val.cIl__RNC() = single_value.field_cIl__RNC->valueof();
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC:
ret_val.cIl__LAC__RNC() = single_value.field_cIl__LAC__RNC->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList_template& BSSMAP__FIELD__CellIdentificationList_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return value_list.list_value[list_index];
}
void BSSMAP__FIELD__CellIdentificationList_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList_template[list_length];
}

BSSMAP__FIELD__CellIdentificationList__CGI_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__CGI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template(ANY_VALUE);
else single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__CGI;
}

const BSSMAP__FIELD__CellIdentificationList__CGI_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__CGI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_CGI in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI) TTCN_error("Accessing non-selected field cIl_CGI in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *single_value.field_cIl__CGI;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__LAC__CI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI_template(ANY_VALUE);
else single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__LAC__CI;
}

const BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__LAC__CI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_LAC_CI in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI) TTCN_error("Accessing non-selected field cIl_LAC_CI in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *single_value.field_cIl__LAC__CI;
}

RecordOfOCT2_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__CI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__CI = new RecordOfOCT2_template(ANY_VALUE);
else single_value.field_cIl__CI = new RecordOfOCT2_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__CI;
}

const RecordOfOCT2_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__CI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_CI in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI) TTCN_error("Accessing non-selected field cIl_CI in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *single_value.field_cIl__CI;
}

OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__noCell()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__noCell = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_cIl__noCell = new OCTETSTRING_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__noCell;
}

const OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__noCell() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_noCell in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell) TTCN_error("Accessing non-selected field cIl_noCell in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *single_value.field_cIl__noCell;
}

BSSMAP__FIELD__CellIdentificationList__LAI_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__LAI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template(ANY_VALUE);
else single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__LAI;
}

const BSSMAP__FIELD__CellIdentificationList__LAI_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__LAI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_LAI in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI) TTCN_error("Accessing non-selected field cIl_LAI in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *single_value.field_cIl__LAI;
}

RecordOfOCT2_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__LAC()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__LAC = new RecordOfOCT2_template(ANY_VALUE);
else single_value.field_cIl__LAC = new RecordOfOCT2_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__LAC;
}

const RecordOfOCT2_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__LAC() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_LAC in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC) TTCN_error("Accessing non-selected field cIl_LAC in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *single_value.field_cIl__LAC;
}

OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__allInBSS()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__allInBSS = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_cIl__allInBSS = new OCTETSTRING_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__allInBSS;
}

const OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__allInBSS() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_allInBSS in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS) TTCN_error("Accessing non-selected field cIl_allInBSS in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *single_value.field_cIl__allInBSS;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__PLMN__LAC__RNC()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__PLMN__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template(ANY_VALUE);
else single_value.field_cIl__PLMN__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__PLMN__LAC__RNC;
}

const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__PLMN__LAC__RNC() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_PLMN_LAC_RNC in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC) TTCN_error("Accessing non-selected field cIl_PLMN_LAC_RNC in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *single_value.field_cIl__PLMN__LAC__RNC;
}

RecordOfOCT2_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__RNC()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__RNC = new RecordOfOCT2_template(ANY_VALUE);
else single_value.field_cIl__RNC = new RecordOfOCT2_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__RNC;
}

const RecordOfOCT2_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__RNC() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_RNC in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC) TTCN_error("Accessing non-selected field cIl_RNC in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *single_value.field_cIl__RNC;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__LAC__RNC()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template(ANY_VALUE);
else single_value.field_cIl__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__LAC__RNC;
}

const BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList_template::cIl__LAC__RNC() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_LAC_RNC in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC) TTCN_error("Accessing non-selected field cIl_LAC_RNC in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return *single_value.field_cIl__LAC__RNC;
}

boolean BSSMAP__FIELD__CellIdentificationList_template::ischosen(BSSMAP__FIELD__CellIdentificationList::union_selection_type checked_selection) const
{
if (checked_selection == BSSMAP__FIELD__CellIdentificationList::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == BSSMAP__FIELD__CellIdentificationList::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationList_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI:
TTCN_Logger::log_event_str("{ cIl_CGI := ");
single_value.field_cIl__CGI->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI:
TTCN_Logger::log_event_str("{ cIl_LAC_CI := ");
single_value.field_cIl__LAC__CI->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI:
TTCN_Logger::log_event_str("{ cIl_CI := ");
single_value.field_cIl__CI->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell:
TTCN_Logger::log_event_str("{ cIl_noCell := ");
single_value.field_cIl__noCell->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI:
TTCN_Logger::log_event_str("{ cIl_LAI := ");
single_value.field_cIl__LAI->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC:
TTCN_Logger::log_event_str("{ cIl_LAC := ");
single_value.field_cIl__LAC->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS:
TTCN_Logger::log_event_str("{ cIl_allInBSS := ");
single_value.field_cIl__allInBSS->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC:
TTCN_Logger::log_event_str("{ cIl_PLMN_LAC_RNC := ");
single_value.field_cIl__PLMN__LAC__RNC->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC:
TTCN_Logger::log_event_str("{ cIl_RNC := ");
single_value.field_cIl__RNC->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC:
TTCN_Logger::log_event_str("{ cIl_LAC_RNC := ");
single_value.field_cIl__LAC__RNC->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationList_template::log_match(const BSSMAP__FIELD__CellIdentificationList& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_CGI");
single_value.field_cIl__CGI->log_match(match_value.cIl__CGI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_CGI := ");
single_value.field_cIl__CGI->log_match(match_value.cIl__CGI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_LAC_CI");
single_value.field_cIl__LAC__CI->log_match(match_value.cIl__LAC__CI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_LAC_CI := ");
single_value.field_cIl__LAC__CI->log_match(match_value.cIl__LAC__CI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_CI");
single_value.field_cIl__CI->log_match(match_value.cIl__CI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_CI := ");
single_value.field_cIl__CI->log_match(match_value.cIl__CI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_noCell");
single_value.field_cIl__noCell->log_match(match_value.cIl__noCell(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_noCell := ");
single_value.field_cIl__noCell->log_match(match_value.cIl__noCell(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_LAI");
single_value.field_cIl__LAI->log_match(match_value.cIl__LAI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_LAI := ");
single_value.field_cIl__LAI->log_match(match_value.cIl__LAI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_LAC");
single_value.field_cIl__LAC->log_match(match_value.cIl__LAC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_LAC := ");
single_value.field_cIl__LAC->log_match(match_value.cIl__LAC(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_allInBSS");
single_value.field_cIl__allInBSS->log_match(match_value.cIl__allInBSS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_allInBSS := ");
single_value.field_cIl__allInBSS->log_match(match_value.cIl__allInBSS(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_PLMN_LAC_RNC");
single_value.field_cIl__PLMN__LAC__RNC->log_match(match_value.cIl__PLMN__LAC__RNC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_PLMN_LAC_RNC := ");
single_value.field_cIl__PLMN__LAC__RNC->log_match(match_value.cIl__PLMN__LAC__RNC(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_RNC");
single_value.field_cIl__RNC->log_match(match_value.cIl__RNC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_RNC := ");
single_value.field_cIl__RNC->log_match(match_value.cIl__RNC(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_LAC_RNC");
single_value.field_cIl__LAC__RNC->log_match(match_value.cIl__LAC__RNC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_LAC_RNC := ");
single_value.field_cIl__LAC__RNC->log_match(match_value.cIl__LAC__RNC(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__CellIdentificationList_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI:
single_value.field_cIl__CGI->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI:
single_value.field_cIl__CI->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell:
single_value.field_cIl__noCell->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI:
single_value.field_cIl__LAI->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC:
single_value.field_cIl__LAC->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC:
single_value.field_cIl__PLMN__LAC__RNC->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC:
single_value.field_cIl__RNC->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC:
single_value.field_cIl__LAC__RNC->set_implicit_omit(); break;
default: break;
}
}

void BSSMAP__FIELD__CellIdentificationList_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI:
single_value.field_cIl__CGI->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI:
single_value.field_cIl__CI->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell:
single_value.field_cIl__noCell->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI:
single_value.field_cIl__LAI->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC:
single_value.field_cIl__LAC->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC:
single_value.field_cIl__PLMN__LAC__RNC->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC:
single_value.field_cIl__RNC->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC:
single_value.field_cIl__LAC__RNC->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
}

void BSSMAP__FIELD__CellIdentificationList_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = BSSMAP__FIELD__CellIdentificationList::UNBOUND_VALUE;
BSSMAP__FIELD__CellIdentificationList::union_selection_type new_selection = (BSSMAP__FIELD__CellIdentificationList::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI:
single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template;
single_value.field_cIl__CGI->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI_template;
single_value.field_cIl__LAC__CI->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI:
single_value.field_cIl__CI = new RecordOfOCT2_template;
single_value.field_cIl__CI->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell:
single_value.field_cIl__noCell = new OCTETSTRING_template;
single_value.field_cIl__noCell->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI:
single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template;
single_value.field_cIl__LAI->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC:
single_value.field_cIl__LAC = new RecordOfOCT2_template;
single_value.field_cIl__LAC->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS = new OCTETSTRING_template;
single_value.field_cIl__allInBSS->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC:
single_value.field_cIl__PLMN__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template;
single_value.field_cIl__PLMN__LAC__RNC->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC:
single_value.field_cIl__RNC = new RecordOfOCT2_template;
single_value.field_cIl__RNC->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC:
single_value.field_cIl__LAC__RNC = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template;
single_value.field_cIl__LAC__RNC->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
}

boolean BSSMAP__FIELD__CellIdentificationList_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__CellIdentificationList_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationList_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList'");
    }
    if (strcmp("cIl_CGI", param_field) == 0) {
      cIl__CGI().set_param(param);
      return;
    } else if (strcmp("cIl_LAC_CI", param_field) == 0) {
      cIl__LAC__CI().set_param(param);
      return;
    } else if (strcmp("cIl_CI", param_field) == 0) {
      cIl__CI().set_param(param);
      return;
    } else if (strcmp("cIl_noCell", param_field) == 0) {
      cIl__noCell().set_param(param);
      return;
    } else if (strcmp("cIl_LAI", param_field) == 0) {
      cIl__LAI().set_param(param);
      return;
    } else if (strcmp("cIl_LAC", param_field) == 0) {
      cIl__LAC().set_param(param);
      return;
    } else if (strcmp("cIl_allInBSS", param_field) == 0) {
      cIl__allInBSS().set_param(param);
      return;
    } else if (strcmp("cIl_PLMN_LAC_RNC", param_field) == 0) {
      cIl__PLMN__LAC__RNC().set_param(param);
      return;
    } else if (strcmp("cIl_RNC", param_field) == 0) {
      cIl__RNC().set_param(param);
      return;
    } else if (strcmp("cIl_LAC_RNC", param_field) == 0) {
      cIl__LAC__RNC().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__CellIdentificationList_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "cIl_CGI")) {
      cIl__CGI().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_LAC_CI")) {
      cIl__LAC__CI().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_CI")) {
      cIl__CI().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_noCell")) {
      cIl__noCell().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_LAI")) {
      cIl__LAI().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_LAC")) {
      cIl__LAC().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_allInBSS")) {
      cIl__allInBSS().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_PLMN_LAC_RNC")) {
      cIl__PLMN__LAC__RNC().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_RNC")) {
      cIl__RNC().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_LAC_RNC")) {
      cIl__LAC__RNC().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__CellIdentificationList_template* precondition = new BSSMAP__FIELD__CellIdentificationList_template;
    precondition->set_param(*m_p->get_elem(0));
    BSSMAP__FIELD__CellIdentificationList_template* implied_template = new BSSMAP__FIELD__CellIdentificationList_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = BSSMAP__FIELD__CellIdentificationList_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationList_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI:
single_value.field_cIl__CGI->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList");
return;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList");
return;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI:
single_value.field_cIl__CI->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList");
return;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell:
single_value.field_cIl__noCell->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList");
return;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI:
single_value.field_cIl__LAI->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList");
return;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC:
single_value.field_cIl__LAC->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList");
return;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList");
return;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC:
single_value.field_cIl__PLMN__LAC__RNC->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList");
return;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC:
single_value.field_cIl__RNC->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList");
return;
case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC:
single_value.field_cIl__LAC__RNC->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList");
}


const BSSMAP__FIELD__CellIdentification__CGI BSSMAP__FIELD__CellIdentificationList__CGI::UNBOUND_ELEM;
BSSMAP__FIELD__CellIdentificationList__CGI::BSSMAP__FIELD__CellIdentificationList__CGI()
{
val_ptr = NULL;
}

BSSMAP__FIELD__CellIdentificationList__CGI::BSSMAP__FIELD__CellIdentificationList__CGI(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

BSSMAP__FIELD__CellIdentificationList__CGI::BSSMAP__FIELD__CellIdentificationList__CGI(const BSSMAP__FIELD__CellIdentificationList__CGI& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

BSSMAP__FIELD__CellIdentificationList__CGI::~BSSMAP__FIELD__CellIdentificationList__CGI()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void BSSMAP__FIELD__CellIdentificationList__CGI::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

BSSMAP__FIELD__CellIdentificationList__CGI& BSSMAP__FIELD__CellIdentificationList__CGI::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

BSSMAP__FIELD__CellIdentificationList__CGI& BSSMAP__FIELD__CellIdentificationList__CGI::operator=(const BSSMAP__FIELD__CellIdentificationList__CGI& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationList__CGI::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
return val_ptr->n_elements == 0 ;
}

boolean BSSMAP__FIELD__CellIdentificationList__CGI::operator==(const BSSMAP__FIELD__CellIdentificationList__CGI& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

BSSMAP__FIELD__CellIdentification__CGI& BSSMAP__FIELD__CellIdentificationList__CGI::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__CGI**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__CGI(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new BSSMAP__FIELD__CellIdentification__CGI;
}
return *val_ptr->value_elements[index_value];
}

BSSMAP__FIELD__CellIdentification__CGI& BSSMAP__FIELD__CellIdentificationList__CGI::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__CellIdentification__CGI& BSSMAP__FIELD__CellIdentificationList__CGI::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const BSSMAP__FIELD__CellIdentification__CGI& BSSMAP__FIELD__CellIdentificationList__CGI::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
return (*this)[(int)index_value];
}

BSSMAP__FIELD__CellIdentificationList__CGI BSSMAP__FIELD__CellIdentificationList__CGI::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

BSSMAP__FIELD__CellIdentificationList__CGI BSSMAP__FIELD__CellIdentificationList__CGI::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

BSSMAP__FIELD__CellIdentificationList__CGI BSSMAP__FIELD__CellIdentificationList__CGI::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

BSSMAP__FIELD__CellIdentificationList__CGI BSSMAP__FIELD__CellIdentificationList__CGI::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
BSSMAP__FIELD__CellIdentificationList__CGI ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new BSSMAP__FIELD__CellIdentification__CGI(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__CGI BSSMAP__FIELD__CellIdentificationList__CGI::operator+(const BSSMAP__FIELD__CellIdentificationList__CGI& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
BSSMAP__FIELD__CellIdentificationList__CGI ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__CGI(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new BSSMAP__FIELD__CellIdentification__CGI(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__CGI BSSMAP__FIELD__CellIdentificationList__CGI::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI","element");
BSSMAP__FIELD__CellIdentificationList__CGI ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__CGI(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__CGI BSSMAP__FIELD__CellIdentificationList__CGI::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__CGI& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
check_replace_arguments(val_ptr->n_elements, index, len, "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI","element");
BSSMAP__FIELD__CellIdentificationList__CGI ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__CGI(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new BSSMAP__FIELD__CellIdentification__CGI(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new BSSMAP__FIELD__CellIdentification__CGI(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__CGI BSSMAP__FIELD__CellIdentificationList__CGI::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__CGI_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void BSSMAP__FIELD__CellIdentificationList__CGI::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__CGI**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__CGI(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__CGI**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__CGI**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean BSSMAP__FIELD__CellIdentificationList__CGI::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int BSSMAP__FIELD__CellIdentificationList__CGI::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
return val_ptr->n_elements;
}

int BSSMAP__FIELD__CellIdentificationList__CGI::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void BSSMAP__FIELD__CellIdentificationList__CGI::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void BSSMAP__FIELD__CellIdentificationList__CGI::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__CellIdentificationList__CGI::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void BSSMAP__FIELD__CellIdentificationList__CGI::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void BSSMAP__FIELD__CellIdentificationList__CGI::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__CGI**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__CGI;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void BSSMAP__FIELD__CellIdentificationList__CGI::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__CellIdentificationList__CGI::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__CellIdentificationList__CGI::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int BSSMAP__FIELD__CellIdentificationList__CGI::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void BSSMAP__FIELD__CellIdentificationList__CGI_template::copy_value(const BSSMAP__FIELD__CellIdentificationList__CGI& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__CGI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__CGI_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__CGI_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__CellIdentificationList__CGI_template::copy_template(const BSSMAP__FIELD__CellIdentificationList__CGI_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__CGI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__CGI_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__CGI_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__CGI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__CellIdentificationList__CGI_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__CellIdentificationList__CGI_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
break;
}
set_selection(other_value);
}

boolean BSSMAP__FIELD__CellIdentificationList__CGI_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const BSSMAP__FIELD__CellIdentificationList__CGI_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const BSSMAP__FIELD__CellIdentificationList__CGI*)value_ptr)[value_index], legacy);
else return ((const BSSMAP__FIELD__CellIdentificationList__CGI_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

BSSMAP__FIELD__CellIdentificationList__CGI_template::BSSMAP__FIELD__CellIdentificationList__CGI_template()
{
}

BSSMAP__FIELD__CellIdentificationList__CGI_template::BSSMAP__FIELD__CellIdentificationList__CGI_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationList__CGI_template::BSSMAP__FIELD__CellIdentificationList__CGI_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

BSSMAP__FIELD__CellIdentificationList__CGI_template::BSSMAP__FIELD__CellIdentificationList__CGI_template(const BSSMAP__FIELD__CellIdentificationList__CGI& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationList__CGI_template::BSSMAP__FIELD__CellIdentificationList__CGI_template(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__CGI>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__CGI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI from an unbound optional field.");
}
}

BSSMAP__FIELD__CellIdentificationList__CGI_template::BSSMAP__FIELD__CellIdentificationList__CGI_template(BSSMAP__FIELD__CellIdentificationList__CGI_template* p_precondition, BSSMAP__FIELD__CellIdentificationList__CGI_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__CellIdentificationList__CGI_template::BSSMAP__FIELD__CellIdentificationList__CGI_template(Dynamic_Match_Interface<BSSMAP__FIELD__CellIdentificationList__CGI>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__CellIdentificationList__CGI>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__CellIdentificationList__CGI_template::BSSMAP__FIELD__CellIdentificationList__CGI_template(const BSSMAP__FIELD__CellIdentificationList__CGI_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

BSSMAP__FIELD__CellIdentificationList__CGI_template::~BSSMAP__FIELD__CellIdentificationList__CGI_template()
{
clean_up();
}

void BSSMAP__FIELD__CellIdentificationList__CGI_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__CellIdentificationList__CGI_template& BSSMAP__FIELD__CellIdentificationList__CGI_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__CGI_template& BSSMAP__FIELD__CellIdentificationList__CGI_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

BSSMAP__FIELD__CellIdentificationList__CGI_template& BSSMAP__FIELD__CellIdentificationList__CGI_template::operator=(const BSSMAP__FIELD__CellIdentificationList__CGI& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__CGI_template& BSSMAP__FIELD__CellIdentificationList__CGI_template::operator=(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__CGI>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__CGI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
}
return *this;
}

BSSMAP__FIELD__CellIdentificationList__CGI_template& BSSMAP__FIELD__CellIdentificationList__CGI_template::operator=(const BSSMAP__FIELD__CellIdentificationList__CGI_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

BSSMAP__FIELD__CellIdentification__CGI_template& BSSMAP__FIELD__CellIdentificationList__CGI_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
    break;
}
return *single_value.value_elements[index_value];
}

BSSMAP__FIELD__CellIdentification__CGI_template& BSSMAP__FIELD__CellIdentificationList__CGI_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__CellIdentification__CGI_template& BSSMAP__FIELD__CellIdentificationList__CGI_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const BSSMAP__FIELD__CellIdentification__CGI_template& BSSMAP__FIELD__CellIdentificationList__CGI_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
return (*this)[(int)index_value];
}

void BSSMAP__FIELD__CellIdentificationList__CGI_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__CGI_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__CGI_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__CGI_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__CGI_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int BSSMAP__FIELD__CellIdentificationList__CGI_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int BSSMAP__FIELD__CellIdentificationList__CGI_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI");
}

boolean BSSMAP__FIELD__CellIdentificationList__CGI_template::match(const BSSMAP__FIELD__CellIdentificationList__CGI& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
}
return FALSE;
}

boolean BSSMAP__FIELD__CellIdentificationList__CGI_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

BSSMAP__FIELD__CellIdentificationList__CGI BSSMAP__FIELD__CellIdentificationList__CGI_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
BSSMAP__FIELD__CellIdentificationList__CGI ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__CGI BSSMAP__FIELD__CellIdentificationList__CGI_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

BSSMAP__FIELD__CellIdentificationList__CGI BSSMAP__FIELD__CellIdentificationList__CGI_template::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__CGI_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

BSSMAP__FIELD__CellIdentificationList__CGI BSSMAP__FIELD__CellIdentificationList__CGI_template::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__CGI& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void BSSMAP__FIELD__CellIdentificationList__CGI_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__CGI_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
}
set_selection(template_type);
}

BSSMAP__FIELD__CellIdentificationList__CGI_template& BSSMAP__FIELD__CellIdentificationList__CGI_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
return value_list.list_value[list_index];
}

void BSSMAP__FIELD__CellIdentificationList__CGI_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationList__CGI_template::log_match(const BSSMAP__FIELD__CellIdentificationList__CGI& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__CellIdentificationList__CGI_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
}
}

void BSSMAP__FIELD__CellIdentificationList__CGI_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__CGI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__CGI_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__CGI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI.");
}
}

boolean BSSMAP__FIELD__CellIdentificationList__CGI_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__CellIdentificationList__CGI_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationList__CGI_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__CellIdentificationList__CGI_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__CellIdentificationList__CGI_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__CellIdentificationList__CGI_template* precondition = new BSSMAP__FIELD__CellIdentificationList__CGI_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__FIELD__CellIdentificationList__CGI_template* implied_template = new BSSMAP__FIELD__CellIdentificationList__CGI_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__FIELD__CellIdentificationList__CGI_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void BSSMAP__FIELD__CellIdentificationList__CGI_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CGI");
}

boolean BSSMAP__FIELD__CellIdentificationList__CGI_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}

const BSSMAP__FIELD__CellIdentification__LAC__CI BSSMAP__FIELD__CellIdentificationList__LAC__CI::UNBOUND_ELEM;
BSSMAP__FIELD__CellIdentificationList__LAC__CI::BSSMAP__FIELD__CellIdentificationList__LAC__CI()
{
val_ptr = NULL;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI::BSSMAP__FIELD__CellIdentificationList__LAC__CI(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI::BSSMAP__FIELD__CellIdentificationList__LAC__CI(const BSSMAP__FIELD__CellIdentificationList__LAC__CI& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI::~BSSMAP__FIELD__CellIdentificationList__LAC__CI()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI& BSSMAP__FIELD__CellIdentificationList__LAC__CI::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI& BSSMAP__FIELD__CellIdentificationList__LAC__CI::operator=(const BSSMAP__FIELD__CellIdentificationList__LAC__CI& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
return val_ptr->n_elements == 0 ;
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI::operator==(const BSSMAP__FIELD__CellIdentificationList__LAC__CI& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

BSSMAP__FIELD__CellIdentification__LAC__CI& BSSMAP__FIELD__CellIdentificationList__LAC__CI::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAC__CI**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__CI(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new BSSMAP__FIELD__CellIdentification__LAC__CI;
}
return *val_ptr->value_elements[index_value];
}

BSSMAP__FIELD__CellIdentification__LAC__CI& BSSMAP__FIELD__CellIdentificationList__LAC__CI::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__CellIdentification__LAC__CI& BSSMAP__FIELD__CellIdentificationList__LAC__CI::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const BSSMAP__FIELD__CellIdentification__LAC__CI& BSSMAP__FIELD__CellIdentificationList__LAC__CI::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
return (*this)[(int)index_value];
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI BSSMAP__FIELD__CellIdentificationList__LAC__CI::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI BSSMAP__FIELD__CellIdentificationList__LAC__CI::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI BSSMAP__FIELD__CellIdentificationList__LAC__CI::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI BSSMAP__FIELD__CellIdentificationList__LAC__CI::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
BSSMAP__FIELD__CellIdentificationList__LAC__CI ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new BSSMAP__FIELD__CellIdentification__LAC__CI(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI BSSMAP__FIELD__CellIdentificationList__LAC__CI::operator+(const BSSMAP__FIELD__CellIdentificationList__LAC__CI& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
BSSMAP__FIELD__CellIdentificationList__LAC__CI ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__LAC__CI(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new BSSMAP__FIELD__CellIdentification__LAC__CI(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI BSSMAP__FIELD__CellIdentificationList__LAC__CI::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI","element");
BSSMAP__FIELD__CellIdentificationList__LAC__CI ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__LAC__CI(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI BSSMAP__FIELD__CellIdentificationList__LAC__CI::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__LAC__CI& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
check_replace_arguments(val_ptr->n_elements, index, len, "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI","element");
BSSMAP__FIELD__CellIdentificationList__LAC__CI ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__LAC__CI(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new BSSMAP__FIELD__CellIdentification__LAC__CI(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new BSSMAP__FIELD__CellIdentification__LAC__CI(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI BSSMAP__FIELD__CellIdentificationList__LAC__CI::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAC__CI**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__CI(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAC__CI**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAC__CI**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int BSSMAP__FIELD__CellIdentificationList__LAC__CI::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
return val_ptr->n_elements;
}

int BSSMAP__FIELD__CellIdentificationList__LAC__CI::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAC__CI**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__CI;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__CellIdentificationList__LAC__CI::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int BSSMAP__FIELD__CellIdentificationList__LAC__CI::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::copy_value(const BSSMAP__FIELD__CellIdentificationList__LAC__CI& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAC__CI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__CI_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__CI_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::copy_template(const BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAC__CI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__CI_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__CI_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__LAC__CI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__CellIdentificationList__LAC__CI_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__CellIdentificationList__LAC__CI_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
break;
}
set_selection(other_value);
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const BSSMAP__FIELD__CellIdentificationList__LAC__CI_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const BSSMAP__FIELD__CellIdentificationList__LAC__CI*)value_ptr)[value_index], legacy);
else return ((const BSSMAP__FIELD__CellIdentificationList__LAC__CI_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI_template()
{
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI_template(const BSSMAP__FIELD__CellIdentificationList__LAC__CI& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI_template(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__LAC__CI>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__LAC__CI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI from an unbound optional field.");
}
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI_template(BSSMAP__FIELD__CellIdentificationList__LAC__CI_template* p_precondition, BSSMAP__FIELD__CellIdentificationList__LAC__CI_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI_template(Dynamic_Match_Interface<BSSMAP__FIELD__CellIdentificationList__LAC__CI>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__CellIdentificationList__LAC__CI>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI_template(const BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::~BSSMAP__FIELD__CellIdentificationList__LAC__CI_template()
{
clean_up();
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::operator=(const BSSMAP__FIELD__CellIdentificationList__LAC__CI& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::operator=(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__LAC__CI>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__LAC__CI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
}
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::operator=(const BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

BSSMAP__FIELD__CellIdentification__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
    break;
}
return *single_value.value_elements[index_value];
}

BSSMAP__FIELD__CellIdentification__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__CellIdentification__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const BSSMAP__FIELD__CellIdentification__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
return (*this)[(int)index_value];
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAC__CI_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__CI_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__CI_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAC__CI_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI");
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::match(const BSSMAP__FIELD__CellIdentificationList__LAC__CI& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
}
return FALSE;
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
BSSMAP__FIELD__CellIdentificationList__LAC__CI ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__LAC__CI& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__LAC__CI_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
}
set_selection(template_type);
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
return value_list.list_value[list_index];
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::log_match(const BSSMAP__FIELD__CellIdentificationList__LAC__CI& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAC__CI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__CI_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__LAC__CI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI.");
}
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__CellIdentificationList__LAC__CI_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__CellIdentificationList__LAC__CI_template* precondition = new BSSMAP__FIELD__CellIdentificationList__LAC__CI_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__FIELD__CellIdentificationList__LAC__CI_template* implied_template = new BSSMAP__FIELD__CellIdentificationList__LAC__CI_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__FIELD__CellIdentificationList__LAC__CI_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI");
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}

const BSSMAP__FIELD__CellIdentification__LAI BSSMAP__FIELD__CellIdentificationList__LAI::UNBOUND_ELEM;
BSSMAP__FIELD__CellIdentificationList__LAI::BSSMAP__FIELD__CellIdentificationList__LAI()
{
val_ptr = NULL;
}

BSSMAP__FIELD__CellIdentificationList__LAI::BSSMAP__FIELD__CellIdentificationList__LAI(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

BSSMAP__FIELD__CellIdentificationList__LAI::BSSMAP__FIELD__CellIdentificationList__LAI(const BSSMAP__FIELD__CellIdentificationList__LAI& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

BSSMAP__FIELD__CellIdentificationList__LAI::~BSSMAP__FIELD__CellIdentificationList__LAI()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void BSSMAP__FIELD__CellIdentificationList__LAI::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

BSSMAP__FIELD__CellIdentificationList__LAI& BSSMAP__FIELD__CellIdentificationList__LAI::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAI& BSSMAP__FIELD__CellIdentificationList__LAI::operator=(const BSSMAP__FIELD__CellIdentificationList__LAI& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationList__LAI::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
return val_ptr->n_elements == 0 ;
}

boolean BSSMAP__FIELD__CellIdentificationList__LAI::operator==(const BSSMAP__FIELD__CellIdentificationList__LAI& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

BSSMAP__FIELD__CellIdentification__LAI& BSSMAP__FIELD__CellIdentificationList__LAI::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAI**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAI(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new BSSMAP__FIELD__CellIdentification__LAI;
}
return *val_ptr->value_elements[index_value];
}

BSSMAP__FIELD__CellIdentification__LAI& BSSMAP__FIELD__CellIdentificationList__LAI::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__CellIdentification__LAI& BSSMAP__FIELD__CellIdentificationList__LAI::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const BSSMAP__FIELD__CellIdentification__LAI& BSSMAP__FIELD__CellIdentificationList__LAI::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
return (*this)[(int)index_value];
}

BSSMAP__FIELD__CellIdentificationList__LAI BSSMAP__FIELD__CellIdentificationList__LAI::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

BSSMAP__FIELD__CellIdentificationList__LAI BSSMAP__FIELD__CellIdentificationList__LAI::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

BSSMAP__FIELD__CellIdentificationList__LAI BSSMAP__FIELD__CellIdentificationList__LAI::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

BSSMAP__FIELD__CellIdentificationList__LAI BSSMAP__FIELD__CellIdentificationList__LAI::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
BSSMAP__FIELD__CellIdentificationList__LAI ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new BSSMAP__FIELD__CellIdentification__LAI(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAI BSSMAP__FIELD__CellIdentificationList__LAI::operator+(const BSSMAP__FIELD__CellIdentificationList__LAI& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
BSSMAP__FIELD__CellIdentificationList__LAI ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__LAI(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new BSSMAP__FIELD__CellIdentification__LAI(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAI BSSMAP__FIELD__CellIdentificationList__LAI::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI","element");
BSSMAP__FIELD__CellIdentificationList__LAI ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__LAI(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAI BSSMAP__FIELD__CellIdentificationList__LAI::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__LAI& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
check_replace_arguments(val_ptr->n_elements, index, len, "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI","element");
BSSMAP__FIELD__CellIdentificationList__LAI ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__LAI(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new BSSMAP__FIELD__CellIdentification__LAI(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new BSSMAP__FIELD__CellIdentification__LAI(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAI BSSMAP__FIELD__CellIdentificationList__LAI::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__LAI_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void BSSMAP__FIELD__CellIdentificationList__LAI::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAI**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAI(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAI**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAI**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean BSSMAP__FIELD__CellIdentificationList__LAI::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int BSSMAP__FIELD__CellIdentificationList__LAI::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
return val_ptr->n_elements;
}

int BSSMAP__FIELD__CellIdentificationList__LAI::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void BSSMAP__FIELD__CellIdentificationList__LAI::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void BSSMAP__FIELD__CellIdentificationList__LAI::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__CellIdentificationList__LAI::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void BSSMAP__FIELD__CellIdentificationList__LAI::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void BSSMAP__FIELD__CellIdentificationList__LAI::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAI**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAI;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void BSSMAP__FIELD__CellIdentificationList__LAI::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__CellIdentificationList__LAI::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__CellIdentificationList__LAI::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int BSSMAP__FIELD__CellIdentificationList__LAI::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void BSSMAP__FIELD__CellIdentificationList__LAI_template::copy_value(const BSSMAP__FIELD__CellIdentificationList__LAI& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAI_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAI_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__CellIdentificationList__LAI_template::copy_template(const BSSMAP__FIELD__CellIdentificationList__LAI_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAI_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAI_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__LAI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__CellIdentificationList__LAI_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__CellIdentificationList__LAI_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
break;
}
set_selection(other_value);
}

boolean BSSMAP__FIELD__CellIdentificationList__LAI_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const BSSMAP__FIELD__CellIdentificationList__LAI_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const BSSMAP__FIELD__CellIdentificationList__LAI*)value_ptr)[value_index], legacy);
else return ((const BSSMAP__FIELD__CellIdentificationList__LAI_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

BSSMAP__FIELD__CellIdentificationList__LAI_template::BSSMAP__FIELD__CellIdentificationList__LAI_template()
{
}

BSSMAP__FIELD__CellIdentificationList__LAI_template::BSSMAP__FIELD__CellIdentificationList__LAI_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationList__LAI_template::BSSMAP__FIELD__CellIdentificationList__LAI_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

BSSMAP__FIELD__CellIdentificationList__LAI_template::BSSMAP__FIELD__CellIdentificationList__LAI_template(const BSSMAP__FIELD__CellIdentificationList__LAI& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationList__LAI_template::BSSMAP__FIELD__CellIdentificationList__LAI_template(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__LAI>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__LAI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI from an unbound optional field.");
}
}

BSSMAP__FIELD__CellIdentificationList__LAI_template::BSSMAP__FIELD__CellIdentificationList__LAI_template(BSSMAP__FIELD__CellIdentificationList__LAI_template* p_precondition, BSSMAP__FIELD__CellIdentificationList__LAI_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__CellIdentificationList__LAI_template::BSSMAP__FIELD__CellIdentificationList__LAI_template(Dynamic_Match_Interface<BSSMAP__FIELD__CellIdentificationList__LAI>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__CellIdentificationList__LAI>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__CellIdentificationList__LAI_template::BSSMAP__FIELD__CellIdentificationList__LAI_template(const BSSMAP__FIELD__CellIdentificationList__LAI_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

BSSMAP__FIELD__CellIdentificationList__LAI_template::~BSSMAP__FIELD__CellIdentificationList__LAI_template()
{
clean_up();
}

void BSSMAP__FIELD__CellIdentificationList__LAI_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__CellIdentificationList__LAI_template& BSSMAP__FIELD__CellIdentificationList__LAI_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAI_template& BSSMAP__FIELD__CellIdentificationList__LAI_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAI_template& BSSMAP__FIELD__CellIdentificationList__LAI_template::operator=(const BSSMAP__FIELD__CellIdentificationList__LAI& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAI_template& BSSMAP__FIELD__CellIdentificationList__LAI_template::operator=(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__LAI>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__LAI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
}
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAI_template& BSSMAP__FIELD__CellIdentificationList__LAI_template::operator=(const BSSMAP__FIELD__CellIdentificationList__LAI_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

BSSMAP__FIELD__CellIdentification__LAI_template& BSSMAP__FIELD__CellIdentificationList__LAI_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
    break;
}
return *single_value.value_elements[index_value];
}

BSSMAP__FIELD__CellIdentification__LAI_template& BSSMAP__FIELD__CellIdentificationList__LAI_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__CellIdentification__LAI_template& BSSMAP__FIELD__CellIdentificationList__LAI_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const BSSMAP__FIELD__CellIdentification__LAI_template& BSSMAP__FIELD__CellIdentificationList__LAI_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
return (*this)[(int)index_value];
}

void BSSMAP__FIELD__CellIdentificationList__LAI_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAI_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAI_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAI_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAI_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int BSSMAP__FIELD__CellIdentificationList__LAI_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int BSSMAP__FIELD__CellIdentificationList__LAI_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI");
}

boolean BSSMAP__FIELD__CellIdentificationList__LAI_template::match(const BSSMAP__FIELD__CellIdentificationList__LAI& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
}
return FALSE;
}

boolean BSSMAP__FIELD__CellIdentificationList__LAI_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

BSSMAP__FIELD__CellIdentificationList__LAI BSSMAP__FIELD__CellIdentificationList__LAI_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
BSSMAP__FIELD__CellIdentificationList__LAI ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAI BSSMAP__FIELD__CellIdentificationList__LAI_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

BSSMAP__FIELD__CellIdentificationList__LAI BSSMAP__FIELD__CellIdentificationList__LAI_template::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__LAI_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

BSSMAP__FIELD__CellIdentificationList__LAI BSSMAP__FIELD__CellIdentificationList__LAI_template::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__LAI& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void BSSMAP__FIELD__CellIdentificationList__LAI_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__LAI_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
}
set_selection(template_type);
}

BSSMAP__FIELD__CellIdentificationList__LAI_template& BSSMAP__FIELD__CellIdentificationList__LAI_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
return value_list.list_value[list_index];
}

void BSSMAP__FIELD__CellIdentificationList__LAI_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationList__LAI_template::log_match(const BSSMAP__FIELD__CellIdentificationList__LAI& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__CellIdentificationList__LAI_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
}
}

void BSSMAP__FIELD__CellIdentificationList__LAI_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAI_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__LAI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI.");
}
}

boolean BSSMAP__FIELD__CellIdentificationList__LAI_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__CellIdentificationList__LAI_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationList__LAI_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__CellIdentificationList__LAI_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__CellIdentificationList__LAI_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__CellIdentificationList__LAI_template* precondition = new BSSMAP__FIELD__CellIdentificationList__LAI_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__FIELD__CellIdentificationList__LAI_template* implied_template = new BSSMAP__FIELD__CellIdentificationList__LAI_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__FIELD__CellIdentificationList__LAI_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void BSSMAP__FIELD__CellIdentificationList__LAI_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAI");
}

boolean BSSMAP__FIELD__CellIdentificationList__LAI_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}

const BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::UNBOUND_ELEM;
BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC()
{
val_ptr = NULL;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC(const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::~BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::operator=(const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
return val_ptr->n_elements == 0 ;
}

boolean BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::operator==(const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC;
}
return *val_ptr->value_elements[index_value];
}

BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
return (*this)[(int)index_value];
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::operator+(const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC","element");
BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
check_replace_arguments(val_ptr->n_elements, index, len, "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC","element");
BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
return val_ptr->n_elements;
}

int BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::copy_value(const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::copy_template(const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
break;
}
set_selection(other_value);
}

boolean BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC*)value_ptr)[value_index], legacy);
else return ((const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template()
{
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template(const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC from an unbound optional field.");
}
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template(BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template* p_precondition, BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template(Dynamic_Match_Interface<BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template(const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::~BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template()
{
clean_up();
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::operator=(const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::operator=(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
}
return *this;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::operator=(const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
    break;
}
return *single_value.value_elements[index_value];
}

BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
return (*this)[(int)index_value];
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC");
}

boolean BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::match(const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
}
return FALSE;
}

boolean BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
}
set_selection(template_type);
}

BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
return value_list.list_value[list_index];
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::log_match(const BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
}
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__PLMN__LAC__RNC_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC.");
}
}

boolean BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template* precondition = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template* implied_template = new BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_PLMN_LAC_RNC");
}

boolean BSSMAP__FIELD__CellIdentificationList__PLMN__LAC__RNC_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}

const BSSMAP__FIELD__CellIdentification__LAC__RNC BSSMAP__FIELD__CellIdentificationList__LAC__RNC::UNBOUND_ELEM;
BSSMAP__FIELD__CellIdentificationList__LAC__RNC::BSSMAP__FIELD__CellIdentificationList__LAC__RNC()
{
val_ptr = NULL;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC::BSSMAP__FIELD__CellIdentificationList__LAC__RNC(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC::BSSMAP__FIELD__CellIdentificationList__LAC__RNC(const BSSMAP__FIELD__CellIdentificationList__LAC__RNC& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC::~BSSMAP__FIELD__CellIdentificationList__LAC__RNC()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC& BSSMAP__FIELD__CellIdentificationList__LAC__RNC::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC& BSSMAP__FIELD__CellIdentificationList__LAC__RNC::operator=(const BSSMAP__FIELD__CellIdentificationList__LAC__RNC& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__RNC::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
return val_ptr->n_elements == 0 ;
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__RNC::operator==(const BSSMAP__FIELD__CellIdentificationList__LAC__RNC& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

BSSMAP__FIELD__CellIdentification__LAC__RNC& BSSMAP__FIELD__CellIdentificationList__LAC__RNC::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAC__RNC**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__RNC(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new BSSMAP__FIELD__CellIdentification__LAC__RNC;
}
return *val_ptr->value_elements[index_value];
}

BSSMAP__FIELD__CellIdentification__LAC__RNC& BSSMAP__FIELD__CellIdentificationList__LAC__RNC::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__CellIdentification__LAC__RNC& BSSMAP__FIELD__CellIdentificationList__LAC__RNC::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const BSSMAP__FIELD__CellIdentification__LAC__RNC& BSSMAP__FIELD__CellIdentificationList__LAC__RNC::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
return (*this)[(int)index_value];
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC BSSMAP__FIELD__CellIdentificationList__LAC__RNC::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC BSSMAP__FIELD__CellIdentificationList__LAC__RNC::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC BSSMAP__FIELD__CellIdentificationList__LAC__RNC::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC BSSMAP__FIELD__CellIdentificationList__LAC__RNC::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
BSSMAP__FIELD__CellIdentificationList__LAC__RNC ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new BSSMAP__FIELD__CellIdentification__LAC__RNC(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC BSSMAP__FIELD__CellIdentificationList__LAC__RNC::operator+(const BSSMAP__FIELD__CellIdentificationList__LAC__RNC& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
BSSMAP__FIELD__CellIdentificationList__LAC__RNC ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__LAC__RNC(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new BSSMAP__FIELD__CellIdentification__LAC__RNC(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC BSSMAP__FIELD__CellIdentificationList__LAC__RNC::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC","element");
BSSMAP__FIELD__CellIdentificationList__LAC__RNC ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__LAC__RNC(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC BSSMAP__FIELD__CellIdentificationList__LAC__RNC::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__LAC__RNC& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
check_replace_arguments(val_ptr->n_elements, index, len, "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC","element");
BSSMAP__FIELD__CellIdentificationList__LAC__RNC ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__LAC__RNC(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new BSSMAP__FIELD__CellIdentification__LAC__RNC(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new BSSMAP__FIELD__CellIdentification__LAC__RNC(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC BSSMAP__FIELD__CellIdentificationList__LAC__RNC::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAC__RNC**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__RNC(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAC__RNC**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAC__RNC**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__RNC::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int BSSMAP__FIELD__CellIdentificationList__LAC__RNC::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
return val_ptr->n_elements;
}

int BSSMAP__FIELD__CellIdentificationList__LAC__RNC::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__LAC__RNC**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__RNC;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__CellIdentificationList__LAC__RNC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int BSSMAP__FIELD__CellIdentificationList__LAC__RNC::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::copy_value(const BSSMAP__FIELD__CellIdentificationList__LAC__RNC& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAC__RNC_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__RNC_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__RNC_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::copy_template(const BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAC__RNC_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__RNC_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__RNC_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
break;
}
set_selection(other_value);
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const BSSMAP__FIELD__CellIdentificationList__LAC__RNC*)value_ptr)[value_index], legacy);
else return ((const BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template()
{
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template(const BSSMAP__FIELD__CellIdentificationList__LAC__RNC& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__LAC__RNC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__LAC__RNC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC from an unbound optional field.");
}
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template(BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template* p_precondition, BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template(Dynamic_Match_Interface<BSSMAP__FIELD__CellIdentificationList__LAC__RNC>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__CellIdentificationList__LAC__RNC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template(const BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::~BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template()
{
clean_up();
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::operator=(const BSSMAP__FIELD__CellIdentificationList__LAC__RNC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::operator=(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__LAC__RNC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__LAC__RNC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
}
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::operator=(const BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

BSSMAP__FIELD__CellIdentification__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
    break;
}
return *single_value.value_elements[index_value];
}

BSSMAP__FIELD__CellIdentification__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__CellIdentification__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const BSSMAP__FIELD__CellIdentification__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
return (*this)[(int)index_value];
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAC__RNC_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__RNC_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__RNC_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAC__RNC_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC");
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::match(const BSSMAP__FIELD__CellIdentificationList__LAC__RNC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
}
return FALSE;
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
BSSMAP__FIELD__CellIdentificationList__LAC__RNC ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__LAC__RNC& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
}
set_selection(template_type);
}

BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template& BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
return value_list.list_value[list_index];
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::log_match(const BSSMAP__FIELD__CellIdentificationList__LAC__RNC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__LAC__RNC_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__LAC__RNC_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC.");
}
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template* precondition = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template* implied_template = new BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_RNC");
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__RNC_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
BSSMAP__IE__CellIdentifierList::BSSMAP__IE__CellIdentifierList()
{
}

BSSMAP__IE__CellIdentifierList::BSSMAP__IE__CellIdentifierList(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_cellIdentifierDiscriminator,
    const BITSTRING& par_spare1__4,
    const BSSMAP__FIELD__CellIdentificationList& par_cellIdentificationList)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_cellIdentifierDiscriminator(par_cellIdentifierDiscriminator),
  field_spare1__4(par_spare1__4),
  field_cellIdentificationList(par_cellIdentificationList)
{
}

BSSMAP__IE__CellIdentifierList::BSSMAP__IE__CellIdentifierList(const BSSMAP__IE__CellIdentifierList& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.cellIdentifierDiscriminator().is_bound()) field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
else field_cellIdentifierDiscriminator.clean_up();
if (other_value.spare1__4().is_bound()) field_spare1__4 = other_value.spare1__4();
else field_spare1__4.clean_up();
if (other_value.cellIdentificationList().is_bound()) field_cellIdentificationList = other_value.cellIdentificationList();
else field_cellIdentificationList.clean_up();
}

void BSSMAP__IE__CellIdentifierList::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_cellIdentifierDiscriminator.clean_up();
field_spare1__4.clean_up();
field_cellIdentificationList.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__CellIdentifierList::get_descriptor() const { return &BSSMAP__IE__CellIdentifierList_descr_; }
BSSMAP__IE__CellIdentifierList& BSSMAP__IE__CellIdentifierList::operator=(const BSSMAP__IE__CellIdentifierList& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.cellIdentifierDiscriminator().is_bound()) field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
  else field_cellIdentifierDiscriminator.clean_up();
  if (other_value.spare1__4().is_bound()) field_spare1__4 = other_value.spare1__4();
  else field_spare1__4.clean_up();
  if (other_value.cellIdentificationList().is_bound()) field_cellIdentificationList = other_value.cellIdentificationList();
  else field_cellIdentificationList.clean_up();
}
return *this;
}

boolean BSSMAP__IE__CellIdentifierList::operator==(const BSSMAP__IE__CellIdentifierList& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_cellIdentifierDiscriminator==other_value.field_cellIdentifierDiscriminator
  && field_spare1__4==other_value.field_spare1__4
  && field_cellIdentificationList==other_value.field_cellIdentificationList;
}

boolean BSSMAP__IE__CellIdentifierList::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_cellIdentifierDiscriminator.is_bound())
  || (field_spare1__4.is_bound())
  || (field_cellIdentificationList.is_bound());
}
boolean BSSMAP__IE__CellIdentifierList::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_cellIdentifierDiscriminator.is_value()
  && field_spare1__4.is_value()
  && field_cellIdentificationList.is_value();
}
void BSSMAP__IE__CellIdentifierList::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", cellIdentifierDiscriminator := ");
field_cellIdentifierDiscriminator.log();
TTCN_Logger::log_event_str(", spare1_4 := ");
field_spare1__4.log();
TTCN_Logger::log_event_str(", cellIdentificationList := ");
field_cellIdentificationList.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__CellIdentifierList::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (cellIdentifierDiscriminator().is_bound()) cellIdentifierDiscriminator().set_implicit_omit();
if (spare1__4().is_bound()) spare1__4().set_implicit_omit();
if (cellIdentificationList().is_bound()) cellIdentificationList().set_implicit_omit();
}

void BSSMAP__IE__CellIdentifierList::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cellIdentifierDiscriminator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare1__4().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) cellIdentificationList().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifierDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifierDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare1_4")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare1__4().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentificationList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentificationList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CellIdentifierList: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_CellIdentifierList");
  }
}

void BSSMAP__IE__CellIdentifierList::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_cellIdentifierDiscriminator.encode_text(text_buf);
field_spare1__4.encode_text(text_buf);
field_cellIdentificationList.encode_text(text_buf);
}

void BSSMAP__IE__CellIdentifierList::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_cellIdentifierDiscriminator.decode_text(text_buf);
field_spare1__4.decode_text(text_buf);
field_cellIdentificationList.decode_text(text_buf);
}

void BSSMAP__IE__CellIdentifierList::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__CellIdentifierList::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__CellIdentifierList::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__CellIdentifierList_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__CellIdentifierList_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__CellIdentifierList_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentifierDiscriminator.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare1__4.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_cellIdentifierDiscriminator ==  bs_0) selected_field = 0;
  else if (field_cellIdentifierDiscriminator ==  bs_1) selected_field = 1;
  else if (field_cellIdentifierDiscriminator ==  bs_2) selected_field = 2;
  else if (field_cellIdentifierDiscriminator ==  bs_3) selected_field = 3;
  else if (field_cellIdentifierDiscriminator ==  bs_10) selected_field = 4;
  else if (field_cellIdentifierDiscriminator ==  bs_11) selected_field = 5;
  else if (field_cellIdentifierDiscriminator ==  bs_12) selected_field = 6;
  else if (field_cellIdentifierDiscriminator ==  bs_4) selected_field = 7;
  else if (field_cellIdentifierDiscriminator ==  bs_5) selected_field = 8;
  else if (field_cellIdentifierDiscriminator ==  bs_6) selected_field = 9;
  else selected_field = -1;
  RAW_Force_Omit field_4_force_omit(4, force_omit, BSSMAP__IE__CellIdentifierList_cellIdentificationList_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentificationList.RAW_decode(BSSMAP__IE__CellIdentifierList_cellIdentificationList_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, selected_field, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_72) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__CellIdentifierList::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__CellIdentifierList_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BSSMAP__IE__CellIdentifierList_cellIdentificationList_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__CellIdentifierList_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_cellIdentifierDiscriminator.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_spare1__4.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_cellIdentificationList.RAW_encode(BSSMAP__IE__CellIdentifierList_cellIdentificationList_descr_, *myleaf.body.node.nodes[4]);
  switch (field_cellIdentificationList.get_selection()) {
  case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CGI:
  if (field_cellIdentifierDiscriminator !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__CI:
  if (field_cellIdentifierDiscriminator !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__CI:
  if (field_cellIdentifierDiscriminator !=  bs_2) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_2.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__noCell:
  if (field_cellIdentifierDiscriminator !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAI:
  if (field_cellIdentifierDiscriminator !=  bs_10) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_10.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC:
  if (field_cellIdentifierDiscriminator !=  bs_11) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_11.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__allInBSS:
  if (field_cellIdentifierDiscriminator !=  bs_12) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_12.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__PLMN__LAC__RNC:
  if (field_cellIdentifierDiscriminator !=  bs_4) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_4.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__RNC:
  if (field_cellIdentifierDiscriminator !=  bs_5) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_5.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationList::ALT_cIl__LAC__RNC:
  if (field_cellIdentifierDiscriminator !=  bs_6) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_6.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_elementIdentifier !=  os_72) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_72.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__CellIdentifierList_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_cellIdentifierDiscriminator;
BITSTRING_template field_spare1__4;
BSSMAP__FIELD__CellIdentificationList_template field_cellIdentificationList;
};

void BSSMAP__IE__CellIdentifierList_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_cellIdentifierDiscriminator = ANY_VALUE;
single_value->field_spare1__4 = ANY_VALUE;
single_value->field_cellIdentificationList = ANY_VALUE;
}
}
}

void BSSMAP__IE__CellIdentifierList_template::copy_value(const BSSMAP__IE__CellIdentifierList& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.cellIdentifierDiscriminator().is_bound()) {
  single_value->field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
} else {
  single_value->field_cellIdentifierDiscriminator.clean_up();
}
if (other_value.spare1__4().is_bound()) {
  single_value->field_spare1__4 = other_value.spare1__4();
} else {
  single_value->field_spare1__4.clean_up();
}
if (other_value.cellIdentificationList().is_bound()) {
  single_value->field_cellIdentificationList = other_value.cellIdentificationList();
} else {
  single_value->field_cellIdentificationList.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__CellIdentifierList_template::copy_template(const BSSMAP__IE__CellIdentifierList_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentifierDiscriminator().get_selection()) {
single_value->field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
} else {
single_value->field_cellIdentifierDiscriminator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare1__4().get_selection()) {
single_value->field_spare1__4 = other_value.spare1__4();
} else {
single_value->field_spare1__4.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentificationList().get_selection()) {
single_value->field_cellIdentificationList = other_value.cellIdentificationList();
} else {
single_value->field_cellIdentificationList.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__CellIdentifierList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__CellIdentifierList_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__CellIdentifierList_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__CellIdentifierList_template::BSSMAP__IE__CellIdentifierList_template()
{
}

BSSMAP__IE__CellIdentifierList_template::BSSMAP__IE__CellIdentifierList_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__CellIdentifierList_template::BSSMAP__IE__CellIdentifierList_template(const BSSMAP__IE__CellIdentifierList& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__CellIdentifierList_template::BSSMAP__IE__CellIdentifierList_template(const OPTIONAL<BSSMAP__IE__CellIdentifierList>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CellIdentifierList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList from an unbound optional field.");
}
}

BSSMAP__IE__CellIdentifierList_template::BSSMAP__IE__CellIdentifierList_template(BSSMAP__IE__CellIdentifierList_template* p_precondition, BSSMAP__IE__CellIdentifierList_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__CellIdentifierList_template::BSSMAP__IE__CellIdentifierList_template(Dynamic_Match_Interface<BSSMAP__IE__CellIdentifierList>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__CellIdentifierList>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__CellIdentifierList_template::BSSMAP__IE__CellIdentifierList_template(const BSSMAP__IE__CellIdentifierList_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__CellIdentifierList_template::~BSSMAP__IE__CellIdentifierList_template()
{
clean_up();
}

BSSMAP__IE__CellIdentifierList_template& BSSMAP__IE__CellIdentifierList_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__CellIdentifierList_template& BSSMAP__IE__CellIdentifierList_template::operator=(const BSSMAP__IE__CellIdentifierList& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__CellIdentifierList_template& BSSMAP__IE__CellIdentifierList_template::operator=(const OPTIONAL<BSSMAP__IE__CellIdentifierList>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CellIdentifierList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
}
return *this;
}

BSSMAP__IE__CellIdentifierList_template& BSSMAP__IE__CellIdentifierList_template::operator=(const BSSMAP__IE__CellIdentifierList_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__CellIdentifierList_template::match(const BSSMAP__IE__CellIdentifierList& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.cellIdentifierDiscriminator().is_bound()) return FALSE;
if(!single_value->field_cellIdentifierDiscriminator.match(other_value.cellIdentifierDiscriminator(), legacy))return FALSE;
if(!other_value.spare1__4().is_bound()) return FALSE;
if(!single_value->field_spare1__4.match(other_value.spare1__4(), legacy))return FALSE;
if(!other_value.cellIdentificationList().is_bound()) return FALSE;
if(!single_value->field_cellIdentificationList.match(other_value.cellIdentificationList(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
}
return FALSE;
}

boolean BSSMAP__IE__CellIdentifierList_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_cellIdentifierDiscriminator.is_bound()
 || single_value->field_spare1__4.is_bound()
 || single_value->field_cellIdentificationList.is_bound();
}

boolean BSSMAP__IE__CellIdentifierList_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_cellIdentifierDiscriminator.is_value()
 && single_value->field_spare1__4.is_value()
 && single_value->field_cellIdentificationList.is_value();
}

void BSSMAP__IE__CellIdentifierList_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__CellIdentifierList BSSMAP__IE__CellIdentifierList_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
BSSMAP__IE__CellIdentifierList ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_cellIdentifierDiscriminator.is_bound()) {
ret_val.cellIdentifierDiscriminator() = single_value->field_cellIdentifierDiscriminator.valueof();
}
if (single_value->field_spare1__4.is_bound()) {
ret_val.spare1__4() = single_value->field_spare1__4.valueof();
}
if (single_value->field_cellIdentificationList.is_bound()) {
ret_val.cellIdentificationList() = single_value->field_cellIdentificationList.valueof();
}
return ret_val;
}

void BSSMAP__IE__CellIdentifierList_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__CellIdentifierList_template[list_length];
}

BSSMAP__IE__CellIdentifierList_template& BSSMAP__IE__CellIdentifierList_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__CellIdentifierList_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__CellIdentifierList_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__CellIdentifierList_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__CellIdentifierList_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& BSSMAP__IE__CellIdentifierList_template::cellIdentifierDiscriminator()
{
set_specific();
return single_value->field_cellIdentifierDiscriminator;
}

const BITSTRING_template& BSSMAP__IE__CellIdentifierList_template::cellIdentifierDiscriminator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentifierDiscriminator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
return single_value->field_cellIdentifierDiscriminator;
}

BITSTRING_template& BSSMAP__IE__CellIdentifierList_template::spare1__4()
{
set_specific();
return single_value->field_spare1__4;
}

const BITSTRING_template& BSSMAP__IE__CellIdentifierList_template::spare1__4() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare1_4 of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
return single_value->field_spare1__4;
}

BSSMAP__FIELD__CellIdentificationList_template& BSSMAP__IE__CellIdentifierList_template::cellIdentificationList()
{
set_specific();
return single_value->field_cellIdentificationList;
}

const BSSMAP__FIELD__CellIdentificationList_template& BSSMAP__IE__CellIdentifierList_template::cellIdentificationList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentificationList of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
return single_value->field_cellIdentificationList;
}

int BSSMAP__IE__CellIdentifierList_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
  }
  return 0;
}

void BSSMAP__IE__CellIdentifierList_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", cellIdentifierDiscriminator := ");
single_value->field_cellIdentifierDiscriminator.log();
TTCN_Logger::log_event_str(", spare1_4 := ");
single_value->field_spare1__4.log();
TTCN_Logger::log_event_str(", cellIdentificationList := ");
single_value->field_cellIdentificationList.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__CellIdentifierList_template::log_match(const BSSMAP__IE__CellIdentifierList& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cellIdentifierDiscriminator.match(match_value.cellIdentifierDiscriminator(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentifierDiscriminator");
single_value->field_cellIdentifierDiscriminator.log_match(match_value.cellIdentifierDiscriminator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare1__4.match(match_value.spare1__4(), legacy)){
TTCN_Logger::log_logmatch_info(".spare1_4");
single_value->field_spare1__4.log_match(match_value.spare1__4(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cellIdentificationList.match(match_value.cellIdentificationList(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentificationList");
single_value->field_cellIdentificationList.log_match(match_value.cellIdentificationList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", cellIdentifierDiscriminator := ");
single_value->field_cellIdentifierDiscriminator.log_match(match_value.cellIdentifierDiscriminator(), legacy);
TTCN_Logger::log_event_str(", spare1_4 := ");
single_value->field_spare1__4.log_match(match_value.spare1__4(), legacy);
TTCN_Logger::log_event_str(", cellIdentificationList := ");
single_value->field_cellIdentificationList.log_match(match_value.cellIdentificationList(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__CellIdentifierList_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (cellIdentifierDiscriminator().is_bound()) cellIdentifierDiscriminator().set_implicit_omit();
if (spare1__4().is_bound()) spare1__4().set_implicit_omit();
if (cellIdentificationList().is_bound()) cellIdentificationList().set_implicit_omit();
}

void BSSMAP__IE__CellIdentifierList_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_cellIdentifierDiscriminator.encode_text(text_buf);
single_value->field_spare1__4.encode_text(text_buf);
single_value->field_cellIdentificationList.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
}
}

void BSSMAP__IE__CellIdentifierList_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_cellIdentifierDiscriminator.decode_text(text_buf);
single_value->field_spare1__4.decode_text(text_buf);
single_value->field_cellIdentificationList.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__CellIdentifierList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList.");
}
}

void BSSMAP__IE__CellIdentifierList_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__CellIdentifierList_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierList has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cellIdentifierDiscriminator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare1__4().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) cellIdentificationList().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifierDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifierDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare1_4")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare1__4().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentificationList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentificationList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CellIdentifierList: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__CellIdentifierList_template* precondition = new BSSMAP__IE__CellIdentifierList_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__CellIdentifierList_template* implied_template = new BSSMAP__IE__CellIdentifierList_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__CellIdentifierList_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_CellIdentifierList");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__CellIdentifierList_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierList");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierList");
single_value->field_cellIdentifierDiscriminator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierList");
single_value->field_spare1__4.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierList");
single_value->field_cellIdentificationList.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierList");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierList");
}

boolean BSSMAP__IE__CellIdentifierList_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__CellIdentifierList_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const BSSMAP__FIELD__CellIdentification__SAI BSSMAP__FIELD__CellIdentificationList__SAI::UNBOUND_ELEM;
BSSMAP__FIELD__CellIdentificationList__SAI::BSSMAP__FIELD__CellIdentificationList__SAI()
{
val_ptr = NULL;
}

BSSMAP__FIELD__CellIdentificationList__SAI::BSSMAP__FIELD__CellIdentificationList__SAI(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

BSSMAP__FIELD__CellIdentificationList__SAI::BSSMAP__FIELD__CellIdentificationList__SAI(const BSSMAP__FIELD__CellIdentificationList__SAI& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

BSSMAP__FIELD__CellIdentificationList__SAI::~BSSMAP__FIELD__CellIdentificationList__SAI()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void BSSMAP__FIELD__CellIdentificationList__SAI::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

BSSMAP__FIELD__CellIdentificationList__SAI& BSSMAP__FIELD__CellIdentificationList__SAI::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

BSSMAP__FIELD__CellIdentificationList__SAI& BSSMAP__FIELD__CellIdentificationList__SAI::operator=(const BSSMAP__FIELD__CellIdentificationList__SAI& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationList__SAI::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
return val_ptr->n_elements == 0 ;
}

boolean BSSMAP__FIELD__CellIdentificationList__SAI::operator==(const BSSMAP__FIELD__CellIdentificationList__SAI& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

BSSMAP__FIELD__CellIdentification__SAI& BSSMAP__FIELD__CellIdentificationList__SAI::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__SAI**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__SAI(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new BSSMAP__FIELD__CellIdentification__SAI;
}
return *val_ptr->value_elements[index_value];
}

BSSMAP__FIELD__CellIdentification__SAI& BSSMAP__FIELD__CellIdentificationList__SAI::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__CellIdentification__SAI& BSSMAP__FIELD__CellIdentificationList__SAI::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const BSSMAP__FIELD__CellIdentification__SAI& BSSMAP__FIELD__CellIdentificationList__SAI::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
return (*this)[(int)index_value];
}

BSSMAP__FIELD__CellIdentificationList__SAI BSSMAP__FIELD__CellIdentificationList__SAI::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

BSSMAP__FIELD__CellIdentificationList__SAI BSSMAP__FIELD__CellIdentificationList__SAI::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

BSSMAP__FIELD__CellIdentificationList__SAI BSSMAP__FIELD__CellIdentificationList__SAI::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

BSSMAP__FIELD__CellIdentificationList__SAI BSSMAP__FIELD__CellIdentificationList__SAI::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
BSSMAP__FIELD__CellIdentificationList__SAI ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new BSSMAP__FIELD__CellIdentification__SAI(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__SAI BSSMAP__FIELD__CellIdentificationList__SAI::operator+(const BSSMAP__FIELD__CellIdentificationList__SAI& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
BSSMAP__FIELD__CellIdentificationList__SAI ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__SAI(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new BSSMAP__FIELD__CellIdentification__SAI(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__SAI BSSMAP__FIELD__CellIdentificationList__SAI::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI","element");
BSSMAP__FIELD__CellIdentificationList__SAI ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__SAI(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__SAI BSSMAP__FIELD__CellIdentificationList__SAI::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__SAI& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
check_replace_arguments(val_ptr->n_elements, index, len, "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI","element");
BSSMAP__FIELD__CellIdentificationList__SAI ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__CellIdentification__SAI(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new BSSMAP__FIELD__CellIdentification__SAI(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new BSSMAP__FIELD__CellIdentification__SAI(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__SAI BSSMAP__FIELD__CellIdentificationList__SAI::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__SAI_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void BSSMAP__FIELD__CellIdentificationList__SAI::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__SAI**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__SAI(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__SAI**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__SAI**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean BSSMAP__FIELD__CellIdentificationList__SAI::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int BSSMAP__FIELD__CellIdentificationList__SAI::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
return val_ptr->n_elements;
}

int BSSMAP__FIELD__CellIdentificationList__SAI::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void BSSMAP__FIELD__CellIdentificationList__SAI::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void BSSMAP__FIELD__CellIdentificationList__SAI::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__CellIdentificationList__SAI::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void BSSMAP__FIELD__CellIdentificationList__SAI::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void BSSMAP__FIELD__CellIdentificationList__SAI::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
val_ptr->value_elements = (BSSMAP__FIELD__CellIdentification__SAI**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__SAI;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void BSSMAP__FIELD__CellIdentificationList__SAI::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__CellIdentificationList__SAI::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__CellIdentificationList__SAI::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int BSSMAP__FIELD__CellIdentificationList__SAI::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void BSSMAP__FIELD__CellIdentificationList__SAI_template::copy_value(const BSSMAP__FIELD__CellIdentificationList__SAI& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__SAI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__SAI_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__SAI_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__CellIdentificationList__SAI_template::copy_template(const BSSMAP__FIELD__CellIdentificationList__SAI_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__SAI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__SAI_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__SAI_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__SAI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__CellIdentificationList__SAI_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__CellIdentificationList__SAI_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
break;
}
set_selection(other_value);
}

boolean BSSMAP__FIELD__CellIdentificationList__SAI_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const BSSMAP__FIELD__CellIdentificationList__SAI_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const BSSMAP__FIELD__CellIdentificationList__SAI*)value_ptr)[value_index], legacy);
else return ((const BSSMAP__FIELD__CellIdentificationList__SAI_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

BSSMAP__FIELD__CellIdentificationList__SAI_template::BSSMAP__FIELD__CellIdentificationList__SAI_template()
{
}

BSSMAP__FIELD__CellIdentificationList__SAI_template::BSSMAP__FIELD__CellIdentificationList__SAI_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationList__SAI_template::BSSMAP__FIELD__CellIdentificationList__SAI_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

BSSMAP__FIELD__CellIdentificationList__SAI_template::BSSMAP__FIELD__CellIdentificationList__SAI_template(const BSSMAP__FIELD__CellIdentificationList__SAI& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationList__SAI_template::BSSMAP__FIELD__CellIdentificationList__SAI_template(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__SAI>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__SAI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI from an unbound optional field.");
}
}

BSSMAP__FIELD__CellIdentificationList__SAI_template::BSSMAP__FIELD__CellIdentificationList__SAI_template(BSSMAP__FIELD__CellIdentificationList__SAI_template* p_precondition, BSSMAP__FIELD__CellIdentificationList__SAI_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__CellIdentificationList__SAI_template::BSSMAP__FIELD__CellIdentificationList__SAI_template(Dynamic_Match_Interface<BSSMAP__FIELD__CellIdentificationList__SAI>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__CellIdentificationList__SAI>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__CellIdentificationList__SAI_template::BSSMAP__FIELD__CellIdentificationList__SAI_template(const BSSMAP__FIELD__CellIdentificationList__SAI_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

BSSMAP__FIELD__CellIdentificationList__SAI_template::~BSSMAP__FIELD__CellIdentificationList__SAI_template()
{
clean_up();
}

void BSSMAP__FIELD__CellIdentificationList__SAI_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__CellIdentificationList__SAI_template& BSSMAP__FIELD__CellIdentificationList__SAI_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__SAI_template& BSSMAP__FIELD__CellIdentificationList__SAI_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

BSSMAP__FIELD__CellIdentificationList__SAI_template& BSSMAP__FIELD__CellIdentificationList__SAI_template::operator=(const BSSMAP__FIELD__CellIdentificationList__SAI& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__SAI_template& BSSMAP__FIELD__CellIdentificationList__SAI_template::operator=(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__SAI>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__SAI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
}
return *this;
}

BSSMAP__FIELD__CellIdentificationList__SAI_template& BSSMAP__FIELD__CellIdentificationList__SAI_template::operator=(const BSSMAP__FIELD__CellIdentificationList__SAI_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

BSSMAP__FIELD__CellIdentification__SAI_template& BSSMAP__FIELD__CellIdentificationList__SAI_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
    break;
}
return *single_value.value_elements[index_value];
}

BSSMAP__FIELD__CellIdentification__SAI_template& BSSMAP__FIELD__CellIdentificationList__SAI_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__CellIdentification__SAI_template& BSSMAP__FIELD__CellIdentificationList__SAI_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const BSSMAP__FIELD__CellIdentification__SAI_template& BSSMAP__FIELD__CellIdentificationList__SAI_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
return (*this)[(int)index_value];
}

void BSSMAP__FIELD__CellIdentificationList__SAI_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__SAI_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__SAI_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__SAI_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__SAI_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int BSSMAP__FIELD__CellIdentificationList__SAI_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int BSSMAP__FIELD__CellIdentificationList__SAI_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI");
}

boolean BSSMAP__FIELD__CellIdentificationList__SAI_template::match(const BSSMAP__FIELD__CellIdentificationList__SAI& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
}
return FALSE;
}

boolean BSSMAP__FIELD__CellIdentificationList__SAI_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

BSSMAP__FIELD__CellIdentificationList__SAI BSSMAP__FIELD__CellIdentificationList__SAI_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
BSSMAP__FIELD__CellIdentificationList__SAI ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationList__SAI BSSMAP__FIELD__CellIdentificationList__SAI_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

BSSMAP__FIELD__CellIdentificationList__SAI BSSMAP__FIELD__CellIdentificationList__SAI_template::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__SAI_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

BSSMAP__FIELD__CellIdentificationList__SAI BSSMAP__FIELD__CellIdentificationList__SAI_template::replace(int index, int len, const BSSMAP__FIELD__CellIdentificationList__SAI& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void BSSMAP__FIELD__CellIdentificationList__SAI_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__SAI_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
}
set_selection(template_type);
}

BSSMAP__FIELD__CellIdentificationList__SAI_template& BSSMAP__FIELD__CellIdentificationList__SAI_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
return value_list.list_value[list_index];
}

void BSSMAP__FIELD__CellIdentificationList__SAI_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationList__SAI_template::log_match(const BSSMAP__FIELD__CellIdentificationList__SAI& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__CellIdentificationList__SAI_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
}
}

void BSSMAP__FIELD__CellIdentificationList__SAI_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
single_value.value_elements = (BSSMAP__FIELD__CellIdentification__SAI_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__CellIdentification__SAI_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__SAI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI.");
}
}

boolean BSSMAP__FIELD__CellIdentificationList__SAI_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__CellIdentificationList__SAI_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationList__SAI_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__CellIdentificationList__SAI_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__CellIdentificationList__SAI_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__CellIdentificationList__SAI_template* precondition = new BSSMAP__FIELD__CellIdentificationList__SAI_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__FIELD__CellIdentificationList__SAI_template* implied_template = new BSSMAP__FIELD__CellIdentificationList__SAI_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__FIELD__CellIdentificationList__SAI_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void BSSMAP__FIELD__CellIdentificationList__SAI_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_SAI");
}

boolean BSSMAP__FIELD__CellIdentificationList__SAI_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
void BSSMAP__FIELD__CellIdentificationListSegment::copy_value(const BSSMAP__FIELD__CellIdentificationListSegment& other_value)
{
switch (other_value.union_selection) {
case ALT_cIl__CGI:
field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI(*other_value.field_cIl__CGI);
break;
case ALT_cIl__LAC__CI:
field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment(*other_value.field_cIl__LAC__CI);
break;
case ALT_cIl__CI:
field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment(*other_value.field_cIl__CI);
break;
case ALT_cIl__noCell:
field_cIl__noCell = new OCTETSTRING(*other_value.field_cIl__noCell);
break;
case ALT_cIl__LAI:
field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI(*other_value.field_cIl__LAI);
break;
case ALT_cIl__LAC:
field_cIl__LAC = new RecordOfOCT2(*other_value.field_cIl__LAC);
break;
case ALT_cIl__allInBSS:
field_cIl__allInBSS = new OCTETSTRING(*other_value.field_cIl__allInBSS);
break;
case ALT_cIl__MCC__MNC:
field_cIl__MCC__MNC = new RecordOfOCT3(*other_value.field_cIl__MCC__MNC);
break;
default:
TTCN_error("Assignment of an unbound union value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
union_selection = other_value.union_selection;
}

BSSMAP__FIELD__CellIdentificationListSegment::BSSMAP__FIELD__CellIdentificationListSegment()
{
union_selection = UNBOUND_VALUE;
}

BSSMAP__FIELD__CellIdentificationListSegment::BSSMAP__FIELD__CellIdentificationListSegment(const BSSMAP__FIELD__CellIdentificationListSegment& other_value)
: Base_Type(){
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationListSegment::~BSSMAP__FIELD__CellIdentificationListSegment()
{
clean_up();
}

BSSMAP__FIELD__CellIdentificationListSegment& BSSMAP__FIELD__CellIdentificationListSegment::operator=(const BSSMAP__FIELD__CellIdentificationListSegment& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationListSegment::operator==(const BSSMAP__FIELD__CellIdentificationListSegment& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_cIl__CGI:
return *field_cIl__CGI == *other_value.field_cIl__CGI;
case ALT_cIl__LAC__CI:
return *field_cIl__LAC__CI == *other_value.field_cIl__LAC__CI;
case ALT_cIl__CI:
return *field_cIl__CI == *other_value.field_cIl__CI;
case ALT_cIl__noCell:
return *field_cIl__noCell == *other_value.field_cIl__noCell;
case ALT_cIl__LAI:
return *field_cIl__LAI == *other_value.field_cIl__LAI;
case ALT_cIl__LAC:
return *field_cIl__LAC == *other_value.field_cIl__LAC;
case ALT_cIl__allInBSS:
return *field_cIl__allInBSS == *other_value.field_cIl__allInBSS;
case ALT_cIl__MCC__MNC:
return *field_cIl__MCC__MNC == *other_value.field_cIl__MCC__MNC;
default:
return FALSE;
}
}

BSSMAP__FIELD__CellIdentificationList__CGI& BSSMAP__FIELD__CellIdentificationListSegment::cIl__CGI()
{
if (union_selection != ALT_cIl__CGI) {
clean_up();
field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI;
union_selection = ALT_cIl__CGI;
}
return *field_cIl__CGI;
}

const BSSMAP__FIELD__CellIdentificationList__CGI& BSSMAP__FIELD__CellIdentificationListSegment::cIl__CGI() const
{
if (union_selection != ALT_cIl__CGI) TTCN_error("Using non-selected field cIl_CGI in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *field_cIl__CGI;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment& BSSMAP__FIELD__CellIdentificationListSegment::cIl__LAC__CI()
{
if (union_selection != ALT_cIl__LAC__CI) {
clean_up();
field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment;
union_selection = ALT_cIl__LAC__CI;
}
return *field_cIl__LAC__CI;
}

const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment& BSSMAP__FIELD__CellIdentificationListSegment::cIl__LAC__CI() const
{
if (union_selection != ALT_cIl__LAC__CI) TTCN_error("Using non-selected field cIl_LAC_CI in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *field_cIl__LAC__CI;
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment& BSSMAP__FIELD__CellIdentificationListSegment::cIl__CI()
{
if (union_selection != ALT_cIl__CI) {
clean_up();
field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment;
union_selection = ALT_cIl__CI;
}
return *field_cIl__CI;
}

const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment& BSSMAP__FIELD__CellIdentificationListSegment::cIl__CI() const
{
if (union_selection != ALT_cIl__CI) TTCN_error("Using non-selected field cIl_CI in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *field_cIl__CI;
}

OCTETSTRING& BSSMAP__FIELD__CellIdentificationListSegment::cIl__noCell()
{
if (union_selection != ALT_cIl__noCell) {
clean_up();
field_cIl__noCell = new OCTETSTRING;
union_selection = ALT_cIl__noCell;
}
return *field_cIl__noCell;
}

const OCTETSTRING& BSSMAP__FIELD__CellIdentificationListSegment::cIl__noCell() const
{
if (union_selection != ALT_cIl__noCell) TTCN_error("Using non-selected field cIl_noCell in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *field_cIl__noCell;
}

BSSMAP__FIELD__CellIdentificationList__LAI& BSSMAP__FIELD__CellIdentificationListSegment::cIl__LAI()
{
if (union_selection != ALT_cIl__LAI) {
clean_up();
field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI;
union_selection = ALT_cIl__LAI;
}
return *field_cIl__LAI;
}

const BSSMAP__FIELD__CellIdentificationList__LAI& BSSMAP__FIELD__CellIdentificationListSegment::cIl__LAI() const
{
if (union_selection != ALT_cIl__LAI) TTCN_error("Using non-selected field cIl_LAI in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *field_cIl__LAI;
}

RecordOfOCT2& BSSMAP__FIELD__CellIdentificationListSegment::cIl__LAC()
{
if (union_selection != ALT_cIl__LAC) {
clean_up();
field_cIl__LAC = new RecordOfOCT2;
union_selection = ALT_cIl__LAC;
}
return *field_cIl__LAC;
}

const RecordOfOCT2& BSSMAP__FIELD__CellIdentificationListSegment::cIl__LAC() const
{
if (union_selection != ALT_cIl__LAC) TTCN_error("Using non-selected field cIl_LAC in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *field_cIl__LAC;
}

OCTETSTRING& BSSMAP__FIELD__CellIdentificationListSegment::cIl__allInBSS()
{
if (union_selection != ALT_cIl__allInBSS) {
clean_up();
field_cIl__allInBSS = new OCTETSTRING;
union_selection = ALT_cIl__allInBSS;
}
return *field_cIl__allInBSS;
}

const OCTETSTRING& BSSMAP__FIELD__CellIdentificationListSegment::cIl__allInBSS() const
{
if (union_selection != ALT_cIl__allInBSS) TTCN_error("Using non-selected field cIl_allInBSS in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *field_cIl__allInBSS;
}

RecordOfOCT3& BSSMAP__FIELD__CellIdentificationListSegment::cIl__MCC__MNC()
{
if (union_selection != ALT_cIl__MCC__MNC) {
clean_up();
field_cIl__MCC__MNC = new RecordOfOCT3;
union_selection = ALT_cIl__MCC__MNC;
}
return *field_cIl__MCC__MNC;
}

const RecordOfOCT3& BSSMAP__FIELD__CellIdentificationListSegment::cIl__MCC__MNC() const
{
if (union_selection != ALT_cIl__MCC__MNC) TTCN_error("Using non-selected field cIl_MCC_MNC in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *field_cIl__MCC__MNC;
}

boolean BSSMAP__FIELD__CellIdentificationListSegment::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return union_selection == checked_selection;
}

boolean BSSMAP__FIELD__CellIdentificationListSegment::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean BSSMAP__FIELD__CellIdentificationListSegment::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_cIl__CGI: return field_cIl__CGI->is_value();
case ALT_cIl__LAC__CI: return field_cIl__LAC__CI->is_value();
case ALT_cIl__CI: return field_cIl__CI->is_value();
case ALT_cIl__noCell: return field_cIl__noCell->is_value();
case ALT_cIl__LAI: return field_cIl__LAI->is_value();
case ALT_cIl__LAC: return field_cIl__LAC->is_value();
case ALT_cIl__allInBSS: return field_cIl__allInBSS->is_value();
case ALT_cIl__MCC__MNC: return field_cIl__MCC__MNC->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void BSSMAP__FIELD__CellIdentificationListSegment::clean_up()
{
switch (union_selection) {
case ALT_cIl__CGI:
  delete field_cIl__CGI;
  break;
case ALT_cIl__LAC__CI:
  delete field_cIl__LAC__CI;
  break;
case ALT_cIl__CI:
  delete field_cIl__CI;
  break;
case ALT_cIl__noCell:
  delete field_cIl__noCell;
  break;
case ALT_cIl__LAI:
  delete field_cIl__LAI;
  break;
case ALT_cIl__LAC:
  delete field_cIl__LAC;
  break;
case ALT_cIl__allInBSS:
  delete field_cIl__allInBSS;
  break;
case ALT_cIl__MCC__MNC:
  delete field_cIl__MCC__MNC;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void BSSMAP__FIELD__CellIdentificationListSegment::log() const
{
switch (union_selection) {
case ALT_cIl__CGI:
TTCN_Logger::log_event_str("{ cIl_CGI := ");
field_cIl__CGI->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__LAC__CI:
TTCN_Logger::log_event_str("{ cIl_LAC_CI := ");
field_cIl__LAC__CI->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__CI:
TTCN_Logger::log_event_str("{ cIl_CI := ");
field_cIl__CI->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__noCell:
TTCN_Logger::log_event_str("{ cIl_noCell := ");
field_cIl__noCell->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__LAI:
TTCN_Logger::log_event_str("{ cIl_LAI := ");
field_cIl__LAI->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__LAC:
TTCN_Logger::log_event_str("{ cIl_LAC := ");
field_cIl__LAC->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__allInBSS:
TTCN_Logger::log_event_str("{ cIl_allInBSS := ");
field_cIl__allInBSS->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__MCC__MNC:
TTCN_Logger::log_event_str("{ cIl_MCC_MNC := ");
field_cIl__MCC__MNC->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void BSSMAP__FIELD__CellIdentificationListSegment::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "cIl_CGI")) {
    cIl__CGI().set_param(*mp_last);
    if (!cIl__CGI().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_LAC_CI")) {
    cIl__LAC__CI().set_param(*mp_last);
    if (!cIl__LAC__CI().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_CI")) {
    cIl__CI().set_param(*mp_last);
    if (!cIl__CI().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_noCell")) {
    cIl__noCell().set_param(*mp_last);
    if (!cIl__noCell().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_LAI")) {
    cIl__LAI().set_param(*mp_last);
    if (!cIl__LAI().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_LAC")) {
    cIl__LAC().set_param(*mp_last);
    if (!cIl__LAC().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_allInBSS")) {
    cIl__allInBSS().set_param(*mp_last);
    if (!cIl__allInBSS().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_MCC_MNC")) {
    cIl__MCC__MNC().set_param(*mp_last);
    if (!cIl__MCC__MNC().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.", last_name);
}

void BSSMAP__FIELD__CellIdentificationListSegment::set_implicit_omit()
{
switch (union_selection) {
case ALT_cIl__CGI:
field_cIl__CGI->set_implicit_omit(); break;
case ALT_cIl__LAC__CI:
field_cIl__LAC__CI->set_implicit_omit(); break;
case ALT_cIl__CI:
field_cIl__CI->set_implicit_omit(); break;
case ALT_cIl__noCell:
field_cIl__noCell->set_implicit_omit(); break;
case ALT_cIl__LAI:
field_cIl__LAI->set_implicit_omit(); break;
case ALT_cIl__LAC:
field_cIl__LAC->set_implicit_omit(); break;
case ALT_cIl__allInBSS:
field_cIl__allInBSS->set_implicit_omit(); break;
case ALT_cIl__MCC__MNC:
field_cIl__MCC__MNC->set_implicit_omit(); break;
default: break;
}
}

void BSSMAP__FIELD__CellIdentificationListSegment::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_cIl__CGI:
field_cIl__CGI->encode_text(text_buf);
break;
case ALT_cIl__LAC__CI:
field_cIl__LAC__CI->encode_text(text_buf);
break;
case ALT_cIl__CI:
field_cIl__CI->encode_text(text_buf);
break;
case ALT_cIl__noCell:
field_cIl__noCell->encode_text(text_buf);
break;
case ALT_cIl__LAI:
field_cIl__LAI->encode_text(text_buf);
break;
case ALT_cIl__LAC:
field_cIl__LAC->encode_text(text_buf);
break;
case ALT_cIl__allInBSS:
field_cIl__allInBSS->encode_text(text_buf);
break;
case ALT_cIl__MCC__MNC:
field_cIl__MCC__MNC->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
}

void BSSMAP__FIELD__CellIdentificationListSegment::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_cIl__CGI:
cIl__CGI().decode_text(text_buf);
break;
case ALT_cIl__LAC__CI:
cIl__LAC__CI().decode_text(text_buf);
break;
case ALT_cIl__CI:
cIl__CI().decode_text(text_buf);
break;
case ALT_cIl__noCell:
cIl__noCell().decode_text(text_buf);
break;
case ALT_cIl__LAI:
cIl__LAI().decode_text(text_buf);
break;
case ALT_cIl__LAC:
cIl__LAC().decode_text(text_buf);
break;
case ALT_cIl__allInBSS:
cIl__allInBSS().decode_text(text_buf);
break;
case ALT_cIl__MCC__MNC:
cIl__MCC__MNC().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
}

void BSSMAP__FIELD__CellIdentificationListSegment::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__CellIdentificationListSegment::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__CellIdentificationListSegment::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, BSSMAP__FIELD__CellIdentificationList__CGI_descr_.raw->forceomit);
      decoded_length = cIl__CGI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__CGI_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_.raw->forceomit);
      decoded_length = cIl__LAC__CI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_.raw->forceomit);
      decoded_length = cIl__CI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, General__Types::OCT0_descr_.raw->forceomit);
      decoded_length = cIl__noCell().RAW_decode(General__Types::OCT0_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 4: {
      RAW_Force_Omit field_force_omit(4, force_omit, BSSMAP__FIELD__CellIdentificationList__LAI_descr_.raw->forceomit);
      decoded_length = cIl__LAI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAI_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 5: {
      RAW_Force_Omit field_force_omit(5, force_omit, RecordOfOCT2_descr_.raw->forceomit);
      decoded_length = cIl__LAC().RAW_decode(RecordOfOCT2_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 6: {
      RAW_Force_Omit field_force_omit(6, force_omit, General__Types::OCT0_descr_.raw->forceomit);
      decoded_length = cIl__allInBSS().RAW_decode(General__Types::OCT0_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 7: {
      RAW_Force_Omit field_force_omit(7, force_omit, RecordOfOCT3_descr_.raw->forceomit);
      decoded_length = cIl__MCC__MNC().RAW_decode(RecordOfOCT3_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, BSSMAP__FIELD__CellIdentificationList__CGI_descr_.raw->forceomit);
      decoded_length = cIl__CGI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__CGI_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_.raw->forceomit);
      decoded_length = cIl__LAC__CI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_.raw->forceomit);
      decoded_length = cIl__CI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT0_descr_.raw->forceomit);
      decoded_length = cIl__noCell().RAW_decode(General__Types::OCT0_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_3_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_4_force_omit(4, force_omit, BSSMAP__FIELD__CellIdentificationList__LAI_descr_.raw->forceomit);
      decoded_length = cIl__LAI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAI_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_4_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_5_force_omit(5, force_omit, RecordOfOCT2_descr_.raw->forceomit);
      decoded_length = cIl__LAC().RAW_decode(RecordOfOCT2_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_5_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_6_force_omit(6, force_omit, General__Types::OCT0_descr_.raw->forceomit);
      decoded_length = cIl__allInBSS().RAW_decode(General__Types::OCT0_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_6_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_7_force_omit(7, force_omit, RecordOfOCT3_descr_.raw->forceomit);
      decoded_length = cIl__MCC__MNC().RAW_decode(RecordOfOCT3_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_7_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int BSSMAP__FIELD__CellIdentificationListSegment::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 8;  myleaf.body.node.nodes = init_nodes_of_enc_tree(8);
  memset(myleaf.body.node.nodes, 0, 8 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_cIl__CGI:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, BSSMAP__FIELD__CellIdentificationList__CGI_descr_.raw);
    encoded_length = field_cIl__CGI->RAW_encode(BSSMAP__FIELD__CellIdentificationList__CGI_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &BSSMAP__FIELD__CellIdentificationList__CGI_descr_;
    break;
  case ALT_cIl__LAC__CI:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_.raw);
    encoded_length = field_cIl__LAC__CI->RAW_encode(BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_;
    break;
  case ALT_cIl__CI:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_.raw);
    encoded_length = field_cIl__CI->RAW_encode(BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_;
    break;
  case ALT_cIl__noCell:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, General__Types::OCT0_descr_.raw);
    encoded_length = field_cIl__noCell->RAW_encode(General__Types::OCT0_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &General__Types::OCT0_descr_;
    break;
  case ALT_cIl__LAI:
    myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 4, BSSMAP__FIELD__CellIdentificationList__LAI_descr_.raw);
    encoded_length = field_cIl__LAI->RAW_encode(BSSMAP__FIELD__CellIdentificationList__LAI_descr_, *myleaf.body.node.nodes[4]);
    myleaf.body.node.nodes[4]->coding_descr = &BSSMAP__FIELD__CellIdentificationList__LAI_descr_;
    break;
  case ALT_cIl__LAC:
    myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 5, RecordOfOCT2_descr_.raw);
    encoded_length = field_cIl__LAC->RAW_encode(RecordOfOCT2_descr_, *myleaf.body.node.nodes[5]);
    myleaf.body.node.nodes[5]->coding_descr = &RecordOfOCT2_descr_;
    break;
  case ALT_cIl__allInBSS:
    myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 6, General__Types::OCT0_descr_.raw);
    encoded_length = field_cIl__allInBSS->RAW_encode(General__Types::OCT0_descr_, *myleaf.body.node.nodes[6]);
    myleaf.body.node.nodes[6]->coding_descr = &General__Types::OCT0_descr_;
    break;
  case ALT_cIl__MCC__MNC:
    myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 7, RecordOfOCT3_descr_.raw);
    encoded_length = field_cIl__MCC__MNC->RAW_encode(RecordOfOCT3_descr_, *myleaf.body.node.nodes[7]);
    myleaf.body.node.nodes[7]->coding_descr = &RecordOfOCT3_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void BSSMAP__FIELD__CellIdentificationListSegment_template::copy_value(const BSSMAP__FIELD__CellIdentificationListSegment& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI:
single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template(other_value.cIl__CGI());
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(other_value.cIl__LAC__CI());
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI:
single_value.field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(other_value.cIl__CI());
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell:
single_value.field_cIl__noCell = new OCTETSTRING_template(other_value.cIl__noCell());
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI:
single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template(other_value.cIl__LAI());
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC:
single_value.field_cIl__LAC = new RecordOfOCT2_template(other_value.cIl__LAC());
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS = new OCTETSTRING_template(other_value.cIl__allInBSS());
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC:
single_value.field_cIl__MCC__MNC = new RecordOfOCT3_template(other_value.cIl__MCC__MNC());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__CellIdentificationListSegment_template::copy_template(const BSSMAP__FIELD__CellIdentificationListSegment_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI:
single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template(*other_value.single_value.field_cIl__CGI);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(*other_value.single_value.field_cIl__LAC__CI);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI:
single_value.field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(*other_value.single_value.field_cIl__CI);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell:
single_value.field_cIl__noCell = new OCTETSTRING_template(*other_value.single_value.field_cIl__noCell);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI:
single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template(*other_value.single_value.field_cIl__LAI);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC:
single_value.field_cIl__LAC = new RecordOfOCT2_template(*other_value.single_value.field_cIl__LAC);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS = new OCTETSTRING_template(*other_value.single_value.field_cIl__allInBSS);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC:
single_value.field_cIl__MCC__MNC = new RecordOfOCT3_template(*other_value.single_value.field_cIl__MCC__MNC);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationListSegment_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__CellIdentificationListSegment_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__CellIdentificationListSegment_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
set_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationListSegment_template::BSSMAP__FIELD__CellIdentificationListSegment_template()
{
}

BSSMAP__FIELD__CellIdentificationListSegment_template::BSSMAP__FIELD__CellIdentificationListSegment_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationListSegment_template::BSSMAP__FIELD__CellIdentificationListSegment_template(const BSSMAP__FIELD__CellIdentificationListSegment& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationListSegment_template::BSSMAP__FIELD__CellIdentificationListSegment_template(const OPTIONAL<BSSMAP__FIELD__CellIdentificationListSegment>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationListSegment&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment from an unbound optional field.");
}
}

BSSMAP__FIELD__CellIdentificationListSegment_template::BSSMAP__FIELD__CellIdentificationListSegment_template(BSSMAP__FIELD__CellIdentificationListSegment_template* p_precondition, BSSMAP__FIELD__CellIdentificationListSegment_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__CellIdentificationListSegment_template::BSSMAP__FIELD__CellIdentificationListSegment_template(Dynamic_Match_Interface<BSSMAP__FIELD__CellIdentificationListSegment>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__CellIdentificationListSegment>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__CellIdentificationListSegment_template::BSSMAP__FIELD__CellIdentificationListSegment_template(const BSSMAP__FIELD__CellIdentificationListSegment_template& other_value)
: Base_Template(){
copy_template(other_value);
}

BSSMAP__FIELD__CellIdentificationListSegment_template::~BSSMAP__FIELD__CellIdentificationListSegment_template()
{
clean_up();
}

void BSSMAP__FIELD__CellIdentificationListSegment_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI:
delete single_value.field_cIl__CGI;
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI:
delete single_value.field_cIl__LAC__CI;
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI:
delete single_value.field_cIl__CI;
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell:
delete single_value.field_cIl__noCell;
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI:
delete single_value.field_cIl__LAI;
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC:
delete single_value.field_cIl__LAC;
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS:
delete single_value.field_cIl__allInBSS;
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC:
delete single_value.field_cIl__MCC__MNC;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__CellIdentificationListSegment_template& BSSMAP__FIELD__CellIdentificationListSegment_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationListSegment_template& BSSMAP__FIELD__CellIdentificationListSegment_template::operator=(const BSSMAP__FIELD__CellIdentificationListSegment& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationListSegment_template& BSSMAP__FIELD__CellIdentificationListSegment_template::operator=(const OPTIONAL<BSSMAP__FIELD__CellIdentificationListSegment>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationListSegment&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
return *this;
}

BSSMAP__FIELD__CellIdentificationListSegment_template& BSSMAP__FIELD__CellIdentificationListSegment_template::operator=(const BSSMAP__FIELD__CellIdentificationListSegment_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationListSegment_template::match(const BSSMAP__FIELD__CellIdentificationListSegment& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
BSSMAP__FIELD__CellIdentificationListSegment::union_selection_type value_selection = other_value.get_selection();
if (value_selection == BSSMAP__FIELD__CellIdentificationListSegment::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI:
return single_value.field_cIl__CGI->match(other_value.cIl__CGI(), legacy);
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI:
return single_value.field_cIl__LAC__CI->match(other_value.cIl__LAC__CI(), legacy);
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI:
return single_value.field_cIl__CI->match(other_value.cIl__CI(), legacy);
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell:
return single_value.field_cIl__noCell->match(other_value.cIl__noCell(), legacy);
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI:
return single_value.field_cIl__LAI->match(other_value.cIl__LAI(), legacy);
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC:
return single_value.field_cIl__LAC->match(other_value.cIl__LAC(), legacy);
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS:
return single_value.field_cIl__allInBSS->match(other_value.cIl__allInBSS(), legacy);
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC:
return single_value.field_cIl__MCC__MNC->match(other_value.cIl__MCC__MNC(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
return FALSE;
}

boolean BSSMAP__FIELD__CellIdentificationListSegment_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI:
return single_value.field_cIl__CGI->is_value();
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI:
return single_value.field_cIl__LAC__CI->is_value();
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI:
return single_value.field_cIl__CI->is_value();
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell:
return single_value.field_cIl__noCell->is_value();
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI:
return single_value.field_cIl__LAI->is_value();
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC:
return single_value.field_cIl__LAC->is_value();
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS:
return single_value.field_cIl__allInBSS->is_value();
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC:
return single_value.field_cIl__MCC__MNC->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
}

BSSMAP__FIELD__CellIdentificationListSegment BSSMAP__FIELD__CellIdentificationListSegment_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
BSSMAP__FIELD__CellIdentificationListSegment ret_val;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI:
ret_val.cIl__CGI() = single_value.field_cIl__CGI->valueof();
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI:
ret_val.cIl__LAC__CI() = single_value.field_cIl__LAC__CI->valueof();
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI:
ret_val.cIl__CI() = single_value.field_cIl__CI->valueof();
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell:
ret_val.cIl__noCell() = single_value.field_cIl__noCell->valueof();
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI:
ret_val.cIl__LAI() = single_value.field_cIl__LAI->valueof();
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC:
ret_val.cIl__LAC() = single_value.field_cIl__LAC->valueof();
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS:
ret_val.cIl__allInBSS() = single_value.field_cIl__allInBSS->valueof();
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC:
ret_val.cIl__MCC__MNC() = single_value.field_cIl__MCC__MNC->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationListSegment_template& BSSMAP__FIELD__CellIdentificationListSegment_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return value_list.list_value[list_index];
}
void BSSMAP__FIELD__CellIdentificationListSegment_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationListSegment_template[list_length];
}

BSSMAP__FIELD__CellIdentificationList__CGI_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__CGI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template(ANY_VALUE);
else single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__CGI;
}

const BSSMAP__FIELD__CellIdentificationList__CGI_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__CGI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_CGI in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI) TTCN_error("Accessing non-selected field cIl_CGI in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *single_value.field_cIl__CGI;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__LAC__CI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(ANY_VALUE);
else single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__LAC__CI;
}

const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__LAC__CI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_LAC_CI in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI) TTCN_error("Accessing non-selected field cIl_LAC_CI in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *single_value.field_cIl__LAC__CI;
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__CI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(ANY_VALUE);
else single_value.field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__CI;
}

const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__CI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_CI in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI) TTCN_error("Accessing non-selected field cIl_CI in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *single_value.field_cIl__CI;
}

OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__noCell()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__noCell = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_cIl__noCell = new OCTETSTRING_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__noCell;
}

const OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__noCell() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_noCell in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell) TTCN_error("Accessing non-selected field cIl_noCell in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *single_value.field_cIl__noCell;
}

BSSMAP__FIELD__CellIdentificationList__LAI_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__LAI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template(ANY_VALUE);
else single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__LAI;
}

const BSSMAP__FIELD__CellIdentificationList__LAI_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__LAI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_LAI in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI) TTCN_error("Accessing non-selected field cIl_LAI in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *single_value.field_cIl__LAI;
}

RecordOfOCT2_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__LAC()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__LAC = new RecordOfOCT2_template(ANY_VALUE);
else single_value.field_cIl__LAC = new RecordOfOCT2_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__LAC;
}

const RecordOfOCT2_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__LAC() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_LAC in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC) TTCN_error("Accessing non-selected field cIl_LAC in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *single_value.field_cIl__LAC;
}

OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__allInBSS()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__allInBSS = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_cIl__allInBSS = new OCTETSTRING_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__allInBSS;
}

const OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__allInBSS() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_allInBSS in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS) TTCN_error("Accessing non-selected field cIl_allInBSS in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *single_value.field_cIl__allInBSS;
}

RecordOfOCT3_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__MCC__MNC()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__MCC__MNC = new RecordOfOCT3_template(ANY_VALUE);
else single_value.field_cIl__MCC__MNC = new RecordOfOCT3_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__MCC__MNC;
}

const RecordOfOCT3_template& BSSMAP__FIELD__CellIdentificationListSegment_template::cIl__MCC__MNC() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_MCC_MNC in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC) TTCN_error("Accessing non-selected field cIl_MCC_MNC in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return *single_value.field_cIl__MCC__MNC;
}

boolean BSSMAP__FIELD__CellIdentificationListSegment_template::ischosen(BSSMAP__FIELD__CellIdentificationListSegment::union_selection_type checked_selection) const
{
if (checked_selection == BSSMAP__FIELD__CellIdentificationListSegment::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == BSSMAP__FIELD__CellIdentificationListSegment::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationListSegment_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI:
TTCN_Logger::log_event_str("{ cIl_CGI := ");
single_value.field_cIl__CGI->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI:
TTCN_Logger::log_event_str("{ cIl_LAC_CI := ");
single_value.field_cIl__LAC__CI->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI:
TTCN_Logger::log_event_str("{ cIl_CI := ");
single_value.field_cIl__CI->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell:
TTCN_Logger::log_event_str("{ cIl_noCell := ");
single_value.field_cIl__noCell->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI:
TTCN_Logger::log_event_str("{ cIl_LAI := ");
single_value.field_cIl__LAI->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC:
TTCN_Logger::log_event_str("{ cIl_LAC := ");
single_value.field_cIl__LAC->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS:
TTCN_Logger::log_event_str("{ cIl_allInBSS := ");
single_value.field_cIl__allInBSS->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC:
TTCN_Logger::log_event_str("{ cIl_MCC_MNC := ");
single_value.field_cIl__MCC__MNC->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationListSegment_template::log_match(const BSSMAP__FIELD__CellIdentificationListSegment& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_CGI");
single_value.field_cIl__CGI->log_match(match_value.cIl__CGI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_CGI := ");
single_value.field_cIl__CGI->log_match(match_value.cIl__CGI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_LAC_CI");
single_value.field_cIl__LAC__CI->log_match(match_value.cIl__LAC__CI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_LAC_CI := ");
single_value.field_cIl__LAC__CI->log_match(match_value.cIl__LAC__CI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_CI");
single_value.field_cIl__CI->log_match(match_value.cIl__CI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_CI := ");
single_value.field_cIl__CI->log_match(match_value.cIl__CI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_noCell");
single_value.field_cIl__noCell->log_match(match_value.cIl__noCell(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_noCell := ");
single_value.field_cIl__noCell->log_match(match_value.cIl__noCell(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_LAI");
single_value.field_cIl__LAI->log_match(match_value.cIl__LAI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_LAI := ");
single_value.field_cIl__LAI->log_match(match_value.cIl__LAI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_LAC");
single_value.field_cIl__LAC->log_match(match_value.cIl__LAC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_LAC := ");
single_value.field_cIl__LAC->log_match(match_value.cIl__LAC(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_allInBSS");
single_value.field_cIl__allInBSS->log_match(match_value.cIl__allInBSS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_allInBSS := ");
single_value.field_cIl__allInBSS->log_match(match_value.cIl__allInBSS(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_MCC_MNC");
single_value.field_cIl__MCC__MNC->log_match(match_value.cIl__MCC__MNC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_MCC_MNC := ");
single_value.field_cIl__MCC__MNC->log_match(match_value.cIl__MCC__MNC(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__CellIdentificationListSegment_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI:
single_value.field_cIl__CGI->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI:
single_value.field_cIl__CI->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell:
single_value.field_cIl__noCell->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI:
single_value.field_cIl__LAI->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC:
single_value.field_cIl__LAC->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC:
single_value.field_cIl__MCC__MNC->set_implicit_omit(); break;
default: break;
}
}

void BSSMAP__FIELD__CellIdentificationListSegment_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI:
single_value.field_cIl__CGI->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI:
single_value.field_cIl__CI->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell:
single_value.field_cIl__noCell->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI:
single_value.field_cIl__LAI->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC:
single_value.field_cIl__LAC->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC:
single_value.field_cIl__MCC__MNC->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
}

void BSSMAP__FIELD__CellIdentificationListSegment_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListSegment::UNBOUND_VALUE;
BSSMAP__FIELD__CellIdentificationListSegment::union_selection_type new_selection = (BSSMAP__FIELD__CellIdentificationListSegment::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI:
single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template;
single_value.field_cIl__CGI->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template;
single_value.field_cIl__LAC__CI->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI:
single_value.field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template;
single_value.field_cIl__CI->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell:
single_value.field_cIl__noCell = new OCTETSTRING_template;
single_value.field_cIl__noCell->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI:
single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template;
single_value.field_cIl__LAI->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC:
single_value.field_cIl__LAC = new RecordOfOCT2_template;
single_value.field_cIl__LAC->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS = new OCTETSTRING_template;
single_value.field_cIl__allInBSS->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC:
single_value.field_cIl__MCC__MNC = new RecordOfOCT3_template;
single_value.field_cIl__MCC__MNC->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__CellIdentificationListSegment_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
}

boolean BSSMAP__FIELD__CellIdentificationListSegment_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__CellIdentificationListSegment_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationListSegment_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment'");
    }
    if (strcmp("cIl_CGI", param_field) == 0) {
      cIl__CGI().set_param(param);
      return;
    } else if (strcmp("cIl_LAC_CI", param_field) == 0) {
      cIl__LAC__CI().set_param(param);
      return;
    } else if (strcmp("cIl_CI", param_field) == 0) {
      cIl__CI().set_param(param);
      return;
    } else if (strcmp("cIl_noCell", param_field) == 0) {
      cIl__noCell().set_param(param);
      return;
    } else if (strcmp("cIl_LAI", param_field) == 0) {
      cIl__LAI().set_param(param);
      return;
    } else if (strcmp("cIl_LAC", param_field) == 0) {
      cIl__LAC().set_param(param);
      return;
    } else if (strcmp("cIl_allInBSS", param_field) == 0) {
      cIl__allInBSS().set_param(param);
      return;
    } else if (strcmp("cIl_MCC_MNC", param_field) == 0) {
      cIl__MCC__MNC().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__CellIdentificationListSegment_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "cIl_CGI")) {
      cIl__CGI().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_LAC_CI")) {
      cIl__LAC__CI().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_CI")) {
      cIl__CI().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_noCell")) {
      cIl__noCell().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_LAI")) {
      cIl__LAI().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_LAC")) {
      cIl__LAC().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_allInBSS")) {
      cIl__allInBSS().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_MCC_MNC")) {
      cIl__MCC__MNC().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__CellIdentificationListSegment_template* precondition = new BSSMAP__FIELD__CellIdentificationListSegment_template;
    precondition->set_param(*m_p->get_elem(0));
    BSSMAP__FIELD__CellIdentificationListSegment_template* implied_template = new BSSMAP__FIELD__CellIdentificationListSegment_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = BSSMAP__FIELD__CellIdentificationListSegment_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationListSegment_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI:
single_value.field_cIl__CGI->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment");
return;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment");
return;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI:
single_value.field_cIl__CI->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment");
return;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell:
single_value.field_cIl__noCell->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment");
return;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI:
single_value.field_cIl__LAI->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment");
return;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC:
single_value.field_cIl__LAC->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment");
return;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment");
return;
case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC:
single_value.field_cIl__MCC__MNC->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListSegment");
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment()
{
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment(const OCTETSTRING& par_mcc__mnc,
    const BSSMAP__FIELD__CellIdentificationList__LAC__CI& par_lac__ci)
  :   field_mcc__mnc(par_mcc__mnc),
  field_lac__ci(par_lac__ci)
{
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment(const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
if (other_value.mcc__mnc().is_bound()) field_mcc__mnc = other_value.mcc__mnc();
else field_mcc__mnc.clean_up();
if (other_value.lac__ci().is_bound()) field_lac__ci = other_value.lac__ci();
else field_lac__ci.clean_up();
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::clean_up()
{
field_mcc__mnc.clean_up();
field_lac__ci.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::get_descriptor() const { return &BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_; }
BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment& BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::operator=(const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
  if (other_value.mcc__mnc().is_bound()) field_mcc__mnc = other_value.mcc__mnc();
  else field_mcc__mnc.clean_up();
  if (other_value.lac__ci().is_bound()) field_lac__ci = other_value.lac__ci();
  else field_lac__ci.clean_up();
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::operator==(const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment& other_value) const
{
return field_mcc__mnc==other_value.field_mcc__mnc
  && field_lac__ci==other_value.field_lac__ci;
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::is_bound() const
{
return (field_mcc__mnc.is_bound())
  || (field_lac__ci.is_bound());
}
boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::is_value() const
{
return field_mcc__mnc.is_value()
  && field_lac__ci.is_value();
}
void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ mcc_mnc := ");
field_mcc__mnc.log();
TTCN_Logger::log_event_str(", lac_ci := ");
field_lac__ci.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::set_implicit_omit()
{
if (mcc__mnc().is_bound()) mcc__mnc().set_implicit_omit();
if (lac__ci().is_bound()) lac__ci().set_implicit_omit();
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) mcc__mnc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lac__ci().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcc_mnc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcc__mnc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lac_ci")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lac__ci().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment");
  }
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::encode_text(Text_Buf& text_buf) const
{
field_mcc__mnc.encode_text(text_buf);
field_lac__ci.encode_text(text_buf);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::decode_text(Text_Buf& text_buf)
{
field_mcc__mnc.decode_text(text_buf);
field_lac__ci.decode_text(text_buf);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT3_descr_.raw->forceomit);
  decoded_field_length = field_mcc__mnc.RAW_decode(General__Types::OCT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__FIELD__CellIdentificationList__LAC__CI_descr_.raw->forceomit);
  decoded_field_length = field_lac__ci.RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAC__CI_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT3_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__FIELD__CellIdentificationList__LAC__CI_descr_.raw);
  encoded_length += field_mcc__mnc.RAW_encode(General__Types::OCT3_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_lac__ci.RAW_encode(BSSMAP__FIELD__CellIdentificationList__LAC__CI_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::single_value_struct {
OCTETSTRING_template field_mcc__mnc;
BSSMAP__FIELD__CellIdentificationList__LAC__CI_template field_lac__ci;
};

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_mcc__mnc = ANY_VALUE;
single_value->field_lac__ci = ANY_VALUE;
}
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::copy_value(const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment& other_value)
{
single_value = new single_value_struct;
if (other_value.mcc__mnc().is_bound()) {
  single_value->field_mcc__mnc = other_value.mcc__mnc();
} else {
  single_value->field_mcc__mnc.clean_up();
}
if (other_value.lac__ci().is_bound()) {
  single_value->field_lac__ci = other_value.lac__ci();
} else {
  single_value->field_lac__ci.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::copy_template(const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.mcc__mnc().get_selection()) {
single_value->field_mcc__mnc = other_value.mcc__mnc();
} else {
single_value->field_mcc__mnc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lac__ci().get_selection()) {
single_value->field_lac__ci = other_value.lac__ci();
} else {
single_value->field_lac__ci.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
break;
}
set_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template()
{
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment from an unbound optional field.");
}
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template* p_precondition, BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(Dynamic_Match_Interface<BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::~BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template()
{
clean_up();
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::operator=(const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::operator=(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
}
return *this;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::operator=(const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::match(const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.mcc__mnc().is_bound()) return FALSE;
if(!single_value->field_mcc__mnc.match(other_value.mcc__mnc(), legacy))return FALSE;
if(!other_value.lac__ci().is_bound()) return FALSE;
if(!single_value->field_lac__ci.match(other_value.lac__ci(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
}
return FALSE;
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_mcc__mnc.is_bound()
 || single_value->field_lac__ci.is_bound();
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_mcc__mnc.is_value()
 && single_value->field_lac__ci.is_value();
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment ret_val;
if (single_value->field_mcc__mnc.is_bound()) {
ret_val.mcc__mnc() = single_value->field_mcc__mnc.valueof();
}
if (single_value->field_lac__ci.is_bound()) {
ret_val.lac__ci() = single_value->field_lac__ci.valueof();
}
return ret_val;
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template[list_length];
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::mcc__mnc()
{
set_specific();
return single_value->field_mcc__mnc;
}

const OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::mcc__mnc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mcc_mnc of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
return single_value->field_mcc__mnc;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::lac__ci()
{
set_specific();
return single_value->field_lac__ci;
}

const BSSMAP__FIELD__CellIdentificationList__LAC__CI_template& BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::lac__ci() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lac_ci of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
return single_value->field_lac__ci;
}

int BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
  }
  return 0;
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ mcc_mnc := ");
single_value->field_mcc__mnc.log();
TTCN_Logger::log_event_str(", lac_ci := ");
single_value->field_lac__ci.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::log_match(const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_mcc__mnc.match(match_value.mcc__mnc(), legacy)){
TTCN_Logger::log_logmatch_info(".mcc_mnc");
single_value->field_mcc__mnc.log_match(match_value.mcc__mnc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lac__ci.match(match_value.lac__ci(), legacy)){
TTCN_Logger::log_logmatch_info(".lac_ci");
single_value->field_lac__ci.log_match(match_value.lac__ci(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ mcc_mnc := ");
single_value->field_mcc__mnc.log_match(match_value.mcc__mnc(), legacy);
TTCN_Logger::log_event_str(", lac_ci := ");
single_value->field_lac__ci.log_match(match_value.lac__ci(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (mcc__mnc().is_bound()) mcc__mnc().set_implicit_omit();
if (lac__ci().is_bound()) lac__ci().set_implicit_omit();
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_mcc__mnc.encode_text(text_buf);
single_value->field_lac__ci.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_mcc__mnc.decode_text(text_buf);
single_value->field_lac__ci.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment.");
}
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) mcc__mnc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lac__ci().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcc_mnc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcc__mnc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lac_ci")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lac__ci().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template* precondition = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template* implied_template = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_mcc__mnc.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment");
single_value->field_lac__ci.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_LAC_CI_Segment");
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment()
{
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment(const OCTETSTRING& par_mcc__mnc,
    const OCTETSTRING& par_lac,
    const RecordOfOCT2& par_ci)
  :   field_mcc__mnc(par_mcc__mnc),
  field_lac(par_lac),
  field_ci(par_ci)
{
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment(const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
if (other_value.mcc__mnc().is_bound()) field_mcc__mnc = other_value.mcc__mnc();
else field_mcc__mnc.clean_up();
if (other_value.lac().is_bound()) field_lac = other_value.lac();
else field_lac.clean_up();
if (other_value.ci().is_bound()) field_ci = other_value.ci();
else field_ci.clean_up();
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::clean_up()
{
field_mcc__mnc.clean_up();
field_lac.clean_up();
field_ci.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::get_descriptor() const { return &BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_; }
BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment& BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::operator=(const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
  if (other_value.mcc__mnc().is_bound()) field_mcc__mnc = other_value.mcc__mnc();
  else field_mcc__mnc.clean_up();
  if (other_value.lac().is_bound()) field_lac = other_value.lac();
  else field_lac.clean_up();
  if (other_value.ci().is_bound()) field_ci = other_value.ci();
  else field_ci.clean_up();
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::operator==(const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment& other_value) const
{
return field_mcc__mnc==other_value.field_mcc__mnc
  && field_lac==other_value.field_lac
  && field_ci==other_value.field_ci;
}

boolean BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::is_bound() const
{
return (field_mcc__mnc.is_bound())
  || (field_lac.is_bound())
  || (field_ci.is_bound());
}
boolean BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::is_value() const
{
return field_mcc__mnc.is_value()
  && field_lac.is_value()
  && field_ci.is_value();
}
void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ mcc_mnc := ");
field_mcc__mnc.log();
TTCN_Logger::log_event_str(", lac := ");
field_lac.log();
TTCN_Logger::log_event_str(", ci := ");
field_ci.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::set_implicit_omit()
{
if (mcc__mnc().is_bound()) mcc__mnc().set_implicit_omit();
if (lac().is_bound()) lac().set_implicit_omit();
if (ci().is_bound()) ci().set_implicit_omit();
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) mcc__mnc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lac().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ci().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcc_mnc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcc__mnc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ci")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ci().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment");
  }
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::encode_text(Text_Buf& text_buf) const
{
field_mcc__mnc.encode_text(text_buf);
field_lac.encode_text(text_buf);
field_ci.encode_text(text_buf);
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::decode_text(Text_Buf& text_buf)
{
field_mcc__mnc.decode_text(text_buf);
field_lac.decode_text(text_buf);
field_ci.decode_text(text_buf);
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT3_descr_.raw->forceomit);
  decoded_field_length = field_mcc__mnc.RAW_decode(General__Types::OCT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_lac.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, RecordOfOCT2_descr_.raw->forceomit);
  decoded_field_length = field_ci.RAW_decode(RecordOfOCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT3_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RecordOfOCT2_descr_.raw);
  encoded_length += field_mcc__mnc.RAW_encode(General__Types::OCT3_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_lac.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_ci.RAW_encode(RecordOfOCT2_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::single_value_struct {
OCTETSTRING_template field_mcc__mnc;
OCTETSTRING_template field_lac;
RecordOfOCT2_template field_ci;
};

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_mcc__mnc = ANY_VALUE;
single_value->field_lac = ANY_VALUE;
single_value->field_ci = ANY_VALUE;
}
}
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::copy_value(const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment& other_value)
{
single_value = new single_value_struct;
if (other_value.mcc__mnc().is_bound()) {
  single_value->field_mcc__mnc = other_value.mcc__mnc();
} else {
  single_value->field_mcc__mnc.clean_up();
}
if (other_value.lac().is_bound()) {
  single_value->field_lac = other_value.lac();
} else {
  single_value->field_lac.clean_up();
}
if (other_value.ci().is_bound()) {
  single_value->field_ci = other_value.ci();
} else {
  single_value->field_ci.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::copy_template(const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.mcc__mnc().get_selection()) {
single_value->field_mcc__mnc = other_value.mcc__mnc();
} else {
single_value->field_mcc__mnc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lac().get_selection()) {
single_value->field_lac = other_value.lac();
} else {
single_value->field_lac.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ci().get_selection()) {
single_value->field_ci = other_value.ci();
} else {
single_value->field_ci.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
break;
}
set_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template()
{
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment from an unbound optional field.");
}
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template* p_precondition, BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(Dynamic_Match_Interface<BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::~BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template()
{
clean_up();
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template& BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template& BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::operator=(const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template& BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::operator=(const OPTIONAL<BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
}
return *this;
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template& BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::operator=(const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::match(const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.mcc__mnc().is_bound()) return FALSE;
if(!single_value->field_mcc__mnc.match(other_value.mcc__mnc(), legacy))return FALSE;
if(!other_value.lac().is_bound()) return FALSE;
if(!single_value->field_lac.match(other_value.lac(), legacy))return FALSE;
if(!other_value.ci().is_bound()) return FALSE;
if(!single_value->field_ci.match(other_value.ci(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
}
return FALSE;
}

boolean BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_mcc__mnc.is_bound()
 || single_value->field_lac.is_bound()
 || single_value->field_ci.is_bound();
}

boolean BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_mcc__mnc.is_value()
 && single_value->field_lac.is_value()
 && single_value->field_ci.is_value();
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment ret_val;
if (single_value->field_mcc__mnc.is_bound()) {
ret_val.mcc__mnc() = single_value->field_mcc__mnc.valueof();
}
if (single_value->field_lac.is_bound()) {
ret_val.lac() = single_value->field_lac.valueof();
}
if (single_value->field_ci.is_bound()) {
ret_val.ci() = single_value->field_ci.valueof();
}
return ret_val;
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template[list_length];
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template& BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::mcc__mnc()
{
set_specific();
return single_value->field_mcc__mnc;
}

const OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::mcc__mnc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mcc_mnc of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
return single_value->field_mcc__mnc;
}

OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::lac()
{
set_specific();
return single_value->field_lac;
}

const OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::lac() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lac of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
return single_value->field_lac;
}

RecordOfOCT2_template& BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::ci()
{
set_specific();
return single_value->field_ci;
}

const RecordOfOCT2_template& BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::ci() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ci of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
return single_value->field_ci;
}

int BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
  }
  return 0;
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ mcc_mnc := ");
single_value->field_mcc__mnc.log();
TTCN_Logger::log_event_str(", lac := ");
single_value->field_lac.log();
TTCN_Logger::log_event_str(", ci := ");
single_value->field_ci.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::log_match(const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_mcc__mnc.match(match_value.mcc__mnc(), legacy)){
TTCN_Logger::log_logmatch_info(".mcc_mnc");
single_value->field_mcc__mnc.log_match(match_value.mcc__mnc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lac.match(match_value.lac(), legacy)){
TTCN_Logger::log_logmatch_info(".lac");
single_value->field_lac.log_match(match_value.lac(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ci.match(match_value.ci(), legacy)){
TTCN_Logger::log_logmatch_info(".ci");
single_value->field_ci.log_match(match_value.ci(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ mcc_mnc := ");
single_value->field_mcc__mnc.log_match(match_value.mcc__mnc(), legacy);
TTCN_Logger::log_event_str(", lac := ");
single_value->field_lac.log_match(match_value.lac(), legacy);
TTCN_Logger::log_event_str(", ci := ");
single_value->field_ci.log_match(match_value.ci(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (mcc__mnc().is_bound()) mcc__mnc().set_implicit_omit();
if (lac().is_bound()) lac().set_implicit_omit();
if (ci().is_bound()) ci().set_implicit_omit();
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_mcc__mnc.encode_text(text_buf);
single_value->field_lac.encode_text(text_buf);
single_value->field_ci.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
}
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_mcc__mnc.decode_text(text_buf);
single_value->field_lac.decode_text(text_buf);
single_value->field_ci.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment.");
}
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) mcc__mnc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lac().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ci().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcc_mnc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcc__mnc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ci")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ci().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template* precondition = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template* implied_template = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_mcc__mnc.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment");
single_value->field_lac.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment");
single_value->field_ci.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationList_CIL_CI_Segment");
}

boolean BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__CellIdentifierListSegment::BSSMAP__IE__CellIdentifierListSegment()
{
}

BSSMAP__IE__CellIdentifierListSegment::BSSMAP__IE__CellIdentifierListSegment(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_sequenceNumber,
    const BITSTRING& par_sequenceLength,
    const BITSTRING& par_cellIdentifierDiscriminator,
    const BITSTRING& par_spare,
    const BSSMAP__FIELD__CellIdentificationListSegment& par_cellIdentificationListSegment)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_sequenceNumber(par_sequenceNumber),
  field_sequenceLength(par_sequenceLength),
  field_cellIdentifierDiscriminator(par_cellIdentifierDiscriminator),
  field_spare(par_spare),
  field_cellIdentificationListSegment(par_cellIdentificationListSegment)
{
}

BSSMAP__IE__CellIdentifierListSegment::BSSMAP__IE__CellIdentifierListSegment(const BSSMAP__IE__CellIdentifierListSegment& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.sequenceNumber().is_bound()) field_sequenceNumber = other_value.sequenceNumber();
else field_sequenceNumber.clean_up();
if (other_value.sequenceLength().is_bound()) field_sequenceLength = other_value.sequenceLength();
else field_sequenceLength.clean_up();
if (other_value.cellIdentifierDiscriminator().is_bound()) field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
else field_cellIdentifierDiscriminator.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.cellIdentificationListSegment().is_bound()) field_cellIdentificationListSegment = other_value.cellIdentificationListSegment();
else field_cellIdentificationListSegment.clean_up();
}

void BSSMAP__IE__CellIdentifierListSegment::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_sequenceNumber.clean_up();
field_sequenceLength.clean_up();
field_cellIdentifierDiscriminator.clean_up();
field_spare.clean_up();
field_cellIdentificationListSegment.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__CellIdentifierListSegment::get_descriptor() const { return &BSSMAP__IE__CellIdentifierListSegment_descr_; }
BSSMAP__IE__CellIdentifierListSegment& BSSMAP__IE__CellIdentifierListSegment::operator=(const BSSMAP__IE__CellIdentifierListSegment& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.sequenceNumber().is_bound()) field_sequenceNumber = other_value.sequenceNumber();
  else field_sequenceNumber.clean_up();
  if (other_value.sequenceLength().is_bound()) field_sequenceLength = other_value.sequenceLength();
  else field_sequenceLength.clean_up();
  if (other_value.cellIdentifierDiscriminator().is_bound()) field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
  else field_cellIdentifierDiscriminator.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.cellIdentificationListSegment().is_bound()) field_cellIdentificationListSegment = other_value.cellIdentificationListSegment();
  else field_cellIdentificationListSegment.clean_up();
}
return *this;
}

boolean BSSMAP__IE__CellIdentifierListSegment::operator==(const BSSMAP__IE__CellIdentifierListSegment& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_sequenceNumber==other_value.field_sequenceNumber
  && field_sequenceLength==other_value.field_sequenceLength
  && field_cellIdentifierDiscriminator==other_value.field_cellIdentifierDiscriminator
  && field_spare==other_value.field_spare
  && field_cellIdentificationListSegment==other_value.field_cellIdentificationListSegment;
}

boolean BSSMAP__IE__CellIdentifierListSegment::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_sequenceNumber.is_bound())
  || (field_sequenceLength.is_bound())
  || (field_cellIdentifierDiscriminator.is_bound())
  || (field_spare.is_bound())
  || (field_cellIdentificationListSegment.is_bound());
}
boolean BSSMAP__IE__CellIdentifierListSegment::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_sequenceNumber.is_value()
  && field_sequenceLength.is_value()
  && field_cellIdentifierDiscriminator.is_value()
  && field_spare.is_value()
  && field_cellIdentificationListSegment.is_value();
}
void BSSMAP__IE__CellIdentifierListSegment::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", sequenceNumber := ");
field_sequenceNumber.log();
TTCN_Logger::log_event_str(", sequenceLength := ");
field_sequenceLength.log();
TTCN_Logger::log_event_str(", cellIdentifierDiscriminator := ");
field_cellIdentifierDiscriminator.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", cellIdentificationListSegment := ");
field_cellIdentificationListSegment.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__CellIdentifierListSegment::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (sequenceNumber().is_bound()) sequenceNumber().set_implicit_omit();
if (sequenceLength().is_bound()) sequenceLength().set_implicit_omit();
if (cellIdentifierDiscriminator().is_bound()) cellIdentifierDiscriminator().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (cellIdentificationListSegment().is_bound()) cellIdentificationListSegment().set_implicit_omit();
}

void BSSMAP__IE__CellIdentifierListSegment::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sequenceNumber().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) sequenceLength().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) cellIdentifierDiscriminator().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) cellIdentificationListSegment().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sequenceNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sequenceNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sequenceLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sequenceLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifierDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifierDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentificationListSegment")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentificationListSegment().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment");
  }
}

void BSSMAP__IE__CellIdentifierListSegment::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_sequenceNumber.encode_text(text_buf);
field_sequenceLength.encode_text(text_buf);
field_cellIdentifierDiscriminator.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_cellIdentificationListSegment.encode_text(text_buf);
}

void BSSMAP__IE__CellIdentifierListSegment::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_sequenceNumber.decode_text(text_buf);
field_sequenceLength.decode_text(text_buf);
field_cellIdentifierDiscriminator.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_cellIdentificationListSegment.decode_text(text_buf);
}

void BSSMAP__IE__CellIdentifierListSegment::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__CellIdentifierListSegment::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__CellIdentifierListSegment::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__CellIdentifierListSegment_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__CellIdentifierListSegment_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__CellIdentifierListSegment_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_sequenceNumber.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_sequenceLength.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentifierDiscriminator.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_cellIdentifierDiscriminator ==  bs_0) selected_field = 0;
  else if (field_cellIdentifierDiscriminator ==  bs_1) selected_field = 1;
  else if (field_cellIdentifierDiscriminator ==  bs_2) selected_field = 2;
  else if (field_cellIdentifierDiscriminator ==  bs_3) selected_field = 3;
  else if (field_cellIdentifierDiscriminator ==  bs_10) selected_field = 4;
  else if (field_cellIdentifierDiscriminator ==  bs_11) selected_field = 5;
  else if (field_cellIdentifierDiscriminator ==  bs_12) selected_field = 6;
  else if (field_cellIdentifierDiscriminator ==  bs_13) selected_field = 7;
  else selected_field = -1;
  RAW_Force_Omit field_6_force_omit(6, force_omit, BSSMAP__IE__CellIdentifierListSegment_cellIdentificationListSegment_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentificationListSegment.RAW_decode(BSSMAP__IE__CellIdentifierListSegment_cellIdentificationListSegment_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, selected_field, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_118) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__CellIdentifierListSegment::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 7;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(7);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__CellIdentifierListSegment_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, BSSMAP__IE__CellIdentifierListSegment_cellIdentificationListSegment_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__CellIdentifierListSegment_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 5;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(5);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[4].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[4].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  encoded_length += field_sequenceNumber.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_sequenceLength.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_cellIdentifierDiscriminator.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_cellIdentificationListSegment.RAW_encode(BSSMAP__IE__CellIdentifierListSegment_cellIdentificationListSegment_descr_, *myleaf.body.node.nodes[6]);
  switch (field_cellIdentificationListSegment.get_selection()) {
  case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CGI:
  if (field_cellIdentifierDiscriminator !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 4 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC__CI:
  if (field_cellIdentifierDiscriminator !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 4 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__CI:
  if (field_cellIdentifierDiscriminator !=  bs_2) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 4 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_2.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__noCell:
  if (field_cellIdentifierDiscriminator !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 4 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAI:
  if (field_cellIdentifierDiscriminator !=  bs_10) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 4 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_10.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__LAC:
  if (field_cellIdentifierDiscriminator !=  bs_11) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 4 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_11.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__allInBSS:
  if (field_cellIdentifierDiscriminator !=  bs_12) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 4 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_12.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationListSegment::ALT_cIl__MCC__MNC:
  if (field_cellIdentifierDiscriminator !=  bs_13) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 4 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_13.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_elementIdentifier !=  os_118) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_118.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__CellIdentifierListSegment_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_sequenceNumber;
BITSTRING_template field_sequenceLength;
BITSTRING_template field_cellIdentifierDiscriminator;
BITSTRING_template field_spare;
BSSMAP__FIELD__CellIdentificationListSegment_template field_cellIdentificationListSegment;
};

void BSSMAP__IE__CellIdentifierListSegment_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_sequenceNumber = ANY_VALUE;
single_value->field_sequenceLength = ANY_VALUE;
single_value->field_cellIdentifierDiscriminator = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_cellIdentificationListSegment = ANY_VALUE;
}
}
}

void BSSMAP__IE__CellIdentifierListSegment_template::copy_value(const BSSMAP__IE__CellIdentifierListSegment& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.sequenceNumber().is_bound()) {
  single_value->field_sequenceNumber = other_value.sequenceNumber();
} else {
  single_value->field_sequenceNumber.clean_up();
}
if (other_value.sequenceLength().is_bound()) {
  single_value->field_sequenceLength = other_value.sequenceLength();
} else {
  single_value->field_sequenceLength.clean_up();
}
if (other_value.cellIdentifierDiscriminator().is_bound()) {
  single_value->field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
} else {
  single_value->field_cellIdentifierDiscriminator.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.cellIdentificationListSegment().is_bound()) {
  single_value->field_cellIdentificationListSegment = other_value.cellIdentificationListSegment();
} else {
  single_value->field_cellIdentificationListSegment.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__CellIdentifierListSegment_template::copy_template(const BSSMAP__IE__CellIdentifierListSegment_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sequenceNumber().get_selection()) {
single_value->field_sequenceNumber = other_value.sequenceNumber();
} else {
single_value->field_sequenceNumber.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sequenceLength().get_selection()) {
single_value->field_sequenceLength = other_value.sequenceLength();
} else {
single_value->field_sequenceLength.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentifierDiscriminator().get_selection()) {
single_value->field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
} else {
single_value->field_cellIdentifierDiscriminator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentificationListSegment().get_selection()) {
single_value->field_cellIdentificationListSegment = other_value.cellIdentificationListSegment();
} else {
single_value->field_cellIdentificationListSegment.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__CellIdentifierListSegment_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__CellIdentifierListSegment_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__CellIdentifierListSegment_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__CellIdentifierListSegment_template::BSSMAP__IE__CellIdentifierListSegment_template()
{
}

BSSMAP__IE__CellIdentifierListSegment_template::BSSMAP__IE__CellIdentifierListSegment_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__CellIdentifierListSegment_template::BSSMAP__IE__CellIdentifierListSegment_template(const BSSMAP__IE__CellIdentifierListSegment& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__CellIdentifierListSegment_template::BSSMAP__IE__CellIdentifierListSegment_template(const OPTIONAL<BSSMAP__IE__CellIdentifierListSegment>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CellIdentifierListSegment&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment from an unbound optional field.");
}
}

BSSMAP__IE__CellIdentifierListSegment_template::BSSMAP__IE__CellIdentifierListSegment_template(BSSMAP__IE__CellIdentifierListSegment_template* p_precondition, BSSMAP__IE__CellIdentifierListSegment_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__CellIdentifierListSegment_template::BSSMAP__IE__CellIdentifierListSegment_template(Dynamic_Match_Interface<BSSMAP__IE__CellIdentifierListSegment>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__CellIdentifierListSegment>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__CellIdentifierListSegment_template::BSSMAP__IE__CellIdentifierListSegment_template(const BSSMAP__IE__CellIdentifierListSegment_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__CellIdentifierListSegment_template::~BSSMAP__IE__CellIdentifierListSegment_template()
{
clean_up();
}

BSSMAP__IE__CellIdentifierListSegment_template& BSSMAP__IE__CellIdentifierListSegment_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__CellIdentifierListSegment_template& BSSMAP__IE__CellIdentifierListSegment_template::operator=(const BSSMAP__IE__CellIdentifierListSegment& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__CellIdentifierListSegment_template& BSSMAP__IE__CellIdentifierListSegment_template::operator=(const OPTIONAL<BSSMAP__IE__CellIdentifierListSegment>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CellIdentifierListSegment&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
}
return *this;
}

BSSMAP__IE__CellIdentifierListSegment_template& BSSMAP__IE__CellIdentifierListSegment_template::operator=(const BSSMAP__IE__CellIdentifierListSegment_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__CellIdentifierListSegment_template::match(const BSSMAP__IE__CellIdentifierListSegment& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.sequenceNumber().is_bound()) return FALSE;
if(!single_value->field_sequenceNumber.match(other_value.sequenceNumber(), legacy))return FALSE;
if(!other_value.sequenceLength().is_bound()) return FALSE;
if(!single_value->field_sequenceLength.match(other_value.sequenceLength(), legacy))return FALSE;
if(!other_value.cellIdentifierDiscriminator().is_bound()) return FALSE;
if(!single_value->field_cellIdentifierDiscriminator.match(other_value.cellIdentifierDiscriminator(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.cellIdentificationListSegment().is_bound()) return FALSE;
if(!single_value->field_cellIdentificationListSegment.match(other_value.cellIdentificationListSegment(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
}
return FALSE;
}

boolean BSSMAP__IE__CellIdentifierListSegment_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_sequenceNumber.is_bound()
 || single_value->field_sequenceLength.is_bound()
 || single_value->field_cellIdentifierDiscriminator.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_cellIdentificationListSegment.is_bound();
}

boolean BSSMAP__IE__CellIdentifierListSegment_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_sequenceNumber.is_value()
 && single_value->field_sequenceLength.is_value()
 && single_value->field_cellIdentifierDiscriminator.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_cellIdentificationListSegment.is_value();
}

void BSSMAP__IE__CellIdentifierListSegment_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__CellIdentifierListSegment BSSMAP__IE__CellIdentifierListSegment_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
BSSMAP__IE__CellIdentifierListSegment ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_sequenceNumber.is_bound()) {
ret_val.sequenceNumber() = single_value->field_sequenceNumber.valueof();
}
if (single_value->field_sequenceLength.is_bound()) {
ret_val.sequenceLength() = single_value->field_sequenceLength.valueof();
}
if (single_value->field_cellIdentifierDiscriminator.is_bound()) {
ret_val.cellIdentifierDiscriminator() = single_value->field_cellIdentifierDiscriminator.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_cellIdentificationListSegment.is_bound()) {
ret_val.cellIdentificationListSegment() = single_value->field_cellIdentificationListSegment.valueof();
}
return ret_val;
}

void BSSMAP__IE__CellIdentifierListSegment_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__CellIdentifierListSegment_template[list_length];
}

BSSMAP__IE__CellIdentifierListSegment_template& BSSMAP__IE__CellIdentifierListSegment_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__CellIdentifierListSegment_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__CellIdentifierListSegment_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__CellIdentifierListSegment_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__CellIdentifierListSegment_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& BSSMAP__IE__CellIdentifierListSegment_template::sequenceNumber()
{
set_specific();
return single_value->field_sequenceNumber;
}

const BITSTRING_template& BSSMAP__IE__CellIdentifierListSegment_template::sequenceNumber() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sequenceNumber of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
return single_value->field_sequenceNumber;
}

BITSTRING_template& BSSMAP__IE__CellIdentifierListSegment_template::sequenceLength()
{
set_specific();
return single_value->field_sequenceLength;
}

const BITSTRING_template& BSSMAP__IE__CellIdentifierListSegment_template::sequenceLength() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sequenceLength of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
return single_value->field_sequenceLength;
}

BITSTRING_template& BSSMAP__IE__CellIdentifierListSegment_template::cellIdentifierDiscriminator()
{
set_specific();
return single_value->field_cellIdentifierDiscriminator;
}

const BITSTRING_template& BSSMAP__IE__CellIdentifierListSegment_template::cellIdentifierDiscriminator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentifierDiscriminator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
return single_value->field_cellIdentifierDiscriminator;
}

BITSTRING_template& BSSMAP__IE__CellIdentifierListSegment_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& BSSMAP__IE__CellIdentifierListSegment_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
return single_value->field_spare;
}

BSSMAP__FIELD__CellIdentificationListSegment_template& BSSMAP__IE__CellIdentifierListSegment_template::cellIdentificationListSegment()
{
set_specific();
return single_value->field_cellIdentificationListSegment;
}

const BSSMAP__FIELD__CellIdentificationListSegment_template& BSSMAP__IE__CellIdentifierListSegment_template::cellIdentificationListSegment() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentificationListSegment of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
return single_value->field_cellIdentificationListSegment;
}

int BSSMAP__IE__CellIdentifierListSegment_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 7;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
  }
  return 0;
}

void BSSMAP__IE__CellIdentifierListSegment_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", sequenceNumber := ");
single_value->field_sequenceNumber.log();
TTCN_Logger::log_event_str(", sequenceLength := ");
single_value->field_sequenceLength.log();
TTCN_Logger::log_event_str(", cellIdentifierDiscriminator := ");
single_value->field_cellIdentifierDiscriminator.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", cellIdentificationListSegment := ");
single_value->field_cellIdentificationListSegment.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__CellIdentifierListSegment_template::log_match(const BSSMAP__IE__CellIdentifierListSegment& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sequenceNumber.match(match_value.sequenceNumber(), legacy)){
TTCN_Logger::log_logmatch_info(".sequenceNumber");
single_value->field_sequenceNumber.log_match(match_value.sequenceNumber(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sequenceLength.match(match_value.sequenceLength(), legacy)){
TTCN_Logger::log_logmatch_info(".sequenceLength");
single_value->field_sequenceLength.log_match(match_value.sequenceLength(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cellIdentifierDiscriminator.match(match_value.cellIdentifierDiscriminator(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentifierDiscriminator");
single_value->field_cellIdentifierDiscriminator.log_match(match_value.cellIdentifierDiscriminator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cellIdentificationListSegment.match(match_value.cellIdentificationListSegment(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentificationListSegment");
single_value->field_cellIdentificationListSegment.log_match(match_value.cellIdentificationListSegment(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", sequenceNumber := ");
single_value->field_sequenceNumber.log_match(match_value.sequenceNumber(), legacy);
TTCN_Logger::log_event_str(", sequenceLength := ");
single_value->field_sequenceLength.log_match(match_value.sequenceLength(), legacy);
TTCN_Logger::log_event_str(", cellIdentifierDiscriminator := ");
single_value->field_cellIdentifierDiscriminator.log_match(match_value.cellIdentifierDiscriminator(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", cellIdentificationListSegment := ");
single_value->field_cellIdentificationListSegment.log_match(match_value.cellIdentificationListSegment(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__CellIdentifierListSegment_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (sequenceNumber().is_bound()) sequenceNumber().set_implicit_omit();
if (sequenceLength().is_bound()) sequenceLength().set_implicit_omit();
if (cellIdentifierDiscriminator().is_bound()) cellIdentifierDiscriminator().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (cellIdentificationListSegment().is_bound()) cellIdentificationListSegment().set_implicit_omit();
}

void BSSMAP__IE__CellIdentifierListSegment_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_sequenceNumber.encode_text(text_buf);
single_value->field_sequenceLength.encode_text(text_buf);
single_value->field_cellIdentifierDiscriminator.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_cellIdentificationListSegment.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
}
}

void BSSMAP__IE__CellIdentifierListSegment_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_sequenceNumber.decode_text(text_buf);
single_value->field_sequenceLength.decode_text(text_buf);
single_value->field_cellIdentifierDiscriminator.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_cellIdentificationListSegment.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__CellIdentifierListSegment_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment.");
}
}

void BSSMAP__IE__CellIdentifierListSegment_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__CellIdentifierListSegment_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sequenceNumber().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) sequenceLength().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) cellIdentifierDiscriminator().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) cellIdentificationListSegment().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sequenceNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sequenceNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sequenceLength")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sequenceLength().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifierDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifierDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentificationListSegment")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentificationListSegment().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__CellIdentifierListSegment_template* precondition = new BSSMAP__IE__CellIdentifierListSegment_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__CellIdentifierListSegment_template* implied_template = new BSSMAP__IE__CellIdentifierListSegment_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__CellIdentifierListSegment_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__CellIdentifierListSegment_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment");
single_value->field_sequenceNumber.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment");
single_value->field_sequenceLength.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment");
single_value->field_cellIdentifierDiscriminator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment");
single_value->field_cellIdentificationListSegment.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CellIdentifierListSegment");
}

boolean BSSMAP__IE__CellIdentifierListSegment_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__CellIdentifierListSegment_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationListEstablishment::copy_value(const BSSMAP__FIELD__CellIdentificationListEstablishment& other_value)
{
switch (other_value.union_selection) {
case ALT_cIl__CGI:
field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI(*other_value.field_cIl__CGI);
break;
case ALT_cIl__LAC__CI:
field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment(*other_value.field_cIl__LAC__CI);
break;
case ALT_cIl__CI:
field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment(*other_value.field_cIl__CI);
break;
case ALT_cIl__LAI:
field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI(*other_value.field_cIl__LAI);
break;
case ALT_cIl__LAC:
field_cIl__LAC = new RecordOfOCT2(*other_value.field_cIl__LAC);
break;
case ALT_cIl__allInBSS:
field_cIl__allInBSS = new OCTETSTRING(*other_value.field_cIl__allInBSS);
break;
case ALT_cIl__MCC__MNC:
field_cIl__MCC__MNC = new RecordOfOCT3(*other_value.field_cIl__MCC__MNC);
break;
default:
TTCN_error("Assignment of an unbound union value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
union_selection = other_value.union_selection;
}

BSSMAP__FIELD__CellIdentificationListEstablishment::BSSMAP__FIELD__CellIdentificationListEstablishment()
{
union_selection = UNBOUND_VALUE;
}

BSSMAP__FIELD__CellIdentificationListEstablishment::BSSMAP__FIELD__CellIdentificationListEstablishment(const BSSMAP__FIELD__CellIdentificationListEstablishment& other_value)
: Base_Type(){
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationListEstablishment::~BSSMAP__FIELD__CellIdentificationListEstablishment()
{
clean_up();
}

BSSMAP__FIELD__CellIdentificationListEstablishment& BSSMAP__FIELD__CellIdentificationListEstablishment::operator=(const BSSMAP__FIELD__CellIdentificationListEstablishment& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationListEstablishment::operator==(const BSSMAP__FIELD__CellIdentificationListEstablishment& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_cIl__CGI:
return *field_cIl__CGI == *other_value.field_cIl__CGI;
case ALT_cIl__LAC__CI:
return *field_cIl__LAC__CI == *other_value.field_cIl__LAC__CI;
case ALT_cIl__CI:
return *field_cIl__CI == *other_value.field_cIl__CI;
case ALT_cIl__LAI:
return *field_cIl__LAI == *other_value.field_cIl__LAI;
case ALT_cIl__LAC:
return *field_cIl__LAC == *other_value.field_cIl__LAC;
case ALT_cIl__allInBSS:
return *field_cIl__allInBSS == *other_value.field_cIl__allInBSS;
case ALT_cIl__MCC__MNC:
return *field_cIl__MCC__MNC == *other_value.field_cIl__MCC__MNC;
default:
return FALSE;
}
}

BSSMAP__FIELD__CellIdentificationList__CGI& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__CGI()
{
if (union_selection != ALT_cIl__CGI) {
clean_up();
field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI;
union_selection = ALT_cIl__CGI;
}
return *field_cIl__CGI;
}

const BSSMAP__FIELD__CellIdentificationList__CGI& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__CGI() const
{
if (union_selection != ALT_cIl__CGI) TTCN_error("Using non-selected field cIl_CGI in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *field_cIl__CGI;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__LAC__CI()
{
if (union_selection != ALT_cIl__LAC__CI) {
clean_up();
field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment;
union_selection = ALT_cIl__LAC__CI;
}
return *field_cIl__LAC__CI;
}

const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__LAC__CI() const
{
if (union_selection != ALT_cIl__LAC__CI) TTCN_error("Using non-selected field cIl_LAC_CI in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *field_cIl__LAC__CI;
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__CI()
{
if (union_selection != ALT_cIl__CI) {
clean_up();
field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment;
union_selection = ALT_cIl__CI;
}
return *field_cIl__CI;
}

const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__CI() const
{
if (union_selection != ALT_cIl__CI) TTCN_error("Using non-selected field cIl_CI in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *field_cIl__CI;
}

BSSMAP__FIELD__CellIdentificationList__LAI& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__LAI()
{
if (union_selection != ALT_cIl__LAI) {
clean_up();
field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI;
union_selection = ALT_cIl__LAI;
}
return *field_cIl__LAI;
}

const BSSMAP__FIELD__CellIdentificationList__LAI& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__LAI() const
{
if (union_selection != ALT_cIl__LAI) TTCN_error("Using non-selected field cIl_LAI in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *field_cIl__LAI;
}

RecordOfOCT2& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__LAC()
{
if (union_selection != ALT_cIl__LAC) {
clean_up();
field_cIl__LAC = new RecordOfOCT2;
union_selection = ALT_cIl__LAC;
}
return *field_cIl__LAC;
}

const RecordOfOCT2& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__LAC() const
{
if (union_selection != ALT_cIl__LAC) TTCN_error("Using non-selected field cIl_LAC in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *field_cIl__LAC;
}

OCTETSTRING& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__allInBSS()
{
if (union_selection != ALT_cIl__allInBSS) {
clean_up();
field_cIl__allInBSS = new OCTETSTRING;
union_selection = ALT_cIl__allInBSS;
}
return *field_cIl__allInBSS;
}

const OCTETSTRING& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__allInBSS() const
{
if (union_selection != ALT_cIl__allInBSS) TTCN_error("Using non-selected field cIl_allInBSS in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *field_cIl__allInBSS;
}

RecordOfOCT3& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__MCC__MNC()
{
if (union_selection != ALT_cIl__MCC__MNC) {
clean_up();
field_cIl__MCC__MNC = new RecordOfOCT3;
union_selection = ALT_cIl__MCC__MNC;
}
return *field_cIl__MCC__MNC;
}

const RecordOfOCT3& BSSMAP__FIELD__CellIdentificationListEstablishment::cIl__MCC__MNC() const
{
if (union_selection != ALT_cIl__MCC__MNC) TTCN_error("Using non-selected field cIl_MCC_MNC in a value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *field_cIl__MCC__MNC;
}

boolean BSSMAP__FIELD__CellIdentificationListEstablishment::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return union_selection == checked_selection;
}

boolean BSSMAP__FIELD__CellIdentificationListEstablishment::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean BSSMAP__FIELD__CellIdentificationListEstablishment::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_cIl__CGI: return field_cIl__CGI->is_value();
case ALT_cIl__LAC__CI: return field_cIl__LAC__CI->is_value();
case ALT_cIl__CI: return field_cIl__CI->is_value();
case ALT_cIl__LAI: return field_cIl__LAI->is_value();
case ALT_cIl__LAC: return field_cIl__LAC->is_value();
case ALT_cIl__allInBSS: return field_cIl__allInBSS->is_value();
case ALT_cIl__MCC__MNC: return field_cIl__MCC__MNC->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void BSSMAP__FIELD__CellIdentificationListEstablishment::clean_up()
{
switch (union_selection) {
case ALT_cIl__CGI:
  delete field_cIl__CGI;
  break;
case ALT_cIl__LAC__CI:
  delete field_cIl__LAC__CI;
  break;
case ALT_cIl__CI:
  delete field_cIl__CI;
  break;
case ALT_cIl__LAI:
  delete field_cIl__LAI;
  break;
case ALT_cIl__LAC:
  delete field_cIl__LAC;
  break;
case ALT_cIl__allInBSS:
  delete field_cIl__allInBSS;
  break;
case ALT_cIl__MCC__MNC:
  delete field_cIl__MCC__MNC;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void BSSMAP__FIELD__CellIdentificationListEstablishment::log() const
{
switch (union_selection) {
case ALT_cIl__CGI:
TTCN_Logger::log_event_str("{ cIl_CGI := ");
field_cIl__CGI->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__LAC__CI:
TTCN_Logger::log_event_str("{ cIl_LAC_CI := ");
field_cIl__LAC__CI->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__CI:
TTCN_Logger::log_event_str("{ cIl_CI := ");
field_cIl__CI->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__LAI:
TTCN_Logger::log_event_str("{ cIl_LAI := ");
field_cIl__LAI->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__LAC:
TTCN_Logger::log_event_str("{ cIl_LAC := ");
field_cIl__LAC->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__allInBSS:
TTCN_Logger::log_event_str("{ cIl_allInBSS := ");
field_cIl__allInBSS->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cIl__MCC__MNC:
TTCN_Logger::log_event_str("{ cIl_MCC_MNC := ");
field_cIl__MCC__MNC->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void BSSMAP__FIELD__CellIdentificationListEstablishment::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "cIl_CGI")) {
    cIl__CGI().set_param(*mp_last);
    if (!cIl__CGI().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_LAC_CI")) {
    cIl__LAC__CI().set_param(*mp_last);
    if (!cIl__LAC__CI().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_CI")) {
    cIl__CI().set_param(*mp_last);
    if (!cIl__CI().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_LAI")) {
    cIl__LAI().set_param(*mp_last);
    if (!cIl__LAI().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_LAC")) {
    cIl__LAC().set_param(*mp_last);
    if (!cIl__LAC().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_allInBSS")) {
    cIl__allInBSS().set_param(*mp_last);
    if (!cIl__allInBSS().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cIl_MCC_MNC")) {
    cIl__MCC__MNC().set_param(*mp_last);
    if (!cIl__MCC__MNC().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.", last_name);
}

void BSSMAP__FIELD__CellIdentificationListEstablishment::set_implicit_omit()
{
switch (union_selection) {
case ALT_cIl__CGI:
field_cIl__CGI->set_implicit_omit(); break;
case ALT_cIl__LAC__CI:
field_cIl__LAC__CI->set_implicit_omit(); break;
case ALT_cIl__CI:
field_cIl__CI->set_implicit_omit(); break;
case ALT_cIl__LAI:
field_cIl__LAI->set_implicit_omit(); break;
case ALT_cIl__LAC:
field_cIl__LAC->set_implicit_omit(); break;
case ALT_cIl__allInBSS:
field_cIl__allInBSS->set_implicit_omit(); break;
case ALT_cIl__MCC__MNC:
field_cIl__MCC__MNC->set_implicit_omit(); break;
default: break;
}
}

void BSSMAP__FIELD__CellIdentificationListEstablishment::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_cIl__CGI:
field_cIl__CGI->encode_text(text_buf);
break;
case ALT_cIl__LAC__CI:
field_cIl__LAC__CI->encode_text(text_buf);
break;
case ALT_cIl__CI:
field_cIl__CI->encode_text(text_buf);
break;
case ALT_cIl__LAI:
field_cIl__LAI->encode_text(text_buf);
break;
case ALT_cIl__LAC:
field_cIl__LAC->encode_text(text_buf);
break;
case ALT_cIl__allInBSS:
field_cIl__allInBSS->encode_text(text_buf);
break;
case ALT_cIl__MCC__MNC:
field_cIl__MCC__MNC->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
}

void BSSMAP__FIELD__CellIdentificationListEstablishment::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_cIl__CGI:
cIl__CGI().decode_text(text_buf);
break;
case ALT_cIl__LAC__CI:
cIl__LAC__CI().decode_text(text_buf);
break;
case ALT_cIl__CI:
cIl__CI().decode_text(text_buf);
break;
case ALT_cIl__LAI:
cIl__LAI().decode_text(text_buf);
break;
case ALT_cIl__LAC:
cIl__LAC().decode_text(text_buf);
break;
case ALT_cIl__allInBSS:
cIl__allInBSS().decode_text(text_buf);
break;
case ALT_cIl__MCC__MNC:
cIl__MCC__MNC().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
}

void BSSMAP__FIELD__CellIdentificationListEstablishment::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__CellIdentificationListEstablishment::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__CellIdentificationListEstablishment::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, BSSMAP__FIELD__CellIdentificationList__CGI_descr_.raw->forceomit);
      decoded_length = cIl__CGI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__CGI_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_.raw->forceomit);
      decoded_length = cIl__LAC__CI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_.raw->forceomit);
      decoded_length = cIl__CI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, BSSMAP__FIELD__CellIdentificationList__LAI_descr_.raw->forceomit);
      decoded_length = cIl__LAI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAI_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 4: {
      RAW_Force_Omit field_force_omit(4, force_omit, RecordOfOCT2_descr_.raw->forceomit);
      decoded_length = cIl__LAC().RAW_decode(RecordOfOCT2_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 5: {
      RAW_Force_Omit field_force_omit(5, force_omit, General__Types::OCT0_descr_.raw->forceomit);
      decoded_length = cIl__allInBSS().RAW_decode(General__Types::OCT0_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 6: {
      RAW_Force_Omit field_force_omit(6, force_omit, RecordOfOCT3_descr_.raw->forceomit);
      decoded_length = cIl__MCC__MNC().RAW_decode(RecordOfOCT3_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, BSSMAP__FIELD__CellIdentificationList__CGI_descr_.raw->forceomit);
      decoded_length = cIl__CGI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__CGI_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_.raw->forceomit);
      decoded_length = cIl__LAC__CI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_.raw->forceomit);
      decoded_length = cIl__CI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_3_force_omit(3, force_omit, BSSMAP__FIELD__CellIdentificationList__LAI_descr_.raw->forceomit);
      decoded_length = cIl__LAI().RAW_decode(BSSMAP__FIELD__CellIdentificationList__LAI_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_3_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_4_force_omit(4, force_omit, RecordOfOCT2_descr_.raw->forceomit);
      decoded_length = cIl__LAC().RAW_decode(RecordOfOCT2_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_4_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::OCT0_descr_.raw->forceomit);
      decoded_length = cIl__allInBSS().RAW_decode(General__Types::OCT0_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_5_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_6_force_omit(6, force_omit, RecordOfOCT3_descr_.raw->forceomit);
      decoded_length = cIl__MCC__MNC().RAW_decode(RecordOfOCT3_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_6_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int BSSMAP__FIELD__CellIdentificationListEstablishment::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 7;  myleaf.body.node.nodes = init_nodes_of_enc_tree(7);
  memset(myleaf.body.node.nodes, 0, 7 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_cIl__CGI:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, BSSMAP__FIELD__CellIdentificationList__CGI_descr_.raw);
    encoded_length = field_cIl__CGI->RAW_encode(BSSMAP__FIELD__CellIdentificationList__CGI_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &BSSMAP__FIELD__CellIdentificationList__CGI_descr_;
    break;
  case ALT_cIl__LAC__CI:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_.raw);
    encoded_length = field_cIl__LAC__CI->RAW_encode(BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_descr_;
    break;
  case ALT_cIl__CI:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_.raw);
    encoded_length = field_cIl__CI->RAW_encode(BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_descr_;
    break;
  case ALT_cIl__LAI:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, BSSMAP__FIELD__CellIdentificationList__LAI_descr_.raw);
    encoded_length = field_cIl__LAI->RAW_encode(BSSMAP__FIELD__CellIdentificationList__LAI_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &BSSMAP__FIELD__CellIdentificationList__LAI_descr_;
    break;
  case ALT_cIl__LAC:
    myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 4, RecordOfOCT2_descr_.raw);
    encoded_length = field_cIl__LAC->RAW_encode(RecordOfOCT2_descr_, *myleaf.body.node.nodes[4]);
    myleaf.body.node.nodes[4]->coding_descr = &RecordOfOCT2_descr_;
    break;
  case ALT_cIl__allInBSS:
    myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 5, General__Types::OCT0_descr_.raw);
    encoded_length = field_cIl__allInBSS->RAW_encode(General__Types::OCT0_descr_, *myleaf.body.node.nodes[5]);
    myleaf.body.node.nodes[5]->coding_descr = &General__Types::OCT0_descr_;
    break;
  case ALT_cIl__MCC__MNC:
    myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 6, RecordOfOCT3_descr_.raw);
    encoded_length = field_cIl__MCC__MNC->RAW_encode(RecordOfOCT3_descr_, *myleaf.body.node.nodes[6]);
    myleaf.body.node.nodes[6]->coding_descr = &RecordOfOCT3_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void BSSMAP__FIELD__CellIdentificationListEstablishment_template::copy_value(const BSSMAP__FIELD__CellIdentificationListEstablishment& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI:
single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template(other_value.cIl__CGI());
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(other_value.cIl__LAC__CI());
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI:
single_value.field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(other_value.cIl__CI());
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI:
single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template(other_value.cIl__LAI());
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC:
single_value.field_cIl__LAC = new RecordOfOCT2_template(other_value.cIl__LAC());
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS = new OCTETSTRING_template(other_value.cIl__allInBSS());
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC:
single_value.field_cIl__MCC__MNC = new RecordOfOCT3_template(other_value.cIl__MCC__MNC());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__CellIdentificationListEstablishment_template::copy_template(const BSSMAP__FIELD__CellIdentificationListEstablishment_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI:
single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template(*other_value.single_value.field_cIl__CGI);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(*other_value.single_value.field_cIl__LAC__CI);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI:
single_value.field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(*other_value.single_value.field_cIl__CI);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI:
single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template(*other_value.single_value.field_cIl__LAI);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC:
single_value.field_cIl__LAC = new RecordOfOCT2_template(*other_value.single_value.field_cIl__LAC);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS = new OCTETSTRING_template(*other_value.single_value.field_cIl__allInBSS);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC:
single_value.field_cIl__MCC__MNC = new RecordOfOCT3_template(*other_value.single_value.field_cIl__MCC__MNC);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationListEstablishment_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__CellIdentificationListEstablishment_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__CellIdentificationListEstablishment_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
set_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template::BSSMAP__FIELD__CellIdentificationListEstablishment_template()
{
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template::BSSMAP__FIELD__CellIdentificationListEstablishment_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template::BSSMAP__FIELD__CellIdentificationListEstablishment_template(const BSSMAP__FIELD__CellIdentificationListEstablishment& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template::BSSMAP__FIELD__CellIdentificationListEstablishment_template(const OPTIONAL<BSSMAP__FIELD__CellIdentificationListEstablishment>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationListEstablishment&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment from an unbound optional field.");
}
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template::BSSMAP__FIELD__CellIdentificationListEstablishment_template(BSSMAP__FIELD__CellIdentificationListEstablishment_template* p_precondition, BSSMAP__FIELD__CellIdentificationListEstablishment_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template::BSSMAP__FIELD__CellIdentificationListEstablishment_template(Dynamic_Match_Interface<BSSMAP__FIELD__CellIdentificationListEstablishment>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__CellIdentificationListEstablishment>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template::BSSMAP__FIELD__CellIdentificationListEstablishment_template(const BSSMAP__FIELD__CellIdentificationListEstablishment_template& other_value)
: Base_Template(){
copy_template(other_value);
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template::~BSSMAP__FIELD__CellIdentificationListEstablishment_template()
{
clean_up();
}

void BSSMAP__FIELD__CellIdentificationListEstablishment_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI:
delete single_value.field_cIl__CGI;
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI:
delete single_value.field_cIl__LAC__CI;
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI:
delete single_value.field_cIl__CI;
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI:
delete single_value.field_cIl__LAI;
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC:
delete single_value.field_cIl__LAC;
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS:
delete single_value.field_cIl__allInBSS;
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC:
delete single_value.field_cIl__MCC__MNC;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::operator=(const BSSMAP__FIELD__CellIdentificationListEstablishment& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::operator=(const OPTIONAL<BSSMAP__FIELD__CellIdentificationListEstablishment>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__CellIdentificationListEstablishment&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
return *this;
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::operator=(const BSSMAP__FIELD__CellIdentificationListEstablishment_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__FIELD__CellIdentificationListEstablishment_template::match(const BSSMAP__FIELD__CellIdentificationListEstablishment& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
BSSMAP__FIELD__CellIdentificationListEstablishment::union_selection_type value_selection = other_value.get_selection();
if (value_selection == BSSMAP__FIELD__CellIdentificationListEstablishment::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI:
return single_value.field_cIl__CGI->match(other_value.cIl__CGI(), legacy);
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI:
return single_value.field_cIl__LAC__CI->match(other_value.cIl__LAC__CI(), legacy);
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI:
return single_value.field_cIl__CI->match(other_value.cIl__CI(), legacy);
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI:
return single_value.field_cIl__LAI->match(other_value.cIl__LAI(), legacy);
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC:
return single_value.field_cIl__LAC->match(other_value.cIl__LAC(), legacy);
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS:
return single_value.field_cIl__allInBSS->match(other_value.cIl__allInBSS(), legacy);
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC:
return single_value.field_cIl__MCC__MNC->match(other_value.cIl__MCC__MNC(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
return FALSE;
}

boolean BSSMAP__FIELD__CellIdentificationListEstablishment_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI:
return single_value.field_cIl__CGI->is_value();
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI:
return single_value.field_cIl__LAC__CI->is_value();
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI:
return single_value.field_cIl__CI->is_value();
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI:
return single_value.field_cIl__LAI->is_value();
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC:
return single_value.field_cIl__LAC->is_value();
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS:
return single_value.field_cIl__allInBSS->is_value();
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC:
return single_value.field_cIl__MCC__MNC->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
}

BSSMAP__FIELD__CellIdentificationListEstablishment BSSMAP__FIELD__CellIdentificationListEstablishment_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
BSSMAP__FIELD__CellIdentificationListEstablishment ret_val;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI:
ret_val.cIl__CGI() = single_value.field_cIl__CGI->valueof();
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI:
ret_val.cIl__LAC__CI() = single_value.field_cIl__LAC__CI->valueof();
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI:
ret_val.cIl__CI() = single_value.field_cIl__CI->valueof();
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI:
ret_val.cIl__LAI() = single_value.field_cIl__LAI->valueof();
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC:
ret_val.cIl__LAC() = single_value.field_cIl__LAC->valueof();
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS:
ret_val.cIl__allInBSS() = single_value.field_cIl__allInBSS->valueof();
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC:
ret_val.cIl__MCC__MNC() = single_value.field_cIl__MCC__MNC->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
return ret_val;
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return value_list.list_value[list_index];
}
void BSSMAP__FIELD__CellIdentificationListEstablishment_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__CellIdentificationListEstablishment_template[list_length];
}

BSSMAP__FIELD__CellIdentificationList__CGI_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__CGI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template(ANY_VALUE);
else single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__CGI;
}

const BSSMAP__FIELD__CellIdentificationList__CGI_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__CGI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_CGI in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI) TTCN_error("Accessing non-selected field cIl_CGI in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *single_value.field_cIl__CGI;
}

BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__LAC__CI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template(ANY_VALUE);
else single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__LAC__CI;
}

const BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__LAC__CI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_LAC_CI in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI) TTCN_error("Accessing non-selected field cIl_LAC_CI in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *single_value.field_cIl__LAC__CI;
}

BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__CI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template(ANY_VALUE);
else single_value.field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__CI;
}

const BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__CI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_CI in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI) TTCN_error("Accessing non-selected field cIl_CI in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *single_value.field_cIl__CI;
}

BSSMAP__FIELD__CellIdentificationList__LAI_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__LAI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template(ANY_VALUE);
else single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__LAI;
}

const BSSMAP__FIELD__CellIdentificationList__LAI_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__LAI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_LAI in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI) TTCN_error("Accessing non-selected field cIl_LAI in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *single_value.field_cIl__LAI;
}

RecordOfOCT2_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__LAC()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__LAC = new RecordOfOCT2_template(ANY_VALUE);
else single_value.field_cIl__LAC = new RecordOfOCT2_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__LAC;
}

const RecordOfOCT2_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__LAC() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_LAC in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC) TTCN_error("Accessing non-selected field cIl_LAC in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *single_value.field_cIl__LAC;
}

OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__allInBSS()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__allInBSS = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_cIl__allInBSS = new OCTETSTRING_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__allInBSS;
}

const OCTETSTRING_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__allInBSS() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_allInBSS in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS) TTCN_error("Accessing non-selected field cIl_allInBSS in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *single_value.field_cIl__allInBSS;
}

RecordOfOCT3_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__MCC__MNC()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cIl__MCC__MNC = new RecordOfOCT3_template(ANY_VALUE);
else single_value.field_cIl__MCC__MNC = new RecordOfOCT3_template;
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cIl__MCC__MNC;
}

const RecordOfOCT3_template& BSSMAP__FIELD__CellIdentificationListEstablishment_template::cIl__MCC__MNC() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cIl_MCC_MNC in a non-specific template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
if (single_value.union_selection != BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC) TTCN_error("Accessing non-selected field cIl_MCC_MNC in a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return *single_value.field_cIl__MCC__MNC;
}

boolean BSSMAP__FIELD__CellIdentificationListEstablishment_template::ischosen(BSSMAP__FIELD__CellIdentificationListEstablishment::union_selection_type checked_selection) const
{
if (checked_selection == BSSMAP__FIELD__CellIdentificationListEstablishment::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == BSSMAP__FIELD__CellIdentificationListEstablishment::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationListEstablishment_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI:
TTCN_Logger::log_event_str("{ cIl_CGI := ");
single_value.field_cIl__CGI->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI:
TTCN_Logger::log_event_str("{ cIl_LAC_CI := ");
single_value.field_cIl__LAC__CI->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI:
TTCN_Logger::log_event_str("{ cIl_CI := ");
single_value.field_cIl__CI->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI:
TTCN_Logger::log_event_str("{ cIl_LAI := ");
single_value.field_cIl__LAI->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC:
TTCN_Logger::log_event_str("{ cIl_LAC := ");
single_value.field_cIl__LAC->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS:
TTCN_Logger::log_event_str("{ cIl_allInBSS := ");
single_value.field_cIl__allInBSS->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC:
TTCN_Logger::log_event_str("{ cIl_MCC_MNC := ");
single_value.field_cIl__MCC__MNC->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationListEstablishment_template::log_match(const BSSMAP__FIELD__CellIdentificationListEstablishment& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_CGI");
single_value.field_cIl__CGI->log_match(match_value.cIl__CGI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_CGI := ");
single_value.field_cIl__CGI->log_match(match_value.cIl__CGI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_LAC_CI");
single_value.field_cIl__LAC__CI->log_match(match_value.cIl__LAC__CI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_LAC_CI := ");
single_value.field_cIl__LAC__CI->log_match(match_value.cIl__LAC__CI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_CI");
single_value.field_cIl__CI->log_match(match_value.cIl__CI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_CI := ");
single_value.field_cIl__CI->log_match(match_value.cIl__CI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_LAI");
single_value.field_cIl__LAI->log_match(match_value.cIl__LAI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_LAI := ");
single_value.field_cIl__LAI->log_match(match_value.cIl__LAI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_LAC");
single_value.field_cIl__LAC->log_match(match_value.cIl__LAC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_LAC := ");
single_value.field_cIl__LAC->log_match(match_value.cIl__LAC(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_allInBSS");
single_value.field_cIl__allInBSS->log_match(match_value.cIl__allInBSS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_allInBSS := ");
single_value.field_cIl__allInBSS->log_match(match_value.cIl__allInBSS(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cIl_MCC_MNC");
single_value.field_cIl__MCC__MNC->log_match(match_value.cIl__MCC__MNC(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cIl_MCC_MNC := ");
single_value.field_cIl__MCC__MNC->log_match(match_value.cIl__MCC__MNC(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__CellIdentificationListEstablishment_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI:
single_value.field_cIl__CGI->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI:
single_value.field_cIl__CI->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI:
single_value.field_cIl__LAI->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC:
single_value.field_cIl__LAC->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS->set_implicit_omit(); break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC:
single_value.field_cIl__MCC__MNC->set_implicit_omit(); break;
default: break;
}
}

void BSSMAP__FIELD__CellIdentificationListEstablishment_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI:
single_value.field_cIl__CGI->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI:
single_value.field_cIl__CI->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI:
single_value.field_cIl__LAI->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC:
single_value.field_cIl__LAC->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS->encode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC:
single_value.field_cIl__MCC__MNC->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
}

void BSSMAP__FIELD__CellIdentificationListEstablishment_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = BSSMAP__FIELD__CellIdentificationListEstablishment::UNBOUND_VALUE;
BSSMAP__FIELD__CellIdentificationListEstablishment::union_selection_type new_selection = (BSSMAP__FIELD__CellIdentificationListEstablishment::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI:
single_value.field_cIl__CGI = new BSSMAP__FIELD__CellIdentificationList__CGI_template;
single_value.field_cIl__CGI->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI = new BSSMAP__FIELD__CellIdentificationList__LAC__CI__Segment_template;
single_value.field_cIl__LAC__CI->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI:
single_value.field_cIl__CI = new BSSMAP__FIELD__CellIdentificationList__CIL__CI__Segment_template;
single_value.field_cIl__CI->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI:
single_value.field_cIl__LAI = new BSSMAP__FIELD__CellIdentificationList__LAI_template;
single_value.field_cIl__LAI->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC:
single_value.field_cIl__LAC = new RecordOfOCT2_template;
single_value.field_cIl__LAC->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS = new OCTETSTRING_template;
single_value.field_cIl__allInBSS->decode_text(text_buf);
break;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC:
single_value.field_cIl__MCC__MNC = new RecordOfOCT3_template;
single_value.field_cIl__MCC__MNC->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__CellIdentificationListEstablishment_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
}

boolean BSSMAP__FIELD__CellIdentificationListEstablishment_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__CellIdentificationListEstablishment_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__CellIdentificationListEstablishment_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment'");
    }
    if (strcmp("cIl_CGI", param_field) == 0) {
      cIl__CGI().set_param(param);
      return;
    } else if (strcmp("cIl_LAC_CI", param_field) == 0) {
      cIl__LAC__CI().set_param(param);
      return;
    } else if (strcmp("cIl_CI", param_field) == 0) {
      cIl__CI().set_param(param);
      return;
    } else if (strcmp("cIl_LAI", param_field) == 0) {
      cIl__LAI().set_param(param);
      return;
    } else if (strcmp("cIl_LAC", param_field) == 0) {
      cIl__LAC().set_param(param);
      return;
    } else if (strcmp("cIl_allInBSS", param_field) == 0) {
      cIl__allInBSS().set_param(param);
      return;
    } else if (strcmp("cIl_MCC_MNC", param_field) == 0) {
      cIl__MCC__MNC().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__CellIdentificationListEstablishment_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "cIl_CGI")) {
      cIl__CGI().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_LAC_CI")) {
      cIl__LAC__CI().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_CI")) {
      cIl__CI().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_LAI")) {
      cIl__LAI().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_LAC")) {
      cIl__LAC().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_allInBSS")) {
      cIl__allInBSS().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cIl_MCC_MNC")) {
      cIl__MCC__MNC().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__CellIdentificationListEstablishment_template* precondition = new BSSMAP__FIELD__CellIdentificationListEstablishment_template;
    precondition->set_param(*m_p->get_elem(0));
    BSSMAP__FIELD__CellIdentificationListEstablishment_template* implied_template = new BSSMAP__FIELD__CellIdentificationListEstablishment_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = BSSMAP__FIELD__CellIdentificationListEstablishment_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__FIELD__CellIdentificationListEstablishment_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI:
single_value.field_cIl__CGI->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment");
return;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI:
single_value.field_cIl__LAC__CI->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment");
return;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI:
single_value.field_cIl__CI->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment");
return;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI:
single_value.field_cIl__LAI->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment");
return;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC:
single_value.field_cIl__LAC->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment");
return;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS:
single_value.field_cIl__allInBSS->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment");
return;
case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC:
single_value.field_cIl__MCC__MNC->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_CellIdentificationListEstablishment");
}

BSSMAP__IE__CellIdentifierListSegmentEstCells::BSSMAP__IE__CellIdentifierListSegmentEstCells()
{
}

BSSMAP__IE__CellIdentifierListSegmentEstCells::BSSMAP__IE__CellIdentifierListSegmentEstCells(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_cellIdentifierDiscriminator,
    const BITSTRING& par_spare1__4,
    const BSSMAP__FIELD__CellIdentificationListEstablishment& par_cellIdentificationListEstCells)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_cellIdentifierDiscriminator(par_cellIdentifierDiscriminator),
  field_spare1__4(par_spare1__4),
  field_cellIdentificationListEstCells(par_cellIdentificationListEstCells)
{
}

BSSMAP__IE__CellIdentifierListSegmentEstCells::BSSMAP__IE__CellIdentifierListSegmentEstCells(const BSSMAP__IE__CellIdentifierListSegmentEstCells& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.cellIdentifierDiscriminator().is_bound()) field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
else field_cellIdentifierDiscriminator.clean_up();
if (other_value.spare1__4().is_bound()) field_spare1__4 = other_value.spare1__4();
else field_spare1__4.clean_up();
if (other_value.cellIdentificationListEstCells().is_bound()) field_cellIdentificationListEstCells = other_value.cellIdentificationListEstCells();
else field_cellIdentificationListEstCells.clean_up();
}

void BSSMAP__IE__CellIdentifierListSegmentEstCells::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_cellIdentifierDiscriminator.clean_up();
field_spare1__4.clean_up();
field_cellIdentificationListEstCells.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__CellIdentifierListSegmentEstCells::get_descriptor() const { return &BSSMAP__IE__CellIdentifierListSegmentEstCells_descr_; }
BSSMAP__IE__CellIdentifierListSegmentEstCells& BSSMAP__IE__CellIdentifierListSegmentEstCells::operator=(const BSSMAP__IE__CellIdentifierListSegmentEstCells& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.cellIdentifierDiscriminator().is_bound()) field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
  else field_cellIdentifierDiscriminator.clean_up();
  if (other_value.spare1__4().is_bound()) field_spare1__4 = other_value.spare1__4();
  else field_spare1__4.clean_up();
  if (other_value.cellIdentificationListEstCells().is_bound()) field_cellIdentificationListEstCells = other_value.cellIdentificationListEstCells();
  else field_cellIdentificationListEstCells.clean_up();
}
return *this;
}

boolean BSSMAP__IE__CellIdentifierListSegmentEstCells::operator==(const BSSMAP__IE__CellIdentifierListSegmentEstCells& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_cellIdentifierDiscriminator==other_value.field_cellIdentifierDiscriminator
  && field_spare1__4==other_value.field_spare1__4
  && field_cellIdentificationListEstCells==other_value.field_cellIdentificationListEstCells;
}

boolean BSSMAP__IE__CellIdentifierListSegmentEstCells::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_cellIdentifierDiscriminator.is_bound())
  || (field_spare1__4.is_bound())
  || (field_cellIdentificationListEstCells.is_bound());
}
boolean BSSMAP__IE__CellIdentifierListSegmentEstCells::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_cellIdentifierDiscriminator.is_value()
  && field_spare1__4.is_value()
  && field_cellIdentificationListEstCells.is_value();
}
void BSSMAP__IE__CellIdentifierListSegmentEstCells::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", cellIdentifierDiscriminator := ");
field_cellIdentifierDiscriminator.log();
TTCN_Logger::log_event_str(", spare1_4 := ");
field_spare1__4.log();
TTCN_Logger::log_event_str(", cellIdentificationListEstCells := ");
field_cellIdentificationListEstCells.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__CellIdentifierListSegmentEstCells::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (cellIdentifierDiscriminator().is_bound()) cellIdentifierDiscriminator().set_implicit_omit();
if (spare1__4().is_bound()) spare1__4().set_implicit_omit();
if (cellIdentificationListEstCells().is_bound()) cellIdentificationListEstCells().set_implicit_omit();
}

void BSSMAP__IE__CellIdentifierListSegmentEstCells::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cellIdentifierDiscriminator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare1__4().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) cellIdentificationListEstCells().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifierDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifierDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare1_4")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare1__4().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentificationListEstCells")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentificationListEstCells().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells");
  }
}

void BSSMAP__IE__CellIdentifierListSegmentEstCells::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_cellIdentifierDiscriminator.encode_text(text_buf);
field_spare1__4.encode_text(text_buf);
field_cellIdentificationListEstCells.encode_text(text_buf);
}

void BSSMAP__IE__CellIdentifierListSegmentEstCells::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_cellIdentifierDiscriminator.decode_text(text_buf);
field_spare1__4.decode_text(text_buf);
field_cellIdentificationListEstCells.decode_text(text_buf);
}

void BSSMAP__IE__CellIdentifierListSegmentEstCells::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__CellIdentifierListSegmentEstCells::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__CellIdentifierListSegmentEstCells::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__CellIdentifierListSegmentEstCells_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__CellIdentifierListSegmentEstCells_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__CellIdentifierListSegmentEstCells_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentifierDiscriminator.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare1__4.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_cellIdentifierDiscriminator ==  bs_0) selected_field = 0;
  else if (field_cellIdentifierDiscriminator ==  bs_1) selected_field = 1;
  else if (field_cellIdentifierDiscriminator ==  bs_2) selected_field = 2;
  else if (field_cellIdentifierDiscriminator ==  bs_10) selected_field = 3;
  else if (field_cellIdentifierDiscriminator ==  bs_11) selected_field = 4;
  else if (field_cellIdentifierDiscriminator ==  bs_12) selected_field = 5;
  else if (field_cellIdentifierDiscriminator ==  bs_13) selected_field = 6;
  else selected_field = -1;
  RAW_Force_Omit field_4_force_omit(4, force_omit, BSSMAP__IE__CellIdentifierListSegmentEstCells_cellIdentificationListEstCells_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentificationListEstCells.RAW_decode(BSSMAP__IE__CellIdentifierListSegmentEstCells_cellIdentificationListEstCells_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, selected_field, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_122) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__CellIdentifierListSegmentEstCells::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__CellIdentifierListSegmentEstCells_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BSSMAP__IE__CellIdentifierListSegmentEstCells_cellIdentificationListEstCells_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__CellIdentifierListSegmentEstCells_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_cellIdentifierDiscriminator.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_spare1__4.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_cellIdentificationListEstCells.RAW_encode(BSSMAP__IE__CellIdentifierListSegmentEstCells_cellIdentificationListEstCells_descr_, *myleaf.body.node.nodes[4]);
  switch (field_cellIdentificationListEstCells.get_selection()) {
  case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CGI:
  if (field_cellIdentifierDiscriminator !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC__CI:
  if (field_cellIdentifierDiscriminator !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__CI:
  if (field_cellIdentifierDiscriminator !=  bs_2) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_2.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAI:
  if (field_cellIdentifierDiscriminator !=  bs_10) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_10.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__LAC:
  if (field_cellIdentifierDiscriminator !=  bs_11) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_11.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__allInBSS:
  if (field_cellIdentifierDiscriminator !=  bs_12) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_12.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAP__FIELD__CellIdentificationListEstablishment::ALT_cIl__MCC__MNC:
  if (field_cellIdentifierDiscriminator !=  bs_13) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_13.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_elementIdentifier !=  os_122) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_122.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__CellIdentifierListSegmentEstCells_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_cellIdentifierDiscriminator;
BITSTRING_template field_spare1__4;
BSSMAP__FIELD__CellIdentificationListEstablishment_template field_cellIdentificationListEstCells;
};

void BSSMAP__IE__CellIdentifierListSegmentEstCells_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_cellIdentifierDiscriminator = ANY_VALUE;
single_value->field_spare1__4 = ANY_VALUE;
single_value->field_cellIdentificationListEstCells = ANY_VALUE;
}
}
}

void BSSMAP__IE__CellIdentifierListSegmentEstCells_template::copy_value(const BSSMAP__IE__CellIdentifierListSegmentEstCells& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.cellIdentifierDiscriminator().is_bound()) {
  single_value->field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
} else {
  single_value->field_cellIdentifierDiscriminator.clean_up();
}
if (other_value.spare1__4().is_bound()) {
  single_value->field_spare1__4 = other_value.spare1__4();
} else {
  single_value->field_spare1__4.clean_up();
}
if (other_value.cellIdentificationListEstCells().is_bound()) {
  single_value->field_cellIdentificationListEstCells = other_value.cellIdentificationListEstCells();
} else {
  single_value->field_cellIdentificationListEstCells.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__CellIdentifierListSegmentEstCells_template::copy_template(const BSSMAP__IE__CellIdentifierListSegmentEstCells_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentifierDiscriminator().get_selection()) {
single_value->field_cellIdentifierDiscriminator = other_value.cellIdentifierDiscriminator();
} else {
single_value->field_cellIdentifierDiscriminator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare1__4().get_selection()) {
single_value->field_spare1__4 = other_value.spare1__4();
} else {
single_value->field_spare1__4.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentificationListEstCells().get_selection()) {
single_value->field_cellIdentificationListEstCells = other_value.cellIdentificationListEstCells();
} else {
single_value->field_cellIdentificationListEstCells.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__CellIdentifierListSegmentEstCells_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__CellIdentifierListSegmentEstCells_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__CellIdentifierListSegmentEstCells_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__CellIdentifierListSegmentEstCells_template::BSSMAP__IE__CellIdentifierListSegmentEstCells_template()
{
}

BSSMAP__IE__CellIdentifierListSegmentEstCells_template::BSSMAP__IE__CellIdentifierListSegmentEstCells_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__CellIdentifierListSegmentEstCells_template::BSSMAP__IE__CellIdentifierListSegmentEstCells_template(const BSSMAP__IE__CellIdentifierListSegmentEstCells& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__CellIdentifierListSegmentEstCells_template::BSSMAP__IE__CellIdentifierListSegmentEstCells_template(const OPTIONAL<BSSMAP__IE__CellIdentifierListSegmentEstCells>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CellIdentifierListSegmentEstCells&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells from an unbound optional field.");
}
}

BSSMAP__IE__CellIdentifierListSegmentEstCells_template::BSSMAP__IE__CellIdentifierListSegmentEstCells_template(BSSMAP__IE__CellIdentifierListSegmentEstCells_template* p_precondition, BSSMAP__IE__CellIdentifierListSegmentEstCells_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__CellIdentifierListSegmentEstCells_template::BSSMAP__IE__CellIdentifierListSegmentEstCells_template(Dynamic_Match_Interface<BSSMAP__IE__CellIdentifierListSegmentEstCells>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__CellIdentifierListSegmentEstCells>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__CellIdentifierListSegmentEstCells_template::BSSMAP__IE__CellIdentifierListSegmentEstCells_template(const BSSMAP__IE__CellIdentifierListSegmentEstCells_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__CellIdentifierListSegmentEstCells_template::~BSSMAP__IE__CellIdentifierListSegmentEstCells_template()
{
clean_up();
}

BSSMAP__IE__CellIdentifierListSegmentEstCells_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__CellIdentifierListSegmentEstCells_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::operator=(const BSSMAP__IE__CellIdentifierListSegmentEstCells& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__CellIdentifierListSegmentEstCells_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::operator=(const OPTIONAL<BSSMAP__IE__CellIdentifierListSegmentEstCells>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CellIdentifierListSegmentEstCells&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
}
return *this;
}

BSSMAP__IE__CellIdentifierListSegmentEstCells_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::operator=(const BSSMAP__IE__CellIdentifierListSegmentEstCells_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__CellIdentifierListSegmentEstCells_template::match(const BSSMAP__IE__CellIdentifierListSegmentEstCells& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.cellIdentifierDiscriminator().is_bound()) return FALSE;
if(!single_value->field_cellIdentifierDiscriminator.match(other_value.cellIdentifierDiscriminator(), legacy))return FALSE;
if(!other_value.spare1__4().is_bound()) return FALSE;
if(!single_value->field_spare1__4.match(other_value.spare1__4(), legacy))return FALSE;
if(!other_value.cellIdentificationListEstCells().is_bound()) return FALSE;
if(!single_value->field_cellIdentificationListEstCells.match(other_value.cellIdentificationListEstCells(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
}
return FALSE;
}

boolean BSSMAP__IE__CellIdentifierListSegmentEstCells_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_cellIdentifierDiscriminator.is_bound()
 || single_value->field_spare1__4.is_bound()
 || single_value->field_cellIdentificationListEstCells.is_bound();
}

boolean BSSMAP__IE__CellIdentifierListSegmentEstCells_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_cellIdentifierDiscriminator.is_value()
 && single_value->field_spare1__4.is_value()
 && single_value->field_cellIdentificationListEstCells.is_value();
}

void BSSMAP__IE__CellIdentifierListSegmentEstCells_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__CellIdentifierListSegmentEstCells BSSMAP__IE__CellIdentifierListSegmentEstCells_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
BSSMAP__IE__CellIdentifierListSegmentEstCells ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_cellIdentifierDiscriminator.is_bound()) {
ret_val.cellIdentifierDiscriminator() = single_value->field_cellIdentifierDiscriminator.valueof();
}
if (single_value->field_spare1__4.is_bound()) {
ret_val.spare1__4() = single_value->field_spare1__4.valueof();
}
if (single_value->field_cellIdentificationListEstCells.is_bound()) {
ret_val.cellIdentificationListEstCells() = single_value->field_cellIdentificationListEstCells.valueof();
}
return ret_val;
}

void BSSMAP__IE__CellIdentifierListSegmentEstCells_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__CellIdentifierListSegmentEstCells_template[list_length];
}

BSSMAP__IE__CellIdentifierListSegmentEstCells_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::cellIdentifierDiscriminator()
{
set_specific();
return single_value->field_cellIdentifierDiscriminator;
}

const BITSTRING_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::cellIdentifierDiscriminator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentifierDiscriminator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
return single_value->field_cellIdentifierDiscriminator;
}

BITSTRING_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::spare1__4()
{
set_specific();
return single_value->field_spare1__4;
}

const BITSTRING_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::spare1__4() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare1_4 of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
return single_value->field_spare1__4;
}

BSSMAP__FIELD__CellIdentificationListEstablishment_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::cellIdentificationListEstCells()
{
set_specific();
return single_value->field_cellIdentificationListEstCells;
}

const BSSMAP__FIELD__CellIdentificationListEstablishment_template& BSSMAP__IE__CellIdentifierListSegmentEstCells_template::cellIdentificationListEstCells() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentificationListEstCells of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
return single_value->field_cellIdentificationListEstCells;
}

int BSSMAP__IE__CellIdentifierListSegmentEstCells_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CellIdentifierListSegmentEstCells.");
  }
  return 0;
}

void BSSMAP__IE__CellIdentifierListSegmentEstCells_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", cellIdentifierDiscriminator := ");
single_value->field_cellIdentifierDiscriminator.log();
TTCN_Logger::log_event_str(", spare1_4 := ");
single_value->field_spare1__4.log();
TTCN_Logger::log_event_str(", cellIdentificationListEstCells := ");
single_value->field_cellIdentificationListEstCells.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__CellIdentifierListSegmentEstCells_template::log_match(const BSSMAP__IE__CellIdentifierListSegmentEstCells& match_valu