// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "MobileL3_GMM_SM_Types.hh"

namespace MobileL3__GMM__SM__Types {

/* Member functions of C++ classes */

QoSLV::QoSLV()
{
}

QoSLV::QoSLV(const INTEGER& par_lengthIndicator,
    const QoSV& par_qoSV)
  :   field_lengthIndicator(par_lengthIndicator),
  field_qoSV(par_qoSV)
{
}

QoSLV::QoSLV(const QoSLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.QoSLV.");
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.qoSV().is_bound()) field_qoSV = other_value.qoSV();
else field_qoSV.clean_up();
}

void QoSLV::clean_up()
{
field_lengthIndicator.clean_up();
field_qoSV.clean_up();
}

const TTCN_Typedescriptor_t* QoSLV::get_descriptor() const { return &QoSLV_descr_; }
QoSLV& QoSLV::operator=(const QoSLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.QoSLV.");
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.qoSV().is_bound()) field_qoSV = other_value.qoSV();
  else field_qoSV.clean_up();
}
return *this;
}

boolean QoSLV::operator==(const QoSLV& other_value) const
{
return field_lengthIndicator==other_value.field_lengthIndicator
  && field_qoSV==other_value.field_qoSV;
}

boolean QoSLV::is_bound() const
{
return (field_lengthIndicator.is_bound())
  || (field_qoSV.is_bound());
}
boolean QoSLV::is_value() const
{
return field_lengthIndicator.is_value()
  && field_qoSV.is_value();
}
void QoSLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", qoSV := ");
field_qoSV.log();
TTCN_Logger::log_event_str(" }");
}

void QoSLV::set_implicit_omit()
{
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (qoSV().is_bound()) qoSV().set_implicit_omit();
}

void QoSLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.QoSLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) qoSV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qoSV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qoSV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.QoSLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.QoSLV");
  }
}

void QoSLV::encode_text(Text_Buf& text_buf) const
{
field_lengthIndicator.encode_text(text_buf);
field_qoSV.encode_text(text_buf);
}

void QoSLV::decode_text(Text_Buf& text_buf)
{
field_lengthIndicator.decode_text(text_buf);
field_qoSV.decode_text(text_buf);
}

void QoSLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void QoSLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int QoSLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, QoSLV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(QoSLV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_lengthIndicator.convert_to_Integer(QoSLV_lengthIndicator_descr_);
  field_lengthIndicator = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, QoSV_descr_.raw->forceomit);
  decoded_field_length = field_qoSV.RAW_decode(QoSV_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int QoSLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, QoSLV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, QoSV_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &QoSLV_lengthIndicator_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_qoSV.RAW_encode(QoSV_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct QoSLV_template::single_value_struct {
INTEGER_template field_lengthIndicator;
QoSV_template field_qoSV;
};

void QoSLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_qoSV = ANY_VALUE;
}
}
}

void QoSLV_template::copy_value(const QoSLV& other_value)
{
single_value = new single_value_struct;
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.qoSV().is_bound()) {
  single_value->field_qoSV = other_value.qoSV();
} else {
  single_value->field_qoSV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void QoSLV_template::copy_template(const QoSLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.qoSV().get_selection()) {
single_value->field_qoSV = other_value.qoSV();
} else {
single_value->field_qoSV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new QoSLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new QoSLV_template(*other_value.implication_.precondition);
implication_.implied_template = new QoSLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSLV.");
break;
}
set_selection(other_value);
}

QoSLV_template::QoSLV_template()
{
}

QoSLV_template::QoSLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

QoSLV_template::QoSLV_template(const QoSLV& other_value)
{
copy_value(other_value);
}

QoSLV_template::QoSLV_template(const OPTIONAL<QoSLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const QoSLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.QoSLV from an unbound optional field.");
}
}

QoSLV_template::QoSLV_template(QoSLV_template* p_precondition, QoSLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

QoSLV_template::QoSLV_template(Dynamic_Match_Interface<QoSLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<QoSLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

QoSLV_template::QoSLV_template(const QoSLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

QoSLV_template::~QoSLV_template()
{
clean_up();
}

QoSLV_template& QoSLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

QoSLV_template& QoSLV_template::operator=(const QoSLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

QoSLV_template& QoSLV_template::operator=(const OPTIONAL<QoSLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const QoSLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.QoSLV.");
}
return *this;
}

QoSLV_template& QoSLV_template::operator=(const QoSLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean QoSLV_template::match(const QoSLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.qoSV().is_bound()) return FALSE;
if(!single_value->field_qoSV.match(other_value.qoSV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSLV.");
}
return FALSE;
}

boolean QoSLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lengthIndicator.is_bound()
 || single_value->field_qoSV.is_bound();
}

boolean QoSLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lengthIndicator.is_value()
 && single_value->field_qoSV.is_value();
}

void QoSLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

QoSLV QoSLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.QoSLV.");
QoSLV ret_val;
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_qoSV.is_bound()) {
ret_val.qoSV() = single_value->field_qoSV.valueof();
}
return ret_val;
}

void QoSLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.QoSLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new QoSLV_template[list_length];
}

QoSLV_template& QoSLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.QoSLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.QoSLV.");
return value_list.list_value[list_index];
}

INTEGER_template& QoSLV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& QoSLV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.QoSLV.");
return single_value->field_lengthIndicator;
}

QoSV_template& QoSLV_template::qoSV()
{
set_specific();
return single_value->field_qoSV;
}

const QoSV_template& QoSLV_template::qoSV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field qoSV of a non-specific template of type @MobileL3_GMM_SM_Types.QoSLV.");
return single_value->field_qoSV;
}

int QoSLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSLV.");
  }
  return 0;
}

void QoSLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", qoSV := ");
single_value->field_qoSV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void QoSLV_template::log_match(const QoSLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_qoSV.match(match_value.qoSV(), legacy)){
TTCN_Logger::log_logmatch_info(".qoSV");
single_value->field_qoSV.log_match(match_value.qoSV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", qoSV := ");
single_value->field_qoSV.log_match(match_value.qoSV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void QoSLV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (qoSV().is_bound()) qoSV().set_implicit_omit();
}

void QoSLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_qoSV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSLV.");
}
}

void QoSLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_qoSV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new QoSLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.QoSLV.");
}
}

void QoSLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    QoSLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.QoSLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) qoSV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qoSV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qoSV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.QoSLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    QoSLV_template* precondition = new QoSLV_template;
    precondition->set_param(*param.get_elem(0));
    QoSLV_template* implied_template = new QoSLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = QoSLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.QoSLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void QoSLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSLV");
single_value->field_qoSV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSLV");
}

boolean QoSLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean QoSLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

QoSTLV::QoSTLV()
{
}

QoSTLV::QoSTLV(const OCTETSTRING& par_elementIdentifier,
    const QoSLV& par_qoSLV)
  :   field_elementIdentifier(par_elementIdentifier),
  field_qoSLV(par_qoSLV)
{
}

QoSTLV::QoSTLV(const QoSTLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.QoSTLV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.qoSLV().is_bound()) field_qoSLV = other_value.qoSLV();
else field_qoSLV.clean_up();
}

void QoSTLV::clean_up()
{
field_elementIdentifier.clean_up();
field_qoSLV.clean_up();
}

const TTCN_Typedescriptor_t* QoSTLV::get_descriptor() const { return &QoSTLV_descr_; }
QoSTLV& QoSTLV::operator=(const QoSTLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.QoSTLV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.qoSLV().is_bound()) field_qoSLV = other_value.qoSLV();
  else field_qoSLV.clean_up();
}
return *this;
}

boolean QoSTLV::operator==(const QoSTLV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_qoSLV==other_value.field_qoSLV;
}

boolean QoSTLV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_qoSLV.is_bound());
}
boolean QoSTLV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_qoSLV.is_value();
}
void QoSTLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", qoSLV := ");
field_qoSLV.log();
TTCN_Logger::log_event_str(" }");
}

void QoSTLV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (qoSLV().is_bound()) qoSLV().set_implicit_omit();
}

void QoSTLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.QoSTLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) qoSLV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qoSLV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qoSLV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.QoSTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.QoSTLV");
  }
}

void QoSTLV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_qoSLV.encode_text(text_buf);
}

void QoSTLV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_qoSLV.decode_text(text_buf);
}

void QoSTLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void QoSTLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int QoSTLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, QoSLV_descr_.raw->forceomit);
  decoded_field_length = field_qoSLV.RAW_decode(QoSLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_15) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int QoSTLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, QoSLV_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_qoSLV.RAW_encode(QoSLV_descr_, *myleaf.body.node.nodes[1]);
  if (field_elementIdentifier !=  os_15) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_15.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct QoSTLV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
QoSLV_template field_qoSLV;
};

void QoSTLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_qoSLV = ANY_VALUE;
}
}
}

void QoSTLV_template::copy_value(const QoSTLV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.qoSLV().is_bound()) {
  single_value->field_qoSLV = other_value.qoSLV();
} else {
  single_value->field_qoSLV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void QoSTLV_template::copy_template(const QoSTLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.qoSLV().get_selection()) {
single_value->field_qoSLV = other_value.qoSLV();
} else {
single_value->field_qoSLV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new QoSTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new QoSTLV_template(*other_value.implication_.precondition);
implication_.implied_template = new QoSTLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSTLV.");
break;
}
set_selection(other_value);
}

QoSTLV_template::QoSTLV_template()
{
}

QoSTLV_template::QoSTLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

QoSTLV_template::QoSTLV_template(const QoSTLV& other_value)
{
copy_value(other_value);
}

QoSTLV_template::QoSTLV_template(const OPTIONAL<QoSTLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const QoSTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.QoSTLV from an unbound optional field.");
}
}

QoSTLV_template::QoSTLV_template(QoSTLV_template* p_precondition, QoSTLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

QoSTLV_template::QoSTLV_template(Dynamic_Match_Interface<QoSTLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<QoSTLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

QoSTLV_template::QoSTLV_template(const QoSTLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

QoSTLV_template::~QoSTLV_template()
{
clean_up();
}

QoSTLV_template& QoSTLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

QoSTLV_template& QoSTLV_template::operator=(const QoSTLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

QoSTLV_template& QoSTLV_template::operator=(const OPTIONAL<QoSTLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const QoSTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.QoSTLV.");
}
return *this;
}

QoSTLV_template& QoSTLV_template::operator=(const QoSTLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean QoSTLV_template::match(const QoSTLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.qoSLV().is_bound()) return FALSE;
if(!single_value->field_qoSLV.match(other_value.qoSLV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSTLV.");
}
return FALSE;
}

boolean QoSTLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_qoSLV.is_bound();
}

boolean QoSTLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_qoSLV.is_value();
}

void QoSTLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

QoSTLV QoSTLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.QoSTLV.");
QoSTLV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_qoSLV.is_bound()) {
ret_val.qoSLV() = single_value->field_qoSLV.valueof();
}
return ret_val;
}

void QoSTLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.QoSTLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new QoSTLV_template[list_length];
}

QoSTLV_template& QoSTLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.QoSTLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.QoSTLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& QoSTLV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& QoSTLV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.QoSTLV.");
return single_value->field_elementIdentifier;
}

QoSLV_template& QoSTLV_template::qoSLV()
{
set_specific();
return single_value->field_qoSLV;
}

const QoSLV_template& QoSTLV_template::qoSLV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field qoSLV of a non-specific template of type @MobileL3_GMM_SM_Types.QoSTLV.");
return single_value->field_qoSLV;
}

int QoSTLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSTLV.");
  }
  return 0;
}

void QoSTLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", qoSLV := ");
single_value->field_qoSLV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void QoSTLV_template::log_match(const QoSTLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_qoSLV.match(match_value.qoSLV(), legacy)){
TTCN_Logger::log_logmatch_info(".qoSLV");
single_value->field_qoSLV.log_match(match_value.qoSLV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", qoSLV := ");
single_value->field_qoSLV.log_match(match_value.qoSLV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void QoSTLV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (qoSLV().is_bound()) qoSLV().set_implicit_omit();
}

void QoSTLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_qoSLV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSTLV.");
}
}

void QoSTLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_qoSLV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new QoSTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.QoSTLV.");
}
}

void QoSTLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    QoSTLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.QoSTLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) qoSLV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qoSLV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qoSLV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.QoSTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    QoSTLV_template* precondition = new QoSTLV_template;
    precondition->set_param(*param.get_elem(0));
    QoSTLV_template* implied_template = new QoSTLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = QoSTLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.QoSTLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void QoSTLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSTLV");
single_value->field_qoSLV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSTLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSTLV");
}

boolean QoSTLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean QoSTLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ReAttemptIndicatorV::ReAttemptIndicatorV()
{
}

ReAttemptIndicatorV::ReAttemptIndicatorV(const BITSTRING& par_rATCValue,
    const BITSTRING& par_ePLMNCValue,
    const BITSTRING& par_spare)
  :   field_rATCValue(par_rATCValue),
  field_ePLMNCValue(par_ePLMNCValue),
  field_spare(par_spare)
{
}

ReAttemptIndicatorV::ReAttemptIndicatorV(const ReAttemptIndicatorV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
if (other_value.rATCValue().is_bound()) field_rATCValue = other_value.rATCValue();
else field_rATCValue.clean_up();
if (other_value.ePLMNCValue().is_bound()) field_ePLMNCValue = other_value.ePLMNCValue();
else field_ePLMNCValue.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void ReAttemptIndicatorV::clean_up()
{
field_rATCValue.clean_up();
field_ePLMNCValue.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* ReAttemptIndicatorV::get_descriptor() const { return &ReAttemptIndicatorV_descr_; }
ReAttemptIndicatorV& ReAttemptIndicatorV::operator=(const ReAttemptIndicatorV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
  if (other_value.rATCValue().is_bound()) field_rATCValue = other_value.rATCValue();
  else field_rATCValue.clean_up();
  if (other_value.ePLMNCValue().is_bound()) field_ePLMNCValue = other_value.ePLMNCValue();
  else field_ePLMNCValue.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean ReAttemptIndicatorV::operator==(const ReAttemptIndicatorV& other_value) const
{
return field_rATCValue==other_value.field_rATCValue
  && field_ePLMNCValue==other_value.field_ePLMNCValue
  && field_spare==other_value.field_spare;
}

boolean ReAttemptIndicatorV::is_bound() const
{
return (field_rATCValue.is_bound())
  || (field_ePLMNCValue.is_bound())
  || (field_spare.is_bound());
}
boolean ReAttemptIndicatorV::is_value() const
{
return field_rATCValue.is_value()
  && field_ePLMNCValue.is_value()
  && field_spare.is_value();
}
void ReAttemptIndicatorV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ rATCValue := ");
field_rATCValue.log();
TTCN_Logger::log_event_str(", ePLMNCValue := ");
field_ePLMNCValue.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void ReAttemptIndicatorV::set_implicit_omit()
{
if (rATCValue().is_bound()) rATCValue().set_implicit_omit();
if (ePLMNCValue().is_bound()) ePLMNCValue().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void ReAttemptIndicatorV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) rATCValue().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ePLMNCValue().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rATCValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rATCValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ePLMNCValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ePLMNCValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.ReAttemptIndicatorV");
  }
}

void ReAttemptIndicatorV::encode_text(Text_Buf& text_buf) const
{
field_rATCValue.encode_text(text_buf);
field_ePLMNCValue.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void ReAttemptIndicatorV::decode_text(Text_Buf& text_buf)
{
field_rATCValue.decode_text(text_buf);
field_ePLMNCValue.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void ReAttemptIndicatorV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ReAttemptIndicatorV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ReAttemptIndicatorV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_rATCValue.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_ePLMNCValue.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ReAttemptIndicatorV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT6_descr_.raw);
  encoded_length += field_rATCValue.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ePLMNCValue.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct ReAttemptIndicatorV_template::single_value_struct {
BITSTRING_template field_rATCValue;
BITSTRING_template field_ePLMNCValue;
BITSTRING_template field_spare;
};

void ReAttemptIndicatorV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_rATCValue = ANY_VALUE;
single_value->field_ePLMNCValue = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void ReAttemptIndicatorV_template::copy_value(const ReAttemptIndicatorV& other_value)
{
single_value = new single_value_struct;
if (other_value.rATCValue().is_bound()) {
  single_value->field_rATCValue = other_value.rATCValue();
} else {
  single_value->field_rATCValue.clean_up();
}
if (other_value.ePLMNCValue().is_bound()) {
  single_value->field_ePLMNCValue = other_value.ePLMNCValue();
} else {
  single_value->field_ePLMNCValue.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ReAttemptIndicatorV_template::copy_template(const ReAttemptIndicatorV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.rATCValue().get_selection()) {
single_value->field_rATCValue = other_value.rATCValue();
} else {
single_value->field_rATCValue.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ePLMNCValue().get_selection()) {
single_value->field_ePLMNCValue = other_value.ePLMNCValue();
} else {
single_value->field_ePLMNCValue.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ReAttemptIndicatorV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ReAttemptIndicatorV_template(*other_value.implication_.precondition);
implication_.implied_template = new ReAttemptIndicatorV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
break;
}
set_selection(other_value);
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template()
{
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template(const ReAttemptIndicatorV& other_value)
{
copy_value(other_value);
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template(const OPTIONAL<ReAttemptIndicatorV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReAttemptIndicatorV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV from an unbound optional field.");
}
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template(ReAttemptIndicatorV_template* p_precondition, ReAttemptIndicatorV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template(Dynamic_Match_Interface<ReAttemptIndicatorV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ReAttemptIndicatorV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template(const ReAttemptIndicatorV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ReAttemptIndicatorV_template::~ReAttemptIndicatorV_template()
{
clean_up();
}

ReAttemptIndicatorV_template& ReAttemptIndicatorV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ReAttemptIndicatorV_template& ReAttemptIndicatorV_template::operator=(const ReAttemptIndicatorV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ReAttemptIndicatorV_template& ReAttemptIndicatorV_template::operator=(const OPTIONAL<ReAttemptIndicatorV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReAttemptIndicatorV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
}
return *this;
}

ReAttemptIndicatorV_template& ReAttemptIndicatorV_template::operator=(const ReAttemptIndicatorV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ReAttemptIndicatorV_template::match(const ReAttemptIndicatorV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.rATCValue().is_bound()) return FALSE;
if(!single_value->field_rATCValue.match(other_value.rATCValue(), legacy))return FALSE;
if(!other_value.ePLMNCValue().is_bound()) return FALSE;
if(!single_value->field_ePLMNCValue.match(other_value.ePLMNCValue(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
}
return FALSE;
}

boolean ReAttemptIndicatorV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_rATCValue.is_bound()
 || single_value->field_ePLMNCValue.is_bound()
 || single_value->field_spare.is_bound();
}

boolean ReAttemptIndicatorV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_rATCValue.is_value()
 && single_value->field_ePLMNCValue.is_value()
 && single_value->field_spare.is_value();
}

void ReAttemptIndicatorV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ReAttemptIndicatorV ReAttemptIndicatorV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
ReAttemptIndicatorV ret_val;
if (single_value->field_rATCValue.is_bound()) {
ret_val.rATCValue() = single_value->field_rATCValue.valueof();
}
if (single_value->field_ePLMNCValue.is_bound()) {
ret_val.ePLMNCValue() = single_value->field_ePLMNCValue.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void ReAttemptIndicatorV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ReAttemptIndicatorV_template[list_length];
}

ReAttemptIndicatorV_template& ReAttemptIndicatorV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
return value_list.list_value[list_index];
}

BITSTRING_template& ReAttemptIndicatorV_template::rATCValue()
{
set_specific();
return single_value->field_rATCValue;
}

const BITSTRING_template& ReAttemptIndicatorV_template::rATCValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rATCValue of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
return single_value->field_rATCValue;
}

BITSTRING_template& ReAttemptIndicatorV_template::ePLMNCValue()
{
set_specific();
return single_value->field_ePLMNCValue;
}

const BITSTRING_template& ReAttemptIndicatorV_template::ePLMNCValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ePLMNCValue of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
return single_value->field_ePLMNCValue;
}

BITSTRING_template& ReAttemptIndicatorV_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& ReAttemptIndicatorV_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
return single_value->field_spare;
}

int ReAttemptIndicatorV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
  }
  return 0;
}

void ReAttemptIndicatorV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ rATCValue := ");
single_value->field_rATCValue.log();
TTCN_Logger::log_event_str(", ePLMNCValue := ");
single_value->field_ePLMNCValue.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ReAttemptIndicatorV_template::log_match(const ReAttemptIndicatorV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_rATCValue.match(match_value.rATCValue(), legacy)){
TTCN_Logger::log_logmatch_info(".rATCValue");
single_value->field_rATCValue.log_match(match_value.rATCValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ePLMNCValue.match(match_value.ePLMNCValue(), legacy)){
TTCN_Logger::log_logmatch_info(".ePLMNCValue");
single_value->field_ePLMNCValue.log_match(match_value.ePLMNCValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ rATCValue := ");
single_value->field_rATCValue.log_match(match_value.rATCValue(), legacy);
TTCN_Logger::log_event_str(", ePLMNCValue := ");
single_value->field_ePLMNCValue.log_match(match_value.ePLMNCValue(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ReAttemptIndicatorV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (rATCValue().is_bound()) rATCValue().set_implicit_omit();
if (ePLMNCValue().is_bound()) ePLMNCValue().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void ReAttemptIndicatorV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_rATCValue.encode_text(text_buf);
single_value->field_ePLMNCValue.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
}
}

void ReAttemptIndicatorV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_rATCValue.decode_text(text_buf);
single_value->field_ePLMNCValue.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ReAttemptIndicatorV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
}
}

void ReAttemptIndicatorV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ReAttemptIndicatorV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) rATCValue().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ePLMNCValue().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rATCValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rATCValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ePLMNCValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ePLMNCValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ReAttemptIndicatorV_template* precondition = new ReAttemptIndicatorV_template;
    precondition->set_param(*param.get_elem(0));
    ReAttemptIndicatorV_template* implied_template = new ReAttemptIndicatorV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ReAttemptIndicatorV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.ReAttemptIndicatorV");
  }
  is_ifpresent = param.get_ifpresent();
}

void ReAttemptIndicatorV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_rATCValue.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorV");
single_value->field_ePLMNCValue.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorV");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorV");
}

boolean ReAttemptIndicatorV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ReAttemptIndicatorV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ReAttemptIndicatorLV::ReAttemptIndicatorLV()
{
}

ReAttemptIndicatorLV::ReAttemptIndicatorLV(const INTEGER& par_lengthIndicator,
    const ReAttemptIndicatorV& par_reAttemptIndicatorV)
  :   field_lengthIndicator(par_lengthIndicator),
  field_reAttemptIndicatorV(par_reAttemptIndicatorV)
{
}

ReAttemptIndicatorLV::ReAttemptIndicatorLV(const ReAttemptIndicatorLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.reAttemptIndicatorV().is_bound()) field_reAttemptIndicatorV = other_value.reAttemptIndicatorV();
else field_reAttemptIndicatorV.clean_up();
}

void ReAttemptIndicatorLV::clean_up()
{
field_lengthIndicator.clean_up();
field_reAttemptIndicatorV.clean_up();
}

const TTCN_Typedescriptor_t* ReAttemptIndicatorLV::get_descriptor() const { return &ReAttemptIndicatorLV_descr_; }
ReAttemptIndicatorLV& ReAttemptIndicatorLV::operator=(const ReAttemptIndicatorLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.reAttemptIndicatorV().is_bound()) field_reAttemptIndicatorV = other_value.reAttemptIndicatorV();
  else field_reAttemptIndicatorV.clean_up();
}
return *this;
}

boolean ReAttemptIndicatorLV::operator==(const ReAttemptIndicatorLV& other_value) const
{
return field_lengthIndicator==other_value.field_lengthIndicator
  && field_reAttemptIndicatorV==other_value.field_reAttemptIndicatorV;
}

boolean ReAttemptIndicatorLV::is_bound() const
{
return (field_lengthIndicator.is_bound())
  || (field_reAttemptIndicatorV.is_bound());
}
boolean ReAttemptIndicatorLV::is_value() const
{
return field_lengthIndicator.is_value()
  && field_reAttemptIndicatorV.is_value();
}
void ReAttemptIndicatorLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reAttemptIndicatorV := ");
field_reAttemptIndicatorV.log();
TTCN_Logger::log_event_str(" }");
}

void ReAttemptIndicatorLV::set_implicit_omit()
{
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reAttemptIndicatorV().is_bound()) reAttemptIndicatorV().set_implicit_omit();
}

void ReAttemptIndicatorLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reAttemptIndicatorV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reAttemptIndicatorV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reAttemptIndicatorV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.ReAttemptIndicatorLV");
  }
}

void ReAttemptIndicatorLV::encode_text(Text_Buf& text_buf) const
{
field_lengthIndicator.encode_text(text_buf);
field_reAttemptIndicatorV.encode_text(text_buf);
}

void ReAttemptIndicatorLV::decode_text(Text_Buf& text_buf)
{
field_lengthIndicator.decode_text(text_buf);
field_reAttemptIndicatorV.decode_text(text_buf);
}

void ReAttemptIndicatorLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ReAttemptIndicatorLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ReAttemptIndicatorLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, ReAttemptIndicatorLV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(ReAttemptIndicatorLV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_lengthIndicator.convert_to_Integer(ReAttemptIndicatorLV_lengthIndicator_descr_);
  field_lengthIndicator = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, ReAttemptIndicatorV_descr_.raw->forceomit);
  decoded_field_length = field_reAttemptIndicatorV.RAW_decode(ReAttemptIndicatorV_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ReAttemptIndicatorLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, ReAttemptIndicatorLV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, ReAttemptIndicatorV_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &ReAttemptIndicatorLV_lengthIndicator_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_reAttemptIndicatorV.RAW_encode(ReAttemptIndicatorV_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct ReAttemptIndicatorLV_template::single_value_struct {
INTEGER_template field_lengthIndicator;
ReAttemptIndicatorV_template field_reAttemptIndicatorV;
};

void ReAttemptIndicatorLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_reAttemptIndicatorV = ANY_VALUE;
}
}
}

void ReAttemptIndicatorLV_template::copy_value(const ReAttemptIndicatorLV& other_value)
{
single_value = new single_value_struct;
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.reAttemptIndicatorV().is_bound()) {
  single_value->field_reAttemptIndicatorV = other_value.reAttemptIndicatorV();
} else {
  single_value->field_reAttemptIndicatorV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ReAttemptIndicatorLV_template::copy_template(const ReAttemptIndicatorLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reAttemptIndicatorV().get_selection()) {
single_value->field_reAttemptIndicatorV = other_value.reAttemptIndicatorV();
} else {
single_value->field_reAttemptIndicatorV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ReAttemptIndicatorLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ReAttemptIndicatorLV_template(*other_value.implication_.precondition);
implication_.implied_template = new ReAttemptIndicatorLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
break;
}
set_selection(other_value);
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template()
{
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template(const ReAttemptIndicatorLV& other_value)
{
copy_value(other_value);
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template(const OPTIONAL<ReAttemptIndicatorLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReAttemptIndicatorLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV from an unbound optional field.");
}
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template(ReAttemptIndicatorLV_template* p_precondition, ReAttemptIndicatorLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template(Dynamic_Match_Interface<ReAttemptIndicatorLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ReAttemptIndicatorLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template(const ReAttemptIndicatorLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ReAttemptIndicatorLV_template::~ReAttemptIndicatorLV_template()
{
clean_up();
}

ReAttemptIndicatorLV_template& ReAttemptIndicatorLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ReAttemptIndicatorLV_template& ReAttemptIndicatorLV_template::operator=(const ReAttemptIndicatorLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ReAttemptIndicatorLV_template& ReAttemptIndicatorLV_template::operator=(const OPTIONAL<ReAttemptIndicatorLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReAttemptIndicatorLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
}
return *this;
}

ReAttemptIndicatorLV_template& ReAttemptIndicatorLV_template::operator=(const ReAttemptIndicatorLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ReAttemptIndicatorLV_template::match(const ReAttemptIndicatorLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.reAttemptIndicatorV().is_bound()) return FALSE;
if(!single_value->field_reAttemptIndicatorV.match(other_value.reAttemptIndicatorV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
}
return FALSE;
}

boolean ReAttemptIndicatorLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lengthIndicator.is_bound()
 || single_value->field_reAttemptIndicatorV.is_bound();
}

boolean ReAttemptIndicatorLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lengthIndicator.is_value()
 && single_value->field_reAttemptIndicatorV.is_value();
}

void ReAttemptIndicatorLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ReAttemptIndicatorLV ReAttemptIndicatorLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
ReAttemptIndicatorLV ret_val;
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_reAttemptIndicatorV.is_bound()) {
ret_val.reAttemptIndicatorV() = single_value->field_reAttemptIndicatorV.valueof();
}
return ret_val;
}

void ReAttemptIndicatorLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ReAttemptIndicatorLV_template[list_length];
}

ReAttemptIndicatorLV_template& ReAttemptIndicatorLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
return value_list.list_value[list_index];
}

INTEGER_template& ReAttemptIndicatorLV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& ReAttemptIndicatorLV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
return single_value->field_lengthIndicator;
}

ReAttemptIndicatorV_template& ReAttemptIndicatorLV_template::reAttemptIndicatorV()
{
set_specific();
return single_value->field_reAttemptIndicatorV;
}

const ReAttemptIndicatorV_template& ReAttemptIndicatorLV_template::reAttemptIndicatorV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reAttemptIndicatorV of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
return single_value->field_reAttemptIndicatorV;
}

int ReAttemptIndicatorLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
  }
  return 0;
}

void ReAttemptIndicatorLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reAttemptIndicatorV := ");
single_value->field_reAttemptIndicatorV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ReAttemptIndicatorLV_template::log_match(const ReAttemptIndicatorLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reAttemptIndicatorV.match(match_value.reAttemptIndicatorV(), legacy)){
TTCN_Logger::log_logmatch_info(".reAttemptIndicatorV");
single_value->field_reAttemptIndicatorV.log_match(match_value.reAttemptIndicatorV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", reAttemptIndicatorV := ");
single_value->field_reAttemptIndicatorV.log_match(match_value.reAttemptIndicatorV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ReAttemptIndicatorLV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reAttemptIndicatorV().is_bound()) reAttemptIndicatorV().set_implicit_omit();
}

void ReAttemptIndicatorLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_reAttemptIndicatorV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
}
}

void ReAttemptIndicatorLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_reAttemptIndicatorV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ReAttemptIndicatorLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
}
}

void ReAttemptIndicatorLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ReAttemptIndicatorLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reAttemptIndicatorV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reAttemptIndicatorV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reAttemptIndicatorV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ReAttemptIndicatorLV_template* precondition = new ReAttemptIndicatorLV_template;
    precondition->set_param(*param.get_elem(0));
    ReAttemptIndicatorLV_template* implied_template = new ReAttemptIndicatorLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ReAttemptIndicatorLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.ReAttemptIndicatorLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void ReAttemptIndicatorLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorLV");
single_value->field_reAttemptIndicatorV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorLV");
}

boolean ReAttemptIndicatorLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ReAttemptIndicatorLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ReAttemptIndicatorTLV::ReAttemptIndicatorTLV()
{
}

ReAttemptIndicatorTLV::ReAttemptIndicatorTLV(const OCTETSTRING& par_elementIdentifier,
    const ReAttemptIndicatorLV& par_reAttemptIndicatorLV)
  :   field_elementIdentifier(par_elementIdentifier),
  field_reAttemptIndicatorLV(par_reAttemptIndicatorLV)
{
}

ReAttemptIndicatorTLV::ReAttemptIndicatorTLV(const ReAttemptIndicatorTLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.reAttemptIndicatorLV().is_bound()) field_reAttemptIndicatorLV = other_value.reAttemptIndicatorLV();
else field_reAttemptIndicatorLV.clean_up();
}

void ReAttemptIndicatorTLV::clean_up()
{
field_elementIdentifier.clean_up();
field_reAttemptIndicatorLV.clean_up();
}

const TTCN_Typedescriptor_t* ReAttemptIndicatorTLV::get_descriptor() const { return &ReAttemptIndicatorTLV_descr_; }
ReAttemptIndicatorTLV& ReAttemptIndicatorTLV::operator=(const ReAttemptIndicatorTLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.reAttemptIndicatorLV().is_bound()) field_reAttemptIndicatorLV = other_value.reAttemptIndicatorLV();
  else field_reAttemptIndicatorLV.clean_up();
}
return *this;
}

boolean ReAttemptIndicatorTLV::operator==(const ReAttemptIndicatorTLV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_reAttemptIndicatorLV==other_value.field_reAttemptIndicatorLV;
}

boolean ReAttemptIndicatorTLV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_reAttemptIndicatorLV.is_bound());
}
boolean ReAttemptIndicatorTLV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_reAttemptIndicatorLV.is_value();
}
void ReAttemptIndicatorTLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", reAttemptIndicatorLV := ");
field_reAttemptIndicatorLV.log();
TTCN_Logger::log_event_str(" }");
}

void ReAttemptIndicatorTLV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (reAttemptIndicatorLV().is_bound()) reAttemptIndicatorLV().set_implicit_omit();
}

void ReAttemptIndicatorTLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reAttemptIndicatorLV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reAttemptIndicatorLV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reAttemptIndicatorLV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV");
  }
}

void ReAttemptIndicatorTLV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_reAttemptIndicatorLV.encode_text(text_buf);
}

void ReAttemptIndicatorTLV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_reAttemptIndicatorLV.decode_text(text_buf);
}

void ReAttemptIndicatorTLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ReAttemptIndicatorTLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ReAttemptIndicatorTLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, ReAttemptIndicatorLV_descr_.raw->forceomit);
  decoded_field_length = field_reAttemptIndicatorLV.RAW_decode(ReAttemptIndicatorLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_16) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ReAttemptIndicatorTLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, ReAttemptIndicatorLV_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_reAttemptIndicatorLV.RAW_encode(ReAttemptIndicatorLV_descr_, *myleaf.body.node.nodes[1]);
  if (field_elementIdentifier !=  os_16) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_16.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct ReAttemptIndicatorTLV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
ReAttemptIndicatorLV_template field_reAttemptIndicatorLV;
};

void ReAttemptIndicatorTLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_reAttemptIndicatorLV = ANY_VALUE;
}
}
}

void ReAttemptIndicatorTLV_template::copy_value(const ReAttemptIndicatorTLV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.reAttemptIndicatorLV().is_bound()) {
  single_value->field_reAttemptIndicatorLV = other_value.reAttemptIndicatorLV();
} else {
  single_value->field_reAttemptIndicatorLV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ReAttemptIndicatorTLV_template::copy_template(const ReAttemptIndicatorTLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reAttemptIndicatorLV().get_selection()) {
single_value->field_reAttemptIndicatorLV = other_value.reAttemptIndicatorLV();
} else {
single_value->field_reAttemptIndicatorLV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ReAttemptIndicatorTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ReAttemptIndicatorTLV_template(*other_value.implication_.precondition);
implication_.implied_template = new ReAttemptIndicatorTLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
break;
}
set_selection(other_value);
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template()
{
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template(const ReAttemptIndicatorTLV& other_value)
{
copy_value(other_value);
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template(const OPTIONAL<ReAttemptIndicatorTLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReAttemptIndicatorTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV from an unbound optional field.");
}
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template(ReAttemptIndicatorTLV_template* p_precondition, ReAttemptIndicatorTLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template(Dynamic_Match_Interface<ReAttemptIndicatorTLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ReAttemptIndicatorTLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template(const ReAttemptIndicatorTLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ReAttemptIndicatorTLV_template::~ReAttemptIndicatorTLV_template()
{
clean_up();
}

ReAttemptIndicatorTLV_template& ReAttemptIndicatorTLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ReAttemptIndicatorTLV_template& ReAttemptIndicatorTLV_template::operator=(const ReAttemptIndicatorTLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ReAttemptIndicatorTLV_template& ReAttemptIndicatorTLV_template::operator=(const OPTIONAL<ReAttemptIndicatorTLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReAttemptIndicatorTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
}
return *this;
}

ReAttemptIndicatorTLV_template& ReAttemptIndicatorTLV_template::operator=(const ReAttemptIndicatorTLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ReAttemptIndicatorTLV_template::match(const ReAttemptIndicatorTLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.reAttemptIndicatorLV().is_bound()) return FALSE;
if(!single_value->field_reAttemptIndicatorLV.match(other_value.reAttemptIndicatorLV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
}
return FALSE;
}

boolean ReAttemptIndicatorTLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_reAttemptIndicatorLV.is_bound();
}

boolean ReAttemptIndicatorTLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_reAttemptIndicatorLV.is_value();
}

void ReAttemptIndicatorTLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ReAttemptIndicatorTLV ReAttemptIndicatorTLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
ReAttemptIndicatorTLV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_reAttemptIndicatorLV.is_bound()) {
ret_val.reAttemptIndicatorLV() = single_value->field_reAttemptIndicatorLV.valueof();
}
return ret_val;
}

void ReAttemptIndicatorTLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ReAttemptIndicatorTLV_template[list_length];
}

ReAttemptIndicatorTLV_template& ReAttemptIndicatorTLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& ReAttemptIndicatorTLV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& ReAttemptIndicatorTLV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
return single_value->field_elementIdentifier;
}

ReAttemptIndicatorLV_template& ReAttemptIndicatorTLV_template::reAttemptIndicatorLV()
{
set_specific();
return single_value->field_reAttemptIndicatorLV;
}

const ReAttemptIndicatorLV_template& ReAttemptIndicatorTLV_template::reAttemptIndicatorLV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reAttemptIndicatorLV of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
return single_value->field_reAttemptIndicatorLV;
}

int ReAttemptIndicatorTLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
  }
  return 0;
}

void ReAttemptIndicatorTLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", reAttemptIndicatorLV := ");
single_value->field_reAttemptIndicatorLV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ReAttemptIndicatorTLV_template::log_match(const ReAttemptIndicatorTLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reAttemptIndicatorLV.match(match_value.reAttemptIndicatorLV(), legacy)){
TTCN_Logger::log_logmatch_info(".reAttemptIndicatorLV");
single_value->field_reAttemptIndicatorLV.log_match(match_value.reAttemptIndicatorLV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", reAttemptIndicatorLV := ");
single_value->field_reAttemptIndicatorLV.log_match(match_value.reAttemptIndicatorLV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ReAttemptIndicatorTLV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (reAttemptIndicatorLV().is_bound()) reAttemptIndicatorLV().set_implicit_omit();
}

void ReAttemptIndicatorTLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_reAttemptIndicatorLV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
}
}

void ReAttemptIndicatorTLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_reAttemptIndicatorLV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ReAttemptIndicatorTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
}
}

void ReAttemptIndicatorTLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ReAttemptIndicatorTLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reAttemptIndicatorLV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reAttemptIndicatorLV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reAttemptIndicatorLV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ReAttemptIndicatorTLV_template* precondition = new ReAttemptIndicatorTLV_template;
    precondition->set_param(*param.get_elem(0));
    ReAttemptIndicatorTLV_template* implied_template = new ReAttemptIndicatorTLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ReAttemptIndicatorTLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void ReAttemptIndicatorTLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV");
single_value->field_reAttemptIndicatorLV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV");
}

boolean ReAttemptIndicatorTLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ReAttemptIndicatorTLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SMCause2LV::SMCause2LV()
{
}

SMCause2LV::SMCause2LV(const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_sMCause2V)
  :   field_lengthIndicator(par_lengthIndicator),
  field_sMCause2V(par_sMCause2V)
{
}

SMCause2LV::SMCause2LV(const SMCause2LV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.SMCause2LV.");
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.sMCause2V().is_bound()) field_sMCause2V = other_value.sMCause2V();
else field_sMCause2V.clean_up();
}

void SMCause2LV::clean_up()
{
field_lengthIndicator.clean_up();
field_sMCause2V.clean_up();
}

const TTCN_Typedescriptor_t* SMCause2LV::get_descriptor() const { return &SMCause2LV_descr_; }
SMCause2LV& SMCause2LV::operator=(const SMCause2LV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.SMCause2LV.");
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.sMCause2V().is_bound()) field_sMCause2V = other_value.sMCause2V();
  else field_sMCause2V.clean_up();
}
return *this;
}

boolean SMCause2LV::operator==(const SMCause2LV& other_value) const
{
return field_lengthIndicator==other_value.field_lengthIndicator
  && field_sMCause2V==other_value.field_sMCause2V;
}

boolean SMCause2LV::is_bound() const
{
return (field_lengthIndicator.is_bound())
  || (field_sMCause2V.is_bound());
}
boolean SMCause2LV::is_value() const
{
return field_lengthIndicator.is_value()
  && field_sMCause2V.is_value();
}
void SMCause2LV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", sMCause2V := ");
field_sMCause2V.log();
TTCN_Logger::log_event_str(" }");
}

void SMCause2LV::set_implicit_omit()
{
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (sMCause2V().is_bound()) sMCause2V().set_implicit_omit();
}

void SMCause2LV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.SMCause2LV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sMCause2V().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sMCause2V")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sMCause2V().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.SMCause2LV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.SMCause2LV");
  }
}

void SMCause2LV::encode_text(Text_Buf& text_buf) const
{
field_lengthIndicator.encode_text(text_buf);
field_sMCause2V.encode_text(text_buf);
}

void SMCause2LV::decode_text(Text_Buf& text_buf)
{
field_lengthIndicator.decode_text(text_buf);
field_sMCause2V.decode_text(text_buf);
}

void SMCause2LV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SMCause2LV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SMCause2LV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SMCause2LV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(SMCause2LV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_lengthIndicator.convert_to_Integer(SMCause2LV_lengthIndicator_descr_);
  field_lengthIndicator = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_sMCause2V.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SMCause2LV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SMCause2LV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT1_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &SMCause2LV_lengthIndicator_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_sMCause2V.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct SMCause2LV_template::single_value_struct {
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_sMCause2V;
};

void SMCause2LV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_sMCause2V = ANY_VALUE;
}
}
}

void SMCause2LV_template::copy_value(const SMCause2LV& other_value)
{
single_value = new single_value_struct;
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.sMCause2V().is_bound()) {
  single_value->field_sMCause2V = other_value.sMCause2V();
} else {
  single_value->field_sMCause2V.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SMCause2LV_template::copy_template(const SMCause2LV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sMCause2V().get_selection()) {
single_value->field_sMCause2V = other_value.sMCause2V();
} else {
single_value->field_sMCause2V.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SMCause2LV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SMCause2LV_template(*other_value.implication_.precondition);
implication_.implied_template = new SMCause2LV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
break;
}
set_selection(other_value);
}

SMCause2LV_template::SMCause2LV_template()
{
}

SMCause2LV_template::SMCause2LV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SMCause2LV_template::SMCause2LV_template(const SMCause2LV& other_value)
{
copy_value(other_value);
}

SMCause2LV_template::SMCause2LV_template(const OPTIONAL<SMCause2LV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SMCause2LV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.SMCause2LV from an unbound optional field.");
}
}

SMCause2LV_template::SMCause2LV_template(SMCause2LV_template* p_precondition, SMCause2LV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SMCause2LV_template::SMCause2LV_template(Dynamic_Match_Interface<SMCause2LV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SMCause2LV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SMCause2LV_template::SMCause2LV_template(const SMCause2LV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SMCause2LV_template::~SMCause2LV_template()
{
clean_up();
}

SMCause2LV_template& SMCause2LV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SMCause2LV_template& SMCause2LV_template::operator=(const SMCause2LV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SMCause2LV_template& SMCause2LV_template::operator=(const OPTIONAL<SMCause2LV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SMCause2LV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
}
return *this;
}

SMCause2LV_template& SMCause2LV_template::operator=(const SMCause2LV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SMCause2LV_template::match(const SMCause2LV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.sMCause2V().is_bound()) return FALSE;
if(!single_value->field_sMCause2V.match(other_value.sMCause2V(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
}
return FALSE;
}

boolean SMCause2LV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lengthIndicator.is_bound()
 || single_value->field_sMCause2V.is_bound();
}

boolean SMCause2LV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lengthIndicator.is_value()
 && single_value->field_sMCause2V.is_value();
}

void SMCause2LV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SMCause2LV SMCause2LV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
SMCause2LV ret_val;
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_sMCause2V.is_bound()) {
ret_val.sMCause2V() = single_value->field_sMCause2V.valueof();
}
return ret_val;
}

void SMCause2LV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SMCause2LV_template[list_length];
}

SMCause2LV_template& SMCause2LV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
return value_list.list_value[list_index];
}

INTEGER_template& SMCause2LV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& SMCause2LV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& SMCause2LV_template::sMCause2V()
{
set_specific();
return single_value->field_sMCause2V;
}

const OCTETSTRING_template& SMCause2LV_template::sMCause2V() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sMCause2V of a non-specific template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
return single_value->field_sMCause2V;
}

int SMCause2LV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
  }
  return 0;
}

void SMCause2LV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", sMCause2V := ");
single_value->field_sMCause2V.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SMCause2LV_template::log_match(const SMCause2LV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sMCause2V.match(match_value.sMCause2V(), legacy)){
TTCN_Logger::log_logmatch_info(".sMCause2V");
single_value->field_sMCause2V.log_match(match_value.sMCause2V(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", sMCause2V := ");
single_value->field_sMCause2V.log_match(match_value.sMCause2V(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SMCause2LV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (sMCause2V().is_bound()) sMCause2V().set_implicit_omit();
}

void SMCause2LV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_sMCause2V.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
}
}

void SMCause2LV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_sMCause2V.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SMCause2LV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
}
}

void SMCause2LV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SMCause2LV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.SMCause2LV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sMCause2V().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sMCause2V")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sMCause2V().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.SMCause2LV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SMCause2LV_template* precondition = new SMCause2LV_template;
    precondition->set_param(*param.get_elem(0));
    SMCause2LV_template* implied_template = new SMCause2LV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SMCause2LV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.SMCause2LV");
  }
  is_ifpresent = param.get_ifpresent();
}

void SMCause2LV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.SMCause2LV");
single_value->field_sMCause2V.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.SMCause2LV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.SMCause2LV");
}

boolean SMCause2LV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SMCause2LV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SMCause2TLV::SMCause2TLV()
{
}

SMCause2TLV::SMCause2TLV(const OCTETSTRING& par_elementIdentifier,
    const SMCause2LV& par_sMCause2LV)
  :   field_elementIdentifier(par_elementIdentifier),
  field_sMCause2LV(par_sMCause2LV)
{
}

SMCause2TLV::SMCause2TLV(const SMCause2TLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.sMCause2LV().is_bound()) field_sMCause2LV = other_value.sMCause2LV();
else field_sMCause2LV.clean_up();
}

void SMCause2TLV::clean_up()
{
field_elementIdentifier.clean_up();
field_sMCause2LV.clean_up();
}

const TTCN_Typedescriptor_t* SMCause2TLV::get_descriptor() const { return &SMCause2TLV_descr_; }
SMCause2TLV& SMCause2TLV::operator=(const SMCause2TLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.sMCause2LV().is_bound()) field_sMCause2LV = other_value.sMCause2LV();
  else field_sMCause2LV.clean_up();
}
return *this;
}

boolean SMCause2TLV::operator==(const SMCause2TLV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_sMCause2LV==other_value.field_sMCause2LV;
}

boolean SMCause2TLV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_sMCause2LV.is_bound());
}
boolean SMCause2TLV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_sMCause2LV.is_value();
}
void SMCause2TLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", sMCause2LV := ");
field_sMCause2LV.log();
TTCN_Logger::log_event_str(" }");
}

void SMCause2TLV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (sMCause2LV().is_bound()) sMCause2LV().set_implicit_omit();
}

void SMCause2TLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.SMCause2TLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sMCause2LV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sMCause2LV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sMCause2LV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.SMCause2TLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.SMCause2TLV");
  }
}

void SMCause2TLV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_sMCause2LV.encode_text(text_buf);
}

void SMCause2TLV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_sMCause2LV.decode_text(text_buf);
}

void SMCause2TLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SMCause2TLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SMCause2TLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SMCause2LV_descr_.raw->forceomit);
  decoded_field_length = field_sMCause2LV.RAW_decode(SMCause2LV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_17) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SMCause2TLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SMCause2LV_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_sMCause2LV.RAW_encode(SMCause2LV_descr_, *myleaf.body.node.nodes[1]);
  if (field_elementIdentifier !=  os_17) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_17.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct SMCause2TLV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
SMCause2LV_template field_sMCause2LV;
};

void SMCause2TLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_sMCause2LV = ANY_VALUE;
}
}
}

void SMCause2TLV_template::copy_value(const SMCause2TLV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.sMCause2LV().is_bound()) {
  single_value->field_sMCause2LV = other_value.sMCause2LV();
} else {
  single_value->field_sMCause2LV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SMCause2TLV_template::copy_template(const SMCause2TLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sMCause2LV().get_selection()) {
single_value->field_sMCause2LV = other_value.sMCause2LV();
} else {
single_value->field_sMCause2LV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SMCause2TLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SMCause2TLV_template(*other_value.implication_.precondition);
implication_.implied_template = new SMCause2TLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
break;
}
set_selection(other_value);
}

SMCause2TLV_template::SMCause2TLV_template()
{
}

SMCause2TLV_template::SMCause2TLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SMCause2TLV_template::SMCause2TLV_template(const SMCause2TLV& other_value)
{
copy_value(other_value);
}

SMCause2TLV_template::SMCause2TLV_template(const OPTIONAL<SMCause2TLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SMCause2TLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.SMCause2TLV from an unbound optional field.");
}
}

SMCause2TLV_template::SMCause2TLV_template(SMCause2TLV_template* p_precondition, SMCause2TLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SMCause2TLV_template::SMCause2TLV_template(Dynamic_Match_Interface<SMCause2TLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SMCause2TLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SMCause2TLV_template::SMCause2TLV_template(const SMCause2TLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SMCause2TLV_template::~SMCause2TLV_template()
{
clean_up();
}

SMCause2TLV_template& SMCause2TLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SMCause2TLV_template& SMCause2TLV_template::operator=(const SMCause2TLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SMCause2TLV_template& SMCause2TLV_template::operator=(const OPTIONAL<SMCause2TLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SMCause2TLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
}
return *this;
}

SMCause2TLV_template& SMCause2TLV_template::operator=(const SMCause2TLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SMCause2TLV_template::match(const SMCause2TLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.sMCause2LV().is_bound()) return FALSE;
if(!single_value->field_sMCause2LV.match(other_value.sMCause2LV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
}
return FALSE;
}

boolean SMCause2TLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_sMCause2LV.is_bound();
}

boolean SMCause2TLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_sMCause2LV.is_value();
}

void SMCause2TLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SMCause2TLV SMCause2TLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
SMCause2TLV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_sMCause2LV.is_bound()) {
ret_val.sMCause2LV() = single_value->field_sMCause2LV.valueof();
}
return ret_val;
}

void SMCause2TLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SMCause2TLV_template[list_length];
}

SMCause2TLV_template& SMCause2TLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& SMCause2TLV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& SMCause2TLV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
return single_value->field_elementIdentifier;
}

SMCause2LV_template& SMCause2TLV_template::sMCause2LV()
{
set_specific();
return single_value->field_sMCause2LV;
}

const SMCause2LV_template& SMCause2TLV_template::sMCause2LV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sMCause2LV of a non-specific template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
return single_value->field_sMCause2LV;
}

int SMCause2TLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
  }
  return 0;
}

void SMCause2TLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", sMCause2LV := ");
single_value->field_sMCause2LV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SMCause2TLV_template::log_match(const SMCause2TLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sMCause2LV.match(match_value.sMCause2LV(), legacy)){
TTCN_Logger::log_logmatch_info(".sMCause2LV");
single_value->field_sMCause2LV.log_match(match_value.sMCause2LV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", sMCause2LV := ");
single_value->field_sMCause2LV.log_match(match_value.sMCause2LV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SMCause2TLV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (sMCause2LV().is_bound()) sMCause2LV().set_implicit_omit();
}

void SMCause2TLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_sMCause2LV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
}
}

void SMCause2TLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_sMCause2LV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SMCause2TLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
}
}

void SMCause2TLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SMCause2TLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.SMCause2TLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sMCause2LV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sMCause2LV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sMCause2LV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.SMCause2TLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SMCause2TLV_template* precondition = new SMCause2TLV_template;
    precondition->set_param(*param.get_elem(0));
    SMCause2TLV_template* implied_template = new SMCause2TLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SMCause2TLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.SMCause2TLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void SMCause2TLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.SMCause2TLV");
single_value->field_sMCause2LV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.SMCause2TLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.SMCause2TLV");
}

boolean SMCause2TLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SMCause2TLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

LinkedTIV::LinkedTIV()
{
}

LinkedTIV::LinkedTIV(const BITSTRING& par_spare,
    const BITSTRING& par_tio,
    const BITSTRING& par_tiFlag,
    const OPTIONAL< TI__Extension >& par_tIExtension)
  :   field_spare(par_spare),
  field_tio(par_tio),
  field_tiFlag(par_tiFlag),
  field_tIExtension(par_tIExtension)
{
}

LinkedTIV::LinkedTIV(const LinkedTIV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.LinkedTIV.");
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.tio().is_bound()) field_tio = other_value.tio();
else field_tio.clean_up();
if (other_value.tiFlag().is_bound()) field_tiFlag = other_value.tiFlag();
else field_tiFlag.clean_up();
if (other_value.tIExtension().is_bound()) field_tIExtension = other_value.tIExtension();
else field_tIExtension.clean_up();
}

void LinkedTIV::clean_up()
{
field_spare.clean_up();
field_tio.clean_up();
field_tiFlag.clean_up();
field_tIExtension.clean_up();
}

const TTCN_Typedescriptor_t* LinkedTIV::get_descriptor() const { return &LinkedTIV_descr_; }
LinkedTIV& LinkedTIV::operator=(const LinkedTIV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.LinkedTIV.");
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.tio().is_bound()) field_tio = other_value.tio();
  else field_tio.clean_up();
  if (other_value.tiFlag().is_bound()) field_tiFlag = other_value.tiFlag();
  else field_tiFlag.clean_up();
  if (other_value.tIExtension().is_bound()) field_tIExtension = other_value.tIExtension();
  else field_tIExtension.clean_up();
}
return *this;
}

boolean LinkedTIV::operator==(const LinkedTIV& other_value) const
{
return field_spare==other_value.field_spare
  && field_tio==other_value.field_tio
  && field_tiFlag==other_value.field_tiFlag
  && field_tIExtension==other_value.field_tIExtension;
}

boolean LinkedTIV::is_bound() const
{
return (field_spare.is_bound())
  || (field_tio.is_bound())
  || (field_tiFlag.is_bound())
  || (OPTIONAL_OMIT == field_tIExtension.get_selection() || field_tIExtension.is_bound());
}
boolean LinkedTIV::is_value() const
{
return field_spare.is_value()
  && field_tio.is_value()
  && field_tiFlag.is_value()
  && (OPTIONAL_OMIT == field_tIExtension.get_selection() || field_tIExtension.is_value());
}
int LinkedTIV::size_of() const
{
  int ret_val = 3;
  if (field_tIExtension.ispresent()) ret_val++;
  return ret_val;
}

void LinkedTIV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", tio := ");
field_tio.log();
TTCN_Logger::log_event_str(", tiFlag := ");
field_tiFlag.log();
TTCN_Logger::log_event_str(", tIExtension := ");
field_tIExtension.log();
TTCN_Logger::log_event_str(" }");
}

void LinkedTIV::set_implicit_omit()
{
if (spare().is_bound()) spare().set_implicit_omit();
if (tio().is_bound()) tio().set_implicit_omit();
if (tiFlag().is_bound()) tiFlag().set_implicit_omit();
if (!tIExtension().is_bound()) tIExtension() = OMIT_VALUE;
else tIExtension().set_implicit_omit();
}

void LinkedTIV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.LinkedTIV has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tio().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tiFlag().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) tIExtension().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tio")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tio().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tiFlag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tiFlag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tIExtension")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tIExtension().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LinkedTIV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.LinkedTIV");
  }
}

void LinkedTIV::encode_text(Text_Buf& text_buf) const
{
field_spare.encode_text(text_buf);
field_tio.encode_text(text_buf);
field_tiFlag.encode_text(text_buf);
field_tIExtension.encode_text(text_buf);
}

void LinkedTIV::decode_text(Text_Buf& text_buf)
{
field_spare.decode_text(text_buf);
field_tio.decode_text(text_buf);
field_tiFlag.decode_text(text_buf);
field_tIExtension.decode_text(text_buf);
}

void LinkedTIV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LinkedTIV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int LinkedTIV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_tio.RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_tiFlag.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_tio ==  bs_14){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_tIExtension = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, LinkedTIV_tIExtension_descr_.raw->forceomit);
  decoded_field_length = field_tIExtension().RAW_decode(LinkedTIV_tIExtension_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_tIExtension = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_tIExtension=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int LinkedTIV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT1_descr_.raw);
  if (field_tIExtension.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, LinkedTIV_tIExtension_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_tio.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_tiFlag.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[2]);
  if (field_tIExtension.ispresent()) {
  encoded_length += field_tIExtension().RAW_encode(LinkedTIV_tIExtension_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_tIExtension.ispresent() && (field_tio !=  bs_14)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_14.RAW_encode(General__Types::BIT3_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct LinkedTIV_template::single_value_struct {
BITSTRING_template field_spare;
BITSTRING_template field_tio;
BITSTRING_template field_tiFlag;
TI__Extension_template field_tIExtension;
};

void LinkedTIV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_spare = ANY_VALUE;
single_value->field_tio = ANY_VALUE;
single_value->field_tiFlag = ANY_VALUE;
single_value->field_tIExtension = ANY_OR_OMIT;
}
}
}

void LinkedTIV_template::copy_value(const LinkedTIV& other_value)
{
single_value = new single_value_struct;
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.tio().is_bound()) {
  single_value->field_tio = other_value.tio();
} else {
  single_value->field_tio.clean_up();
}
if (other_value.tiFlag().is_bound()) {
  single_value->field_tiFlag = other_value.tiFlag();
} else {
  single_value->field_tiFlag.clean_up();
}
if (other_value.tIExtension().is_bound()) {
  if (other_value.tIExtension().ispresent()) single_value->field_tIExtension = other_value.tIExtension()();
  else single_value->field_tIExtension = OMIT_VALUE;
} else {
  single_value->field_tIExtension.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void LinkedTIV_template::copy_template(const LinkedTIV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tio().get_selection()) {
single_value->field_tio = other_value.tio();
} else {
single_value->field_tio.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tiFlag().get_selection()) {
single_value->field_tiFlag = other_value.tiFlag();
} else {
single_value->field_tiFlag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tIExtension().get_selection()) {
single_value->field_tIExtension = other_value.tIExtension();
} else {
single_value->field_tIExtension.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new LinkedTIV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new LinkedTIV_template(*other_value.implication_.precondition);
implication_.implied_template = new LinkedTIV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
break;
}
set_selection(other_value);
}

LinkedTIV_template::LinkedTIV_template()
{
}

LinkedTIV_template::LinkedTIV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

LinkedTIV_template::LinkedTIV_template(const LinkedTIV& other_value)
{
copy_value(other_value);
}

LinkedTIV_template::LinkedTIV_template(const OPTIONAL<LinkedTIV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LinkedTIV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.LinkedTIV from an unbound optional field.");
}
}

LinkedTIV_template::LinkedTIV_template(LinkedTIV_template* p_precondition, LinkedTIV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

LinkedTIV_template::LinkedTIV_template(Dynamic_Match_Interface<LinkedTIV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<LinkedTIV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

LinkedTIV_template::LinkedTIV_template(const LinkedTIV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

LinkedTIV_template::~LinkedTIV_template()
{
clean_up();
}

LinkedTIV_template& LinkedTIV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

LinkedTIV_template& LinkedTIV_template::operator=(const LinkedTIV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

LinkedTIV_template& LinkedTIV_template::operator=(const OPTIONAL<LinkedTIV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LinkedTIV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
}
return *this;
}

LinkedTIV_template& LinkedTIV_template::operator=(const LinkedTIV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean LinkedTIV_template::match(const LinkedTIV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.tio().is_bound()) return FALSE;
if(!single_value->field_tio.match(other_value.tio(), legacy))return FALSE;
if(!other_value.tiFlag().is_bound()) return FALSE;
if(!single_value->field_tiFlag.match(other_value.tiFlag(), legacy))return FALSE;
if(!other_value.tIExtension().is_bound()) return FALSE;
if((other_value.tIExtension().ispresent() ? !single_value->field_tIExtension.match((const TI__Extension&)other_value.tIExtension(), legacy) : !single_value->field_tIExtension.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
}
return FALSE;
}

boolean LinkedTIV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_spare.is_bound()
 || single_value->field_tio.is_bound()
 || single_value->field_tiFlag.is_bound()
 || (single_value->field_tIExtension.is_omit() || single_value->field_tIExtension.is_bound());
}

boolean LinkedTIV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_spare.is_value()
 && single_value->field_tio.is_value()
 && single_value->field_tiFlag.is_value()
 && (single_value->field_tIExtension.is_omit() || single_value->field_tIExtension.is_value());
}

void LinkedTIV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

LinkedTIV LinkedTIV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
LinkedTIV ret_val;
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_tio.is_bound()) {
ret_val.tio() = single_value->field_tio.valueof();
}
if (single_value->field_tiFlag.is_bound()) {
ret_val.tiFlag() = single_value->field_tiFlag.valueof();
}
if (single_value->field_tIExtension.is_omit()) ret_val.tIExtension() = OMIT_VALUE;
else if (single_value->field_tIExtension.is_bound()) {
ret_val.tIExtension() = single_value->field_tIExtension.valueof();
}
return ret_val;
}

void LinkedTIV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new LinkedTIV_template[list_length];
}

LinkedTIV_template& LinkedTIV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
return value_list.list_value[list_index];
}

BITSTRING_template& LinkedTIV_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& LinkedTIV_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
return single_value->field_spare;
}

BITSTRING_template& LinkedTIV_template::tio()
{
set_specific();
return single_value->field_tio;
}

const BITSTRING_template& LinkedTIV_template::tio() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tio of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
return single_value->field_tio;
}

BITSTRING_template& LinkedTIV_template::tiFlag()
{
set_specific();
return single_value->field_tiFlag;
}

const BITSTRING_template& LinkedTIV_template::tiFlag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tiFlag of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
return single_value->field_tiFlag;
}

TI__Extension_template& LinkedTIV_template::tIExtension()
{
set_specific();
return single_value->field_tIExtension;
}

const TI__Extension_template& LinkedTIV_template::tIExtension() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tIExtension of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
return single_value->field_tIExtension;
}

int LinkedTIV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_tIExtension.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
  }
  return 0;
}

void LinkedTIV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", tio := ");
single_value->field_tio.log();
TTCN_Logger::log_event_str(", tiFlag := ");
single_value->field_tiFlag.log();
TTCN_Logger::log_event_str(", tIExtension := ");
single_value->field_tIExtension.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void LinkedTIV_template::log_match(const LinkedTIV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tio.match(match_value.tio(), legacy)){
TTCN_Logger::log_logmatch_info(".tio");
single_value->field_tio.log_match(match_value.tio(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tiFlag.match(match_value.tiFlag(), legacy)){
TTCN_Logger::log_logmatch_info(".tiFlag");
single_value->field_tiFlag.log_match(match_value.tiFlag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.tIExtension().ispresent()){
if(!single_value->field_tIExtension.match(match_value.tIExtension(), legacy)){
TTCN_Logger::log_logmatch_info(".tIExtension");
single_value->field_tIExtension.log_match(match_value.tIExtension(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_tIExtension.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".tIExtension := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_tIExtension.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", tio := ");
single_value->field_tio.log_match(match_value.tio(), legacy);
TTCN_Logger::log_event_str(", tiFlag := ");
single_value->field_tiFlag.log_match(match_value.tiFlag(), legacy);
TTCN_Logger::log_event_str(", tIExtension := ");
if (match_value.tIExtension().ispresent()) {
single_value->field_tIExtension.log_match(match_value.tIExtension(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_tIExtension.log();
if (single_value->field_tIExtension.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void LinkedTIV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (spare().is_bound()) spare().set_implicit_omit();
if (tio().is_bound()) tio().set_implicit_omit();
if (tiFlag().is_bound()) tiFlag().set_implicit_omit();
if (!tIExtension().is_bound()) tIExtension() = OMIT_VALUE;
else tIExtension().set_implicit_omit();
}

void LinkedTIV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_spare.encode_text(text_buf);
single_value->field_tio.encode_text(text_buf);
single_value->field_tiFlag.encode_text(text_buf);
single_value->field_tIExtension.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
}
}

void LinkedTIV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_spare.decode_text(text_buf);
single_value->field_tio.decode_text(text_buf);
single_value->field_tiFlag.decode_text(text_buf);
single_value->field_tIExtension.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new LinkedTIV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
}
}

void LinkedTIV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    LinkedTIV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.LinkedTIV has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tio().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tiFlag().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) tIExtension().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tio")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tio().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tiFlag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tiFlag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tIExtension")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tIExtension().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LinkedTIV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    LinkedTIV_template* precondition = new LinkedTIV_template;
    precondition->set_param(*param.get_elem(0));
    LinkedTIV_template* implied_template = new LinkedTIV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = LinkedTIV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.LinkedTIV");
  }
  is_ifpresent = param.get_ifpresent();
}

void LinkedTIV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTIV");
single_value->field_tio.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTIV");
single_value->field_tiFlag.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTIV");
single_value->field_tIExtension.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTIV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTIV");
}

boolean LinkedTIV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean LinkedTIV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

TI__Extension::TI__Extension()
{
}

TI__Extension::TI__Extension(const BITSTRING& par_tI__Value,
    const BITSTRING& par_tI__ExtBit)
  :   field_tI__Value(par_tI__Value),
  field_tI__ExtBit(par_tI__ExtBit)
{
}

TI__Extension::TI__Extension(const TI__Extension& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.TI_Extension.");
if (other_value.tI__Value().is_bound()) field_tI__Value = other_value.tI__Value();
else field_tI__Value.clean_up();
if (other_value.tI__ExtBit().is_bound()) field_tI__ExtBit = other_value.tI__ExtBit();
else field_tI__ExtBit.clean_up();
}

void TI__Extension::clean_up()
{
field_tI__Value.clean_up();
field_tI__ExtBit.clean_up();
}

const TTCN_Typedescriptor_t* TI__Extension::get_descriptor() const { return &TI__Extension_descr_; }
TI__Extension& TI__Extension::operator=(const TI__Extension& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.TI_Extension.");
  if (other_value.tI__Value().is_bound()) field_tI__Value = other_value.tI__Value();
  else field_tI__Value.clean_up();
  if (other_value.tI__ExtBit().is_bound()) field_tI__ExtBit = other_value.tI__ExtBit();
  else field_tI__ExtBit.clean_up();
}
return *this;
}

boolean TI__Extension::operator==(const TI__Extension& other_value) const
{
return field_tI__Value==other_value.field_tI__Value
  && field_tI__ExtBit==other_value.field_tI__ExtBit;
}

boolean TI__Extension::is_bound() const
{
return (field_tI__Value.is_bound())
  || (field_tI__ExtBit.is_bound());
}
boolean TI__Extension::is_value() const
{
return field_tI__Value.is_value()
  && field_tI__ExtBit.is_value();
}
void TI__Extension::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tI_Value := ");
field_tI__Value.log();
TTCN_Logger::log_event_str(", tI_ExtBit := ");
field_tI__ExtBit.log();
TTCN_Logger::log_event_str(" }");
}

void TI__Extension::set_implicit_omit()
{
if (tI__Value().is_bound()) tI__Value().set_implicit_omit();
if (tI__ExtBit().is_bound()) tI__ExtBit().set_implicit_omit();
}

void TI__Extension::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.TI_Extension has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tI__Value().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tI__ExtBit().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tI_Value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tI__Value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tI_ExtBit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tI__ExtBit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.TI_Extension: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.TI_Extension");
  }
}

void TI__Extension::encode_text(Text_Buf& text_buf) const
{
field_tI__Value.encode_text(text_buf);
field_tI__ExtBit.encode_text(text_buf);
}

void TI__Extension::decode_text(Text_Buf& text_buf)
{
field_tI__Value.decode_text(text_buf);
field_tI__ExtBit.decode_text(text_buf);
}

void TI__Extension::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void TI__Extension::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int TI__Extension::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_tI__Value.RAW_decode(General__Types::BIT7_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_tI__ExtBit.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int TI__Extension::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT7_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT1_descr_.raw);
  encoded_length += field_tI__Value.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_tI__ExtBit.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct TI__Extension_template::single_value_struct {
BITSTRING_template field_tI__Value;
BITSTRING_template field_tI__ExtBit;
};

void TI__Extension_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tI__Value = ANY_VALUE;
single_value->field_tI__ExtBit = ANY_VALUE;
}
}
}

void TI__Extension_template::copy_value(const TI__Extension& other_value)
{
single_value = new single_value_struct;
if (other_value.tI__Value().is_bound()) {
  single_value->field_tI__Value = other_value.tI__Value();
} else {
  single_value->field_tI__Value.clean_up();
}
if (other_value.tI__ExtBit().is_bound()) {
  single_value->field_tI__ExtBit = other_value.tI__ExtBit();
} else {
  single_value->field_tI__ExtBit.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void TI__Extension_template::copy_template(const TI__Extension_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tI__Value().get_selection()) {
single_value->field_tI__Value = other_value.tI__Value();
} else {
single_value->field_tI__Value.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tI__ExtBit().get_selection()) {
single_value->field_tI__ExtBit = other_value.tI__ExtBit();
} else {
single_value->field_tI__ExtBit.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new TI__Extension_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new TI__Extension_template(*other_value.implication_.precondition);
implication_.implied_template = new TI__Extension_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TI_Extension.");
break;
}
set_selection(other_value);
}

TI__Extension_template::TI__Extension_template()
{
}

TI__Extension_template::TI__Extension_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

TI__Extension_template::TI__Extension_template(const TI__Extension& other_value)
{
copy_value(other_value);
}

TI__Extension_template::TI__Extension_template(const OPTIONAL<TI__Extension>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TI__Extension&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.TI_Extension from an unbound optional field.");
}
}

TI__Extension_template::TI__Extension_template(TI__Extension_template* p_precondition, TI__Extension_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

TI__Extension_template::TI__Extension_template(Dynamic_Match_Interface<TI__Extension>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<TI__Extension>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

TI__Extension_template::TI__Extension_template(const TI__Extension_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

TI__Extension_template::~TI__Extension_template()
{
clean_up();
}

TI__Extension_template& TI__Extension_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

TI__Extension_template& TI__Extension_template::operator=(const TI__Extension& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

TI__Extension_template& TI__Extension_template::operator=(const OPTIONAL<TI__Extension>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TI__Extension&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.TI_Extension.");
}
return *this;
}

TI__Extension_template& TI__Extension_template::operator=(const TI__Extension_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean TI__Extension_template::match(const TI__Extension& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tI__Value().is_bound()) return FALSE;
if(!single_value->field_tI__Value.match(other_value.tI__Value(), legacy))return FALSE;
if(!other_value.tI__ExtBit().is_bound()) return FALSE;
if(!single_value->field_tI__ExtBit.match(other_value.tI__ExtBit(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TI_Extension.");
}
return FALSE;
}

boolean TI__Extension_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tI__Value.is_bound()
 || single_value->field_tI__ExtBit.is_bound();
}

boolean TI__Extension_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tI__Value.is_value()
 && single_value->field_tI__ExtBit.is_value();
}

void TI__Extension_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

TI__Extension TI__Extension_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.TI_Extension.");
TI__Extension ret_val;
if (single_value->field_tI__Value.is_bound()) {
ret_val.tI__Value() = single_value->field_tI__Value.valueof();
}
if (single_value->field_tI__ExtBit.is_bound()) {
ret_val.tI__ExtBit() = single_value->field_tI__ExtBit.valueof();
}
return ret_val;
}

void TI__Extension_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.TI_Extension.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new TI__Extension_template[list_length];
}

TI__Extension_template& TI__Extension_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.TI_Extension.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.TI_Extension.");
return value_list.list_value[list_index];
}

BITSTRING_template& TI__Extension_template::tI__Value()
{
set_specific();
return single_value->field_tI__Value;
}

const BITSTRING_template& TI__Extension_template::tI__Value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tI_Value of a non-specific template of type @MobileL3_GMM_SM_Types.TI_Extension.");
return single_value->field_tI__Value;
}

BITSTRING_template& TI__Extension_template::tI__ExtBit()
{
set_specific();
return single_value->field_tI__ExtBit;
}

const BITSTRING_template& TI__Extension_template::tI__ExtBit() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tI_ExtBit of a non-specific template of type @MobileL3_GMM_SM_Types.TI_Extension.");
return single_value->field_tI__ExtBit;
}

int TI__Extension_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TI_Extension.");
  }
  return 0;
}

void TI__Extension_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tI_Value := ");
single_value->field_tI__Value.log();
TTCN_Logger::log_event_str(", tI_ExtBit := ");
single_value->field_tI__ExtBit.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void TI__Extension_template::log_match(const TI__Extension& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tI__Value.match(match_value.tI__Value(), legacy)){
TTCN_Logger::log_logmatch_info(".tI_Value");
single_value->field_tI__Value.log_match(match_value.tI__Value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tI__ExtBit.match(match_value.tI__ExtBit(), legacy)){
TTCN_Logger::log_logmatch_info(".tI_ExtBit");
single_value->field_tI__ExtBit.log_match(match_value.tI__ExtBit(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tI_Value := ");
single_value->field_tI__Value.log_match(match_value.tI__Value(), legacy);
TTCN_Logger::log_event_str(", tI_ExtBit := ");
single_value->field_tI__ExtBit.log_match(match_value.tI__ExtBit(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void TI__Extension_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tI__Value().is_bound()) tI__Value().set_implicit_omit();
if (tI__ExtBit().is_bound()) tI__ExtBit().set_implicit_omit();
}

void TI__Extension_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tI__Value.encode_text(text_buf);
single_value->field_tI__ExtBit.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TI_Extension.");
}
}

void TI__Extension_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tI__Value.decode_text(text_buf);
single_value->field_tI__ExtBit.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new TI__Extension_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.TI_Extension.");
}
}

void TI__Extension_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    TI__Extension_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.TI_Extension has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tI__Value().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tI__ExtBit().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tI_Value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tI__Value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tI_ExtBit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tI__ExtBit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.TI_Extension: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    TI__Extension_template* precondition = new TI__Extension_template;
    precondition->set_param(*param.get_elem(0));
    TI__Extension_template* implied_template = new TI__Extension_template;
    implied_template->set_param(*param.get_elem(1));
    *this = TI__Extension_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.TI_Extension");
  }
  is_ifpresent = param.get_ifpresent();
}

void TI__Extension_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tI__Value.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TI_Extension");
single_value->field_tI__ExtBit.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TI_Extension");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.TI_Extension");
}

boolean TI__Extension_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean TI__Extension_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

LinkedTILV::LinkedTILV()
{
}

LinkedTILV::LinkedTILV(const INTEGER& par_lengthIndicator,
    const LinkedTIV& par_valueField)
  :   field_lengthIndicator(par_lengthIndicator),
  field_valueField(par_valueField)
{
}

LinkedTILV::LinkedTILV(const LinkedTILV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.LinkedTILV.");
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
else field_valueField.clean_up();
}

void LinkedTILV::clean_up()
{
field_lengthIndicator.clean_up();
field_valueField.clean_up();
}

const TTCN_Typedescriptor_t* LinkedTILV::get_descriptor() const { return &LinkedTILV_descr_; }
LinkedTILV& LinkedTILV::operator=(const LinkedTILV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.LinkedTILV.");
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
  else field_valueField.clean_up();
}
return *this;
}

boolean LinkedTILV::operator==(const LinkedTILV& other_value) const
{
return field_lengthIndicator==other_value.field_lengthIndicator
  && field_valueField==other_value.field_valueField;
}

boolean LinkedTILV::is_bound() const
{
return (field_lengthIndicator.is_bound())
  || (field_valueField.is_bound());
}
boolean LinkedTILV::is_value() const
{
return field_lengthIndicator.is_value()
  && field_valueField.is_value();
}
void LinkedTILV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", valueField := ");
field_valueField.log();
TTCN_Logger::log_event_str(" }");
}

void LinkedTILV::set_implicit_omit()
{
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (valueField().is_bound()) valueField().set_implicit_omit();
}

void LinkedTILV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.LinkedTILV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LinkedTILV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.LinkedTILV");
  }
}

void LinkedTILV::encode_text(Text_Buf& text_buf) const
{
field_lengthIndicator.encode_text(text_buf);
field_valueField.encode_text(text_buf);
}

void LinkedTILV::decode_text(Text_Buf& text_buf)
{
field_lengthIndicator.decode_text(text_buf);
field_valueField.decode_text(text_buf);
}

void LinkedTILV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LinkedTILV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int LinkedTILV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, LinkedTILV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(LinkedTILV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_lengthIndicator.convert_to_Integer(LinkedTILV_lengthIndicator_descr_);
  field_lengthIndicator = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, LinkedTIV_descr_.raw->forceomit);
  decoded_field_length = field_valueField.RAW_decode(LinkedTIV_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int LinkedTILV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, LinkedTILV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, LinkedTIV_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &LinkedTILV_lengthIndicator_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_valueField.RAW_encode(LinkedTIV_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct LinkedTILV_template::single_value_struct {
INTEGER_template field_lengthIndicator;
LinkedTIV_template field_valueField;
};

void LinkedTILV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_valueField = ANY_VALUE;
}
}
}

void LinkedTILV_template::copy_value(const LinkedTILV& other_value)
{
single_value = new single_value_struct;
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.valueField().is_bound()) {
  single_value->field_valueField = other_value.valueField();
} else {
  single_value->field_valueField.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void LinkedTILV_template::copy_template(const LinkedTILV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.valueField().get_selection()) {
single_value->field_valueField = other_value.valueField();
} else {
single_value->field_valueField.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new LinkedTILV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new LinkedTILV_template(*other_value.implication_.precondition);
implication_.implied_template = new LinkedTILV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
break;
}
set_selection(other_value);
}

LinkedTILV_template::LinkedTILV_template()
{
}

LinkedTILV_template::LinkedTILV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

LinkedTILV_template::LinkedTILV_template(const LinkedTILV& other_value)
{
copy_value(other_value);
}

LinkedTILV_template::LinkedTILV_template(const OPTIONAL<LinkedTILV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LinkedTILV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.LinkedTILV from an unbound optional field.");
}
}

LinkedTILV_template::LinkedTILV_template(LinkedTILV_template* p_precondition, LinkedTILV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

LinkedTILV_template::LinkedTILV_template(Dynamic_Match_Interface<LinkedTILV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<LinkedTILV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

LinkedTILV_template::LinkedTILV_template(const LinkedTILV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

LinkedTILV_template::~LinkedTILV_template()
{
clean_up();
}

LinkedTILV_template& LinkedTILV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

LinkedTILV_template& LinkedTILV_template::operator=(const LinkedTILV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

LinkedTILV_template& LinkedTILV_template::operator=(const OPTIONAL<LinkedTILV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LinkedTILV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
}
return *this;
}

LinkedTILV_template& LinkedTILV_template::operator=(const LinkedTILV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean LinkedTILV_template::match(const LinkedTILV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.valueField().is_bound()) return FALSE;
if(!single_value->field_valueField.match(other_value.valueField(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
}
return FALSE;
}

boolean LinkedTILV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lengthIndicator.is_bound()
 || single_value->field_valueField.is_bound();
}

boolean LinkedTILV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lengthIndicator.is_value()
 && single_value->field_valueField.is_value();
}

void LinkedTILV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

LinkedTILV LinkedTILV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
LinkedTILV ret_val;
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_valueField.is_bound()) {
ret_val.valueField() = single_value->field_valueField.valueof();
}
return ret_val;
}

void LinkedTILV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new LinkedTILV_template[list_length];
}

LinkedTILV_template& LinkedTILV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
return value_list.list_value[list_index];
}

INTEGER_template& LinkedTILV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& LinkedTILV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
return single_value->field_lengthIndicator;
}

LinkedTIV_template& LinkedTILV_template::valueField()
{
set_specific();
return single_value->field_valueField;
}

const LinkedTIV_template& LinkedTILV_template::valueField() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field valueField of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
return single_value->field_valueField;
}

int LinkedTILV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
  }
  return 0;
}

void LinkedTILV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", valueField := ");
single_value->field_valueField.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void LinkedTILV_template::log_match(const LinkedTILV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_valueField.match(match_value.valueField(), legacy)){
TTCN_Logger::log_logmatch_info(".valueField");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", valueField := ");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void LinkedTILV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (valueField().is_bound()) valueField().set_implicit_omit();
}

void LinkedTILV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_valueField.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
}
}

void LinkedTILV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_valueField.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new LinkedTILV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
}
}

void LinkedTILV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    LinkedTILV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.LinkedTILV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LinkedTILV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    LinkedTILV_template* precondition = new LinkedTILV_template;
    precondition->set_param(*param.get_elem(0));
    LinkedTILV_template* implied_template = new LinkedTILV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = LinkedTILV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.LinkedTILV");
  }
  is_ifpresent = param.get_ifpresent();
}

void LinkedTILV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTILV");
single_value->field_valueField.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTILV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTILV");
}

boolean LinkedTILV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean LinkedTILV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

LinkedTITLV::LinkedTITLV()
{
}

LinkedTITLV::LinkedTITLV(const OCTETSTRING& par_elementIdentifier,
    const LinkedTILV& par_linkedTILV)
  :   field_elementIdentifier(par_elementIdentifier),
  field_linkedTILV(par_linkedTILV)
{
}

LinkedTITLV::LinkedTITLV(const LinkedTITLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.linkedTILV().is_bound()) field_linkedTILV = other_value.linkedTILV();
else field_linkedTILV.clean_up();
}

void LinkedTITLV::clean_up()
{
field_elementIdentifier.clean_up();
field_linkedTILV.clean_up();
}

const TTCN_Typedescriptor_t* LinkedTITLV::get_descriptor() const { return &LinkedTITLV_descr_; }
LinkedTITLV& LinkedTITLV::operator=(const LinkedTITLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.linkedTILV().is_bound()) field_linkedTILV = other_value.linkedTILV();
  else field_linkedTILV.clean_up();
}
return *this;
}

boolean LinkedTITLV::operator==(const LinkedTITLV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_linkedTILV==other_value.field_linkedTILV;
}

boolean LinkedTITLV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_linkedTILV.is_bound());
}
boolean LinkedTITLV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_linkedTILV.is_value();
}
void LinkedTITLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", linkedTILV := ");
field_linkedTILV.log();
TTCN_Logger::log_event_str(" }");
}

void LinkedTITLV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (linkedTILV().is_bound()) linkedTILV().set_implicit_omit();
}

void LinkedTITLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.LinkedTITLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) linkedTILV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "linkedTILV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          linkedTILV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LinkedTITLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.LinkedTITLV");
  }
}

void LinkedTITLV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_linkedTILV.encode_text(text_buf);
}

void LinkedTITLV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_linkedTILV.decode_text(text_buf);
}

void LinkedTITLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LinkedTITLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int LinkedTITLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, LinkedTILV_descr_.raw->forceomit);
  decoded_field_length = field_linkedTILV.RAW_decode(LinkedTILV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int LinkedTITLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, LinkedTILV_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_linkedTILV.RAW_encode(LinkedTILV_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct LinkedTITLV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
LinkedTILV_template field_linkedTILV;
};

void LinkedTITLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_linkedTILV = ANY_VALUE;
}
}
}

void LinkedTITLV_template::copy_value(const LinkedTITLV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.linkedTILV().is_bound()) {
  single_value->field_linkedTILV = other_value.linkedTILV();
} else {
  single_value->field_linkedTILV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void LinkedTITLV_template::copy_template(const LinkedTITLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.linkedTILV().get_selection()) {
single_value->field_linkedTILV = other_value.linkedTILV();
} else {
single_value->field_linkedTILV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new LinkedTITLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new LinkedTITLV_template(*other_value.implication_.precondition);
implication_.implied_template = new LinkedTITLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
break;
}
set_selection(other_value);
}

LinkedTITLV_template::LinkedTITLV_template()
{
}

LinkedTITLV_template::LinkedTITLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

LinkedTITLV_template::LinkedTITLV_template(const LinkedTITLV& other_value)
{
copy_value(other_value);
}

LinkedTITLV_template::LinkedTITLV_template(const OPTIONAL<LinkedTITLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LinkedTITLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.LinkedTITLV from an unbound optional field.");
}
}

LinkedTITLV_template::LinkedTITLV_template(LinkedTITLV_template* p_precondition, LinkedTITLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

LinkedTITLV_template::LinkedTITLV_template(Dynamic_Match_Interface<LinkedTITLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<LinkedTITLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

LinkedTITLV_template::LinkedTITLV_template(const LinkedTITLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

LinkedTITLV_template::~LinkedTITLV_template()
{
clean_up();
}

LinkedTITLV_template& LinkedTITLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

LinkedTITLV_template& LinkedTITLV_template::operator=(const LinkedTITLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

LinkedTITLV_template& LinkedTITLV_template::operator=(const OPTIONAL<LinkedTITLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LinkedTITLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
}
return *this;
}

LinkedTITLV_template& LinkedTITLV_template::operator=(const LinkedTITLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean LinkedTITLV_template::match(const LinkedTITLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.linkedTILV().is_bound()) return FALSE;
if(!single_value->field_linkedTILV.match(other_value.linkedTILV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
}
return FALSE;
}

boolean LinkedTITLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_linkedTILV.is_bound();
}

boolean LinkedTITLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_linkedTILV.is_value();
}

void LinkedTITLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

LinkedTITLV LinkedTITLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
LinkedTITLV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_linkedTILV.is_bound()) {
ret_val.linkedTILV() = single_value->field_linkedTILV.valueof();
}
return ret_val;
}

void LinkedTITLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new LinkedTITLV_template[list_length];
}

LinkedTITLV_template& LinkedTITLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& LinkedTITLV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& LinkedTITLV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
return single_value->field_elementIdentifier;
}

LinkedTILV_template& LinkedTITLV_template::linkedTILV()
{
set_specific();
return single_value->field_linkedTILV;
}

const LinkedTILV_template& LinkedTITLV_template::linkedTILV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field linkedTILV of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
return single_value->field_linkedTILV;
}

int LinkedTITLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
  }
  return 0;
}

void LinkedTITLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", linkedTILV := ");
single_value->field_linkedTILV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void LinkedTITLV_template::log_match(const LinkedTITLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_linkedTILV.match(match_value.linkedTILV(), legacy)){
TTCN_Logger::log_logmatch_info(".linkedTILV");
single_value->field_linkedTILV.log_match(match_value.linkedTILV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", linkedTILV := ");
single_value->field_linkedTILV.log_match(match_value.linkedTILV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void LinkedTITLV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (linkedTILV().is_bound()) linkedTILV().set_implicit_omit();
}

void LinkedTITLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_linkedTILV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
}
}

void LinkedTITLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_linkedTILV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new LinkedTITLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
}
}

void LinkedTITLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    LinkedTITLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.LinkedTITLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) linkedTILV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "linkedTILV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          linkedTILV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LinkedTITLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    LinkedTITLV_template* precondition = new LinkedTITLV_template;
    precondition->set_param(*param.get_elem(0));
    LinkedTITLV_template* implied_template = new LinkedTITLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = LinkedTITLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.LinkedTITLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void LinkedTITLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTITLV");
single_value->field_linkedTILV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTITLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTITLV");
}

boolean LinkedTITLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean LinkedTITLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

LLC__SAPIV::LLC__SAPIV()
{
}

LLC__SAPIV::LLC__SAPIV(const BITSTRING& par_valueField,
    const BITSTRING& par_spare)
  :   field_valueField(par_valueField),
  field_spare(par_spare)
{
}

LLC__SAPIV::LLC__SAPIV(const LLC__SAPIV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
else field_valueField.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void LLC__SAPIV::clean_up()
{
field_valueField.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* LLC__SAPIV::get_descriptor() const { return &LLC__SAPIV_descr_; }
LLC__SAPIV& LLC__SAPIV::operator=(const LLC__SAPIV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
  if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
  else field_valueField.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean LLC__SAPIV::operator==(const LLC__SAPIV& other_value) const
{
return field_valueField==other_value.field_valueField
  && field_spare==other_value.field_spare;
}

boolean LLC__SAPIV::is_bound() const
{
return (field_valueField.is_bound())
  || (field_spare.is_bound());
}
boolean LLC__SAPIV::is_value() const
{
return field_valueField.is_value()
  && field_spare.is_value();
}
void LLC__SAPIV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ valueField := ");
field_valueField.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void LLC__SAPIV::set_implicit_omit()
{
if (valueField().is_bound()) valueField().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void LLC__SAPIV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.LLC_SAPIV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LLC_SAPIV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.LLC_SAPIV");
  }
}

void LLC__SAPIV::encode_text(Text_Buf& text_buf) const
{
field_valueField.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void LLC__SAPIV::decode_text(Text_Buf& text_buf)
{
field_valueField.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void LLC__SAPIV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LLC__SAPIV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int LLC__SAPIV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_valueField.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int LLC__SAPIV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT4_descr_.raw);
  encoded_length += field_valueField.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct LLC__SAPIV_template::single_value_struct {
BITSTRING_template field_valueField;
BITSTRING_template field_spare;
};

void LLC__SAPIV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_valueField = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void LLC__SAPIV_template::copy_value(const LLC__SAPIV& other_value)
{
single_value = new single_value_struct;
if (other_value.valueField().is_bound()) {
  single_value->field_valueField = other_value.valueField();
} else {
  single_value->field_valueField.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void LLC__SAPIV_template::copy_template(const LLC__SAPIV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.valueField().get_selection()) {
single_value->field_valueField = other_value.valueField();
} else {
single_value->field_valueField.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new LLC__SAPIV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new LLC__SAPIV_template(*other_value.implication_.precondition);
implication_.implied_template = new LLC__SAPIV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
break;
}
set_selection(other_value);
}

LLC__SAPIV_template::LLC__SAPIV_template()
{
}

LLC__SAPIV_template::LLC__SAPIV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

LLC__SAPIV_template::LLC__SAPIV_template(const LLC__SAPIV& other_value)
{
copy_value(other_value);
}

LLC__SAPIV_template::LLC__SAPIV_template(const OPTIONAL<LLC__SAPIV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LLC__SAPIV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV from an unbound optional field.");
}
}

LLC__SAPIV_template::LLC__SAPIV_template(LLC__SAPIV_template* p_precondition, LLC__SAPIV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

LLC__SAPIV_template::LLC__SAPIV_template(Dynamic_Match_Interface<LLC__SAPIV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<LLC__SAPIV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

LLC__SAPIV_template::LLC__SAPIV_template(const LLC__SAPIV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

LLC__SAPIV_template::~LLC__SAPIV_template()
{
clean_up();
}

LLC__SAPIV_template& LLC__SAPIV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

LLC__SAPIV_template& LLC__SAPIV_template::operator=(const LLC__SAPIV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

LLC__SAPIV_template& LLC__SAPIV_template::operator=(const OPTIONAL<LLC__SAPIV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LLC__SAPIV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
}
return *this;
}

LLC__SAPIV_template& LLC__SAPIV_template::operator=(const LLC__SAPIV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean LLC__SAPIV_template::match(const LLC__SAPIV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.valueField().is_bound()) return FALSE;
if(!single_value->field_valueField.match(other_value.valueField(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
}
return FALSE;
}

boolean LLC__SAPIV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_valueField.is_bound()
 || single_value->field_spare.is_bound();
}

boolean LLC__SAPIV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_valueField.is_value()
 && single_value->field_spare.is_value();
}

void LLC__SAPIV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

LLC__SAPIV LLC__SAPIV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
LLC__SAPIV ret_val;
if (single_value->field_valueField.is_bound()) {
ret_val.valueField() = single_value->field_valueField.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void LLC__SAPIV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new LLC__SAPIV_template[list_length];
}

LLC__SAPIV_template& LLC__SAPIV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
return value_list.list_value[list_index];
}

BITSTRING_template& LLC__SAPIV_template::valueField()
{
set_specific();
return single_value->field_valueField;
}

const BITSTRING_template& LLC__SAPIV_template::valueField() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field valueField of a non-specific template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
return single_value->field_valueField;
}

BITSTRING_template& LLC__SAPIV_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& LLC__SAPIV_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
return single_value->field_spare;
}

int LLC__SAPIV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
  }
  return 0;
}

void LLC__SAPIV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ valueField := ");
single_value->field_valueField.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void LLC__SAPIV_template::log_match(const LLC__SAPIV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_valueField.match(match_value.valueField(), legacy)){
TTCN_Logger::log_logmatch_info(".valueField");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ valueField := ");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void LLC__SAPIV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (valueField().is_bound()) valueField().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void LLC__SAPIV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_valueField.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
}
}

void LLC__SAPIV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_valueField.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new LLC__SAPIV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
}
}

void LLC__SAPIV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    LLC__SAPIV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.LLC_SAPIV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LLC_SAPIV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    LLC__SAPIV_template* precondition = new LLC__SAPIV_template;
    precondition->set_param(*param.get_elem(0));
    LLC__SAPIV_template* implied_template = new LLC__SAPIV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = LLC__SAPIV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.LLC_SAPIV");
  }
  is_ifpresent = param.get_ifpresent();
}

void LLC__SAPIV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_valueField.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LLC_SAPIV");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LLC_SAPIV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.LLC_SAPIV");
}

boolean LLC__SAPIV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean LLC__SAPIV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

LLC__SAPITV::LLC__SAPITV()
{
}

LLC__SAPITV::LLC__SAPITV(const OCTETSTRING& par_elementIdentifier,
    const LLC__SAPIV& par_valueField)
  :   field_elementIdentifier(par_elementIdentifier),
  field_valueField(par_valueField)
{
}

LLC__SAPITV::LLC__SAPITV(const LLC__SAPITV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
else field_valueField.clean_up();
}

void LLC__SAPITV::clean_up()
{
field_elementIdentifier.clean_up();
field_valueField.clean_up();
}

const TTCN_Typedescriptor_t* LLC__SAPITV::get_descriptor() const { return &LLC__SAPITV_descr_; }
LLC__SAPITV& LLC__SAPITV::operator=(const LLC__SAPITV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
  else field_valueField.clean_up();
}
return *this;
}

boolean LLC__SAPITV::operator==(const LLC__SAPITV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_valueField==other_value.field_valueField;
}

boolean LLC__SAPITV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_valueField.is_bound());
}
boolean LLC__SAPITV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_valueField.is_value();
}
void LLC__SAPITV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", valueField := ");
field_valueField.log();
TTCN_Logger::log_event_str(" }");
}

void LLC__SAPITV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (valueField().is_bound()) valueField().set_implicit_omit();
}

void LLC__SAPITV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.LLC_SAPITV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LLC_SAPITV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.LLC_SAPITV");
  }
}

void LLC__SAPITV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_valueField.encode_text(text_buf);
}

void LLC__SAPITV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_valueField.decode_text(text_buf);
}

void LLC__SAPITV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LLC__SAPITV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int LLC__SAPITV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, LLC__SAPIV_descr_.raw->forceomit);
  decoded_field_length = field_valueField.RAW_decode(LLC__SAPIV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_18) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int LLC__SAPITV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, LLC__SAPIV_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_valueField.RAW_encode(LLC__SAPIV_descr_, *myleaf.body.node.nodes[1]);
  if (field_elementIdentifier !=  os_18) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_18.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct LLC__SAPITV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
LLC__SAPIV_template field_valueField;
};

void LLC__SAPITV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_valueField = ANY_VALUE;
}
}
}

void LLC__SAPITV_template::copy_value(const LLC__SAPITV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.valueField().is_bound()) {
  single_value->field_valueField = other_value.valueField();
} else {
  single_value->field_valueField.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void LLC__SAPITV_template::copy_template(const LLC__SAPITV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.valueField().get_selection()) {
single_value->field_valueField = other_value.valueField();
} else {
single_value->field_valueField.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new LLC__SAPITV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new LLC__SAPITV_template(*other_value.implication_.precondition);
implication_.implied_template = new LLC__SAPITV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
break;
}
set_selection(other_value);
}

LLC__SAPITV_template::LLC__SAPITV_template()
{
}

LLC__SAPITV_template::LLC__SAPITV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

LLC__SAPITV_template::LLC__SAPITV_template(const LLC__SAPITV& other_value)
{
copy_value(other_value);
}

LLC__SAPITV_template::LLC__SAPITV_template(const OPTIONAL<LLC__SAPITV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LLC__SAPITV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.LLC_SAPITV from an unbound optional field.");
}
}

LLC__SAPITV_template::LLC__SAPITV_template(LLC__SAPITV_template* p_precondition, LLC__SAPITV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

LLC__SAPITV_template::LLC__SAPITV_template(Dynamic_Match_Interface<LLC__SAPITV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<LLC__SAPITV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

LLC__SAPITV_template::LLC__SAPITV_template(const LLC__SAPITV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

LLC__SAPITV_template::~LLC__SAPITV_template()
{
clean_up();
}

LLC__SAPITV_template& LLC__SAPITV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

LLC__SAPITV_template& LLC__SAPITV_template::operator=(const LLC__SAPITV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

LLC__SAPITV_template& LLC__SAPITV_template::operator=(const OPTIONAL<LLC__SAPITV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LLC__SAPITV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
}
return *this;
}

LLC__SAPITV_template& LLC__SAPITV_template::operator=(const LLC__SAPITV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean LLC__SAPITV_template::match(const LLC__SAPITV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.valueField().is_bound()) return FALSE;
if(!single_value->field_valueField.match(other_value.valueField(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
}
return FALSE;
}

boolean LLC__SAPITV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_valueField.is_bound();
}

boolean LLC__SAPITV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_valueField.is_value();
}

void LLC__SAPITV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

LLC__SAPITV LLC__SAPITV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
LLC__SAPITV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_valueField.is_bound()) {
ret_val.valueField() = single_value->field_valueField.valueof();
}
return ret_val;
}

void LLC__SAPITV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new LLC__SAPITV_template[list_length];
}

LLC__SAPITV_template& LLC__SAPITV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& LLC__SAPITV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& LLC__SAPITV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
return single_value->field_elementIdentifier;
}

LLC__SAPIV_template& LLC__SAPITV_template::valueField()
{
set_specific();
return single_value->field_valueField;
}

const LLC__SAPIV_template& LLC__SAPITV_template::valueField() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field valueField of a non-specific template of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
return single_value->field_valueField;
}

int LLC__SAPITV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPITV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPITV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPITV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPITV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPITV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPITV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPITV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPITV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPITV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
  }
  return 0;
}

void LLC__SAPITV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", valueField := ");
single_value->field_valueField.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void LLC__SAPITV_template::log_match(const LLC__SAPITV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_valueField.match(match_value.valueField(), legacy)){
TTCN_Logger::log_logmatch_info(".valueField");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", valueField := ");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void LLC__SAPITV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (valueField().is_bound()) valueField().set_implicit_omit();
}

void LLC__SAPITV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_valueField.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
}
}

void LLC__SAPITV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_valueField.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new LLC__SAPITV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
}
}

void LLC__SAPITV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    LLC__SAPITV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.LLC_SAPITV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LLC_SAPITV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    LLC__SAPITV_template* precondition = new LLC__SAPITV_template;
    precondition->set_param(*param.get_elem(0));
    LLC__SAPITV_template* implied_template = new LLC__SAPITV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = LLC__SAPITV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.LLC_SAPITV");
  }
  is_ifpresent = param.get_ifpresent();
}

void LLC__SAPITV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LLC_SAPITV");
single_value->field_valueField.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LLC_SAPITV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.LLC_SAPITV");
}

boolean LLC__SAPITV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean LLC__SAPITV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

TearDownIndicatorV::TearDownIndicatorV()
{
}

TearDownIndicatorV::TearDownIndicatorV(const BITSTRING& par_tdi__flag,
    const BITSTRING& par_spare)
  :   field_tdi__flag(par_tdi__flag),
  field_spare(par_spare)
{
}

TearDownIndicatorV::TearDownIndicatorV(const TearDownIndicatorV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
if (other_value.tdi__flag().is_bound()) field_tdi__flag = other_value.tdi__flag();
else field_tdi__flag.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void TearDownIndicatorV::clean_up()
{
field_tdi__flag.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* TearDownIndicatorV::get_descriptor() const { return &TearDownIndicatorV_descr_; }
TearDownIndicatorV& TearDownIndicatorV::operator=(const TearDownIndicatorV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
  if (other_value.tdi__flag().is_bound()) field_tdi__flag = other_value.tdi__flag();
  else field_tdi__flag.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean TearDownIndicatorV::operator==(const TearDownIndicatorV& other_value) const
{
return field_tdi__flag==other_value.field_tdi__flag
  && field_spare==other_value.field_spare;
}

boolean TearDownIndicatorV::is_bound() const
{
return (field_tdi__flag.is_bound())
  || (field_spare.is_bound());
}
boolean TearDownIndicatorV::is_value() const
{
return field_tdi__flag.is_value()
  && field_spare.is_value();
}
void TearDownIndicatorV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tdi_flag := ");
field_tdi__flag.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void TearDownIndicatorV::set_implicit_omit()
{
if (tdi__flag().is_bound()) tdi__flag().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void TearDownIndicatorV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.TearDownIndicatorV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tdi__flag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tdi_flag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tdi__flag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.TearDownIndicatorV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.TearDownIndicatorV");
  }
}

void TearDownIndicatorV::encode_text(Text_Buf& text_buf) const
{
field_tdi__flag.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void TearDownIndicatorV::decode_text(Text_Buf& text_buf)
{
field_tdi__flag.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void TearDownIndicatorV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void TearDownIndicatorV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int TearDownIndicatorV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_tdi__flag.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int TearDownIndicatorV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT3_descr_.raw);
  encoded_length += field_tdi__flag.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct TearDownIndicatorV_template::single_value_struct {
BITSTRING_template field_tdi__flag;
BITSTRING_template field_spare;
};

void TearDownIndicatorV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tdi__flag = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void TearDownIndicatorV_template::copy_value(const TearDownIndicatorV& other_value)
{
single_value = new single_value_struct;
if (other_value.tdi__flag().is_bound()) {
  single_value->field_tdi__flag = other_value.tdi__flag();
} else {
  single_value->field_tdi__flag.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void TearDownIndicatorV_template::copy_template(const TearDownIndicatorV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tdi__flag().get_selection()) {
single_value->field_tdi__flag = other_value.tdi__flag();
} else {
single_value->field_tdi__flag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new TearDownIndicatorV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new TearDownIndicatorV_template(*other_value.implication_.precondition);
implication_.implied_template = new TearDownIndicatorV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
break;
}
set_selection(other_value);
}

TearDownIndicatorV_template::TearDownIndicatorV_template()
{
}

TearDownIndicatorV_template::TearDownIndicatorV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

TearDownIndicatorV_template::TearDownIndicatorV_template(const TearDownIndicatorV& other_value)
{
copy_value(other_value);
}

TearDownIndicatorV_template::TearDownIndicatorV_template(const OPTIONAL<TearDownIndicatorV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TearDownIndicatorV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV from an unbound optional field.");
}
}

TearDownIndicatorV_template::TearDownIndicatorV_template(TearDownIndicatorV_template* p_precondition, TearDownIndicatorV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

TearDownIndicatorV_template::TearDownIndicatorV_template(Dynamic_Match_Interface<TearDownIndicatorV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<TearDownIndicatorV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

TearDownIndicatorV_template::TearDownIndicatorV_template(const TearDownIndicatorV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

TearDownIndicatorV_template::~TearDownIndicatorV_template()
{
clean_up();
}

TearDownIndicatorV_template& TearDownIndicatorV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

TearDownIndicatorV_template& TearDownIndicatorV_template::operator=(const TearDownIndicatorV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

TearDownIndicatorV_template& TearDownIndicatorV_template::operator=(const OPTIONAL<TearDownIndicatorV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TearDownIndicatorV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
}
return *this;
}

TearDownIndicatorV_template& TearDownIndicatorV_template::operator=(const TearDownIndicatorV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean TearDownIndicatorV_template::match(const TearDownIndicatorV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tdi__flag().is_bound()) return FALSE;
if(!single_value->field_tdi__flag.match(other_value.tdi__flag(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
}
return FALSE;
}

boolean TearDownIndicatorV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tdi__flag.is_bound()
 || single_value->field_spare.is_bound();
}

boolean TearDownIndicatorV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tdi__flag.is_value()
 && single_value->field_spare.is_value();
}

void TearDownIndicatorV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

TearDownIndicatorV TearDownIndicatorV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
TearDownIndicatorV ret_val;
if (single_value->field_tdi__flag.is_bound()) {
ret_val.tdi__flag() = single_value->field_tdi__flag.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void TearDownIndicatorV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new TearDownIndicatorV_template[list_length];
}

TearDownIndicatorV_template& TearDownIndicatorV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
return value_list.list_value[list_index];
}

BITSTRING_template& TearDownIndicatorV_template::tdi__flag()
{
set_specific();
return single_value->field_tdi__flag;
}

const BITSTRING_template& TearDownIndicatorV_template::tdi__flag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tdi_flag of a non-specific template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
return single_value->field_tdi__flag;
}

BITSTRING_template& TearDownIndicatorV_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& TearDownIndicatorV_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
return single_value->field_spare;
}

int TearDownIndicatorV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
  }
  return 0;
}

void TearDownIndicatorV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tdi_flag := ");
single_value->field_tdi__flag.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void TearDownIndicatorV_template::log_match(const TearDownIndicatorV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tdi__flag.match(match_value.tdi__flag(), legacy)){
TTCN_Logger::log_logmatch_info(".tdi_flag");
single_value->field_tdi__flag.log_match(match_value.tdi__flag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tdi_flag := ");
single_value->field_tdi__flag.log_match(match_value.tdi__flag(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void TearDownIndicatorV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tdi__flag().is_bound()) tdi__flag().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void TearDownIndicatorV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tdi__flag.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
}
}

void TearDownIndicatorV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tdi__flag.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new TearDownIndicatorV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV.");
}
}

void TearDownIndicatorV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    TearDownIndicatorV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.TearDownIndicatorV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tdi__flag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tdi_flag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tdi__flag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.TearDownIndicatorV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    TearDownIndicatorV_template* precondition = new TearDownIndicatorV_template;
    precondition->set_param(*param.get_elem(0));
    TearDownIndicatorV_template* implied_template = new TearDownIndicatorV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = TearDownIndicatorV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.TearDownIndicatorV");
  }
  is_ifpresent = param.get_ifpresent();
}

void TearDownIndicatorV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tdi__flag.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TearDownIndicatorV");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TearDownIndicatorV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.TearDownIndicatorV");
}

boolean TearDownIndicatorV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean TearDownIndicatorV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

TearDownIndicatorTV::TearDownIndicatorTV()
{
}

TearDownIndicatorTV::TearDownIndicatorTV(const TearDownIndicatorV& par_tearDownIndicatorV,
    const BITSTRING& par_elementIdentifier)
  :   field_tearDownIndicatorV(par_tearDownIndicatorV),
  field_elementIdentifier(par_elementIdentifier)
{
}

TearDownIndicatorTV::TearDownIndicatorTV(const TearDownIndicatorTV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
if (other_value.tearDownIndicatorV().is_bound()) field_tearDownIndicatorV = other_value.tearDownIndicatorV();
else field_tearDownIndicatorV.clean_up();
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
}

void TearDownIndicatorTV::clean_up()
{
field_tearDownIndicatorV.clean_up();
field_elementIdentifier.clean_up();
}

const TTCN_Typedescriptor_t* TearDownIndicatorTV::get_descriptor() const { return &TearDownIndicatorTV_descr_; }
TearDownIndicatorTV& TearDownIndicatorTV::operator=(const TearDownIndicatorTV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
  if (other_value.tearDownIndicatorV().is_bound()) field_tearDownIndicatorV = other_value.tearDownIndicatorV();
  else field_tearDownIndicatorV.clean_up();
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
}
return *this;
}

boolean TearDownIndicatorTV::operator==(const TearDownIndicatorTV& other_value) const
{
return field_tearDownIndicatorV==other_value.field_tearDownIndicatorV
  && field_elementIdentifier==other_value.field_elementIdentifier;
}

boolean TearDownIndicatorTV::is_bound() const
{
return (field_tearDownIndicatorV.is_bound())
  || (field_elementIdentifier.is_bound());
}
boolean TearDownIndicatorTV::is_value() const
{
return field_tearDownIndicatorV.is_value()
  && field_elementIdentifier.is_value();
}
void TearDownIndicatorTV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tearDownIndicatorV := ");
field_tearDownIndicatorV.log();
TTCN_Logger::log_event_str(", elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(" }");
}

void TearDownIndicatorTV::set_implicit_omit()
{
if (tearDownIndicatorV().is_bound()) tearDownIndicatorV().set_implicit_omit();
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
}

void TearDownIndicatorTV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tearDownIndicatorV().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tearDownIndicatorV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tearDownIndicatorV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.TearDownIndicatorTV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.TearDownIndicatorTV");
  }
}

void TearDownIndicatorTV::encode_text(Text_Buf& text_buf) const
{
field_tearDownIndicatorV.encode_text(text_buf);
field_elementIdentifier.encode_text(text_buf);
}

void TearDownIndicatorTV::decode_text(Text_Buf& text_buf)
{
field_tearDownIndicatorV.decode_text(text_buf);
field_elementIdentifier.decode_text(text_buf);
}

void TearDownIndicatorTV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void TearDownIndicatorTV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int TearDownIndicatorTV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, TearDownIndicatorV_descr_.raw->forceomit);
  decoded_field_length = field_tearDownIndicatorV.RAW_decode(TearDownIndicatorV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  bs_1) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int TearDownIndicatorTV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, TearDownIndicatorV_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT4_descr_.raw);
  encoded_length += field_tearDownIndicatorV.RAW_encode(TearDownIndicatorV_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[1]);
  if (field_elementIdentifier !=  bs_1) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_1.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct TearDownIndicatorTV_template::single_value_struct {
TearDownIndicatorV_template field_tearDownIndicatorV;
BITSTRING_template field_elementIdentifier;
};

void TearDownIndicatorTV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tearDownIndicatorV = ANY_VALUE;
single_value->field_elementIdentifier = ANY_VALUE;
}
}
}

void TearDownIndicatorTV_template::copy_value(const TearDownIndicatorTV& other_value)
{
single_value = new single_value_struct;
if (other_value.tearDownIndicatorV().is_bound()) {
  single_value->field_tearDownIndicatorV = other_value.tearDownIndicatorV();
} else {
  single_value->field_tearDownIndicatorV.clean_up();
}
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void TearDownIndicatorTV_template::copy_template(const TearDownIndicatorTV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tearDownIndicatorV().get_selection()) {
single_value->field_tearDownIndicatorV = other_value.tearDownIndicatorV();
} else {
single_value->field_tearDownIndicatorV.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new TearDownIndicatorTV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new TearDownIndicatorTV_template(*other_value.implication_.precondition);
implication_.implied_template = new TearDownIndicatorTV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
break;
}
set_selection(other_value);
}

TearDownIndicatorTV_template::TearDownIndicatorTV_template()
{
}

TearDownIndicatorTV_template::TearDownIndicatorTV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

TearDownIndicatorTV_template::TearDownIndicatorTV_template(const TearDownIndicatorTV& other_value)
{
copy_value(other_value);
}

TearDownIndicatorTV_template::TearDownIndicatorTV_template(const OPTIONAL<TearDownIndicatorTV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TearDownIndicatorTV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV from an unbound optional field.");
}
}

TearDownIndicatorTV_template::TearDownIndicatorTV_template(TearDownIndicatorTV_template* p_precondition, TearDownIndicatorTV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

TearDownIndicatorTV_template::TearDownIndicatorTV_template(Dynamic_Match_Interface<TearDownIndicatorTV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<TearDownIndicatorTV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

TearDownIndicatorTV_template::TearDownIndicatorTV_template(const TearDownIndicatorTV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

TearDownIndicatorTV_template::~TearDownIndicatorTV_template()
{
clean_up();
}

TearDownIndicatorTV_template& TearDownIndicatorTV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

TearDownIndicatorTV_template& TearDownIndicatorTV_template::operator=(const TearDownIndicatorTV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

TearDownIndicatorTV_template& TearDownIndicatorTV_template::operator=(const OPTIONAL<TearDownIndicatorTV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TearDownIndicatorTV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
}
return *this;
}

TearDownIndicatorTV_template& TearDownIndicatorTV_template::operator=(const TearDownIndicatorTV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean TearDownIndicatorTV_template::match(const TearDownIndicatorTV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tearDownIndicatorV().is_bound()) return FALSE;
if(!single_value->field_tearDownIndicatorV.match(other_value.tearDownIndicatorV(), legacy))return FALSE;
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
}
return FALSE;
}

boolean TearDownIndicatorTV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tearDownIndicatorV.is_bound()
 || single_value->field_elementIdentifier.is_bound();
}

boolean TearDownIndicatorTV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tearDownIndicatorV.is_value()
 && single_value->field_elementIdentifier.is_value();
}

void TearDownIndicatorTV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

TearDownIndicatorTV TearDownIndicatorTV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
TearDownIndicatorTV ret_val;
if (single_value->field_tearDownIndicatorV.is_bound()) {
ret_val.tearDownIndicatorV() = single_value->field_tearDownIndicatorV.valueof();
}
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
return ret_val;
}

void TearDownIndicatorTV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new TearDownIndicatorTV_template[list_length];
}

TearDownIndicatorTV_template& TearDownIndicatorTV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
return value_list.list_value[list_index];
}

TearDownIndicatorV_template& TearDownIndicatorTV_template::tearDownIndicatorV()
{
set_specific();
return single_value->field_tearDownIndicatorV;
}

const TearDownIndicatorV_template& TearDownIndicatorTV_template::tearDownIndicatorV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tearDownIndicatorV of a non-specific template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
return single_value->field_tearDownIndicatorV;
}

BITSTRING_template& TearDownIndicatorTV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const BITSTRING_template& TearDownIndicatorTV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
return single_value->field_elementIdentifier;
}

int TearDownIndicatorTV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
  }
  return 0;
}

void TearDownIndicatorTV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tearDownIndicatorV := ");
single_value->field_tearDownIndicatorV.log();
TTCN_Logger::log_event_str(", elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void TearDownIndicatorTV_template::log_match(const TearDownIndicatorTV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tearDownIndicatorV.match(match_value.tearDownIndicatorV(), legacy)){
TTCN_Logger::log_logmatch_info(".tearDownIndicatorV");
single_value->field_tearDownIndicatorV.log_match(match_value.tearDownIndicatorV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tearDownIndicatorV := ");
single_value->field_tearDownIndicatorV.log_match(match_value.tearDownIndicatorV(), legacy);
TTCN_Logger::log_event_str(", elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void TearDownIndicatorTV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tearDownIndicatorV().is_bound()) tearDownIndicatorV().set_implicit_omit();
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
}

void TearDownIndicatorTV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tearDownIndicatorV.encode_text(text_buf);
single_value->field_elementIdentifier.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
}
}

void TearDownIndicatorTV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tearDownIndicatorV.decode_text(text_buf);
single_value->field_elementIdentifier.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new TearDownIndicatorTV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV.");
}
}

void TearDownIndicatorTV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    TearDownIndicatorTV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.TearDownIndicatorTV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tearDownIndicatorV().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tearDownIndicatorV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tearDownIndicatorV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.TearDownIndicatorTV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    TearDownIndicatorTV_template* precondition = new TearDownIndicatorTV_template;
    precondition->set_param(*param.get_elem(0));
    TearDownIndicatorTV_template* implied_template = new TearDownIndicatorTV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = TearDownIndicatorTV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.TearDownIndicatorTV");
  }
  is_ifpresent = param.get_ifpresent();
}

void TearDownIndicatorTV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tearDownIndicatorV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TearDownIndicatorTV");
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TearDownIndicatorTV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.TearDownIndicatorTV");
}

boolean TearDownIndicatorTV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean TearDownIndicatorTV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PacketFlowIDV::PacketFlowIDV()
{
}

PacketFlowIDV::PacketFlowIDV(const BITSTRING& par_valueField,
    const BITSTRING& par_spare)
  :   field_valueField(par_valueField),
  field_spare(par_spare)
{
}

PacketFlowIDV::PacketFlowIDV(const PacketFlowIDV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
else field_valueField.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void PacketFlowIDV::clean_up()
{
field_valueField.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* PacketFlowIDV::get_descriptor() const { return &PacketFlowIDV_descr_; }
PacketFlowIDV& PacketFlowIDV::operator=(const PacketFlowIDV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
  if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
  else field_valueField.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean PacketFlowIDV::operator==(const PacketFlowIDV& other_value) const
{
return field_valueField==other_value.field_valueField
  && field_spare==other_value.field_spare;
}

boolean PacketFlowIDV::is_bound() const
{
return (field_valueField.is_bound())
  || (field_spare.is_bound());
}
boolean PacketFlowIDV::is_value() const
{
return field_valueField.is_value()
  && field_spare.is_value();
}
void PacketFlowIDV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ valueField := ");
field_valueField.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void PacketFlowIDV::set_implicit_omit()
{
if (valueField().is_bound()) valueField().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void PacketFlowIDV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PacketFlowIDV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PacketFlowIDV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PacketFlowIDV");
  }
}

void PacketFlowIDV::encode_text(Text_Buf& text_buf) const
{
field_valueField.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void PacketFlowIDV::decode_text(Text_Buf& text_buf)
{
field_valueField.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void PacketFlowIDV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketFlowIDV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketFlowIDV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_valueField.RAW_decode(General__Types::BIT7_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PacketFlowIDV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT7_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT1_descr_.raw);
  encoded_length += field_valueField.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct PacketFlowIDV_template::single_value_struct {
BITSTRING_template field_valueField;
BITSTRING_template field_spare;
};

void PacketFlowIDV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_valueField = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void PacketFlowIDV_template::copy_value(const PacketFlowIDV& other_value)
{
single_value = new single_value_struct;
if (other_value.valueField().is_bound()) {
  single_value->field_valueField = other_value.valueField();
} else {
  single_value->field_valueField.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PacketFlowIDV_template::copy_template(const PacketFlowIDV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.valueField().get_selection()) {
single_value->field_valueField = other_value.valueField();
} else {
single_value->field_valueField.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketFlowIDV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketFlowIDV_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketFlowIDV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
break;
}
set_selection(other_value);
}

PacketFlowIDV_template::PacketFlowIDV_template()
{
}

PacketFlowIDV_template::PacketFlowIDV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PacketFlowIDV_template::PacketFlowIDV_template(const PacketFlowIDV& other_value)
{
copy_value(other_value);
}

PacketFlowIDV_template::PacketFlowIDV_template(const OPTIONAL<PacketFlowIDV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketFlowIDV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PacketFlowIDV from an unbound optional field.");
}
}

PacketFlowIDV_template::PacketFlowIDV_template(PacketFlowIDV_template* p_precondition, PacketFlowIDV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketFlowIDV_template::PacketFlowIDV_template(Dynamic_Match_Interface<PacketFlowIDV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketFlowIDV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketFlowIDV_template::PacketFlowIDV_template(const PacketFlowIDV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PacketFlowIDV_template::~PacketFlowIDV_template()
{
clean_up();
}

PacketFlowIDV_template& PacketFlowIDV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketFlowIDV_template& PacketFlowIDV_template::operator=(const PacketFlowIDV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketFlowIDV_template& PacketFlowIDV_template::operator=(const OPTIONAL<PacketFlowIDV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketFlowIDV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
}
return *this;
}

PacketFlowIDV_template& PacketFlowIDV_template::operator=(const PacketFlowIDV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PacketFlowIDV_template::match(const PacketFlowIDV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.valueField().is_bound()) return FALSE;
if(!single_value->field_valueField.match(other_value.valueField(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
}
return FALSE;
}

boolean PacketFlowIDV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_valueField.is_bound()
 || single_value->field_spare.is_bound();
}

boolean PacketFlowIDV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_valueField.is_value()
 && single_value->field_spare.is_value();
}

void PacketFlowIDV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketFlowIDV PacketFlowIDV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
PacketFlowIDV ret_val;
if (single_value->field_valueField.is_bound()) {
ret_val.valueField() = single_value->field_valueField.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void PacketFlowIDV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PacketFlowIDV_template[list_length];
}

PacketFlowIDV_template& PacketFlowIDV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
return value_list.list_value[list_index];
}

BITSTRING_template& PacketFlowIDV_template::valueField()
{
set_specific();
return single_value->field_valueField;
}

const BITSTRING_template& PacketFlowIDV_template::valueField() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field valueField of a non-specific template of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
return single_value->field_valueField;
}

BITSTRING_template& PacketFlowIDV_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& PacketFlowIDV_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
return single_value->field_spare;
}

int PacketFlowIDV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
  }
  return 0;
}

void PacketFlowIDV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ valueField := ");
single_value->field_valueField.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PacketFlowIDV_template::log_match(const PacketFlowIDV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_valueField.match(match_value.valueField(), legacy)){
TTCN_Logger::log_logmatch_info(".valueField");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ valueField := ");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PacketFlowIDV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (valueField().is_bound()) valueField().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void PacketFlowIDV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_valueField.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
}
}

void PacketFlowIDV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_valueField.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PacketFlowIDV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PacketFlowIDV.");
}
}

void PacketFlowIDV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PacketFlowIDV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PacketFlowIDV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PacketFlowIDV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PacketFlowIDV_template* precondition = new PacketFlowIDV_template;
    precondition->set_param(*param.get_elem(0));
    PacketFlowIDV_template* implied_template = new PacketFlowIDV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PacketFlowIDV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PacketFlowIDV");
  }
  is_ifpresent = param.get_ifpresent();
}

void PacketFlowIDV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_valueField.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFlowIDV");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFlowIDV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFlowIDV");
}

boolean PacketFlowIDV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PacketFlowIDV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PacketFlowIDTLV::PacketFlowIDTLV()
{
}

PacketFlowIDTLV::PacketFlowIDTLV(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const PacketFlowIDV& par_valueField)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_valueField(par_valueField)
{
}

PacketFlowIDTLV::PacketFlowIDTLV(const PacketFlowIDTLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
else field_valueField.clean_up();
}

void PacketFlowIDTLV::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_valueField.clean_up();
}

const TTCN_Typedescriptor_t* PacketFlowIDTLV::get_descriptor() const { return &PacketFlowIDTLV_descr_; }
PacketFlowIDTLV& PacketFlowIDTLV::operator=(const PacketFlowIDTLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
  else field_valueField.clean_up();
}
return *this;
}

boolean PacketFlowIDTLV::operator==(const PacketFlowIDTLV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_valueField==other_value.field_valueField;
}

boolean PacketFlowIDTLV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_valueField.is_bound());
}
boolean PacketFlowIDTLV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_valueField.is_value();
}
void PacketFlowIDTLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", valueField := ");
field_valueField.log();
TTCN_Logger::log_event_str(" }");
}

void PacketFlowIDTLV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (valueField().is_bound()) valueField().set_implicit_omit();
}

void PacketFlowIDTLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PacketFlowIDTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PacketFlowIDTLV");
  }
}

void PacketFlowIDTLV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_valueField.encode_text(text_buf);
}

void PacketFlowIDTLV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_valueField.decode_text(text_buf);
}

void PacketFlowIDTLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketFlowIDTLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketFlowIDTLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, PacketFlowIDTLV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(PacketFlowIDTLV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(PacketFlowIDTLV_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, PacketFlowIDV_descr_.raw->forceomit);
  decoded_field_length = field_valueField.RAW_decode(PacketFlowIDV_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_19) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PacketFlowIDTLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PacketFlowIDTLV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, PacketFlowIDV_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &PacketFlowIDTLV_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_valueField.RAW_encode(PacketFlowIDV_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_19) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_19.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PacketFlowIDTLV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
PacketFlowIDV_template field_valueField;
};

void PacketFlowIDTLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_valueField = ANY_VALUE;
}
}
}

void PacketFlowIDTLV_template::copy_value(const PacketFlowIDTLV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.valueField().is_bound()) {
  single_value->field_valueField = other_value.valueField();
} else {
  single_value->field_valueField.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PacketFlowIDTLV_template::copy_template(const PacketFlowIDTLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.valueField().get_selection()) {
single_value->field_valueField = other_value.valueField();
} else {
single_value->field_valueField.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketFlowIDTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketFlowIDTLV_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketFlowIDTLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
break;
}
set_selection(other_value);
}

PacketFlowIDTLV_template::PacketFlowIDTLV_template()
{
}

PacketFlowIDTLV_template::PacketFlowIDTLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PacketFlowIDTLV_template::PacketFlowIDTLV_template(const PacketFlowIDTLV& other_value)
{
copy_value(other_value);
}

PacketFlowIDTLV_template::PacketFlowIDTLV_template(const OPTIONAL<PacketFlowIDTLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketFlowIDTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV from an unbound optional field.");
}
}

PacketFlowIDTLV_template::PacketFlowIDTLV_template(PacketFlowIDTLV_template* p_precondition, PacketFlowIDTLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketFlowIDTLV_template::PacketFlowIDTLV_template(Dynamic_Match_Interface<PacketFlowIDTLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketFlowIDTLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketFlowIDTLV_template::PacketFlowIDTLV_template(const PacketFlowIDTLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PacketFlowIDTLV_template::~PacketFlowIDTLV_template()
{
clean_up();
}

PacketFlowIDTLV_template& PacketFlowIDTLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketFlowIDTLV_template& PacketFlowIDTLV_template::operator=(const PacketFlowIDTLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketFlowIDTLV_template& PacketFlowIDTLV_template::operator=(const OPTIONAL<PacketFlowIDTLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketFlowIDTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
}
return *this;
}

PacketFlowIDTLV_template& PacketFlowIDTLV_template::operator=(const PacketFlowIDTLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PacketFlowIDTLV_template::match(const PacketFlowIDTLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.valueField().is_bound()) return FALSE;
if(!single_value->field_valueField.match(other_value.valueField(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
}
return FALSE;
}

boolean PacketFlowIDTLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_valueField.is_bound();
}

boolean PacketFlowIDTLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_valueField.is_value();
}

void PacketFlowIDTLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketFlowIDTLV PacketFlowIDTLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
PacketFlowIDTLV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_valueField.is_bound()) {
ret_val.valueField() = single_value->field_valueField.valueof();
}
return ret_val;
}

void PacketFlowIDTLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PacketFlowIDTLV_template[list_length];
}

PacketFlowIDTLV_template& PacketFlowIDTLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PacketFlowIDTLV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& PacketFlowIDTLV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
return single_value->field_elementIdentifier;
}

INTEGER_template& PacketFlowIDTLV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& PacketFlowIDTLV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
return single_value->field_lengthIndicator;
}

PacketFlowIDV_template& PacketFlowIDTLV_template::valueField()
{
set_specific();
return single_value->field_valueField;
}

const PacketFlowIDV_template& PacketFlowIDTLV_template::valueField() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field valueField of a non-specific template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
return single_value->field_valueField;
}

int PacketFlowIDTLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
  }
  return 0;
}

void PacketFlowIDTLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", valueField := ");
single_value->field_valueField.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PacketFlowIDTLV_template::log_match(const PacketFlowIDTLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_valueField.match(match_value.valueField(), legacy)){
TTCN_Logger::log_logmatch_info(".valueField");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", valueField := ");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PacketFlowIDTLV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (valueField().is_bound()) valueField().set_implicit_omit();
}

void PacketFlowIDTLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_valueField.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
}
}

void PacketFlowIDTLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_valueField.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PacketFlowIDTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV.");
}
}

void PacketFlowIDTLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PacketFlowIDTLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PacketFlowIDTLV has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PacketFlowIDTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PacketFlowIDTLV_template* precondition = new PacketFlowIDTLV_template;
    precondition->set_param(*param.get_elem(0));
    PacketFlowIDTLV_template* implied_template = new PacketFlowIDTLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PacketFlowIDTLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PacketFlowIDTLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void PacketFlowIDTLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFlowIDTLV");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFlowIDTLV");
single_value->field_valueField.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFlowIDTLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFlowIDTLV");
}

boolean PacketFlowIDTLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PacketFlowIDTLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void TrafficFlowTemplateV::copy_value(const TrafficFlowTemplateV& other_value)
{
switch (other_value.union_selection) {
case ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
field_trafficFlowTemplateV__CreateAddReplaceTFT = new TrafficFlowTemplateV__CreateAddReplaceTFT(*other_value.field_trafficFlowTemplateV__CreateAddReplaceTFT);
break;
case ALT_trafficFlowTemplateV__DeletePacketFilter:
field_trafficFlowTemplateV__DeletePacketFilter = new TrafficFlowTemplateV__DeletePacketFilter(*other_value.field_trafficFlowTemplateV__DeletePacketFilter);
break;
case ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation = new TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation(*other_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation);
break;
default:
TTCN_error("Assignment of an unbound union value of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
union_selection = other_value.union_selection;
}

TrafficFlowTemplateV::TrafficFlowTemplateV()
{
union_selection = UNBOUND_VALUE;
}

TrafficFlowTemplateV::TrafficFlowTemplateV(const TrafficFlowTemplateV& other_value)
: Base_Type(){
copy_value(other_value);
}

TrafficFlowTemplateV::~TrafficFlowTemplateV()
{
clean_up();
}

TrafficFlowTemplateV& TrafficFlowTemplateV::operator=(const TrafficFlowTemplateV& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean TrafficFlowTemplateV::operator==(const TrafficFlowTemplateV& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
return *field_trafficFlowTemplateV__CreateAddReplaceTFT == *other_value.field_trafficFlowTemplateV__CreateAddReplaceTFT;
case ALT_trafficFlowTemplateV__DeletePacketFilter:
return *field_trafficFlowTemplateV__DeletePacketFilter == *other_value.field_trafficFlowTemplateV__DeletePacketFilter;
case ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
return *field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation == *other_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation;
default:
return FALSE;
}
}

TrafficFlowTemplateV__CreateAddReplaceTFT& TrafficFlowTemplateV::trafficFlowTemplateV__CreateAddReplaceTFT()
{
if (union_selection != ALT_trafficFlowTemplateV__CreateAddReplaceTFT) {
clean_up();
field_trafficFlowTemplateV__CreateAddReplaceTFT = new TrafficFlowTemplateV__CreateAddReplaceTFT;
union_selection = ALT_trafficFlowTemplateV__CreateAddReplaceTFT;
}
return *field_trafficFlowTemplateV__CreateAddReplaceTFT;
}

const TrafficFlowTemplateV__CreateAddReplaceTFT& TrafficFlowTemplateV::trafficFlowTemplateV__CreateAddReplaceTFT() const
{
if (union_selection != ALT_trafficFlowTemplateV__CreateAddReplaceTFT) TTCN_error("Using non-selected field trafficFlowTemplateV_CreateAddReplaceTFT in a value of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
return *field_trafficFlowTemplateV__CreateAddReplaceTFT;
}

TrafficFlowTemplateV__DeletePacketFilter& TrafficFlowTemplateV::trafficFlowTemplateV__DeletePacketFilter()
{
if (union_selection != ALT_trafficFlowTemplateV__DeletePacketFilter) {
clean_up();
field_trafficFlowTemplateV__DeletePacketFilter = new TrafficFlowTemplateV__DeletePacketFilter;
union_selection = ALT_trafficFlowTemplateV__DeletePacketFilter;
}
return *field_trafficFlowTemplateV__DeletePacketFilter;
}

const TrafficFlowTemplateV__DeletePacketFilter& TrafficFlowTemplateV::trafficFlowTemplateV__DeletePacketFilter() const
{
if (union_selection != ALT_trafficFlowTemplateV__DeletePacketFilter) TTCN_error("Using non-selected field trafficFlowTemplateV_DeletePacketFilter in a value of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
return *field_trafficFlowTemplateV__DeletePacketFilter;
}

TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation& TrafficFlowTemplateV::trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation()
{
if (union_selection != ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation) {
clean_up();
field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation = new TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation;
union_selection = ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation;
}
return *field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation;
}

const TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation& TrafficFlowTemplateV::trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation() const
{
if (union_selection != ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation) TTCN_error("Using non-selected field trafficFlowTemplateV_Delete_Existing_TFT_or_No_TFT_Operation in a value of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
return *field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation;
}

boolean TrafficFlowTemplateV::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
return union_selection == checked_selection;
}

boolean TrafficFlowTemplateV::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean TrafficFlowTemplateV::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_trafficFlowTemplateV__CreateAddReplaceTFT: return field_trafficFlowTemplateV__CreateAddReplaceTFT->is_value();
case ALT_trafficFlowTemplateV__DeletePacketFilter: return field_trafficFlowTemplateV__DeletePacketFilter->is_value();
case ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation: return field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void TrafficFlowTemplateV::clean_up()
{
switch (union_selection) {
case ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
  delete field_trafficFlowTemplateV__CreateAddReplaceTFT;
  break;
case ALT_trafficFlowTemplateV__DeletePacketFilter:
  delete field_trafficFlowTemplateV__DeletePacketFilter;
  break;
case ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
  delete field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void TrafficFlowTemplateV::log() const
{
switch (union_selection) {
case ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
TTCN_Logger::log_event_str("{ trafficFlowTemplateV_CreateAddReplaceTFT := ");
field_trafficFlowTemplateV__CreateAddReplaceTFT->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_trafficFlowTemplateV__DeletePacketFilter:
TTCN_Logger::log_event_str("{ trafficFlowTemplateV_DeletePacketFilter := ");
field_trafficFlowTemplateV__DeletePacketFilter->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
TTCN_Logger::log_event_str("{ trafficFlowTemplateV_Delete_Existing_TFT_or_No_TFT_Operation := ");
field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void TrafficFlowTemplateV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "trafficFlowTemplateV_CreateAddReplaceTFT")) {
    trafficFlowTemplateV__CreateAddReplaceTFT().set_param(*mp_last);
    if (!trafficFlowTemplateV__CreateAddReplaceTFT().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "trafficFlowTemplateV_DeletePacketFilter")) {
    trafficFlowTemplateV__DeletePacketFilter().set_param(*mp_last);
    if (!trafficFlowTemplateV__DeletePacketFilter().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "trafficFlowTemplateV_Delete_Existing_TFT_or_No_TFT_Operation")) {
    trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation().set_param(*mp_last);
    if (!trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.", last_name);
}

void TrafficFlowTemplateV::set_implicit_omit()
{
switch (union_selection) {
case ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
field_trafficFlowTemplateV__CreateAddReplaceTFT->set_implicit_omit(); break;
case ALT_trafficFlowTemplateV__DeletePacketFilter:
field_trafficFlowTemplateV__DeletePacketFilter->set_implicit_omit(); break;
case ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->set_implicit_omit(); break;
default: break;
}
}

void TrafficFlowTemplateV::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
field_trafficFlowTemplateV__CreateAddReplaceTFT->encode_text(text_buf);
break;
case ALT_trafficFlowTemplateV__DeletePacketFilter:
field_trafficFlowTemplateV__DeletePacketFilter->encode_text(text_buf);
break;
case ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
}

void TrafficFlowTemplateV::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
trafficFlowTemplateV__CreateAddReplaceTFT().decode_text(text_buf);
break;
case ALT_trafficFlowTemplateV__DeletePacketFilter:
trafficFlowTemplateV__DeletePacketFilter().decode_text(text_buf);
break;
case ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
}

void TrafficFlowTemplateV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void TrafficFlowTemplateV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int TrafficFlowTemplateV::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, TrafficFlowTemplateV__CreateAddReplaceTFT_descr_.raw->forceomit);
      decoded_length = trafficFlowTemplateV__CreateAddReplaceTFT().RAW_decode(TrafficFlowTemplateV__CreateAddReplaceTFT_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, TrafficFlowTemplateV__DeletePacketFilter_descr_.raw->forceomit);
      decoded_length = trafficFlowTemplateV__DeletePacketFilter().RAW_decode(TrafficFlowTemplateV__DeletePacketFilter_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_descr_.raw->forceomit);
      decoded_length = trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation().RAW_decode(TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, TrafficFlowTemplateV__CreateAddReplaceTFT_descr_.raw->forceomit);
      decoded_length = trafficFlowTemplateV__CreateAddReplaceTFT().RAW_decode(TrafficFlowTemplateV__CreateAddReplaceTFT_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, TrafficFlowTemplateV__DeletePacketFilter_descr_.raw->forceomit);
      decoded_length = trafficFlowTemplateV__DeletePacketFilter().RAW_decode(TrafficFlowTemplateV__DeletePacketFilter_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_descr_.raw->forceomit);
      decoded_length = trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation().RAW_decode(TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int TrafficFlowTemplateV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  memset(myleaf.body.node.nodes, 0, 3 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, TrafficFlowTemplateV__CreateAddReplaceTFT_descr_.raw);
    encoded_length = field_trafficFlowTemplateV__CreateAddReplaceTFT->RAW_encode(TrafficFlowTemplateV__CreateAddReplaceTFT_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &TrafficFlowTemplateV__CreateAddReplaceTFT_descr_;
    break;
  case ALT_trafficFlowTemplateV__DeletePacketFilter:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, TrafficFlowTemplateV__DeletePacketFilter_descr_.raw);
    encoded_length = field_trafficFlowTemplateV__DeletePacketFilter->RAW_encode(TrafficFlowTemplateV__DeletePacketFilter_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &TrafficFlowTemplateV__DeletePacketFilter_descr_;
    break;
  case ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_descr_.raw);
    encoded_length = field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->RAW_encode(TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void TrafficFlowTemplateV_template::copy_value(const TrafficFlowTemplateV& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT = new TrafficFlowTemplateV__CreateAddReplaceTFT_template(other_value.trafficFlowTemplateV__CreateAddReplaceTFT());
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter:
single_value.field_trafficFlowTemplateV__DeletePacketFilter = new TrafficFlowTemplateV__DeletePacketFilter_template(other_value.trafficFlowTemplateV__DeletePacketFilter());
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation = new TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_template(other_value.trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
set_selection(SPECIFIC_VALUE);
}

void TrafficFlowTemplateV_template::copy_template(const TrafficFlowTemplateV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT = new TrafficFlowTemplateV__CreateAddReplaceTFT_template(*other_value.single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT);
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter:
single_value.field_trafficFlowTemplateV__DeletePacketFilter = new TrafficFlowTemplateV__DeletePacketFilter_template(*other_value.single_value.field_trafficFlowTemplateV__DeletePacketFilter);
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation = new TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_template(*other_value.single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new TrafficFlowTemplateV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new TrafficFlowTemplateV_template(*other_value.implication_.precondition);
implication_.implied_template = new TrafficFlowTemplateV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
set_selection(other_value);
}

TrafficFlowTemplateV_template::TrafficFlowTemplateV_template()
{
}

TrafficFlowTemplateV_template::TrafficFlowTemplateV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

TrafficFlowTemplateV_template::TrafficFlowTemplateV_template(const TrafficFlowTemplateV& other_value)
{
copy_value(other_value);
}

TrafficFlowTemplateV_template::TrafficFlowTemplateV_template(const OPTIONAL<TrafficFlowTemplateV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TrafficFlowTemplateV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV from an unbound optional field.");
}
}

TrafficFlowTemplateV_template::TrafficFlowTemplateV_template(TrafficFlowTemplateV_template* p_precondition, TrafficFlowTemplateV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

TrafficFlowTemplateV_template::TrafficFlowTemplateV_template(Dynamic_Match_Interface<TrafficFlowTemplateV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<TrafficFlowTemplateV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

TrafficFlowTemplateV_template::TrafficFlowTemplateV_template(const TrafficFlowTemplateV_template& other_value)
: Base_Template(){
copy_template(other_value);
}

TrafficFlowTemplateV_template::~TrafficFlowTemplateV_template()
{
clean_up();
}

void TrafficFlowTemplateV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
delete single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT;
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter:
delete single_value.field_trafficFlowTemplateV__DeletePacketFilter;
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
delete single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

TrafficFlowTemplateV_template& TrafficFlowTemplateV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

TrafficFlowTemplateV_template& TrafficFlowTemplateV_template::operator=(const TrafficFlowTemplateV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

TrafficFlowTemplateV_template& TrafficFlowTemplateV_template::operator=(const OPTIONAL<TrafficFlowTemplateV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TrafficFlowTemplateV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
return *this;
}

TrafficFlowTemplateV_template& TrafficFlowTemplateV_template::operator=(const TrafficFlowTemplateV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean TrafficFlowTemplateV_template::match(const TrafficFlowTemplateV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
TrafficFlowTemplateV::union_selection_type value_selection = other_value.get_selection();
if (value_selection == TrafficFlowTemplateV::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
return single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT->match(other_value.trafficFlowTemplateV__CreateAddReplaceTFT(), legacy);
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter:
return single_value.field_trafficFlowTemplateV__DeletePacketFilter->match(other_value.trafficFlowTemplateV__DeletePacketFilter(), legacy);
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
return single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->match(other_value.trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
return FALSE;
}

boolean TrafficFlowTemplateV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
return single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT->is_value();
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter:
return single_value.field_trafficFlowTemplateV__DeletePacketFilter->is_value();
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
return single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
}

TrafficFlowTemplateV TrafficFlowTemplateV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
TrafficFlowTemplateV ret_val;
switch (single_value.union_selection) {
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
ret_val.trafficFlowTemplateV__CreateAddReplaceTFT() = single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT->valueof();
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter:
ret_val.trafficFlowTemplateV__DeletePacketFilter() = single_value.field_trafficFlowTemplateV__DeletePacketFilter->valueof();
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
ret_val.trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation() = single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
return ret_val;
}

TrafficFlowTemplateV_template& TrafficFlowTemplateV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
return value_list.list_value[list_index];
}
void TrafficFlowTemplateV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new TrafficFlowTemplateV_template[list_length];
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template& TrafficFlowTemplateV_template::trafficFlowTemplateV__CreateAddReplaceTFT()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT = new TrafficFlowTemplateV__CreateAddReplaceTFT_template(ANY_VALUE);
else single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT = new TrafficFlowTemplateV__CreateAddReplaceTFT_template;
single_value.union_selection = TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT;
}

const TrafficFlowTemplateV__CreateAddReplaceTFT_template& TrafficFlowTemplateV_template::trafficFlowTemplateV__CreateAddReplaceTFT() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field trafficFlowTemplateV_CreateAddReplaceTFT in a non-specific template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
if (single_value.union_selection != TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT) TTCN_error("Accessing non-selected field trafficFlowTemplateV_CreateAddReplaceTFT in a template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
return *single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT;
}

TrafficFlowTemplateV__DeletePacketFilter_template& TrafficFlowTemplateV_template::trafficFlowTemplateV__DeletePacketFilter()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_trafficFlowTemplateV__DeletePacketFilter = new TrafficFlowTemplateV__DeletePacketFilter_template(ANY_VALUE);
else single_value.field_trafficFlowTemplateV__DeletePacketFilter = new TrafficFlowTemplateV__DeletePacketFilter_template;
single_value.union_selection = TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_trafficFlowTemplateV__DeletePacketFilter;
}

const TrafficFlowTemplateV__DeletePacketFilter_template& TrafficFlowTemplateV_template::trafficFlowTemplateV__DeletePacketFilter() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field trafficFlowTemplateV_DeletePacketFilter in a non-specific template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
if (single_value.union_selection != TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter) TTCN_error("Accessing non-selected field trafficFlowTemplateV_DeletePacketFilter in a template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
return *single_value.field_trafficFlowTemplateV__DeletePacketFilter;
}

TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_template& TrafficFlowTemplateV_template::trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation = new TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_template(ANY_VALUE);
else single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation = new TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_template;
single_value.union_selection = TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation;
}

const TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_template& TrafficFlowTemplateV_template::trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field trafficFlowTemplateV_Delete_Existing_TFT_or_No_TFT_Operation in a non-specific template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
if (single_value.union_selection != TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation) TTCN_error("Accessing non-selected field trafficFlowTemplateV_Delete_Existing_TFT_or_No_TFT_Operation in a template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
return *single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation;
}

boolean TrafficFlowTemplateV_template::ischosen(TrafficFlowTemplateV::union_selection_type checked_selection) const
{
if (checked_selection == TrafficFlowTemplateV::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == TrafficFlowTemplateV::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void TrafficFlowTemplateV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
TTCN_Logger::log_event_str("{ trafficFlowTemplateV_CreateAddReplaceTFT := ");
single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT->log();
TTCN_Logger::log_event_str(" }");
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter:
TTCN_Logger::log_event_str("{ trafficFlowTemplateV_DeletePacketFilter := ");
single_value.field_trafficFlowTemplateV__DeletePacketFilter->log();
TTCN_Logger::log_event_str(" }");
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
TTCN_Logger::log_event_str("{ trafficFlowTemplateV_Delete_Existing_TFT_or_No_TFT_Operation := ");
single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void TrafficFlowTemplateV_template::log_match(const TrafficFlowTemplateV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".trafficFlowTemplateV_CreateAddReplaceTFT");
single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT->log_match(match_value.trafficFlowTemplateV__CreateAddReplaceTFT(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ trafficFlowTemplateV_CreateAddReplaceTFT := ");
single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT->log_match(match_value.trafficFlowTemplateV__CreateAddReplaceTFT(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".trafficFlowTemplateV_DeletePacketFilter");
single_value.field_trafficFlowTemplateV__DeletePacketFilter->log_match(match_value.trafficFlowTemplateV__DeletePacketFilter(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ trafficFlowTemplateV_DeletePacketFilter := ");
single_value.field_trafficFlowTemplateV__DeletePacketFilter->log_match(match_value.trafficFlowTemplateV__DeletePacketFilter(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".trafficFlowTemplateV_Delete_Existing_TFT_or_No_TFT_Operation");
single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->log_match(match_value.trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ trafficFlowTemplateV_Delete_Existing_TFT_or_No_TFT_Operation := ");
single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->log_match(match_value.trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void TrafficFlowTemplateV_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT->set_implicit_omit(); break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter:
single_value.field_trafficFlowTemplateV__DeletePacketFilter->set_implicit_omit(); break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->set_implicit_omit(); break;
default: break;
}
}

void TrafficFlowTemplateV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT->encode_text(text_buf);
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter:
single_value.field_trafficFlowTemplateV__DeletePacketFilter->encode_text(text_buf);
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
}

void TrafficFlowTemplateV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = TrafficFlowTemplateV::UNBOUND_VALUE;
TrafficFlowTemplateV::union_selection_type new_selection = (TrafficFlowTemplateV::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT = new TrafficFlowTemplateV__CreateAddReplaceTFT_template;
single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT->decode_text(text_buf);
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter:
single_value.field_trafficFlowTemplateV__DeletePacketFilter = new TrafficFlowTemplateV__DeletePacketFilter_template;
single_value.field_trafficFlowTemplateV__DeletePacketFilter->decode_text(text_buf);
break;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation = new TrafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation_template;
single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new TrafficFlowTemplateV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
}

boolean TrafficFlowTemplateV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean TrafficFlowTemplateV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void TrafficFlowTemplateV_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@MobileL3_GMM_SM_Types.TrafficFlowTemplateV'");
    }
    if (strcmp("trafficFlowTemplateV_CreateAddReplaceTFT", param_field) == 0) {
      trafficFlowTemplateV__CreateAddReplaceTFT().set_param(param);
      return;
    } else if (strcmp("trafficFlowTemplateV_DeletePacketFilter", param_field) == 0) {
      trafficFlowTemplateV__DeletePacketFilter().set_param(param);
      return;
    } else if (strcmp("trafficFlowTemplateV_Delete_Existing_TFT_or_No_TFT_Operation", param_field) == 0) {
      trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@MobileL3_GMM_SM_Types.TrafficFlowTemplateV'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    TrafficFlowTemplateV_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "trafficFlowTemplateV_CreateAddReplaceTFT")) {
      trafficFlowTemplateV__CreateAddReplaceTFT().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "trafficFlowTemplateV_DeletePacketFilter")) {
      trafficFlowTemplateV__DeletePacketFilter().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "trafficFlowTemplateV_Delete_Existing_TFT_or_No_TFT_Operation")) {
      trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    TrafficFlowTemplateV_template* precondition = new TrafficFlowTemplateV_template;
    precondition->set_param(*m_p->get_elem(0));
    TrafficFlowTemplateV_template* implied_template = new TrafficFlowTemplateV_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = TrafficFlowTemplateV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV");
  }
  is_ifpresent = param.get_ifpresent();
}

void TrafficFlowTemplateV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__CreateAddReplaceTFT:
single_value.field_trafficFlowTemplateV__CreateAddReplaceTFT->check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV");
return;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__DeletePacketFilter:
single_value.field_trafficFlowTemplateV__DeletePacketFilter->check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV");
return;
case TrafficFlowTemplateV::ALT_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation:
single_value.field_trafficFlowTemplateV__Delete__Existing__TFT__or__No__TFT__Operation->check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV");
}


const PacketFilter PacketFilterList__CreateAddReplaceTFT::UNBOUND_ELEM;
PacketFilterList__CreateAddReplaceTFT::PacketFilterList__CreateAddReplaceTFT()
{
val_ptr = NULL;
}

PacketFilterList__CreateAddReplaceTFT::PacketFilterList__CreateAddReplaceTFT(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

PacketFilterList__CreateAddReplaceTFT::PacketFilterList__CreateAddReplaceTFT(const PacketFilterList__CreateAddReplaceTFT& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

PacketFilterList__CreateAddReplaceTFT::~PacketFilterList__CreateAddReplaceTFT()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void PacketFilterList__CreateAddReplaceTFT::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

PacketFilterList__CreateAddReplaceTFT& PacketFilterList__CreateAddReplaceTFT::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

PacketFilterList__CreateAddReplaceTFT& PacketFilterList__CreateAddReplaceTFT::operator=(const PacketFilterList__CreateAddReplaceTFT& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean PacketFilterList__CreateAddReplaceTFT::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
return val_ptr->n_elements == 0 ;
}

boolean PacketFilterList__CreateAddReplaceTFT::operator==(const PacketFilterList__CreateAddReplaceTFT& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

PacketFilter& PacketFilterList__CreateAddReplaceTFT::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (PacketFilter**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new PacketFilter(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new PacketFilter;
}
return *val_ptr->value_elements[index_value];
}

PacketFilter& PacketFilterList__CreateAddReplaceTFT::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
return (*this)[(int)index_value];
}

const PacketFilter& PacketFilterList__CreateAddReplaceTFT::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
if (index_value < 0) TTCN_error("Accessing an element of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const PacketFilter& PacketFilterList__CreateAddReplaceTFT::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
return (*this)[(int)index_value];
}

PacketFilterList__CreateAddReplaceTFT PacketFilterList__CreateAddReplaceTFT::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

PacketFilterList__CreateAddReplaceTFT PacketFilterList__CreateAddReplaceTFT::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

PacketFilterList__CreateAddReplaceTFT PacketFilterList__CreateAddReplaceTFT::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

PacketFilterList__CreateAddReplaceTFT PacketFilterList__CreateAddReplaceTFT::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
PacketFilterList__CreateAddReplaceTFT ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new PacketFilter(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

PacketFilterList__CreateAddReplaceTFT PacketFilterList__CreateAddReplaceTFT::operator+(const PacketFilterList__CreateAddReplaceTFT& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
PacketFilterList__CreateAddReplaceTFT ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new PacketFilter(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new PacketFilter(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

PacketFilterList__CreateAddReplaceTFT PacketFilterList__CreateAddReplaceTFT::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT","element");
PacketFilterList__CreateAddReplaceTFT ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new PacketFilter(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

PacketFilterList__CreateAddReplaceTFT PacketFilterList__CreateAddReplaceTFT::replace(int index, int len, const PacketFilterList__CreateAddReplaceTFT& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
check_replace_arguments(val_ptr->n_elements, index, len, "@MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT","element");
PacketFilterList__CreateAddReplaceTFT ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new PacketFilter(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new PacketFilter(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new PacketFilter(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

PacketFilterList__CreateAddReplaceTFT PacketFilterList__CreateAddReplaceTFT::replace(int index, int len, const PacketFilterList__CreateAddReplaceTFT_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void PacketFilterList__CreateAddReplaceTFT::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (PacketFilter**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new PacketFilter(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (PacketFilter**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (PacketFilter**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean PacketFilterList__CreateAddReplaceTFT::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int PacketFilterList__CreateAddReplaceTFT::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
return val_ptr->n_elements;
}

int PacketFilterList__CreateAddReplaceTFT::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void PacketFilterList__CreateAddReplaceTFT::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void PacketFilterList__CreateAddReplaceTFT::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void PacketFilterList__CreateAddReplaceTFT::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void PacketFilterList__CreateAddReplaceTFT::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void PacketFilterList__CreateAddReplaceTFT::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
val_ptr->value_elements = (PacketFilter**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new PacketFilter;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void PacketFilterList__CreateAddReplaceTFT::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketFilterList__CreateAddReplaceTFT::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketFilterList__CreateAddReplaceTFT::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int PacketFilterList__CreateAddReplaceTFT::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void PacketFilterList__CreateAddReplaceTFT_template::copy_value(const PacketFilterList__CreateAddReplaceTFT& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (PacketFilter_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new PacketFilter_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new PacketFilter_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void PacketFilterList__CreateAddReplaceTFT_template::copy_template(const PacketFilterList__CreateAddReplaceTFT_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (PacketFilter_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new PacketFilter_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new PacketFilter_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketFilterList__CreateAddReplaceTFT_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketFilterList__CreateAddReplaceTFT_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketFilterList__CreateAddReplaceTFT_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
break;
}
set_selection(other_value);
}

boolean PacketFilterList__CreateAddReplaceTFT_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const PacketFilterList__CreateAddReplaceTFT_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const PacketFilterList__CreateAddReplaceTFT*)value_ptr)[value_index], legacy);
else return ((const PacketFilterList__CreateAddReplaceTFT_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

PacketFilterList__CreateAddReplaceTFT_template::PacketFilterList__CreateAddReplaceTFT_template()
{
}

PacketFilterList__CreateAddReplaceTFT_template::PacketFilterList__CreateAddReplaceTFT_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

PacketFilterList__CreateAddReplaceTFT_template::PacketFilterList__CreateAddReplaceTFT_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

PacketFilterList__CreateAddReplaceTFT_template::PacketFilterList__CreateAddReplaceTFT_template(const PacketFilterList__CreateAddReplaceTFT& other_value)
{
copy_value(other_value);
}

PacketFilterList__CreateAddReplaceTFT_template::PacketFilterList__CreateAddReplaceTFT_template(const OPTIONAL<PacketFilterList__CreateAddReplaceTFT>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketFilterList__CreateAddReplaceTFT&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT from an unbound optional field.");
}
}

PacketFilterList__CreateAddReplaceTFT_template::PacketFilterList__CreateAddReplaceTFT_template(PacketFilterList__CreateAddReplaceTFT_template* p_precondition, PacketFilterList__CreateAddReplaceTFT_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketFilterList__CreateAddReplaceTFT_template::PacketFilterList__CreateAddReplaceTFT_template(Dynamic_Match_Interface<PacketFilterList__CreateAddReplaceTFT>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketFilterList__CreateAddReplaceTFT>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketFilterList__CreateAddReplaceTFT_template::PacketFilterList__CreateAddReplaceTFT_template(const PacketFilterList__CreateAddReplaceTFT_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

PacketFilterList__CreateAddReplaceTFT_template::~PacketFilterList__CreateAddReplaceTFT_template()
{
clean_up();
}

void PacketFilterList__CreateAddReplaceTFT_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketFilterList__CreateAddReplaceTFT_template& PacketFilterList__CreateAddReplaceTFT_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketFilterList__CreateAddReplaceTFT_template& PacketFilterList__CreateAddReplaceTFT_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

PacketFilterList__CreateAddReplaceTFT_template& PacketFilterList__CreateAddReplaceTFT_template::operator=(const PacketFilterList__CreateAddReplaceTFT& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketFilterList__CreateAddReplaceTFT_template& PacketFilterList__CreateAddReplaceTFT_template::operator=(const OPTIONAL<PacketFilterList__CreateAddReplaceTFT>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketFilterList__CreateAddReplaceTFT&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
}
return *this;
}

PacketFilterList__CreateAddReplaceTFT_template& PacketFilterList__CreateAddReplaceTFT_template::operator=(const PacketFilterList__CreateAddReplaceTFT_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

PacketFilter_template& PacketFilterList__CreateAddReplaceTFT_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
    break;
}
return *single_value.value_elements[index_value];
}

PacketFilter_template& PacketFilterList__CreateAddReplaceTFT_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
return (*this)[(int)index_value];
}

const PacketFilter_template& PacketFilterList__CreateAddReplaceTFT_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const PacketFilter_template& PacketFilterList__CreateAddReplaceTFT_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
return (*this)[(int)index_value];
}

void PacketFilterList__CreateAddReplaceTFT_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (PacketFilter_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new PacketFilter_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new PacketFilter_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (PacketFilter_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int PacketFilterList__CreateAddReplaceTFT_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int PacketFilterList__CreateAddReplaceTFT_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT");
}

boolean PacketFilterList__CreateAddReplaceTFT_template::match(const PacketFilterList__CreateAddReplaceTFT& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
}
return FALSE;
}

boolean PacketFilterList__CreateAddReplaceTFT_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

PacketFilterList__CreateAddReplaceTFT PacketFilterList__CreateAddReplaceTFT_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
PacketFilterList__CreateAddReplaceTFT ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

PacketFilterList__CreateAddReplaceTFT PacketFilterList__CreateAddReplaceTFT_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

PacketFilterList__CreateAddReplaceTFT PacketFilterList__CreateAddReplaceTFT_template::replace(int index, int len, const PacketFilterList__CreateAddReplaceTFT_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

PacketFilterList__CreateAddReplaceTFT PacketFilterList__CreateAddReplaceTFT_template::replace(int index, int len, const PacketFilterList__CreateAddReplaceTFT& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void PacketFilterList__CreateAddReplaceTFT_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new PacketFilterList__CreateAddReplaceTFT_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
}
set_selection(template_type);
}

PacketFilterList__CreateAddReplaceTFT_template& PacketFilterList__CreateAddReplaceTFT_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
return value_list.list_value[list_index];
}

void PacketFilterList__CreateAddReplaceTFT_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void PacketFilterList__CreateAddReplaceTFT_template::log_match(const PacketFilterList__CreateAddReplaceTFT& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PacketFilterList__CreateAddReplaceTFT_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
}
}

void PacketFilterList__CreateAddReplaceTFT_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
single_value.value_elements = (PacketFilter_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new PacketFilter_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PacketFilterList__CreateAddReplaceTFT_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT.");
}
}

boolean PacketFilterList__CreateAddReplaceTFT_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PacketFilterList__CreateAddReplaceTFT_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PacketFilterList__CreateAddReplaceTFT_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void PacketFilterList__CreateAddReplaceTFT_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PacketFilterList__CreateAddReplaceTFT_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PacketFilterList__CreateAddReplaceTFT_template* precondition = new PacketFilterList__CreateAddReplaceTFT_template;
    precondition->set_param(*param.get_elem(0));
    PacketFilterList__CreateAddReplaceTFT_template* implied_template = new PacketFilterList__CreateAddReplaceTFT_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PacketFilterList__CreateAddReplaceTFT_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void PacketFilterList__CreateAddReplaceTFT_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFilterList_CreateAddReplaceTFT");
}

boolean PacketFilterList__CreateAddReplaceTFT_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
PacketFilterIdentifier__CreateAddReplaceTFT::PacketFilterIdentifier__CreateAddReplaceTFT()
{
}

PacketFilterIdentifier__CreateAddReplaceTFT::PacketFilterIdentifier__CreateAddReplaceTFT(const BITSTRING& par_packetFilterIdentifier,
    const BITSTRING& par_packetFilterDirection,
    const BITSTRING& par_spare)
  :   field_packetFilterIdentifier(par_packetFilterIdentifier),
  field_packetFilterDirection(par_packetFilterDirection),
  field_spare(par_spare)
{
}

PacketFilterIdentifier__CreateAddReplaceTFT::PacketFilterIdentifier__CreateAddReplaceTFT(const PacketFilterIdentifier__CreateAddReplaceTFT& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
if (other_value.packetFilterIdentifier().is_bound()) field_packetFilterIdentifier = other_value.packetFilterIdentifier();
else field_packetFilterIdentifier.clean_up();
if (other_value.packetFilterDirection().is_bound()) field_packetFilterDirection = other_value.packetFilterDirection();
else field_packetFilterDirection.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void PacketFilterIdentifier__CreateAddReplaceTFT::clean_up()
{
field_packetFilterIdentifier.clean_up();
field_packetFilterDirection.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* PacketFilterIdentifier__CreateAddReplaceTFT::get_descriptor() const { return &PacketFilterIdentifier__CreateAddReplaceTFT_descr_; }
PacketFilterIdentifier__CreateAddReplaceTFT& PacketFilterIdentifier__CreateAddReplaceTFT::operator=(const PacketFilterIdentifier__CreateAddReplaceTFT& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
  if (other_value.packetFilterIdentifier().is_bound()) field_packetFilterIdentifier = other_value.packetFilterIdentifier();
  else field_packetFilterIdentifier.clean_up();
  if (other_value.packetFilterDirection().is_bound()) field_packetFilterDirection = other_value.packetFilterDirection();
  else field_packetFilterDirection.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean PacketFilterIdentifier__CreateAddReplaceTFT::operator==(const PacketFilterIdentifier__CreateAddReplaceTFT& other_value) const
{
return field_packetFilterIdentifier==other_value.field_packetFilterIdentifier
  && field_packetFilterDirection==other_value.field_packetFilterDirection
  && field_spare==other_value.field_spare;
}

boolean PacketFilterIdentifier__CreateAddReplaceTFT::is_bound() const
{
return (field_packetFilterIdentifier.is_bound())
  || (field_packetFilterDirection.is_bound())
  || (field_spare.is_bound());
}
boolean PacketFilterIdentifier__CreateAddReplaceTFT::is_value() const
{
return field_packetFilterIdentifier.is_value()
  && field_packetFilterDirection.is_value()
  && field_spare.is_value();
}
void PacketFilterIdentifier__CreateAddReplaceTFT::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ packetFilterIdentifier := ");
field_packetFilterIdentifier.log();
TTCN_Logger::log_event_str(", packetFilterDirection := ");
field_packetFilterDirection.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void PacketFilterIdentifier__CreateAddReplaceTFT::set_implicit_omit()
{
if (packetFilterIdentifier().is_bound()) packetFilterIdentifier().set_implicit_omit();
if (packetFilterDirection().is_bound()) packetFilterDirection().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void PacketFilterIdentifier__CreateAddReplaceTFT::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) packetFilterIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) packetFilterDirection().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packetFilterIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packetFilterIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packetFilterDirection")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packetFilterDirection().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT");
  }
}

void PacketFilterIdentifier__CreateAddReplaceTFT::encode_text(Text_Buf& text_buf) const
{
field_packetFilterIdentifier.encode_text(text_buf);
field_packetFilterDirection.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void PacketFilterIdentifier__CreateAddReplaceTFT::decode_text(Text_Buf& text_buf)
{
field_packetFilterIdentifier.decode_text(text_buf);
field_packetFilterDirection.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void PacketFilterIdentifier__CreateAddReplaceTFT::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketFilterIdentifier__CreateAddReplaceTFT::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketFilterIdentifier__CreateAddReplaceTFT::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_packetFilterIdentifier.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_packetFilterDirection.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PacketFilterIdentifier__CreateAddReplaceTFT::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT2_descr_.raw);
  encoded_length += field_packetFilterIdentifier.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_packetFilterDirection.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct PacketFilterIdentifier__CreateAddReplaceTFT_template::single_value_struct {
BITSTRING_template field_packetFilterIdentifier;
BITSTRING_template field_packetFilterDirection;
BITSTRING_template field_spare;
};

void PacketFilterIdentifier__CreateAddReplaceTFT_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_packetFilterIdentifier = ANY_VALUE;
single_value->field_packetFilterDirection = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void PacketFilterIdentifier__CreateAddReplaceTFT_template::copy_value(const PacketFilterIdentifier__CreateAddReplaceTFT& other_value)
{
single_value = new single_value_struct;
if (other_value.packetFilterIdentifier().is_bound()) {
  single_value->field_packetFilterIdentifier = other_value.packetFilterIdentifier();
} else {
  single_value->field_packetFilterIdentifier.clean_up();
}
if (other_value.packetFilterDirection().is_bound()) {
  single_value->field_packetFilterDirection = other_value.packetFilterDirection();
} else {
  single_value->field_packetFilterDirection.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PacketFilterIdentifier__CreateAddReplaceTFT_template::copy_template(const PacketFilterIdentifier__CreateAddReplaceTFT_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.packetFilterIdentifier().get_selection()) {
single_value->field_packetFilterIdentifier = other_value.packetFilterIdentifier();
} else {
single_value->field_packetFilterIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.packetFilterDirection().get_selection()) {
single_value->field_packetFilterDirection = other_value.packetFilterDirection();
} else {
single_value->field_packetFilterDirection.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketFilterIdentifier__CreateAddReplaceTFT_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketFilterIdentifier__CreateAddReplaceTFT_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketFilterIdentifier__CreateAddReplaceTFT_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
break;
}
set_selection(other_value);
}

PacketFilterIdentifier__CreateAddReplaceTFT_template::PacketFilterIdentifier__CreateAddReplaceTFT_template()
{
}

PacketFilterIdentifier__CreateAddReplaceTFT_template::PacketFilterIdentifier__CreateAddReplaceTFT_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PacketFilterIdentifier__CreateAddReplaceTFT_template::PacketFilterIdentifier__CreateAddReplaceTFT_template(const PacketFilterIdentifier__CreateAddReplaceTFT& other_value)
{
copy_value(other_value);
}

PacketFilterIdentifier__CreateAddReplaceTFT_template::PacketFilterIdentifier__CreateAddReplaceTFT_template(const OPTIONAL<PacketFilterIdentifier__CreateAddReplaceTFT>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketFilterIdentifier__CreateAddReplaceTFT&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT from an unbound optional field.");
}
}

PacketFilterIdentifier__CreateAddReplaceTFT_template::PacketFilterIdentifier__CreateAddReplaceTFT_template(PacketFilterIdentifier__CreateAddReplaceTFT_template* p_precondition, PacketFilterIdentifier__CreateAddReplaceTFT_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketFilterIdentifier__CreateAddReplaceTFT_template::PacketFilterIdentifier__CreateAddReplaceTFT_template(Dynamic_Match_Interface<PacketFilterIdentifier__CreateAddReplaceTFT>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketFilterIdentifier__CreateAddReplaceTFT>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketFilterIdentifier__CreateAddReplaceTFT_template::PacketFilterIdentifier__CreateAddReplaceTFT_template(const PacketFilterIdentifier__CreateAddReplaceTFT_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PacketFilterIdentifier__CreateAddReplaceTFT_template::~PacketFilterIdentifier__CreateAddReplaceTFT_template()
{
clean_up();
}

PacketFilterIdentifier__CreateAddReplaceTFT_template& PacketFilterIdentifier__CreateAddReplaceTFT_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketFilterIdentifier__CreateAddReplaceTFT_template& PacketFilterIdentifier__CreateAddReplaceTFT_template::operator=(const PacketFilterIdentifier__CreateAddReplaceTFT& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketFilterIdentifier__CreateAddReplaceTFT_template& PacketFilterIdentifier__CreateAddReplaceTFT_template::operator=(const OPTIONAL<PacketFilterIdentifier__CreateAddReplaceTFT>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketFilterIdentifier__CreateAddReplaceTFT&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
}
return *this;
}

PacketFilterIdentifier__CreateAddReplaceTFT_template& PacketFilterIdentifier__CreateAddReplaceTFT_template::operator=(const PacketFilterIdentifier__CreateAddReplaceTFT_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PacketFilterIdentifier__CreateAddReplaceTFT_template::match(const PacketFilterIdentifier__CreateAddReplaceTFT& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.packetFilterIdentifier().is_bound()) return FALSE;
if(!single_value->field_packetFilterIdentifier.match(other_value.packetFilterIdentifier(), legacy))return FALSE;
if(!other_value.packetFilterDirection().is_bound()) return FALSE;
if(!single_value->field_packetFilterDirection.match(other_value.packetFilterDirection(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
}
return FALSE;
}

boolean PacketFilterIdentifier__CreateAddReplaceTFT_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_packetFilterIdentifier.is_bound()
 || single_value->field_packetFilterDirection.is_bound()
 || single_value->field_spare.is_bound();
}

boolean PacketFilterIdentifier__CreateAddReplaceTFT_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_packetFilterIdentifier.is_value()
 && single_value->field_packetFilterDirection.is_value()
 && single_value->field_spare.is_value();
}

void PacketFilterIdentifier__CreateAddReplaceTFT_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketFilterIdentifier__CreateAddReplaceTFT PacketFilterIdentifier__CreateAddReplaceTFT_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
PacketFilterIdentifier__CreateAddReplaceTFT ret_val;
if (single_value->field_packetFilterIdentifier.is_bound()) {
ret_val.packetFilterIdentifier() = single_value->field_packetFilterIdentifier.valueof();
}
if (single_value->field_packetFilterDirection.is_bound()) {
ret_val.packetFilterDirection() = single_value->field_packetFilterDirection.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void PacketFilterIdentifier__CreateAddReplaceTFT_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PacketFilterIdentifier__CreateAddReplaceTFT_template[list_length];
}

PacketFilterIdentifier__CreateAddReplaceTFT_template& PacketFilterIdentifier__CreateAddReplaceTFT_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
return value_list.list_value[list_index];
}

BITSTRING_template& PacketFilterIdentifier__CreateAddReplaceTFT_template::packetFilterIdentifier()
{
set_specific();
return single_value->field_packetFilterIdentifier;
}

const BITSTRING_template& PacketFilterIdentifier__CreateAddReplaceTFT_template::packetFilterIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field packetFilterIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
return single_value->field_packetFilterIdentifier;
}

BITSTRING_template& PacketFilterIdentifier__CreateAddReplaceTFT_template::packetFilterDirection()
{
set_specific();
return single_value->field_packetFilterDirection;
}

const BITSTRING_template& PacketFilterIdentifier__CreateAddReplaceTFT_template::packetFilterDirection() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field packetFilterDirection of a non-specific template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
return single_value->field_packetFilterDirection;
}

BITSTRING_template& PacketFilterIdentifier__CreateAddReplaceTFT_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& PacketFilterIdentifier__CreateAddReplaceTFT_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
return single_value->field_spare;
}

int PacketFilterIdentifier__CreateAddReplaceTFT_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
  }
  return 0;
}

void PacketFilterIdentifier__CreateAddReplaceTFT_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ packetFilterIdentifier := ");
single_value->field_packetFilterIdentifier.log();
TTCN_Logger::log_event_str(", packetFilterDirection := ");
single_value->field_packetFilterDirection.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PacketFilterIdentifier__CreateAddReplaceTFT_template::log_match(const PacketFilterIdentifier__CreateAddReplaceTFT& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_packetFilterIdentifier.match(match_value.packetFilterIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".packetFilterIdentifier");
single_value->field_packetFilterIdentifier.log_match(match_value.packetFilterIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_packetFilterDirection.match(match_value.packetFilterDirection(), legacy)){
TTCN_Logger::log_logmatch_info(".packetFilterDirection");
single_value->field_packetFilterDirection.log_match(match_value.packetFilterDirection(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ packetFilterIdentifier := ");
single_value->field_packetFilterIdentifier.log_match(match_value.packetFilterIdentifier(), legacy);
TTCN_Logger::log_event_str(", packetFilterDirection := ");
single_value->field_packetFilterDirection.log_match(match_value.packetFilterDirection(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PacketFilterIdentifier__CreateAddReplaceTFT_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (packetFilterIdentifier().is_bound()) packetFilterIdentifier().set_implicit_omit();
if (packetFilterDirection().is_bound()) packetFilterDirection().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void PacketFilterIdentifier__CreateAddReplaceTFT_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_packetFilterIdentifier.encode_text(text_buf);
single_value->field_packetFilterDirection.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
}
}

void PacketFilterIdentifier__CreateAddReplaceTFT_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_packetFilterIdentifier.decode_text(text_buf);
single_value->field_packetFilterDirection.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PacketFilterIdentifier__CreateAddReplaceTFT_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT.");
}
}

void PacketFilterIdentifier__CreateAddReplaceTFT_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PacketFilterIdentifier__CreateAddReplaceTFT_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) packetFilterIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) packetFilterDirection().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packetFilterIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packetFilterIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packetFilterDirection")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packetFilterDirection().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PacketFilterIdentifier__CreateAddReplaceTFT_template* precondition = new PacketFilterIdentifier__CreateAddReplaceTFT_template;
    precondition->set_param(*param.get_elem(0));
    PacketFilterIdentifier__CreateAddReplaceTFT_template* implied_template = new PacketFilterIdentifier__CreateAddReplaceTFT_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PacketFilterIdentifier__CreateAddReplaceTFT_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT");
  }
  is_ifpresent = param.get_ifpresent();
}

void PacketFilterIdentifier__CreateAddReplaceTFT_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_packetFilterIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT");
single_value->field_packetFilterDirection.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFilterIdentifier_CreateAddReplaceTFT");
}

boolean PacketFilterIdentifier__CreateAddReplaceTFT_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PacketFilterIdentifier__CreateAddReplaceTFT_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PacketFilter::PacketFilter()
{
}

PacketFilter::PacketFilter(const PacketFilterIdentifier__CreateAddReplaceTFT& par_identifier,
    const OCTETSTRING& par_evaluationPrecedence,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_contents)
  :   field_identifier(par_identifier),
  field_evaluationPrecedence(par_evaluationPrecedence),
  field_lengthIndicator(par_lengthIndicator),
  field_contents(par_contents)
{
}

PacketFilter::PacketFilter(const PacketFilter& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PacketFilter.");
if (other_value.identifier().is_bound()) field_identifier = other_value.identifier();
else field_identifier.clean_up();
if (other_value.evaluationPrecedence().is_bound()) field_evaluationPrecedence = other_value.evaluationPrecedence();
else field_evaluationPrecedence.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.contents().is_bound()) field_contents = other_value.contents();
else field_contents.clean_up();
}

void PacketFilter::clean_up()
{
field_identifier.clean_up();
field_evaluationPrecedence.clean_up();
field_lengthIndicator.clean_up();
field_contents.clean_up();
}

const TTCN_Typedescriptor_t* PacketFilter::get_descriptor() const { return &PacketFilter_descr_; }
PacketFilter& PacketFilter::operator=(const PacketFilter& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PacketFilter.");
  if (other_value.identifier().is_bound()) field_identifier = other_value.identifier();
  else field_identifier.clean_up();
  if (other_value.evaluationPrecedence().is_bound()) field_evaluationPrecedence = other_value.evaluationPrecedence();
  else field_evaluationPrecedence.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.contents().is_bound()) field_contents = other_value.contents();
  else field_contents.clean_up();
}
return *this;
}

boolean PacketFilter::operator==(const PacketFilter& other_value) const
{
return field_identifier==other_value.field_identifier
  && field_evaluationPrecedence==other_value.field_evaluationPrecedence
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_contents==other_value.field_contents;
}

boolean PacketFilter::is_bound() const
{
return (field_identifier.is_bound())
  || (field_evaluationPrecedence.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_contents.is_bound());
}
boolean PacketFilter::is_value() const
{
return field_identifier.is_value()
  && field_evaluationPrecedence.is_value()
  && field_lengthIndicator.is_value()
  && field_contents.is_value();
}
void PacketFilter::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ identifier := ");
field_identifier.log();
TTCN_Logger::log_event_str(", evaluationPrecedence := ");
field_evaluationPrecedence.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", contents := ");
field_contents.log();
TTCN_Logger::log_event_str(" }");
}

void PacketFilter::set_implicit_omit()
{
if (identifier().is_bound()) identifier().set_implicit_omit();
if (evaluationPrecedence().is_bound()) evaluationPrecedence().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (contents().is_bound()) contents().set_implicit_omit();
}

void PacketFilter::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PacketFilter has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) identifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) evaluationPrecedence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) contents().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "evaluationPrecedence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          evaluationPrecedence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "contents")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          contents().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PacketFilter: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PacketFilter");
  }
}

void PacketFilter::encode_text(Text_Buf& text_buf) const
{
field_identifier.encode_text(text_buf);
field_evaluationPrecedence.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_contents.encode_text(text_buf);
}

void PacketFilter::decode_text(Text_Buf& text_buf)
{
field_identifier.decode_text(text_buf);
field_evaluationPrecedence.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_contents.decode_text(text_buf);
}

void PacketFilter::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketFilter::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketFilter::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, PacketFilterIdentifier__CreateAddReplaceTFT_descr_.raw->forceomit);
  decoded_field_length = field_identifier.RAW_decode(PacketFilterIdentifier__CreateAddReplaceTFT_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_evaluationPrecedence.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, PacketFilter_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(PacketFilter_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp2 = field_lengthIndicator.convert_to_Integer(PacketFilter_lengthIndicator_descr_);
  field_lengthIndicator = tmp2;
  value_of_length_field2 += tmp2.get_long_long_val() * 8;
  RAW_Force_Omit field_3_force_omit(3, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_contents.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PacketFilter::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PacketFilterIdentifier__CreateAddReplaceTFT_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, PacketFilter_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, OCTETSTRING_descr_.raw);
  encoded_length += field_identifier.RAW_encode(PacketFilterIdentifier__CreateAddReplaceTFT_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_evaluationPrecedence.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += 8;
  myleaf.body.node.nodes[2]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->coding_descr = &PacketFilter_lengthIndicator_descr_;
  myleaf.body.node.nodes[2]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->length = 8;
  myleaf.body.node.nodes[2]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_contents.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct PacketFilter_template::single_value_struct {
PacketFilterIdentifier__CreateAddReplaceTFT_template field_identifier;
OCTETSTRING_template field_evaluationPrecedence;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_contents;
};

void PacketFilter_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_identifier = ANY_VALUE;
single_value->field_evaluationPrecedence = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_contents = ANY_VALUE;
}
}
}

void PacketFilter_template::copy_value(const PacketFilter& other_value)
{
single_value = new single_value_struct;
if (other_value.identifier().is_bound()) {
  single_value->field_identifier = other_value.identifier();
} else {
  single_value->field_identifier.clean_up();
}
if (other_value.evaluationPrecedence().is_bound()) {
  single_value->field_evaluationPrecedence = other_value.evaluationPrecedence();
} else {
  single_value->field_evaluationPrecedence.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.contents().is_bound()) {
  single_value->field_contents = other_value.contents();
} else {
  single_value->field_contents.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PacketFilter_template::copy_template(const PacketFilter_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.identifier().get_selection()) {
single_value->field_identifier = other_value.identifier();
} else {
single_value->field_identifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.evaluationPrecedence().get_selection()) {
single_value->field_evaluationPrecedence = other_value.evaluationPrecedence();
} else {
single_value->field_evaluationPrecedence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.contents().get_selection()) {
single_value->field_contents = other_value.contents();
} else {
single_value->field_contents.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketFilter_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketFilter_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketFilter_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFilter.");
break;
}
set_selection(other_value);
}

PacketFilter_template::PacketFilter_template()
{
}

PacketFilter_template::PacketFilter_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PacketFilter_template::PacketFilter_template(const PacketFilter& other_value)
{
copy_value(other_value);
}

PacketFilter_template::PacketFilter_template(const OPTIONAL<PacketFilter>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketFilter&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PacketFilter from an unbound optional field.");
}
}

PacketFilter_template::PacketFilter_template(PacketFilter_template* p_precondition, PacketFilter_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketFilter_template::PacketFilter_template(Dynamic_Match_Interface<PacketFilter>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketFilter>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketFilter_template::PacketFilter_template(const PacketFilter_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PacketFilter_template::~PacketFilter_template()
{
clean_up();
}

PacketFilter_template& PacketFilter_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketFilter_template& PacketFilter_template::operator=(const PacketFilter& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketFilter_template& PacketFilter_template::operator=(const OPTIONAL<PacketFilter>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketFilter&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PacketFilter.");
}
return *this;
}

PacketFilter_template& PacketFilter_template::operator=(const PacketFilter_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PacketFilter_template::match(const PacketFilter& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.identifier().is_bound()) return FALSE;
if(!single_value->field_identifier.match(other_value.identifier(), legacy))return FALSE;
if(!other_value.evaluationPrecedence().is_bound()) return FALSE;
if(!single_value->field_evaluationPrecedence.match(other_value.evaluationPrecedence(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.contents().is_bound()) return FALSE;
if(!single_value->field_contents.match(other_value.contents(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFilter.");
}
return FALSE;
}

boolean PacketFilter_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_identifier.is_bound()
 || single_value->field_evaluationPrecedence.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_contents.is_bound();
}

boolean PacketFilter_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_identifier.is_value()
 && single_value->field_evaluationPrecedence.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_contents.is_value();
}

void PacketFilter_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketFilter PacketFilter_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PacketFilter.");
PacketFilter ret_val;
if (single_value->field_identifier.is_bound()) {
ret_val.identifier() = single_value->field_identifier.valueof();
}
if (single_value->field_evaluationPrecedence.is_bound()) {
ret_val.evaluationPrecedence() = single_value->field_evaluationPrecedence.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_contents.is_bound()) {
ret_val.contents() = single_value->field_contents.valueof();
}
return ret_val;
}

void PacketFilter_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PacketFilter.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PacketFilter_template[list_length];
}

PacketFilter_template& PacketFilter_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PacketFilter.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PacketFilter.");
return value_list.list_value[list_index];
}

PacketFilterIdentifier__CreateAddReplaceTFT_template& PacketFilter_template::identifier()
{
set_specific();
return single_value->field_identifier;
}

const PacketFilterIdentifier__CreateAddReplaceTFT_template& PacketFilter_template::identifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field identifier of a non-specific template of type @MobileL3_GMM_SM_Types.PacketFilter.");
return single_value->field_identifier;
}

OCTETSTRING_template& PacketFilter_template::evaluationPrecedence()
{
set_specific();
return single_value->field_evaluationPrecedence;
}

const OCTETSTRING_template& PacketFilter_template::evaluationPrecedence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field evaluationPrecedence of a non-specific template of type @MobileL3_GMM_SM_Types.PacketFilter.");
return single_value->field_evaluationPrecedence;
}

INTEGER_template& PacketFilter_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& PacketFilter_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.PacketFilter.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& PacketFilter_template::contents()
{
set_specific();
return single_value->field_contents;
}

const OCTETSTRING_template& PacketFilter_template::contents() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field contents of a non-specific template of type @MobileL3_GMM_SM_Types.PacketFilter.");
return single_value->field_contents;
}

int PacketFilter_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilter which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilter containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilter containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilter containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilter containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilter containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilter containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilter containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PacketFilter containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFilter.");
  }
  return 0;
}

void PacketFilter_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ identifier := ");
single_value->field_identifier.log();
TTCN_Logger::log_event_str(", evaluationPrecedence := ");
single_value->field_evaluationPrecedence.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", contents := ");
single_value->field_contents.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PacketFilter_template::log_match(const PacketFilter& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_identifier.match(match_value.identifier(), legacy)){
TTCN_Logger::log_logmatch_info(".identifier");
single_value->field_identifier.log_match(match_value.identifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_evaluationPrecedence.match(match_value.evaluationPrecedence(), legacy)){
TTCN_Logger::log_logmatch_info(".evaluationPrecedence");
single_value->field_evaluationPrecedence.log_match(match_value.evaluationPrecedence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_contents.match(match_value.contents(), legacy)){
TTCN_Logger::log_logmatch_info(".contents");
single_value->field_contents.log_match(match_value.contents(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ identifier := ");
single_value->field_identifier.log_match(match_value.identifier(), legacy);
TTCN_Logger::log_event_str(", evaluationPrecedence := ");
single_value->field_evaluationPrecedence.log_match(match_value.evaluationPrecedence(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", contents := ");
single_value->field_contents.log_match(match_value.contents(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PacketFilter_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (identifier().is_bound()) identifier().set_implicit_omit();
if (evaluationPrecedence().is_bound()) evaluationPrecedence().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (contents().is_bound()) contents().set_implicit_omit();
}

void PacketFilter_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_identifier.encode_text(text_buf);
single_value->field_evaluationPrecedence.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_contents.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFilter.");
}
}

void PacketFilter_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_identifier.decode_text(text_buf);
single_value->field_evaluationPrecedence.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_contents.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PacketFilter_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PacketFilter.");
}
}

void PacketFilter_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PacketFilter_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PacketFilter has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) identifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) evaluationPrecedence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) contents().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "evaluationPrecedence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          evaluationPrecedence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "contents")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          contents().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PacketFilter: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PacketFilter_template* precondition = new PacketFilter_template;
    precondition->set_param(*param.get_elem(0));
    PacketFilter_template* implied_template = new PacketFilter_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PacketFilter_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PacketFilter");
  }
  is_ifpresent = param.get_ifpresent();
}

void PacketFilter_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_identifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFilter");
single_value->field_evaluationPrecedence.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFilter");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFilter");
single_value->field_contents.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFilter");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PacketFilter");
}

boolean PacketFilter_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PacketFilter_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

TrafficFlowTemplateV__CreateAddReplaceTFT::TrafficFlowTemplateV__CreateAddReplaceTFT()
{
}

TrafficFlowTemplateV__CreateAddReplaceTFT::TrafficFlowTemplateV__CreateAddReplaceTFT(const INTEGER& par_numberOfPacketFilters,
    const BITSTRING& par_eBIT,
    const BITSTRING& par_operationCodeTFT,
    const PacketFilterList__CreateAddReplaceTFT& par_packetFilterList__CreateAddReplaceTFT,
    const OPTIONAL< ParametersList >& par_parametersList)
  :   field_numberOfPacketFilters(par_numberOfPacketFilters),
  field_eBIT(par_eBIT),
  field_operationCodeTFT(par_operationCodeTFT),
  field_packetFilterList__CreateAddReplaceTFT(par_packetFilterList__CreateAddReplaceTFT),
  field_parametersList(par_parametersList)
{
}

TrafficFlowTemplateV__CreateAddReplaceTFT::TrafficFlowTemplateV__CreateAddReplaceTFT(const TrafficFlowTemplateV__CreateAddReplaceTFT& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
if (other_value.numberOfPacketFilters().is_bound()) field_numberOfPacketFilters = other_value.numberOfPacketFilters();
else field_numberOfPacketFilters.clean_up();
if (other_value.eBIT().is_bound()) field_eBIT = other_value.eBIT();
else field_eBIT.clean_up();
if (other_value.operationCodeTFT().is_bound()) field_operationCodeTFT = other_value.operationCodeTFT();
else field_operationCodeTFT.clean_up();
if (other_value.packetFilterList__CreateAddReplaceTFT().is_bound()) field_packetFilterList__CreateAddReplaceTFT = other_value.packetFilterList__CreateAddReplaceTFT();
else field_packetFilterList__CreateAddReplaceTFT.clean_up();
if (other_value.parametersList().is_bound()) field_parametersList = other_value.parametersList();
else field_parametersList.clean_up();
}

void TrafficFlowTemplateV__CreateAddReplaceTFT::clean_up()
{
field_numberOfPacketFilters.clean_up();
field_eBIT.clean_up();
field_operationCodeTFT.clean_up();
field_packetFilterList__CreateAddReplaceTFT.clean_up();
field_parametersList.clean_up();
}

const TTCN_Typedescriptor_t* TrafficFlowTemplateV__CreateAddReplaceTFT::get_descriptor() const { return &TrafficFlowTemplateV__CreateAddReplaceTFT_descr_; }
TrafficFlowTemplateV__CreateAddReplaceTFT& TrafficFlowTemplateV__CreateAddReplaceTFT::operator=(const TrafficFlowTemplateV__CreateAddReplaceTFT& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
  if (other_value.numberOfPacketFilters().is_bound()) field_numberOfPacketFilters = other_value.numberOfPacketFilters();
  else field_numberOfPacketFilters.clean_up();
  if (other_value.eBIT().is_bound()) field_eBIT = other_value.eBIT();
  else field_eBIT.clean_up();
  if (other_value.operationCodeTFT().is_bound()) field_operationCodeTFT = other_value.operationCodeTFT();
  else field_operationCodeTFT.clean_up();
  if (other_value.packetFilterList__CreateAddReplaceTFT().is_bound()) field_packetFilterList__CreateAddReplaceTFT = other_value.packetFilterList__CreateAddReplaceTFT();
  else field_packetFilterList__CreateAddReplaceTFT.clean_up();
  if (other_value.parametersList().is_bound()) field_parametersList = other_value.parametersList();
  else field_parametersList.clean_up();
}
return *this;
}

boolean TrafficFlowTemplateV__CreateAddReplaceTFT::operator==(const TrafficFlowTemplateV__CreateAddReplaceTFT& other_value) const
{
return field_numberOfPacketFilters==other_value.field_numberOfPacketFilters
  && field_eBIT==other_value.field_eBIT
  && field_operationCodeTFT==other_value.field_operationCodeTFT
  && field_packetFilterList__CreateAddReplaceTFT==other_value.field_packetFilterList__CreateAddReplaceTFT
  && field_parametersList==other_value.field_parametersList;
}

boolean TrafficFlowTemplateV__CreateAddReplaceTFT::is_bound() const
{
return (field_numberOfPacketFilters.is_bound())
  || (field_eBIT.is_bound())
  || (field_operationCodeTFT.is_bound())
  || (field_packetFilterList__CreateAddReplaceTFT.is_bound())
  || (OPTIONAL_OMIT == field_parametersList.get_selection() || field_parametersList.is_bound());
}
boolean TrafficFlowTemplateV__CreateAddReplaceTFT::is_value() const
{
return field_numberOfPacketFilters.is_value()
  && field_eBIT.is_value()
  && field_operationCodeTFT.is_value()
  && field_packetFilterList__CreateAddReplaceTFT.is_value()
  && (OPTIONAL_OMIT == field_parametersList.get_selection() || field_parametersList.is_value());
}
int TrafficFlowTemplateV__CreateAddReplaceTFT::size_of() const
{
  int ret_val = 4;
  if (field_parametersList.ispresent()) ret_val++;
  return ret_val;
}

void TrafficFlowTemplateV__CreateAddReplaceTFT::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ numberOfPacketFilters := ");
field_numberOfPacketFilters.log();
TTCN_Logger::log_event_str(", eBIT := ");
field_eBIT.log();
TTCN_Logger::log_event_str(", operationCodeTFT := ");
field_operationCodeTFT.log();
TTCN_Logger::log_event_str(", packetFilterList_CreateAddReplaceTFT := ");
field_packetFilterList__CreateAddReplaceTFT.log();
TTCN_Logger::log_event_str(", parametersList := ");
field_parametersList.log();
TTCN_Logger::log_event_str(" }");
}

void TrafficFlowTemplateV__CreateAddReplaceTFT::set_implicit_omit()
{
if (numberOfPacketFilters().is_bound()) numberOfPacketFilters().set_implicit_omit();
if (eBIT().is_bound()) eBIT().set_implicit_omit();
if (operationCodeTFT().is_bound()) operationCodeTFT().set_implicit_omit();
if (packetFilterList__CreateAddReplaceTFT().is_bound()) packetFilterList__CreateAddReplaceTFT().set_implicit_omit();
if (!parametersList().is_bound()) parametersList() = OMIT_VALUE;
else parametersList().set_implicit_omit();
}

void TrafficFlowTemplateV__CreateAddReplaceTFT::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) numberOfPacketFilters().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) eBIT().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) operationCodeTFT().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) packetFilterList__CreateAddReplaceTFT().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) parametersList().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "numberOfPacketFilters")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          numberOfPacketFilters().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eBIT")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eBIT().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "operationCodeTFT")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          operationCodeTFT().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packetFilterList_CreateAddReplaceTFT")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packetFilterList__CreateAddReplaceTFT().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "parametersList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          parametersList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT");
  }
}

void TrafficFlowTemplateV__CreateAddReplaceTFT::encode_text(Text_Buf& text_buf) const
{
field_numberOfPacketFilters.encode_text(text_buf);
field_eBIT.encode_text(text_buf);
field_operationCodeTFT.encode_text(text_buf);
field_packetFilterList__CreateAddReplaceTFT.encode_text(text_buf);
field_parametersList.encode_text(text_buf);
}

void TrafficFlowTemplateV__CreateAddReplaceTFT::decode_text(Text_Buf& text_buf)
{
field_numberOfPacketFilters.decode_text(text_buf);
field_eBIT.decode_text(text_buf);
field_operationCodeTFT.decode_text(text_buf);
field_packetFilterList__CreateAddReplaceTFT.decode_text(text_buf);
field_parametersList.decode_text(text_buf);
}

void TrafficFlowTemplateV__CreateAddReplaceTFT::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void TrafficFlowTemplateV__CreateAddReplaceTFT::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int TrafficFlowTemplateV__CreateAddReplaceTFT::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, TrafficFlowTemplateV__CreateAddReplaceTFT_numberOfPacketFilters_descr_.raw->forceomit);
  decoded_field_length = field_numberOfPacketFilters.RAW_decode(TrafficFlowTemplateV__CreateAddReplaceTFT_numberOfPacketFilters_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_numberOfPacketFilters.convert_to_Integer(TrafficFlowTemplateV__CreateAddReplaceTFT_numberOfPacketFilters_descr_);
  field_numberOfPacketFilters = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 1;
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_eBIT.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_operationCodeTFT.RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, PacketFilterList__CreateAddReplaceTFT_descr_.raw->forceomit);
  decoded_field_length = field_packetFilterList__CreateAddReplaceTFT.RAW_decode(PacketFilterList__CreateAddReplaceTFT_descr_, p_buf, limit, local_top_order, no_err, value_of_length_field0, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  if (limit > 0 && field_eBIT ==  bs_2){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_parametersList = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, TrafficFlowTemplateV__CreateAddReplaceTFT_parametersList_descr_.raw->forceomit);
  decoded_field_length = field_parametersList().RAW_decode(TrafficFlowTemplateV__CreateAddReplaceTFT_parametersList_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_parametersList = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_parametersList=OMIT_VALUE;
  if (field_operationCodeTFT !=  bs_15 && field_operationCodeTFT !=  bs_16 && field_operationCodeTFT !=  bs_17) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int TrafficFlowTemplateV__CreateAddReplaceTFT::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, TrafficFlowTemplateV__CreateAddReplaceTFT_numberOfPacketFilters_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, PacketFilterList__CreateAddReplaceTFT_descr_.raw);
  if (field_parametersList.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, TrafficFlowTemplateV__CreateAddReplaceTFT_parametersList_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += 4;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &TrafficFlowTemplateV__CreateAddReplaceTFT_numberOfPacketFilters_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = -1;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 4;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_eBIT.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_operationCodeTFT.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_packetFilterList__CreateAddReplaceTFT.RAW_encode(PacketFilterList__CreateAddReplaceTFT_descr_, *myleaf.body.node.nodes[3]);
  if (field_parametersList.ispresent()) {
  encoded_length += field_parametersList().RAW_encode(TrafficFlowTemplateV__CreateAddReplaceTFT_parametersList_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_parametersList.ispresent() && (field_eBIT !=  bs_2)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_2.RAW_encode(General__Types::BIT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_operationCodeTFT !=  bs_15 && field_operationCodeTFT !=  bs_16 && field_operationCodeTFT !=  bs_17) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={2};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_15.RAW_encode(General__Types::BIT3_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos1;
  pr_pos1.level=myleaf.curr_pos.level+1;
  int new_pos1[]={2};
  pr_pos1.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos1);
  temp_leaf = myleaf.get_node(pr_pos1);
  if(temp_leaf != NULL){
   bs_16.RAW_encode(General__Types::BIT3_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos2;
  pr_pos2.level=myleaf.curr_pos.level+1;
  int new_pos2[]={2};
  pr_pos2.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos2);
  temp_leaf = myleaf.get_node(pr_pos2);
  if(temp_leaf != NULL){
   bs_17.RAW_encode(General__Types::BIT3_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos2.pos);
  }
  free_tree_pos(pr_pos1.pos);
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct TrafficFlowTemplateV__CreateAddReplaceTFT_template::single_value_struct {
INTEGER_template field_numberOfPacketFilters;
BITSTRING_template field_eBIT;
BITSTRING_template field_operationCodeTFT;
PacketFilterList__CreateAddReplaceTFT_template field_packetFilterList__CreateAddReplaceTFT;
ParametersList_template field_parametersList;
};

void TrafficFlowTemplateV__CreateAddReplaceTFT_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_numberOfPacketFilters = ANY_VALUE;
single_value->field_eBIT = ANY_VALUE;
single_value->field_operationCodeTFT = ANY_VALUE;
single_value->field_packetFilterList__CreateAddReplaceTFT = ANY_VALUE;
single_value->field_parametersList = ANY_OR_OMIT;
}
}
}

void TrafficFlowTemplateV__CreateAddReplaceTFT_template::copy_value(const TrafficFlowTemplateV__CreateAddReplaceTFT& other_value)
{
single_value = new single_value_struct;
if (other_value.numberOfPacketFilters().is_bound()) {
  single_value->field_numberOfPacketFilters = other_value.numberOfPacketFilters();
} else {
  single_value->field_numberOfPacketFilters.clean_up();
}
if (other_value.eBIT().is_bound()) {
  single_value->field_eBIT = other_value.eBIT();
} else {
  single_value->field_eBIT.clean_up();
}
if (other_value.operationCodeTFT().is_bound()) {
  single_value->field_operationCodeTFT = other_value.operationCodeTFT();
} else {
  single_value->field_operationCodeTFT.clean_up();
}
if (other_value.packetFilterList__CreateAddReplaceTFT().is_bound()) {
  single_value->field_packetFilterList__CreateAddReplaceTFT = other_value.packetFilterList__CreateAddReplaceTFT();
} else {
  single_value->field_packetFilterList__CreateAddReplaceTFT.clean_up();
}
if (other_value.parametersList().is_bound()) {
  if (other_value.parametersList().ispresent()) single_value->field_parametersList = other_value.parametersList()();
  else single_value->field_parametersList = OMIT_VALUE;
} else {
  single_value->field_parametersList.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void TrafficFlowTemplateV__CreateAddReplaceTFT_template::copy_template(const TrafficFlowTemplateV__CreateAddReplaceTFT_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.numberOfPacketFilters().get_selection()) {
single_value->field_numberOfPacketFilters = other_value.numberOfPacketFilters();
} else {
single_value->field_numberOfPacketFilters.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.eBIT().get_selection()) {
single_value->field_eBIT = other_value.eBIT();
} else {
single_value->field_eBIT.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.operationCodeTFT().get_selection()) {
single_value->field_operationCodeTFT = other_value.operationCodeTFT();
} else {
single_value->field_operationCodeTFT.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.packetFilterList__CreateAddReplaceTFT().get_selection()) {
single_value->field_packetFilterList__CreateAddReplaceTFT = other_value.packetFilterList__CreateAddReplaceTFT();
} else {
single_value->field_packetFilterList__CreateAddReplaceTFT.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.parametersList().get_selection()) {
single_value->field_parametersList = other_value.parametersList();
} else {
single_value->field_parametersList.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new TrafficFlowTemplateV__CreateAddReplaceTFT_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new TrafficFlowTemplateV__CreateAddReplaceTFT_template(*other_value.implication_.precondition);
implication_.implied_template = new TrafficFlowTemplateV__CreateAddReplaceTFT_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
break;
}
set_selection(other_value);
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template::TrafficFlowTemplateV__CreateAddReplaceTFT_template()
{
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template::TrafficFlowTemplateV__CreateAddReplaceTFT_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template::TrafficFlowTemplateV__CreateAddReplaceTFT_template(const TrafficFlowTemplateV__CreateAddReplaceTFT& other_value)
{
copy_value(other_value);
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template::TrafficFlowTemplateV__CreateAddReplaceTFT_template(const OPTIONAL<TrafficFlowTemplateV__CreateAddReplaceTFT>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TrafficFlowTemplateV__CreateAddReplaceTFT&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT from an unbound optional field.");
}
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template::TrafficFlowTemplateV__CreateAddReplaceTFT_template(TrafficFlowTemplateV__CreateAddReplaceTFT_template* p_precondition, TrafficFlowTemplateV__CreateAddReplaceTFT_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template::TrafficFlowTemplateV__CreateAddReplaceTFT_template(Dynamic_Match_Interface<TrafficFlowTemplateV__CreateAddReplaceTFT>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<TrafficFlowTemplateV__CreateAddReplaceTFT>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template::TrafficFlowTemplateV__CreateAddReplaceTFT_template(const TrafficFlowTemplateV__CreateAddReplaceTFT_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template::~TrafficFlowTemplateV__CreateAddReplaceTFT_template()
{
clean_up();
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::operator=(const TrafficFlowTemplateV__CreateAddReplaceTFT& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::operator=(const OPTIONAL<TrafficFlowTemplateV__CreateAddReplaceTFT>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TrafficFlowTemplateV__CreateAddReplaceTFT&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
}
return *this;
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::operator=(const TrafficFlowTemplateV__CreateAddReplaceTFT_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean TrafficFlowTemplateV__CreateAddReplaceTFT_template::match(const TrafficFlowTemplateV__CreateAddReplaceTFT& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.numberOfPacketFilters().is_bound()) return FALSE;
if(!single_value->field_numberOfPacketFilters.match(other_value.numberOfPacketFilters(), legacy))return FALSE;
if(!other_value.eBIT().is_bound()) return FALSE;
if(!single_value->field_eBIT.match(other_value.eBIT(), legacy))return FALSE;
if(!other_value.operationCodeTFT().is_bound()) return FALSE;
if(!single_value->field_operationCodeTFT.match(other_value.operationCodeTFT(), legacy))return FALSE;
if(!other_value.packetFilterList__CreateAddReplaceTFT().is_bound()) return FALSE;
if(!single_value->field_packetFilterList__CreateAddReplaceTFT.match(other_value.packetFilterList__CreateAddReplaceTFT(), legacy))return FALSE;
if(!other_value.parametersList().is_bound()) return FALSE;
if((other_value.parametersList().ispresent() ? !single_value->field_parametersList.match((const ParametersList&)other_value.parametersList(), legacy) : !single_value->field_parametersList.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
}
return FALSE;
}

boolean TrafficFlowTemplateV__CreateAddReplaceTFT_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_numberOfPacketFilters.is_bound()
 || single_value->field_eBIT.is_bound()
 || single_value->field_operationCodeTFT.is_bound()
 || single_value->field_packetFilterList__CreateAddReplaceTFT.is_bound()
 || (single_value->field_parametersList.is_omit() || single_value->field_parametersList.is_bound());
}

boolean TrafficFlowTemplateV__CreateAddReplaceTFT_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_numberOfPacketFilters.is_value()
 && single_value->field_eBIT.is_value()
 && single_value->field_operationCodeTFT.is_value()
 && single_value->field_packetFilterList__CreateAddReplaceTFT.is_value()
 && (single_value->field_parametersList.is_omit() || single_value->field_parametersList.is_value());
}

void TrafficFlowTemplateV__CreateAddReplaceTFT_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

TrafficFlowTemplateV__CreateAddReplaceTFT TrafficFlowTemplateV__CreateAddReplaceTFT_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
TrafficFlowTemplateV__CreateAddReplaceTFT ret_val;
if (single_value->field_numberOfPacketFilters.is_bound()) {
ret_val.numberOfPacketFilters() = single_value->field_numberOfPacketFilters.valueof();
}
if (single_value->field_eBIT.is_bound()) {
ret_val.eBIT() = single_value->field_eBIT.valueof();
}
if (single_value->field_operationCodeTFT.is_bound()) {
ret_val.operationCodeTFT() = single_value->field_operationCodeTFT.valueof();
}
if (single_value->field_packetFilterList__CreateAddReplaceTFT.is_bound()) {
ret_val.packetFilterList__CreateAddReplaceTFT() = single_value->field_packetFilterList__CreateAddReplaceTFT.valueof();
}
if (single_value->field_parametersList.is_omit()) ret_val.parametersList() = OMIT_VALUE;
else if (single_value->field_parametersList.is_bound()) {
ret_val.parametersList() = single_value->field_parametersList.valueof();
}
return ret_val;
}

void TrafficFlowTemplateV__CreateAddReplaceTFT_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new TrafficFlowTemplateV__CreateAddReplaceTFT_template[list_length];
}

TrafficFlowTemplateV__CreateAddReplaceTFT_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
return value_list.list_value[list_index];
}

INTEGER_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::numberOfPacketFilters()
{
set_specific();
return single_value->field_numberOfPacketFilters;
}

const INTEGER_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::numberOfPacketFilters() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field numberOfPacketFilters of a non-specific template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
return single_value->field_numberOfPacketFilters;
}

BITSTRING_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::eBIT()
{
set_specific();
return single_value->field_eBIT;
}

const BITSTRING_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::eBIT() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field eBIT of a non-specific template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
return single_value->field_eBIT;
}

BITSTRING_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::operationCodeTFT()
{
set_specific();
return single_value->field_operationCodeTFT;
}

const BITSTRING_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::operationCodeTFT() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field operationCodeTFT of a non-specific template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
return single_value->field_operationCodeTFT;
}

PacketFilterList__CreateAddReplaceTFT_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::packetFilterList__CreateAddReplaceTFT()
{
set_specific();
return single_value->field_packetFilterList__CreateAddReplaceTFT;
}

const PacketFilterList__CreateAddReplaceTFT_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::packetFilterList__CreateAddReplaceTFT() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field packetFilterList_CreateAddReplaceTFT of a non-specific template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
return single_value->field_packetFilterList__CreateAddReplaceTFT;
}

ParametersList_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::parametersList()
{
set_specific();
return single_value->field_parametersList;
}

const ParametersList_template& TrafficFlowTemplateV__CreateAddReplaceTFT_template::parametersList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field parametersList of a non-specific template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
return single_value->field_parametersList;
}

int TrafficFlowTemplateV__CreateAddReplaceTFT_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 4;
      if (single_value->field_parametersList.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
  }
  return 0;
}

void TrafficFlowTemplateV__CreateAddReplaceTFT_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ numberOfPacketFilters := ");
single_value->field_numberOfPacketFilters.log();
TTCN_Logger::log_event_str(", eBIT := ");
single_value->field_eBIT.log();
TTCN_Logger::log_event_str(", operationCodeTFT := ");
single_value->field_operationCodeTFT.log();
TTCN_Logger::log_event_str(", packetFilterList_CreateAddReplaceTFT := ");
single_value->field_packetFilterList__CreateAddReplaceTFT.log();
TTCN_Logger::log_event_str(", parametersList := ");
single_value->field_parametersList.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void TrafficFlowTemplateV__CreateAddReplaceTFT_template::log_match(const TrafficFlowTemplateV__CreateAddReplaceTFT& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_numberOfPacketFilters.match(match_value.numberOfPacketFilters(), legacy)){
TTCN_Logger::log_logmatch_info(".numberOfPacketFilters");
single_value->field_numberOfPacketFilters.log_match(match_value.numberOfPacketFilters(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_eBIT.match(match_value.eBIT(), legacy)){
TTCN_Logger::log_logmatch_info(".eBIT");
single_value->field_eBIT.log_match(match_value.eBIT(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_operationCodeTFT.match(match_value.operationCodeTFT(), legacy)){
TTCN_Logger::log_logmatch_info(".operationCodeTFT");
single_value->field_operationCodeTFT.log_match(match_value.operationCodeTFT(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_packetFilterList__CreateAddReplaceTFT.match(match_value.packetFilterList__CreateAddReplaceTFT(), legacy)){
TTCN_Logger::log_logmatch_info(".packetFilterList_CreateAddReplaceTFT");
single_value->field_packetFilterList__CreateAddReplaceTFT.log_match(match_value.packetFilterList__CreateAddReplaceTFT(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.parametersList().ispresent()){
if(!single_value->field_parametersList.match(match_value.parametersList(), legacy)){
TTCN_Logger::log_logmatch_info(".parametersList");
single_value->field_parametersList.log_match(match_value.parametersList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_parametersList.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".parametersList := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_parametersList.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ numberOfPacketFilters := ");
single_value->field_numberOfPacketFilters.log_match(match_value.numberOfPacketFilters(), legacy);
TTCN_Logger::log_event_str(", eBIT := ");
single_value->field_eBIT.log_match(match_value.eBIT(), legacy);
TTCN_Logger::log_event_str(", operationCodeTFT := ");
single_value->field_operationCodeTFT.log_match(match_value.operationCodeTFT(), legacy);
TTCN_Logger::log_event_str(", packetFilterList_CreateAddReplaceTFT := ");
single_value->field_packetFilterList__CreateAddReplaceTFT.log_match(match_value.packetFilterList__CreateAddReplaceTFT(), legacy);
TTCN_Logger::log_event_str(", parametersList := ");
if (match_value.parametersList().ispresent()) {
single_value->field_parametersList.log_match(match_value.parametersList(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_parametersList.log();
if (single_value->field_parametersList.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void TrafficFlowTemplateV__CreateAddReplaceTFT_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (numberOfPacketFilters().is_bound()) numberOfPacketFilters().set_implicit_omit();
if (eBIT().is_bound()) eBIT().set_implicit_omit();
if (operationCodeTFT().is_bound()) operationCodeTFT().set_implicit_omit();
if (packetFilterList__CreateAddReplaceTFT().is_bound()) packetFilterList__CreateAddReplaceTFT().set_implicit_omit();
if (!parametersList().is_bound()) parametersList() = OMIT_VALUE;
else parametersList().set_implicit_omit();
}

void TrafficFlowTemplateV__CreateAddReplaceTFT_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_numberOfPacketFilters.encode_text(text_buf);
single_value->field_eBIT.encode_text(text_buf);
single_value->field_operationCodeTFT.encode_text(text_buf);
single_value->field_packetFilterList__CreateAddReplaceTFT.encode_text(text_buf);
single_value->field_parametersList.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
}
}

void TrafficFlowTemplateV__CreateAddReplaceTFT_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_numberOfPacketFilters.decode_text(text_buf);
single_value->field_eBIT.decode_text(text_buf);
single_value->field_operationCodeTFT.decode_text(text_buf);
single_value->field_packetFilterList__CreateAddReplaceTFT.decode_text(text_buf);
single_value->field_parametersList.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new TrafficFlowTemplateV__CreateAddReplaceTFT_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT.");
}
}

void TrafficFlowTemplateV__CreateAddReplaceTFT_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    TrafficFlowTemplateV__CreateAddReplaceTFT_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) numberOfPacketFilters().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) eBIT().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) operationCodeTFT().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) packetFilterList__CreateAddReplaceTFT().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) parametersList().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "numberOfPacketFilters")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          numberOfPacketFilters().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eBIT")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eBIT().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "operationCodeTFT")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          operationCodeTFT().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "packetFilterList_CreateAddReplaceTFT")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          packetFilterList__CreateAddReplaceTFT().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "parametersList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          parametersList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    TrafficFlowTemplateV__CreateAddReplaceTFT_template* precondition = new TrafficFlowTemplateV__CreateAddReplaceTFT_template;
    precondition->set_param(*param.get_elem(0));
    TrafficFlowTemplateV__CreateAddReplaceTFT_template* implied_template = new TrafficFlowTemplateV__CreateAddReplaceTFT_template;
    implied_template->set_param(*param.get_elem(1));
    *this = TrafficFlowTemplateV__CreateAddReplaceTFT_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT");
  }
  is_ifpresent = param.get_ifpresent();
}

void TrafficFlowTemplateV__CreateAddReplaceTFT_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_numberOfPacketFilters.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT");
single_value->field_eBIT.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT");
single_value->field_operationCodeTFT.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT");
single_value->field_packetFilterList__CreateAddReplaceTFT.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT");
single_value->field_parametersList.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.TrafficFlowTemplateV_CreateAddReplaceTFT");
}

boolean TrafficFlowTemplateV__CreateAddReplaceTFT_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean TrafficFlowTemplateV__CreateAddReplaceTFT_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const Parameter ParametersList::UNBOUND_ELEM;
ParametersList::ParametersList()
{
val_ptr = NULL;
}

ParametersList::ParametersList(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

ParametersList::ParametersList(const ParametersList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.ParametersList.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

ParametersList::~ParametersList()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void ParametersList::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

ParametersList& ParametersList::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

ParametersList& ParametersList::operator=(const ParametersList& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @MobileL3_GMM_SM_Types.ParametersList.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean ParametersList::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @MobileL3_GMM_SM_Types.ParametersList.");
return val_ptr->n_elements == 0 ;
}

boolean ParametersList::operator==(const ParametersList& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @MobileL3_GMM_SM_Types.ParametersList.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @MobileL3_GMM_SM_Types.ParametersList.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

Parameter& ParametersList::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @MobileL3_GMM_SM_Types.ParametersList using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (Parameter**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new Parameter(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new Parameter;
}
return *val_ptr->value_elements[index_value];
}

Parameter& ParametersList::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @MobileL3_GMM_SM_Types.ParametersList.");
return (*this)[(int)index_value];
}

const Parameter& ParametersList::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @MobileL3_GMM_SM_Types.ParametersList.");
if (index_value < 0) TTCN_error("Accessing an element of type @MobileL3_GMM_SM_Types.ParametersList using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @MobileL3_GMM_SM_Types.ParametersList: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const Parameter& ParametersList::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @MobileL3_GMM_SM_Types.ParametersList.");
return (*this)[(int)index_value];
}

ParametersList ParametersList::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

ParametersList ParametersList::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

ParametersList ParametersList::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

ParametersList ParametersList::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @MobileL3_GMM_SM_Types.ParametersList.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
ParametersList ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new Parameter(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

ParametersList ParametersList::operator+(const ParametersList& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @MobileL3_GMM_SM_Types.ParametersList concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
ParametersList ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new Parameter(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new Parameter(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

ParametersList ParametersList::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @MobileL3_GMM_SM_Types.ParametersList.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@MobileL3_GMM_SM_Types.ParametersList","element");
ParametersList ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new Parameter(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

ParametersList ParametersList::replace(int index, int len, const ParametersList& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @MobileL3_GMM_SM_Types.ParametersList.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @MobileL3_GMM_SM_Types.ParametersList.");
check_replace_arguments(val_ptr->n_elements, index, len, "@MobileL3_GMM_SM_Types.ParametersList","element");
ParametersList ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new Parameter(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new Parameter(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new Parameter(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

ParametersList ParametersList::replace(int index, int len, const ParametersList_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void ParametersList::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @MobileL3_GMM_SM_Types.ParametersList.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (Parameter**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new Parameter(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (Parameter**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @MobileL3_GMM_SM_Types.ParametersList: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (Parameter**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean ParametersList::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int ParametersList::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @MobileL3_GMM_SM_Types.ParametersList.");
return val_ptr->n_elements;
}

int ParametersList::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @MobileL3_GMM_SM_Types.ParametersList.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void ParametersList::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void ParametersList::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void ParametersList::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@MobileL3_GMM_SM_Types.ParametersList");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@MobileL3_GMM_SM_Types.ParametersList");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void ParametersList::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @MobileL3_GMM_SM_Types.ParametersList.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void ParametersList::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @MobileL3_GMM_SM_Types.ParametersList.");
val_ptr->value_elements = (Parameter**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new Parameter;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void ParametersList::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ParametersList::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ParametersList::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int ParametersList::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void ParametersList_template::copy_value(const ParametersList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @MobileL3_GMM_SM_Types.ParametersList with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (Parameter_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new Parameter_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new Parameter_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void ParametersList_template::copy_template(const ParametersList_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (Parameter_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new Parameter_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new Parameter_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ParametersList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ParametersList_template(*other_value.implication_.precondition);
implication_.implied_template = new ParametersList_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ParametersList.");
break;
}
set_selection(other_value);
}

boolean ParametersList_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const ParametersList_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const ParametersList*)value_ptr)[value_index], legacy);
else return ((const ParametersList_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

ParametersList_template::ParametersList_template()
{
}

ParametersList_template::ParametersList_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

ParametersList_template::ParametersList_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

ParametersList_template::ParametersList_template(const ParametersList& other_value)
{
copy_value(other_value);
}

ParametersList_template::ParametersList_template(const OPTIONAL<ParametersList>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ParametersList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.ParametersList from an unbound optional field.");
}
}

ParametersList_template::ParametersList_template(ParametersList_template* p_precondition, ParametersList_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ParametersList_template::ParametersList_template(Dynamic_Match_Interface<ParametersList>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ParametersList>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ParametersList_template::ParametersList_template(const ParametersList_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

ParametersList_template::~ParametersList_template()
{
clean_up();
}

void ParametersList_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ParametersList_template& ParametersList_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ParametersList_template& ParametersList_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

ParametersList_template& ParametersList_template::operator=(const ParametersList& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ParametersList_template& ParametersList_template::operator=(const OPTIONAL<ParametersList>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ParametersList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.ParametersList.");
}
return *this;
}

ParametersList_template& ParametersList_template::operator=(const ParametersList_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

Parameter_template& ParametersList_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @MobileL3_GMM_SM_Types.ParametersList using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @MobileL3_GMM_SM_Types.ParametersList.");
    break;
}
return *single_value.value_elements[index_value];
}

Parameter_template& ParametersList_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @MobileL3_GMM_SM_Types.ParametersList.");
return (*this)[(int)index_value];
}

const Parameter_template& ParametersList_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @MobileL3_GMM_SM_Types.ParametersList using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @MobileL3_GMM_SM_Types.ParametersList.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @MobileL3_GMM_SM_Types.ParametersList: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const Parameter_template& ParametersList_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @MobileL3_GMM_SM_Types.ParametersList.");
return (*this)[(int)index_value];
}

void ParametersList_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @MobileL3_GMM_SM_Types.ParametersList.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (Parameter_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new Parameter_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new Parameter_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (Parameter_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int ParametersList_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int ParametersList_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.ParametersList which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.ParametersList containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.ParametersList containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.ParametersList containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.ParametersList containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.ParametersList containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ParametersList.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @MobileL3_GMM_SM_Types.ParametersList");
}

boolean ParametersList_template::match(const ParametersList& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ParametersList.");
}
return FALSE;
}

boolean ParametersList_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

ParametersList ParametersList_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.ParametersList.");
ParametersList ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

ParametersList ParametersList_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

ParametersList ParametersList_template::replace(int index, int len, const ParametersList_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

ParametersList ParametersList_template::replace(int index, int len, const ParametersList& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void ParametersList_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new ParametersList_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @MobileL3_GMM_SM_Types.ParametersList.");
}
set_selection(template_type);
}

ParametersList_template& ParametersList_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.ParametersList.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @MobileL3_GMM_SM_Types.ParametersList.");
return value_list.list_value[list_index];
}

void ParametersList_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void ParametersList_template::log_match(const ParametersList& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ParametersList_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ParametersList.");
}
}

void ParametersList_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @MobileL3_GMM_SM_Types.ParametersList.");
single_value.value_elements = (Parameter_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new Parameter_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ParametersList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @MobileL3_GMM_SM_Types.ParametersList.");
}
}

boolean ParametersList_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ParametersList_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void ParametersList_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void ParametersList_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ParametersList_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ParametersList_template* precondition = new ParametersList_template;
    precondition->set_param(*param.get_elem(0));
    ParametersList_template* implied_template = new ParametersList_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ParametersList_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@MobileL3_GMM_SM_Types.ParametersList");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void ParametersList_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ParametersList");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.ParametersList");
}

boolean ParametersList_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
Parameter::Parameter()
{
}

Parameter::Parameter(const OCTETSTRING& par_parameterIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_contents)
  :   field_parameterIdentifier(par_parameterIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_contents(par_contents)
{
}

Parameter::Parameter(const Parameter& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.Parameter.");
if (other_value.parameterIdentifier().is_bound()) field_parameterIdentifier = other_value.parameterIdentifier();
else field_parameterIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.contents().is_bound()) field_contents = other_value.contents();
else field_contents.clean_up();
}

void Parameter::clean_up()
{
field_parameterIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_contents.clean_up();
}

const TTCN_Typedescriptor_t* Parameter::get_descriptor() const { return &Parameter_descr_; }
Parameter& Parameter::operator=(const Parameter& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.Parameter.");
  if (other_value.parameterIdentifier().is_bound()) field_parameterIdentifier = other_value.parameterIdentifier();
  else field_parameterIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.contents().is_bound()) field_contents = other_value.contents();
  else field_contents.clean_up();
}
return *this;
}

boolean Parameter::operator==(const Parameter& other_value) const
{
return field_parameterIdentifier==other_value.field_parameterIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_contents==other_value.field_contents;
}

boolean Parameter::is_bound() const
{
return (field_parameterIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_contents.is_bound());
}
boolean Parameter::is_value() const
{
return field_parameterIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_contents.is_value();
}
void Parameter::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ parameterIdentifier := ");
field_parameterIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", contents := ");
field_contents.log();
TTCN_Logger::log_event_str(" }");
}

void Parameter::set_implicit_omit()
{
if (parameterIdentifier().is_bound()) parameterIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (contents().is_bound()) contents().set_implicit_omit();
}

void Parameter::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.Parameter has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) parameterIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) contents().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "parameterIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          parameterIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "contents")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          contents().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.Parameter: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.Parameter");
  }
}

void Parameter::encode_text(Text_Buf& text_buf) const
{
field_parameterIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_contents.encode_text(text_buf);
}

void Parameter::decode_text(Text_Buf& text_buf)
{
field_parameterIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_contents.decode_text(text_buf);
}

void Parameter::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Parameter::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Parameter::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_parameterIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Parameter_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Parameter_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(Parameter_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_contents.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Parameter::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Parameter_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, OCTETSTRING_descr_.raw);
  encoded_length += field_parameterIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &Parameter_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_contents.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct Parameter_template::single_value_struct {
OCTETSTRING_template field_parameterIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_contents;
};

void Parameter_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_parameterIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_contents = ANY_VALUE;
}
}
}

void Parameter_template::copy_value(const Parameter& other_value)
{
single_value = new single_value_struct;
if (other_value.parameterIdentifier().is_bound()) {
  single_value->field_parameterIdentifier = other_value.parameterIdentifier();
} else {
  single_value->field_parameterIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.contents().is_bound()) {
  single_value->field_contents = other_value.contents();
} else {
  single_value->field_contents.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Parameter_template::copy_template(const Parameter_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.parameterIdentifier().get_selection()) {
single_value->field_parameterIdentifier = other_value.parameterIdentifier();
} else {
single_value->field_parameterIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.contents().get_selection()) {
single_value->field_contents = other_value.contents();
} else {
single_value->field_contents.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Parameter_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Parameter_template(*other_value.implication_.precondition);
implication_.implied_template = new Parameter_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.Parameter.");
break;
}
set_selection(other_value);
}

Parameter_template::Parameter_template()
{
}

Parameter_template::Parameter_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Parameter_template::Parameter_template(const Parameter& other_value)
{
copy_value(other_value);
}

Parameter_template::Parameter_template(const OPTIONAL<Parameter>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Parameter&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.Parameter from an unbound optional field.");
}
}

Parameter_template::Parameter_template(Parameter_template* p_precondition, Parameter_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Parameter_template::Parameter_template(Dynamic_Match_Interface<Parameter>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Parameter>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Parameter_template::Parameter_template(const Parameter_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Parameter_template::~Parameter_template()
{
clean_up();
}

Parameter_template& Parameter_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Parameter_template& Parameter_template::operator=(const Parameter& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Parameter_template& Parameter_template::operator=(const OPTIONAL<Parameter>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Parameter&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.Parameter.");
}
return *this;
}

Parameter_template& Parameter_template::operator=(const Parameter_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Parameter_template::match(const Parameter& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.parameterIdentifier().is_bound()) return FALSE;
if(!single_value->field_parameterIdentifier.match(other_value.parameterIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.contents().is_bound()) return FALSE;
if(!single_value->field_contents.match(other_value.contents(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.Parameter.");
}
return FALSE;
}

boolean Parameter_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_parameterIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_contents.is_bound();
}

boolean Parameter_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_parameterIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_contents.is_value();
}

void Parameter_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Parameter Parameter_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.Parameter.");
Parameter ret_val;
if (single_value->field_parameterIdentifier.is_bound()) {
ret_val.parameterIdentifier() = single_value->field_parameterIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_contents.is_bound()) {
ret_val.contents() = single_value->field_contents.valueof();
}
return ret_val;
}

void Parameter_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.Parameter.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Parameter_template[list_length];
}

Parameter_template& Parameter_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.Parameter.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.Parameter.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Parameter_template::parameterIdentifier()
{
set_specific();
return single_value->field_parameterIdentifier;
}

const OCTETSTRING_template& Parameter_template::parameterIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field parameterIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.Parameter.");
return single_value->field_parameterIdentifier;
}

INTEGER_template& Parameter_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& Parameter_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.Parameter.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& Parameter_template::contents()
{
set_specific();
return single_value->field_contents;
}

const OCTETSTRING_template& Parameter_template::contents() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field contents of a non-specific template of type @MobileL3_GMM_SM_Types.Parameter.");
return single_value->field_contents;
}

int Parameter_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.Parameter which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.Parameter containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.Parameter containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.Parameter containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.Parameter containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.Parameter containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.Parameter containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.Parameter containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.Parameter containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.Parameter.");
  }
  return 0;
}

void Parameter_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ parameterIdentifier := ");
single_value->field_parameterIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", contents := ");
single_value->field_contents.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Parameter_template::log_match(const Parameter& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_parameterIdentifier.match(match_value.parameterIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".parameterIdentifier");
single_value->field_parameterIdentifier.log_match(match_value.parameterIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_contents.match(match_value.contents(), legacy)){
TTCN_Logger::log_logmatch_info(".contents");
single_value->field_contents.log_match(match_value.contents(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ parameterIdentifier := ");
single_value->field_parameterIdentifier.log_match(match_value.parameterIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", contents := ");
single_value->field_contents.log_match(match_value.contents(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Parameter_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (parameterIdentifier().is_bound()) parameterIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (contents().is_bound()) contents().set_implicit_omit();
}

void Parameter_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_parameterIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_contents.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.Parameter.");
}
}

void Parameter_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_parameterIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_contents.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Parameter_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.Parameter.");
}
}

void Parameter_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Parameter_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.Parameter has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) parameterIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) contents().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "parameterIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          parameterIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "contents")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          contents().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.Parameter: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Parameter_template* precondition = new Parameter_template;
    precondition->set_param(*param.get_elem(0));
    Parameter_template* implied_template = new Parameter_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Parameter_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.Parameter");
  }
  is_ifpresent = param.get_ifpresent();
}

void Parameter_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_parameterIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.Parameter");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.Parameter");
single_value->field_contents.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.Parameter");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.Parameter");
}

boolean Parameter_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Parameter_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const PacketFilterIdentifier PacketFilterList__DeletePacketFilter::UNBOUND_ELEM;
PacketFilterList__DeletePacketFilter::PacketFilterList__DeletePacketFilter()
{
val_ptr = NULL;
}

PacketFilterList__DeletePacketFilter::PacketFilterList__DeletePacketFilter(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

PacketFilterList__DeletePacketFilter::PacketFilterList__DeletePacketFilter(const PacketFilterList__DeletePacketFilter& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

PacketFilterList__DeletePacketFilter::~PacketFilterList__DeletePacketFilter()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void PacketFilterList__DeletePacketFilter::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

PacketFilterList__DeletePacketFilter& PacketFilterList__DeletePacketFilter::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

PacketFilterList__DeletePacketFilter& PacketFilterList__DeletePacketFilter::operator=(const PacketFilterList__DeletePacketFilter& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean PacketFilterList__DeletePacketFilter::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
return val_ptr->n_elements == 0 ;
}

boolean PacketFilterList__DeletePacketFilter::operator==(const PacketFilterList__DeletePacketFilter& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

PacketFilterIdentifier& PacketFilterList__DeletePacketFilter::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (PacketFilterIdentifier**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new PacketFilterIdentifier(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new PacketFilterIdentifier;
}
return *val_ptr->value_elements[index_value];
}

PacketFilterIdentifier& PacketFilterList__DeletePacketFilter::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
return (*this)[(int)index_value];
}

const PacketFilterIdentifier& PacketFilterList__DeletePacketFilter::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
if (index_value < 0) TTCN_error("Accessing an element of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const PacketFilterIdentifier& PacketFilterList__DeletePacketFilter::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
return (*this)[(int)index_value];
}

PacketFilterList__DeletePacketFilter PacketFilterList__DeletePacketFilter::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

PacketFilterList__DeletePacketFilter PacketFilterList__DeletePacketFilter::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

PacketFilterList__DeletePacketFilter PacketFilterList__DeletePacketFilter::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

PacketFilterList__DeletePacketFilter PacketFilterList__DeletePacketFilter::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
PacketFilterList__DeletePacketFilter ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new PacketFilterIdentifier(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

PacketFilterList__DeletePacketFilter PacketFilterList__DeletePacketFilter::operator+(const PacketFilterList__DeletePacketFilter& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
PacketFilterList__DeletePacketFilter ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new PacketFilterIdentifier(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new PacketFilterIdentifier(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

PacketFilterList__DeletePacketFilter PacketFilterList__DeletePacketFilter::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter","element");
PacketFilterList__DeletePacketFilter ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new PacketFilterIdentifier(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

PacketFilterList__DeletePacketFilter PacketFilterList__DeletePacketFilter::replace(int index, int len, const PacketFilterList__DeletePacketFilter& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
check_replace_arguments(val_ptr->n_elements, index, len, "@MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter","element");
PacketFilterList__DeletePacketFilter ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new PacketFilterIdentifier(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new PacketFilterIdentifier(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new PacketFilterIdentifier(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

PacketFilterList__DeletePacketFilter PacketFilterList__DeletePacketFilter::replace(int index, int len, const PacketFilterList__DeletePacketFilter_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void PacketFilterList__DeletePacketFilter::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (PacketFilterIdentifier**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new PacketFilterIdentifier(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (PacketFilterIdentifier**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (PacketFilterIdentifier**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean PacketFilterList__DeletePacketFilter::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int PacketFilterList__DeletePacketFilter::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
return val_ptr->n_elements;
}

int PacketFilterList__DeletePacketFilter::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void PacketFilterList__DeletePacketFilter::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void PacketFilterList__DeletePacketFilter::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void PacketFilterList__DeletePacketFilter::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void PacketFilterList__DeletePacketFilter::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void PacketFilterList__DeletePacketFilter::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
val_ptr->value_elements = (PacketFilterIdentifier**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new PacketFilterIdentifier;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void PacketFilterList__DeletePacketFilter::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketFilterList__DeletePacketFilter::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketFilterList__DeletePacketFilter::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int PacketFilterList__DeletePacketFilter::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void PacketFilterList__DeletePacketFilter_template::copy_value(const PacketFilterList__DeletePacketFilter& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (PacketFilterIdentifier_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new PacketFilterIdentifier_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new PacketFilterIdentifier_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void PacketFilterList__DeletePacketFilter_template::copy_template(const PacketFilterList__DeletePacketFilter_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (PacketFilterIdentifier_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new PacketFilterIdentifier_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new PacketFilterIdentifier_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketFilterList__DeletePacketFilter_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketFilterList__DeletePacketFilter_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketFilterList__DeletePacketFilter_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
break;
}
set_selection(other_value);
}

boolean PacketFilterList__DeletePacketFilter_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const PacketFilterList__DeletePacketFilter_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const PacketFilterList__DeletePacketFilter*)value_ptr)[value_index], legacy);
else return ((const PacketFilterList__DeletePacketFilter_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

PacketFilterList__DeletePacketFilter_template::PacketFilterList__DeletePacketFilter_template()
{
}

PacketFilterList__DeletePacketFilter_template::PacketFilterList__DeletePacketFilter_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

PacketFilterList__DeletePacketFilter_template::PacketFilterList__DeletePacketFilter_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

PacketFilterList__DeletePacketFilter_template::PacketFilterList__DeletePacketFilter_template(const PacketFilterList__DeletePacketFilter& other_value)
{
copy_value(other_value);
}

PacketFilterList__DeletePacketFilter_template::PacketFilterList__DeletePacketFilter_template(const OPTIONAL<PacketFilterList__DeletePacketFilter>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketFilterList__DeletePacketFilter&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter from an unbound optional field.");
}
}

PacketFilterList__DeletePacketFilter_template::PacketFilterList__DeletePacketFilter_template(PacketFilterList__DeletePacketFilter_template* p_precondition, PacketFilterList__DeletePacketFilter_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketFilterList__DeletePacketFilter_template::PacketFilterList__DeletePacketFilter_template(Dynamic_Match_Interface<PacketFilterList__DeletePacketFilter>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketFilterList__DeletePacketFilter>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketFilterList__DeletePacketFilter_template::PacketFilterList__DeletePacketFilter_template(const PacketFilterList__DeletePacketFilter_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

PacketFilterList__DeletePacketFilter_template::~PacketFilterList__DeletePacketFilter_template()
{
clean_up();
}

void PacketFilterList__DeletePacketFilter_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketFilterList__DeletePacketFilter_template& PacketFilterList__DeletePacketFilter_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketFilterList__DeletePacketFilter_template& PacketFilterList__DeletePacketFilter_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

PacketFilterList__DeletePacketFilter_template& PacketFilterList__DeletePacketFilter_template::operator=(const PacketFilterList__DeletePacketFilter& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketFilterList__DeletePacketFilter_template& PacketFilterList__DeletePacketFilter_template::operator=(const OPTIONAL<PacketFilterList__DeletePacketFilter>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketFilterList__DeletePacketFilter&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
}
return *this;
}

PacketFilterList__DeletePacketFilter_template& PacketFilterList__DeletePacketFilter_template::operator=(const PacketFilterList__DeletePacketFilter_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

PacketFilterIdentifier_template& PacketFilterList__DeletePacketFilter_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
    break;
}
return *single_value.value_elements[index_value];
}

PacketFilterIdentifier_template& PacketFilterList__DeletePacketFilter_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
return (*this)[(int)index_value];
}

const PacketFilterIdentifier_template& PacketFilterList__DeletePacketFilter_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const PacketFilterIdentifier_template& PacketFilterList__DeletePacketFilter_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
return (*this)[(int)index_value];
}

void PacketFilterList__DeletePacketFilter_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @MobileL3_GMM_SM_Types.PacketFilterList_DeletePacketFilter.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (PacketFilterIdentifier_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; e