// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "GTPC_Types.hh"

namespace GTPC__Types {

/* Member functions of C++ classes */

RIM__Application__Identity__GTPC::RIM__Application__Identity__GTPC()
{
}

RIM__Application__Identity__GTPC::RIM__Application__Identity__GTPC(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a__GTPC& par_lengthIndicator,
    const OCTETSTRING& par_rIMApplicationIdentity)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_rIMApplicationIdentity(par_rIMApplicationIdentity)
{
}

RIM__Application__Identity__GTPC::RIM__Application__Identity__GTPC(const RIM__Application__Identity__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.RIM_Application_Identity_GTPC.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.rIMApplicationIdentity().is_bound()) field_rIMApplicationIdentity = other_value.rIMApplicationIdentity();
else field_rIMApplicationIdentity.clean_up();
}

void RIM__Application__Identity__GTPC::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_rIMApplicationIdentity.clean_up();
}

const TTCN_Typedescriptor_t* RIM__Application__Identity__GTPC::get_descriptor() const { return &RIM__Application__Identity__GTPC_descr_; }
RIM__Application__Identity__GTPC& RIM__Application__Identity__GTPC::operator=(const RIM__Application__Identity__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.RIM_Application_Identity_GTPC.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.rIMApplicationIdentity().is_bound()) field_rIMApplicationIdentity = other_value.rIMApplicationIdentity();
  else field_rIMApplicationIdentity.clean_up();
}
return *this;
}

boolean RIM__Application__Identity__GTPC::operator==(const RIM__Application__Identity__GTPC& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_rIMApplicationIdentity==other_value.field_rIMApplicationIdentity;
}

boolean RIM__Application__Identity__GTPC::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_rIMApplicationIdentity.is_bound());
}
boolean RIM__Application__Identity__GTPC::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_rIMApplicationIdentity.is_value();
}
void RIM__Application__Identity__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", rIMApplicationIdentity := ");
field_rIMApplicationIdentity.log();
TTCN_Logger::log_event_str(" }");
}

void RIM__Application__Identity__GTPC::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (rIMApplicationIdentity().is_bound()) rIMApplicationIdentity().set_implicit_omit();
}

void RIM__Application__Identity__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @GTPC_Types.RIM_Application_Identity_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rIMApplicationIdentity().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIMApplicationIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIMApplicationIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RIM_Application_Identity_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.RIM_Application_Identity_GTPC");
  }
}

void RIM__Application__Identity__GTPC::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_rIMApplicationIdentity.encode_text(text_buf);
}

void RIM__Application__Identity__GTPC::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_rIMApplicationIdentity.decode_text(text_buf);
}

void RIM__Application__Identity__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RIM__Application__Identity__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RIM__Application__Identity__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RIM__Application__Identity__GTPC_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(RIM__Application__Identity__GTPC_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_3) selected_field = 0;
  else if (field_ext ==  bs_24) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RIM__Application__Identity__GTPC_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(RIM__Application__Identity__GTPC_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a__GTPC_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a__GTPC::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a__GTPC_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_rIMApplicationIdentity.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RIM__Application__Identity__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RIM__Application__Identity__GTPC_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RIM__Application__Identity__GTPC_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT1_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(RIM__Application__Identity__GTPC_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(RIM__Application__Identity__GTPC_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_rIMApplicationIdentity.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1:
  if (field_ext !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(RIM__Application__Identity__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a__GTPC::ALT_length2:
  if (field_ext !=  bs_24) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_24.RAW_encode(RIM__Application__Identity__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  return myleaf.length = encoded_length;
}

struct RIM__Application__Identity__GTPC_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a__GTPC_template field_lengthIndicator;
OCTETSTRING_template field_rIMApplicationIdentity;
};

void RIM__Application__Identity__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_rIMApplicationIdentity = ANY_VALUE;
}
}
}

void RIM__Application__Identity__GTPC_template::copy_value(const RIM__Application__Identity__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.rIMApplicationIdentity().is_bound()) {
  single_value->field_rIMApplicationIdentity = other_value.rIMApplicationIdentity();
} else {
  single_value->field_rIMApplicationIdentity.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RIM__Application__Identity__GTPC_template::copy_template(const RIM__Application__Identity__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rIMApplicationIdentity().get_selection()) {
single_value->field_rIMApplicationIdentity = other_value.rIMApplicationIdentity();
} else {
single_value->field_rIMApplicationIdentity.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RIM__Application__Identity__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RIM__Application__Identity__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new RIM__Application__Identity__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
break;
}
set_selection(other_value);
}

RIM__Application__Identity__GTPC_template::RIM__Application__Identity__GTPC_template()
{
}

RIM__Application__Identity__GTPC_template::RIM__Application__Identity__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RIM__Application__Identity__GTPC_template::RIM__Application__Identity__GTPC_template(const RIM__Application__Identity__GTPC& other_value)
{
copy_value(other_value);
}

RIM__Application__Identity__GTPC_template::RIM__Application__Identity__GTPC_template(const OPTIONAL<RIM__Application__Identity__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RIM__Application__Identity__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.RIM_Application_Identity_GTPC from an unbound optional field.");
}
}

RIM__Application__Identity__GTPC_template::RIM__Application__Identity__GTPC_template(RIM__Application__Identity__GTPC_template* p_precondition, RIM__Application__Identity__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RIM__Application__Identity__GTPC_template::RIM__Application__Identity__GTPC_template(Dynamic_Match_Interface<RIM__Application__Identity__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RIM__Application__Identity__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RIM__Application__Identity__GTPC_template::RIM__Application__Identity__GTPC_template(const RIM__Application__Identity__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RIM__Application__Identity__GTPC_template::~RIM__Application__Identity__GTPC_template()
{
clean_up();
}

RIM__Application__Identity__GTPC_template& RIM__Application__Identity__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RIM__Application__Identity__GTPC_template& RIM__Application__Identity__GTPC_template::operator=(const RIM__Application__Identity__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RIM__Application__Identity__GTPC_template& RIM__Application__Identity__GTPC_template::operator=(const OPTIONAL<RIM__Application__Identity__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RIM__Application__Identity__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
}
return *this;
}

RIM__Application__Identity__GTPC_template& RIM__Application__Identity__GTPC_template::operator=(const RIM__Application__Identity__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RIM__Application__Identity__GTPC_template::match(const RIM__Application__Identity__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.rIMApplicationIdentity().is_bound()) return FALSE;
if(!single_value->field_rIMApplicationIdentity.match(other_value.rIMApplicationIdentity(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
}
return FALSE;
}

boolean RIM__Application__Identity__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_rIMApplicationIdentity.is_bound();
}

boolean RIM__Application__Identity__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_rIMApplicationIdentity.is_value();
}

void RIM__Application__Identity__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RIM__Application__Identity__GTPC RIM__Application__Identity__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
RIM__Application__Identity__GTPC ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_rIMApplicationIdentity.is_bound()) {
ret_val.rIMApplicationIdentity() = single_value->field_rIMApplicationIdentity.valueof();
}
return ret_val;
}

void RIM__Application__Identity__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RIM__Application__Identity__GTPC_template[list_length];
}

RIM__Application__Identity__GTPC_template& RIM__Application__Identity__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RIM__Application__Identity__GTPC_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& RIM__Application__Identity__GTPC_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
return single_value->field_iEI;
}

BITSTRING_template& RIM__Application__Identity__GTPC_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& RIM__Application__Identity__GTPC_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
return single_value->field_ext;
}

LIN2__2a__GTPC_template& RIM__Application__Identity__GTPC_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a__GTPC_template& RIM__Application__Identity__GTPC_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& RIM__Application__Identity__GTPC_template::rIMApplicationIdentity()
{
set_specific();
return single_value->field_rIMApplicationIdentity;
}

const OCTETSTRING_template& RIM__Application__Identity__GTPC_template::rIMApplicationIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rIMApplicationIdentity of a non-specific template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
return single_value->field_rIMApplicationIdentity;
}

int RIM__Application__Identity__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Application_Identity_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.RIM_Application_Identity_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Application_Identity_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Application_Identity_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Application_Identity_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Application_Identity_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Application_Identity_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Application_Identity_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Application_Identity_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
  }
  return 0;
}

void RIM__Application__Identity__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", rIMApplicationIdentity := ");
single_value->field_rIMApplicationIdentity.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RIM__Application__Identity__GTPC_template::log_match(const RIM__Application__Identity__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rIMApplicationIdentity.match(match_value.rIMApplicationIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".rIMApplicationIdentity");
single_value->field_rIMApplicationIdentity.log_match(match_value.rIMApplicationIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", rIMApplicationIdentity := ");
single_value->field_rIMApplicationIdentity.log_match(match_value.rIMApplicationIdentity(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RIM__Application__Identity__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (rIMApplicationIdentity().is_bound()) rIMApplicationIdentity().set_implicit_omit();
}

void RIM__Application__Identity__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_rIMApplicationIdentity.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
}
}

void RIM__Application__Identity__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_rIMApplicationIdentity.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RIM__Application__Identity__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.RIM_Application_Identity_GTPC.");
}
}

void RIM__Application__Identity__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RIM__Application__Identity__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @GTPC_Types.RIM_Application_Identity_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rIMApplicationIdentity().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIMApplicationIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIMApplicationIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RIM_Application_Identity_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RIM__Application__Identity__GTPC_template* precondition = new RIM__Application__Identity__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    RIM__Application__Identity__GTPC_template* implied_template = new RIM__Application__Identity__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RIM__Application__Identity__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.RIM_Application_Identity_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void RIM__Application__Identity__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_Application_Identity_GTPC");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_Application_Identity_GTPC");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_Application_Identity_GTPC");
single_value->field_rIMApplicationIdentity.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_Application_Identity_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.RIM_Application_Identity_GTPC");
}

boolean RIM__Application__Identity__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RIM__Application__Identity__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RIM__Sequence__Number__GTPC::RIM__Sequence__Number__GTPC()
{
}

RIM__Sequence__Number__GTPC::RIM__Sequence__Number__GTPC(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a__GTPC& par_lengthIndicator,
    const OCTETSTRING& par_rIMSequenceNumber)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_rIMSequenceNumber(par_rIMSequenceNumber)
{
}

RIM__Sequence__Number__GTPC::RIM__Sequence__Number__GTPC(const RIM__Sequence__Number__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.rIMSequenceNumber().is_bound()) field_rIMSequenceNumber = other_value.rIMSequenceNumber();
else field_rIMSequenceNumber.clean_up();
}

void RIM__Sequence__Number__GTPC::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_rIMSequenceNumber.clean_up();
}

const TTCN_Typedescriptor_t* RIM__Sequence__Number__GTPC::get_descriptor() const { return &RIM__Sequence__Number__GTPC_descr_; }
RIM__Sequence__Number__GTPC& RIM__Sequence__Number__GTPC::operator=(const RIM__Sequence__Number__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.rIMSequenceNumber().is_bound()) field_rIMSequenceNumber = other_value.rIMSequenceNumber();
  else field_rIMSequenceNumber.clean_up();
}
return *this;
}

boolean RIM__Sequence__Number__GTPC::operator==(const RIM__Sequence__Number__GTPC& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_rIMSequenceNumber==other_value.field_rIMSequenceNumber;
}

boolean RIM__Sequence__Number__GTPC::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_rIMSequenceNumber.is_bound());
}
boolean RIM__Sequence__Number__GTPC::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_rIMSequenceNumber.is_value();
}
void RIM__Sequence__Number__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", rIMSequenceNumber := ");
field_rIMSequenceNumber.log();
TTCN_Logger::log_event_str(" }");
}

void RIM__Sequence__Number__GTPC::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (rIMSequenceNumber().is_bound()) rIMSequenceNumber().set_implicit_omit();
}

void RIM__Sequence__Number__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @GTPC_Types.RIM_Sequence_Number_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rIMSequenceNumber().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIMSequenceNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIMSequenceNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RIM_Sequence_Number_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.RIM_Sequence_Number_GTPC");
  }
}

void RIM__Sequence__Number__GTPC::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_rIMSequenceNumber.encode_text(text_buf);
}

void RIM__Sequence__Number__GTPC::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_rIMSequenceNumber.decode_text(text_buf);
}

void RIM__Sequence__Number__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RIM__Sequence__Number__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RIM__Sequence__Number__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RIM__Sequence__Number__GTPC_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(RIM__Sequence__Number__GTPC_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_3) selected_field = 0;
  else if (field_ext ==  bs_24) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RIM__Sequence__Number__GTPC_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(RIM__Sequence__Number__GTPC_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a__GTPC_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a__GTPC::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a__GTPC_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT4_descr_.raw->forceomit);
  decoded_field_length = field_rIMSequenceNumber.RAW_decode(General__Types::OCT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RIM__Sequence__Number__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RIM__Sequence__Number__GTPC_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RIM__Sequence__Number__GTPC_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT4_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(RIM__Sequence__Number__GTPC_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(RIM__Sequence__Number__GTPC_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_rIMSequenceNumber.RAW_encode(General__Types::OCT4_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1:
  if (field_ext !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(RIM__Sequence__Number__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a__GTPC::ALT_length2:
  if (field_ext !=  bs_24) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_24.RAW_encode(RIM__Sequence__Number__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  return myleaf.length = encoded_length;
}

struct RIM__Sequence__Number__GTPC_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a__GTPC_template field_lengthIndicator;
OCTETSTRING_template field_rIMSequenceNumber;
};

void RIM__Sequence__Number__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_rIMSequenceNumber = ANY_VALUE;
}
}
}

void RIM__Sequence__Number__GTPC_template::copy_value(const RIM__Sequence__Number__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.rIMSequenceNumber().is_bound()) {
  single_value->field_rIMSequenceNumber = other_value.rIMSequenceNumber();
} else {
  single_value->field_rIMSequenceNumber.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RIM__Sequence__Number__GTPC_template::copy_template(const RIM__Sequence__Number__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rIMSequenceNumber().get_selection()) {
single_value->field_rIMSequenceNumber = other_value.rIMSequenceNumber();
} else {
single_value->field_rIMSequenceNumber.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RIM__Sequence__Number__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RIM__Sequence__Number__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new RIM__Sequence__Number__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
break;
}
set_selection(other_value);
}

RIM__Sequence__Number__GTPC_template::RIM__Sequence__Number__GTPC_template()
{
}

RIM__Sequence__Number__GTPC_template::RIM__Sequence__Number__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RIM__Sequence__Number__GTPC_template::RIM__Sequence__Number__GTPC_template(const RIM__Sequence__Number__GTPC& other_value)
{
copy_value(other_value);
}

RIM__Sequence__Number__GTPC_template::RIM__Sequence__Number__GTPC_template(const OPTIONAL<RIM__Sequence__Number__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RIM__Sequence__Number__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.RIM_Sequence_Number_GTPC from an unbound optional field.");
}
}

RIM__Sequence__Number__GTPC_template::RIM__Sequence__Number__GTPC_template(RIM__Sequence__Number__GTPC_template* p_precondition, RIM__Sequence__Number__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RIM__Sequence__Number__GTPC_template::RIM__Sequence__Number__GTPC_template(Dynamic_Match_Interface<RIM__Sequence__Number__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RIM__Sequence__Number__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RIM__Sequence__Number__GTPC_template::RIM__Sequence__Number__GTPC_template(const RIM__Sequence__Number__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RIM__Sequence__Number__GTPC_template::~RIM__Sequence__Number__GTPC_template()
{
clean_up();
}

RIM__Sequence__Number__GTPC_template& RIM__Sequence__Number__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RIM__Sequence__Number__GTPC_template& RIM__Sequence__Number__GTPC_template::operator=(const RIM__Sequence__Number__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RIM__Sequence__Number__GTPC_template& RIM__Sequence__Number__GTPC_template::operator=(const OPTIONAL<RIM__Sequence__Number__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RIM__Sequence__Number__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
}
return *this;
}

RIM__Sequence__Number__GTPC_template& RIM__Sequence__Number__GTPC_template::operator=(const RIM__Sequence__Number__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RIM__Sequence__Number__GTPC_template::match(const RIM__Sequence__Number__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.rIMSequenceNumber().is_bound()) return FALSE;
if(!single_value->field_rIMSequenceNumber.match(other_value.rIMSequenceNumber(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
}
return FALSE;
}

boolean RIM__Sequence__Number__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_rIMSequenceNumber.is_bound();
}

boolean RIM__Sequence__Number__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_rIMSequenceNumber.is_value();
}

void RIM__Sequence__Number__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RIM__Sequence__Number__GTPC RIM__Sequence__Number__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
RIM__Sequence__Number__GTPC ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_rIMSequenceNumber.is_bound()) {
ret_val.rIMSequenceNumber() = single_value->field_rIMSequenceNumber.valueof();
}
return ret_val;
}

void RIM__Sequence__Number__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RIM__Sequence__Number__GTPC_template[list_length];
}

RIM__Sequence__Number__GTPC_template& RIM__Sequence__Number__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RIM__Sequence__Number__GTPC_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& RIM__Sequence__Number__GTPC_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
return single_value->field_iEI;
}

BITSTRING_template& RIM__Sequence__Number__GTPC_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& RIM__Sequence__Number__GTPC_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
return single_value->field_ext;
}

LIN2__2a__GTPC_template& RIM__Sequence__Number__GTPC_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a__GTPC_template& RIM__Sequence__Number__GTPC_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& RIM__Sequence__Number__GTPC_template::rIMSequenceNumber()
{
set_specific();
return single_value->field_rIMSequenceNumber;
}

const OCTETSTRING_template& RIM__Sequence__Number__GTPC_template::rIMSequenceNumber() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rIMSequenceNumber of a non-specific template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
return single_value->field_rIMSequenceNumber;
}

int RIM__Sequence__Number__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Sequence_Number_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.RIM_Sequence_Number_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Sequence_Number_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Sequence_Number_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Sequence_Number_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Sequence_Number_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Sequence_Number_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Sequence_Number_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Sequence_Number_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
  }
  return 0;
}

void RIM__Sequence__Number__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", rIMSequenceNumber := ");
single_value->field_rIMSequenceNumber.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RIM__Sequence__Number__GTPC_template::log_match(const RIM__Sequence__Number__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rIMSequenceNumber.match(match_value.rIMSequenceNumber(), legacy)){
TTCN_Logger::log_logmatch_info(".rIMSequenceNumber");
single_value->field_rIMSequenceNumber.log_match(match_value.rIMSequenceNumber(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", rIMSequenceNumber := ");
single_value->field_rIMSequenceNumber.log_match(match_value.rIMSequenceNumber(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RIM__Sequence__Number__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (rIMSequenceNumber().is_bound()) rIMSequenceNumber().set_implicit_omit();
}

void RIM__Sequence__Number__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_rIMSequenceNumber.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
}
}

void RIM__Sequence__Number__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_rIMSequenceNumber.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RIM__Sequence__Number__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.RIM_Sequence_Number_GTPC.");
}
}

void RIM__Sequence__Number__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RIM__Sequence__Number__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @GTPC_Types.RIM_Sequence_Number_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rIMSequenceNumber().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIMSequenceNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIMSequenceNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RIM_Sequence_Number_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RIM__Sequence__Number__GTPC_template* precondition = new RIM__Sequence__Number__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    RIM__Sequence__Number__GTPC_template* implied_template = new RIM__Sequence__Number__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RIM__Sequence__Number__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.RIM_Sequence_Number_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void RIM__Sequence__Number__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_Sequence_Number_GTPC");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_Sequence_Number_GTPC");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_Sequence_Number_GTPC");
single_value->field_rIMSequenceNumber.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_Sequence_Number_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.RIM_Sequence_Number_GTPC");
}

boolean RIM__Sequence__Number__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RIM__Sequence__Number__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RIM__PDU__Indications__GTPC::RIM__PDU__Indications__GTPC()
{
}

RIM__PDU__Indications__GTPC::RIM__PDU__Indications__GTPC(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a__GTPC& par_lengthIndicator,
    const BITSTRING& par_ack,
    const BITSTRING& par_pDU__Type__Extension,
    const BITSTRING& par_reserved)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_ack(par_ack),
  field_pDU__Type__Extension(par_pDU__Type__Extension),
  field_reserved(par_reserved)
{
}

RIM__PDU__Indications__GTPC::RIM__PDU__Indications__GTPC(const RIM__PDU__Indications__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.ack().is_bound()) field_ack = other_value.ack();
else field_ack.clean_up();
if (other_value.pDU__Type__Extension().is_bound()) field_pDU__Type__Extension = other_value.pDU__Type__Extension();
else field_pDU__Type__Extension.clean_up();
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
}

void RIM__PDU__Indications__GTPC::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_ack.clean_up();
field_pDU__Type__Extension.clean_up();
field_reserved.clean_up();
}

const TTCN_Typedescriptor_t* RIM__PDU__Indications__GTPC::get_descriptor() const { return &RIM__PDU__Indications__GTPC_descr_; }
RIM__PDU__Indications__GTPC& RIM__PDU__Indications__GTPC::operator=(const RIM__PDU__Indications__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.ack().is_bound()) field_ack = other_value.ack();
  else field_ack.clean_up();
  if (other_value.pDU__Type__Extension().is_bound()) field_pDU__Type__Extension = other_value.pDU__Type__Extension();
  else field_pDU__Type__Extension.clean_up();
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
}
return *this;
}

boolean RIM__PDU__Indications__GTPC::operator==(const RIM__PDU__Indications__GTPC& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_ack==other_value.field_ack
  && field_pDU__Type__Extension==other_value.field_pDU__Type__Extension
  && field_reserved==other_value.field_reserved;
}

boolean RIM__PDU__Indications__GTPC::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_ack.is_bound())
  || (field_pDU__Type__Extension.is_bound())
  || (field_reserved.is_bound());
}
boolean RIM__PDU__Indications__GTPC::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_ack.is_value()
  && field_pDU__Type__Extension.is_value()
  && field_reserved.is_value();
}
void RIM__PDU__Indications__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", ack := ");
field_ack.log();
TTCN_Logger::log_event_str(", pDU_Type_Extension := ");
field_pDU__Type__Extension.log();
TTCN_Logger::log_event_str(", reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(" }");
}

void RIM__PDU__Indications__GTPC::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (ack().is_bound()) ack().set_implicit_omit();
if (pDU__Type__Extension().is_bound()) pDU__Type__Extension().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
}

void RIM__PDU__Indications__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @GTPC_Types.RIM_PDU_Indications_GTPC has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ack().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) pDU__Type__Extension().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ack")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ack().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pDU_Type_Extension")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pDU__Type__Extension().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RIM_PDU_Indications_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.RIM_PDU_Indications_GTPC");
  }
}

void RIM__PDU__Indications__GTPC::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_ack.encode_text(text_buf);
field_pDU__Type__Extension.encode_text(text_buf);
field_reserved.encode_text(text_buf);
}

void RIM__PDU__Indications__GTPC::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_ack.decode_text(text_buf);
field_pDU__Type__Extension.decode_text(text_buf);
field_reserved.decode_text(text_buf);
}

void RIM__PDU__Indications__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RIM__PDU__Indications__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RIM__PDU__Indications__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RIM__PDU__Indications__GTPC_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(RIM__PDU__Indications__GTPC_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_3) selected_field = 0;
  else if (field_ext ==  bs_24) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RIM__PDU__Indications__GTPC_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(RIM__PDU__Indications__GTPC_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a__GTPC_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a__GTPC::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a__GTPC_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_ack.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_pDU__Type__Extension.RAW_decode(General__Types::BIT3_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RIM__PDU__Indications__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RIM__PDU__Indications__GTPC_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RIM__PDU__Indications__GTPC_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::BIT4_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(RIM__PDU__Indications__GTPC_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(RIM__PDU__Indications__GTPC_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_ack.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_pDU__Type__Extension.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_reserved.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[5]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1:
  if (field_ext !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(RIM__PDU__Indications__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a__GTPC::ALT_length2:
  if (field_ext !=  bs_24) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_24.RAW_encode(RIM__PDU__Indications__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  return myleaf.length = encoded_length;
}

struct RIM__PDU__Indications__GTPC_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a__GTPC_template field_lengthIndicator;
BITSTRING_template field_ack;
BITSTRING_template field_pDU__Type__Extension;
BITSTRING_template field_reserved;
};

void RIM__PDU__Indications__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_ack = ANY_VALUE;
single_value->field_pDU__Type__Extension = ANY_VALUE;
single_value->field_reserved = ANY_VALUE;
}
}
}

void RIM__PDU__Indications__GTPC_template::copy_value(const RIM__PDU__Indications__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.ack().is_bound()) {
  single_value->field_ack = other_value.ack();
} else {
  single_value->field_ack.clean_up();
}
if (other_value.pDU__Type__Extension().is_bound()) {
  single_value->field_pDU__Type__Extension = other_value.pDU__Type__Extension();
} else {
  single_value->field_pDU__Type__Extension.clean_up();
}
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RIM__PDU__Indications__GTPC_template::copy_template(const RIM__PDU__Indications__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ack().get_selection()) {
single_value->field_ack = other_value.ack();
} else {
single_value->field_ack.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pDU__Type__Extension().get_selection()) {
single_value->field_pDU__Type__Extension = other_value.pDU__Type__Extension();
} else {
single_value->field_pDU__Type__Extension.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RIM__PDU__Indications__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RIM__PDU__Indications__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new RIM__PDU__Indications__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
break;
}
set_selection(other_value);
}

RIM__PDU__Indications__GTPC_template::RIM__PDU__Indications__GTPC_template()
{
}

RIM__PDU__Indications__GTPC_template::RIM__PDU__Indications__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RIM__PDU__Indications__GTPC_template::RIM__PDU__Indications__GTPC_template(const RIM__PDU__Indications__GTPC& other_value)
{
copy_value(other_value);
}

RIM__PDU__Indications__GTPC_template::RIM__PDU__Indications__GTPC_template(const OPTIONAL<RIM__PDU__Indications__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RIM__PDU__Indications__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.RIM_PDU_Indications_GTPC from an unbound optional field.");
}
}

RIM__PDU__Indications__GTPC_template::RIM__PDU__Indications__GTPC_template(RIM__PDU__Indications__GTPC_template* p_precondition, RIM__PDU__Indications__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RIM__PDU__Indications__GTPC_template::RIM__PDU__Indications__GTPC_template(Dynamic_Match_Interface<RIM__PDU__Indications__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RIM__PDU__Indications__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RIM__PDU__Indications__GTPC_template::RIM__PDU__Indications__GTPC_template(const RIM__PDU__Indications__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RIM__PDU__Indications__GTPC_template::~RIM__PDU__Indications__GTPC_template()
{
clean_up();
}

RIM__PDU__Indications__GTPC_template& RIM__PDU__Indications__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RIM__PDU__Indications__GTPC_template& RIM__PDU__Indications__GTPC_template::operator=(const RIM__PDU__Indications__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RIM__PDU__Indications__GTPC_template& RIM__PDU__Indications__GTPC_template::operator=(const OPTIONAL<RIM__PDU__Indications__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RIM__PDU__Indications__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
}
return *this;
}

RIM__PDU__Indications__GTPC_template& RIM__PDU__Indications__GTPC_template::operator=(const RIM__PDU__Indications__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RIM__PDU__Indications__GTPC_template::match(const RIM__PDU__Indications__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.ack().is_bound()) return FALSE;
if(!single_value->field_ack.match(other_value.ack(), legacy))return FALSE;
if(!other_value.pDU__Type__Extension().is_bound()) return FALSE;
if(!single_value->field_pDU__Type__Extension.match(other_value.pDU__Type__Extension(), legacy))return FALSE;
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
}
return FALSE;
}

boolean RIM__PDU__Indications__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_ack.is_bound()
 || single_value->field_pDU__Type__Extension.is_bound()
 || single_value->field_reserved.is_bound();
}

boolean RIM__PDU__Indications__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_ack.is_value()
 && single_value->field_pDU__Type__Extension.is_value()
 && single_value->field_reserved.is_value();
}

void RIM__PDU__Indications__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RIM__PDU__Indications__GTPC RIM__PDU__Indications__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
RIM__PDU__Indications__GTPC ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_ack.is_bound()) {
ret_val.ack() = single_value->field_ack.valueof();
}
if (single_value->field_pDU__Type__Extension.is_bound()) {
ret_val.pDU__Type__Extension() = single_value->field_pDU__Type__Extension.valueof();
}
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
return ret_val;
}

void RIM__PDU__Indications__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RIM__PDU__Indications__GTPC_template[list_length];
}

RIM__PDU__Indications__GTPC_template& RIM__PDU__Indications__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RIM__PDU__Indications__GTPC_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& RIM__PDU__Indications__GTPC_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
return single_value->field_iEI;
}

BITSTRING_template& RIM__PDU__Indications__GTPC_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& RIM__PDU__Indications__GTPC_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
return single_value->field_ext;
}

LIN2__2a__GTPC_template& RIM__PDU__Indications__GTPC_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a__GTPC_template& RIM__PDU__Indications__GTPC_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& RIM__PDU__Indications__GTPC_template::ack()
{
set_specific();
return single_value->field_ack;
}

const BITSTRING_template& RIM__PDU__Indications__GTPC_template::ack() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ack of a non-specific template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
return single_value->field_ack;
}

BITSTRING_template& RIM__PDU__Indications__GTPC_template::pDU__Type__Extension()
{
set_specific();
return single_value->field_pDU__Type__Extension;
}

const BITSTRING_template& RIM__PDU__Indications__GTPC_template::pDU__Type__Extension() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pDU_Type_Extension of a non-specific template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
return single_value->field_pDU__Type__Extension;
}

BITSTRING_template& RIM__PDU__Indications__GTPC_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const BITSTRING_template& RIM__PDU__Indications__GTPC_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
return single_value->field_reserved;
}

int RIM__PDU__Indications__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_PDU_Indications_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 6;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.RIM_PDU_Indications_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_PDU_Indications_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_PDU_Indications_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_PDU_Indications_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_PDU_Indications_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_PDU_Indications_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_PDU_Indications_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_PDU_Indications_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
  }
  return 0;
}

void RIM__PDU__Indications__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", ack := ");
single_value->field_ack.log();
TTCN_Logger::log_event_str(", pDU_Type_Extension := ");
single_value->field_pDU__Type__Extension.log();
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RIM__PDU__Indications__GTPC_template::log_match(const RIM__PDU__Indications__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ack.match(match_value.ack(), legacy)){
TTCN_Logger::log_logmatch_info(".ack");
single_value->field_ack.log_match(match_value.ack(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pDU__Type__Extension.match(match_value.pDU__Type__Extension(), legacy)){
TTCN_Logger::log_logmatch_info(".pDU_Type_Extension");
single_value->field_pDU__Type__Extension.log_match(match_value.pDU__Type__Extension(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", ack := ");
single_value->field_ack.log_match(match_value.ack(), legacy);
TTCN_Logger::log_event_str(", pDU_Type_Extension := ");
single_value->field_pDU__Type__Extension.log_match(match_value.pDU__Type__Extension(), legacy);
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RIM__PDU__Indications__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (ack().is_bound()) ack().set_implicit_omit();
if (pDU__Type__Extension().is_bound()) pDU__Type__Extension().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
}

void RIM__PDU__Indications__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_ack.encode_text(text_buf);
single_value->field_pDU__Type__Extension.encode_text(text_buf);
single_value->field_reserved.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
}
}

void RIM__PDU__Indications__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_ack.decode_text(text_buf);
single_value->field_pDU__Type__Extension.decode_text(text_buf);
single_value->field_reserved.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RIM__PDU__Indications__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.RIM_PDU_Indications_GTPC.");
}
}

void RIM__PDU__Indications__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RIM__PDU__Indications__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @GTPC_Types.RIM_PDU_Indications_GTPC has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ack().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) pDU__Type__Extension().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ack")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ack().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pDU_Type_Extension")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pDU__Type__Extension().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RIM_PDU_Indications_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RIM__PDU__Indications__GTPC_template* precondition = new RIM__PDU__Indications__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    RIM__PDU__Indications__GTPC_template* implied_template = new RIM__PDU__Indications__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RIM__PDU__Indications__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.RIM_PDU_Indications_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void RIM__PDU__Indications__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_PDU_Indications_GTPC");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_PDU_Indications_GTPC");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_PDU_Indications_GTPC");
single_value->field_ack.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_PDU_Indications_GTPC");
single_value->field_pDU__Type__Extension.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_PDU_Indications_GTPC");
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_PDU_Indications_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.RIM_PDU_Indications_GTPC");
}

boolean RIM__PDU__Indications__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RIM__PDU__Indications__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RAN__Information__Request__RIM__Container__GTPC::RAN__Information__Request__RIM__Container__GTPC()
{
}

RAN__Information__Request__RIM__Container__GTPC::RAN__Information__Request__RIM__Container__GTPC(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a__GTPC& par_lengthIndicator,
    const RIM__Application__Identity__GTPC& par_rIM__Application__Identity,
    const RIM__Sequence__Number__GTPC& par_rIM__Sequence__Number,
    const RIM__PDU__Indications__GTPC& par_rIM__PDU__Indications,
    const OPTIONAL< RIM__Protocol__Version__Number__GTPC >& par_rIM__Protocol__Version__Number,
    const OPTIONAL< RAN__Information__Request__Application__Container__GTPC >& par_application__Container,
    const OPTIONAL< SON__TransferApplicationIdentity >& par_sON__TransferApplicationIdentity)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_rIM__Application__Identity(par_rIM__Application__Identity),
  field_rIM__Sequence__Number(par_rIM__Sequence__Number),
  field_rIM__PDU__Indications(par_rIM__PDU__Indications),
  field_rIM__Protocol__Version__Number(par_rIM__Protocol__Version__Number),
  field_application__Container(par_application__Container),
  field_sON__TransferApplicationIdentity(par_sON__TransferApplicationIdentity)
{
}

RAN__Information__Request__RIM__Container__GTPC::RAN__Information__Request__RIM__Container__GTPC(const RAN__Information__Request__RIM__Container__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.rIM__Application__Identity().is_bound()) field_rIM__Application__Identity = other_value.rIM__Application__Identity();
else field_rIM__Application__Identity.clean_up();
if (other_value.rIM__Sequence__Number().is_bound()) field_rIM__Sequence__Number = other_value.rIM__Sequence__Number();
else field_rIM__Sequence__Number.clean_up();
if (other_value.rIM__PDU__Indications().is_bound()) field_rIM__PDU__Indications = other_value.rIM__PDU__Indications();
else field_rIM__PDU__Indications.clean_up();
if (other_value.rIM__Protocol__Version__Number().is_bound()) field_rIM__Protocol__Version__Number = other_value.rIM__Protocol__Version__Number();
else field_rIM__Protocol__Version__Number.clean_up();
if (other_value.application__Container().is_bound()) field_application__Container = other_value.application__Container();
else field_application__Container.clean_up();
if (other_value.sON__TransferApplicationIdentity().is_bound()) field_sON__TransferApplicationIdentity = other_value.sON__TransferApplicationIdentity();
else field_sON__TransferApplicationIdentity.clean_up();
}

void RAN__Information__Request__RIM__Container__GTPC::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_rIM__Application__Identity.clean_up();
field_rIM__Sequence__Number.clean_up();
field_rIM__PDU__Indications.clean_up();
field_rIM__Protocol__Version__Number.clean_up();
field_application__Container.clean_up();
field_sON__TransferApplicationIdentity.clean_up();
}

const TTCN_Typedescriptor_t* RAN__Information__Request__RIM__Container__GTPC::get_descriptor() const { return &RAN__Information__Request__RIM__Container__GTPC_descr_; }
RAN__Information__Request__RIM__Container__GTPC& RAN__Information__Request__RIM__Container__GTPC::operator=(const RAN__Information__Request__RIM__Container__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.rIM__Application__Identity().is_bound()) field_rIM__Application__Identity = other_value.rIM__Application__Identity();
  else field_rIM__Application__Identity.clean_up();
  if (other_value.rIM__Sequence__Number().is_bound()) field_rIM__Sequence__Number = other_value.rIM__Sequence__Number();
  else field_rIM__Sequence__Number.clean_up();
  if (other_value.rIM__PDU__Indications().is_bound()) field_rIM__PDU__Indications = other_value.rIM__PDU__Indications();
  else field_rIM__PDU__Indications.clean_up();
  if (other_value.rIM__Protocol__Version__Number().is_bound()) field_rIM__Protocol__Version__Number = other_value.rIM__Protocol__Version__Number();
  else field_rIM__Protocol__Version__Number.clean_up();
  if (other_value.application__Container().is_bound()) field_application__Container = other_value.application__Container();
  else field_application__Container.clean_up();
  if (other_value.sON__TransferApplicationIdentity().is_bound()) field_sON__TransferApplicationIdentity = other_value.sON__TransferApplicationIdentity();
  else field_sON__TransferApplicationIdentity.clean_up();
}
return *this;
}

boolean RAN__Information__Request__RIM__Container__GTPC::operator==(const RAN__Information__Request__RIM__Container__GTPC& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_rIM__Application__Identity==other_value.field_rIM__Application__Identity
  && field_rIM__Sequence__Number==other_value.field_rIM__Sequence__Number
  && field_rIM__PDU__Indications==other_value.field_rIM__PDU__Indications
  && field_rIM__Protocol__Version__Number==other_value.field_rIM__Protocol__Version__Number
  && field_application__Container==other_value.field_application__Container
  && field_sON__TransferApplicationIdentity==other_value.field_sON__TransferApplicationIdentity;
}

boolean RAN__Information__Request__RIM__Container__GTPC::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_rIM__Application__Identity.is_bound())
  || (field_rIM__Sequence__Number.is_bound())
  || (field_rIM__PDU__Indications.is_bound())
  || (OPTIONAL_OMIT == field_rIM__Protocol__Version__Number.get_selection() || field_rIM__Protocol__Version__Number.is_bound())
  || (OPTIONAL_OMIT == field_application__Container.get_selection() || field_application__Container.is_bound())
  || (OPTIONAL_OMIT == field_sON__TransferApplicationIdentity.get_selection() || field_sON__TransferApplicationIdentity.is_bound());
}
boolean RAN__Information__Request__RIM__Container__GTPC::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_rIM__Application__Identity.is_value()
  && field_rIM__Sequence__Number.is_value()
  && field_rIM__PDU__Indications.is_value()
  && (OPTIONAL_OMIT == field_rIM__Protocol__Version__Number.get_selection() || field_rIM__Protocol__Version__Number.is_value())
  && (OPTIONAL_OMIT == field_application__Container.get_selection() || field_application__Container.is_value())
  && (OPTIONAL_OMIT == field_sON__TransferApplicationIdentity.get_selection() || field_sON__TransferApplicationIdentity.is_value());
}
int RAN__Information__Request__RIM__Container__GTPC::size_of() const
{
  int ret_val = 6;
  if (field_rIM__Protocol__Version__Number.ispresent()) ret_val++;
  if (field_application__Container.ispresent()) ret_val++;
  if (field_sON__TransferApplicationIdentity.ispresent()) ret_val++;
  return ret_val;
}

void RAN__Information__Request__RIM__Container__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", rIM_Application_Identity := ");
field_rIM__Application__Identity.log();
TTCN_Logger::log_event_str(", rIM_Sequence_Number := ");
field_rIM__Sequence__Number.log();
TTCN_Logger::log_event_str(", rIM_PDU_Indications := ");
field_rIM__PDU__Indications.log();
TTCN_Logger::log_event_str(", rIM_Protocol_Version_Number := ");
field_rIM__Protocol__Version__Number.log();
TTCN_Logger::log_event_str(", application_Container := ");
field_application__Container.log();
TTCN_Logger::log_event_str(", sON_TransferApplicationIdentity := ");
field_sON__TransferApplicationIdentity.log();
TTCN_Logger::log_event_str(" }");
}

void RAN__Information__Request__RIM__Container__GTPC::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (rIM__Application__Identity().is_bound()) rIM__Application__Identity().set_implicit_omit();
if (rIM__Sequence__Number().is_bound()) rIM__Sequence__Number().set_implicit_omit();
if (rIM__PDU__Indications().is_bound()) rIM__PDU__Indications().set_implicit_omit();
if (!rIM__Protocol__Version__Number().is_bound()) rIM__Protocol__Version__Number() = OMIT_VALUE;
else rIM__Protocol__Version__Number().set_implicit_omit();
if (!application__Container().is_bound()) application__Container() = OMIT_VALUE;
else application__Container().set_implicit_omit();
if (!sON__TransferApplicationIdentity().is_bound()) sON__TransferApplicationIdentity() = OMIT_VALUE;
else sON__TransferApplicationIdentity().set_implicit_omit();
}

void RAN__Information__Request__RIM__Container__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record value of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rIM__Application__Identity().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) rIM__Sequence__Number().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) rIM__PDU__Indications().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) rIM__Protocol__Version__Number().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) application__Container().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) sON__TransferApplicationIdentity().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_Application_Identity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__Application__Identity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_Sequence_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__Sequence__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_PDU_Indications")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__PDU__Indications().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_Protocol_Version_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__Protocol__Version__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "application_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          application__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sON_TransferApplicationIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sON__TransferApplicationIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.RAN_Information_Request_RIM_Container_GTPC");
  }
}

void RAN__Information__Request__RIM__Container__GTPC::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_rIM__Application__Identity.encode_text(text_buf);
field_rIM__Sequence__Number.encode_text(text_buf);
field_rIM__PDU__Indications.encode_text(text_buf);
field_rIM__Protocol__Version__Number.encode_text(text_buf);
field_application__Container.encode_text(text_buf);
field_sON__TransferApplicationIdentity.encode_text(text_buf);
}

void RAN__Information__Request__RIM__Container__GTPC::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_rIM__Application__Identity.decode_text(text_buf);
field_rIM__Sequence__Number.decode_text(text_buf);
field_rIM__PDU__Indications.decode_text(text_buf);
field_rIM__Protocol__Version__Number.decode_text(text_buf);
field_application__Container.decode_text(text_buf);
field_sON__TransferApplicationIdentity.decode_text(text_buf);
}

void RAN__Information__Request__RIM__Container__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RAN__Information__Request__RIM__Container__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RAN__Information__Request__RIM__Container__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RAN__Information__Request__RIM__Container__GTPC_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(RAN__Information__Request__RIM__Container__GTPC_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_3) selected_field = 0;
  else if (field_ext ==  bs_24) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RAN__Information__Request__RIM__Container__GTPC_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(RAN__Information__Request__RIM__Container__GTPC_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a__GTPC_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a__GTPC::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a__GTPC_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, RIM__Application__Identity__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_rIM__Application__Identity.RAW_decode(RIM__Application__Identity__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, RIM__Sequence__Number__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_rIM__Sequence__Number.RAW_decode(RIM__Sequence__Number__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, RIM__PDU__Indications__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_rIM__PDU__Indications.RAW_decode(RIM__PDU__Indications__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (limit > 0 && value_of_length_field2 > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_rIM__Protocol__Version__Number = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, RIM__Protocol__Version__Number__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_rIM__Protocol__Version__Number().RAW_decode(RIM__Protocol__Version__Number__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_rIM__Protocol__Version__Number = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_rIM__Protocol__Version__Number.ispresent() || field_rIM__Protocol__Version__Number().iEI() !=  os_105){
  field_rIM__Protocol__Version__Number=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  }
  }
  }
  }
  else field_rIM__Protocol__Version__Number=OMIT_VALUE;
  if (field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_13) selected_field = 0;
  else if (field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_2) selected_field = 1;
  else if (field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_3) selected_field = 2;
  else if (field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_58) selected_field = 3;
  else if (field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_52) selected_field = 4;
  else selected_field = -1;
  if (limit > 0 && value_of_length_field2 > 0 && (field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_13 || field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_2 || field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_3 || field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_58 || field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_52)&& selected_field!=-1){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_application__Container = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, RAN__Information__Request__RIM__Container__GTPC_application__Container_descr_.raw->forceomit);
  decoded_field_length = field_application__Container().RAW_decode(RAN__Information__Request__RIM__Container__GTPC_application__Container_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, TRUE, selected_field, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_application__Container = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  }
  }
  }
  else field_application__Container=OMIT_VALUE;
  if (limit > 0 && value_of_length_field2 > 0 && field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_58){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_sON__TransferApplicationIdentity = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, RAN__Information__Request__RIM__Container__GTPC_sON__TransferApplicationIdentity_descr_.raw->forceomit);
  decoded_field_length = field_sON__TransferApplicationIdentity().RAW_decode(RAN__Information__Request__RIM__Container__GTPC_sON__TransferApplicationIdentity_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_sON__TransferApplicationIdentity = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  }
  }
  }
  else field_sON__TransferApplicationIdentity=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RAN__Information__Request__RIM__Container__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 9;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(9);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RAN__Information__Request__RIM__Container__GTPC_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RAN__Information__Request__RIM__Container__GTPC_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RIM__Application__Identity__GTPC_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RIM__Sequence__Number__GTPC_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, RIM__PDU__Indications__GTPC_descr_.raw);
  if (field_rIM__Protocol__Version__Number.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, RIM__Protocol__Version__Number__GTPC_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_application__Container.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, RAN__Information__Request__RIM__Container__GTPC_application__Container_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_sON__TransferApplicationIdentity.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, RAN__Information__Request__RIM__Container__GTPC_sON__TransferApplicationIdentity_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(RAN__Information__Request__RIM__Container__GTPC_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(RAN__Information__Request__RIM__Container__GTPC_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_rIM__Application__Identity.RAW_encode(RIM__Application__Identity__GTPC_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_rIM__Sequence__Number.RAW_encode(RIM__Sequence__Number__GTPC_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_rIM__PDU__Indications.RAW_encode(RIM__PDU__Indications__GTPC_descr_, *myleaf.body.node.nodes[5]);
  if (field_rIM__Protocol__Version__Number.ispresent()) {
  encoded_length += field_rIM__Protocol__Version__Number().RAW_encode(RIM__Protocol__Version__Number__GTPC_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_application__Container.ispresent()) {
  encoded_length += field_application__Container().RAW_encode(RAN__Information__Request__RIM__Container__GTPC_application__Container_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_sON__TransferApplicationIdentity.ispresent()) {
  encoded_length += field_sON__TransferApplicationIdentity().RAW_encode(RAN__Information__Request__RIM__Container__GTPC_sON__TransferApplicationIdentity_descr_, *myleaf.body.node.nodes[8]);
  }
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 6;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(6);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  if (field_rIM__Protocol__Version__Number.ispresent()) {
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  }else{
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[3].level = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[3].pos = 0;
  }
  if (field_application__Container.ispresent()) {
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[4].level = myleaf.body.node.nodes[7]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[4].pos = myleaf.body.node.nodes[7]->curr_pos.pos;
  }else{
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[4].level = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[4].pos = 0;
  }
  if (field_sON__TransferApplicationIdentity.ispresent()) {
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[5].level = myleaf.body.node.nodes[8]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[5].pos = myleaf.body.node.nodes[8]->curr_pos.pos;
  }else{
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[5].level = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[5].pos = 0;
  }
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1:
  if (field_ext !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(RAN__Information__Request__RIM__Container__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a__GTPC::ALT_length2:
  if (field_ext !=  bs_24) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_24.RAW_encode(RAN__Information__Request__RIM__Container__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_rIM__Protocol__Version__Number.ispresent() && (!field_rIM__Protocol__Version__Number.ispresent() || field_rIM__Protocol__Version__Number().iEI() !=  os_105)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={6,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_105.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_application__Container.ispresent() && (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_13 && field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_2 && field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_3 && field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_58 && field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_52)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,3};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_13.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos1;
  pr_pos1.level=myleaf.curr_pos.level+2;
  int new_pos1[]={3,3};
  pr_pos1.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos1);
  temp_leaf = myleaf.get_node(pr_pos1);
  if(temp_leaf != NULL){
   os_2.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos2;
  pr_pos2.level=myleaf.curr_pos.level+2;
  int new_pos2[]={3,3};
  pr_pos2.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos2);
  temp_leaf = myleaf.get_node(pr_pos2);
  if(temp_leaf != NULL){
   os_3.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos3;
  pr_pos3.level=myleaf.curr_pos.level+2;
  int new_pos3[]={3,3};
  pr_pos3.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos3);
  temp_leaf = myleaf.get_node(pr_pos3);
  if(temp_leaf != NULL){
   os_58.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos4;
  pr_pos4.level=myleaf.curr_pos.level+2;
  int new_pos4[]={3,3};
  pr_pos4.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos4);
  temp_leaf = myleaf.get_node(pr_pos4);
  if(temp_leaf != NULL){
   os_52.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos4.pos);
  }
  free_tree_pos(pr_pos3.pos);
  }
  free_tree_pos(pr_pos2.pos);
  }
  free_tree_pos(pr_pos1.pos);
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_application__Container.ispresent()) {
  switch (field_application__Container().get_selection()) {
  case RAN__Information__Request__Application__Container__GTPC::ALT_nacc:
  if (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_13) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 3, 3 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     os_13.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case RAN__Information__Request__Application__Container__GTPC::ALT_si3:
  if (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_2) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 3, 3 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     os_2.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case RAN__Information__Request__Application__Container__GTPC::ALT_mBMS:
  if (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 3, 3 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     os_3.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case RAN__Information__Request__Application__Container__GTPC::ALT_sON:
  if (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_58) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 3, 3 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     os_58.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI:
  if (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_52) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 3, 3 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     os_52.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  }
  if (field_sON__TransferApplicationIdentity.ispresent() && (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_58)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,3};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_58.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct RAN__Information__Request__RIM__Container__GTPC_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a__GTPC_template field_lengthIndicator;
RIM__Application__Identity__GTPC_template field_rIM__Application__Identity;
RIM__Sequence__Number__GTPC_template field_rIM__Sequence__Number;
RIM__PDU__Indications__GTPC_template field_rIM__PDU__Indications;
RIM__Protocol__Version__Number__GTPC_template field_rIM__Protocol__Version__Number;
RAN__Information__Request__Application__Container__GTPC_template field_application__Container;
SON__TransferApplicationIdentity_template field_sON__TransferApplicationIdentity;
};

void RAN__Information__Request__RIM__Container__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_rIM__Application__Identity = ANY_VALUE;
single_value->field_rIM__Sequence__Number = ANY_VALUE;
single_value->field_rIM__PDU__Indications = ANY_VALUE;
single_value->field_rIM__Protocol__Version__Number = ANY_OR_OMIT;
single_value->field_application__Container = ANY_OR_OMIT;
single_value->field_sON__TransferApplicationIdentity = ANY_OR_OMIT;
}
}
}

void RAN__Information__Request__RIM__Container__GTPC_template::copy_value(const RAN__Information__Request__RIM__Container__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.rIM__Application__Identity().is_bound()) {
  single_value->field_rIM__Application__Identity = other_value.rIM__Application__Identity();
} else {
  single_value->field_rIM__Application__Identity.clean_up();
}
if (other_value.rIM__Sequence__Number().is_bound()) {
  single_value->field_rIM__Sequence__Number = other_value.rIM__Sequence__Number();
} else {
  single_value->field_rIM__Sequence__Number.clean_up();
}
if (other_value.rIM__PDU__Indications().is_bound()) {
  single_value->field_rIM__PDU__Indications = other_value.rIM__PDU__Indications();
} else {
  single_value->field_rIM__PDU__Indications.clean_up();
}
if (other_value.rIM__Protocol__Version__Number().is_bound()) {
  if (other_value.rIM__Protocol__Version__Number().ispresent()) single_value->field_rIM__Protocol__Version__Number = other_value.rIM__Protocol__Version__Number()();
  else single_value->field_rIM__Protocol__Version__Number = OMIT_VALUE;
} else {
  single_value->field_rIM__Protocol__Version__Number.clean_up();
}
if (other_value.application__Container().is_bound()) {
  if (other_value.application__Container().ispresent()) single_value->field_application__Container = other_value.application__Container()();
  else single_value->field_application__Container = OMIT_VALUE;
} else {
  single_value->field_application__Container.clean_up();
}
if (other_value.sON__TransferApplicationIdentity().is_bound()) {
  if (other_value.sON__TransferApplicationIdentity().ispresent()) single_value->field_sON__TransferApplicationIdentity = other_value.sON__TransferApplicationIdentity()();
  else single_value->field_sON__TransferApplicationIdentity = OMIT_VALUE;
} else {
  single_value->field_sON__TransferApplicationIdentity.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RAN__Information__Request__RIM__Container__GTPC_template::copy_template(const RAN__Information__Request__RIM__Container__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rIM__Application__Identity().get_selection()) {
single_value->field_rIM__Application__Identity = other_value.rIM__Application__Identity();
} else {
single_value->field_rIM__Application__Identity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rIM__Sequence__Number().get_selection()) {
single_value->field_rIM__Sequence__Number = other_value.rIM__Sequence__Number();
} else {
single_value->field_rIM__Sequence__Number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rIM__PDU__Indications().get_selection()) {
single_value->field_rIM__PDU__Indications = other_value.rIM__PDU__Indications();
} else {
single_value->field_rIM__PDU__Indications.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rIM__Protocol__Version__Number().get_selection()) {
single_value->field_rIM__Protocol__Version__Number = other_value.rIM__Protocol__Version__Number();
} else {
single_value->field_rIM__Protocol__Version__Number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.application__Container().get_selection()) {
single_value->field_application__Container = other_value.application__Container();
} else {
single_value->field_application__Container.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sON__TransferApplicationIdentity().get_selection()) {
single_value->field_sON__TransferApplicationIdentity = other_value.sON__TransferApplicationIdentity();
} else {
single_value->field_sON__TransferApplicationIdentity.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RAN__Information__Request__RIM__Container__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RAN__Information__Request__RIM__Container__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new RAN__Information__Request__RIM__Container__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
break;
}
set_selection(other_value);
}

RAN__Information__Request__RIM__Container__GTPC_template::RAN__Information__Request__RIM__Container__GTPC_template()
{
}

RAN__Information__Request__RIM__Container__GTPC_template::RAN__Information__Request__RIM__Container__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RAN__Information__Request__RIM__Container__GTPC_template::RAN__Information__Request__RIM__Container__GTPC_template(const RAN__Information__Request__RIM__Container__GTPC& other_value)
{
copy_value(other_value);
}

RAN__Information__Request__RIM__Container__GTPC_template::RAN__Information__Request__RIM__Container__GTPC_template(const OPTIONAL<RAN__Information__Request__RIM__Container__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__RIM__Container__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC from an unbound optional field.");
}
}

RAN__Information__Request__RIM__Container__GTPC_template::RAN__Information__Request__RIM__Container__GTPC_template(RAN__Information__Request__RIM__Container__GTPC_template* p_precondition, RAN__Information__Request__RIM__Container__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RAN__Information__Request__RIM__Container__GTPC_template::RAN__Information__Request__RIM__Container__GTPC_template(Dynamic_Match_Interface<RAN__Information__Request__RIM__Container__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RAN__Information__Request__RIM__Container__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RAN__Information__Request__RIM__Container__GTPC_template::RAN__Information__Request__RIM__Container__GTPC_template(const RAN__Information__Request__RIM__Container__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RAN__Information__Request__RIM__Container__GTPC_template::~RAN__Information__Request__RIM__Container__GTPC_template()
{
clean_up();
}

RAN__Information__Request__RIM__Container__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RAN__Information__Request__RIM__Container__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::operator=(const RAN__Information__Request__RIM__Container__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RAN__Information__Request__RIM__Container__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::operator=(const OPTIONAL<RAN__Information__Request__RIM__Container__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__RIM__Container__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
}
return *this;
}

RAN__Information__Request__RIM__Container__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::operator=(const RAN__Information__Request__RIM__Container__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RAN__Information__Request__RIM__Container__GTPC_template::match(const RAN__Information__Request__RIM__Container__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.rIM__Application__Identity().is_bound()) return FALSE;
if(!single_value->field_rIM__Application__Identity.match(other_value.rIM__Application__Identity(), legacy))return FALSE;
if(!other_value.rIM__Sequence__Number().is_bound()) return FALSE;
if(!single_value->field_rIM__Sequence__Number.match(other_value.rIM__Sequence__Number(), legacy))return FALSE;
if(!other_value.rIM__PDU__Indications().is_bound()) return FALSE;
if(!single_value->field_rIM__PDU__Indications.match(other_value.rIM__PDU__Indications(), legacy))return FALSE;
if(!other_value.rIM__Protocol__Version__Number().is_bound()) return FALSE;
if((other_value.rIM__Protocol__Version__Number().ispresent() ? !single_value->field_rIM__Protocol__Version__Number.match((const RIM__Protocol__Version__Number__GTPC&)other_value.rIM__Protocol__Version__Number(), legacy) : !single_value->field_rIM__Protocol__Version__Number.match_omit(legacy)))return FALSE;
if(!other_value.application__Container().is_bound()) return FALSE;
if((other_value.application__Container().ispresent() ? !single_value->field_application__Container.match((const RAN__Information__Request__Application__Container__GTPC&)other_value.application__Container(), legacy) : !single_value->field_application__Container.match_omit(legacy)))return FALSE;
if(!other_value.sON__TransferApplicationIdentity().is_bound()) return FALSE;
if((other_value.sON__TransferApplicationIdentity().ispresent() ? !single_value->field_sON__TransferApplicationIdentity.match((const SON__TransferApplicationIdentity&)other_value.sON__TransferApplicationIdentity(), legacy) : !single_value->field_sON__TransferApplicationIdentity.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
}
return FALSE;
}

boolean RAN__Information__Request__RIM__Container__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_rIM__Application__Identity.is_bound()
 || single_value->field_rIM__Sequence__Number.is_bound()
 || single_value->field_rIM__PDU__Indications.is_bound()
 || (single_value->field_rIM__Protocol__Version__Number.is_omit() || single_value->field_rIM__Protocol__Version__Number.is_bound())
 || (single_value->field_application__Container.is_omit() || single_value->field_application__Container.is_bound())
 || (single_value->field_sON__TransferApplicationIdentity.is_omit() || single_value->field_sON__TransferApplicationIdentity.is_bound());
}

boolean RAN__Information__Request__RIM__Container__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_rIM__Application__Identity.is_value()
 && single_value->field_rIM__Sequence__Number.is_value()
 && single_value->field_rIM__PDU__Indications.is_value()
 && (single_value->field_rIM__Protocol__Version__Number.is_omit() || single_value->field_rIM__Protocol__Version__Number.is_value())
 && (single_value->field_application__Container.is_omit() || single_value->field_application__Container.is_value())
 && (single_value->field_sON__TransferApplicationIdentity.is_omit() || single_value->field_sON__TransferApplicationIdentity.is_value());
}

void RAN__Information__Request__RIM__Container__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RAN__Information__Request__RIM__Container__GTPC RAN__Information__Request__RIM__Container__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
RAN__Information__Request__RIM__Container__GTPC ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_rIM__Application__Identity.is_bound()) {
ret_val.rIM__Application__Identity() = single_value->field_rIM__Application__Identity.valueof();
}
if (single_value->field_rIM__Sequence__Number.is_bound()) {
ret_val.rIM__Sequence__Number() = single_value->field_rIM__Sequence__Number.valueof();
}
if (single_value->field_rIM__PDU__Indications.is_bound()) {
ret_val.rIM__PDU__Indications() = single_value->field_rIM__PDU__Indications.valueof();
}
if (single_value->field_rIM__Protocol__Version__Number.is_omit()) ret_val.rIM__Protocol__Version__Number() = OMIT_VALUE;
else if (single_value->field_rIM__Protocol__Version__Number.is_bound()) {
ret_val.rIM__Protocol__Version__Number() = single_value->field_rIM__Protocol__Version__Number.valueof();
}
if (single_value->field_application__Container.is_omit()) ret_val.application__Container() = OMIT_VALUE;
else if (single_value->field_application__Container.is_bound()) {
ret_val.application__Container() = single_value->field_application__Container.valueof();
}
if (single_value->field_sON__TransferApplicationIdentity.is_omit()) ret_val.sON__TransferApplicationIdentity() = OMIT_VALUE;
else if (single_value->field_sON__TransferApplicationIdentity.is_bound()) {
ret_val.sON__TransferApplicationIdentity() = single_value->field_sON__TransferApplicationIdentity.valueof();
}
return ret_val;
}

void RAN__Information__Request__RIM__Container__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RAN__Information__Request__RIM__Container__GTPC_template[list_length];
}

RAN__Information__Request__RIM__Container__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RAN__Information__Request__RIM__Container__GTPC_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& RAN__Information__Request__RIM__Container__GTPC_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
return single_value->field_iEI;
}

BITSTRING_template& RAN__Information__Request__RIM__Container__GTPC_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& RAN__Information__Request__RIM__Container__GTPC_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
return single_value->field_ext;
}

LIN2__2a__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
return single_value->field_lengthIndicator;
}

RIM__Application__Identity__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::rIM__Application__Identity()
{
set_specific();
return single_value->field_rIM__Application__Identity;
}

const RIM__Application__Identity__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::rIM__Application__Identity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rIM_Application_Identity of a non-specific template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
return single_value->field_rIM__Application__Identity;
}

RIM__Sequence__Number__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::rIM__Sequence__Number()
{
set_specific();
return single_value->field_rIM__Sequence__Number;
}

const RIM__Sequence__Number__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::rIM__Sequence__Number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rIM_Sequence_Number of a non-specific template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
return single_value->field_rIM__Sequence__Number;
}

RIM__PDU__Indications__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::rIM__PDU__Indications()
{
set_specific();
return single_value->field_rIM__PDU__Indications;
}

const RIM__PDU__Indications__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::rIM__PDU__Indications() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rIM_PDU_Indications of a non-specific template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
return single_value->field_rIM__PDU__Indications;
}

RIM__Protocol__Version__Number__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::rIM__Protocol__Version__Number()
{
set_specific();
return single_value->field_rIM__Protocol__Version__Number;
}

const RIM__Protocol__Version__Number__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::rIM__Protocol__Version__Number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rIM_Protocol_Version_Number of a non-specific template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
return single_value->field_rIM__Protocol__Version__Number;
}

RAN__Information__Request__Application__Container__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::application__Container()
{
set_specific();
return single_value->field_application__Container;
}

const RAN__Information__Request__Application__Container__GTPC_template& RAN__Information__Request__RIM__Container__GTPC_template::application__Container() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field application_Container of a non-specific template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
return single_value->field_application__Container;
}

SON__TransferApplicationIdentity_template& RAN__Information__Request__RIM__Container__GTPC_template::sON__TransferApplicationIdentity()
{
set_specific();
return single_value->field_sON__TransferApplicationIdentity;
}

const SON__TransferApplicationIdentity_template& RAN__Information__Request__RIM__Container__GTPC_template::sON__TransferApplicationIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sON_TransferApplicationIdentity of a non-specific template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
return single_value->field_sON__TransferApplicationIdentity;
}

int RAN__Information__Request__RIM__Container__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 6;
      if (single_value->field_rIM__Protocol__Version__Number.is_present()) ret_val++;
      if (single_value->field_application__Container.is_present()) ret_val++;
      if (single_value->field_sON__TransferApplicationIdentity.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
  }
  return 0;
}

void RAN__Information__Request__RIM__Container__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", rIM_Application_Identity := ");
single_value->field_rIM__Application__Identity.log();
TTCN_Logger::log_event_str(", rIM_Sequence_Number := ");
single_value->field_rIM__Sequence__Number.log();
TTCN_Logger::log_event_str(", rIM_PDU_Indications := ");
single_value->field_rIM__PDU__Indications.log();
TTCN_Logger::log_event_str(", rIM_Protocol_Version_Number := ");
single_value->field_rIM__Protocol__Version__Number.log();
TTCN_Logger::log_event_str(", application_Container := ");
single_value->field_application__Container.log();
TTCN_Logger::log_event_str(", sON_TransferApplicationIdentity := ");
single_value->field_sON__TransferApplicationIdentity.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RAN__Information__Request__RIM__Container__GTPC_template::log_match(const RAN__Information__Request__RIM__Container__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rIM__Application__Identity.match(match_value.rIM__Application__Identity(), legacy)){
TTCN_Logger::log_logmatch_info(".rIM_Application_Identity");
single_value->field_rIM__Application__Identity.log_match(match_value.rIM__Application__Identity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rIM__Sequence__Number.match(match_value.rIM__Sequence__Number(), legacy)){
TTCN_Logger::log_logmatch_info(".rIM_Sequence_Number");
single_value->field_rIM__Sequence__Number.log_match(match_value.rIM__Sequence__Number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rIM__PDU__Indications.match(match_value.rIM__PDU__Indications(), legacy)){
TTCN_Logger::log_logmatch_info(".rIM_PDU_Indications");
single_value->field_rIM__PDU__Indications.log_match(match_value.rIM__PDU__Indications(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.rIM__Protocol__Version__Number().ispresent()){
if(!single_value->field_rIM__Protocol__Version__Number.match(match_value.rIM__Protocol__Version__Number(), legacy)){
TTCN_Logger::log_logmatch_info(".rIM_Protocol_Version_Number");
single_value->field_rIM__Protocol__Version__Number.log_match(match_value.rIM__Protocol__Version__Number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_rIM__Protocol__Version__Number.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".rIM_Protocol_Version_Number := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_rIM__Protocol__Version__Number.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.application__Container().ispresent()){
if(!single_value->field_application__Container.match(match_value.application__Container(), legacy)){
TTCN_Logger::log_logmatch_info(".application_Container");
single_value->field_application__Container.log_match(match_value.application__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_application__Container.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".application_Container := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_application__Container.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.sON__TransferApplicationIdentity().ispresent()){
if(!single_value->field_sON__TransferApplicationIdentity.match(match_value.sON__TransferApplicationIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".sON_TransferApplicationIdentity");
single_value->field_sON__TransferApplicationIdentity.log_match(match_value.sON__TransferApplicationIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_sON__TransferApplicationIdentity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".sON_TransferApplicationIdentity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_sON__TransferApplicationIdentity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", rIM_Application_Identity := ");
single_value->field_rIM__Application__Identity.log_match(match_value.rIM__Application__Identity(), legacy);
TTCN_Logger::log_event_str(", rIM_Sequence_Number := ");
single_value->field_rIM__Sequence__Number.log_match(match_value.rIM__Sequence__Number(), legacy);
TTCN_Logger::log_event_str(", rIM_PDU_Indications := ");
single_value->field_rIM__PDU__Indications.log_match(match_value.rIM__PDU__Indications(), legacy);
TTCN_Logger::log_event_str(", rIM_Protocol_Version_Number := ");
if (match_value.rIM__Protocol__Version__Number().ispresent()) {
single_value->field_rIM__Protocol__Version__Number.log_match(match_value.rIM__Protocol__Version__Number(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_rIM__Protocol__Version__Number.log();
if (single_value->field_rIM__Protocol__Version__Number.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", application_Container := ");
if (match_value.application__Container().ispresent()) {
single_value->field_application__Container.log_match(match_value.application__Container(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_application__Container.log();
if (single_value->field_application__Container.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", sON_TransferApplicationIdentity := ");
if (match_value.sON__TransferApplicationIdentity().ispresent()) {
single_value->field_sON__TransferApplicationIdentity.log_match(match_value.sON__TransferApplicationIdentity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_sON__TransferApplicationIdentity.log();
if (single_value->field_sON__TransferApplicationIdentity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RAN__Information__Request__RIM__Container__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (rIM__Application__Identity().is_bound()) rIM__Application__Identity().set_implicit_omit();
if (rIM__Sequence__Number().is_bound()) rIM__Sequence__Number().set_implicit_omit();
if (rIM__PDU__Indications().is_bound()) rIM__PDU__Indications().set_implicit_omit();
if (!rIM__Protocol__Version__Number().is_bound()) rIM__Protocol__Version__Number() = OMIT_VALUE;
else rIM__Protocol__Version__Number().set_implicit_omit();
if (!application__Container().is_bound()) application__Container() = OMIT_VALUE;
else application__Container().set_implicit_omit();
if (!sON__TransferApplicationIdentity().is_bound()) sON__TransferApplicationIdentity() = OMIT_VALUE;
else sON__TransferApplicationIdentity().set_implicit_omit();
}

void RAN__Information__Request__RIM__Container__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_rIM__Application__Identity.encode_text(text_buf);
single_value->field_rIM__Sequence__Number.encode_text(text_buf);
single_value->field_rIM__PDU__Indications.encode_text(text_buf);
single_value->field_rIM__Protocol__Version__Number.encode_text(text_buf);
single_value->field_application__Container.encode_text(text_buf);
single_value->field_sON__TransferApplicationIdentity.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
}
}

void RAN__Information__Request__RIM__Container__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_rIM__Application__Identity.decode_text(text_buf);
single_value->field_rIM__Sequence__Number.decode_text(text_buf);
single_value->field_rIM__PDU__Indications.decode_text(text_buf);
single_value->field_rIM__Protocol__Version__Number.decode_text(text_buf);
single_value->field_application__Container.decode_text(text_buf);
single_value->field_sON__TransferApplicationIdentity.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RAN__Information__Request__RIM__Container__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC.");
}
}

void RAN__Information__Request__RIM__Container__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RAN__Information__Request__RIM__Container__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record template of type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rIM__Application__Identity().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) rIM__Sequence__Number().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) rIM__PDU__Indications().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) rIM__Protocol__Version__Number().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) application__Container().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) sON__TransferApplicationIdentity().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_Application_Identity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__Application__Identity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_Sequence_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__Sequence__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_PDU_Indications")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__PDU__Indications().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_Protocol_Version_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__Protocol__Version__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "application_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          application__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sON_TransferApplicationIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sON__TransferApplicationIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_Request_RIM_Container_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RAN__Information__Request__RIM__Container__GTPC_template* precondition = new RAN__Information__Request__RIM__Container__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    RAN__Information__Request__RIM__Container__GTPC_template* implied_template = new RAN__Information__Request__RIM__Container__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RAN__Information__Request__RIM__Container__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.RAN_Information_Request_RIM_Container_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void RAN__Information__Request__RIM__Container__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_RIM_Container_GTPC");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_RIM_Container_GTPC");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_RIM_Container_GTPC");
single_value->field_rIM__Application__Identity.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_RIM_Container_GTPC");
single_value->field_rIM__Sequence__Number.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_RIM_Container_GTPC");
single_value->field_rIM__PDU__Indications.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_RIM_Container_GTPC");
single_value->field_rIM__Protocol__Version__Number.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_RIM_Container_GTPC");
single_value->field_application__Container.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_RIM_Container_GTPC");
single_value->field_sON__TransferApplicationIdentity.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_RIM_Container_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.RAN_Information_Request_RIM_Container_GTPC");
}

boolean RAN__Information__Request__RIM__Container__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RAN__Information__Request__RIM__Container__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RIM__Protocol__Version__Number__GTPC::RIM__Protocol__Version__Number__GTPC()
{
}

RIM__Protocol__Version__Number__GTPC::RIM__Protocol__Version__Number__GTPC(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a__GTPC& par_lengthIndicator,
    const OCTETSTRING& par_rIMProtocolVersionNumber)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_rIMProtocolVersionNumber(par_rIMProtocolVersionNumber)
{
}

RIM__Protocol__Version__Number__GTPC::RIM__Protocol__Version__Number__GTPC(const RIM__Protocol__Version__Number__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.rIMProtocolVersionNumber().is_bound()) field_rIMProtocolVersionNumber = other_value.rIMProtocolVersionNumber();
else field_rIMProtocolVersionNumber.clean_up();
}

void RIM__Protocol__Version__Number__GTPC::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_rIMProtocolVersionNumber.clean_up();
}

const TTCN_Typedescriptor_t* RIM__Protocol__Version__Number__GTPC::get_descriptor() const { return &RIM__Protocol__Version__Number__GTPC_descr_; }
RIM__Protocol__Version__Number__GTPC& RIM__Protocol__Version__Number__GTPC::operator=(const RIM__Protocol__Version__Number__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.rIMProtocolVersionNumber().is_bound()) field_rIMProtocolVersionNumber = other_value.rIMProtocolVersionNumber();
  else field_rIMProtocolVersionNumber.clean_up();
}
return *this;
}

boolean RIM__Protocol__Version__Number__GTPC::operator==(const RIM__Protocol__Version__Number__GTPC& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_rIMProtocolVersionNumber==other_value.field_rIMProtocolVersionNumber;
}

boolean RIM__Protocol__Version__Number__GTPC::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_rIMProtocolVersionNumber.is_bound());
}
boolean RIM__Protocol__Version__Number__GTPC::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_rIMProtocolVersionNumber.is_value();
}
void RIM__Protocol__Version__Number__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", rIMProtocolVersionNumber := ");
field_rIMProtocolVersionNumber.log();
TTCN_Logger::log_event_str(" }");
}

void RIM__Protocol__Version__Number__GTPC::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (rIMProtocolVersionNumber().is_bound()) rIMProtocolVersionNumber().set_implicit_omit();
}

void RIM__Protocol__Version__Number__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rIMProtocolVersionNumber().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIMProtocolVersionNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIMProtocolVersionNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RIM_Protocol_Version_Number_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.RIM_Protocol_Version_Number_GTPC");
  }
}

void RIM__Protocol__Version__Number__GTPC::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_rIMProtocolVersionNumber.encode_text(text_buf);
}

void RIM__Protocol__Version__Number__GTPC::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_rIMProtocolVersionNumber.decode_text(text_buf);
}

void RIM__Protocol__Version__Number__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RIM__Protocol__Version__Number__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RIM__Protocol__Version__Number__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RIM__Protocol__Version__Number__GTPC_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(RIM__Protocol__Version__Number__GTPC_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_3) selected_field = 0;
  else if (field_ext ==  bs_24) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RIM__Protocol__Version__Number__GTPC_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(RIM__Protocol__Version__Number__GTPC_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a__GTPC_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a__GTPC::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a__GTPC_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_rIMProtocolVersionNumber.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RIM__Protocol__Version__Number__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RIM__Protocol__Version__Number__GTPC_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RIM__Protocol__Version__Number__GTPC_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT1_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(RIM__Protocol__Version__Number__GTPC_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(RIM__Protocol__Version__Number__GTPC_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_rIMProtocolVersionNumber.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1:
  if (field_ext !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(RIM__Protocol__Version__Number__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a__GTPC::ALT_length2:
  if (field_ext !=  bs_24) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_24.RAW_encode(RIM__Protocol__Version__Number__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  return myleaf.length = encoded_length;
}

struct RIM__Protocol__Version__Number__GTPC_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a__GTPC_template field_lengthIndicator;
OCTETSTRING_template field_rIMProtocolVersionNumber;
};

void RIM__Protocol__Version__Number__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_rIMProtocolVersionNumber = ANY_VALUE;
}
}
}

void RIM__Protocol__Version__Number__GTPC_template::copy_value(const RIM__Protocol__Version__Number__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.rIMProtocolVersionNumber().is_bound()) {
  single_value->field_rIMProtocolVersionNumber = other_value.rIMProtocolVersionNumber();
} else {
  single_value->field_rIMProtocolVersionNumber.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RIM__Protocol__Version__Number__GTPC_template::copy_template(const RIM__Protocol__Version__Number__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rIMProtocolVersionNumber().get_selection()) {
single_value->field_rIMProtocolVersionNumber = other_value.rIMProtocolVersionNumber();
} else {
single_value->field_rIMProtocolVersionNumber.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RIM__Protocol__Version__Number__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RIM__Protocol__Version__Number__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new RIM__Protocol__Version__Number__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
break;
}
set_selection(other_value);
}

RIM__Protocol__Version__Number__GTPC_template::RIM__Protocol__Version__Number__GTPC_template()
{
}

RIM__Protocol__Version__Number__GTPC_template::RIM__Protocol__Version__Number__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RIM__Protocol__Version__Number__GTPC_template::RIM__Protocol__Version__Number__GTPC_template(const RIM__Protocol__Version__Number__GTPC& other_value)
{
copy_value(other_value);
}

RIM__Protocol__Version__Number__GTPC_template::RIM__Protocol__Version__Number__GTPC_template(const OPTIONAL<RIM__Protocol__Version__Number__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RIM__Protocol__Version__Number__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC from an unbound optional field.");
}
}

RIM__Protocol__Version__Number__GTPC_template::RIM__Protocol__Version__Number__GTPC_template(RIM__Protocol__Version__Number__GTPC_template* p_precondition, RIM__Protocol__Version__Number__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RIM__Protocol__Version__Number__GTPC_template::RIM__Protocol__Version__Number__GTPC_template(Dynamic_Match_Interface<RIM__Protocol__Version__Number__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RIM__Protocol__Version__Number__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RIM__Protocol__Version__Number__GTPC_template::RIM__Protocol__Version__Number__GTPC_template(const RIM__Protocol__Version__Number__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RIM__Protocol__Version__Number__GTPC_template::~RIM__Protocol__Version__Number__GTPC_template()
{
clean_up();
}

RIM__Protocol__Version__Number__GTPC_template& RIM__Protocol__Version__Number__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RIM__Protocol__Version__Number__GTPC_template& RIM__Protocol__Version__Number__GTPC_template::operator=(const RIM__Protocol__Version__Number__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RIM__Protocol__Version__Number__GTPC_template& RIM__Protocol__Version__Number__GTPC_template::operator=(const OPTIONAL<RIM__Protocol__Version__Number__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RIM__Protocol__Version__Number__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
}
return *this;
}

RIM__Protocol__Version__Number__GTPC_template& RIM__Protocol__Version__Number__GTPC_template::operator=(const RIM__Protocol__Version__Number__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RIM__Protocol__Version__Number__GTPC_template::match(const RIM__Protocol__Version__Number__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.rIMProtocolVersionNumber().is_bound()) return FALSE;
if(!single_value->field_rIMProtocolVersionNumber.match(other_value.rIMProtocolVersionNumber(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
}
return FALSE;
}

boolean RIM__Protocol__Version__Number__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_rIMProtocolVersionNumber.is_bound();
}

boolean RIM__Protocol__Version__Number__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_rIMProtocolVersionNumber.is_value();
}

void RIM__Protocol__Version__Number__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RIM__Protocol__Version__Number__GTPC RIM__Protocol__Version__Number__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
RIM__Protocol__Version__Number__GTPC ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_rIMProtocolVersionNumber.is_bound()) {
ret_val.rIMProtocolVersionNumber() = single_value->field_rIMProtocolVersionNumber.valueof();
}
return ret_val;
}

void RIM__Protocol__Version__Number__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RIM__Protocol__Version__Number__GTPC_template[list_length];
}

RIM__Protocol__Version__Number__GTPC_template& RIM__Protocol__Version__Number__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RIM__Protocol__Version__Number__GTPC_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& RIM__Protocol__Version__Number__GTPC_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
return single_value->field_iEI;
}

BITSTRING_template& RIM__Protocol__Version__Number__GTPC_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& RIM__Protocol__Version__Number__GTPC_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
return single_value->field_ext;
}

LIN2__2a__GTPC_template& RIM__Protocol__Version__Number__GTPC_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a__GTPC_template& RIM__Protocol__Version__Number__GTPC_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& RIM__Protocol__Version__Number__GTPC_template::rIMProtocolVersionNumber()
{
set_specific();
return single_value->field_rIMProtocolVersionNumber;
}

const OCTETSTRING_template& RIM__Protocol__Version__Number__GTPC_template::rIMProtocolVersionNumber() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rIMProtocolVersionNumber of a non-specific template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
return single_value->field_rIMProtocolVersionNumber;
}

int RIM__Protocol__Version__Number__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
  }
  return 0;
}

void RIM__Protocol__Version__Number__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", rIMProtocolVersionNumber := ");
single_value->field_rIMProtocolVersionNumber.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RIM__Protocol__Version__Number__GTPC_template::log_match(const RIM__Protocol__Version__Number__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rIMProtocolVersionNumber.match(match_value.rIMProtocolVersionNumber(), legacy)){
TTCN_Logger::log_logmatch_info(".rIMProtocolVersionNumber");
single_value->field_rIMProtocolVersionNumber.log_match(match_value.rIMProtocolVersionNumber(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", rIMProtocolVersionNumber := ");
single_value->field_rIMProtocolVersionNumber.log_match(match_value.rIMProtocolVersionNumber(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RIM__Protocol__Version__Number__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (rIMProtocolVersionNumber().is_bound()) rIMProtocolVersionNumber().set_implicit_omit();
}

void RIM__Protocol__Version__Number__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_rIMProtocolVersionNumber.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
}
}

void RIM__Protocol__Version__Number__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_rIMProtocolVersionNumber.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RIM__Protocol__Version__Number__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC.");
}
}

void RIM__Protocol__Version__Number__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RIM__Protocol__Version__Number__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @GTPC_Types.RIM_Protocol_Version_Number_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rIMProtocolVersionNumber().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIMProtocolVersionNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIMProtocolVersionNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RIM_Protocol_Version_Number_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RIM__Protocol__Version__Number__GTPC_template* precondition = new RIM__Protocol__Version__Number__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    RIM__Protocol__Version__Number__GTPC_template* implied_template = new RIM__Protocol__Version__Number__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RIM__Protocol__Version__Number__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.RIM_Protocol_Version_Number_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void RIM__Protocol__Version__Number__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_Protocol_Version_Number_GTPC");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_Protocol_Version_Number_GTPC");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_Protocol_Version_Number_GTPC");
single_value->field_rIMProtocolVersionNumber.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RIM_Protocol_Version_Number_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.RIM_Protocol_Version_Number_GTPC");
}

boolean RIM__Protocol__Version__Number__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RIM__Protocol__Version__Number__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RAN__Information__Request__Application__Container__GTPC::copy_value(const RAN__Information__Request__Application__Container__GTPC& other_value)
{
switch (other_value.union_selection) {
case ALT_nacc:
field_nacc = new RAN__Information__Request__Application__Container__NACC__GTPC(*other_value.field_nacc);
break;
case ALT_si3:
field_si3 = new RAN__Information__Request__Application__Container__SI3__GTPC(*other_value.field_si3);
break;
case ALT_mBMS:
field_mBMS = new RAN__Information__Request__Application__Container__MBMS__GTPC(*other_value.field_mBMS);
break;
case ALT_sON:
field_sON = new RAN__Information__Request__Application__Container__SON__GTPC(*other_value.field_sON);
break;
case ALT_uTRA__SI:
field_uTRA__SI = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC(*other_value.field_uTRA__SI);
break;
default:
TTCN_error("Assignment of an unbound union value of type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
union_selection = other_value.union_selection;
}

RAN__Information__Request__Application__Container__GTPC::RAN__Information__Request__Application__Container__GTPC()
{
union_selection = UNBOUND_VALUE;
}

RAN__Information__Request__Application__Container__GTPC::RAN__Information__Request__Application__Container__GTPC(const RAN__Information__Request__Application__Container__GTPC& other_value)
: Base_Type(){
copy_value(other_value);
}

RAN__Information__Request__Application__Container__GTPC::~RAN__Information__Request__Application__Container__GTPC()
{
clean_up();
}

RAN__Information__Request__Application__Container__GTPC& RAN__Information__Request__Application__Container__GTPC::operator=(const RAN__Information__Request__Application__Container__GTPC& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean RAN__Information__Request__Application__Container__GTPC::operator==(const RAN__Information__Request__Application__Container__GTPC& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_nacc:
return *field_nacc == *other_value.field_nacc;
case ALT_si3:
return *field_si3 == *other_value.field_si3;
case ALT_mBMS:
return *field_mBMS == *other_value.field_mBMS;
case ALT_sON:
return *field_sON == *other_value.field_sON;
case ALT_uTRA__SI:
return *field_uTRA__SI == *other_value.field_uTRA__SI;
default:
return FALSE;
}
}

RAN__Information__Request__Application__Container__NACC__GTPC& RAN__Information__Request__Application__Container__GTPC::nacc()
{
if (union_selection != ALT_nacc) {
clean_up();
field_nacc = new RAN__Information__Request__Application__Container__NACC__GTPC;
union_selection = ALT_nacc;
}
return *field_nacc;
}

const RAN__Information__Request__Application__Container__NACC__GTPC& RAN__Information__Request__Application__Container__GTPC::nacc() const
{
if (union_selection != ALT_nacc) TTCN_error("Using non-selected field nacc in a value of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
return *field_nacc;
}

RAN__Information__Request__Application__Container__SI3__GTPC& RAN__Information__Request__Application__Container__GTPC::si3()
{
if (union_selection != ALT_si3) {
clean_up();
field_si3 = new RAN__Information__Request__Application__Container__SI3__GTPC;
union_selection = ALT_si3;
}
return *field_si3;
}

const RAN__Information__Request__Application__Container__SI3__GTPC& RAN__Information__Request__Application__Container__GTPC::si3() const
{
if (union_selection != ALT_si3) TTCN_error("Using non-selected field si3 in a value of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
return *field_si3;
}

RAN__Information__Request__Application__Container__MBMS__GTPC& RAN__Information__Request__Application__Container__GTPC::mBMS()
{
if (union_selection != ALT_mBMS) {
clean_up();
field_mBMS = new RAN__Information__Request__Application__Container__MBMS__GTPC;
union_selection = ALT_mBMS;
}
return *field_mBMS;
}

const RAN__Information__Request__Application__Container__MBMS__GTPC& RAN__Information__Request__Application__Container__GTPC::mBMS() const
{
if (union_selection != ALT_mBMS) TTCN_error("Using non-selected field mBMS in a value of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
return *field_mBMS;
}

RAN__Information__Request__Application__Container__SON__GTPC& RAN__Information__Request__Application__Container__GTPC::sON()
{
if (union_selection != ALT_sON) {
clean_up();
field_sON = new RAN__Information__Request__Application__Container__SON__GTPC;
union_selection = ALT_sON;
}
return *field_sON;
}

const RAN__Information__Request__Application__Container__SON__GTPC& RAN__Information__Request__Application__Container__GTPC::sON() const
{
if (union_selection != ALT_sON) TTCN_error("Using non-selected field sON in a value of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
return *field_sON;
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC& RAN__Information__Request__Application__Container__GTPC::uTRA__SI()
{
if (union_selection != ALT_uTRA__SI) {
clean_up();
field_uTRA__SI = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC;
union_selection = ALT_uTRA__SI;
}
return *field_uTRA__SI;
}

const RAN__Information__Request__Application__Container__UTRA__SI__GTPC& RAN__Information__Request__Application__Container__GTPC::uTRA__SI() const
{
if (union_selection != ALT_uTRA__SI) TTCN_error("Using non-selected field uTRA_SI in a value of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
return *field_uTRA__SI;
}

boolean RAN__Information__Request__Application__Container__GTPC::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
return union_selection == checked_selection;
}

boolean RAN__Information__Request__Application__Container__GTPC::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean RAN__Information__Request__Application__Container__GTPC::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_nacc: return field_nacc->is_value();
case ALT_si3: return field_si3->is_value();
case ALT_mBMS: return field_mBMS->is_value();
case ALT_sON: return field_sON->is_value();
case ALT_uTRA__SI: return field_uTRA__SI->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void RAN__Information__Request__Application__Container__GTPC::clean_up()
{
switch (union_selection) {
case ALT_nacc:
  delete field_nacc;
  break;
case ALT_si3:
  delete field_si3;
  break;
case ALT_mBMS:
  delete field_mBMS;
  break;
case ALT_sON:
  delete field_sON;
  break;
case ALT_uTRA__SI:
  delete field_uTRA__SI;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void RAN__Information__Request__Application__Container__GTPC::log() const
{
switch (union_selection) {
case ALT_nacc:
TTCN_Logger::log_event_str("{ nacc := ");
field_nacc->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_si3:
TTCN_Logger::log_event_str("{ si3 := ");
field_si3->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_mBMS:
TTCN_Logger::log_event_str("{ mBMS := ");
field_mBMS->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_sON:
TTCN_Logger::log_event_str("{ sON := ");
field_sON->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_uTRA__SI:
TTCN_Logger::log_event_str("{ uTRA_SI := ");
field_uTRA__SI->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void RAN__Information__Request__Application__Container__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "nacc")) {
    nacc().set_param(*mp_last);
    if (!nacc().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "si3")) {
    si3().set_param(*mp_last);
    if (!si3().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "mBMS")) {
    mBMS().set_param(*mp_last);
    if (!mBMS().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "sON")) {
    sON().set_param(*mp_last);
    if (!sON().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "uTRA_SI")) {
    uTRA__SI().set_param(*mp_last);
    if (!uTRA__SI().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.", last_name);
}

void RAN__Information__Request__Application__Container__GTPC::set_implicit_omit()
{
switch (union_selection) {
case ALT_nacc:
field_nacc->set_implicit_omit(); break;
case ALT_si3:
field_si3->set_implicit_omit(); break;
case ALT_mBMS:
field_mBMS->set_implicit_omit(); break;
case ALT_sON:
field_sON->set_implicit_omit(); break;
case ALT_uTRA__SI:
field_uTRA__SI->set_implicit_omit(); break;
default: break;
}
}

void RAN__Information__Request__Application__Container__GTPC::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_nacc:
field_nacc->encode_text(text_buf);
break;
case ALT_si3:
field_si3->encode_text(text_buf);
break;
case ALT_mBMS:
field_mBMS->encode_text(text_buf);
break;
case ALT_sON:
field_sON->encode_text(text_buf);
break;
case ALT_uTRA__SI:
field_uTRA__SI->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
}

void RAN__Information__Request__Application__Container__GTPC::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_nacc:
nacc().decode_text(text_buf);
break;
case ALT_si3:
si3().decode_text(text_buf);
break;
case ALT_mBMS:
mBMS().decode_text(text_buf);
break;
case ALT_sON:
sON().decode_text(text_buf);
break;
case ALT_uTRA__SI:
uTRA__SI().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
}

void RAN__Information__Request__Application__Container__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RAN__Information__Request__Application__Container__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RAN__Information__Request__Application__Container__GTPC::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, RAN__Information__Request__Application__Container__NACC__GTPC_descr_.raw->forceomit);
      decoded_length = nacc().RAW_decode(RAN__Information__Request__Application__Container__NACC__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, RAN__Information__Request__Application__Container__SI3__GTPC_descr_.raw->forceomit);
      decoded_length = si3().RAW_decode(RAN__Information__Request__Application__Container__SI3__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, RAN__Information__Request__Application__Container__MBMS__GTPC_descr_.raw->forceomit);
      decoded_length = mBMS().RAW_decode(RAN__Information__Request__Application__Container__MBMS__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, RAN__Information__Request__Application__Container__SON__GTPC_descr_.raw->forceomit);
      decoded_length = sON().RAW_decode(RAN__Information__Request__Application__Container__SON__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 4: {
      RAW_Force_Omit field_force_omit(4, force_omit, RAN__Information__Request__Application__Container__UTRA__SI__GTPC_descr_.raw->forceomit);
      decoded_length = uTRA__SI().RAW_decode(RAN__Information__Request__Application__Container__UTRA__SI__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, RAN__Information__Request__Application__Container__NACC__GTPC_descr_.raw->forceomit);
      decoded_length = nacc().RAW_decode(RAN__Information__Request__Application__Container__NACC__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, RAN__Information__Request__Application__Container__SI3__GTPC_descr_.raw->forceomit);
      decoded_length = si3().RAW_decode(RAN__Information__Request__Application__Container__SI3__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, RAN__Information__Request__Application__Container__MBMS__GTPC_descr_.raw->forceomit);
      decoded_length = mBMS().RAW_decode(RAN__Information__Request__Application__Container__MBMS__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_3_force_omit(3, force_omit, RAN__Information__Request__Application__Container__SON__GTPC_descr_.raw->forceomit);
      decoded_length = sON().RAW_decode(RAN__Information__Request__Application__Container__SON__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_3_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_4_force_omit(4, force_omit, RAN__Information__Request__Application__Container__UTRA__SI__GTPC_descr_.raw->forceomit);
      decoded_length = uTRA__SI().RAW_decode(RAN__Information__Request__Application__Container__UTRA__SI__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_4_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int RAN__Information__Request__Application__Container__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  memset(myleaf.body.node.nodes, 0, 5 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_nacc:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, RAN__Information__Request__Application__Container__NACC__GTPC_descr_.raw);
    encoded_length = field_nacc->RAW_encode(RAN__Information__Request__Application__Container__NACC__GTPC_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &RAN__Information__Request__Application__Container__NACC__GTPC_descr_;
    break;
  case ALT_si3:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, RAN__Information__Request__Application__Container__SI3__GTPC_descr_.raw);
    encoded_length = field_si3->RAW_encode(RAN__Information__Request__Application__Container__SI3__GTPC_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &RAN__Information__Request__Application__Container__SI3__GTPC_descr_;
    break;
  case ALT_mBMS:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, RAN__Information__Request__Application__Container__MBMS__GTPC_descr_.raw);
    encoded_length = field_mBMS->RAW_encode(RAN__Information__Request__Application__Container__MBMS__GTPC_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &RAN__Information__Request__Application__Container__MBMS__GTPC_descr_;
    break;
  case ALT_sON:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, RAN__Information__Request__Application__Container__SON__GTPC_descr_.raw);
    encoded_length = field_sON->RAW_encode(RAN__Information__Request__Application__Container__SON__GTPC_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &RAN__Information__Request__Application__Container__SON__GTPC_descr_;
    break;
  case ALT_uTRA__SI:
    myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 4, RAN__Information__Request__Application__Container__UTRA__SI__GTPC_descr_.raw);
    encoded_length = field_uTRA__SI->RAW_encode(RAN__Information__Request__Application__Container__UTRA__SI__GTPC_descr_, *myleaf.body.node.nodes[4]);
    myleaf.body.node.nodes[4]->coding_descr = &RAN__Information__Request__Application__Container__UTRA__SI__GTPC_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void RAN__Information__Request__Application__Container__GTPC_template::copy_value(const RAN__Information__Request__Application__Container__GTPC& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case RAN__Information__Request__Application__Container__GTPC::ALT_nacc:
single_value.field_nacc = new RAN__Information__Request__Application__Container__NACC__GTPC_template(other_value.nacc());
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_si3:
single_value.field_si3 = new RAN__Information__Request__Application__Container__SI3__GTPC_template(other_value.si3());
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_mBMS:
single_value.field_mBMS = new RAN__Information__Request__Application__Container__MBMS__GTPC_template(other_value.mBMS());
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_sON:
single_value.field_sON = new RAN__Information__Request__Application__Container__SON__GTPC_template(other_value.sON());
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI:
single_value.field_uTRA__SI = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template(other_value.uTRA__SI());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
set_selection(SPECIFIC_VALUE);
}

void RAN__Information__Request__Application__Container__GTPC_template::copy_template(const RAN__Information__Request__Application__Container__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case RAN__Information__Request__Application__Container__GTPC::ALT_nacc:
single_value.field_nacc = new RAN__Information__Request__Application__Container__NACC__GTPC_template(*other_value.single_value.field_nacc);
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_si3:
single_value.field_si3 = new RAN__Information__Request__Application__Container__SI3__GTPC_template(*other_value.single_value.field_si3);
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_mBMS:
single_value.field_mBMS = new RAN__Information__Request__Application__Container__MBMS__GTPC_template(*other_value.single_value.field_mBMS);
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_sON:
single_value.field_sON = new RAN__Information__Request__Application__Container__SON__GTPC_template(*other_value.single_value.field_sON);
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI:
single_value.field_uTRA__SI = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template(*other_value.single_value.field_uTRA__SI);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RAN__Information__Request__Application__Container__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RAN__Information__Request__Application__Container__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new RAN__Information__Request__Application__Container__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
set_selection(other_value);
}

RAN__Information__Request__Application__Container__GTPC_template::RAN__Information__Request__Application__Container__GTPC_template()
{
}

RAN__Information__Request__Application__Container__GTPC_template::RAN__Information__Request__Application__Container__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RAN__Information__Request__Application__Container__GTPC_template::RAN__Information__Request__Application__Container__GTPC_template(const RAN__Information__Request__Application__Container__GTPC& other_value)
{
copy_value(other_value);
}

RAN__Information__Request__Application__Container__GTPC_template::RAN__Information__Request__Application__Container__GTPC_template(const OPTIONAL<RAN__Information__Request__Application__Container__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__Application__Container__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC from an unbound optional field.");
}
}

RAN__Information__Request__Application__Container__GTPC_template::RAN__Information__Request__Application__Container__GTPC_template(RAN__Information__Request__Application__Container__GTPC_template* p_precondition, RAN__Information__Request__Application__Container__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RAN__Information__Request__Application__Container__GTPC_template::RAN__Information__Request__Application__Container__GTPC_template(Dynamic_Match_Interface<RAN__Information__Request__Application__Container__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RAN__Information__Request__Application__Container__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RAN__Information__Request__Application__Container__GTPC_template::RAN__Information__Request__Application__Container__GTPC_template(const RAN__Information__Request__Application__Container__GTPC_template& other_value)
: Base_Template(){
copy_template(other_value);
}

RAN__Information__Request__Application__Container__GTPC_template::~RAN__Information__Request__Application__Container__GTPC_template()
{
clean_up();
}

void RAN__Information__Request__Application__Container__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case RAN__Information__Request__Application__Container__GTPC::ALT_nacc:
delete single_value.field_nacc;
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_si3:
delete single_value.field_si3;
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_mBMS:
delete single_value.field_mBMS;
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_sON:
delete single_value.field_sON;
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI:
delete single_value.field_uTRA__SI;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RAN__Information__Request__Application__Container__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RAN__Information__Request__Application__Container__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::operator=(const RAN__Information__Request__Application__Container__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RAN__Information__Request__Application__Container__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::operator=(const OPTIONAL<RAN__Information__Request__Application__Container__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__Application__Container__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
return *this;
}

RAN__Information__Request__Application__Container__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::operator=(const RAN__Information__Request__Application__Container__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RAN__Information__Request__Application__Container__GTPC_template::match(const RAN__Information__Request__Application__Container__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
RAN__Information__Request__Application__Container__GTPC::union_selection_type value_selection = other_value.get_selection();
if (value_selection == RAN__Information__Request__Application__Container__GTPC::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case RAN__Information__Request__Application__Container__GTPC::ALT_nacc:
return single_value.field_nacc->match(other_value.nacc(), legacy);
case RAN__Information__Request__Application__Container__GTPC::ALT_si3:
return single_value.field_si3->match(other_value.si3(), legacy);
case RAN__Information__Request__Application__Container__GTPC::ALT_mBMS:
return single_value.field_mBMS->match(other_value.mBMS(), legacy);
case RAN__Information__Request__Application__Container__GTPC::ALT_sON:
return single_value.field_sON->match(other_value.sON(), legacy);
case RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI:
return single_value.field_uTRA__SI->match(other_value.uTRA__SI(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
return FALSE;
}

boolean RAN__Information__Request__Application__Container__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case RAN__Information__Request__Application__Container__GTPC::ALT_nacc:
return single_value.field_nacc->is_value();
case RAN__Information__Request__Application__Container__GTPC::ALT_si3:
return single_value.field_si3->is_value();
case RAN__Information__Request__Application__Container__GTPC::ALT_mBMS:
return single_value.field_mBMS->is_value();
case RAN__Information__Request__Application__Container__GTPC::ALT_sON:
return single_value.field_sON->is_value();
case RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI:
return single_value.field_uTRA__SI->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
}

RAN__Information__Request__Application__Container__GTPC RAN__Information__Request__Application__Container__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
RAN__Information__Request__Application__Container__GTPC ret_val;
switch (single_value.union_selection) {
case RAN__Information__Request__Application__Container__GTPC::ALT_nacc:
ret_val.nacc() = single_value.field_nacc->valueof();
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_si3:
ret_val.si3() = single_value.field_si3->valueof();
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_mBMS:
ret_val.mBMS() = single_value.field_mBMS->valueof();
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_sON:
ret_val.sON() = single_value.field_sON->valueof();
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI:
ret_val.uTRA__SI() = single_value.field_uTRA__SI->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
return ret_val;
}

RAN__Information__Request__Application__Container__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
return value_list.list_value[list_index];
}
void RAN__Information__Request__Application__Container__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RAN__Information__Request__Application__Container__GTPC_template[list_length];
}

RAN__Information__Request__Application__Container__NACC__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::nacc()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RAN__Information__Request__Application__Container__GTPC::ALT_nacc) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_nacc = new RAN__Information__Request__Application__Container__NACC__GTPC_template(ANY_VALUE);
else single_value.field_nacc = new RAN__Information__Request__Application__Container__NACC__GTPC_template;
single_value.union_selection = RAN__Information__Request__Application__Container__GTPC::ALT_nacc;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_nacc;
}

const RAN__Information__Request__Application__Container__NACC__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::nacc() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field nacc in a non-specific template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
if (single_value.union_selection != RAN__Information__Request__Application__Container__GTPC::ALT_nacc) TTCN_error("Accessing non-selected field nacc in a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
return *single_value.field_nacc;
}

RAN__Information__Request__Application__Container__SI3__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::si3()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RAN__Information__Request__Application__Container__GTPC::ALT_si3) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_si3 = new RAN__Information__Request__Application__Container__SI3__GTPC_template(ANY_VALUE);
else single_value.field_si3 = new RAN__Information__Request__Application__Container__SI3__GTPC_template;
single_value.union_selection = RAN__Information__Request__Application__Container__GTPC::ALT_si3;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_si3;
}

const RAN__Information__Request__Application__Container__SI3__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::si3() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field si3 in a non-specific template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
if (single_value.union_selection != RAN__Information__Request__Application__Container__GTPC::ALT_si3) TTCN_error("Accessing non-selected field si3 in a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
return *single_value.field_si3;
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::mBMS()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RAN__Information__Request__Application__Container__GTPC::ALT_mBMS) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_mBMS = new RAN__Information__Request__Application__Container__MBMS__GTPC_template(ANY_VALUE);
else single_value.field_mBMS = new RAN__Information__Request__Application__Container__MBMS__GTPC_template;
single_value.union_selection = RAN__Information__Request__Application__Container__GTPC::ALT_mBMS;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_mBMS;
}

const RAN__Information__Request__Application__Container__MBMS__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::mBMS() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field mBMS in a non-specific template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
if (single_value.union_selection != RAN__Information__Request__Application__Container__GTPC::ALT_mBMS) TTCN_error("Accessing non-selected field mBMS in a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
return *single_value.field_mBMS;
}

RAN__Information__Request__Application__Container__SON__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::sON()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RAN__Information__Request__Application__Container__GTPC::ALT_sON) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_sON = new RAN__Information__Request__Application__Container__SON__GTPC_template(ANY_VALUE);
else single_value.field_sON = new RAN__Information__Request__Application__Container__SON__GTPC_template;
single_value.union_selection = RAN__Information__Request__Application__Container__GTPC::ALT_sON;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_sON;
}

const RAN__Information__Request__Application__Container__SON__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::sON() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field sON in a non-specific template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
if (single_value.union_selection != RAN__Information__Request__Application__Container__GTPC::ALT_sON) TTCN_error("Accessing non-selected field sON in a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
return *single_value.field_sON;
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::uTRA__SI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_uTRA__SI = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template(ANY_VALUE);
else single_value.field_uTRA__SI = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template;
single_value.union_selection = RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_uTRA__SI;
}

const RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template& RAN__Information__Request__Application__Container__GTPC_template::uTRA__SI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field uTRA_SI in a non-specific template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
if (single_value.union_selection != RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI) TTCN_error("Accessing non-selected field uTRA_SI in a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
return *single_value.field_uTRA__SI;
}

boolean RAN__Information__Request__Application__Container__GTPC_template::ischosen(RAN__Information__Request__Application__Container__GTPC::union_selection_type checked_selection) const
{
if (checked_selection == RAN__Information__Request__Application__Container__GTPC::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == RAN__Information__Request__Application__Container__GTPC::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void RAN__Information__Request__Application__Container__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case RAN__Information__Request__Application__Container__GTPC::ALT_nacc:
TTCN_Logger::log_event_str("{ nacc := ");
single_value.field_nacc->log();
TTCN_Logger::log_event_str(" }");
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_si3:
TTCN_Logger::log_event_str("{ si3 := ");
single_value.field_si3->log();
TTCN_Logger::log_event_str(" }");
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_mBMS:
TTCN_Logger::log_event_str("{ mBMS := ");
single_value.field_mBMS->log();
TTCN_Logger::log_event_str(" }");
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_sON:
TTCN_Logger::log_event_str("{ sON := ");
single_value.field_sON->log();
TTCN_Logger::log_event_str(" }");
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI:
TTCN_Logger::log_event_str("{ uTRA_SI := ");
single_value.field_uTRA__SI->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RAN__Information__Request__Application__Container__GTPC_template::log_match(const RAN__Information__Request__Application__Container__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case RAN__Information__Request__Application__Container__GTPC::ALT_nacc:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".nacc");
single_value.field_nacc->log_match(match_value.nacc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ nacc := ");
single_value.field_nacc->log_match(match_value.nacc(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_si3:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".si3");
single_value.field_si3->log_match(match_value.si3(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ si3 := ");
single_value.field_si3->log_match(match_value.si3(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_mBMS:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".mBMS");
single_value.field_mBMS->log_match(match_value.mBMS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ mBMS := ");
single_value.field_mBMS->log_match(match_value.mBMS(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_sON:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".sON");
single_value.field_sON->log_match(match_value.sON(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ sON := ");
single_value.field_sON->log_match(match_value.sON(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".uTRA_SI");
single_value.field_uTRA__SI->log_match(match_value.uTRA__SI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ uTRA_SI := ");
single_value.field_uTRA__SI->log_match(match_value.uTRA__SI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RAN__Information__Request__Application__Container__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case RAN__Information__Request__Application__Container__GTPC::ALT_nacc:
single_value.field_nacc->set_implicit_omit(); break;
case RAN__Information__Request__Application__Container__GTPC::ALT_si3:
single_value.field_si3->set_implicit_omit(); break;
case RAN__Information__Request__Application__Container__GTPC::ALT_mBMS:
single_value.field_mBMS->set_implicit_omit(); break;
case RAN__Information__Request__Application__Container__GTPC::ALT_sON:
single_value.field_sON->set_implicit_omit(); break;
case RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI:
single_value.field_uTRA__SI->set_implicit_omit(); break;
default: break;
}
}

void RAN__Information__Request__Application__Container__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case RAN__Information__Request__Application__Container__GTPC::ALT_nacc:
single_value.field_nacc->encode_text(text_buf);
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_si3:
single_value.field_si3->encode_text(text_buf);
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_mBMS:
single_value.field_mBMS->encode_text(text_buf);
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_sON:
single_value.field_sON->encode_text(text_buf);
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI:
single_value.field_uTRA__SI->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
}

void RAN__Information__Request__Application__Container__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = RAN__Information__Request__Application__Container__GTPC::UNBOUND_VALUE;
RAN__Information__Request__Application__Container__GTPC::union_selection_type new_selection = (RAN__Information__Request__Application__Container__GTPC::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case RAN__Information__Request__Application__Container__GTPC::ALT_nacc:
single_value.field_nacc = new RAN__Information__Request__Application__Container__NACC__GTPC_template;
single_value.field_nacc->decode_text(text_buf);
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_si3:
single_value.field_si3 = new RAN__Information__Request__Application__Container__SI3__GTPC_template;
single_value.field_si3->decode_text(text_buf);
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_mBMS:
single_value.field_mBMS = new RAN__Information__Request__Application__Container__MBMS__GTPC_template;
single_value.field_mBMS->decode_text(text_buf);
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_sON:
single_value.field_sON = new RAN__Information__Request__Application__Container__SON__GTPC_template;
single_value.field_sON->decode_text(text_buf);
break;
case RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI:
single_value.field_uTRA__SI = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template;
single_value.field_uTRA__SI->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RAN__Information__Request__Application__Container__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
}

boolean RAN__Information__Request__Application__Container__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RAN__Information__Request__Application__Container__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RAN__Information__Request__Application__Container__GTPC_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@GTPC_Types.RAN_Information_Request_Application_Container_GTPC'");
    }
    if (strcmp("nacc", param_field) == 0) {
      nacc().set_param(param);
      return;
    } else if (strcmp("si3", param_field) == 0) {
      si3().set_param(param);
      return;
    } else if (strcmp("mBMS", param_field) == 0) {
      mBMS().set_param(param);
      return;
    } else if (strcmp("sON", param_field) == 0) {
      sON().set_param(param);
      return;
    } else if (strcmp("uTRA_SI", param_field) == 0) {
      uTRA__SI().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@GTPC_Types.RAN_Information_Request_Application_Container_GTPC'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RAN__Information__Request__Application__Container__GTPC_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@GTPC_Types.RAN_Information_Request_Application_Container_GTPC");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "nacc")) {
      nacc().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "si3")) {
      si3().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "mBMS")) {
      mBMS().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "sON")) {
      sON().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "uTRA_SI")) {
      uTRA__SI().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    RAN__Information__Request__Application__Container__GTPC_template* precondition = new RAN__Information__Request__Application__Container__GTPC_template;
    precondition->set_param(*m_p->get_elem(0));
    RAN__Information__Request__Application__Container__GTPC_template* implied_template = new RAN__Information__Request__Application__Container__GTPC_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RAN__Information__Request__Application__Container__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@GTPC_Types.RAN_Information_Request_Application_Container_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void RAN__Information__Request__Application__Container__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case RAN__Information__Request__Application__Container__GTPC::ALT_nacc:
single_value.field_nacc->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_GTPC");
return;
case RAN__Information__Request__Application__Container__GTPC::ALT_si3:
single_value.field_si3->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_GTPC");
return;
case RAN__Information__Request__Application__Container__GTPC::ALT_mBMS:
single_value.field_mBMS->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_GTPC");
return;
case RAN__Information__Request__Application__Container__GTPC::ALT_sON:
single_value.field_sON->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_GTPC");
return;
case RAN__Information__Request__Application__Container__GTPC::ALT_uTRA__SI:
single_value.field_uTRA__SI->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_GTPC");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @GTPC_Types.RAN_Information_Request_Application_Container_GTPC.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_GTPC");
}

Cell__Identifier__V__GTPC::Cell__Identifier__V__GTPC()
{
}

Cell__Identifier__V__GTPC::Cell__Identifier__V__GTPC(const HEXSTRING& par_mccDigit1,
    const HEXSTRING& par_mccDigit2,
    const HEXSTRING& par_mccDigit3,
    const HEXSTRING& par_mncDigit3,
    const HEXSTRING& par_mncDigit1,
    const HEXSTRING& par_mncDigit2,
    const OCTETSTRING& par_lac,
    const OCTETSTRING& par_rac,
    const OCTETSTRING& par_cI__value)
  :   field_mccDigit1(par_mccDigit1),
  field_mccDigit2(par_mccDigit2),
  field_mccDigit3(par_mccDigit3),
  field_mncDigit3(par_mncDigit3),
  field_mncDigit1(par_mncDigit1),
  field_mncDigit2(par_mncDigit2),
  field_lac(par_lac),
  field_rac(par_rac),
  field_cI__value(par_cI__value)
{
}

Cell__Identifier__V__GTPC::Cell__Identifier__V__GTPC(const Cell__Identifier__V__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.Cell_Identifier_V_GTPC.");
if (other_value.mccDigit1().is_bound()) field_mccDigit1 = other_value.mccDigit1();
else field_mccDigit1.clean_up();
if (other_value.mccDigit2().is_bound()) field_mccDigit2 = other_value.mccDigit2();
else field_mccDigit2.clean_up();
if (other_value.mccDigit3().is_bound()) field_mccDigit3 = other_value.mccDigit3();
else field_mccDigit3.clean_up();
if (other_value.mncDigit3().is_bound()) field_mncDigit3 = other_value.mncDigit3();
else field_mncDigit3.clean_up();
if (other_value.mncDigit1().is_bound()) field_mncDigit1 = other_value.mncDigit1();
else field_mncDigit1.clean_up();
if (other_value.mncDigit2().is_bound()) field_mncDigit2 = other_value.mncDigit2();
else field_mncDigit2.clean_up();
if (other_value.lac().is_bound()) field_lac = other_value.lac();
else field_lac.clean_up();
if (other_value.rac().is_bound()) field_rac = other_value.rac();
else field_rac.clean_up();
if (other_value.cI__value().is_bound()) field_cI__value = other_value.cI__value();
else field_cI__value.clean_up();
}

void Cell__Identifier__V__GTPC::clean_up()
{
field_mccDigit1.clean_up();
field_mccDigit2.clean_up();
field_mccDigit3.clean_up();
field_mncDigit3.clean_up();
field_mncDigit1.clean_up();
field_mncDigit2.clean_up();
field_lac.clean_up();
field_rac.clean_up();
field_cI__value.clean_up();
}

const TTCN_Typedescriptor_t* Cell__Identifier__V__GTPC::get_descriptor() const { return &Cell__Identifier__V__GTPC_descr_; }
Cell__Identifier__V__GTPC& Cell__Identifier__V__GTPC::operator=(const Cell__Identifier__V__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.Cell_Identifier_V_GTPC.");
  if (other_value.mccDigit1().is_bound()) field_mccDigit1 = other_value.mccDigit1();
  else field_mccDigit1.clean_up();
  if (other_value.mccDigit2().is_bound()) field_mccDigit2 = other_value.mccDigit2();
  else field_mccDigit2.clean_up();
  if (other_value.mccDigit3().is_bound()) field_mccDigit3 = other_value.mccDigit3();
  else field_mccDigit3.clean_up();
  if (other_value.mncDigit3().is_bound()) field_mncDigit3 = other_value.mncDigit3();
  else field_mncDigit3.clean_up();
  if (other_value.mncDigit1().is_bound()) field_mncDigit1 = other_value.mncDigit1();
  else field_mncDigit1.clean_up();
  if (other_value.mncDigit2().is_bound()) field_mncDigit2 = other_value.mncDigit2();
  else field_mncDigit2.clean_up();
  if (other_value.lac().is_bound()) field_lac = other_value.lac();
  else field_lac.clean_up();
  if (other_value.rac().is_bound()) field_rac = other_value.rac();
  else field_rac.clean_up();
  if (other_value.cI__value().is_bound()) field_cI__value = other_value.cI__value();
  else field_cI__value.clean_up();
}
return *this;
}

boolean Cell__Identifier__V__GTPC::operator==(const Cell__Identifier__V__GTPC& other_value) const
{
return field_mccDigit1==other_value.field_mccDigit1
  && field_mccDigit2==other_value.field_mccDigit2
  && field_mccDigit3==other_value.field_mccDigit3
  && field_mncDigit3==other_value.field_mncDigit3
  && field_mncDigit1==other_value.field_mncDigit1
  && field_mncDigit2==other_value.field_mncDigit2
  && field_lac==other_value.field_lac
  && field_rac==other_value.field_rac
  && field_cI__value==other_value.field_cI__value;
}

boolean Cell__Identifier__V__GTPC::is_bound() const
{
return (field_mccDigit1.is_bound())
  || (field_mccDigit2.is_bound())
  || (field_mccDigit3.is_bound())
  || (field_mncDigit3.is_bound())
  || (field_mncDigit1.is_bound())
  || (field_mncDigit2.is_bound())
  || (field_lac.is_bound())
  || (field_rac.is_bound())
  || (field_cI__value.is_bound());
}
boolean Cell__Identifier__V__GTPC::is_value() const
{
return field_mccDigit1.is_value()
  && field_mccDigit2.is_value()
  && field_mccDigit3.is_value()
  && field_mncDigit3.is_value()
  && field_mncDigit1.is_value()
  && field_mncDigit2.is_value()
  && field_lac.is_value()
  && field_rac.is_value()
  && field_cI__value.is_value();
}
void Cell__Identifier__V__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ mccDigit1 := ");
field_mccDigit1.log();
TTCN_Logger::log_event_str(", mccDigit2 := ");
field_mccDigit2.log();
TTCN_Logger::log_event_str(", mccDigit3 := ");
field_mccDigit3.log();
TTCN_Logger::log_event_str(", mncDigit3 := ");
field_mncDigit3.log();
TTCN_Logger::log_event_str(", mncDigit1 := ");
field_mncDigit1.log();
TTCN_Logger::log_event_str(", mncDigit2 := ");
field_mncDigit2.log();
TTCN_Logger::log_event_str(", lac := ");
field_lac.log();
TTCN_Logger::log_event_str(", rac := ");
field_rac.log();
TTCN_Logger::log_event_str(", cI_value := ");
field_cI__value.log();
TTCN_Logger::log_event_str(" }");
}

void Cell__Identifier__V__GTPC::set_implicit_omit()
{
if (mccDigit1().is_bound()) mccDigit1().set_implicit_omit();
if (mccDigit2().is_bound()) mccDigit2().set_implicit_omit();
if (mccDigit3().is_bound()) mccDigit3().set_implicit_omit();
if (mncDigit3().is_bound()) mncDigit3().set_implicit_omit();
if (mncDigit1().is_bound()) mncDigit1().set_implicit_omit();
if (mncDigit2().is_bound()) mncDigit2().set_implicit_omit();
if (lac().is_bound()) lac().set_implicit_omit();
if (rac().is_bound()) rac().set_implicit_omit();
if (cI__value().is_bound()) cI__value().set_implicit_omit();
}

void Cell__Identifier__V__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record value of type @GTPC_Types.Cell_Identifier_V_GTPC has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) mccDigit1().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mccDigit2().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) mccDigit3().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) mncDigit3().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) mncDigit1().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) mncDigit2().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) lac().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) rac().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) cI__value().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mccDigit1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mccDigit1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mccDigit2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mccDigit2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mccDigit3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mccDigit3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mncDigit3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mncDigit3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mncDigit1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mncDigit1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mncDigit2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mncDigit2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cI_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cI__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.Cell_Identifier_V_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.Cell_Identifier_V_GTPC");
  }
}

void Cell__Identifier__V__GTPC::encode_text(Text_Buf& text_buf) const
{
field_mccDigit1.encode_text(text_buf);
field_mccDigit2.encode_text(text_buf);
field_mccDigit3.encode_text(text_buf);
field_mncDigit3.encode_text(text_buf);
field_mncDigit1.encode_text(text_buf);
field_mncDigit2.encode_text(text_buf);
field_lac.encode_text(text_buf);
field_rac.encode_text(text_buf);
field_cI__value.encode_text(text_buf);
}

void Cell__Identifier__V__GTPC::decode_text(Text_Buf& text_buf)
{
field_mccDigit1.decode_text(text_buf);
field_mccDigit2.decode_text(text_buf);
field_mccDigit3.decode_text(text_buf);
field_mncDigit3.decode_text(text_buf);
field_mncDigit1.decode_text(text_buf);
field_mncDigit2.decode_text(text_buf);
field_lac.decode_text(text_buf);
field_rac.decode_text(text_buf);
field_cI__value.decode_text(text_buf);
}

void Cell__Identifier__V__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Cell__Identifier__V__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Cell__Identifier__V__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::HEX1_descr_.raw->forceomit);
  decoded_field_length = field_mccDigit1.RAW_decode(General__Types::HEX1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::HEX1_descr_.raw->forceomit);
  decoded_field_length = field_mccDigit2.RAW_decode(General__Types::HEX1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::HEX1_descr_.raw->forceomit);
  decoded_field_length = field_mccDigit3.RAW_decode(General__Types::HEX1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::HEX1_descr_.raw->forceomit);
  decoded_field_length = field_mncDigit3.RAW_decode(General__Types::HEX1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::HEX1_descr_.raw->forceomit);
  decoded_field_length = field_mncDigit1.RAW_decode(General__Types::HEX1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::HEX1_descr_.raw->forceomit);
  decoded_field_length = field_mncDigit2.RAW_decode(General__Types::HEX1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_6_force_omit(6, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_lac.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_7_force_omit(7, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_rac.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_8_force_omit(8, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_cI__value.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Cell__Identifier__V__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 9;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(9);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::HEX1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::HEX1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::HEX1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::HEX1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::HEX1_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::HEX1_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, General__Types::OCT2_descr_.raw);
  encoded_length += field_mccDigit1.RAW_encode(General__Types::HEX1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_mccDigit2.RAW_encode(General__Types::HEX1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_mccDigit3.RAW_encode(General__Types::HEX1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_mncDigit3.RAW_encode(General__Types::HEX1_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_mncDigit1.RAW_encode(General__Types::HEX1_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_mncDigit2.RAW_encode(General__Types::HEX1_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_lac.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[6]);
  encoded_length += field_rac.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[7]);
  encoded_length += field_cI__value.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[8]);
  return myleaf.length = encoded_length;
}

struct Cell__Identifier__V__GTPC_template::single_value_struct {
HEXSTRING_template field_mccDigit1;
HEXSTRING_template field_mccDigit2;
HEXSTRING_template field_mccDigit3;
HEXSTRING_template field_mncDigit3;
HEXSTRING_template field_mncDigit1;
HEXSTRING_template field_mncDigit2;
OCTETSTRING_template field_lac;
OCTETSTRING_template field_rac;
OCTETSTRING_template field_cI__value;
};

void Cell__Identifier__V__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_mccDigit1 = ANY_VALUE;
single_value->field_mccDigit2 = ANY_VALUE;
single_value->field_mccDigit3 = ANY_VALUE;
single_value->field_mncDigit3 = ANY_VALUE;
single_value->field_mncDigit1 = ANY_VALUE;
single_value->field_mncDigit2 = ANY_VALUE;
single_value->field_lac = ANY_VALUE;
single_value->field_rac = ANY_VALUE;
single_value->field_cI__value = ANY_VALUE;
}
}
}

void Cell__Identifier__V__GTPC_template::copy_value(const Cell__Identifier__V__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.mccDigit1().is_bound()) {
  single_value->field_mccDigit1 = other_value.mccDigit1();
} else {
  single_value->field_mccDigit1.clean_up();
}
if (other_value.mccDigit2().is_bound()) {
  single_value->field_mccDigit2 = other_value.mccDigit2();
} else {
  single_value->field_mccDigit2.clean_up();
}
if (other_value.mccDigit3().is_bound()) {
  single_value->field_mccDigit3 = other_value.mccDigit3();
} else {
  single_value->field_mccDigit3.clean_up();
}
if (other_value.mncDigit3().is_bound()) {
  single_value->field_mncDigit3 = other_value.mncDigit3();
} else {
  single_value->field_mncDigit3.clean_up();
}
if (other_value.mncDigit1().is_bound()) {
  single_value->field_mncDigit1 = other_value.mncDigit1();
} else {
  single_value->field_mncDigit1.clean_up();
}
if (other_value.mncDigit2().is_bound()) {
  single_value->field_mncDigit2 = other_value.mncDigit2();
} else {
  single_value->field_mncDigit2.clean_up();
}
if (other_value.lac().is_bound()) {
  single_value->field_lac = other_value.lac();
} else {
  single_value->field_lac.clean_up();
}
if (other_value.rac().is_bound()) {
  single_value->field_rac = other_value.rac();
} else {
  single_value->field_rac.clean_up();
}
if (other_value.cI__value().is_bound()) {
  single_value->field_cI__value = other_value.cI__value();
} else {
  single_value->field_cI__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Cell__Identifier__V__GTPC_template::copy_template(const Cell__Identifier__V__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.mccDigit1().get_selection()) {
single_value->field_mccDigit1 = other_value.mccDigit1();
} else {
single_value->field_mccDigit1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mccDigit2().get_selection()) {
single_value->field_mccDigit2 = other_value.mccDigit2();
} else {
single_value->field_mccDigit2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mccDigit3().get_selection()) {
single_value->field_mccDigit3 = other_value.mccDigit3();
} else {
single_value->field_mccDigit3.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mncDigit3().get_selection()) {
single_value->field_mncDigit3 = other_value.mncDigit3();
} else {
single_value->field_mncDigit3.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mncDigit1().get_selection()) {
single_value->field_mncDigit1 = other_value.mncDigit1();
} else {
single_value->field_mncDigit1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mncDigit2().get_selection()) {
single_value->field_mncDigit2 = other_value.mncDigit2();
} else {
single_value->field_mncDigit2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lac().get_selection()) {
single_value->field_lac = other_value.lac();
} else {
single_value->field_lac.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rac().get_selection()) {
single_value->field_rac = other_value.rac();
} else {
single_value->field_rac.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cI__value().get_selection()) {
single_value->field_cI__value = other_value.cI__value();
} else {
single_value->field_cI__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Cell__Identifier__V__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Cell__Identifier__V__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new Cell__Identifier__V__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
break;
}
set_selection(other_value);
}

Cell__Identifier__V__GTPC_template::Cell__Identifier__V__GTPC_template()
{
}

Cell__Identifier__V__GTPC_template::Cell__Identifier__V__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Cell__Identifier__V__GTPC_template::Cell__Identifier__V__GTPC_template(const Cell__Identifier__V__GTPC& other_value)
{
copy_value(other_value);
}

Cell__Identifier__V__GTPC_template::Cell__Identifier__V__GTPC_template(const OPTIONAL<Cell__Identifier__V__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Cell__Identifier__V__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.Cell_Identifier_V_GTPC from an unbound optional field.");
}
}

Cell__Identifier__V__GTPC_template::Cell__Identifier__V__GTPC_template(Cell__Identifier__V__GTPC_template* p_precondition, Cell__Identifier__V__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Cell__Identifier__V__GTPC_template::Cell__Identifier__V__GTPC_template(Dynamic_Match_Interface<Cell__Identifier__V__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Cell__Identifier__V__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Cell__Identifier__V__GTPC_template::Cell__Identifier__V__GTPC_template(const Cell__Identifier__V__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Cell__Identifier__V__GTPC_template::~Cell__Identifier__V__GTPC_template()
{
clean_up();
}

Cell__Identifier__V__GTPC_template& Cell__Identifier__V__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Cell__Identifier__V__GTPC_template& Cell__Identifier__V__GTPC_template::operator=(const Cell__Identifier__V__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Cell__Identifier__V__GTPC_template& Cell__Identifier__V__GTPC_template::operator=(const OPTIONAL<Cell__Identifier__V__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Cell__Identifier__V__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
}
return *this;
}

Cell__Identifier__V__GTPC_template& Cell__Identifier__V__GTPC_template::operator=(const Cell__Identifier__V__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Cell__Identifier__V__GTPC_template::match(const Cell__Identifier__V__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.mccDigit1().is_bound()) return FALSE;
if(!single_value->field_mccDigit1.match(other_value.mccDigit1(), legacy))return FALSE;
if(!other_value.mccDigit2().is_bound()) return FALSE;
if(!single_value->field_mccDigit2.match(other_value.mccDigit2(), legacy))return FALSE;
if(!other_value.mccDigit3().is_bound()) return FALSE;
if(!single_value->field_mccDigit3.match(other_value.mccDigit3(), legacy))return FALSE;
if(!other_value.mncDigit3().is_bound()) return FALSE;
if(!single_value->field_mncDigit3.match(other_value.mncDigit3(), legacy))return FALSE;
if(!other_value.mncDigit1().is_bound()) return FALSE;
if(!single_value->field_mncDigit1.match(other_value.mncDigit1(), legacy))return FALSE;
if(!other_value.mncDigit2().is_bound()) return FALSE;
if(!single_value->field_mncDigit2.match(other_value.mncDigit2(), legacy))return FALSE;
if(!other_value.lac().is_bound()) return FALSE;
if(!single_value->field_lac.match(other_value.lac(), legacy))return FALSE;
if(!other_value.rac().is_bound()) return FALSE;
if(!single_value->field_rac.match(other_value.rac(), legacy))return FALSE;
if(!other_value.cI__value().is_bound()) return FALSE;
if(!single_value->field_cI__value.match(other_value.cI__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
}
return FALSE;
}

boolean Cell__Identifier__V__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_mccDigit1.is_bound()
 || single_value->field_mccDigit2.is_bound()
 || single_value->field_mccDigit3.is_bound()
 || single_value->field_mncDigit3.is_bound()
 || single_value->field_mncDigit1.is_bound()
 || single_value->field_mncDigit2.is_bound()
 || single_value->field_lac.is_bound()
 || single_value->field_rac.is_bound()
 || single_value->field_cI__value.is_bound();
}

boolean Cell__Identifier__V__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_mccDigit1.is_value()
 && single_value->field_mccDigit2.is_value()
 && single_value->field_mccDigit3.is_value()
 && single_value->field_mncDigit3.is_value()
 && single_value->field_mncDigit1.is_value()
 && single_value->field_mncDigit2.is_value()
 && single_value->field_lac.is_value()
 && single_value->field_rac.is_value()
 && single_value->field_cI__value.is_value();
}

void Cell__Identifier__V__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Cell__Identifier__V__GTPC Cell__Identifier__V__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
Cell__Identifier__V__GTPC ret_val;
if (single_value->field_mccDigit1.is_bound()) {
ret_val.mccDigit1() = single_value->field_mccDigit1.valueof();
}
if (single_value->field_mccDigit2.is_bound()) {
ret_val.mccDigit2() = single_value->field_mccDigit2.valueof();
}
if (single_value->field_mccDigit3.is_bound()) {
ret_val.mccDigit3() = single_value->field_mccDigit3.valueof();
}
if (single_value->field_mncDigit3.is_bound()) {
ret_val.mncDigit3() = single_value->field_mncDigit3.valueof();
}
if (single_value->field_mncDigit1.is_bound()) {
ret_val.mncDigit1() = single_value->field_mncDigit1.valueof();
}
if (single_value->field_mncDigit2.is_bound()) {
ret_val.mncDigit2() = single_value->field_mncDigit2.valueof();
}
if (single_value->field_lac.is_bound()) {
ret_val.lac() = single_value->field_lac.valueof();
}
if (single_value->field_rac.is_bound()) {
ret_val.rac() = single_value->field_rac.valueof();
}
if (single_value->field_cI__value.is_bound()) {
ret_val.cI__value() = single_value->field_cI__value.valueof();
}
return ret_val;
}

void Cell__Identifier__V__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Cell__Identifier__V__GTPC_template[list_length];
}

Cell__Identifier__V__GTPC_template& Cell__Identifier__V__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
return value_list.list_value[list_index];
}

HEXSTRING_template& Cell__Identifier__V__GTPC_template::mccDigit1()
{
set_specific();
return single_value->field_mccDigit1;
}

const HEXSTRING_template& Cell__Identifier__V__GTPC_template::mccDigit1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mccDigit1 of a non-specific template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
return single_value->field_mccDigit1;
}

HEXSTRING_template& Cell__Identifier__V__GTPC_template::mccDigit2()
{
set_specific();
return single_value->field_mccDigit2;
}

const HEXSTRING_template& Cell__Identifier__V__GTPC_template::mccDigit2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mccDigit2 of a non-specific template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
return single_value->field_mccDigit2;
}

HEXSTRING_template& Cell__Identifier__V__GTPC_template::mccDigit3()
{
set_specific();
return single_value->field_mccDigit3;
}

const HEXSTRING_template& Cell__Identifier__V__GTPC_template::mccDigit3() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mccDigit3 of a non-specific template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
return single_value->field_mccDigit3;
}

HEXSTRING_template& Cell__Identifier__V__GTPC_template::mncDigit3()
{
set_specific();
return single_value->field_mncDigit3;
}

const HEXSTRING_template& Cell__Identifier__V__GTPC_template::mncDigit3() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mncDigit3 of a non-specific template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
return single_value->field_mncDigit3;
}

HEXSTRING_template& Cell__Identifier__V__GTPC_template::mncDigit1()
{
set_specific();
return single_value->field_mncDigit1;
}

const HEXSTRING_template& Cell__Identifier__V__GTPC_template::mncDigit1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mncDigit1 of a non-specific template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
return single_value->field_mncDigit1;
}

HEXSTRING_template& Cell__Identifier__V__GTPC_template::mncDigit2()
{
set_specific();
return single_value->field_mncDigit2;
}

const HEXSTRING_template& Cell__Identifier__V__GTPC_template::mncDigit2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mncDigit2 of a non-specific template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
return single_value->field_mncDigit2;
}

OCTETSTRING_template& Cell__Identifier__V__GTPC_template::lac()
{
set_specific();
return single_value->field_lac;
}

const OCTETSTRING_template& Cell__Identifier__V__GTPC_template::lac() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lac of a non-specific template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
return single_value->field_lac;
}

OCTETSTRING_template& Cell__Identifier__V__GTPC_template::rac()
{
set_specific();
return single_value->field_rac;
}

const OCTETSTRING_template& Cell__Identifier__V__GTPC_template::rac() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rac of a non-specific template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
return single_value->field_rac;
}

OCTETSTRING_template& Cell__Identifier__V__GTPC_template::cI__value()
{
set_specific();
return single_value->field_cI__value;
}

const OCTETSTRING_template& Cell__Identifier__V__GTPC_template::cI__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cI_value of a non-specific template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
return single_value->field_cI__value;
}

int Cell__Identifier__V__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Cell_Identifier_V_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 9;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.Cell_Identifier_V_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Cell_Identifier_V_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Cell_Identifier_V_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Cell_Identifier_V_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Cell_Identifier_V_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Cell_Identifier_V_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Cell_Identifier_V_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Cell_Identifier_V_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
  }
  return 0;
}

void Cell__Identifier__V__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ mccDigit1 := ");
single_value->field_mccDigit1.log();
TTCN_Logger::log_event_str(", mccDigit2 := ");
single_value->field_mccDigit2.log();
TTCN_Logger::log_event_str(", mccDigit3 := ");
single_value->field_mccDigit3.log();
TTCN_Logger::log_event_str(", mncDigit3 := ");
single_value->field_mncDigit3.log();
TTCN_Logger::log_event_str(", mncDigit1 := ");
single_value->field_mncDigit1.log();
TTCN_Logger::log_event_str(", mncDigit2 := ");
single_value->field_mncDigit2.log();
TTCN_Logger::log_event_str(", lac := ");
single_value->field_lac.log();
TTCN_Logger::log_event_str(", rac := ");
single_value->field_rac.log();
TTCN_Logger::log_event_str(", cI_value := ");
single_value->field_cI__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Cell__Identifier__V__GTPC_template::log_match(const Cell__Identifier__V__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_mccDigit1.match(match_value.mccDigit1(), legacy)){
TTCN_Logger::log_logmatch_info(".mccDigit1");
single_value->field_mccDigit1.log_match(match_value.mccDigit1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mccDigit2.match(match_value.mccDigit2(), legacy)){
TTCN_Logger::log_logmatch_info(".mccDigit2");
single_value->field_mccDigit2.log_match(match_value.mccDigit2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mccDigit3.match(match_value.mccDigit3(), legacy)){
TTCN_Logger::log_logmatch_info(".mccDigit3");
single_value->field_mccDigit3.log_match(match_value.mccDigit3(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mncDigit3.match(match_value.mncDigit3(), legacy)){
TTCN_Logger::log_logmatch_info(".mncDigit3");
single_value->field_mncDigit3.log_match(match_value.mncDigit3(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mncDigit1.match(match_value.mncDigit1(), legacy)){
TTCN_Logger::log_logmatch_info(".mncDigit1");
single_value->field_mncDigit1.log_match(match_value.mncDigit1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mncDigit2.match(match_value.mncDigit2(), legacy)){
TTCN_Logger::log_logmatch_info(".mncDigit2");
single_value->field_mncDigit2.log_match(match_value.mncDigit2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lac.match(match_value.lac(), legacy)){
TTCN_Logger::log_logmatch_info(".lac");
single_value->field_lac.log_match(match_value.lac(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rac.match(match_value.rac(), legacy)){
TTCN_Logger::log_logmatch_info(".rac");
single_value->field_rac.log_match(match_value.rac(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cI__value.match(match_value.cI__value(), legacy)){
TTCN_Logger::log_logmatch_info(".cI_value");
single_value->field_cI__value.log_match(match_value.cI__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ mccDigit1 := ");
single_value->field_mccDigit1.log_match(match_value.mccDigit1(), legacy);
TTCN_Logger::log_event_str(", mccDigit2 := ");
single_value->field_mccDigit2.log_match(match_value.mccDigit2(), legacy);
TTCN_Logger::log_event_str(", mccDigit3 := ");
single_value->field_mccDigit3.log_match(match_value.mccDigit3(), legacy);
TTCN_Logger::log_event_str(", mncDigit3 := ");
single_value->field_mncDigit3.log_match(match_value.mncDigit3(), legacy);
TTCN_Logger::log_event_str(", mncDigit1 := ");
single_value->field_mncDigit1.log_match(match_value.mncDigit1(), legacy);
TTCN_Logger::log_event_str(", mncDigit2 := ");
single_value->field_mncDigit2.log_match(match_value.mncDigit2(), legacy);
TTCN_Logger::log_event_str(", lac := ");
single_value->field_lac.log_match(match_value.lac(), legacy);
TTCN_Logger::log_event_str(", rac := ");
single_value->field_rac.log_match(match_value.rac(), legacy);
TTCN_Logger::log_event_str(", cI_value := ");
single_value->field_cI__value.log_match(match_value.cI__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Cell__Identifier__V__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (mccDigit1().is_bound()) mccDigit1().set_implicit_omit();
if (mccDigit2().is_bound()) mccDigit2().set_implicit_omit();
if (mccDigit3().is_bound()) mccDigit3().set_implicit_omit();
if (mncDigit3().is_bound()) mncDigit3().set_implicit_omit();
if (mncDigit1().is_bound()) mncDigit1().set_implicit_omit();
if (mncDigit2().is_bound()) mncDigit2().set_implicit_omit();
if (lac().is_bound()) lac().set_implicit_omit();
if (rac().is_bound()) rac().set_implicit_omit();
if (cI__value().is_bound()) cI__value().set_implicit_omit();
}

void Cell__Identifier__V__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_mccDigit1.encode_text(text_buf);
single_value->field_mccDigit2.encode_text(text_buf);
single_value->field_mccDigit3.encode_text(text_buf);
single_value->field_mncDigit3.encode_text(text_buf);
single_value->field_mncDigit1.encode_text(text_buf);
single_value->field_mncDigit2.encode_text(text_buf);
single_value->field_lac.encode_text(text_buf);
single_value->field_rac.encode_text(text_buf);
single_value->field_cI__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
}
}

void Cell__Identifier__V__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_mccDigit1.decode_text(text_buf);
single_value->field_mccDigit2.decode_text(text_buf);
single_value->field_mccDigit3.decode_text(text_buf);
single_value->field_mncDigit3.decode_text(text_buf);
single_value->field_mncDigit1.decode_text(text_buf);
single_value->field_mncDigit2.decode_text(text_buf);
single_value->field_lac.decode_text(text_buf);
single_value->field_rac.decode_text(text_buf);
single_value->field_cI__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Cell__Identifier__V__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.Cell_Identifier_V_GTPC.");
}
}

void Cell__Identifier__V__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Cell__Identifier__V__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record template of type @GTPC_Types.Cell_Identifier_V_GTPC has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) mccDigit1().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mccDigit2().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) mccDigit3().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) mncDigit3().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) mncDigit1().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) mncDigit2().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) lac().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) rac().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) cI__value().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mccDigit1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mccDigit1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mccDigit2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mccDigit2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mccDigit3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mccDigit3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mncDigit3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mncDigit3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mncDigit1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mncDigit1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mncDigit2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mncDigit2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cI_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cI__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.Cell_Identifier_V_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Cell__Identifier__V__GTPC_template* precondition = new Cell__Identifier__V__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    Cell__Identifier__V__GTPC_template* implied_template = new Cell__Identifier__V__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Cell__Identifier__V__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.Cell_Identifier_V_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void Cell__Identifier__V__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_mccDigit1.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.Cell_Identifier_V_GTPC");
single_value->field_mccDigit2.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.Cell_Identifier_V_GTPC");
single_value->field_mccDigit3.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.Cell_Identifier_V_GTPC");
single_value->field_mncDigit3.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.Cell_Identifier_V_GTPC");
single_value->field_mncDigit1.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.Cell_Identifier_V_GTPC");
single_value->field_mncDigit2.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.Cell_Identifier_V_GTPC");
single_value->field_lac.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.Cell_Identifier_V_GTPC");
single_value->field_rac.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.Cell_Identifier_V_GTPC");
single_value->field_cI__value.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.Cell_Identifier_V_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.Cell_Identifier_V_GTPC");
}

boolean Cell__Identifier__V__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Cell__Identifier__V__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RAN__Information__Request__Application__Container__NACC__GTPC::RAN__Information__Request__Application__Container__NACC__GTPC()
{
}

RAN__Information__Request__Application__Container__NACC__GTPC::RAN__Information__Request__Application__Container__NACC__GTPC(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a__GTPC& par_lengthIndicator,
    const Cell__Identifier__V__GTPC& par_reporting__Cell__Identifier)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_reporting__Cell__Identifier(par_reporting__Cell__Identifier)
{
}

RAN__Information__Request__Application__Container__NACC__GTPC::RAN__Information__Request__Application__Container__NACC__GTPC(const RAN__Information__Request__Application__Container__NACC__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.reporting__Cell__Identifier().is_bound()) field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
else field_reporting__Cell__Identifier.clean_up();
}

void RAN__Information__Request__Application__Container__NACC__GTPC::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_reporting__Cell__Identifier.clean_up();
}

const TTCN_Typedescriptor_t* RAN__Information__Request__Application__Container__NACC__GTPC::get_descriptor() const { return &RAN__Information__Request__Application__Container__NACC__GTPC_descr_; }
RAN__Information__Request__Application__Container__NACC__GTPC& RAN__Information__Request__Application__Container__NACC__GTPC::operator=(const RAN__Information__Request__Application__Container__NACC__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.reporting__Cell__Identifier().is_bound()) field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
  else field_reporting__Cell__Identifier.clean_up();
}
return *this;
}

boolean RAN__Information__Request__Application__Container__NACC__GTPC::operator==(const RAN__Information__Request__Application__Container__NACC__GTPC& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_reporting__Cell__Identifier==other_value.field_reporting__Cell__Identifier;
}

boolean RAN__Information__Request__Application__Container__NACC__GTPC::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_reporting__Cell__Identifier.is_bound());
}
boolean RAN__Information__Request__Application__Container__NACC__GTPC::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_reporting__Cell__Identifier.is_value();
}
void RAN__Information__Request__Application__Container__NACC__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
field_reporting__Cell__Identifier.log();
TTCN_Logger::log_event_str(" }");
}

void RAN__Information__Request__Application__Container__NACC__GTPC::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reporting__Cell__Identifier().is_bound()) reporting__Cell__Identifier().set_implicit_omit();
}

void RAN__Information__Request__Application__Container__NACC__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reporting__Cell__Identifier().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_Cell_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__Cell__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC");
  }
}

void RAN__Information__Request__Application__Container__NACC__GTPC::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_reporting__Cell__Identifier.encode_text(text_buf);
}

void RAN__Information__Request__Application__Container__NACC__GTPC::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_reporting__Cell__Identifier.decode_text(text_buf);
}

void RAN__Information__Request__Application__Container__NACC__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RAN__Information__Request__Application__Container__NACC__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RAN__Information__Request__Application__Container__NACC__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RAN__Information__Request__Application__Container__NACC__GTPC_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(RAN__Information__Request__Application__Container__NACC__GTPC_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_3) selected_field = 0;
  else if (field_ext ==  bs_24) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RAN__Information__Request__Application__Container__NACC__GTPC_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(RAN__Information__Request__Application__Container__NACC__GTPC_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a__GTPC_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a__GTPC::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a__GTPC_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, Cell__Identifier__V__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_reporting__Cell__Identifier.RAW_decode(Cell__Identifier__V__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RAN__Information__Request__Application__Container__NACC__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RAN__Information__Request__Application__Container__NACC__GTPC_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RAN__Information__Request__Application__Container__NACC__GTPC_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, Cell__Identifier__V__GTPC_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(RAN__Information__Request__Application__Container__NACC__GTPC_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(RAN__Information__Request__Application__Container__NACC__GTPC_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_reporting__Cell__Identifier.RAW_encode(Cell__Identifier__V__GTPC_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1:
  if (field_ext !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(RAN__Information__Request__Application__Container__NACC__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a__GTPC::ALT_length2:
  if (field_ext !=  bs_24) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_24.RAW_encode(RAN__Information__Request__Application__Container__NACC__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  return myleaf.length = encoded_length;
}

struct RAN__Information__Request__Application__Container__NACC__GTPC_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a__GTPC_template field_lengthIndicator;
Cell__Identifier__V__GTPC_template field_reporting__Cell__Identifier;
};

void RAN__Information__Request__Application__Container__NACC__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_reporting__Cell__Identifier = ANY_VALUE;
}
}
}

void RAN__Information__Request__Application__Container__NACC__GTPC_template::copy_value(const RAN__Information__Request__Application__Container__NACC__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.reporting__Cell__Identifier().is_bound()) {
  single_value->field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
} else {
  single_value->field_reporting__Cell__Identifier.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RAN__Information__Request__Application__Container__NACC__GTPC_template::copy_template(const RAN__Information__Request__Application__Container__NACC__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reporting__Cell__Identifier().get_selection()) {
single_value->field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
} else {
single_value->field_reporting__Cell__Identifier.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RAN__Information__Request__Application__Container__NACC__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RAN__Information__Request__Application__Container__NACC__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new RAN__Information__Request__Application__Container__NACC__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
break;
}
set_selection(other_value);
}

RAN__Information__Request__Application__Container__NACC__GTPC_template::RAN__Information__Request__Application__Container__NACC__GTPC_template()
{
}

RAN__Information__Request__Application__Container__NACC__GTPC_template::RAN__Information__Request__Application__Container__NACC__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RAN__Information__Request__Application__Container__NACC__GTPC_template::RAN__Information__Request__Application__Container__NACC__GTPC_template(const RAN__Information__Request__Application__Container__NACC__GTPC& other_value)
{
copy_value(other_value);
}

RAN__Information__Request__Application__Container__NACC__GTPC_template::RAN__Information__Request__Application__Container__NACC__GTPC_template(const OPTIONAL<RAN__Information__Request__Application__Container__NACC__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__Application__Container__NACC__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC from an unbound optional field.");
}
}

RAN__Information__Request__Application__Container__NACC__GTPC_template::RAN__Information__Request__Application__Container__NACC__GTPC_template(RAN__Information__Request__Application__Container__NACC__GTPC_template* p_precondition, RAN__Information__Request__Application__Container__NACC__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RAN__Information__Request__Application__Container__NACC__GTPC_template::RAN__Information__Request__Application__Container__NACC__GTPC_template(Dynamic_Match_Interface<RAN__Information__Request__Application__Container__NACC__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RAN__Information__Request__Application__Container__NACC__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RAN__Information__Request__Application__Container__NACC__GTPC_template::RAN__Information__Request__Application__Container__NACC__GTPC_template(const RAN__Information__Request__Application__Container__NACC__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RAN__Information__Request__Application__Container__NACC__GTPC_template::~RAN__Information__Request__Application__Container__NACC__GTPC_template()
{
clean_up();
}

RAN__Information__Request__Application__Container__NACC__GTPC_template& RAN__Information__Request__Application__Container__NACC__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RAN__Information__Request__Application__Container__NACC__GTPC_template& RAN__Information__Request__Application__Container__NACC__GTPC_template::operator=(const RAN__Information__Request__Application__Container__NACC__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RAN__Information__Request__Application__Container__NACC__GTPC_template& RAN__Information__Request__Application__Container__NACC__GTPC_template::operator=(const OPTIONAL<RAN__Information__Request__Application__Container__NACC__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__Application__Container__NACC__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
}
return *this;
}

RAN__Information__Request__Application__Container__NACC__GTPC_template& RAN__Information__Request__Application__Container__NACC__GTPC_template::operator=(const RAN__Information__Request__Application__Container__NACC__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RAN__Information__Request__Application__Container__NACC__GTPC_template::match(const RAN__Information__Request__Application__Container__NACC__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.reporting__Cell__Identifier().is_bound()) return FALSE;
if(!single_value->field_reporting__Cell__Identifier.match(other_value.reporting__Cell__Identifier(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
}
return FALSE;
}

boolean RAN__Information__Request__Application__Container__NACC__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_reporting__Cell__Identifier.is_bound();
}

boolean RAN__Information__Request__Application__Container__NACC__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_reporting__Cell__Identifier.is_value();
}

void RAN__Information__Request__Application__Container__NACC__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RAN__Information__Request__Application__Container__NACC__GTPC RAN__Information__Request__Application__Container__NACC__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
RAN__Information__Request__Application__Container__NACC__GTPC ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_reporting__Cell__Identifier.is_bound()) {
ret_val.reporting__Cell__Identifier() = single_value->field_reporting__Cell__Identifier.valueof();
}
return ret_val;
}

void RAN__Information__Request__Application__Container__NACC__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RAN__Information__Request__Application__Container__NACC__GTPC_template[list_length];
}

RAN__Information__Request__Application__Container__NACC__GTPC_template& RAN__Information__Request__Application__Container__NACC__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RAN__Information__Request__Application__Container__NACC__GTPC_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& RAN__Information__Request__Application__Container__NACC__GTPC_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
return single_value->field_iEI;
}

BITSTRING_template& RAN__Information__Request__Application__Container__NACC__GTPC_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& RAN__Information__Request__Application__Container__NACC__GTPC_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
return single_value->field_ext;
}

LIN2__2a__GTPC_template& RAN__Information__Request__Application__Container__NACC__GTPC_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a__GTPC_template& RAN__Information__Request__Application__Container__NACC__GTPC_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
return single_value->field_lengthIndicator;
}

Cell__Identifier__V__GTPC_template& RAN__Information__Request__Application__Container__NACC__GTPC_template::reporting__Cell__Identifier()
{
set_specific();
return single_value->field_reporting__Cell__Identifier;
}

const Cell__Identifier__V__GTPC_template& RAN__Information__Request__Application__Container__NACC__GTPC_template::reporting__Cell__Identifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reporting_Cell_Identifier of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
return single_value->field_reporting__Cell__Identifier;
}

int RAN__Information__Request__Application__Container__NACC__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
  }
  return 0;
}

void RAN__Information__Request__Application__Container__NACC__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
single_value->field_reporting__Cell__Identifier.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RAN__Information__Request__Application__Container__NACC__GTPC_template::log_match(const RAN__Information__Request__Application__Container__NACC__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reporting__Cell__Identifier.match(match_value.reporting__Cell__Identifier(), legacy)){
TTCN_Logger::log_logmatch_info(".reporting_Cell_Identifier");
single_value->field_reporting__Cell__Identifier.log_match(match_value.reporting__Cell__Identifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
single_value->field_reporting__Cell__Identifier.log_match(match_value.reporting__Cell__Identifier(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RAN__Information__Request__Application__Container__NACC__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reporting__Cell__Identifier().is_bound()) reporting__Cell__Identifier().set_implicit_omit();
}

void RAN__Information__Request__Application__Container__NACC__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_reporting__Cell__Identifier.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
}
}

void RAN__Information__Request__Application__Container__NACC__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_reporting__Cell__Identifier.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RAN__Information__Request__Application__Container__NACC__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC.");
}
}

void RAN__Information__Request__Application__Container__NACC__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RAN__Information__Request__Application__Container__NACC__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reporting__Cell__Identifier().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_Cell_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__Cell__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RAN__Information__Request__Application__Container__NACC__GTPC_template* precondition = new RAN__Information__Request__Application__Container__NACC__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    RAN__Information__Request__Application__Container__NACC__GTPC_template* implied_template = new RAN__Information__Request__Application__Container__NACC__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RAN__Information__Request__Application__Container__NACC__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void RAN__Information__Request__Application__Container__NACC__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC");
single_value->field_reporting__Cell__Identifier.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_NACC_GTPC");
}

boolean RAN__Information__Request__Application__Container__NACC__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RAN__Information__Request__Application__Container__NACC__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RAN__Information__Request__Application__Container__SI3__GTPC::RAN__Information__Request__Application__Container__SI3__GTPC()
{
}

RAN__Information__Request__Application__Container__SI3__GTPC::RAN__Information__Request__Application__Container__SI3__GTPC(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a__GTPC& par_lengthIndicator,
    const Cell__Identifier__V__GTPC& par_reporting__Cell__Identifier)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_reporting__Cell__Identifier(par_reporting__Cell__Identifier)
{
}

RAN__Information__Request__Application__Container__SI3__GTPC::RAN__Information__Request__Application__Container__SI3__GTPC(const RAN__Information__Request__Application__Container__SI3__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.reporting__Cell__Identifier().is_bound()) field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
else field_reporting__Cell__Identifier.clean_up();
}

void RAN__Information__Request__Application__Container__SI3__GTPC::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_reporting__Cell__Identifier.clean_up();
}

const TTCN_Typedescriptor_t* RAN__Information__Request__Application__Container__SI3__GTPC::get_descriptor() const { return &RAN__Information__Request__Application__Container__SI3__GTPC_descr_; }
RAN__Information__Request__Application__Container__SI3__GTPC& RAN__Information__Request__Application__Container__SI3__GTPC::operator=(const RAN__Information__Request__Application__Container__SI3__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.reporting__Cell__Identifier().is_bound()) field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
  else field_reporting__Cell__Identifier.clean_up();
}
return *this;
}

boolean RAN__Information__Request__Application__Container__SI3__GTPC::operator==(const RAN__Information__Request__Application__Container__SI3__GTPC& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_reporting__Cell__Identifier==other_value.field_reporting__Cell__Identifier;
}

boolean RAN__Information__Request__Application__Container__SI3__GTPC::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_reporting__Cell__Identifier.is_bound());
}
boolean RAN__Information__Request__Application__Container__SI3__GTPC::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_reporting__Cell__Identifier.is_value();
}
void RAN__Information__Request__Application__Container__SI3__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
field_reporting__Cell__Identifier.log();
TTCN_Logger::log_event_str(" }");
}

void RAN__Information__Request__Application__Container__SI3__GTPC::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reporting__Cell__Identifier().is_bound()) reporting__Cell__Identifier().set_implicit_omit();
}

void RAN__Information__Request__Application__Container__SI3__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reporting__Cell__Identifier().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_Cell_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__Cell__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC");
  }
}

void RAN__Information__Request__Application__Container__SI3__GTPC::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_reporting__Cell__Identifier.encode_text(text_buf);
}

void RAN__Information__Request__Application__Container__SI3__GTPC::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_reporting__Cell__Identifier.decode_text(text_buf);
}

void RAN__Information__Request__Application__Container__SI3__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RAN__Information__Request__Application__Container__SI3__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RAN__Information__Request__Application__Container__SI3__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RAN__Information__Request__Application__Container__SI3__GTPC_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(RAN__Information__Request__Application__Container__SI3__GTPC_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_3) selected_field = 0;
  else if (field_ext ==  bs_24) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RAN__Information__Request__Application__Container__SI3__GTPC_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(RAN__Information__Request__Application__Container__SI3__GTPC_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a__GTPC_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a__GTPC::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a__GTPC_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, Cell__Identifier__V__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_reporting__Cell__Identifier.RAW_decode(Cell__Identifier__V__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RAN__Information__Request__Application__Container__SI3__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RAN__Information__Request__Application__Container__SI3__GTPC_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RAN__Information__Request__Application__Container__SI3__GTPC_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, Cell__Identifier__V__GTPC_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(RAN__Information__Request__Application__Container__SI3__GTPC_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(RAN__Information__Request__Application__Container__SI3__GTPC_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_reporting__Cell__Identifier.RAW_encode(Cell__Identifier__V__GTPC_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1:
  if (field_ext !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(RAN__Information__Request__Application__Container__SI3__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a__GTPC::ALT_length2:
  if (field_ext !=  bs_24) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_24.RAW_encode(RAN__Information__Request__Application__Container__SI3__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  return myleaf.length = encoded_length;
}

struct RAN__Information__Request__Application__Container__SI3__GTPC_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a__GTPC_template field_lengthIndicator;
Cell__Identifier__V__GTPC_template field_reporting__Cell__Identifier;
};

void RAN__Information__Request__Application__Container__SI3__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_reporting__Cell__Identifier = ANY_VALUE;
}
}
}

void RAN__Information__Request__Application__Container__SI3__GTPC_template::copy_value(const RAN__Information__Request__Application__Container__SI3__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.reporting__Cell__Identifier().is_bound()) {
  single_value->field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
} else {
  single_value->field_reporting__Cell__Identifier.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RAN__Information__Request__Application__Container__SI3__GTPC_template::copy_template(const RAN__Information__Request__Application__Container__SI3__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reporting__Cell__Identifier().get_selection()) {
single_value->field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
} else {
single_value->field_reporting__Cell__Identifier.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RAN__Information__Request__Application__Container__SI3__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RAN__Information__Request__Application__Container__SI3__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new RAN__Information__Request__Application__Container__SI3__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
break;
}
set_selection(other_value);
}

RAN__Information__Request__Application__Container__SI3__GTPC_template::RAN__Information__Request__Application__Container__SI3__GTPC_template()
{
}

RAN__Information__Request__Application__Container__SI3__GTPC_template::RAN__Information__Request__Application__Container__SI3__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RAN__Information__Request__Application__Container__SI3__GTPC_template::RAN__Information__Request__Application__Container__SI3__GTPC_template(const RAN__Information__Request__Application__Container__SI3__GTPC& other_value)
{
copy_value(other_value);
}

RAN__Information__Request__Application__Container__SI3__GTPC_template::RAN__Information__Request__Application__Container__SI3__GTPC_template(const OPTIONAL<RAN__Information__Request__Application__Container__SI3__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__Application__Container__SI3__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC from an unbound optional field.");
}
}

RAN__Information__Request__Application__Container__SI3__GTPC_template::RAN__Information__Request__Application__Container__SI3__GTPC_template(RAN__Information__Request__Application__Container__SI3__GTPC_template* p_precondition, RAN__Information__Request__Application__Container__SI3__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RAN__Information__Request__Application__Container__SI3__GTPC_template::RAN__Information__Request__Application__Container__SI3__GTPC_template(Dynamic_Match_Interface<RAN__Information__Request__Application__Container__SI3__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RAN__Information__Request__Application__Container__SI3__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RAN__Information__Request__Application__Container__SI3__GTPC_template::RAN__Information__Request__Application__Container__SI3__GTPC_template(const RAN__Information__Request__Application__Container__SI3__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RAN__Information__Request__Application__Container__SI3__GTPC_template::~RAN__Information__Request__Application__Container__SI3__GTPC_template()
{
clean_up();
}

RAN__Information__Request__Application__Container__SI3__GTPC_template& RAN__Information__Request__Application__Container__SI3__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RAN__Information__Request__Application__Container__SI3__GTPC_template& RAN__Information__Request__Application__Container__SI3__GTPC_template::operator=(const RAN__Information__Request__Application__Container__SI3__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RAN__Information__Request__Application__Container__SI3__GTPC_template& RAN__Information__Request__Application__Container__SI3__GTPC_template::operator=(const OPTIONAL<RAN__Information__Request__Application__Container__SI3__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__Application__Container__SI3__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
}
return *this;
}

RAN__Information__Request__Application__Container__SI3__GTPC_template& RAN__Information__Request__Application__Container__SI3__GTPC_template::operator=(const RAN__Information__Request__Application__Container__SI3__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RAN__Information__Request__Application__Container__SI3__GTPC_template::match(const RAN__Information__Request__Application__Container__SI3__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.reporting__Cell__Identifier().is_bound()) return FALSE;
if(!single_value->field_reporting__Cell__Identifier.match(other_value.reporting__Cell__Identifier(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
}
return FALSE;
}

boolean RAN__Information__Request__Application__Container__SI3__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_reporting__Cell__Identifier.is_bound();
}

boolean RAN__Information__Request__Application__Container__SI3__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_reporting__Cell__Identifier.is_value();
}

void RAN__Information__Request__Application__Container__SI3__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RAN__Information__Request__Application__Container__SI3__GTPC RAN__Information__Request__Application__Container__SI3__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
RAN__Information__Request__Application__Container__SI3__GTPC ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_reporting__Cell__Identifier.is_bound()) {
ret_val.reporting__Cell__Identifier() = single_value->field_reporting__Cell__Identifier.valueof();
}
return ret_val;
}

void RAN__Information__Request__Application__Container__SI3__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RAN__Information__Request__Application__Container__SI3__GTPC_template[list_length];
}

RAN__Information__Request__Application__Container__SI3__GTPC_template& RAN__Information__Request__Application__Container__SI3__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RAN__Information__Request__Application__Container__SI3__GTPC_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& RAN__Information__Request__Application__Container__SI3__GTPC_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
return single_value->field_iEI;
}

BITSTRING_template& RAN__Information__Request__Application__Container__SI3__GTPC_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& RAN__Information__Request__Application__Container__SI3__GTPC_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
return single_value->field_ext;
}

LIN2__2a__GTPC_template& RAN__Information__Request__Application__Container__SI3__GTPC_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a__GTPC_template& RAN__Information__Request__Application__Container__SI3__GTPC_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
return single_value->field_lengthIndicator;
}

Cell__Identifier__V__GTPC_template& RAN__Information__Request__Application__Container__SI3__GTPC_template::reporting__Cell__Identifier()
{
set_specific();
return single_value->field_reporting__Cell__Identifier;
}

const Cell__Identifier__V__GTPC_template& RAN__Information__Request__Application__Container__SI3__GTPC_template::reporting__Cell__Identifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reporting_Cell_Identifier of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
return single_value->field_reporting__Cell__Identifier;
}

int RAN__Information__Request__Application__Container__SI3__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
  }
  return 0;
}

void RAN__Information__Request__Application__Container__SI3__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
single_value->field_reporting__Cell__Identifier.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RAN__Information__Request__Application__Container__SI3__GTPC_template::log_match(const RAN__Information__Request__Application__Container__SI3__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reporting__Cell__Identifier.match(match_value.reporting__Cell__Identifier(), legacy)){
TTCN_Logger::log_logmatch_info(".reporting_Cell_Identifier");
single_value->field_reporting__Cell__Identifier.log_match(match_value.reporting__Cell__Identifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
single_value->field_reporting__Cell__Identifier.log_match(match_value.reporting__Cell__Identifier(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RAN__Information__Request__Application__Container__SI3__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reporting__Cell__Identifier().is_bound()) reporting__Cell__Identifier().set_implicit_omit();
}

void RAN__Information__Request__Application__Container__SI3__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_reporting__Cell__Identifier.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
}
}

void RAN__Information__Request__Application__Container__SI3__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_reporting__Cell__Identifier.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RAN__Information__Request__Application__Container__SI3__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC.");
}
}

void RAN__Information__Request__Application__Container__SI3__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RAN__Information__Request__Application__Container__SI3__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reporting__Cell__Identifier().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_Cell_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__Cell__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RAN__Information__Request__Application__Container__SI3__GTPC_template* precondition = new RAN__Information__Request__Application__Container__SI3__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    RAN__Information__Request__Application__Container__SI3__GTPC_template* implied_template = new RAN__Information__Request__Application__Container__SI3__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RAN__Information__Request__Application__Container__SI3__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void RAN__Information__Request__Application__Container__SI3__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC");
single_value->field_reporting__Cell__Identifier.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_SI3_GTPC");
}

boolean RAN__Information__Request__Application__Container__SI3__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RAN__Information__Request__Application__Container__SI3__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RAN__Information__Request__Application__Container__MBMS__GTPC::RAN__Information__Request__Application__Container__MBMS__GTPC()
{
}

RAN__Information__Request__Application__Container__MBMS__GTPC::RAN__Information__Request__Application__Container__MBMS__GTPC(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a__GTPC& par_lengthIndicator,
    const Cell__Identifier__V__GTPC& par_reporting__Cell__Identifier)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_reporting__Cell__Identifier(par_reporting__Cell__Identifier)
{
}

RAN__Information__Request__Application__Container__MBMS__GTPC::RAN__Information__Request__Application__Container__MBMS__GTPC(const RAN__Information__Request__Application__Container__MBMS__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.reporting__Cell__Identifier().is_bound()) field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
else field_reporting__Cell__Identifier.clean_up();
}

void RAN__Information__Request__Application__Container__MBMS__GTPC::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_reporting__Cell__Identifier.clean_up();
}

const TTCN_Typedescriptor_t* RAN__Information__Request__Application__Container__MBMS__GTPC::get_descriptor() const { return &RAN__Information__Request__Application__Container__MBMS__GTPC_descr_; }
RAN__Information__Request__Application__Container__MBMS__GTPC& RAN__Information__Request__Application__Container__MBMS__GTPC::operator=(const RAN__Information__Request__Application__Container__MBMS__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.reporting__Cell__Identifier().is_bound()) field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
  else field_reporting__Cell__Identifier.clean_up();
}
return *this;
}

boolean RAN__Information__Request__Application__Container__MBMS__GTPC::operator==(const RAN__Information__Request__Application__Container__MBMS__GTPC& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_reporting__Cell__Identifier==other_value.field_reporting__Cell__Identifier;
}

boolean RAN__Information__Request__Application__Container__MBMS__GTPC::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_reporting__Cell__Identifier.is_bound());
}
boolean RAN__Information__Request__Application__Container__MBMS__GTPC::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_reporting__Cell__Identifier.is_value();
}
void RAN__Information__Request__Application__Container__MBMS__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
field_reporting__Cell__Identifier.log();
TTCN_Logger::log_event_str(" }");
}

void RAN__Information__Request__Application__Container__MBMS__GTPC::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reporting__Cell__Identifier().is_bound()) reporting__Cell__Identifier().set_implicit_omit();
}

void RAN__Information__Request__Application__Container__MBMS__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reporting__Cell__Identifier().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_Cell_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__Cell__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC");
  }
}

void RAN__Information__Request__Application__Container__MBMS__GTPC::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_reporting__Cell__Identifier.encode_text(text_buf);
}

void RAN__Information__Request__Application__Container__MBMS__GTPC::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_reporting__Cell__Identifier.decode_text(text_buf);
}

void RAN__Information__Request__Application__Container__MBMS__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RAN__Information__Request__Application__Container__MBMS__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RAN__Information__Request__Application__Container__MBMS__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RAN__Information__Request__Application__Container__MBMS__GTPC_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(RAN__Information__Request__Application__Container__MBMS__GTPC_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_3) selected_field = 0;
  else if (field_ext ==  bs_24) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RAN__Information__Request__Application__Container__MBMS__GTPC_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(RAN__Information__Request__Application__Container__MBMS__GTPC_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a__GTPC_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a__GTPC::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a__GTPC_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, Cell__Identifier__V__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_reporting__Cell__Identifier.RAW_decode(Cell__Identifier__V__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RAN__Information__Request__Application__Container__MBMS__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RAN__Information__Request__Application__Container__MBMS__GTPC_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RAN__Information__Request__Application__Container__MBMS__GTPC_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, Cell__Identifier__V__GTPC_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(RAN__Information__Request__Application__Container__MBMS__GTPC_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(RAN__Information__Request__Application__Container__MBMS__GTPC_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_reporting__Cell__Identifier.RAW_encode(Cell__Identifier__V__GTPC_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1:
  if (field_ext !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(RAN__Information__Request__Application__Container__MBMS__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a__GTPC::ALT_length2:
  if (field_ext !=  bs_24) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_24.RAW_encode(RAN__Information__Request__Application__Container__MBMS__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  return myleaf.length = encoded_length;
}

struct RAN__Information__Request__Application__Container__MBMS__GTPC_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a__GTPC_template field_lengthIndicator;
Cell__Identifier__V__GTPC_template field_reporting__Cell__Identifier;
};

void RAN__Information__Request__Application__Container__MBMS__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_reporting__Cell__Identifier = ANY_VALUE;
}
}
}

void RAN__Information__Request__Application__Container__MBMS__GTPC_template::copy_value(const RAN__Information__Request__Application__Container__MBMS__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.reporting__Cell__Identifier().is_bound()) {
  single_value->field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
} else {
  single_value->field_reporting__Cell__Identifier.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RAN__Information__Request__Application__Container__MBMS__GTPC_template::copy_template(const RAN__Information__Request__Application__Container__MBMS__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reporting__Cell__Identifier().get_selection()) {
single_value->field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
} else {
single_value->field_reporting__Cell__Identifier.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RAN__Information__Request__Application__Container__MBMS__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RAN__Information__Request__Application__Container__MBMS__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new RAN__Information__Request__Application__Container__MBMS__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
break;
}
set_selection(other_value);
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template::RAN__Information__Request__Application__Container__MBMS__GTPC_template()
{
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template::RAN__Information__Request__Application__Container__MBMS__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template::RAN__Information__Request__Application__Container__MBMS__GTPC_template(const RAN__Information__Request__Application__Container__MBMS__GTPC& other_value)
{
copy_value(other_value);
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template::RAN__Information__Request__Application__Container__MBMS__GTPC_template(const OPTIONAL<RAN__Information__Request__Application__Container__MBMS__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__Application__Container__MBMS__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC from an unbound optional field.");
}
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template::RAN__Information__Request__Application__Container__MBMS__GTPC_template(RAN__Information__Request__Application__Container__MBMS__GTPC_template* p_precondition, RAN__Information__Request__Application__Container__MBMS__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template::RAN__Information__Request__Application__Container__MBMS__GTPC_template(Dynamic_Match_Interface<RAN__Information__Request__Application__Container__MBMS__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RAN__Information__Request__Application__Container__MBMS__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template::RAN__Information__Request__Application__Container__MBMS__GTPC_template(const RAN__Information__Request__Application__Container__MBMS__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template::~RAN__Information__Request__Application__Container__MBMS__GTPC_template()
{
clean_up();
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template& RAN__Information__Request__Application__Container__MBMS__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template& RAN__Information__Request__Application__Container__MBMS__GTPC_template::operator=(const RAN__Information__Request__Application__Container__MBMS__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template& RAN__Information__Request__Application__Container__MBMS__GTPC_template::operator=(const OPTIONAL<RAN__Information__Request__Application__Container__MBMS__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__Application__Container__MBMS__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
}
return *this;
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template& RAN__Information__Request__Application__Container__MBMS__GTPC_template::operator=(const RAN__Information__Request__Application__Container__MBMS__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RAN__Information__Request__Application__Container__MBMS__GTPC_template::match(const RAN__Information__Request__Application__Container__MBMS__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.reporting__Cell__Identifier().is_bound()) return FALSE;
if(!single_value->field_reporting__Cell__Identifier.match(other_value.reporting__Cell__Identifier(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
}
return FALSE;
}

boolean RAN__Information__Request__Application__Container__MBMS__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_reporting__Cell__Identifier.is_bound();
}

boolean RAN__Information__Request__Application__Container__MBMS__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_reporting__Cell__Identifier.is_value();
}

void RAN__Information__Request__Application__Container__MBMS__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RAN__Information__Request__Application__Container__MBMS__GTPC RAN__Information__Request__Application__Container__MBMS__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
RAN__Information__Request__Application__Container__MBMS__GTPC ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_reporting__Cell__Identifier.is_bound()) {
ret_val.reporting__Cell__Identifier() = single_value->field_reporting__Cell__Identifier.valueof();
}
return ret_val;
}

void RAN__Information__Request__Application__Container__MBMS__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RAN__Information__Request__Application__Container__MBMS__GTPC_template[list_length];
}

RAN__Information__Request__Application__Container__MBMS__GTPC_template& RAN__Information__Request__Application__Container__MBMS__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RAN__Information__Request__Application__Container__MBMS__GTPC_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& RAN__Information__Request__Application__Container__MBMS__GTPC_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
return single_value->field_iEI;
}

BITSTRING_template& RAN__Information__Request__Application__Container__MBMS__GTPC_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& RAN__Information__Request__Application__Container__MBMS__GTPC_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
return single_value->field_ext;
}

LIN2__2a__GTPC_template& RAN__Information__Request__Application__Container__MBMS__GTPC_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a__GTPC_template& RAN__Information__Request__Application__Container__MBMS__GTPC_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
return single_value->field_lengthIndicator;
}

Cell__Identifier__V__GTPC_template& RAN__Information__Request__Application__Container__MBMS__GTPC_template::reporting__Cell__Identifier()
{
set_specific();
return single_value->field_reporting__Cell__Identifier;
}

const Cell__Identifier__V__GTPC_template& RAN__Information__Request__Application__Container__MBMS__GTPC_template::reporting__Cell__Identifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reporting_Cell_Identifier of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
return single_value->field_reporting__Cell__Identifier;
}

int RAN__Information__Request__Application__Container__MBMS__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
  }
  return 0;
}

void RAN__Information__Request__Application__Container__MBMS__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
single_value->field_reporting__Cell__Identifier.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RAN__Information__Request__Application__Container__MBMS__GTPC_template::log_match(const RAN__Information__Request__Application__Container__MBMS__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reporting__Cell__Identifier.match(match_value.reporting__Cell__Identifier(), legacy)){
TTCN_Logger::log_logmatch_info(".reporting_Cell_Identifier");
single_value->field_reporting__Cell__Identifier.log_match(match_value.reporting__Cell__Identifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
single_value->field_reporting__Cell__Identifier.log_match(match_value.reporting__Cell__Identifier(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RAN__Information__Request__Application__Container__MBMS__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reporting__Cell__Identifier().is_bound()) reporting__Cell__Identifier().set_implicit_omit();
}

void RAN__Information__Request__Application__Container__MBMS__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_reporting__Cell__Identifier.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
}
}

void RAN__Information__Request__Application__Container__MBMS__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_reporting__Cell__Identifier.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RAN__Information__Request__Application__Container__MBMS__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC.");
}
}

void RAN__Information__Request__Application__Container__MBMS__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RAN__Information__Request__Application__Container__MBMS__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reporting__Cell__Identifier().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_Cell_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__Cell__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RAN__Information__Request__Application__Container__MBMS__GTPC_template* precondition = new RAN__Information__Request__Application__Container__MBMS__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    RAN__Information__Request__Application__Container__MBMS__GTPC_template* implied_template = new RAN__Information__Request__Application__Container__MBMS__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RAN__Information__Request__Application__Container__MBMS__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void RAN__Information__Request__Application__Container__MBMS__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC");
single_value->field_reporting__Cell__Identifier.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_MBMS_GTPC");
}

boolean RAN__Information__Request__Application__Container__MBMS__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RAN__Information__Request__Application__Container__MBMS__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RAN__Information__Request__Application__Container__SON__GTPC::RAN__Information__Request__Application__Container__SON__GTPC()
{
}

RAN__Information__Request__Application__Container__SON__GTPC::RAN__Information__Request__Application__Container__SON__GTPC(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a__GTPC& par_lengthIndicator,
    const Cell__Identifier__V__GTPC& par_reporting__Cell__Identifier,
    const OCTETSTRING& par_sON__TransferRequestContainer)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_reporting__Cell__Identifier(par_reporting__Cell__Identifier),
  field_sON__TransferRequestContainer(par_sON__TransferRequestContainer)
{
}

RAN__Information__Request__Application__Container__SON__GTPC::RAN__Information__Request__Application__Container__SON__GTPC(const RAN__Information__Request__Application__Container__SON__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.reporting__Cell__Identifier().is_bound()) field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
else field_reporting__Cell__Identifier.clean_up();
if (other_value.sON__TransferRequestContainer().is_bound()) field_sON__TransferRequestContainer = other_value.sON__TransferRequestContainer();
else field_sON__TransferRequestContainer.clean_up();
}

void RAN__Information__Request__Application__Container__SON__GTPC::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_reporting__Cell__Identifier.clean_up();
field_sON__TransferRequestContainer.clean_up();
}

const TTCN_Typedescriptor_t* RAN__Information__Request__Application__Container__SON__GTPC::get_descriptor() const { return &RAN__Information__Request__Application__Container__SON__GTPC_descr_; }
RAN__Information__Request__Application__Container__SON__GTPC& RAN__Information__Request__Application__Container__SON__GTPC::operator=(const RAN__Information__Request__Application__Container__SON__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.reporting__Cell__Identifier().is_bound()) field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
  else field_reporting__Cell__Identifier.clean_up();
  if (other_value.sON__TransferRequestContainer().is_bound()) field_sON__TransferRequestContainer = other_value.sON__TransferRequestContainer();
  else field_sON__TransferRequestContainer.clean_up();
}
return *this;
}

boolean RAN__Information__Request__Application__Container__SON__GTPC::operator==(const RAN__Information__Request__Application__Container__SON__GTPC& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_reporting__Cell__Identifier==other_value.field_reporting__Cell__Identifier
  && field_sON__TransferRequestContainer==other_value.field_sON__TransferRequestContainer;
}

boolean RAN__Information__Request__Application__Container__SON__GTPC::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_reporting__Cell__Identifier.is_bound())
  || (field_sON__TransferRequestContainer.is_bound());
}
boolean RAN__Information__Request__Application__Container__SON__GTPC::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_reporting__Cell__Identifier.is_value()
  && field_sON__TransferRequestContainer.is_value();
}
void RAN__Information__Request__Application__Container__SON__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
field_reporting__Cell__Identifier.log();
TTCN_Logger::log_event_str(", sON_TransferRequestContainer := ");
field_sON__TransferRequestContainer.log();
TTCN_Logger::log_event_str(" }");
}

void RAN__Information__Request__Application__Container__SON__GTPC::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reporting__Cell__Identifier().is_bound()) reporting__Cell__Identifier().set_implicit_omit();
if (sON__TransferRequestContainer().is_bound()) sON__TransferRequestContainer().set_implicit_omit();
}

void RAN__Information__Request__Application__Container__SON__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reporting__Cell__Identifier().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) sON__TransferRequestContainer().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_Cell_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__Cell__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sON_TransferRequestContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sON__TransferRequestContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC");
  }
}

void RAN__Information__Request__Application__Container__SON__GTPC::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_reporting__Cell__Identifier.encode_text(text_buf);
field_sON__TransferRequestContainer.encode_text(text_buf);
}

void RAN__Information__Request__Application__Container__SON__GTPC::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_reporting__Cell__Identifier.decode_text(text_buf);
field_sON__TransferRequestContainer.decode_text(text_buf);
}

void RAN__Information__Request__Application__Container__SON__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RAN__Information__Request__Application__Container__SON__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RAN__Information__Request__Application__Container__SON__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RAN__Information__Request__Application__Container__SON__GTPC_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(RAN__Information__Request__Application__Container__SON__GTPC_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_3) selected_field = 0;
  else if (field_ext ==  bs_24) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RAN__Information__Request__Application__Container__SON__GTPC_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(RAN__Information__Request__Application__Container__SON__GTPC_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a__GTPC_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a__GTPC::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a__GTPC_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, Cell__Identifier__V__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_reporting__Cell__Identifier.RAW_decode(Cell__Identifier__V__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_sON__TransferRequestContainer.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RAN__Information__Request__Application__Container__SON__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RAN__Information__Request__Application__Container__SON__GTPC_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RAN__Information__Request__Application__Container__SON__GTPC_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, Cell__Identifier__V__GTPC_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, OCTETSTRING_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(RAN__Information__Request__Application__Container__SON__GTPC_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(RAN__Information__Request__Application__Container__SON__GTPC_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_reporting__Cell__Identifier.RAW_encode(Cell__Identifier__V__GTPC_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_sON__TransferRequestContainer.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[4]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1:
  if (field_ext !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(RAN__Information__Request__Application__Container__SON__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a__GTPC::ALT_length2:
  if (field_ext !=  bs_24) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_24.RAW_encode(RAN__Information__Request__Application__Container__SON__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  return myleaf.length = encoded_length;
}

struct RAN__Information__Request__Application__Container__SON__GTPC_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a__GTPC_template field_lengthIndicator;
Cell__Identifier__V__GTPC_template field_reporting__Cell__Identifier;
OCTETSTRING_template field_sON__TransferRequestContainer;
};

void RAN__Information__Request__Application__Container__SON__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_reporting__Cell__Identifier = ANY_VALUE;
single_value->field_sON__TransferRequestContainer = ANY_VALUE;
}
}
}

void RAN__Information__Request__Application__Container__SON__GTPC_template::copy_value(const RAN__Information__Request__Application__Container__SON__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.reporting__Cell__Identifier().is_bound()) {
  single_value->field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
} else {
  single_value->field_reporting__Cell__Identifier.clean_up();
}
if (other_value.sON__TransferRequestContainer().is_bound()) {
  single_value->field_sON__TransferRequestContainer = other_value.sON__TransferRequestContainer();
} else {
  single_value->field_sON__TransferRequestContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RAN__Information__Request__Application__Container__SON__GTPC_template::copy_template(const RAN__Information__Request__Application__Container__SON__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reporting__Cell__Identifier().get_selection()) {
single_value->field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
} else {
single_value->field_reporting__Cell__Identifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sON__TransferRequestContainer().get_selection()) {
single_value->field_sON__TransferRequestContainer = other_value.sON__TransferRequestContainer();
} else {
single_value->field_sON__TransferRequestContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RAN__Information__Request__Application__Container__SON__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RAN__Information__Request__Application__Container__SON__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new RAN__Information__Request__Application__Container__SON__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
break;
}
set_selection(other_value);
}

RAN__Information__Request__Application__Container__SON__GTPC_template::RAN__Information__Request__Application__Container__SON__GTPC_template()
{
}

RAN__Information__Request__Application__Container__SON__GTPC_template::RAN__Information__Request__Application__Container__SON__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RAN__Information__Request__Application__Container__SON__GTPC_template::RAN__Information__Request__Application__Container__SON__GTPC_template(const RAN__Information__Request__Application__Container__SON__GTPC& other_value)
{
copy_value(other_value);
}

RAN__Information__Request__Application__Container__SON__GTPC_template::RAN__Information__Request__Application__Container__SON__GTPC_template(const OPTIONAL<RAN__Information__Request__Application__Container__SON__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__Application__Container__SON__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC from an unbound optional field.");
}
}

RAN__Information__Request__Application__Container__SON__GTPC_template::RAN__Information__Request__Application__Container__SON__GTPC_template(RAN__Information__Request__Application__Container__SON__GTPC_template* p_precondition, RAN__Information__Request__Application__Container__SON__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RAN__Information__Request__Application__Container__SON__GTPC_template::RAN__Information__Request__Application__Container__SON__GTPC_template(Dynamic_Match_Interface<RAN__Information__Request__Application__Container__SON__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RAN__Information__Request__Application__Container__SON__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RAN__Information__Request__Application__Container__SON__GTPC_template::RAN__Information__Request__Application__Container__SON__GTPC_template(const RAN__Information__Request__Application__Container__SON__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RAN__Information__Request__Application__Container__SON__GTPC_template::~RAN__Information__Request__Application__Container__SON__GTPC_template()
{
clean_up();
}

RAN__Information__Request__Application__Container__SON__GTPC_template& RAN__Information__Request__Application__Container__SON__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RAN__Information__Request__Application__Container__SON__GTPC_template& RAN__Information__Request__Application__Container__SON__GTPC_template::operator=(const RAN__Information__Request__Application__Container__SON__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RAN__Information__Request__Application__Container__SON__GTPC_template& RAN__Information__Request__Application__Container__SON__GTPC_template::operator=(const OPTIONAL<RAN__Information__Request__Application__Container__SON__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__Application__Container__SON__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
}
return *this;
}

RAN__Information__Request__Application__Container__SON__GTPC_template& RAN__Information__Request__Application__Container__SON__GTPC_template::operator=(const RAN__Information__Request__Application__Container__SON__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RAN__Information__Request__Application__Container__SON__GTPC_template::match(const RAN__Information__Request__Application__Container__SON__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.reporting__Cell__Identifier().is_bound()) return FALSE;
if(!single_value->field_reporting__Cell__Identifier.match(other_value.reporting__Cell__Identifier(), legacy))return FALSE;
if(!other_value.sON__TransferRequestContainer().is_bound()) return FALSE;
if(!single_value->field_sON__TransferRequestContainer.match(other_value.sON__TransferRequestContainer(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
}
return FALSE;
}

boolean RAN__Information__Request__Application__Container__SON__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_reporting__Cell__Identifier.is_bound()
 || single_value->field_sON__TransferRequestContainer.is_bound();
}

boolean RAN__Information__Request__Application__Container__SON__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_reporting__Cell__Identifier.is_value()
 && single_value->field_sON__TransferRequestContainer.is_value();
}

void RAN__Information__Request__Application__Container__SON__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RAN__Information__Request__Application__Container__SON__GTPC RAN__Information__Request__Application__Container__SON__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
RAN__Information__Request__Application__Container__SON__GTPC ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_reporting__Cell__Identifier.is_bound()) {
ret_val.reporting__Cell__Identifier() = single_value->field_reporting__Cell__Identifier.valueof();
}
if (single_value->field_sON__TransferRequestContainer.is_bound()) {
ret_val.sON__TransferRequestContainer() = single_value->field_sON__TransferRequestContainer.valueof();
}
return ret_val;
}

void RAN__Information__Request__Application__Container__SON__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RAN__Information__Request__Application__Container__SON__GTPC_template[list_length];
}

RAN__Information__Request__Application__Container__SON__GTPC_template& RAN__Information__Request__Application__Container__SON__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RAN__Information__Request__Application__Container__SON__GTPC_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& RAN__Information__Request__Application__Container__SON__GTPC_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
return single_value->field_iEI;
}

BITSTRING_template& RAN__Information__Request__Application__Container__SON__GTPC_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& RAN__Information__Request__Application__Container__SON__GTPC_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
return single_value->field_ext;
}

LIN2__2a__GTPC_template& RAN__Information__Request__Application__Container__SON__GTPC_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a__GTPC_template& RAN__Information__Request__Application__Container__SON__GTPC_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
return single_value->field_lengthIndicator;
}

Cell__Identifier__V__GTPC_template& RAN__Information__Request__Application__Container__SON__GTPC_template::reporting__Cell__Identifier()
{
set_specific();
return single_value->field_reporting__Cell__Identifier;
}

const Cell__Identifier__V__GTPC_template& RAN__Information__Request__Application__Container__SON__GTPC_template::reporting__Cell__Identifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reporting_Cell_Identifier of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
return single_value->field_reporting__Cell__Identifier;
}

OCTETSTRING_template& RAN__Information__Request__Application__Container__SON__GTPC_template::sON__TransferRequestContainer()
{
set_specific();
return single_value->field_sON__TransferRequestContainer;
}

const OCTETSTRING_template& RAN__Information__Request__Application__Container__SON__GTPC_template::sON__TransferRequestContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sON_TransferRequestContainer of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
return single_value->field_sON__TransferRequestContainer;
}

int RAN__Information__Request__Application__Container__SON__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
  }
  return 0;
}

void RAN__Information__Request__Application__Container__SON__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
single_value->field_reporting__Cell__Identifier.log();
TTCN_Logger::log_event_str(", sON_TransferRequestContainer := ");
single_value->field_sON__TransferRequestContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RAN__Information__Request__Application__Container__SON__GTPC_template::log_match(const RAN__Information__Request__Application__Container__SON__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reporting__Cell__Identifier.match(match_value.reporting__Cell__Identifier(), legacy)){
TTCN_Logger::log_logmatch_info(".reporting_Cell_Identifier");
single_value->field_reporting__Cell__Identifier.log_match(match_value.reporting__Cell__Identifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sON__TransferRequestContainer.match(match_value.sON__TransferRequestContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".sON_TransferRequestContainer");
single_value->field_sON__TransferRequestContainer.log_match(match_value.sON__TransferRequestContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
single_value->field_reporting__Cell__Identifier.log_match(match_value.reporting__Cell__Identifier(), legacy);
TTCN_Logger::log_event_str(", sON_TransferRequestContainer := ");
single_value->field_sON__TransferRequestContainer.log_match(match_value.sON__TransferRequestContainer(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RAN__Information__Request__Application__Container__SON__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reporting__Cell__Identifier().is_bound()) reporting__Cell__Identifier().set_implicit_omit();
if (sON__TransferRequestContainer().is_bound()) sON__TransferRequestContainer().set_implicit_omit();
}

void RAN__Information__Request__Application__Container__SON__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_reporting__Cell__Identifier.encode_text(text_buf);
single_value->field_sON__TransferRequestContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
}
}

void RAN__Information__Request__Application__Container__SON__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_reporting__Cell__Identifier.decode_text(text_buf);
single_value->field_sON__TransferRequestContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RAN__Information__Request__Application__Container__SON__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC.");
}
}

void RAN__Information__Request__Application__Container__SON__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RAN__Information__Request__Application__Container__SON__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reporting__Cell__Identifier().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) sON__TransferRequestContainer().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_Cell_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__Cell__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sON_TransferRequestContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sON__TransferRequestContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RAN__Information__Request__Application__Container__SON__GTPC_template* precondition = new RAN__Information__Request__Application__Container__SON__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    RAN__Information__Request__Application__Container__SON__GTPC_template* implied_template = new RAN__Information__Request__Application__Container__SON__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RAN__Information__Request__Application__Container__SON__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void RAN__Information__Request__Application__Container__SON__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC");
single_value->field_reporting__Cell__Identifier.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC");
single_value->field_sON__TransferRequestContainer.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_SON_GTPC");
}

boolean RAN__Information__Request__Application__Container__SON__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RAN__Information__Request__Application__Container__SON__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC::RAN__Information__Request__Application__Container__UTRA__SI__GTPC()
{
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC::RAN__Information__Request__Application__Container__UTRA__SI__GTPC(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a__GTPC& par_lengthIndicator,
    const Cell__Identifier__V__GTPC& par_reporting__Cell__Identifier)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_reporting__Cell__Identifier(par_reporting__Cell__Identifier)
{
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC::RAN__Information__Request__Application__Container__UTRA__SI__GTPC(const RAN__Information__Request__Application__Container__UTRA__SI__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.reporting__Cell__Identifier().is_bound()) field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
else field_reporting__Cell__Identifier.clean_up();
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_reporting__Cell__Identifier.clean_up();
}

const TTCN_Typedescriptor_t* RAN__Information__Request__Application__Container__UTRA__SI__GTPC::get_descriptor() const { return &RAN__Information__Request__Application__Container__UTRA__SI__GTPC_descr_; }
RAN__Information__Request__Application__Container__UTRA__SI__GTPC& RAN__Information__Request__Application__Container__UTRA__SI__GTPC::operator=(const RAN__Information__Request__Application__Container__UTRA__SI__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.reporting__Cell__Identifier().is_bound()) field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
  else field_reporting__Cell__Identifier.clean_up();
}
return *this;
}

boolean RAN__Information__Request__Application__Container__UTRA__SI__GTPC::operator==(const RAN__Information__Request__Application__Container__UTRA__SI__GTPC& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_reporting__Cell__Identifier==other_value.field_reporting__Cell__Identifier;
}

boolean RAN__Information__Request__Application__Container__UTRA__SI__GTPC::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_reporting__Cell__Identifier.is_bound());
}
boolean RAN__Information__Request__Application__Container__UTRA__SI__GTPC::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_reporting__Cell__Identifier.is_value();
}
void RAN__Information__Request__Application__Container__UTRA__SI__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
field_reporting__Cell__Identifier.log();
TTCN_Logger::log_event_str(" }");
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reporting__Cell__Identifier().is_bound()) reporting__Cell__Identifier().set_implicit_omit();
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reporting__Cell__Identifier().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_Cell_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__Cell__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC");
  }
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_reporting__Cell__Identifier.encode_text(text_buf);
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_reporting__Cell__Identifier.decode_text(text_buf);
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RAN__Information__Request__Application__Container__UTRA__SI__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RAN__Information__Request__Application__Container__UTRA__SI__GTPC_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(RAN__Information__Request__Application__Container__UTRA__SI__GTPC_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_3) selected_field = 0;
  else if (field_ext ==  bs_24) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RAN__Information__Request__Application__Container__UTRA__SI__GTPC_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(RAN__Information__Request__Application__Container__UTRA__SI__GTPC_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a__GTPC_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a__GTPC::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a__GTPC_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, Cell__Identifier__V__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_reporting__Cell__Identifier.RAW_decode(Cell__Identifier__V__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RAN__Information__Request__Application__Container__UTRA__SI__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RAN__Information__Request__Application__Container__UTRA__SI__GTPC_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RAN__Information__Request__Application__Container__UTRA__SI__GTPC_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, Cell__Identifier__V__GTPC_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(RAN__Information__Request__Application__Container__UTRA__SI__GTPC_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(RAN__Information__Request__Application__Container__UTRA__SI__GTPC_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_reporting__Cell__Identifier.RAW_encode(Cell__Identifier__V__GTPC_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1:
  if (field_ext !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(RAN__Information__Request__Application__Container__UTRA__SI__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a__GTPC::ALT_length2:
  if (field_ext !=  bs_24) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_24.RAW_encode(RAN__Information__Request__Application__Container__UTRA__SI__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  return myleaf.length = encoded_length;
}

struct RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a__GTPC_template field_lengthIndicator;
Cell__Identifier__V__GTPC_template field_reporting__Cell__Identifier;
};

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_reporting__Cell__Identifier = ANY_VALUE;
}
}
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::copy_value(const RAN__Information__Request__Application__Container__UTRA__SI__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.reporting__Cell__Identifier().is_bound()) {
  single_value->field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
} else {
  single_value->field_reporting__Cell__Identifier.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::copy_template(const RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reporting__Cell__Identifier().get_selection()) {
single_value->field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
} else {
single_value->field_reporting__Cell__Identifier.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
break;
}
set_selection(other_value);
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template()
{
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template(const RAN__Information__Request__Application__Container__UTRA__SI__GTPC& other_value)
{
copy_value(other_value);
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template(const OPTIONAL<RAN__Information__Request__Application__Container__UTRA__SI__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__Application__Container__UTRA__SI__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC from an unbound optional field.");
}
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template(RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template* p_precondition, RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template(Dynamic_Match_Interface<RAN__Information__Request__Application__Container__UTRA__SI__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RAN__Information__Request__Application__Container__UTRA__SI__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template(const RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::~RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template()
{
clean_up();
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template& RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template& RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::operator=(const RAN__Information__Request__Application__Container__UTRA__SI__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template& RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::operator=(const OPTIONAL<RAN__Information__Request__Application__Container__UTRA__SI__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Request__Application__Container__UTRA__SI__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
}
return *this;
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template& RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::operator=(const RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::match(const RAN__Information__Request__Application__Container__UTRA__SI__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.reporting__Cell__Identifier().is_bound()) return FALSE;
if(!single_value->field_reporting__Cell__Identifier.match(other_value.reporting__Cell__Identifier(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
}
return FALSE;
}

boolean RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_reporting__Cell__Identifier.is_bound();
}

boolean RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_reporting__Cell__Identifier.is_value();
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
RAN__Information__Request__Application__Container__UTRA__SI__GTPC ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_reporting__Cell__Identifier.is_bound()) {
ret_val.reporting__Cell__Identifier() = single_value->field_reporting__Cell__Identifier.valueof();
}
return ret_val;
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template[list_length];
}

RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template& RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
return single_value->field_iEI;
}

BITSTRING_template& RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
return single_value->field_ext;
}

LIN2__2a__GTPC_template& RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a__GTPC_template& RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
return single_value->field_lengthIndicator;
}

Cell__Identifier__V__GTPC_template& RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::reporting__Cell__Identifier()
{
set_specific();
return single_value->field_reporting__Cell__Identifier;
}

const Cell__Identifier__V__GTPC_template& RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::reporting__Cell__Identifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reporting_Cell_Identifier of a non-specific template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
return single_value->field_reporting__Cell__Identifier;
}

int RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
  }
  return 0;
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
single_value->field_reporting__Cell__Identifier.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::log_match(const RAN__Information__Request__Application__Container__UTRA__SI__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reporting__Cell__Identifier.match(match_value.reporting__Cell__Identifier(), legacy)){
TTCN_Logger::log_logmatch_info(".reporting_Cell_Identifier");
single_value->field_reporting__Cell__Identifier.log_match(match_value.reporting__Cell__Identifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
single_value->field_reporting__Cell__Identifier.log_match(match_value.reporting__Cell__Identifier(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reporting__Cell__Identifier().is_bound()) reporting__Cell__Identifier().set_implicit_omit();
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_reporting__Cell__Identifier.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
}
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_reporting__Cell__Identifier.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC.");
}
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reporting__Cell__Identifier().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_Cell_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__Cell__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template* precondition = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template* implied_template = new RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC");
single_value->field_reporting__Cell__Identifier.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.RAN_Information_Request_Application_Container_UTRA_SI_GTPC");
}

boolean RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RAN__Information__Request__Application__Container__UTRA__SI__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SON__TransferApplicationIdentity::SON__TransferApplicationIdentity()
{
}

SON__TransferApplicationIdentity::SON__TransferApplicationIdentity(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a__GTPC& par_lengthIndicator,
    const OCTETSTRING& par_sON__TransferApplicationIdentityValue)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_sON__TransferApplicationIdentityValue(par_sON__TransferApplicationIdentityValue)
{
}

SON__TransferApplicationIdentity::SON__TransferApplicationIdentity(const SON__TransferApplicationIdentity& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.SON_TransferApplicationIdentity.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.sON__TransferApplicationIdentityValue().is_bound()) field_sON__TransferApplicationIdentityValue = other_value.sON__TransferApplicationIdentityValue();
else field_sON__TransferApplicationIdentityValue.clean_up();
}

void SON__TransferApplicationIdentity::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_sON__TransferApplicationIdentityValue.clean_up();
}

const TTCN_Typedescriptor_t* SON__TransferApplicationIdentity::get_descriptor() const { return &SON__TransferApplicationIdentity_descr_; }
SON__TransferApplicationIdentity& SON__TransferApplicationIdentity::operator=(const SON__TransferApplicationIdentity& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.SON_TransferApplicationIdentity.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.sON__TransferApplicationIdentityValue().is_bound()) field_sON__TransferApplicationIdentityValue = other_value.sON__TransferApplicationIdentityValue();
  else field_sON__TransferApplicationIdentityValue.clean_up();
}
return *this;
}

boolean SON__TransferApplicationIdentity::operator==(const SON__TransferApplicationIdentity& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_sON__TransferApplicationIdentityValue==other_value.field_sON__TransferApplicationIdentityValue;
}

boolean SON__TransferApplicationIdentity::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_sON__TransferApplicationIdentityValue.is_bound());
}
boolean SON__TransferApplicationIdentity::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_sON__TransferApplicationIdentityValue.is_value();
}
void SON__TransferApplicationIdentity::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", sON_TransferApplicationIdentityValue := ");
field_sON__TransferApplicationIdentityValue.log();
TTCN_Logger::log_event_str(" }");
}

void SON__TransferApplicationIdentity::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (sON__TransferApplicationIdentityValue().is_bound()) sON__TransferApplicationIdentityValue().set_implicit_omit();
}

void SON__TransferApplicationIdentity::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @GTPC_Types.SON_TransferApplicationIdentity has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) sON__TransferApplicationIdentityValue().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sON_TransferApplicationIdentityValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sON__TransferApplicationIdentityValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.SON_TransferApplicationIdentity: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.SON_TransferApplicationIdentity");
  }
}

void SON__TransferApplicationIdentity::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_sON__TransferApplicationIdentityValue.encode_text(text_buf);
}

void SON__TransferApplicationIdentity::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_sON__TransferApplicationIdentityValue.decode_text(text_buf);
}

void SON__TransferApplicationIdentity::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SON__TransferApplicationIdentity::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SON__TransferApplicationIdentity::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, LIN2__2a__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(LIN2__2a__GTPC_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_sON__TransferApplicationIdentityValue.RAW_decode(OCTETSTRING_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SON__TransferApplicationIdentity::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, LIN2__2a__GTPC_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, OCTETSTRING_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(LIN2__2a__GTPC_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_sON__TransferApplicationIdentityValue.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct SON__TransferApplicationIdentity_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a__GTPC_template field_lengthIndicator;
OCTETSTRING_template field_sON__TransferApplicationIdentityValue;
};

void SON__TransferApplicationIdentity_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_sON__TransferApplicationIdentityValue = ANY_VALUE;
}
}
}

void SON__TransferApplicationIdentity_template::copy_value(const SON__TransferApplicationIdentity& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.sON__TransferApplicationIdentityValue().is_bound()) {
  single_value->field_sON__TransferApplicationIdentityValue = other_value.sON__TransferApplicationIdentityValue();
} else {
  single_value->field_sON__TransferApplicationIdentityValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SON__TransferApplicationIdentity_template::copy_template(const SON__TransferApplicationIdentity_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sON__TransferApplicationIdentityValue().get_selection()) {
single_value->field_sON__TransferApplicationIdentityValue = other_value.sON__TransferApplicationIdentityValue();
} else {
single_value->field_sON__TransferApplicationIdentityValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SON__TransferApplicationIdentity_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SON__TransferApplicationIdentity_template(*other_value.implication_.precondition);
implication_.implied_template = new SON__TransferApplicationIdentity_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.SON_TransferApplicationIdentity.");
break;
}
set_selection(other_value);
}

SON__TransferApplicationIdentity_template::SON__TransferApplicationIdentity_template()
{
}

SON__TransferApplicationIdentity_template::SON__TransferApplicationIdentity_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SON__TransferApplicationIdentity_template::SON__TransferApplicationIdentity_template(const SON__TransferApplicationIdentity& other_value)
{
copy_value(other_value);
}

SON__TransferApplicationIdentity_template::SON__TransferApplicationIdentity_template(const OPTIONAL<SON__TransferApplicationIdentity>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SON__TransferApplicationIdentity&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.SON_TransferApplicationIdentity from an unbound optional field.");
}
}

SON__TransferApplicationIdentity_template::SON__TransferApplicationIdentity_template(SON__TransferApplicationIdentity_template* p_precondition, SON__TransferApplicationIdentity_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SON__TransferApplicationIdentity_template::SON__TransferApplicationIdentity_template(Dynamic_Match_Interface<SON__TransferApplicationIdentity>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SON__TransferApplicationIdentity>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SON__TransferApplicationIdentity_template::SON__TransferApplicationIdentity_template(const SON__TransferApplicationIdentity_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SON__TransferApplicationIdentity_template::~SON__TransferApplicationIdentity_template()
{
clean_up();
}

SON__TransferApplicationIdentity_template& SON__TransferApplicationIdentity_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SON__TransferApplicationIdentity_template& SON__TransferApplicationIdentity_template::operator=(const SON__TransferApplicationIdentity& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SON__TransferApplicationIdentity_template& SON__TransferApplicationIdentity_template::operator=(const OPTIONAL<SON__TransferApplicationIdentity>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SON__TransferApplicationIdentity&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.SON_TransferApplicationIdentity.");
}
return *this;
}

SON__TransferApplicationIdentity_template& SON__TransferApplicationIdentity_template::operator=(const SON__TransferApplicationIdentity_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SON__TransferApplicationIdentity_template::match(const SON__TransferApplicationIdentity& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.sON__TransferApplicationIdentityValue().is_bound()) return FALSE;
if(!single_value->field_sON__TransferApplicationIdentityValue.match(other_value.sON__TransferApplicationIdentityValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.SON_TransferApplicationIdentity.");
}
return FALSE;
}

boolean SON__TransferApplicationIdentity_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_sON__TransferApplicationIdentityValue.is_bound();
}

boolean SON__TransferApplicationIdentity_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_sON__TransferApplicationIdentityValue.is_value();
}

void SON__TransferApplicationIdentity_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SON__TransferApplicationIdentity SON__TransferApplicationIdentity_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.SON_TransferApplicationIdentity.");
SON__TransferApplicationIdentity ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_sON__TransferApplicationIdentityValue.is_bound()) {
ret_val.sON__TransferApplicationIdentityValue() = single_value->field_sON__TransferApplicationIdentityValue.valueof();
}
return ret_val;
}

void SON__TransferApplicationIdentity_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.SON_TransferApplicationIdentity.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SON__TransferApplicationIdentity_template[list_length];
}

SON__TransferApplicationIdentity_template& SON__TransferApplicationIdentity_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.SON_TransferApplicationIdentity.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.SON_TransferApplicationIdentity.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& SON__TransferApplicationIdentity_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& SON__TransferApplicationIdentity_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @GTPC_Types.SON_TransferApplicationIdentity.");
return single_value->field_iEI;
}

BITSTRING_template& SON__TransferApplicationIdentity_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& SON__TransferApplicationIdentity_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @GTPC_Types.SON_TransferApplicationIdentity.");
return single_value->field_ext;
}

LIN2__2a__GTPC_template& SON__TransferApplicationIdentity_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a__GTPC_template& SON__TransferApplicationIdentity_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @GTPC_Types.SON_TransferApplicationIdentity.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& SON__TransferApplicationIdentity_template::sON__TransferApplicationIdentityValue()
{
set_specific();
return single_value->field_sON__TransferApplicationIdentityValue;
}

const OCTETSTRING_template& SON__TransferApplicationIdentity_template::sON__TransferApplicationIdentityValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sON_TransferApplicationIdentityValue of a non-specific template of type @GTPC_Types.SON_TransferApplicationIdentity.");
return single_value->field_sON__TransferApplicationIdentityValue;
}

int SON__TransferApplicationIdentity_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SON_TransferApplicationIdentity which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.SON_TransferApplicationIdentity containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SON_TransferApplicationIdentity containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SON_TransferApplicationIdentity containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SON_TransferApplicationIdentity containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SON_TransferApplicationIdentity containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SON_TransferApplicationIdentity containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SON_TransferApplicationIdentity containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SON_TransferApplicationIdentity containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.SON_TransferApplicationIdentity.");
  }
  return 0;
}

void SON__TransferApplicationIdentity_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", sON_TransferApplicationIdentityValue := ");
single_value->field_sON__TransferApplicationIdentityValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SON__TransferApplicationIdentity_template::log_match(const SON__TransferApplicationIdentity& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sON__TransferApplicationIdentityValue.match(match_value.sON__TransferApplicationIdentityValue(), legacy)){
TTCN_Logger::log_logmatch_info(".sON_TransferApplicationIdentityValue");
single_value->field_sON__TransferApplicationIdentityValue.log_match(match_value.sON__TransferApplicationIdentityValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", sON_TransferApplicationIdentityValue := ");
single_value->field_sON__TransferApplicationIdentityValue.log_match(match_value.sON__TransferApplicationIdentityValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SON__TransferApplicationIdentity_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (sON__TransferApplicationIdentityValue().is_bound()) sON__TransferApplicationIdentityValue().set_implicit_omit();
}

void SON__TransferApplicationIdentity_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_sON__TransferApplicationIdentityValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.SON_TransferApplicationIdentity.");
}
}

void SON__TransferApplicationIdentity_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_sON__TransferApplicationIdentityValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SON__TransferApplicationIdentity_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.SON_TransferApplicationIdentity.");
}
}

void SON__TransferApplicationIdentity_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SON__TransferApplicationIdentity_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @GTPC_Types.SON_TransferApplicationIdentity has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) sON__TransferApplicationIdentityValue().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sON_TransferApplicationIdentityValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sON__TransferApplicationIdentityValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.SON_TransferApplicationIdentity: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SON__TransferApplicationIdentity_template* precondition = new SON__TransferApplicationIdentity_template;
    precondition->set_param(*param.get_elem(0));
    SON__TransferApplicationIdentity_template* implied_template = new SON__TransferApplicationIdentity_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SON__TransferApplicationIdentity_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.SON_TransferApplicationIdentity");
  }
  is_ifpresent = param.get_ifpresent();
}

void SON__TransferApplicationIdentity_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.SON_TransferApplicationIdentity");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.SON_TransferApplicationIdentity");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.SON_TransferApplicationIdentity");
single_value->field_sON__TransferApplicationIdentityValue.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.SON_TransferApplicationIdentity");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.SON_TransferApplicationIdentity");
}

boolean SON__TransferApplicationIdentity_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SON__TransferApplicationIdentity_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RAN__Information__RIM__Container__GTPC::RAN__Information__RIM__Container__GTPC()
{
}

RAN__Information__RIM__Container__GTPC::RAN__Information__RIM__Container__GTPC(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a__GTPC& par_lengthIndicator,
    const RIM__Application__Identity__GTPC& par_rIM__Application__Identity,
    const RIM__Sequence__Number__GTPC& par_rIM__Sequence__Number,
    const RIM__PDU__Indications__GTPC& par_rIM__PDU__Indications,
    const OPTIONAL< RIM__Protocol__Version__Number__GTPC >& par_rIM__Protocol__Version__Number,
    const OPTIONAL< ApplContainer__or__ApplErrContainer__GTPC >& par_applContainer__or__ApplErrContainer,
    const OPTIONAL< SON__TransferApplicationIdentity >& par_sON__TransferApplicationIdentity)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_rIM__Application__Identity(par_rIM__Application__Identity),
  field_rIM__Sequence__Number(par_rIM__Sequence__Number),
  field_rIM__PDU__Indications(par_rIM__PDU__Indications),
  field_rIM__Protocol__Version__Number(par_rIM__Protocol__Version__Number),
  field_applContainer__or__ApplErrContainer(par_applContainer__or__ApplErrContainer),
  field_sON__TransferApplicationIdentity(par_sON__TransferApplicationIdentity)
{
}

RAN__Information__RIM__Container__GTPC::RAN__Information__RIM__Container__GTPC(const RAN__Information__RIM__Container__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.rIM__Application__Identity().is_bound()) field_rIM__Application__Identity = other_value.rIM__Application__Identity();
else field_rIM__Application__Identity.clean_up();
if (other_value.rIM__Sequence__Number().is_bound()) field_rIM__Sequence__Number = other_value.rIM__Sequence__Number();
else field_rIM__Sequence__Number.clean_up();
if (other_value.rIM__PDU__Indications().is_bound()) field_rIM__PDU__Indications = other_value.rIM__PDU__Indications();
else field_rIM__PDU__Indications.clean_up();
if (other_value.rIM__Protocol__Version__Number().is_bound()) field_rIM__Protocol__Version__Number = other_value.rIM__Protocol__Version__Number();
else field_rIM__Protocol__Version__Number.clean_up();
if (other_value.applContainer__or__ApplErrContainer().is_bound()) field_applContainer__or__ApplErrContainer = other_value.applContainer__or__ApplErrContainer();
else field_applContainer__or__ApplErrContainer.clean_up();
if (other_value.sON__TransferApplicationIdentity().is_bound()) field_sON__TransferApplicationIdentity = other_value.sON__TransferApplicationIdentity();
else field_sON__TransferApplicationIdentity.clean_up();
}

void RAN__Information__RIM__Container__GTPC::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_rIM__Application__Identity.clean_up();
field_rIM__Sequence__Number.clean_up();
field_rIM__PDU__Indications.clean_up();
field_rIM__Protocol__Version__Number.clean_up();
field_applContainer__or__ApplErrContainer.clean_up();
field_sON__TransferApplicationIdentity.clean_up();
}

const TTCN_Typedescriptor_t* RAN__Information__RIM__Container__GTPC::get_descriptor() const { return &RAN__Information__RIM__Container__GTPC_descr_; }
RAN__Information__RIM__Container__GTPC& RAN__Information__RIM__Container__GTPC::operator=(const RAN__Information__RIM__Container__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.rIM__Application__Identity().is_bound()) field_rIM__Application__Identity = other_value.rIM__Application__Identity();
  else field_rIM__Application__Identity.clean_up();
  if (other_value.rIM__Sequence__Number().is_bound()) field_rIM__Sequence__Number = other_value.rIM__Sequence__Number();
  else field_rIM__Sequence__Number.clean_up();
  if (other_value.rIM__PDU__Indications().is_bound()) field_rIM__PDU__Indications = other_value.rIM__PDU__Indications();
  else field_rIM__PDU__Indications.clean_up();
  if (other_value.rIM__Protocol__Version__Number().is_bound()) field_rIM__Protocol__Version__Number = other_value.rIM__Protocol__Version__Number();
  else field_rIM__Protocol__Version__Number.clean_up();
  if (other_value.applContainer__or__ApplErrContainer().is_bound()) field_applContainer__or__ApplErrContainer = other_value.applContainer__or__ApplErrContainer();
  else field_applContainer__or__ApplErrContainer.clean_up();
  if (other_value.sON__TransferApplicationIdentity().is_bound()) field_sON__TransferApplicationIdentity = other_value.sON__TransferApplicationIdentity();
  else field_sON__TransferApplicationIdentity.clean_up();
}
return *this;
}

boolean RAN__Information__RIM__Container__GTPC::operator==(const RAN__Information__RIM__Container__GTPC& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_rIM__Application__Identity==other_value.field_rIM__Application__Identity
  && field_rIM__Sequence__Number==other_value.field_rIM__Sequence__Number
  && field_rIM__PDU__Indications==other_value.field_rIM__PDU__Indications
  && field_rIM__Protocol__Version__Number==other_value.field_rIM__Protocol__Version__Number
  && field_applContainer__or__ApplErrContainer==other_value.field_applContainer__or__ApplErrContainer
  && field_sON__TransferApplicationIdentity==other_value.field_sON__TransferApplicationIdentity;
}

boolean RAN__Information__RIM__Container__GTPC::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_rIM__Application__Identity.is_bound())
  || (field_rIM__Sequence__Number.is_bound())
  || (field_rIM__PDU__Indications.is_bound())
  || (OPTIONAL_OMIT == field_rIM__Protocol__Version__Number.get_selection() || field_rIM__Protocol__Version__Number.is_bound())
  || (OPTIONAL_OMIT == field_applContainer__or__ApplErrContainer.get_selection() || field_applContainer__or__ApplErrContainer.is_bound())
  || (OPTIONAL_OMIT == field_sON__TransferApplicationIdentity.get_selection() || field_sON__TransferApplicationIdentity.is_bound());
}
boolean RAN__Information__RIM__Container__GTPC::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_rIM__Application__Identity.is_value()
  && field_rIM__Sequence__Number.is_value()
  && field_rIM__PDU__Indications.is_value()
  && (OPTIONAL_OMIT == field_rIM__Protocol__Version__Number.get_selection() || field_rIM__Protocol__Version__Number.is_value())
  && (OPTIONAL_OMIT == field_applContainer__or__ApplErrContainer.get_selection() || field_applContainer__or__ApplErrContainer.is_value())
  && (OPTIONAL_OMIT == field_sON__TransferApplicationIdentity.get_selection() || field_sON__TransferApplicationIdentity.is_value());
}
int RAN__Information__RIM__Container__GTPC::size_of() const
{
  int ret_val = 6;
  if (field_rIM__Protocol__Version__Number.ispresent()) ret_val++;
  if (field_applContainer__or__ApplErrContainer.ispresent()) ret_val++;
  if (field_sON__TransferApplicationIdentity.ispresent()) ret_val++;
  return ret_val;
}

void RAN__Information__RIM__Container__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", rIM_Application_Identity := ");
field_rIM__Application__Identity.log();
TTCN_Logger::log_event_str(", rIM_Sequence_Number := ");
field_rIM__Sequence__Number.log();
TTCN_Logger::log_event_str(", rIM_PDU_Indications := ");
field_rIM__PDU__Indications.log();
TTCN_Logger::log_event_str(", rIM_Protocol_Version_Number := ");
field_rIM__Protocol__Version__Number.log();
TTCN_Logger::log_event_str(", applContainer_or_ApplErrContainer := ");
field_applContainer__or__ApplErrContainer.log();
TTCN_Logger::log_event_str(", sON_TransferApplicationIdentity := ");
field_sON__TransferApplicationIdentity.log();
TTCN_Logger::log_event_str(" }");
}

void RAN__Information__RIM__Container__GTPC::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (rIM__Application__Identity().is_bound()) rIM__Application__Identity().set_implicit_omit();
if (rIM__Sequence__Number().is_bound()) rIM__Sequence__Number().set_implicit_omit();
if (rIM__PDU__Indications().is_bound()) rIM__PDU__Indications().set_implicit_omit();
if (!rIM__Protocol__Version__Number().is_bound()) rIM__Protocol__Version__Number() = OMIT_VALUE;
else rIM__Protocol__Version__Number().set_implicit_omit();
if (!applContainer__or__ApplErrContainer().is_bound()) applContainer__or__ApplErrContainer() = OMIT_VALUE;
else applContainer__or__ApplErrContainer().set_implicit_omit();
if (!sON__TransferApplicationIdentity().is_bound()) sON__TransferApplicationIdentity() = OMIT_VALUE;
else sON__TransferApplicationIdentity().set_implicit_omit();
}

void RAN__Information__RIM__Container__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record value of type @GTPC_Types.RAN_Information_RIM_Container_GTPC has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rIM__Application__Identity().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) rIM__Sequence__Number().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) rIM__PDU__Indications().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) rIM__Protocol__Version__Number().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) applContainer__or__ApplErrContainer().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) sON__TransferApplicationIdentity().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_Application_Identity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__Application__Identity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_Sequence_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__Sequence__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_PDU_Indications")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__PDU__Indications().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_Protocol_Version_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__Protocol__Version__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "applContainer_or_ApplErrContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          applContainer__or__ApplErrContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sON_TransferApplicationIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sON__TransferApplicationIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_RIM_Container_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.RAN_Information_RIM_Container_GTPC");
  }
}

void RAN__Information__RIM__Container__GTPC::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_rIM__Application__Identity.encode_text(text_buf);
field_rIM__Sequence__Number.encode_text(text_buf);
field_rIM__PDU__Indications.encode_text(text_buf);
field_rIM__Protocol__Version__Number.encode_text(text_buf);
field_applContainer__or__ApplErrContainer.encode_text(text_buf);
field_sON__TransferApplicationIdentity.encode_text(text_buf);
}

void RAN__Information__RIM__Container__GTPC::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_rIM__Application__Identity.decode_text(text_buf);
field_rIM__Sequence__Number.decode_text(text_buf);
field_rIM__PDU__Indications.decode_text(text_buf);
field_rIM__Protocol__Version__Number.decode_text(text_buf);
field_applContainer__or__ApplErrContainer.decode_text(text_buf);
field_sON__TransferApplicationIdentity.decode_text(text_buf);
}

void RAN__Information__RIM__Container__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RAN__Information__RIM__Container__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RAN__Information__RIM__Container__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RAN__Information__RIM__Container__GTPC_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(RAN__Information__RIM__Container__GTPC_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_3) selected_field = 0;
  else if (field_ext ==  bs_24) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RAN__Information__RIM__Container__GTPC_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(RAN__Information__RIM__Container__GTPC_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a__GTPC_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a__GTPC::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a__GTPC_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, RIM__Application__Identity__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_rIM__Application__Identity.RAW_decode(RIM__Application__Identity__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, RIM__Sequence__Number__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_rIM__Sequence__Number.RAW_decode(RIM__Sequence__Number__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, RIM__PDU__Indications__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_rIM__PDU__Indications.RAW_decode(RIM__PDU__Indications__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (limit > 0 && value_of_length_field2 > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_rIM__Protocol__Version__Number = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, RIM__Protocol__Version__Number__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_rIM__Protocol__Version__Number().RAW_decode(RIM__Protocol__Version__Number__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_rIM__Protocol__Version__Number = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_rIM__Protocol__Version__Number.ispresent() || field_rIM__Protocol__Version__Number().iEI() !=  os_105){
  field_rIM__Protocol__Version__Number=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  }
  }
  }
  }
  else field_rIM__Protocol__Version__Number=OMIT_VALUE;
  if (field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_13) selected_field = 0;
  else if (field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_2) selected_field = 1;
  else if (field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_3) selected_field = 2;
  else if (field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_58) selected_field = 3;
  else if (field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_52) selected_field = 4;
  else selected_field = -1;
  if (limit > 0 && value_of_length_field2 > 0 && (field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_13 || field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_2 || field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_3 || field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_58 || field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_52)&& selected_field!=-1){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_applContainer__or__ApplErrContainer = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, RAN__Information__RIM__Container__GTPC_applContainer__or__ApplErrContainer_descr_.raw->forceomit);
  decoded_field_length = field_applContainer__or__ApplErrContainer().RAW_decode(RAN__Information__RIM__Container__GTPC_applContainer__or__ApplErrContainer_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, TRUE, selected_field, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_applContainer__or__ApplErrContainer = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  }
  }
  }
  else field_applContainer__or__ApplErrContainer=OMIT_VALUE;
  if (limit > 0 && value_of_length_field2 > 0 && field_rIM__Application__Identity.rIMApplicationIdentity() ==  os_58){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_sON__TransferApplicationIdentity = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, RAN__Information__RIM__Container__GTPC_sON__TransferApplicationIdentity_descr_.raw->forceomit);
  decoded_field_length = field_sON__TransferApplicationIdentity().RAW_decode(RAN__Information__RIM__Container__GTPC_sON__TransferApplicationIdentity_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_sON__TransferApplicationIdentity = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  }
  }
  }
  else field_sON__TransferApplicationIdentity=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RAN__Information__RIM__Container__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 9;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(9);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RAN__Information__RIM__Container__GTPC_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RAN__Information__RIM__Container__GTPC_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RIM__Application__Identity__GTPC_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RIM__Sequence__Number__GTPC_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, RIM__PDU__Indications__GTPC_descr_.raw);
  if (field_rIM__Protocol__Version__Number.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, RIM__Protocol__Version__Number__GTPC_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_applContainer__or__ApplErrContainer.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, RAN__Information__RIM__Container__GTPC_applContainer__or__ApplErrContainer_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_sON__TransferApplicationIdentity.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, RAN__Information__RIM__Container__GTPC_sON__TransferApplicationIdentity_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(RAN__Information__RIM__Container__GTPC_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(RAN__Information__RIM__Container__GTPC_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_rIM__Application__Identity.RAW_encode(RIM__Application__Identity__GTPC_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_rIM__Sequence__Number.RAW_encode(RIM__Sequence__Number__GTPC_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_rIM__PDU__Indications.RAW_encode(RIM__PDU__Indications__GTPC_descr_, *myleaf.body.node.nodes[5]);
  if (field_rIM__Protocol__Version__Number.ispresent()) {
  encoded_length += field_rIM__Protocol__Version__Number().RAW_encode(RIM__Protocol__Version__Number__GTPC_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_applContainer__or__ApplErrContainer.ispresent()) {
  encoded_length += field_applContainer__or__ApplErrContainer().RAW_encode(RAN__Information__RIM__Container__GTPC_applContainer__or__ApplErrContainer_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_sON__TransferApplicationIdentity.ispresent()) {
  encoded_length += field_sON__TransferApplicationIdentity().RAW_encode(RAN__Information__RIM__Container__GTPC_sON__TransferApplicationIdentity_descr_, *myleaf.body.node.nodes[8]);
  }
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 6;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(6);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  if (field_rIM__Protocol__Version__Number.ispresent()) {
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  }else{
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[3].level = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[3].pos = 0;
  }
  if (field_applContainer__or__ApplErrContainer.ispresent()) {
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[4].level = myleaf.body.node.nodes[7]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[4].pos = myleaf.body.node.nodes[7]->curr_pos.pos;
  }else{
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[4].level = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[4].pos = 0;
  }
  if (field_sON__TransferApplicationIdentity.ispresent()) {
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[5].level = myleaf.body.node.nodes[8]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[5].pos = myleaf.body.node.nodes[8]->curr_pos.pos;
  }else{
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[5].level = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[5].pos = 0;
  }
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1:
  if (field_ext !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(RAN__Information__RIM__Container__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a__GTPC::ALT_length2:
  if (field_ext !=  bs_24) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_24.RAW_encode(RAN__Information__RIM__Container__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_rIM__Protocol__Version__Number.ispresent() && (!field_rIM__Protocol__Version__Number.ispresent() || field_rIM__Protocol__Version__Number().iEI() !=  os_105)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={6,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_105.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_applContainer__or__ApplErrContainer.ispresent() && (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_13 && field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_2 && field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_3 && field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_58 && field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_52)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,3};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_13.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos1;
  pr_pos1.level=myleaf.curr_pos.level+2;
  int new_pos1[]={3,3};
  pr_pos1.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos1);
  temp_leaf = myleaf.get_node(pr_pos1);
  if(temp_leaf != NULL){
   os_2.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos2;
  pr_pos2.level=myleaf.curr_pos.level+2;
  int new_pos2[]={3,3};
  pr_pos2.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos2);
  temp_leaf = myleaf.get_node(pr_pos2);
  if(temp_leaf != NULL){
   os_3.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos3;
  pr_pos3.level=myleaf.curr_pos.level+2;
  int new_pos3[]={3,3};
  pr_pos3.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos3);
  temp_leaf = myleaf.get_node(pr_pos3);
  if(temp_leaf != NULL){
   os_58.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else  {
  RAW_enc_tr_pos pr_pos4;
  pr_pos4.level=myleaf.curr_pos.level+2;
  int new_pos4[]={3,3};
  pr_pos4.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos4);
  temp_leaf = myleaf.get_node(pr_pos4);
  if(temp_leaf != NULL){
   os_52.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos4.pos);
  }
  free_tree_pos(pr_pos3.pos);
  }
  free_tree_pos(pr_pos2.pos);
  }
  free_tree_pos(pr_pos1.pos);
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_applContainer__or__ApplErrContainer.ispresent()) {
  switch (field_applContainer__or__ApplErrContainer().get_selection()) {
  case ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc:
  if (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_13) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 3, 3 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     os_13.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case ApplContainer__or__ApplErrContainer__GTPC::ALT_si3:
  if (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_2) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 3, 3 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     os_2.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS:
  if (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 3, 3 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     os_3.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case ApplContainer__or__ApplErrContainer__GTPC::ALT_sON:
  if (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_58) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 3, 3 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     os_58.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI:
  if (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_52) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 2;
  int new_pos[] = { 3, 3 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 2, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     os_52.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  }
  if (field_sON__TransferApplicationIdentity.ispresent() && (field_rIM__Application__Identity.rIMApplicationIdentity() !=  os_58)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,3};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_58.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct RAN__Information__RIM__Container__GTPC_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a__GTPC_template field_lengthIndicator;
RIM__Application__Identity__GTPC_template field_rIM__Application__Identity;
RIM__Sequence__Number__GTPC_template field_rIM__Sequence__Number;
RIM__PDU__Indications__GTPC_template field_rIM__PDU__Indications;
RIM__Protocol__Version__Number__GTPC_template field_rIM__Protocol__Version__Number;
ApplContainer__or__ApplErrContainer__GTPC_template field_applContainer__or__ApplErrContainer;
SON__TransferApplicationIdentity_template field_sON__TransferApplicationIdentity;
};

void RAN__Information__RIM__Container__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_rIM__Application__Identity = ANY_VALUE;
single_value->field_rIM__Sequence__Number = ANY_VALUE;
single_value->field_rIM__PDU__Indications = ANY_VALUE;
single_value->field_rIM__Protocol__Version__Number = ANY_OR_OMIT;
single_value->field_applContainer__or__ApplErrContainer = ANY_OR_OMIT;
single_value->field_sON__TransferApplicationIdentity = ANY_OR_OMIT;
}
}
}

void RAN__Information__RIM__Container__GTPC_template::copy_value(const RAN__Information__RIM__Container__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.rIM__Application__Identity().is_bound()) {
  single_value->field_rIM__Application__Identity = other_value.rIM__Application__Identity();
} else {
  single_value->field_rIM__Application__Identity.clean_up();
}
if (other_value.rIM__Sequence__Number().is_bound()) {
  single_value->field_rIM__Sequence__Number = other_value.rIM__Sequence__Number();
} else {
  single_value->field_rIM__Sequence__Number.clean_up();
}
if (other_value.rIM__PDU__Indications().is_bound()) {
  single_value->field_rIM__PDU__Indications = other_value.rIM__PDU__Indications();
} else {
  single_value->field_rIM__PDU__Indications.clean_up();
}
if (other_value.rIM__Protocol__Version__Number().is_bound()) {
  if (other_value.rIM__Protocol__Version__Number().ispresent()) single_value->field_rIM__Protocol__Version__Number = other_value.rIM__Protocol__Version__Number()();
  else single_value->field_rIM__Protocol__Version__Number = OMIT_VALUE;
} else {
  single_value->field_rIM__Protocol__Version__Number.clean_up();
}
if (other_value.applContainer__or__ApplErrContainer().is_bound()) {
  if (other_value.applContainer__or__ApplErrContainer().ispresent()) single_value->field_applContainer__or__ApplErrContainer = other_value.applContainer__or__ApplErrContainer()();
  else single_value->field_applContainer__or__ApplErrContainer = OMIT_VALUE;
} else {
  single_value->field_applContainer__or__ApplErrContainer.clean_up();
}
if (other_value.sON__TransferApplicationIdentity().is_bound()) {
  if (other_value.sON__TransferApplicationIdentity().ispresent()) single_value->field_sON__TransferApplicationIdentity = other_value.sON__TransferApplicationIdentity()();
  else single_value->field_sON__TransferApplicationIdentity = OMIT_VALUE;
} else {
  single_value->field_sON__TransferApplicationIdentity.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RAN__Information__RIM__Container__GTPC_template::copy_template(const RAN__Information__RIM__Container__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rIM__Application__Identity().get_selection()) {
single_value->field_rIM__Application__Identity = other_value.rIM__Application__Identity();
} else {
single_value->field_rIM__Application__Identity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rIM__Sequence__Number().get_selection()) {
single_value->field_rIM__Sequence__Number = other_value.rIM__Sequence__Number();
} else {
single_value->field_rIM__Sequence__Number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rIM__PDU__Indications().get_selection()) {
single_value->field_rIM__PDU__Indications = other_value.rIM__PDU__Indications();
} else {
single_value->field_rIM__PDU__Indications.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rIM__Protocol__Version__Number().get_selection()) {
single_value->field_rIM__Protocol__Version__Number = other_value.rIM__Protocol__Version__Number();
} else {
single_value->field_rIM__Protocol__Version__Number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.applContainer__or__ApplErrContainer().get_selection()) {
single_value->field_applContainer__or__ApplErrContainer = other_value.applContainer__or__ApplErrContainer();
} else {
single_value->field_applContainer__or__ApplErrContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sON__TransferApplicationIdentity().get_selection()) {
single_value->field_sON__TransferApplicationIdentity = other_value.sON__TransferApplicationIdentity();
} else {
single_value->field_sON__TransferApplicationIdentity.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RAN__Information__RIM__Container__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RAN__Information__RIM__Container__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new RAN__Information__RIM__Container__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
break;
}
set_selection(other_value);
}

RAN__Information__RIM__Container__GTPC_template::RAN__Information__RIM__Container__GTPC_template()
{
}

RAN__Information__RIM__Container__GTPC_template::RAN__Information__RIM__Container__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RAN__Information__RIM__Container__GTPC_template::RAN__Information__RIM__Container__GTPC_template(const RAN__Information__RIM__Container__GTPC& other_value)
{
copy_value(other_value);
}

RAN__Information__RIM__Container__GTPC_template::RAN__Information__RIM__Container__GTPC_template(const OPTIONAL<RAN__Information__RIM__Container__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__RIM__Container__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC from an unbound optional field.");
}
}

RAN__Information__RIM__Container__GTPC_template::RAN__Information__RIM__Container__GTPC_template(RAN__Information__RIM__Container__GTPC_template* p_precondition, RAN__Information__RIM__Container__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RAN__Information__RIM__Container__GTPC_template::RAN__Information__RIM__Container__GTPC_template(Dynamic_Match_Interface<RAN__Information__RIM__Container__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RAN__Information__RIM__Container__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RAN__Information__RIM__Container__GTPC_template::RAN__Information__RIM__Container__GTPC_template(const RAN__Information__RIM__Container__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RAN__Information__RIM__Container__GTPC_template::~RAN__Information__RIM__Container__GTPC_template()
{
clean_up();
}

RAN__Information__RIM__Container__GTPC_template& RAN__Information__RIM__Container__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RAN__Information__RIM__Container__GTPC_template& RAN__Information__RIM__Container__GTPC_template::operator=(const RAN__Information__RIM__Container__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RAN__Information__RIM__Container__GTPC_template& RAN__Information__RIM__Container__GTPC_template::operator=(const OPTIONAL<RAN__Information__RIM__Container__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__RIM__Container__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
}
return *this;
}

RAN__Information__RIM__Container__GTPC_template& RAN__Information__RIM__Container__GTPC_template::operator=(const RAN__Information__RIM__Container__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RAN__Information__RIM__Container__GTPC_template::match(const RAN__Information__RIM__Container__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.rIM__Application__Identity().is_bound()) return FALSE;
if(!single_value->field_rIM__Application__Identity.match(other_value.rIM__Application__Identity(), legacy))return FALSE;
if(!other_value.rIM__Sequence__Number().is_bound()) return FALSE;
if(!single_value->field_rIM__Sequence__Number.match(other_value.rIM__Sequence__Number(), legacy))return FALSE;
if(!other_value.rIM__PDU__Indications().is_bound()) return FALSE;
if(!single_value->field_rIM__PDU__Indications.match(other_value.rIM__PDU__Indications(), legacy))return FALSE;
if(!other_value.rIM__Protocol__Version__Number().is_bound()) return FALSE;
if((other_value.rIM__Protocol__Version__Number().ispresent() ? !single_value->field_rIM__Protocol__Version__Number.match((const RIM__Protocol__Version__Number__GTPC&)other_value.rIM__Protocol__Version__Number(), legacy) : !single_value->field_rIM__Protocol__Version__Number.match_omit(legacy)))return FALSE;
if(!other_value.applContainer__or__ApplErrContainer().is_bound()) return FALSE;
if((other_value.applContainer__or__ApplErrContainer().ispresent() ? !single_value->field_applContainer__or__ApplErrContainer.match((const ApplContainer__or__ApplErrContainer__GTPC&)other_value.applContainer__or__ApplErrContainer(), legacy) : !single_value->field_applContainer__or__ApplErrContainer.match_omit(legacy)))return FALSE;
if(!other_value.sON__TransferApplicationIdentity().is_bound()) return FALSE;
if((other_value.sON__TransferApplicationIdentity().ispresent() ? !single_value->field_sON__TransferApplicationIdentity.match((const SON__TransferApplicationIdentity&)other_value.sON__TransferApplicationIdentity(), legacy) : !single_value->field_sON__TransferApplicationIdentity.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
}
return FALSE;
}

boolean RAN__Information__RIM__Container__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_rIM__Application__Identity.is_bound()
 || single_value->field_rIM__Sequence__Number.is_bound()
 || single_value->field_rIM__PDU__Indications.is_bound()
 || (single_value->field_rIM__Protocol__Version__Number.is_omit() || single_value->field_rIM__Protocol__Version__Number.is_bound())
 || (single_value->field_applContainer__or__ApplErrContainer.is_omit() || single_value->field_applContainer__or__ApplErrContainer.is_bound())
 || (single_value->field_sON__TransferApplicationIdentity.is_omit() || single_value->field_sON__TransferApplicationIdentity.is_bound());
}

boolean RAN__Information__RIM__Container__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_rIM__Application__Identity.is_value()
 && single_value->field_rIM__Sequence__Number.is_value()
 && single_value->field_rIM__PDU__Indications.is_value()
 && (single_value->field_rIM__Protocol__Version__Number.is_omit() || single_value->field_rIM__Protocol__Version__Number.is_value())
 && (single_value->field_applContainer__or__ApplErrContainer.is_omit() || single_value->field_applContainer__or__ApplErrContainer.is_value())
 && (single_value->field_sON__TransferApplicationIdentity.is_omit() || single_value->field_sON__TransferApplicationIdentity.is_value());
}

void RAN__Information__RIM__Container__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RAN__Information__RIM__Container__GTPC RAN__Information__RIM__Container__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
RAN__Information__RIM__Container__GTPC ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_rIM__Application__Identity.is_bound()) {
ret_val.rIM__Application__Identity() = single_value->field_rIM__Application__Identity.valueof();
}
if (single_value->field_rIM__Sequence__Number.is_bound()) {
ret_val.rIM__Sequence__Number() = single_value->field_rIM__Sequence__Number.valueof();
}
if (single_value->field_rIM__PDU__Indications.is_bound()) {
ret_val.rIM__PDU__Indications() = single_value->field_rIM__PDU__Indications.valueof();
}
if (single_value->field_rIM__Protocol__Version__Number.is_omit()) ret_val.rIM__Protocol__Version__Number() = OMIT_VALUE;
else if (single_value->field_rIM__Protocol__Version__Number.is_bound()) {
ret_val.rIM__Protocol__Version__Number() = single_value->field_rIM__Protocol__Version__Number.valueof();
}
if (single_value->field_applContainer__or__ApplErrContainer.is_omit()) ret_val.applContainer__or__ApplErrContainer() = OMIT_VALUE;
else if (single_value->field_applContainer__or__ApplErrContainer.is_bound()) {
ret_val.applContainer__or__ApplErrContainer() = single_value->field_applContainer__or__ApplErrContainer.valueof();
}
if (single_value->field_sON__TransferApplicationIdentity.is_omit()) ret_val.sON__TransferApplicationIdentity() = OMIT_VALUE;
else if (single_value->field_sON__TransferApplicationIdentity.is_bound()) {
ret_val.sON__TransferApplicationIdentity() = single_value->field_sON__TransferApplicationIdentity.valueof();
}
return ret_val;
}

void RAN__Information__RIM__Container__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RAN__Information__RIM__Container__GTPC_template[list_length];
}

RAN__Information__RIM__Container__GTPC_template& RAN__Information__RIM__Container__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RAN__Information__RIM__Container__GTPC_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& RAN__Information__RIM__Container__GTPC_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
return single_value->field_iEI;
}

BITSTRING_template& RAN__Information__RIM__Container__GTPC_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& RAN__Information__RIM__Container__GTPC_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
return single_value->field_ext;
}

LIN2__2a__GTPC_template& RAN__Information__RIM__Container__GTPC_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a__GTPC_template& RAN__Information__RIM__Container__GTPC_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
return single_value->field_lengthIndicator;
}

RIM__Application__Identity__GTPC_template& RAN__Information__RIM__Container__GTPC_template::rIM__Application__Identity()
{
set_specific();
return single_value->field_rIM__Application__Identity;
}

const RIM__Application__Identity__GTPC_template& RAN__Information__RIM__Container__GTPC_template::rIM__Application__Identity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rIM_Application_Identity of a non-specific template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
return single_value->field_rIM__Application__Identity;
}

RIM__Sequence__Number__GTPC_template& RAN__Information__RIM__Container__GTPC_template::rIM__Sequence__Number()
{
set_specific();
return single_value->field_rIM__Sequence__Number;
}

const RIM__Sequence__Number__GTPC_template& RAN__Information__RIM__Container__GTPC_template::rIM__Sequence__Number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rIM_Sequence_Number of a non-specific template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
return single_value->field_rIM__Sequence__Number;
}

RIM__PDU__Indications__GTPC_template& RAN__Information__RIM__Container__GTPC_template::rIM__PDU__Indications()
{
set_specific();
return single_value->field_rIM__PDU__Indications;
}

const RIM__PDU__Indications__GTPC_template& RAN__Information__RIM__Container__GTPC_template::rIM__PDU__Indications() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rIM_PDU_Indications of a non-specific template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
return single_value->field_rIM__PDU__Indications;
}

RIM__Protocol__Version__Number__GTPC_template& RAN__Information__RIM__Container__GTPC_template::rIM__Protocol__Version__Number()
{
set_specific();
return single_value->field_rIM__Protocol__Version__Number;
}

const RIM__Protocol__Version__Number__GTPC_template& RAN__Information__RIM__Container__GTPC_template::rIM__Protocol__Version__Number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rIM_Protocol_Version_Number of a non-specific template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
return single_value->field_rIM__Protocol__Version__Number;
}

ApplContainer__or__ApplErrContainer__GTPC_template& RAN__Information__RIM__Container__GTPC_template::applContainer__or__ApplErrContainer()
{
set_specific();
return single_value->field_applContainer__or__ApplErrContainer;
}

const ApplContainer__or__ApplErrContainer__GTPC_template& RAN__Information__RIM__Container__GTPC_template::applContainer__or__ApplErrContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field applContainer_or_ApplErrContainer of a non-specific template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
return single_value->field_applContainer__or__ApplErrContainer;
}

SON__TransferApplicationIdentity_template& RAN__Information__RIM__Container__GTPC_template::sON__TransferApplicationIdentity()
{
set_specific();
return single_value->field_sON__TransferApplicationIdentity;
}

const SON__TransferApplicationIdentity_template& RAN__Information__RIM__Container__GTPC_template::sON__TransferApplicationIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sON_TransferApplicationIdentity of a non-specific template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
return single_value->field_sON__TransferApplicationIdentity;
}

int RAN__Information__RIM__Container__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 6;
      if (single_value->field_rIM__Protocol__Version__Number.is_present()) ret_val++;
      if (single_value->field_applContainer__or__ApplErrContainer.is_present()) ret_val++;
      if (single_value->field_sON__TransferApplicationIdentity.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
  }
  return 0;
}

void RAN__Information__RIM__Container__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", rIM_Application_Identity := ");
single_value->field_rIM__Application__Identity.log();
TTCN_Logger::log_event_str(", rIM_Sequence_Number := ");
single_value->field_rIM__Sequence__Number.log();
TTCN_Logger::log_event_str(", rIM_PDU_Indications := ");
single_value->field_rIM__PDU__Indications.log();
TTCN_Logger::log_event_str(", rIM_Protocol_Version_Number := ");
single_value->field_rIM__Protocol__Version__Number.log();
TTCN_Logger::log_event_str(", applContainer_or_ApplErrContainer := ");
single_value->field_applContainer__or__ApplErrContainer.log();
TTCN_Logger::log_event_str(", sON_TransferApplicationIdentity := ");
single_value->field_sON__TransferApplicationIdentity.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RAN__Information__RIM__Container__GTPC_template::log_match(const RAN__Information__RIM__Container__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rIM__Application__Identity.match(match_value.rIM__Application__Identity(), legacy)){
TTCN_Logger::log_logmatch_info(".rIM_Application_Identity");
single_value->field_rIM__Application__Identity.log_match(match_value.rIM__Application__Identity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rIM__Sequence__Number.match(match_value.rIM__Sequence__Number(), legacy)){
TTCN_Logger::log_logmatch_info(".rIM_Sequence_Number");
single_value->field_rIM__Sequence__Number.log_match(match_value.rIM__Sequence__Number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rIM__PDU__Indications.match(match_value.rIM__PDU__Indications(), legacy)){
TTCN_Logger::log_logmatch_info(".rIM_PDU_Indications");
single_value->field_rIM__PDU__Indications.log_match(match_value.rIM__PDU__Indications(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.rIM__Protocol__Version__Number().ispresent()){
if(!single_value->field_rIM__Protocol__Version__Number.match(match_value.rIM__Protocol__Version__Number(), legacy)){
TTCN_Logger::log_logmatch_info(".rIM_Protocol_Version_Number");
single_value->field_rIM__Protocol__Version__Number.log_match(match_value.rIM__Protocol__Version__Number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_rIM__Protocol__Version__Number.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".rIM_Protocol_Version_Number := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_rIM__Protocol__Version__Number.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.applContainer__or__ApplErrContainer().ispresent()){
if(!single_value->field_applContainer__or__ApplErrContainer.match(match_value.applContainer__or__ApplErrContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".applContainer_or_ApplErrContainer");
single_value->field_applContainer__or__ApplErrContainer.log_match(match_value.applContainer__or__ApplErrContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_applContainer__or__ApplErrContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".applContainer_or_ApplErrContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_applContainer__or__ApplErrContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.sON__TransferApplicationIdentity().ispresent()){
if(!single_value->field_sON__TransferApplicationIdentity.match(match_value.sON__TransferApplicationIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".sON_TransferApplicationIdentity");
single_value->field_sON__TransferApplicationIdentity.log_match(match_value.sON__TransferApplicationIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_sON__TransferApplicationIdentity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".sON_TransferApplicationIdentity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_sON__TransferApplicationIdentity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", rIM_Application_Identity := ");
single_value->field_rIM__Application__Identity.log_match(match_value.rIM__Application__Identity(), legacy);
TTCN_Logger::log_event_str(", rIM_Sequence_Number := ");
single_value->field_rIM__Sequence__Number.log_match(match_value.rIM__Sequence__Number(), legacy);
TTCN_Logger::log_event_str(", rIM_PDU_Indications := ");
single_value->field_rIM__PDU__Indications.log_match(match_value.rIM__PDU__Indications(), legacy);
TTCN_Logger::log_event_str(", rIM_Protocol_Version_Number := ");
if (match_value.rIM__Protocol__Version__Number().ispresent()) {
single_value->field_rIM__Protocol__Version__Number.log_match(match_value.rIM__Protocol__Version__Number(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_rIM__Protocol__Version__Number.log();
if (single_value->field_rIM__Protocol__Version__Number.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", applContainer_or_ApplErrContainer := ");
if (match_value.applContainer__or__ApplErrContainer().ispresent()) {
single_value->field_applContainer__or__ApplErrContainer.log_match(match_value.applContainer__or__ApplErrContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_applContainer__or__ApplErrContainer.log();
if (single_value->field_applContainer__or__ApplErrContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", sON_TransferApplicationIdentity := ");
if (match_value.sON__TransferApplicationIdentity().ispresent()) {
single_value->field_sON__TransferApplicationIdentity.log_match(match_value.sON__TransferApplicationIdentity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_sON__TransferApplicationIdentity.log();
if (single_value->field_sON__TransferApplicationIdentity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RAN__Information__RIM__Container__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (rIM__Application__Identity().is_bound()) rIM__Application__Identity().set_implicit_omit();
if (rIM__Sequence__Number().is_bound()) rIM__Sequence__Number().set_implicit_omit();
if (rIM__PDU__Indications().is_bound()) rIM__PDU__Indications().set_implicit_omit();
if (!rIM__Protocol__Version__Number().is_bound()) rIM__Protocol__Version__Number() = OMIT_VALUE;
else rIM__Protocol__Version__Number().set_implicit_omit();
if (!applContainer__or__ApplErrContainer().is_bound()) applContainer__or__ApplErrContainer() = OMIT_VALUE;
else applContainer__or__ApplErrContainer().set_implicit_omit();
if (!sON__TransferApplicationIdentity().is_bound()) sON__TransferApplicationIdentity() = OMIT_VALUE;
else sON__TransferApplicationIdentity().set_implicit_omit();
}

void RAN__Information__RIM__Container__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_rIM__Application__Identity.encode_text(text_buf);
single_value->field_rIM__Sequence__Number.encode_text(text_buf);
single_value->field_rIM__PDU__Indications.encode_text(text_buf);
single_value->field_rIM__Protocol__Version__Number.encode_text(text_buf);
single_value->field_applContainer__or__ApplErrContainer.encode_text(text_buf);
single_value->field_sON__TransferApplicationIdentity.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
}
}

void RAN__Information__RIM__Container__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_rIM__Application__Identity.decode_text(text_buf);
single_value->field_rIM__Sequence__Number.decode_text(text_buf);
single_value->field_rIM__PDU__Indications.decode_text(text_buf);
single_value->field_rIM__Protocol__Version__Number.decode_text(text_buf);
single_value->field_applContainer__or__ApplErrContainer.decode_text(text_buf);
single_value->field_sON__TransferApplicationIdentity.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RAN__Information__RIM__Container__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC.");
}
}

void RAN__Information__RIM__Container__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RAN__Information__RIM__Container__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record template of type @GTPC_Types.RAN_Information_RIM_Container_GTPC has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rIM__Application__Identity().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) rIM__Sequence__Number().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) rIM__PDU__Indications().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) rIM__Protocol__Version__Number().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) applContainer__or__ApplErrContainer().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) sON__TransferApplicationIdentity().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_Application_Identity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__Application__Identity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_Sequence_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__Sequence__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_PDU_Indications")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__PDU__Indications().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rIM_Protocol_Version_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rIM__Protocol__Version__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "applContainer_or_ApplErrContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          applContainer__or__ApplErrContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sON_TransferApplicationIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sON__TransferApplicationIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_RIM_Container_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RAN__Information__RIM__Container__GTPC_template* precondition = new RAN__Information__RIM__Container__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    RAN__Information__RIM__Container__GTPC_template* implied_template = new RAN__Information__RIM__Container__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RAN__Information__RIM__Container__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.RAN_Information_RIM_Container_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void RAN__Information__RIM__Container__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_RIM_Container_GTPC");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_RIM_Container_GTPC");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_RIM_Container_GTPC");
single_value->field_rIM__Application__Identity.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_RIM_Container_GTPC");
single_value->field_rIM__Sequence__Number.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_RIM_Container_GTPC");
single_value->field_rIM__PDU__Indications.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_RIM_Container_GTPC");
single_value->field_rIM__Protocol__Version__Number.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_RIM_Container_GTPC");
single_value->field_applContainer__or__ApplErrContainer.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_RIM_Container_GTPC");
single_value->field_sON__TransferApplicationIdentity.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RAN_Information_RIM_Container_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.RAN_Information_RIM_Container_GTPC");
}

boolean RAN__Information__RIM__Container__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RAN__Information__RIM__Container__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void ApplContainer__or__ApplErrContainer__GTPC::copy_value(const ApplContainer__or__ApplErrContainer__GTPC& other_value)
{
switch (other_value.union_selection) {
case ALT_nacc:
field_nacc = new ApplContainer__or__ApplErrContainer__NACC__GTPC(*other_value.field_nacc);
break;
case ALT_si3:
field_si3 = new ApplContainer__or__ApplErrContainer__SI3__GTPC(*other_value.field_si3);
break;
case ALT_mBMS:
field_mBMS = new ApplContainer__or__ApplErrContainer__MBMS__GTPC(*other_value.field_mBMS);
break;
case ALT_sON:
field_sON = new ApplContainer__or__ApplErrContainer__SON__GTPC(*other_value.field_sON);
break;
case ALT_uTRA__SI:
field_uTRA__SI = new ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC(*other_value.field_uTRA__SI);
break;
default:
TTCN_error("Assignment of an unbound union value of type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
union_selection = other_value.union_selection;
}

ApplContainer__or__ApplErrContainer__GTPC::ApplContainer__or__ApplErrContainer__GTPC()
{
union_selection = UNBOUND_VALUE;
}

ApplContainer__or__ApplErrContainer__GTPC::ApplContainer__or__ApplErrContainer__GTPC(const ApplContainer__or__ApplErrContainer__GTPC& other_value)
: Base_Type(){
copy_value(other_value);
}

ApplContainer__or__ApplErrContainer__GTPC::~ApplContainer__or__ApplErrContainer__GTPC()
{
clean_up();
}

ApplContainer__or__ApplErrContainer__GTPC& ApplContainer__or__ApplErrContainer__GTPC::operator=(const ApplContainer__or__ApplErrContainer__GTPC& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean ApplContainer__or__ApplErrContainer__GTPC::operator==(const ApplContainer__or__ApplErrContainer__GTPC& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_nacc:
return *field_nacc == *other_value.field_nacc;
case ALT_si3:
return *field_si3 == *other_value.field_si3;
case ALT_mBMS:
return *field_mBMS == *other_value.field_mBMS;
case ALT_sON:
return *field_sON == *other_value.field_sON;
case ALT_uTRA__SI:
return *field_uTRA__SI == *other_value.field_uTRA__SI;
default:
return FALSE;
}
}

ApplContainer__or__ApplErrContainer__NACC__GTPC& ApplContainer__or__ApplErrContainer__GTPC::nacc()
{
if (union_selection != ALT_nacc) {
clean_up();
field_nacc = new ApplContainer__or__ApplErrContainer__NACC__GTPC;
union_selection = ALT_nacc;
}
return *field_nacc;
}

const ApplContainer__or__ApplErrContainer__NACC__GTPC& ApplContainer__or__ApplErrContainer__GTPC::nacc() const
{
if (union_selection != ALT_nacc) TTCN_error("Using non-selected field nacc in a value of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
return *field_nacc;
}

ApplContainer__or__ApplErrContainer__SI3__GTPC& ApplContainer__or__ApplErrContainer__GTPC::si3()
{
if (union_selection != ALT_si3) {
clean_up();
field_si3 = new ApplContainer__or__ApplErrContainer__SI3__GTPC;
union_selection = ALT_si3;
}
return *field_si3;
}

const ApplContainer__or__ApplErrContainer__SI3__GTPC& ApplContainer__or__ApplErrContainer__GTPC::si3() const
{
if (union_selection != ALT_si3) TTCN_error("Using non-selected field si3 in a value of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
return *field_si3;
}

ApplContainer__or__ApplErrContainer__MBMS__GTPC& ApplContainer__or__ApplErrContainer__GTPC::mBMS()
{
if (union_selection != ALT_mBMS) {
clean_up();
field_mBMS = new ApplContainer__or__ApplErrContainer__MBMS__GTPC;
union_selection = ALT_mBMS;
}
return *field_mBMS;
}

const ApplContainer__or__ApplErrContainer__MBMS__GTPC& ApplContainer__or__ApplErrContainer__GTPC::mBMS() const
{
if (union_selection != ALT_mBMS) TTCN_error("Using non-selected field mBMS in a value of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
return *field_mBMS;
}

ApplContainer__or__ApplErrContainer__SON__GTPC& ApplContainer__or__ApplErrContainer__GTPC::sON()
{
if (union_selection != ALT_sON) {
clean_up();
field_sON = new ApplContainer__or__ApplErrContainer__SON__GTPC;
union_selection = ALT_sON;
}
return *field_sON;
}

const ApplContainer__or__ApplErrContainer__SON__GTPC& ApplContainer__or__ApplErrContainer__GTPC::sON() const
{
if (union_selection != ALT_sON) TTCN_error("Using non-selected field sON in a value of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
return *field_sON;
}

ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC& ApplContainer__or__ApplErrContainer__GTPC::uTRA__SI()
{
if (union_selection != ALT_uTRA__SI) {
clean_up();
field_uTRA__SI = new ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC;
union_selection = ALT_uTRA__SI;
}
return *field_uTRA__SI;
}

const ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC& ApplContainer__or__ApplErrContainer__GTPC::uTRA__SI() const
{
if (union_selection != ALT_uTRA__SI) TTCN_error("Using non-selected field uTRA_SI in a value of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
return *field_uTRA__SI;
}

boolean ApplContainer__or__ApplErrContainer__GTPC::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
return union_selection == checked_selection;
}

boolean ApplContainer__or__ApplErrContainer__GTPC::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean ApplContainer__or__ApplErrContainer__GTPC::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_nacc: return field_nacc->is_value();
case ALT_si3: return field_si3->is_value();
case ALT_mBMS: return field_mBMS->is_value();
case ALT_sON: return field_sON->is_value();
case ALT_uTRA__SI: return field_uTRA__SI->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void ApplContainer__or__ApplErrContainer__GTPC::clean_up()
{
switch (union_selection) {
case ALT_nacc:
  delete field_nacc;
  break;
case ALT_si3:
  delete field_si3;
  break;
case ALT_mBMS:
  delete field_mBMS;
  break;
case ALT_sON:
  delete field_sON;
  break;
case ALT_uTRA__SI:
  delete field_uTRA__SI;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void ApplContainer__or__ApplErrContainer__GTPC::log() const
{
switch (union_selection) {
case ALT_nacc:
TTCN_Logger::log_event_str("{ nacc := ");
field_nacc->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_si3:
TTCN_Logger::log_event_str("{ si3 := ");
field_si3->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_mBMS:
TTCN_Logger::log_event_str("{ mBMS := ");
field_mBMS->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_sON:
TTCN_Logger::log_event_str("{ sON := ");
field_sON->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_uTRA__SI:
TTCN_Logger::log_event_str("{ uTRA_SI := ");
field_uTRA__SI->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void ApplContainer__or__ApplErrContainer__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "nacc")) {
    nacc().set_param(*mp_last);
    if (!nacc().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "si3")) {
    si3().set_param(*mp_last);
    if (!si3().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "mBMS")) {
    mBMS().set_param(*mp_last);
    if (!mBMS().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "sON")) {
    sON().set_param(*mp_last);
    if (!sON().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "uTRA_SI")) {
    uTRA__SI().set_param(*mp_last);
    if (!uTRA__SI().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.", last_name);
}

void ApplContainer__or__ApplErrContainer__GTPC::set_implicit_omit()
{
switch (union_selection) {
case ALT_nacc:
field_nacc->set_implicit_omit(); break;
case ALT_si3:
field_si3->set_implicit_omit(); break;
case ALT_mBMS:
field_mBMS->set_implicit_omit(); break;
case ALT_sON:
field_sON->set_implicit_omit(); break;
case ALT_uTRA__SI:
field_uTRA__SI->set_implicit_omit(); break;
default: break;
}
}

void ApplContainer__or__ApplErrContainer__GTPC::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_nacc:
field_nacc->encode_text(text_buf);
break;
case ALT_si3:
field_si3->encode_text(text_buf);
break;
case ALT_mBMS:
field_mBMS->encode_text(text_buf);
break;
case ALT_sON:
field_sON->encode_text(text_buf);
break;
case ALT_uTRA__SI:
field_uTRA__SI->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
}

void ApplContainer__or__ApplErrContainer__GTPC::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_nacc:
nacc().decode_text(text_buf);
break;
case ALT_si3:
si3().decode_text(text_buf);
break;
case ALT_mBMS:
mBMS().decode_text(text_buf);
break;
case ALT_sON:
sON().decode_text(text_buf);
break;
case ALT_uTRA__SI:
uTRA__SI().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
}

void ApplContainer__or__ApplErrContainer__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ApplContainer__or__ApplErrContainer__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ApplContainer__or__ApplErrContainer__GTPC::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, ApplContainer__or__ApplErrContainer__NACC__GTPC_descr_.raw->forceomit);
      decoded_length = nacc().RAW_decode(ApplContainer__or__ApplErrContainer__NACC__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, ApplContainer__or__ApplErrContainer__SI3__GTPC_descr_.raw->forceomit);
      decoded_length = si3().RAW_decode(ApplContainer__or__ApplErrContainer__SI3__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, ApplContainer__or__ApplErrContainer__MBMS__GTPC_descr_.raw->forceomit);
      decoded_length = mBMS().RAW_decode(ApplContainer__or__ApplErrContainer__MBMS__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, ApplContainer__or__ApplErrContainer__SON__GTPC_descr_.raw->forceomit);
      decoded_length = sON().RAW_decode(ApplContainer__or__ApplErrContainer__SON__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 4: {
      RAW_Force_Omit field_force_omit(4, force_omit, ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_descr_.raw->forceomit);
      decoded_length = uTRA__SI().RAW_decode(ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, ApplContainer__or__ApplErrContainer__NACC__GTPC_descr_.raw->forceomit);
      decoded_length = nacc().RAW_decode(ApplContainer__or__ApplErrContainer__NACC__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, ApplContainer__or__ApplErrContainer__SI3__GTPC_descr_.raw->forceomit);
      decoded_length = si3().RAW_decode(ApplContainer__or__ApplErrContainer__SI3__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, ApplContainer__or__ApplErrContainer__MBMS__GTPC_descr_.raw->forceomit);
      decoded_length = mBMS().RAW_decode(ApplContainer__or__ApplErrContainer__MBMS__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_3_force_omit(3, force_omit, ApplContainer__or__ApplErrContainer__SON__GTPC_descr_.raw->forceomit);
      decoded_length = sON().RAW_decode(ApplContainer__or__ApplErrContainer__SON__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_3_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_4_force_omit(4, force_omit, ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_descr_.raw->forceomit);
      decoded_length = uTRA__SI().RAW_decode(ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_4_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int ApplContainer__or__ApplErrContainer__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  memset(myleaf.body.node.nodes, 0, 5 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_nacc:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, ApplContainer__or__ApplErrContainer__NACC__GTPC_descr_.raw);
    encoded_length = field_nacc->RAW_encode(ApplContainer__or__ApplErrContainer__NACC__GTPC_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &ApplContainer__or__ApplErrContainer__NACC__GTPC_descr_;
    break;
  case ALT_si3:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, ApplContainer__or__ApplErrContainer__SI3__GTPC_descr_.raw);
    encoded_length = field_si3->RAW_encode(ApplContainer__or__ApplErrContainer__SI3__GTPC_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &ApplContainer__or__ApplErrContainer__SI3__GTPC_descr_;
    break;
  case ALT_mBMS:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, ApplContainer__or__ApplErrContainer__MBMS__GTPC_descr_.raw);
    encoded_length = field_mBMS->RAW_encode(ApplContainer__or__ApplErrContainer__MBMS__GTPC_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &ApplContainer__or__ApplErrContainer__MBMS__GTPC_descr_;
    break;
  case ALT_sON:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, ApplContainer__or__ApplErrContainer__SON__GTPC_descr_.raw);
    encoded_length = field_sON->RAW_encode(ApplContainer__or__ApplErrContainer__SON__GTPC_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &ApplContainer__or__ApplErrContainer__SON__GTPC_descr_;
    break;
  case ALT_uTRA__SI:
    myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 4, ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_descr_.raw);
    encoded_length = field_uTRA__SI->RAW_encode(ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_descr_, *myleaf.body.node.nodes[4]);
    myleaf.body.node.nodes[4]->coding_descr = &ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void ApplContainer__or__ApplErrContainer__GTPC_template::copy_value(const ApplContainer__or__ApplErrContainer__GTPC& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc:
single_value.field_nacc = new ApplContainer__or__ApplErrContainer__NACC__GTPC_template(other_value.nacc());
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_si3:
single_value.field_si3 = new ApplContainer__or__ApplErrContainer__SI3__GTPC_template(other_value.si3());
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS:
single_value.field_mBMS = new ApplContainer__or__ApplErrContainer__MBMS__GTPC_template(other_value.mBMS());
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_sON:
single_value.field_sON = new ApplContainer__or__ApplErrContainer__SON__GTPC_template(other_value.sON());
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI:
single_value.field_uTRA__SI = new ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_template(other_value.uTRA__SI());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
set_selection(SPECIFIC_VALUE);
}

void ApplContainer__or__ApplErrContainer__GTPC_template::copy_template(const ApplContainer__or__ApplErrContainer__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc:
single_value.field_nacc = new ApplContainer__or__ApplErrContainer__NACC__GTPC_template(*other_value.single_value.field_nacc);
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_si3:
single_value.field_si3 = new ApplContainer__or__ApplErrContainer__SI3__GTPC_template(*other_value.single_value.field_si3);
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS:
single_value.field_mBMS = new ApplContainer__or__ApplErrContainer__MBMS__GTPC_template(*other_value.single_value.field_mBMS);
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_sON:
single_value.field_sON = new ApplContainer__or__ApplErrContainer__SON__GTPC_template(*other_value.single_value.field_sON);
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI:
single_value.field_uTRA__SI = new ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_template(*other_value.single_value.field_uTRA__SI);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ApplContainer__or__ApplErrContainer__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ApplContainer__or__ApplErrContainer__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new ApplContainer__or__ApplErrContainer__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
set_selection(other_value);
}

ApplContainer__or__ApplErrContainer__GTPC_template::ApplContainer__or__ApplErrContainer__GTPC_template()
{
}

ApplContainer__or__ApplErrContainer__GTPC_template::ApplContainer__or__ApplErrContainer__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ApplContainer__or__ApplErrContainer__GTPC_template::ApplContainer__or__ApplErrContainer__GTPC_template(const ApplContainer__or__ApplErrContainer__GTPC& other_value)
{
copy_value(other_value);
}

ApplContainer__or__ApplErrContainer__GTPC_template::ApplContainer__or__ApplErrContainer__GTPC_template(const OPTIONAL<ApplContainer__or__ApplErrContainer__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ApplContainer__or__ApplErrContainer__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC from an unbound optional field.");
}
}

ApplContainer__or__ApplErrContainer__GTPC_template::ApplContainer__or__ApplErrContainer__GTPC_template(ApplContainer__or__ApplErrContainer__GTPC_template* p_precondition, ApplContainer__or__ApplErrContainer__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ApplContainer__or__ApplErrContainer__GTPC_template::ApplContainer__or__ApplErrContainer__GTPC_template(Dynamic_Match_Interface<ApplContainer__or__ApplErrContainer__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ApplContainer__or__ApplErrContainer__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ApplContainer__or__ApplErrContainer__GTPC_template::ApplContainer__or__ApplErrContainer__GTPC_template(const ApplContainer__or__ApplErrContainer__GTPC_template& other_value)
: Base_Template(){
copy_template(other_value);
}

ApplContainer__or__ApplErrContainer__GTPC_template::~ApplContainer__or__ApplErrContainer__GTPC_template()
{
clean_up();
}

void ApplContainer__or__ApplErrContainer__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc:
delete single_value.field_nacc;
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_si3:
delete single_value.field_si3;
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS:
delete single_value.field_mBMS;
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_sON:
delete single_value.field_sON;
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI:
delete single_value.field_uTRA__SI;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ApplContainer__or__ApplErrContainer__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ApplContainer__or__ApplErrContainer__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::operator=(const ApplContainer__or__ApplErrContainer__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ApplContainer__or__ApplErrContainer__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::operator=(const OPTIONAL<ApplContainer__or__ApplErrContainer__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ApplContainer__or__ApplErrContainer__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
return *this;
}

ApplContainer__or__ApplErrContainer__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::operator=(const ApplContainer__or__ApplErrContainer__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ApplContainer__or__ApplErrContainer__GTPC_template::match(const ApplContainer__or__ApplErrContainer__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
ApplContainer__or__ApplErrContainer__GTPC::union_selection_type value_selection = other_value.get_selection();
if (value_selection == ApplContainer__or__ApplErrContainer__GTPC::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc:
return single_value.field_nacc->match(other_value.nacc(), legacy);
case ApplContainer__or__ApplErrContainer__GTPC::ALT_si3:
return single_value.field_si3->match(other_value.si3(), legacy);
case ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS:
return single_value.field_mBMS->match(other_value.mBMS(), legacy);
case ApplContainer__or__ApplErrContainer__GTPC::ALT_sON:
return single_value.field_sON->match(other_value.sON(), legacy);
case ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI:
return single_value.field_uTRA__SI->match(other_value.uTRA__SI(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
return FALSE;
}

boolean ApplContainer__or__ApplErrContainer__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc:
return single_value.field_nacc->is_value();
case ApplContainer__or__ApplErrContainer__GTPC::ALT_si3:
return single_value.field_si3->is_value();
case ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS:
return single_value.field_mBMS->is_value();
case ApplContainer__or__ApplErrContainer__GTPC::ALT_sON:
return single_value.field_sON->is_value();
case ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI:
return single_value.field_uTRA__SI->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
}

ApplContainer__or__ApplErrContainer__GTPC ApplContainer__or__ApplErrContainer__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
ApplContainer__or__ApplErrContainer__GTPC ret_val;
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc:
ret_val.nacc() = single_value.field_nacc->valueof();
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_si3:
ret_val.si3() = single_value.field_si3->valueof();
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS:
ret_val.mBMS() = single_value.field_mBMS->valueof();
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_sON:
ret_val.sON() = single_value.field_sON->valueof();
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI:
ret_val.uTRA__SI() = single_value.field_uTRA__SI->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
return ret_val;
}

ApplContainer__or__ApplErrContainer__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
return value_list.list_value[list_index];
}
void ApplContainer__or__ApplErrContainer__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ApplContainer__or__ApplErrContainer__GTPC_template[list_length];
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::nacc()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_nacc = new ApplContainer__or__ApplErrContainer__NACC__GTPC_template(ANY_VALUE);
else single_value.field_nacc = new ApplContainer__or__ApplErrContainer__NACC__GTPC_template;
single_value.union_selection = ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_nacc;
}

const ApplContainer__or__ApplErrContainer__NACC__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::nacc() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field nacc in a non-specific template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
if (single_value.union_selection != ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc) TTCN_error("Accessing non-selected field nacc in a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
return *single_value.field_nacc;
}

ApplContainer__or__ApplErrContainer__SI3__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::si3()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != ApplContainer__or__ApplErrContainer__GTPC::ALT_si3) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_si3 = new ApplContainer__or__ApplErrContainer__SI3__GTPC_template(ANY_VALUE);
else single_value.field_si3 = new ApplContainer__or__ApplErrContainer__SI3__GTPC_template;
single_value.union_selection = ApplContainer__or__ApplErrContainer__GTPC::ALT_si3;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_si3;
}

const ApplContainer__or__ApplErrContainer__SI3__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::si3() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field si3 in a non-specific template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
if (single_value.union_selection != ApplContainer__or__ApplErrContainer__GTPC::ALT_si3) TTCN_error("Accessing non-selected field si3 in a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
return *single_value.field_si3;
}

ApplContainer__or__ApplErrContainer__MBMS__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::mBMS()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_mBMS = new ApplContainer__or__ApplErrContainer__MBMS__GTPC_template(ANY_VALUE);
else single_value.field_mBMS = new ApplContainer__or__ApplErrContainer__MBMS__GTPC_template;
single_value.union_selection = ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_mBMS;
}

const ApplContainer__or__ApplErrContainer__MBMS__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::mBMS() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field mBMS in a non-specific template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
if (single_value.union_selection != ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS) TTCN_error("Accessing non-selected field mBMS in a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
return *single_value.field_mBMS;
}

ApplContainer__or__ApplErrContainer__SON__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::sON()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != ApplContainer__or__ApplErrContainer__GTPC::ALT_sON) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_sON = new ApplContainer__or__ApplErrContainer__SON__GTPC_template(ANY_VALUE);
else single_value.field_sON = new ApplContainer__or__ApplErrContainer__SON__GTPC_template;
single_value.union_selection = ApplContainer__or__ApplErrContainer__GTPC::ALT_sON;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_sON;
}

const ApplContainer__or__ApplErrContainer__SON__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::sON() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field sON in a non-specific template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
if (single_value.union_selection != ApplContainer__or__ApplErrContainer__GTPC::ALT_sON) TTCN_error("Accessing non-selected field sON in a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
return *single_value.field_sON;
}

ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::uTRA__SI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_uTRA__SI = new ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_template(ANY_VALUE);
else single_value.field_uTRA__SI = new ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_template;
single_value.union_selection = ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_uTRA__SI;
}

const ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_template& ApplContainer__or__ApplErrContainer__GTPC_template::uTRA__SI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field uTRA_SI in a non-specific template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
if (single_value.union_selection != ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI) TTCN_error("Accessing non-selected field uTRA_SI in a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
return *single_value.field_uTRA__SI;
}

boolean ApplContainer__or__ApplErrContainer__GTPC_template::ischosen(ApplContainer__or__ApplErrContainer__GTPC::union_selection_type checked_selection) const
{
if (checked_selection == ApplContainer__or__ApplErrContainer__GTPC::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == ApplContainer__or__ApplErrContainer__GTPC::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void ApplContainer__or__ApplErrContainer__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc:
TTCN_Logger::log_event_str("{ nacc := ");
single_value.field_nacc->log();
TTCN_Logger::log_event_str(" }");
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_si3:
TTCN_Logger::log_event_str("{ si3 := ");
single_value.field_si3->log();
TTCN_Logger::log_event_str(" }");
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS:
TTCN_Logger::log_event_str("{ mBMS := ");
single_value.field_mBMS->log();
TTCN_Logger::log_event_str(" }");
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_sON:
TTCN_Logger::log_event_str("{ sON := ");
single_value.field_sON->log();
TTCN_Logger::log_event_str(" }");
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI:
TTCN_Logger::log_event_str("{ uTRA_SI := ");
single_value.field_uTRA__SI->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ApplContainer__or__ApplErrContainer__GTPC_template::log_match(const ApplContainer__or__ApplErrContainer__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".nacc");
single_value.field_nacc->log_match(match_value.nacc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ nacc := ");
single_value.field_nacc->log_match(match_value.nacc(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_si3:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".si3");
single_value.field_si3->log_match(match_value.si3(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ si3 := ");
single_value.field_si3->log_match(match_value.si3(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".mBMS");
single_value.field_mBMS->log_match(match_value.mBMS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ mBMS := ");
single_value.field_mBMS->log_match(match_value.mBMS(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_sON:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".sON");
single_value.field_sON->log_match(match_value.sON(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ sON := ");
single_value.field_sON->log_match(match_value.sON(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".uTRA_SI");
single_value.field_uTRA__SI->log_match(match_value.uTRA__SI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ uTRA_SI := ");
single_value.field_uTRA__SI->log_match(match_value.uTRA__SI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ApplContainer__or__ApplErrContainer__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc:
single_value.field_nacc->set_implicit_omit(); break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_si3:
single_value.field_si3->set_implicit_omit(); break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS:
single_value.field_mBMS->set_implicit_omit(); break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_sON:
single_value.field_sON->set_implicit_omit(); break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI:
single_value.field_uTRA__SI->set_implicit_omit(); break;
default: break;
}
}

void ApplContainer__or__ApplErrContainer__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc:
single_value.field_nacc->encode_text(text_buf);
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_si3:
single_value.field_si3->encode_text(text_buf);
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS:
single_value.field_mBMS->encode_text(text_buf);
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_sON:
single_value.field_sON->encode_text(text_buf);
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI:
single_value.field_uTRA__SI->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
}

void ApplContainer__or__ApplErrContainer__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = ApplContainer__or__ApplErrContainer__GTPC::UNBOUND_VALUE;
ApplContainer__or__ApplErrContainer__GTPC::union_selection_type new_selection = (ApplContainer__or__ApplErrContainer__GTPC::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc:
single_value.field_nacc = new ApplContainer__or__ApplErrContainer__NACC__GTPC_template;
single_value.field_nacc->decode_text(text_buf);
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_si3:
single_value.field_si3 = new ApplContainer__or__ApplErrContainer__SI3__GTPC_template;
single_value.field_si3->decode_text(text_buf);
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS:
single_value.field_mBMS = new ApplContainer__or__ApplErrContainer__MBMS__GTPC_template;
single_value.field_mBMS->decode_text(text_buf);
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_sON:
single_value.field_sON = new ApplContainer__or__ApplErrContainer__SON__GTPC_template;
single_value.field_sON->decode_text(text_buf);
break;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI:
single_value.field_uTRA__SI = new ApplContainer__or__ApplErrContainer__UTRA__SI__GTPC_template;
single_value.field_uTRA__SI->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ApplContainer__or__ApplErrContainer__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
}

boolean ApplContainer__or__ApplErrContainer__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ApplContainer__or__ApplErrContainer__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void ApplContainer__or__ApplErrContainer__GTPC_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC'");
    }
    if (strcmp("nacc", param_field) == 0) {
      nacc().set_param(param);
      return;
    } else if (strcmp("si3", param_field) == 0) {
      si3().set_param(param);
      return;
    } else if (strcmp("mBMS", param_field) == 0) {
      mBMS().set_param(param);
      return;
    } else if (strcmp("sON", param_field) == 0) {
      sON().set_param(param);
      return;
    } else if (strcmp("uTRA_SI", param_field) == 0) {
      uTRA__SI().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ApplContainer__or__ApplErrContainer__GTPC_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "nacc")) {
      nacc().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "si3")) {
      si3().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "mBMS")) {
      mBMS().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "sON")) {
      sON().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "uTRA_SI")) {
      uTRA__SI().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    ApplContainer__or__ApplErrContainer__GTPC_template* precondition = new ApplContainer__or__ApplErrContainer__GTPC_template;
    precondition->set_param(*m_p->get_elem(0));
    ApplContainer__or__ApplErrContainer__GTPC_template* implied_template = new ApplContainer__or__ApplErrContainer__GTPC_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = ApplContainer__or__ApplErrContainer__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void ApplContainer__or__ApplErrContainer__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__GTPC::ALT_nacc:
single_value.field_nacc->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC");
return;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_si3:
single_value.field_si3->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC");
return;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_mBMS:
single_value.field_mBMS->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC");
return;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_sON:
single_value.field_sON->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC");
return;
case ApplContainer__or__ApplErrContainer__GTPC::ALT_uTRA__SI:
single_value.field_uTRA__SI->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.ApplContainer_or_ApplErrContainer_GTPC");
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC::copy_value(const ApplContainer__or__ApplErrContainer__NACC__GTPC& other_value)
{
switch (other_value.union_selection) {
case ALT_application__Container:
field_application__Container = new RAN__Information__Application__Container__NACC__GTPC(*other_value.field_application__Container);
break;
case ALT_application__Error__Container:
field_application__Error__Container = new Application__Error__Container__NACC__GTPC(*other_value.field_application__Error__Container);
break;
default:
TTCN_error("Assignment of an unbound union value of type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
union_selection = other_value.union_selection;
}

ApplContainer__or__ApplErrContainer__NACC__GTPC::ApplContainer__or__ApplErrContainer__NACC__GTPC()
{
union_selection = UNBOUND_VALUE;
}

ApplContainer__or__ApplErrContainer__NACC__GTPC::ApplContainer__or__ApplErrContainer__NACC__GTPC(const ApplContainer__or__ApplErrContainer__NACC__GTPC& other_value)
: Base_Type(){
copy_value(other_value);
}

ApplContainer__or__ApplErrContainer__NACC__GTPC::~ApplContainer__or__ApplErrContainer__NACC__GTPC()
{
clean_up();
}

ApplContainer__or__ApplErrContainer__NACC__GTPC& ApplContainer__or__ApplErrContainer__NACC__GTPC::operator=(const ApplContainer__or__ApplErrContainer__NACC__GTPC& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean ApplContainer__or__ApplErrContainer__NACC__GTPC::operator==(const ApplContainer__or__ApplErrContainer__NACC__GTPC& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_application__Container:
return *field_application__Container == *other_value.field_application__Container;
case ALT_application__Error__Container:
return *field_application__Error__Container == *other_value.field_application__Error__Container;
default:
return FALSE;
}
}

RAN__Information__Application__Container__NACC__GTPC& ApplContainer__or__ApplErrContainer__NACC__GTPC::application__Container()
{
if (union_selection != ALT_application__Container) {
clean_up();
field_application__Container = new RAN__Information__Application__Container__NACC__GTPC;
union_selection = ALT_application__Container;
}
return *field_application__Container;
}

const RAN__Information__Application__Container__NACC__GTPC& ApplContainer__or__ApplErrContainer__NACC__GTPC::application__Container() const
{
if (union_selection != ALT_application__Container) TTCN_error("Using non-selected field application_Container in a value of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
return *field_application__Container;
}

Application__Error__Container__NACC__GTPC& ApplContainer__or__ApplErrContainer__NACC__GTPC::application__Error__Container()
{
if (union_selection != ALT_application__Error__Container) {
clean_up();
field_application__Error__Container = new Application__Error__Container__NACC__GTPC;
union_selection = ALT_application__Error__Container;
}
return *field_application__Error__Container;
}

const Application__Error__Container__NACC__GTPC& ApplContainer__or__ApplErrContainer__NACC__GTPC::application__Error__Container() const
{
if (union_selection != ALT_application__Error__Container) TTCN_error("Using non-selected field application_Error_Container in a value of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
return *field_application__Error__Container;
}

boolean ApplContainer__or__ApplErrContainer__NACC__GTPC::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
return union_selection == checked_selection;
}

boolean ApplContainer__or__ApplErrContainer__NACC__GTPC::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean ApplContainer__or__ApplErrContainer__NACC__GTPC::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_application__Container: return field_application__Container->is_value();
case ALT_application__Error__Container: return field_application__Error__Container->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC::clean_up()
{
switch (union_selection) {
case ALT_application__Container:
  delete field_application__Container;
  break;
case ALT_application__Error__Container:
  delete field_application__Error__Container;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC::log() const
{
switch (union_selection) {
case ALT_application__Container:
TTCN_Logger::log_event_str("{ application_Container := ");
field_application__Container->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_application__Error__Container:
TTCN_Logger::log_event_str("{ application_Error_Container := ");
field_application__Error__Container->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "application_Container")) {
    application__Container().set_param(*mp_last);
    if (!application__Container().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "application_Error_Container")) {
    application__Error__Container().set_param(*mp_last);
    if (!application__Error__Container().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.", last_name);
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC::set_implicit_omit()
{
switch (union_selection) {
case ALT_application__Container:
field_application__Container->set_implicit_omit(); break;
case ALT_application__Error__Container:
field_application__Error__Container->set_implicit_omit(); break;
default: break;
}
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_application__Container:
field_application__Container->encode_text(text_buf);
break;
case ALT_application__Error__Container:
field_application__Error__Container->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_application__Container:
application__Container().decode_text(text_buf);
break;
case ALT_application__Error__Container:
application__Error__Container().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ApplContainer__or__ApplErrContainer__NACC__GTPC::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, RAN__Information__Application__Container__NACC__GTPC_descr_.raw->forceomit);
      decoded_length = application__Container().RAW_decode(RAN__Information__Application__Container__NACC__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, Application__Error__Container__NACC__GTPC_descr_.raw->forceomit);
      decoded_length = application__Error__Container().RAW_decode(Application__Error__Container__NACC__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
    boolean already_failed = FALSE;
    OCTETSTRING temporal_0;
    int decoded_0_length;
    already_failed = FALSE;
    if (!already_failed) {
      p_buf.set_pos_bit(starting_pos + 0);
      decoded_0_length = temporal_0.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, top_bit_ord, TRUE);
      if (decoded_0_length > 0) {
        if (temporal_0 ==  os_107) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(0, force_omit, RAN__Information__Application__Container__NACC__GTPC_descr_.raw->forceomit);
          decoded_length = application__Container().RAW_decode(RAN__Information__Application__Container__NACC__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_application__Container).iEI() ==  os_107) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  os_108) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(1, force_omit, Application__Error__Container__NACC__GTPC_descr_.raw->forceomit);
          decoded_length = application__Error__Container().RAW_decode(Application__Error__Container__NACC__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_application__Error__Container).iEI() ==  os_108) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
 }
 clean_up();
 return -1;
}

int ApplContainer__or__ApplErrContainer__NACC__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  memset(myleaf.body.node.nodes, 0, 2 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_application__Container:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, RAN__Information__Application__Container__NACC__GTPC_descr_.raw);
    encoded_length = field_application__Container->RAW_encode(RAN__Information__Application__Container__NACC__GTPC_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &RAN__Information__Application__Container__NACC__GTPC_descr_;
    if ((*field_application__Container).iEI() !=  os_107) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_107.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_application__Error__Container:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, Application__Error__Container__NACC__GTPC_descr_.raw);
    encoded_length = field_application__Error__Container->RAW_encode(Application__Error__Container__NACC__GTPC_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &Application__Error__Container__NACC__GTPC_descr_;
    if ((*field_application__Error__Container).iEI() !=  os_108) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={1,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_108.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC_template::copy_value(const ApplContainer__or__ApplErrContainer__NACC__GTPC& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container:
single_value.field_application__Container = new RAN__Information__Application__Container__NACC__GTPC_template(other_value.application__Container());
break;
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container:
single_value.field_application__Error__Container = new Application__Error__Container__NACC__GTPC_template(other_value.application__Error__Container());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
set_selection(SPECIFIC_VALUE);
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC_template::copy_template(const ApplContainer__or__ApplErrContainer__NACC__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container:
single_value.field_application__Container = new RAN__Information__Application__Container__NACC__GTPC_template(*other_value.single_value.field_application__Container);
break;
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container:
single_value.field_application__Error__Container = new Application__Error__Container__NACC__GTPC_template(*other_value.single_value.field_application__Error__Container);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ApplContainer__or__ApplErrContainer__NACC__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ApplContainer__or__ApplErrContainer__NACC__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new ApplContainer__or__ApplErrContainer__NACC__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
set_selection(other_value);
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template::ApplContainer__or__ApplErrContainer__NACC__GTPC_template()
{
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template::ApplContainer__or__ApplErrContainer__NACC__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template::ApplContainer__or__ApplErrContainer__NACC__GTPC_template(const ApplContainer__or__ApplErrContainer__NACC__GTPC& other_value)
{
copy_value(other_value);
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template::ApplContainer__or__ApplErrContainer__NACC__GTPC_template(const OPTIONAL<ApplContainer__or__ApplErrContainer__NACC__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ApplContainer__or__ApplErrContainer__NACC__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC from an unbound optional field.");
}
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template::ApplContainer__or__ApplErrContainer__NACC__GTPC_template(ApplContainer__or__ApplErrContainer__NACC__GTPC_template* p_precondition, ApplContainer__or__ApplErrContainer__NACC__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template::ApplContainer__or__ApplErrContainer__NACC__GTPC_template(Dynamic_Match_Interface<ApplContainer__or__ApplErrContainer__NACC__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ApplContainer__or__ApplErrContainer__NACC__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template::ApplContainer__or__ApplErrContainer__NACC__GTPC_template(const ApplContainer__or__ApplErrContainer__NACC__GTPC_template& other_value)
: Base_Template(){
copy_template(other_value);
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template::~ApplContainer__or__ApplErrContainer__NACC__GTPC_template()
{
clean_up();
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container:
delete single_value.field_application__Container;
break;
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container:
delete single_value.field_application__Error__Container;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template& ApplContainer__or__ApplErrContainer__NACC__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template& ApplContainer__or__ApplErrContainer__NACC__GTPC_template::operator=(const ApplContainer__or__ApplErrContainer__NACC__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template& ApplContainer__or__ApplErrContainer__NACC__GTPC_template::operator=(const OPTIONAL<ApplContainer__or__ApplErrContainer__NACC__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ApplContainer__or__ApplErrContainer__NACC__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
return *this;
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template& ApplContainer__or__ApplErrContainer__NACC__GTPC_template::operator=(const ApplContainer__or__ApplErrContainer__NACC__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ApplContainer__or__ApplErrContainer__NACC__GTPC_template::match(const ApplContainer__or__ApplErrContainer__NACC__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
ApplContainer__or__ApplErrContainer__NACC__GTPC::union_selection_type value_selection = other_value.get_selection();
if (value_selection == ApplContainer__or__ApplErrContainer__NACC__GTPC::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container:
return single_value.field_application__Container->match(other_value.application__Container(), legacy);
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container:
return single_value.field_application__Error__Container->match(other_value.application__Error__Container(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
return FALSE;
}

boolean ApplContainer__or__ApplErrContainer__NACC__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container:
return single_value.field_application__Container->is_value();
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container:
return single_value.field_application__Error__Container->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
}

ApplContainer__or__ApplErrContainer__NACC__GTPC ApplContainer__or__ApplErrContainer__NACC__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
ApplContainer__or__ApplErrContainer__NACC__GTPC ret_val;
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container:
ret_val.application__Container() = single_value.field_application__Container->valueof();
break;
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container:
ret_val.application__Error__Container() = single_value.field_application__Error__Container->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
return ret_val;
}

ApplContainer__or__ApplErrContainer__NACC__GTPC_template& ApplContainer__or__ApplErrContainer__NACC__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
return value_list.list_value[list_index];
}
void ApplContainer__or__ApplErrContainer__NACC__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ApplContainer__or__ApplErrContainer__NACC__GTPC_template[list_length];
}

RAN__Information__Application__Container__NACC__GTPC_template& ApplContainer__or__ApplErrContainer__NACC__GTPC_template::application__Container()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_application__Container = new RAN__Information__Application__Container__NACC__GTPC_template(ANY_VALUE);
else single_value.field_application__Container = new RAN__Information__Application__Container__NACC__GTPC_template;
single_value.union_selection = ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_application__Container;
}

const RAN__Information__Application__Container__NACC__GTPC_template& ApplContainer__or__ApplErrContainer__NACC__GTPC_template::application__Container() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field application_Container in a non-specific template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
if (single_value.union_selection != ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container) TTCN_error("Accessing non-selected field application_Container in a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
return *single_value.field_application__Container;
}

Application__Error__Container__NACC__GTPC_template& ApplContainer__or__ApplErrContainer__NACC__GTPC_template::application__Error__Container()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_application__Error__Container = new Application__Error__Container__NACC__GTPC_template(ANY_VALUE);
else single_value.field_application__Error__Container = new Application__Error__Container__NACC__GTPC_template;
single_value.union_selection = ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_application__Error__Container;
}

const Application__Error__Container__NACC__GTPC_template& ApplContainer__or__ApplErrContainer__NACC__GTPC_template::application__Error__Container() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field application_Error_Container in a non-specific template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
if (single_value.union_selection != ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container) TTCN_error("Accessing non-selected field application_Error_Container in a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
return *single_value.field_application__Error__Container;
}

boolean ApplContainer__or__ApplErrContainer__NACC__GTPC_template::ischosen(ApplContainer__or__ApplErrContainer__NACC__GTPC::union_selection_type checked_selection) const
{
if (checked_selection == ApplContainer__or__ApplErrContainer__NACC__GTPC::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == ApplContainer__or__ApplErrContainer__NACC__GTPC::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container:
TTCN_Logger::log_event_str("{ application_Container := ");
single_value.field_application__Container->log();
TTCN_Logger::log_event_str(" }");
break;
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container:
TTCN_Logger::log_event_str("{ application_Error_Container := ");
single_value.field_application__Error__Container->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC_template::log_match(const ApplContainer__or__ApplErrContainer__NACC__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".application_Container");
single_value.field_application__Container->log_match(match_value.application__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ application_Container := ");
single_value.field_application__Container->log_match(match_value.application__Container(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".application_Error_Container");
single_value.field_application__Error__Container->log_match(match_value.application__Error__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ application_Error_Container := ");
single_value.field_application__Error__Container->log_match(match_value.application__Error__Container(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container:
single_value.field_application__Container->set_implicit_omit(); break;
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container:
single_value.field_application__Error__Container->set_implicit_omit(); break;
default: break;
}
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container:
single_value.field_application__Container->encode_text(text_buf);
break;
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container:
single_value.field_application__Error__Container->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = ApplContainer__or__ApplErrContainer__NACC__GTPC::UNBOUND_VALUE;
ApplContainer__or__ApplErrContainer__NACC__GTPC::union_selection_type new_selection = (ApplContainer__or__ApplErrContainer__NACC__GTPC::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container:
single_value.field_application__Container = new RAN__Information__Application__Container__NACC__GTPC_template;
single_value.field_application__Container->decode_text(text_buf);
break;
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container:
single_value.field_application__Error__Container = new Application__Error__Container__NACC__GTPC_template;
single_value.field_application__Error__Container->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ApplContainer__or__ApplErrContainer__NACC__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
}

boolean ApplContainer__or__ApplErrContainer__NACC__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ApplContainer__or__ApplErrContainer__NACC__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC'");
    }
    if (strcmp("application_Container", param_field) == 0) {
      application__Container().set_param(param);
      return;
    } else if (strcmp("application_Error_Container", param_field) == 0) {
      application__Error__Container().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ApplContainer__or__ApplErrContainer__NACC__GTPC_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "application_Container")) {
      application__Container().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "application_Error_Container")) {
      application__Error__Container().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    ApplContainer__or__ApplErrContainer__NACC__GTPC_template* precondition = new ApplContainer__or__ApplErrContainer__NACC__GTPC_template;
    precondition->set_param(*m_p->get_elem(0));
    ApplContainer__or__ApplErrContainer__NACC__GTPC_template* implied_template = new ApplContainer__or__ApplErrContainer__NACC__GTPC_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = ApplContainer__or__ApplErrContainer__NACC__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void ApplContainer__or__ApplErrContainer__NACC__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Container:
single_value.field_application__Container->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC");
return;
case ApplContainer__or__ApplErrContainer__NACC__GTPC::ALT_application__Error__Container:
single_value.field_application__Error__Container->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.ApplContainer_or_ApplErrContainer_NACC_GTPC");
}

RAN__Information__Application__Container__NACC__GTPC::RAN__Information__Application__Container__NACC__GTPC()
{
}

RAN__Information__Application__Container__NACC__GTPC::RAN__Information__Application__Container__NACC__GTPC(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a__GTPC& par_lengthIndicator,
    const Cell__Identifier__V__GTPC& par_reporting__Cell__Identifier,
    const BITSTRING& par_typeBit,
    const BITSTRING& par_number__of__SI__PSI,
    const OCTETSTRING& par_sI__PSI)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_reporting__Cell__Identifier(par_reporting__Cell__Identifier),
  field_typeBit(par_typeBit),
  field_number__of__SI__PSI(par_number__of__SI__PSI),
  field_sI__PSI(par_sI__PSI)
{
}

RAN__Information__Application__Container__NACC__GTPC::RAN__Information__Application__Container__NACC__GTPC(const RAN__Information__Application__Container__NACC__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.RAN_Information_Application_Container_NACC_GTPC.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.reporting__Cell__Identifier().is_bound()) field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
else field_reporting__Cell__Identifier.clean_up();
if (other_value.typeBit().is_bound()) field_typeBit = other_value.typeBit();
else field_typeBit.clean_up();
if (other_value.number__of__SI__PSI().is_bound()) field_number__of__SI__PSI = other_value.number__of__SI__PSI();
else field_number__of__SI__PSI.clean_up();
if (other_value.sI__PSI().is_bound()) field_sI__PSI = other_value.sI__PSI();
else field_sI__PSI.clean_up();
}

void RAN__Information__Application__Container__NACC__GTPC::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_reporting__Cell__Identifier.clean_up();
field_typeBit.clean_up();
field_number__of__SI__PSI.clean_up();
field_sI__PSI.clean_up();
}

const TTCN_Typedescriptor_t* RAN__Information__Application__Container__NACC__GTPC::get_descriptor() const { return &RAN__Information__Application__Container__NACC__GTPC_descr_; }
RAN__Information__Application__Container__NACC__GTPC& RAN__Information__Application__Container__NACC__GTPC::operator=(const RAN__Information__Application__Container__NACC__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.RAN_Information_Application_Container_NACC_GTPC.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.reporting__Cell__Identifier().is_bound()) field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
  else field_reporting__Cell__Identifier.clean_up();
  if (other_value.typeBit().is_bound()) field_typeBit = other_value.typeBit();
  else field_typeBit.clean_up();
  if (other_value.number__of__SI__PSI().is_bound()) field_number__of__SI__PSI = other_value.number__of__SI__PSI();
  else field_number__of__SI__PSI.clean_up();
  if (other_value.sI__PSI().is_bound()) field_sI__PSI = other_value.sI__PSI();
  else field_sI__PSI.clean_up();
}
return *this;
}

boolean RAN__Information__Application__Container__NACC__GTPC::operator==(const RAN__Information__Application__Container__NACC__GTPC& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_reporting__Cell__Identifier==other_value.field_reporting__Cell__Identifier
  && field_typeBit==other_value.field_typeBit
  && field_number__of__SI__PSI==other_value.field_number__of__SI__PSI
  && field_sI__PSI==other_value.field_sI__PSI;
}

boolean RAN__Information__Application__Container__NACC__GTPC::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_reporting__Cell__Identifier.is_bound())
  || (field_typeBit.is_bound())
  || (field_number__of__SI__PSI.is_bound())
  || (field_sI__PSI.is_bound());
}
boolean RAN__Information__Application__Container__NACC__GTPC::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_reporting__Cell__Identifier.is_value()
  && field_typeBit.is_value()
  && field_number__of__SI__PSI.is_value()
  && field_sI__PSI.is_value();
}
void RAN__Information__Application__Container__NACC__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reporting_Cell_Identifier := ");
field_reporting__Cell__Identifier.log();
TTCN_Logger::log_event_str(", typeBit := ");
field_typeBit.log();
TTCN_Logger::log_event_str(", number_of_SI_PSI := ");
field_number__of__SI__PSI.log();
TTCN_Logger::log_event_str(", sI_PSI := ");
field_sI__PSI.log();
TTCN_Logger::log_event_str(" }");
}

void RAN__Information__Application__Container__NACC__GTPC::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reporting__Cell__Identifier().is_bound()) reporting__Cell__Identifier().set_implicit_omit();
if (typeBit().is_bound()) typeBit().set_implicit_omit();
if (number__of__SI__PSI().is_bound()) number__of__SI__PSI().set_implicit_omit();
if (sI__PSI().is_bound()) sI__PSI().set_implicit_omit();
}

void RAN__Information__Application__Container__NACC__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record value of type @GTPC_Types.RAN_Information_Application_Container_NACC_GTPC has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reporting__Cell__Identifier().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) typeBit().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) number__of__SI__PSI().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) sI__PSI().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_Cell_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__Cell__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "typeBit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          typeBit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "number_of_SI_PSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          number__of__SI__PSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sI_PSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sI__PSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RAN_Information_Application_Container_NACC_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.RAN_Information_Application_Container_NACC_GTPC");
  }
}

void RAN__Information__Application__Container__NACC__GTPC::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_reporting__Cell__Identifier.encode_text(text_buf);
field_typeBit.encode_text(text_buf);
field_number__of__SI__PSI.encode_text(text_buf);
field_sI__PSI.encode_text(text_buf);
}

void RAN__Information__Application__Container__NACC__GTPC::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_reporting__Cell__Identifier.decode_text(text_buf);
field_typeBit.decode_text(text_buf);
field_number__of__SI__PSI.decode_text(text_buf);
field_sI__PSI.decode_text(text_buf);
}

void RAN__Information__Application__Container__NACC__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RAN__Information__Application__Container__NACC__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RAN__Information__Application__Container__NACC__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RAN__Information__Application__Container__NACC__GTPC_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(RAN__Information__Application__Container__NACC__GTPC_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_3) selected_field = 0;
  else if (field_ext ==  bs_24) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RAN__Information__Application__Container__NACC__GTPC_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(RAN__Information__Application__Container__NACC__GTPC_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a__GTPC_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a__GTPC::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a__GTPC_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, Cell__Identifier__V__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_reporting__Cell__Identifier.RAW_decode(Cell__Identifier__V__GTPC_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_typeBit.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_number__of__SI__PSI.RAW_decode(General__Types::BIT7_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_6_force_omit(6, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_sI__PSI.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RAN__Information__Application__Container__NACC__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 7;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(7);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RAN__Information__Application__Container__NACC__GTPC_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RAN__Information__Application__Container__NACC__GTPC_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, Cell__Identifier__V__GTPC_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::BIT7_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, OCTETSTRING_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(RAN__Information__Application__Container__NACC__GTPC_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(RAN__Information__Application__Container__NACC__GTPC_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_reporting__Cell__Identifier.RAW_encode(Cell__Identifier__V__GTPC_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_typeBit.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_number__of__SI__PSI.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_sI__PSI.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[6]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a__GTPC::ALT_length1:
  if (field_ext !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(RAN__Information__Application__Container__NACC__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a__GTPC::ALT_length2:
  if (field_ext !=  bs_24) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_24.RAW_encode(RAN__Information__Application__Container__NACC__GTPC_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  return myleaf.length = encoded_length;
}

struct RAN__Information__Application__Container__NACC__GTPC_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a__GTPC_template field_lengthIndicator;
Cell__Identifier__V__GTPC_template field_reporting__Cell__Identifier;
BITSTRING_template field_typeBit;
BITSTRING_template field_number__of__SI__PSI;
OCTETSTRING_template field_sI__PSI;
};

void RAN__Information__Application__Container__NACC__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_reporting__Cell__Identifier = ANY_VALUE;
single_value->field_typeBit = ANY_VALUE;
single_value->field_number__of__SI__PSI = ANY_VALUE;
single_value->field_sI__PSI = ANY_VALUE;
}
}
}

void RAN__Information__Application__Container__NACC__GTPC_template::copy_value(const RAN__Information__Application__Container__NACC__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.reporting__Cell__Identifier().is_bound()) {
  single_value->field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
} else {
  single_value->field_reporting__Cell__Identifier.clean_up();
}
if (other_value.typeBit().is_bound()) {
  single_value->field_typeBit = other_value.typeBit();
} else {
  single_value->field_typeBit.clean_up();
}
if (other_value.number__of__SI__PSI().is_bound()) {
  single_value->field_number__of__SI__PSI = other_value.number__of__SI__PSI();
} else {
  single_value->field_number__of__SI__PSI.clean_up();
}
if (other_value.sI__PSI().is_bound()) {
  single_value->field_sI__PSI = other_value.sI__PSI();
} else {
  single_value->field_sI__PSI.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RAN__Information__Application__Container__NACC__GTPC_template::copy_template(const RAN__Information__Application__Container__NACC__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reporting__Cell__Identifier().get_selection()) {
single_value->field_reporting__Cell__Identifier = other_value.reporting__Cell__Identifier();
} else {
single_value->field_reporting__Cell__Identifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.typeBit().get_selection()) {
single_value->field_typeBit = other_value.typeBit();
} else {
single_value->field_typeBit.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.number__of__SI__PSI().get_selection()) {
single_value->field_number__of__SI__PSI = other_value.number__of__SI__PSI();
} else {
single_value->field_number__of__SI__PSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sI__PSI().get_selection()) {
single_value->field_sI__PSI = other_value.sI__PSI();
} else {
single_value->field_sI__PSI.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RAN__Information__Application__Container__NACC__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RAN__Information__Application__Container__NACC__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new RAN__Information__Application__Container__NACC__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Application_Container_NACC_GTPC.");
break;
}
set_selection(other_value);
}

RAN__Information__Application__Container__NACC__GTPC_template::RAN__Information__Application__Container__NACC__GTPC_template()
{
}

RAN__Information__Application__Container__NACC__GTPC_template::RAN__Information__Application__Container__NACC__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RAN__Information__Application__Container__NACC__GTPC_template::RAN__Information__Application__Container__NACC__GTPC_template(const RAN__Information__Application__Container__NACC__GTPC& other_value)
{
copy_value(other_value);
}

RAN__Information__Application__Container__NACC__GTPC_template::RAN__Information__Application__Container__NACC__GTPC_template(const OPTIONAL<RAN__Information__Application__Container__NACC__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Application__Container__NACC__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.RAN_Information_Application_Container_NACC_GTPC from an unbound optional field.");
}
}

RAN__Information__Application__Container__NACC__GTPC_template::RAN__Information__Application__Container__NACC__GTPC_template(RAN__Information__Application__Container__NACC__GTPC_template* p_precondition, RAN__Information__Application__Container__NACC__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RAN__Information__Application__Container__NACC__GTPC_template::RAN__Information__Application__Container__NACC__GTPC_template(Dynamic_Match_Interface<RAN__Information__Application__Container__NACC__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RAN__Information__Application__Container__NACC__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RAN__Information__Application__Container__NACC__GTPC_template::RAN__Information__Application__Container__NACC__GTPC_template(const RAN__Information__Application__Container__NACC__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RAN__Information__Application__Container__NACC__GTPC_template::~RAN__Information__Application__Container__NACC__GTPC_template()
{
clean_up();
}

RAN__Information__Application__Container__NACC__GTPC_template& RAN__Information__Application__Container__NACC__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RAN__Information__Application__Container__NACC__GTPC_template& RAN__Information__Application__Container__NACC__GTPC_template::operator=(const RAN__Information__Application__Container__NACC__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RAN__Information__Application__Container__NACC__GTPC_template& RAN__Information__Application__Container__NACC__GTPC_template::operator=(const OPTIONAL<RAN__Information__Application__Container__NACC__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RAN__Information__Application__Container__NACC__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.RAN_Information_Application_Container_NACC_GTPC.");
}
return *this;
}

RAN__Information__Application__Container__NACC__GTPC_template& RAN__Information__Application__Container__NACC__GTPC_template::operator=(const RAN__Information__Application__Container__NACC__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RAN__Information__Application__Container__NACC__GTPC_template::match(const RAN__Information__Application__Container__NACC__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.reporting__Cell__Identifier().is_bound()) return FALSE;
if(!single_value->field_reporting__Cell__Identifier.match(other_value.reporting__Cell__Identifier(), legacy))return FALSE;
if(!other_value.typeBit().is_bound()) return FALSE;
if(!single_value->field_typeBit.match(other_value.typeBit(), legacy))return FALSE;
if(!other_value.number__of__SI__PSI().is_bound()) return FALSE;
if(!single_value->field_number__of__SI__PSI.match(other_value.number__of__SI__PSI(), legacy))return FALSE;
if(!other_value.sI__PSI().is_bound()) return FALSE;
if(!single_value->field_sI__PSI.match(other_value.sI__PSI(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.RAN_Information_Application_Container_NACC_GTPC.");
}
return FALSE;
}

boolean RAN__Information__Application__Container__NACC__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_reporting__Cell__Identifier.is_bound()
 || single_value->field_typeBit.is_bound()
 || single_value->field_number__of__SI__PSI.is_bound()
 || single_value->field_sI__PSI.is_bound();
}

boolean RAN__Information__Application__Container__NACC__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_reporting__Cell__Identifier.is_value()
 && single_value->field_typeBit.is_value()
 && single_value->field_number__of__SI__PSI.is_value()
 && single_value->field_sI__PSI.is_value();
}

void RAN__Information__Application__Container__NACC__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RAN__Information__Application__Container__NACC__GTPC RAN__Information__Application__Container__NACC__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.RAN_Information_Application_Container_NACC_GTPC.");
RAN__Information__Application__Container__NACC__GTPC ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueo