// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "GTPC_Types.hh"

namespace GTPC__Types {

/* Member functions of C++ classes */


const XID__GTPC XID__Information__GTPC::UNBOUND_ELEM;
XID__Information__GTPC::XID__Information__GTPC()
{
val_ptr = NULL;
}

XID__Information__GTPC::XID__Information__GTPC(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

XID__Information__GTPC::XID__Information__GTPC(const XID__Information__GTPC& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.XID_Information_GTPC.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

XID__Information__GTPC::~XID__Information__GTPC()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void XID__Information__GTPC::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

XID__Information__GTPC& XID__Information__GTPC::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

XID__Information__GTPC& XID__Information__GTPC::operator=(const XID__Information__GTPC& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @GTPC_Types.XID_Information_GTPC.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean XID__Information__GTPC::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @GTPC_Types.XID_Information_GTPC.");
return val_ptr->n_elements == 0 ;
}

boolean XID__Information__GTPC::operator==(const XID__Information__GTPC& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @GTPC_Types.XID_Information_GTPC.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @GTPC_Types.XID_Information_GTPC.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

XID__GTPC& XID__Information__GTPC::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @GTPC_Types.XID_Information_GTPC using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (XID__GTPC**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new XID__GTPC(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new XID__GTPC;
}
return *val_ptr->value_elements[index_value];
}

XID__GTPC& XID__Information__GTPC::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @GTPC_Types.XID_Information_GTPC.");
return (*this)[(int)index_value];
}

const XID__GTPC& XID__Information__GTPC::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @GTPC_Types.XID_Information_GTPC.");
if (index_value < 0) TTCN_error("Accessing an element of type @GTPC_Types.XID_Information_GTPC using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @GTPC_Types.XID_Information_GTPC: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const XID__GTPC& XID__Information__GTPC::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @GTPC_Types.XID_Information_GTPC.");
return (*this)[(int)index_value];
}

XID__Information__GTPC XID__Information__GTPC::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

XID__Information__GTPC XID__Information__GTPC::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

XID__Information__GTPC XID__Information__GTPC::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

XID__Information__GTPC XID__Information__GTPC::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @GTPC_Types.XID_Information_GTPC.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
XID__Information__GTPC ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new XID__GTPC(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

XID__Information__GTPC XID__Information__GTPC::operator+(const XID__Information__GTPC& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @GTPC_Types.XID_Information_GTPC concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
XID__Information__GTPC ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new XID__GTPC(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new XID__GTPC(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

XID__Information__GTPC XID__Information__GTPC::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @GTPC_Types.XID_Information_GTPC.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@GTPC_Types.XID_Information_GTPC","element");
XID__Information__GTPC ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new XID__GTPC(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

XID__Information__GTPC XID__Information__GTPC::replace(int index, int len, const XID__Information__GTPC& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @GTPC_Types.XID_Information_GTPC.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @GTPC_Types.XID_Information_GTPC.");
check_replace_arguments(val_ptr->n_elements, index, len, "@GTPC_Types.XID_Information_GTPC","element");
XID__Information__GTPC ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new XID__GTPC(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new XID__GTPC(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new XID__GTPC(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

XID__Information__GTPC XID__Information__GTPC::replace(int index, int len, const XID__Information__GTPC_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void XID__Information__GTPC::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @GTPC_Types.XID_Information_GTPC.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (XID__GTPC**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new XID__GTPC(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (XID__GTPC**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @GTPC_Types.XID_Information_GTPC: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (XID__GTPC**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean XID__Information__GTPC::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int XID__Information__GTPC::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @GTPC_Types.XID_Information_GTPC.");
return val_ptr->n_elements;
}

int XID__Information__GTPC::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @GTPC_Types.XID_Information_GTPC.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void XID__Information__GTPC::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void XID__Information__GTPC::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void XID__Information__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@GTPC_Types.XID_Information_GTPC");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@GTPC_Types.XID_Information_GTPC");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void XID__Information__GTPC::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @GTPC_Types.XID_Information_GTPC.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void XID__Information__GTPC::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @GTPC_Types.XID_Information_GTPC.");
val_ptr->value_elements = (XID__GTPC**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new XID__GTPC;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void XID__Information__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void XID__Information__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int XID__Information__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int XID__Information__GTPC::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void XID__Information__GTPC_template::copy_value(const XID__Information__GTPC& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @GTPC_Types.XID_Information_GTPC with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (XID__GTPC_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new XID__GTPC_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new XID__GTPC_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void XID__Information__GTPC_template::copy_template(const XID__Information__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (XID__GTPC_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new XID__GTPC_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new XID__GTPC_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new XID__Information__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new XID__Information__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new XID__Information__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.XID_Information_GTPC.");
break;
}
set_selection(other_value);
}

boolean XID__Information__GTPC_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const XID__Information__GTPC_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const XID__Information__GTPC*)value_ptr)[value_index], legacy);
else return ((const XID__Information__GTPC_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

XID__Information__GTPC_template::XID__Information__GTPC_template()
{
}

XID__Information__GTPC_template::XID__Information__GTPC_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

XID__Information__GTPC_template::XID__Information__GTPC_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

XID__Information__GTPC_template::XID__Information__GTPC_template(const XID__Information__GTPC& other_value)
{
copy_value(other_value);
}

XID__Information__GTPC_template::XID__Information__GTPC_template(const OPTIONAL<XID__Information__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const XID__Information__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.XID_Information_GTPC from an unbound optional field.");
}
}

XID__Information__GTPC_template::XID__Information__GTPC_template(XID__Information__GTPC_template* p_precondition, XID__Information__GTPC_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

XID__Information__GTPC_template::XID__Information__GTPC_template(Dynamic_Match_Interface<XID__Information__GTPC>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<XID__Information__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

XID__Information__GTPC_template::XID__Information__GTPC_template(const XID__Information__GTPC_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

XID__Information__GTPC_template::~XID__Information__GTPC_template()
{
clean_up();
}

void XID__Information__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

XID__Information__GTPC_template& XID__Information__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

XID__Information__GTPC_template& XID__Information__GTPC_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

XID__Information__GTPC_template& XID__Information__GTPC_template::operator=(const XID__Information__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

XID__Information__GTPC_template& XID__Information__GTPC_template::operator=(const OPTIONAL<XID__Information__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const XID__Information__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.XID_Information_GTPC.");
}
return *this;
}

XID__Information__GTPC_template& XID__Information__GTPC_template::operator=(const XID__Information__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

XID__GTPC_template& XID__Information__GTPC_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @GTPC_Types.XID_Information_GTPC using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @GTPC_Types.XID_Information_GTPC.");
    break;
}
return *single_value.value_elements[index_value];
}

XID__GTPC_template& XID__Information__GTPC_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @GTPC_Types.XID_Information_GTPC.");
return (*this)[(int)index_value];
}

const XID__GTPC_template& XID__Information__GTPC_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @GTPC_Types.XID_Information_GTPC using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @GTPC_Types.XID_Information_GTPC.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @GTPC_Types.XID_Information_GTPC: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const XID__GTPC_template& XID__Information__GTPC_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @GTPC_Types.XID_Information_GTPC.");
return (*this)[(int)index_value];
}

void XID__Information__GTPC_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @GTPC_Types.XID_Information_GTPC.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (XID__GTPC_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new XID__GTPC_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new XID__GTPC_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (XID__GTPC_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int XID__Information__GTPC_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int XID__Information__GTPC_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @GTPC_Types.XID_Information_GTPC which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @GTPC_Types.XID_Information_GTPC containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @GTPC_Types.XID_Information_GTPC containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @GTPC_Types.XID_Information_GTPC containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @GTPC_Types.XID_Information_GTPC containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @GTPC_Types.XID_Information_GTPC containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @GTPC_Types.XID_Information_GTPC.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @GTPC_Types.XID_Information_GTPC");
}

boolean XID__Information__GTPC_template::match(const XID__Information__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @GTPC_Types.XID_Information_GTPC.");
}
return FALSE;
}

boolean XID__Information__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

XID__Information__GTPC XID__Information__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.XID_Information_GTPC.");
XID__Information__GTPC ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

XID__Information__GTPC XID__Information__GTPC_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

XID__Information__GTPC XID__Information__GTPC_template::replace(int index, int len, const XID__Information__GTPC_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

XID__Information__GTPC XID__Information__GTPC_template::replace(int index, int len, const XID__Information__GTPC& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void XID__Information__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new XID__Information__GTPC_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @GTPC_Types.XID_Information_GTPC.");
}
set_selection(template_type);
}

XID__Information__GTPC_template& XID__Information__GTPC_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @GTPC_Types.XID_Information_GTPC.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @GTPC_Types.XID_Information_GTPC.");
return value_list.list_value[list_index];
}

void XID__Information__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void XID__Information__GTPC_template::log_match(const XID__Information__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void XID__Information__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.XID_Information_GTPC.");
}
}

void XID__Information__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @GTPC_Types.XID_Information_GTPC.");
single_value.value_elements = (XID__GTPC_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new XID__GTPC_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new XID__Information__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @GTPC_Types.XID_Information_GTPC.");
}
}

boolean XID__Information__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean XID__Information__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void XID__Information__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void XID__Information__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    XID__Information__GTPC_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    XID__Information__GTPC_template* precondition = new XID__Information__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    XID__Information__GTPC_template* implied_template = new XID__Information__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = XID__Information__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@GTPC_Types.XID_Information_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void XID__Information__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Information_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.XID_Information_GTPC");
}

boolean XID__Information__GTPC_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
void XID__length__GTPC::copy_value(const XID__length__GTPC& other_value)
{
switch (other_value.union_selection) {
case ALT_short__len:
field_short__len = new INTEGER(*other_value.field_short__len);
break;
case ALT_long__len:
field_long__len = new INTEGER(*other_value.field_long__len);
break;
default:
TTCN_error("Assignment of an unbound union value of type @GTPC_Types.XID_length_GTPC.");
}
union_selection = other_value.union_selection;
}

XID__length__GTPC::XID__length__GTPC()
{
union_selection = UNBOUND_VALUE;
}

XID__length__GTPC::XID__length__GTPC(const XID__length__GTPC& other_value)
: Base_Type(){
copy_value(other_value);
}

XID__length__GTPC::~XID__length__GTPC()
{
clean_up();
}

XID__length__GTPC& XID__length__GTPC::operator=(const XID__length__GTPC& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean XID__length__GTPC::operator==(const XID__length__GTPC& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @GTPC_Types.XID_length_GTPC.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @GTPC_Types.XID_length_GTPC.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_short__len:
return *field_short__len == *other_value.field_short__len;
case ALT_long__len:
return *field_long__len == *other_value.field_long__len;
default:
return FALSE;
}
}

INTEGER& XID__length__GTPC::short__len()
{
if (union_selection != ALT_short__len) {
clean_up();
field_short__len = new INTEGER;
union_selection = ALT_short__len;
}
return *field_short__len;
}

const INTEGER& XID__length__GTPC::short__len() const
{
if (union_selection != ALT_short__len) TTCN_error("Using non-selected field short_len in a value of union type @GTPC_Types.XID_length_GTPC.");
return *field_short__len;
}

INTEGER& XID__length__GTPC::long__len()
{
if (union_selection != ALT_long__len) {
clean_up();
field_long__len = new INTEGER;
union_selection = ALT_long__len;
}
return *field_long__len;
}

const INTEGER& XID__length__GTPC::long__len() const
{
if (union_selection != ALT_long__len) TTCN_error("Using non-selected field long_len in a value of union type @GTPC_Types.XID_length_GTPC.");
return *field_long__len;
}

boolean XID__length__GTPC::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @GTPC_Types.XID_length_GTPC.");
return union_selection == checked_selection;
}

boolean XID__length__GTPC::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean XID__length__GTPC::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_short__len: return field_short__len->is_value();
case ALT_long__len: return field_long__len->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void XID__length__GTPC::clean_up()
{
switch (union_selection) {
case ALT_short__len:
  delete field_short__len;
  break;
case ALT_long__len:
  delete field_long__len;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void XID__length__GTPC::log() const
{
switch (union_selection) {
case ALT_short__len:
TTCN_Logger::log_event_str("{ short_len := ");
field_short__len->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_long__len:
TTCN_Logger::log_event_str("{ long_len := ");
field_long__len->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void XID__length__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "short_len")) {
    short__len().set_param(*mp_last);
    if (!short__len().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "long_len")) {
    long__len().set_param(*mp_last);
    if (!long__len().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @GTPC_Types.XID_length_GTPC.", last_name);
}

void XID__length__GTPC::set_implicit_omit()
{
switch (union_selection) {
case ALT_short__len:
field_short__len->set_implicit_omit(); break;
case ALT_long__len:
field_long__len->set_implicit_omit(); break;
default: break;
}
}

void XID__length__GTPC::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_short__len:
field_short__len->encode_text(text_buf);
break;
case ALT_long__len:
field_long__len->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @GTPC_Types.XID_length_GTPC.");
}
}

void XID__length__GTPC::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_short__len:
short__len().decode_text(text_buf);
break;
case ALT_long__len:
long__len().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @GTPC_Types.XID_length_GTPC.");
}
}

void XID__length__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void XID__length__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int XID__length__GTPC::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, XID__length__GTPC_short__len_descr_.raw->forceomit);
      decoded_length = short__len().RAW_decode(XID__length__GTPC_short__len_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, XID__length__GTPC_long__len_descr_.raw->forceomit);
      decoded_length = long__len().RAW_decode(XID__length__GTPC_long__len_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, XID__length__GTPC_short__len_descr_.raw->forceomit);
      decoded_length = short__len().RAW_decode(XID__length__GTPC_short__len_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, XID__length__GTPC_long__len_descr_.raw->forceomit);
      decoded_length = long__len().RAW_decode(XID__length__GTPC_long__len_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int XID__length__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  memset(myleaf.body.node.nodes, 0, 2 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_short__len:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, XID__length__GTPC_short__len_descr_.raw);
    encoded_length = field_short__len->RAW_encode(XID__length__GTPC_short__len_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &XID__length__GTPC_short__len_descr_;
    break;
  case ALT_long__len:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, XID__length__GTPC_long__len_descr_.raw);
    encoded_length = field_long__len->RAW_encode(XID__length__GTPC_long__len_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &XID__length__GTPC_long__len_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void XID__length__GTPC_template::copy_value(const XID__length__GTPC& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case XID__length__GTPC::ALT_short__len:
single_value.field_short__len = new INTEGER_template(other_value.short__len());
break;
case XID__length__GTPC::ALT_long__len:
single_value.field_long__len = new INTEGER_template(other_value.long__len());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @GTPC_Types.XID_length_GTPC.");
}
set_selection(SPECIFIC_VALUE);
}

void XID__length__GTPC_template::copy_template(const XID__length__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case XID__length__GTPC::ALT_short__len:
single_value.field_short__len = new INTEGER_template(*other_value.single_value.field_short__len);
break;
case XID__length__GTPC::ALT_long__len:
single_value.field_long__len = new INTEGER_template(*other_value.single_value.field_long__len);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @GTPC_Types.XID_length_GTPC.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new XID__length__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new XID__length__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new XID__length__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @GTPC_Types.XID_length_GTPC.");
}
set_selection(other_value);
}

XID__length__GTPC_template::XID__length__GTPC_template()
{
}

XID__length__GTPC_template::XID__length__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

XID__length__GTPC_template::XID__length__GTPC_template(const XID__length__GTPC& other_value)
{
copy_value(other_value);
}

XID__length__GTPC_template::XID__length__GTPC_template(const OPTIONAL<XID__length__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const XID__length__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @GTPC_Types.XID_length_GTPC from an unbound optional field.");
}
}

XID__length__GTPC_template::XID__length__GTPC_template(XID__length__GTPC_template* p_precondition, XID__length__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

XID__length__GTPC_template::XID__length__GTPC_template(Dynamic_Match_Interface<XID__length__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<XID__length__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

XID__length__GTPC_template::XID__length__GTPC_template(const XID__length__GTPC_template& other_value)
: Base_Template(){
copy_template(other_value);
}

XID__length__GTPC_template::~XID__length__GTPC_template()
{
clean_up();
}

void XID__length__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case XID__length__GTPC::ALT_short__len:
delete single_value.field_short__len;
break;
case XID__length__GTPC::ALT_long__len:
delete single_value.field_long__len;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

XID__length__GTPC_template& XID__length__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

XID__length__GTPC_template& XID__length__GTPC_template::operator=(const XID__length__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

XID__length__GTPC_template& XID__length__GTPC_template::operator=(const OPTIONAL<XID__length__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const XID__length__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @GTPC_Types.XID_length_GTPC.");
}
return *this;
}

XID__length__GTPC_template& XID__length__GTPC_template::operator=(const XID__length__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean XID__length__GTPC_template::match(const XID__length__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
XID__length__GTPC::union_selection_type value_selection = other_value.get_selection();
if (value_selection == XID__length__GTPC::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case XID__length__GTPC::ALT_short__len:
return single_value.field_short__len->match(other_value.short__len(), legacy);
case XID__length__GTPC::ALT_long__len:
return single_value.field_long__len->match(other_value.long__len(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @GTPC_Types.XID_length_GTPC.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @GTPC_Types.XID_length_GTPC.");
}
return FALSE;
}

boolean XID__length__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case XID__length__GTPC::ALT_short__len:
return single_value.field_short__len->is_value();
case XID__length__GTPC::ALT_long__len:
return single_value.field_long__len->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @GTPC_Types.XID_length_GTPC.");
}
}

XID__length__GTPC XID__length__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @GTPC_Types.XID_length_GTPC.");
XID__length__GTPC ret_val;
switch (single_value.union_selection) {
case XID__length__GTPC::ALT_short__len:
ret_val.short__len() = single_value.field_short__len->valueof();
break;
case XID__length__GTPC::ALT_long__len:
ret_val.long__len() = single_value.field_long__len->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @GTPC_Types.XID_length_GTPC.");
}
return ret_val;
}

XID__length__GTPC_template& XID__length__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @GTPC_Types.XID_length_GTPC.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @GTPC_Types.XID_length_GTPC.");
return value_list.list_value[list_index];
}
void XID__length__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @GTPC_Types.XID_length_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new XID__length__GTPC_template[list_length];
}

INTEGER_template& XID__length__GTPC_template::short__len()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__length__GTPC::ALT_short__len) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_short__len = new INTEGER_template(ANY_VALUE);
else single_value.field_short__len = new INTEGER_template;
single_value.union_selection = XID__length__GTPC::ALT_short__len;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_short__len;
}

const INTEGER_template& XID__length__GTPC_template::short__len() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field short_len in a non-specific template of union type @GTPC_Types.XID_length_GTPC.");
if (single_value.union_selection != XID__length__GTPC::ALT_short__len) TTCN_error("Accessing non-selected field short_len in a template of union type @GTPC_Types.XID_length_GTPC.");
return *single_value.field_short__len;
}

INTEGER_template& XID__length__GTPC_template::long__len()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__length__GTPC::ALT_long__len) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_long__len = new INTEGER_template(ANY_VALUE);
else single_value.field_long__len = new INTEGER_template;
single_value.union_selection = XID__length__GTPC::ALT_long__len;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_long__len;
}

const INTEGER_template& XID__length__GTPC_template::long__len() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field long_len in a non-specific template of union type @GTPC_Types.XID_length_GTPC.");
if (single_value.union_selection != XID__length__GTPC::ALT_long__len) TTCN_error("Accessing non-selected field long_len in a template of union type @GTPC_Types.XID_length_GTPC.");
return *single_value.field_long__len;
}

boolean XID__length__GTPC_template::ischosen(XID__length__GTPC::union_selection_type checked_selection) const
{
if (checked_selection == XID__length__GTPC::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @GTPC_Types.XID_length_GTPC.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == XID__length__GTPC::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @GTPC_Types.XID_length_GTPC.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @GTPC_Types.XID_length_GTPC containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void XID__length__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case XID__length__GTPC::ALT_short__len:
TTCN_Logger::log_event_str("{ short_len := ");
single_value.field_short__len->log();
TTCN_Logger::log_event_str(" }");
break;
case XID__length__GTPC::ALT_long__len:
TTCN_Logger::log_event_str("{ long_len := ");
single_value.field_long__len->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void XID__length__GTPC_template::log_match(const XID__length__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case XID__length__GTPC::ALT_short__len:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".short_len");
single_value.field_short__len->log_match(match_value.short__len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ short_len := ");
single_value.field_short__len->log_match(match_value.short__len(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case XID__length__GTPC::ALT_long__len:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".long_len");
single_value.field_long__len->log_match(match_value.long__len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ long_len := ");
single_value.field_long__len->log_match(match_value.long__len(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void XID__length__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case XID__length__GTPC::ALT_short__len:
single_value.field_short__len->set_implicit_omit(); break;
case XID__length__GTPC::ALT_long__len:
single_value.field_long__len->set_implicit_omit(); break;
default: break;
}
}

void XID__length__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case XID__length__GTPC::ALT_short__len:
single_value.field_short__len->encode_text(text_buf);
break;
case XID__length__GTPC::ALT_long__len:
single_value.field_long__len->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @GTPC_Types.XID_length_GTPC.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @GTPC_Types.XID_length_GTPC.");
}
}

void XID__length__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = XID__length__GTPC::UNBOUND_VALUE;
XID__length__GTPC::union_selection_type new_selection = (XID__length__GTPC::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case XID__length__GTPC::ALT_short__len:
single_value.field_short__len = new INTEGER_template;
single_value.field_short__len->decode_text(text_buf);
break;
case XID__length__GTPC::ALT_long__len:
single_value.field_long__len = new INTEGER_template;
single_value.field_long__len->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @GTPC_Types.XID_length_GTPC.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new XID__length__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @GTPC_Types.XID_length_GTPC.");
}
}

boolean XID__length__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean XID__length__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void XID__length__GTPC_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@GTPC_Types.XID_length_GTPC'");
    }
    if (strcmp("short_len", param_field) == 0) {
      short__len().set_param(param);
      return;
    } else if (strcmp("long_len", param_field) == 0) {
      long__len().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@GTPC_Types.XID_length_GTPC'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    XID__length__GTPC_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@GTPC_Types.XID_length_GTPC");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "short_len")) {
      short__len().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "long_len")) {
      long__len().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @GTPC_Types.XID_length_GTPC.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    XID__length__GTPC_template* precondition = new XID__length__GTPC_template;
    precondition->set_param(*m_p->get_elem(0));
    XID__length__GTPC_template* implied_template = new XID__length__GTPC_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = XID__length__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@GTPC_Types.XID_length_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void XID__length__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case XID__length__GTPC::ALT_short__len:
single_value.field_short__len->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_length_GTPC");
return;
case XID__length__GTPC::ALT_long__len:
single_value.field_long__len->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_length_GTPC");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @GTPC_Types.XID_length_GTPC.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.XID_length_GTPC");
}

void XID__Data__GTPC::copy_value(const XID__Data__GTPC& other_value)
{
switch (other_value.union_selection) {
case ALT_version:
field_version = new Version__GTPC(*other_value.field_version);
break;
case ALT_iOV__UI:
field_iOV__UI = new OCTETSTRING(*other_value.field_iOV__UI);
break;
case ALT_iOV__I:
field_iOV__I = new OCTETSTRING(*other_value.field_iOV__I);
break;
case ALT_t200:
field_t200 = new T200__GTPC(*other_value.field_t200);
break;
case ALT_n200:
field_n200 = new N200__GTPC(*other_value.field_n200);
break;
case ALT_n201__U:
field_n201__U = new N201__U__GTPC(*other_value.field_n201__U);
break;
case ALT_n201__I:
field_n201__I = new N201__I__GTPC(*other_value.field_n201__I);
break;
case ALT_mD:
field_mD = new MD__GTPC(*other_value.field_mD);
break;
case ALT_mU:
field_mU = new MU__GTPC(*other_value.field_mU);
break;
case ALT_kD:
field_kD = new INTEGER(*other_value.field_kD);
break;
case ALT_kU:
field_kU = new INTEGER(*other_value.field_kU);
break;
case ALT_l3param:
field_l3param = new OCTETSTRING(*other_value.field_l3param);
break;
case ALT_reset:
field_reset = new OCTETSTRING(*other_value.field_reset);
break;
default:
TTCN_error("Assignment of an unbound union value of type @GTPC_Types.XID_Data_GTPC.");
}
union_selection = other_value.union_selection;
}

XID__Data__GTPC::XID__Data__GTPC()
{
union_selection = UNBOUND_VALUE;
}

XID__Data__GTPC::XID__Data__GTPC(const XID__Data__GTPC& other_value)
: Base_Type(){
copy_value(other_value);
}

XID__Data__GTPC::~XID__Data__GTPC()
{
clean_up();
}

XID__Data__GTPC& XID__Data__GTPC::operator=(const XID__Data__GTPC& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean XID__Data__GTPC::operator==(const XID__Data__GTPC& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @GTPC_Types.XID_Data_GTPC.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @GTPC_Types.XID_Data_GTPC.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_version:
return *field_version == *other_value.field_version;
case ALT_iOV__UI:
return *field_iOV__UI == *other_value.field_iOV__UI;
case ALT_iOV__I:
return *field_iOV__I == *other_value.field_iOV__I;
case ALT_t200:
return *field_t200 == *other_value.field_t200;
case ALT_n200:
return *field_n200 == *other_value.field_n200;
case ALT_n201__U:
return *field_n201__U == *other_value.field_n201__U;
case ALT_n201__I:
return *field_n201__I == *other_value.field_n201__I;
case ALT_mD:
return *field_mD == *other_value.field_mD;
case ALT_mU:
return *field_mU == *other_value.field_mU;
case ALT_kD:
return *field_kD == *other_value.field_kD;
case ALT_kU:
return *field_kU == *other_value.field_kU;
case ALT_l3param:
return *field_l3param == *other_value.field_l3param;
case ALT_reset:
return *field_reset == *other_value.field_reset;
default:
return FALSE;
}
}

Version__GTPC& XID__Data__GTPC::version()
{
if (union_selection != ALT_version) {
clean_up();
field_version = new Version__GTPC;
union_selection = ALT_version;
}
return *field_version;
}

const Version__GTPC& XID__Data__GTPC::version() const
{
if (union_selection != ALT_version) TTCN_error("Using non-selected field version in a value of union type @GTPC_Types.XID_Data_GTPC.");
return *field_version;
}

OCTETSTRING& XID__Data__GTPC::iOV__UI()
{
if (union_selection != ALT_iOV__UI) {
clean_up();
field_iOV__UI = new OCTETSTRING;
union_selection = ALT_iOV__UI;
}
return *field_iOV__UI;
}

const OCTETSTRING& XID__Data__GTPC::iOV__UI() const
{
if (union_selection != ALT_iOV__UI) TTCN_error("Using non-selected field iOV_UI in a value of union type @GTPC_Types.XID_Data_GTPC.");
return *field_iOV__UI;
}

OCTETSTRING& XID__Data__GTPC::iOV__I()
{
if (union_selection != ALT_iOV__I) {
clean_up();
field_iOV__I = new OCTETSTRING;
union_selection = ALT_iOV__I;
}
return *field_iOV__I;
}

const OCTETSTRING& XID__Data__GTPC::iOV__I() const
{
if (union_selection != ALT_iOV__I) TTCN_error("Using non-selected field iOV_I in a value of union type @GTPC_Types.XID_Data_GTPC.");
return *field_iOV__I;
}

T200__GTPC& XID__Data__GTPC::t200()
{
if (union_selection != ALT_t200) {
clean_up();
field_t200 = new T200__GTPC;
union_selection = ALT_t200;
}
return *field_t200;
}

const T200__GTPC& XID__Data__GTPC::t200() const
{
if (union_selection != ALT_t200) TTCN_error("Using non-selected field t200 in a value of union type @GTPC_Types.XID_Data_GTPC.");
return *field_t200;
}

N200__GTPC& XID__Data__GTPC::n200()
{
if (union_selection != ALT_n200) {
clean_up();
field_n200 = new N200__GTPC;
union_selection = ALT_n200;
}
return *field_n200;
}

const N200__GTPC& XID__Data__GTPC::n200() const
{
if (union_selection != ALT_n200) TTCN_error("Using non-selected field n200 in a value of union type @GTPC_Types.XID_Data_GTPC.");
return *field_n200;
}

N201__U__GTPC& XID__Data__GTPC::n201__U()
{
if (union_selection != ALT_n201__U) {
clean_up();
field_n201__U = new N201__U__GTPC;
union_selection = ALT_n201__U;
}
return *field_n201__U;
}

const N201__U__GTPC& XID__Data__GTPC::n201__U() const
{
if (union_selection != ALT_n201__U) TTCN_error("Using non-selected field n201_U in a value of union type @GTPC_Types.XID_Data_GTPC.");
return *field_n201__U;
}

N201__I__GTPC& XID__Data__GTPC::n201__I()
{
if (union_selection != ALT_n201__I) {
clean_up();
field_n201__I = new N201__I__GTPC;
union_selection = ALT_n201__I;
}
return *field_n201__I;
}

const N201__I__GTPC& XID__Data__GTPC::n201__I() const
{
if (union_selection != ALT_n201__I) TTCN_error("Using non-selected field n201_I in a value of union type @GTPC_Types.XID_Data_GTPC.");
return *field_n201__I;
}

MD__GTPC& XID__Data__GTPC::mD()
{
if (union_selection != ALT_mD) {
clean_up();
field_mD = new MD__GTPC;
union_selection = ALT_mD;
}
return *field_mD;
}

const MD__GTPC& XID__Data__GTPC::mD() const
{
if (union_selection != ALT_mD) TTCN_error("Using non-selected field mD in a value of union type @GTPC_Types.XID_Data_GTPC.");
return *field_mD;
}

MU__GTPC& XID__Data__GTPC::mU()
{
if (union_selection != ALT_mU) {
clean_up();
field_mU = new MU__GTPC;
union_selection = ALT_mU;
}
return *field_mU;
}

const MU__GTPC& XID__Data__GTPC::mU() const
{
if (union_selection != ALT_mU) TTCN_error("Using non-selected field mU in a value of union type @GTPC_Types.XID_Data_GTPC.");
return *field_mU;
}

INTEGER& XID__Data__GTPC::kD()
{
if (union_selection != ALT_kD) {
clean_up();
field_kD = new INTEGER;
union_selection = ALT_kD;
}
return *field_kD;
}

const INTEGER& XID__Data__GTPC::kD() const
{
if (union_selection != ALT_kD) TTCN_error("Using non-selected field kD in a value of union type @GTPC_Types.XID_Data_GTPC.");
return *field_kD;
}

INTEGER& XID__Data__GTPC::kU()
{
if (union_selection != ALT_kU) {
clean_up();
field_kU = new INTEGER;
union_selection = ALT_kU;
}
return *field_kU;
}

const INTEGER& XID__Data__GTPC::kU() const
{
if (union_selection != ALT_kU) TTCN_error("Using non-selected field kU in a value of union type @GTPC_Types.XID_Data_GTPC.");
return *field_kU;
}

OCTETSTRING& XID__Data__GTPC::l3param()
{
if (union_selection != ALT_l3param) {
clean_up();
field_l3param = new OCTETSTRING;
union_selection = ALT_l3param;
}
return *field_l3param;
}

const OCTETSTRING& XID__Data__GTPC::l3param() const
{
if (union_selection != ALT_l3param) TTCN_error("Using non-selected field l3param in a value of union type @GTPC_Types.XID_Data_GTPC.");
return *field_l3param;
}

OCTETSTRING& XID__Data__GTPC::reset()
{
if (union_selection != ALT_reset) {
clean_up();
field_reset = new OCTETSTRING;
union_selection = ALT_reset;
}
return *field_reset;
}

const OCTETSTRING& XID__Data__GTPC::reset() const
{
if (union_selection != ALT_reset) TTCN_error("Using non-selected field reset in a value of union type @GTPC_Types.XID_Data_GTPC.");
return *field_reset;
}

boolean XID__Data__GTPC::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @GTPC_Types.XID_Data_GTPC.");
return union_selection == checked_selection;
}

boolean XID__Data__GTPC::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean XID__Data__GTPC::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_version: return field_version->is_value();
case ALT_iOV__UI: return field_iOV__UI->is_value();
case ALT_iOV__I: return field_iOV__I->is_value();
case ALT_t200: return field_t200->is_value();
case ALT_n200: return field_n200->is_value();
case ALT_n201__U: return field_n201__U->is_value();
case ALT_n201__I: return field_n201__I->is_value();
case ALT_mD: return field_mD->is_value();
case ALT_mU: return field_mU->is_value();
case ALT_kD: return field_kD->is_value();
case ALT_kU: return field_kU->is_value();
case ALT_l3param: return field_l3param->is_value();
case ALT_reset: return field_reset->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void XID__Data__GTPC::clean_up()
{
switch (union_selection) {
case ALT_version:
  delete field_version;
  break;
case ALT_iOV__UI:
  delete field_iOV__UI;
  break;
case ALT_iOV__I:
  delete field_iOV__I;
  break;
case ALT_t200:
  delete field_t200;
  break;
case ALT_n200:
  delete field_n200;
  break;
case ALT_n201__U:
  delete field_n201__U;
  break;
case ALT_n201__I:
  delete field_n201__I;
  break;
case ALT_mD:
  delete field_mD;
  break;
case ALT_mU:
  delete field_mU;
  break;
case ALT_kD:
  delete field_kD;
  break;
case ALT_kU:
  delete field_kU;
  break;
case ALT_l3param:
  delete field_l3param;
  break;
case ALT_reset:
  delete field_reset;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void XID__Data__GTPC::log() const
{
switch (union_selection) {
case ALT_version:
TTCN_Logger::log_event_str("{ version := ");
field_version->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_iOV__UI:
TTCN_Logger::log_event_str("{ iOV_UI := ");
field_iOV__UI->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_iOV__I:
TTCN_Logger::log_event_str("{ iOV_I := ");
field_iOV__I->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_t200:
TTCN_Logger::log_event_str("{ t200 := ");
field_t200->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_n200:
TTCN_Logger::log_event_str("{ n200 := ");
field_n200->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_n201__U:
TTCN_Logger::log_event_str("{ n201_U := ");
field_n201__U->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_n201__I:
TTCN_Logger::log_event_str("{ n201_I := ");
field_n201__I->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_mD:
TTCN_Logger::log_event_str("{ mD := ");
field_mD->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_mU:
TTCN_Logger::log_event_str("{ mU := ");
field_mU->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_kD:
TTCN_Logger::log_event_str("{ kD := ");
field_kD->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_kU:
TTCN_Logger::log_event_str("{ kU := ");
field_kU->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_l3param:
TTCN_Logger::log_event_str("{ l3param := ");
field_l3param->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_reset:
TTCN_Logger::log_event_str("{ reset := ");
field_reset->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void XID__Data__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "version")) {
    version().set_param(*mp_last);
    if (!version().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "iOV_UI")) {
    iOV__UI().set_param(*mp_last);
    if (!iOV__UI().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "iOV_I")) {
    iOV__I().set_param(*mp_last);
    if (!iOV__I().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "t200")) {
    t200().set_param(*mp_last);
    if (!t200().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "n200")) {
    n200().set_param(*mp_last);
    if (!n200().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "n201_U")) {
    n201__U().set_param(*mp_last);
    if (!n201__U().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "n201_I")) {
    n201__I().set_param(*mp_last);
    if (!n201__I().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "mD")) {
    mD().set_param(*mp_last);
    if (!mD().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "mU")) {
    mU().set_param(*mp_last);
    if (!mU().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "kD")) {
    kD().set_param(*mp_last);
    if (!kD().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "kU")) {
    kU().set_param(*mp_last);
    if (!kU().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "l3param")) {
    l3param().set_param(*mp_last);
    if (!l3param().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "reset")) {
    reset().set_param(*mp_last);
    if (!reset().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @GTPC_Types.XID_Data_GTPC.", last_name);
}

void XID__Data__GTPC::set_implicit_omit()
{
switch (union_selection) {
case ALT_version:
field_version->set_implicit_omit(); break;
case ALT_iOV__UI:
field_iOV__UI->set_implicit_omit(); break;
case ALT_iOV__I:
field_iOV__I->set_implicit_omit(); break;
case ALT_t200:
field_t200->set_implicit_omit(); break;
case ALT_n200:
field_n200->set_implicit_omit(); break;
case ALT_n201__U:
field_n201__U->set_implicit_omit(); break;
case ALT_n201__I:
field_n201__I->set_implicit_omit(); break;
case ALT_mD:
field_mD->set_implicit_omit(); break;
case ALT_mU:
field_mU->set_implicit_omit(); break;
case ALT_kD:
field_kD->set_implicit_omit(); break;
case ALT_kU:
field_kU->set_implicit_omit(); break;
case ALT_l3param:
field_l3param->set_implicit_omit(); break;
case ALT_reset:
field_reset->set_implicit_omit(); break;
default: break;
}
}

void XID__Data__GTPC::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_version:
field_version->encode_text(text_buf);
break;
case ALT_iOV__UI:
field_iOV__UI->encode_text(text_buf);
break;
case ALT_iOV__I:
field_iOV__I->encode_text(text_buf);
break;
case ALT_t200:
field_t200->encode_text(text_buf);
break;
case ALT_n200:
field_n200->encode_text(text_buf);
break;
case ALT_n201__U:
field_n201__U->encode_text(text_buf);
break;
case ALT_n201__I:
field_n201__I->encode_text(text_buf);
break;
case ALT_mD:
field_mD->encode_text(text_buf);
break;
case ALT_mU:
field_mU->encode_text(text_buf);
break;
case ALT_kD:
field_kD->encode_text(text_buf);
break;
case ALT_kU:
field_kU->encode_text(text_buf);
break;
case ALT_l3param:
field_l3param->encode_text(text_buf);
break;
case ALT_reset:
field_reset->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @GTPC_Types.XID_Data_GTPC.");
}
}

void XID__Data__GTPC::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_version:
version().decode_text(text_buf);
break;
case ALT_iOV__UI:
iOV__UI().decode_text(text_buf);
break;
case ALT_iOV__I:
iOV__I().decode_text(text_buf);
break;
case ALT_t200:
t200().decode_text(text_buf);
break;
case ALT_n200:
n200().decode_text(text_buf);
break;
case ALT_n201__U:
n201__U().decode_text(text_buf);
break;
case ALT_n201__I:
n201__I().decode_text(text_buf);
break;
case ALT_mD:
mD().decode_text(text_buf);
break;
case ALT_mU:
mU().decode_text(text_buf);
break;
case ALT_kD:
kD().decode_text(text_buf);
break;
case ALT_kU:
kU().decode_text(text_buf);
break;
case ALT_l3param:
l3param().decode_text(text_buf);
break;
case ALT_reset:
reset().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @GTPC_Types.XID_Data_GTPC.");
}
}

void XID__Data__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void XID__Data__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int XID__Data__GTPC::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, Version__GTPC_descr_.raw->forceomit);
      decoded_length = version().RAW_decode(Version__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, IOV__UI__GTPC_descr_.raw->forceomit);
      decoded_length = iOV__UI().RAW_decode(IOV__UI__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, IOV__I__GTPC_descr_.raw->forceomit);
      decoded_length = iOV__I().RAW_decode(IOV__I__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, T200__GTPC_descr_.raw->forceomit);
      decoded_length = t200().RAW_decode(T200__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 4: {
      RAW_Force_Omit field_force_omit(4, force_omit, N200__GTPC_descr_.raw->forceomit);
      decoded_length = n200().RAW_decode(N200__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 5: {
      RAW_Force_Omit field_force_omit(5, force_omit, N201__U__GTPC_descr_.raw->forceomit);
      decoded_length = n201__U().RAW_decode(N201__U__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 6: {
      RAW_Force_Omit field_force_omit(6, force_omit, N201__I__GTPC_descr_.raw->forceomit);
      decoded_length = n201__I().RAW_decode(N201__I__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 7: {
      RAW_Force_Omit field_force_omit(7, force_omit, MD__GTPC_descr_.raw->forceomit);
      decoded_length = mD().RAW_decode(MD__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 8: {
      RAW_Force_Omit field_force_omit(8, force_omit, MU__GTPC_descr_.raw->forceomit);
      decoded_length = mU().RAW_decode(MU__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 9: {
      RAW_Force_Omit field_force_omit(9, force_omit, KD__GTPC_descr_.raw->forceomit);
      decoded_length = kD().RAW_decode(KD__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 10: {
      RAW_Force_Omit field_force_omit(10, force_omit, KU__GTPC_descr_.raw->forceomit);
      decoded_length = kU().RAW_decode(KU__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 11: {
      RAW_Force_Omit field_force_omit(11, force_omit, L3param__GTPC_descr_.raw->forceomit);
      decoded_length = l3param().RAW_decode(L3param__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 12: {
      RAW_Force_Omit field_force_omit(12, force_omit, Reset__LLC__GTPC_descr_.raw->forceomit);
      decoded_length = reset().RAW_decode(Reset__LLC__GTPC_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, Version__GTPC_descr_.raw->forceomit);
      decoded_length = version().RAW_decode(Version__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, IOV__UI__GTPC_descr_.raw->forceomit);
      decoded_length = iOV__UI().RAW_decode(IOV__UI__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, IOV__I__GTPC_descr_.raw->forceomit);
      decoded_length = iOV__I().RAW_decode(IOV__I__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_3_force_omit(3, force_omit, T200__GTPC_descr_.raw->forceomit);
      decoded_length = t200().RAW_decode(T200__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_3_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_4_force_omit(4, force_omit, N200__GTPC_descr_.raw->forceomit);
      decoded_length = n200().RAW_decode(N200__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_4_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_5_force_omit(5, force_omit, N201__U__GTPC_descr_.raw->forceomit);
      decoded_length = n201__U().RAW_decode(N201__U__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_5_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_6_force_omit(6, force_omit, N201__I__GTPC_descr_.raw->forceomit);
      decoded_length = n201__I().RAW_decode(N201__I__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_6_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_7_force_omit(7, force_omit, MD__GTPC_descr_.raw->forceomit);
      decoded_length = mD().RAW_decode(MD__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_7_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_8_force_omit(8, force_omit, MU__GTPC_descr_.raw->forceomit);
      decoded_length = mU().RAW_decode(MU__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_8_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_9_force_omit(9, force_omit, KD__GTPC_descr_.raw->forceomit);
      decoded_length = kD().RAW_decode(KD__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_9_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_10_force_omit(10, force_omit, KU__GTPC_descr_.raw->forceomit);
      decoded_length = kU().RAW_decode(KU__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_10_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_11_force_omit(11, force_omit, L3param__GTPC_descr_.raw->forceomit);
      decoded_length = l3param().RAW_decode(L3param__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_11_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_12_force_omit(12, force_omit, Reset__LLC__GTPC_descr_.raw->forceomit);
      decoded_length = reset().RAW_decode(Reset__LLC__GTPC_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_12_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int XID__Data__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 13;  myleaf.body.node.nodes = init_nodes_of_enc_tree(13);
  memset(myleaf.body.node.nodes, 0, 13 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_version:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, Version__GTPC_descr_.raw);
    encoded_length = field_version->RAW_encode(Version__GTPC_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &Version__GTPC_descr_;
    break;
  case ALT_iOV__UI:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, IOV__UI__GTPC_descr_.raw);
    encoded_length = field_iOV__UI->RAW_encode(IOV__UI__GTPC_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &IOV__UI__GTPC_descr_;
    break;
  case ALT_iOV__I:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, IOV__I__GTPC_descr_.raw);
    encoded_length = field_iOV__I->RAW_encode(IOV__I__GTPC_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &IOV__I__GTPC_descr_;
    break;
  case ALT_t200:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, T200__GTPC_descr_.raw);
    encoded_length = field_t200->RAW_encode(T200__GTPC_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &T200__GTPC_descr_;
    break;
  case ALT_n200:
    myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 4, N200__GTPC_descr_.raw);
    encoded_length = field_n200->RAW_encode(N200__GTPC_descr_, *myleaf.body.node.nodes[4]);
    myleaf.body.node.nodes[4]->coding_descr = &N200__GTPC_descr_;
    break;
  case ALT_n201__U:
    myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 5, N201__U__GTPC_descr_.raw);
    encoded_length = field_n201__U->RAW_encode(N201__U__GTPC_descr_, *myleaf.body.node.nodes[5]);
    myleaf.body.node.nodes[5]->coding_descr = &N201__U__GTPC_descr_;
    break;
  case ALT_n201__I:
    myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 6, N201__I__GTPC_descr_.raw);
    encoded_length = field_n201__I->RAW_encode(N201__I__GTPC_descr_, *myleaf.body.node.nodes[6]);
    myleaf.body.node.nodes[6]->coding_descr = &N201__I__GTPC_descr_;
    break;
  case ALT_mD:
    myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 7, MD__GTPC_descr_.raw);
    encoded_length = field_mD->RAW_encode(MD__GTPC_descr_, *myleaf.body.node.nodes[7]);
    myleaf.body.node.nodes[7]->coding_descr = &MD__GTPC_descr_;
    break;
  case ALT_mU:
    myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 8, MU__GTPC_descr_.raw);
    encoded_length = field_mU->RAW_encode(MU__GTPC_descr_, *myleaf.body.node.nodes[8]);
    myleaf.body.node.nodes[8]->coding_descr = &MU__GTPC_descr_;
    break;
  case ALT_kD:
    myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 9, KD__GTPC_descr_.raw);
    encoded_length = field_kD->RAW_encode(KD__GTPC_descr_, *myleaf.body.node.nodes[9]);
    myleaf.body.node.nodes[9]->coding_descr = &KD__GTPC_descr_;
    break;
  case ALT_kU:
    myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 10, KU__GTPC_descr_.raw);
    encoded_length = field_kU->RAW_encode(KU__GTPC_descr_, *myleaf.body.node.nodes[10]);
    myleaf.body.node.nodes[10]->coding_descr = &KU__GTPC_descr_;
    break;
  case ALT_l3param:
    myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 11, L3param__GTPC_descr_.raw);
    encoded_length = field_l3param->RAW_encode(L3param__GTPC_descr_, *myleaf.body.node.nodes[11]);
    myleaf.body.node.nodes[11]->coding_descr = &L3param__GTPC_descr_;
    break;
  case ALT_reset:
    myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 12, Reset__LLC__GTPC_descr_.raw);
    encoded_length = field_reset->RAW_encode(Reset__LLC__GTPC_descr_, *myleaf.body.node.nodes[12]);
    myleaf.body.node.nodes[12]->coding_descr = &Reset__LLC__GTPC_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void XID__Data__GTPC_template::copy_value(const XID__Data__GTPC& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case XID__Data__GTPC::ALT_version:
single_value.field_version = new Version__GTPC_template(other_value.version());
break;
case XID__Data__GTPC::ALT_iOV__UI:
single_value.field_iOV__UI = new OCTETSTRING_template(other_value.iOV__UI());
break;
case XID__Data__GTPC::ALT_iOV__I:
single_value.field_iOV__I = new OCTETSTRING_template(other_value.iOV__I());
break;
case XID__Data__GTPC::ALT_t200:
single_value.field_t200 = new T200__GTPC_template(other_value.t200());
break;
case XID__Data__GTPC::ALT_n200:
single_value.field_n200 = new N200__GTPC_template(other_value.n200());
break;
case XID__Data__GTPC::ALT_n201__U:
single_value.field_n201__U = new N201__U__GTPC_template(other_value.n201__U());
break;
case XID__Data__GTPC::ALT_n201__I:
single_value.field_n201__I = new N201__I__GTPC_template(other_value.n201__I());
break;
case XID__Data__GTPC::ALT_mD:
single_value.field_mD = new MD__GTPC_template(other_value.mD());
break;
case XID__Data__GTPC::ALT_mU:
single_value.field_mU = new MU__GTPC_template(other_value.mU());
break;
case XID__Data__GTPC::ALT_kD:
single_value.field_kD = new INTEGER_template(other_value.kD());
break;
case XID__Data__GTPC::ALT_kU:
single_value.field_kU = new INTEGER_template(other_value.kU());
break;
case XID__Data__GTPC::ALT_l3param:
single_value.field_l3param = new OCTETSTRING_template(other_value.l3param());
break;
case XID__Data__GTPC::ALT_reset:
single_value.field_reset = new OCTETSTRING_template(other_value.reset());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @GTPC_Types.XID_Data_GTPC.");
}
set_selection(SPECIFIC_VALUE);
}

void XID__Data__GTPC_template::copy_template(const XID__Data__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case XID__Data__GTPC::ALT_version:
single_value.field_version = new Version__GTPC_template(*other_value.single_value.field_version);
break;
case XID__Data__GTPC::ALT_iOV__UI:
single_value.field_iOV__UI = new OCTETSTRING_template(*other_value.single_value.field_iOV__UI);
break;
case XID__Data__GTPC::ALT_iOV__I:
single_value.field_iOV__I = new OCTETSTRING_template(*other_value.single_value.field_iOV__I);
break;
case XID__Data__GTPC::ALT_t200:
single_value.field_t200 = new T200__GTPC_template(*other_value.single_value.field_t200);
break;
case XID__Data__GTPC::ALT_n200:
single_value.field_n200 = new N200__GTPC_template(*other_value.single_value.field_n200);
break;
case XID__Data__GTPC::ALT_n201__U:
single_value.field_n201__U = new N201__U__GTPC_template(*other_value.single_value.field_n201__U);
break;
case XID__Data__GTPC::ALT_n201__I:
single_value.field_n201__I = new N201__I__GTPC_template(*other_value.single_value.field_n201__I);
break;
case XID__Data__GTPC::ALT_mD:
single_value.field_mD = new MD__GTPC_template(*other_value.single_value.field_mD);
break;
case XID__Data__GTPC::ALT_mU:
single_value.field_mU = new MU__GTPC_template(*other_value.single_value.field_mU);
break;
case XID__Data__GTPC::ALT_kD:
single_value.field_kD = new INTEGER_template(*other_value.single_value.field_kD);
break;
case XID__Data__GTPC::ALT_kU:
single_value.field_kU = new INTEGER_template(*other_value.single_value.field_kU);
break;
case XID__Data__GTPC::ALT_l3param:
single_value.field_l3param = new OCTETSTRING_template(*other_value.single_value.field_l3param);
break;
case XID__Data__GTPC::ALT_reset:
single_value.field_reset = new OCTETSTRING_template(*other_value.single_value.field_reset);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @GTPC_Types.XID_Data_GTPC.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new XID__Data__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new XID__Data__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new XID__Data__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @GTPC_Types.XID_Data_GTPC.");
}
set_selection(other_value);
}

XID__Data__GTPC_template::XID__Data__GTPC_template()
{
}

XID__Data__GTPC_template::XID__Data__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

XID__Data__GTPC_template::XID__Data__GTPC_template(const XID__Data__GTPC& other_value)
{
copy_value(other_value);
}

XID__Data__GTPC_template::XID__Data__GTPC_template(const OPTIONAL<XID__Data__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const XID__Data__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @GTPC_Types.XID_Data_GTPC from an unbound optional field.");
}
}

XID__Data__GTPC_template::XID__Data__GTPC_template(XID__Data__GTPC_template* p_precondition, XID__Data__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

XID__Data__GTPC_template::XID__Data__GTPC_template(Dynamic_Match_Interface<XID__Data__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<XID__Data__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

XID__Data__GTPC_template::XID__Data__GTPC_template(const XID__Data__GTPC_template& other_value)
: Base_Template(){
copy_template(other_value);
}

XID__Data__GTPC_template::~XID__Data__GTPC_template()
{
clean_up();
}

void XID__Data__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case XID__Data__GTPC::ALT_version:
delete single_value.field_version;
break;
case XID__Data__GTPC::ALT_iOV__UI:
delete single_value.field_iOV__UI;
break;
case XID__Data__GTPC::ALT_iOV__I:
delete single_value.field_iOV__I;
break;
case XID__Data__GTPC::ALT_t200:
delete single_value.field_t200;
break;
case XID__Data__GTPC::ALT_n200:
delete single_value.field_n200;
break;
case XID__Data__GTPC::ALT_n201__U:
delete single_value.field_n201__U;
break;
case XID__Data__GTPC::ALT_n201__I:
delete single_value.field_n201__I;
break;
case XID__Data__GTPC::ALT_mD:
delete single_value.field_mD;
break;
case XID__Data__GTPC::ALT_mU:
delete single_value.field_mU;
break;
case XID__Data__GTPC::ALT_kD:
delete single_value.field_kD;
break;
case XID__Data__GTPC::ALT_kU:
delete single_value.field_kU;
break;
case XID__Data__GTPC::ALT_l3param:
delete single_value.field_l3param;
break;
case XID__Data__GTPC::ALT_reset:
delete single_value.field_reset;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

XID__Data__GTPC_template& XID__Data__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

XID__Data__GTPC_template& XID__Data__GTPC_template::operator=(const XID__Data__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

XID__Data__GTPC_template& XID__Data__GTPC_template::operator=(const OPTIONAL<XID__Data__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const XID__Data__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @GTPC_Types.XID_Data_GTPC.");
}
return *this;
}

XID__Data__GTPC_template& XID__Data__GTPC_template::operator=(const XID__Data__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean XID__Data__GTPC_template::match(const XID__Data__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
XID__Data__GTPC::union_selection_type value_selection = other_value.get_selection();
if (value_selection == XID__Data__GTPC::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case XID__Data__GTPC::ALT_version:
return single_value.field_version->match(other_value.version(), legacy);
case XID__Data__GTPC::ALT_iOV__UI:
return single_value.field_iOV__UI->match(other_value.iOV__UI(), legacy);
case XID__Data__GTPC::ALT_iOV__I:
return single_value.field_iOV__I->match(other_value.iOV__I(), legacy);
case XID__Data__GTPC::ALT_t200:
return single_value.field_t200->match(other_value.t200(), legacy);
case XID__Data__GTPC::ALT_n200:
return single_value.field_n200->match(other_value.n200(), legacy);
case XID__Data__GTPC::ALT_n201__U:
return single_value.field_n201__U->match(other_value.n201__U(), legacy);
case XID__Data__GTPC::ALT_n201__I:
return single_value.field_n201__I->match(other_value.n201__I(), legacy);
case XID__Data__GTPC::ALT_mD:
return single_value.field_mD->match(other_value.mD(), legacy);
case XID__Data__GTPC::ALT_mU:
return single_value.field_mU->match(other_value.mU(), legacy);
case XID__Data__GTPC::ALT_kD:
return single_value.field_kD->match(other_value.kD(), legacy);
case XID__Data__GTPC::ALT_kU:
return single_value.field_kU->match(other_value.kU(), legacy);
case XID__Data__GTPC::ALT_l3param:
return single_value.field_l3param->match(other_value.l3param(), legacy);
case XID__Data__GTPC::ALT_reset:
return single_value.field_reset->match(other_value.reset(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @GTPC_Types.XID_Data_GTPC.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @GTPC_Types.XID_Data_GTPC.");
}
return FALSE;
}

boolean XID__Data__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case XID__Data__GTPC::ALT_version:
return single_value.field_version->is_value();
case XID__Data__GTPC::ALT_iOV__UI:
return single_value.field_iOV__UI->is_value();
case XID__Data__GTPC::ALT_iOV__I:
return single_value.field_iOV__I->is_value();
case XID__Data__GTPC::ALT_t200:
return single_value.field_t200->is_value();
case XID__Data__GTPC::ALT_n200:
return single_value.field_n200->is_value();
case XID__Data__GTPC::ALT_n201__U:
return single_value.field_n201__U->is_value();
case XID__Data__GTPC::ALT_n201__I:
return single_value.field_n201__I->is_value();
case XID__Data__GTPC::ALT_mD:
return single_value.field_mD->is_value();
case XID__Data__GTPC::ALT_mU:
return single_value.field_mU->is_value();
case XID__Data__GTPC::ALT_kD:
return single_value.field_kD->is_value();
case XID__Data__GTPC::ALT_kU:
return single_value.field_kU->is_value();
case XID__Data__GTPC::ALT_l3param:
return single_value.field_l3param->is_value();
case XID__Data__GTPC::ALT_reset:
return single_value.field_reset->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @GTPC_Types.XID_Data_GTPC.");
}
}

XID__Data__GTPC XID__Data__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
XID__Data__GTPC ret_val;
switch (single_value.union_selection) {
case XID__Data__GTPC::ALT_version:
ret_val.version() = single_value.field_version->valueof();
break;
case XID__Data__GTPC::ALT_iOV__UI:
ret_val.iOV__UI() = single_value.field_iOV__UI->valueof();
break;
case XID__Data__GTPC::ALT_iOV__I:
ret_val.iOV__I() = single_value.field_iOV__I->valueof();
break;
case XID__Data__GTPC::ALT_t200:
ret_val.t200() = single_value.field_t200->valueof();
break;
case XID__Data__GTPC::ALT_n200:
ret_val.n200() = single_value.field_n200->valueof();
break;
case XID__Data__GTPC::ALT_n201__U:
ret_val.n201__U() = single_value.field_n201__U->valueof();
break;
case XID__Data__GTPC::ALT_n201__I:
ret_val.n201__I() = single_value.field_n201__I->valueof();
break;
case XID__Data__GTPC::ALT_mD:
ret_val.mD() = single_value.field_mD->valueof();
break;
case XID__Data__GTPC::ALT_mU:
ret_val.mU() = single_value.field_mU->valueof();
break;
case XID__Data__GTPC::ALT_kD:
ret_val.kD() = single_value.field_kD->valueof();
break;
case XID__Data__GTPC::ALT_kU:
ret_val.kU() = single_value.field_kU->valueof();
break;
case XID__Data__GTPC::ALT_l3param:
ret_val.l3param() = single_value.field_l3param->valueof();
break;
case XID__Data__GTPC::ALT_reset:
ret_val.reset() = single_value.field_reset->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @GTPC_Types.XID_Data_GTPC.");
}
return ret_val;
}

XID__Data__GTPC_template& XID__Data__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @GTPC_Types.XID_Data_GTPC.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @GTPC_Types.XID_Data_GTPC.");
return value_list.list_value[list_index];
}
void XID__Data__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @GTPC_Types.XID_Data_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new XID__Data__GTPC_template[list_length];
}

Version__GTPC_template& XID__Data__GTPC_template::version()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__Data__GTPC::ALT_version) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_version = new Version__GTPC_template(ANY_VALUE);
else single_value.field_version = new Version__GTPC_template;
single_value.union_selection = XID__Data__GTPC::ALT_version;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_version;
}

const Version__GTPC_template& XID__Data__GTPC_template::version() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field version in a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
if (single_value.union_selection != XID__Data__GTPC::ALT_version) TTCN_error("Accessing non-selected field version in a template of union type @GTPC_Types.XID_Data_GTPC.");
return *single_value.field_version;
}

OCTETSTRING_template& XID__Data__GTPC_template::iOV__UI()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__Data__GTPC::ALT_iOV__UI) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_iOV__UI = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_iOV__UI = new OCTETSTRING_template;
single_value.union_selection = XID__Data__GTPC::ALT_iOV__UI;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_iOV__UI;
}

const OCTETSTRING_template& XID__Data__GTPC_template::iOV__UI() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field iOV_UI in a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
if (single_value.union_selection != XID__Data__GTPC::ALT_iOV__UI) TTCN_error("Accessing non-selected field iOV_UI in a template of union type @GTPC_Types.XID_Data_GTPC.");
return *single_value.field_iOV__UI;
}

OCTETSTRING_template& XID__Data__GTPC_template::iOV__I()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__Data__GTPC::ALT_iOV__I) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_iOV__I = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_iOV__I = new OCTETSTRING_template;
single_value.union_selection = XID__Data__GTPC::ALT_iOV__I;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_iOV__I;
}

const OCTETSTRING_template& XID__Data__GTPC_template::iOV__I() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field iOV_I in a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
if (single_value.union_selection != XID__Data__GTPC::ALT_iOV__I) TTCN_error("Accessing non-selected field iOV_I in a template of union type @GTPC_Types.XID_Data_GTPC.");
return *single_value.field_iOV__I;
}

T200__GTPC_template& XID__Data__GTPC_template::t200()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__Data__GTPC::ALT_t200) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_t200 = new T200__GTPC_template(ANY_VALUE);
else single_value.field_t200 = new T200__GTPC_template;
single_value.union_selection = XID__Data__GTPC::ALT_t200;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_t200;
}

const T200__GTPC_template& XID__Data__GTPC_template::t200() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field t200 in a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
if (single_value.union_selection != XID__Data__GTPC::ALT_t200) TTCN_error("Accessing non-selected field t200 in a template of union type @GTPC_Types.XID_Data_GTPC.");
return *single_value.field_t200;
}

N200__GTPC_template& XID__Data__GTPC_template::n200()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__Data__GTPC::ALT_n200) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_n200 = new N200__GTPC_template(ANY_VALUE);
else single_value.field_n200 = new N200__GTPC_template;
single_value.union_selection = XID__Data__GTPC::ALT_n200;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_n200;
}

const N200__GTPC_template& XID__Data__GTPC_template::n200() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field n200 in a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
if (single_value.union_selection != XID__Data__GTPC::ALT_n200) TTCN_error("Accessing non-selected field n200 in a template of union type @GTPC_Types.XID_Data_GTPC.");
return *single_value.field_n200;
}

N201__U__GTPC_template& XID__Data__GTPC_template::n201__U()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__Data__GTPC::ALT_n201__U) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_n201__U = new N201__U__GTPC_template(ANY_VALUE);
else single_value.field_n201__U = new N201__U__GTPC_template;
single_value.union_selection = XID__Data__GTPC::ALT_n201__U;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_n201__U;
}

const N201__U__GTPC_template& XID__Data__GTPC_template::n201__U() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field n201_U in a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
if (single_value.union_selection != XID__Data__GTPC::ALT_n201__U) TTCN_error("Accessing non-selected field n201_U in a template of union type @GTPC_Types.XID_Data_GTPC.");
return *single_value.field_n201__U;
}

N201__I__GTPC_template& XID__Data__GTPC_template::n201__I()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__Data__GTPC::ALT_n201__I) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_n201__I = new N201__I__GTPC_template(ANY_VALUE);
else single_value.field_n201__I = new N201__I__GTPC_template;
single_value.union_selection = XID__Data__GTPC::ALT_n201__I;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_n201__I;
}

const N201__I__GTPC_template& XID__Data__GTPC_template::n201__I() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field n201_I in a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
if (single_value.union_selection != XID__Data__GTPC::ALT_n201__I) TTCN_error("Accessing non-selected field n201_I in a template of union type @GTPC_Types.XID_Data_GTPC.");
return *single_value.field_n201__I;
}

MD__GTPC_template& XID__Data__GTPC_template::mD()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__Data__GTPC::ALT_mD) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_mD = new MD__GTPC_template(ANY_VALUE);
else single_value.field_mD = new MD__GTPC_template;
single_value.union_selection = XID__Data__GTPC::ALT_mD;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_mD;
}

const MD__GTPC_template& XID__Data__GTPC_template::mD() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field mD in a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
if (single_value.union_selection != XID__Data__GTPC::ALT_mD) TTCN_error("Accessing non-selected field mD in a template of union type @GTPC_Types.XID_Data_GTPC.");
return *single_value.field_mD;
}

MU__GTPC_template& XID__Data__GTPC_template::mU()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__Data__GTPC::ALT_mU) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_mU = new MU__GTPC_template(ANY_VALUE);
else single_value.field_mU = new MU__GTPC_template;
single_value.union_selection = XID__Data__GTPC::ALT_mU;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_mU;
}

const MU__GTPC_template& XID__Data__GTPC_template::mU() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field mU in a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
if (single_value.union_selection != XID__Data__GTPC::ALT_mU) TTCN_error("Accessing non-selected field mU in a template of union type @GTPC_Types.XID_Data_GTPC.");
return *single_value.field_mU;
}

INTEGER_template& XID__Data__GTPC_template::kD()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__Data__GTPC::ALT_kD) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_kD = new INTEGER_template(ANY_VALUE);
else single_value.field_kD = new INTEGER_template;
single_value.union_selection = XID__Data__GTPC::ALT_kD;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_kD;
}

const INTEGER_template& XID__Data__GTPC_template::kD() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field kD in a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
if (single_value.union_selection != XID__Data__GTPC::ALT_kD) TTCN_error("Accessing non-selected field kD in a template of union type @GTPC_Types.XID_Data_GTPC.");
return *single_value.field_kD;
}

INTEGER_template& XID__Data__GTPC_template::kU()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__Data__GTPC::ALT_kU) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_kU = new INTEGER_template(ANY_VALUE);
else single_value.field_kU = new INTEGER_template;
single_value.union_selection = XID__Data__GTPC::ALT_kU;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_kU;
}

const INTEGER_template& XID__Data__GTPC_template::kU() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field kU in a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
if (single_value.union_selection != XID__Data__GTPC::ALT_kU) TTCN_error("Accessing non-selected field kU in a template of union type @GTPC_Types.XID_Data_GTPC.");
return *single_value.field_kU;
}

OCTETSTRING_template& XID__Data__GTPC_template::l3param()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__Data__GTPC::ALT_l3param) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_l3param = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_l3param = new OCTETSTRING_template;
single_value.union_selection = XID__Data__GTPC::ALT_l3param;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_l3param;
}

const OCTETSTRING_template& XID__Data__GTPC_template::l3param() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field l3param in a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
if (single_value.union_selection != XID__Data__GTPC::ALT_l3param) TTCN_error("Accessing non-selected field l3param in a template of union type @GTPC_Types.XID_Data_GTPC.");
return *single_value.field_l3param;
}

OCTETSTRING_template& XID__Data__GTPC_template::reset()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != XID__Data__GTPC::ALT_reset) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_reset = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_reset = new OCTETSTRING_template;
single_value.union_selection = XID__Data__GTPC::ALT_reset;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_reset;
}

const OCTETSTRING_template& XID__Data__GTPC_template::reset() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field reset in a non-specific template of union type @GTPC_Types.XID_Data_GTPC.");
if (single_value.union_selection != XID__Data__GTPC::ALT_reset) TTCN_error("Accessing non-selected field reset in a template of union type @GTPC_Types.XID_Data_GTPC.");
return *single_value.field_reset;
}

boolean XID__Data__GTPC_template::ischosen(XID__Data__GTPC::union_selection_type checked_selection) const
{
if (checked_selection == XID__Data__GTPC::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @GTPC_Types.XID_Data_GTPC.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == XID__Data__GTPC::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @GTPC_Types.XID_Data_GTPC.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @GTPC_Types.XID_Data_GTPC containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void XID__Data__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case XID__Data__GTPC::ALT_version:
TTCN_Logger::log_event_str("{ version := ");
single_value.field_version->log();
TTCN_Logger::log_event_str(" }");
break;
case XID__Data__GTPC::ALT_iOV__UI:
TTCN_Logger::log_event_str("{ iOV_UI := ");
single_value.field_iOV__UI->log();
TTCN_Logger::log_event_str(" }");
break;
case XID__Data__GTPC::ALT_iOV__I:
TTCN_Logger::log_event_str("{ iOV_I := ");
single_value.field_iOV__I->log();
TTCN_Logger::log_event_str(" }");
break;
case XID__Data__GTPC::ALT_t200:
TTCN_Logger::log_event_str("{ t200 := ");
single_value.field_t200->log();
TTCN_Logger::log_event_str(" }");
break;
case XID__Data__GTPC::ALT_n200:
TTCN_Logger::log_event_str("{ n200 := ");
single_value.field_n200->log();
TTCN_Logger::log_event_str(" }");
break;
case XID__Data__GTPC::ALT_n201__U:
TTCN_Logger::log_event_str("{ n201_U := ");
single_value.field_n201__U->log();
TTCN_Logger::log_event_str(" }");
break;
case XID__Data__GTPC::ALT_n201__I:
TTCN_Logger::log_event_str("{ n201_I := ");
single_value.field_n201__I->log();
TTCN_Logger::log_event_str(" }");
break;
case XID__Data__GTPC::ALT_mD:
TTCN_Logger::log_event_str("{ mD := ");
single_value.field_mD->log();
TTCN_Logger::log_event_str(" }");
break;
case XID__Data__GTPC::ALT_mU:
TTCN_Logger::log_event_str("{ mU := ");
single_value.field_mU->log();
TTCN_Logger::log_event_str(" }");
break;
case XID__Data__GTPC::ALT_kD:
TTCN_Logger::log_event_str("{ kD := ");
single_value.field_kD->log();
TTCN_Logger::log_event_str(" }");
break;
case XID__Data__GTPC::ALT_kU:
TTCN_Logger::log_event_str("{ kU := ");
single_value.field_kU->log();
TTCN_Logger::log_event_str(" }");
break;
case XID__Data__GTPC::ALT_l3param:
TTCN_Logger::log_event_str("{ l3param := ");
single_value.field_l3param->log();
TTCN_Logger::log_event_str(" }");
break;
case XID__Data__GTPC::ALT_reset:
TTCN_Logger::log_event_str("{ reset := ");
single_value.field_reset->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void XID__Data__GTPC_template::log_match(const XID__Data__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case XID__Data__GTPC::ALT_version:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".version");
single_value.field_version->log_match(match_value.version(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ version := ");
single_value.field_version->log_match(match_value.version(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case XID__Data__GTPC::ALT_iOV__UI:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".iOV_UI");
single_value.field_iOV__UI->log_match(match_value.iOV__UI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ iOV_UI := ");
single_value.field_iOV__UI->log_match(match_value.iOV__UI(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case XID__Data__GTPC::ALT_iOV__I:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".iOV_I");
single_value.field_iOV__I->log_match(match_value.iOV__I(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ iOV_I := ");
single_value.field_iOV__I->log_match(match_value.iOV__I(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case XID__Data__GTPC::ALT_t200:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".t200");
single_value.field_t200->log_match(match_value.t200(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ t200 := ");
single_value.field_t200->log_match(match_value.t200(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case XID__Data__GTPC::ALT_n200:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".n200");
single_value.field_n200->log_match(match_value.n200(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ n200 := ");
single_value.field_n200->log_match(match_value.n200(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case XID__Data__GTPC::ALT_n201__U:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".n201_U");
single_value.field_n201__U->log_match(match_value.n201__U(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ n201_U := ");
single_value.field_n201__U->log_match(match_value.n201__U(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case XID__Data__GTPC::ALT_n201__I:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".n201_I");
single_value.field_n201__I->log_match(match_value.n201__I(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ n201_I := ");
single_value.field_n201__I->log_match(match_value.n201__I(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case XID__Data__GTPC::ALT_mD:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".mD");
single_value.field_mD->log_match(match_value.mD(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ mD := ");
single_value.field_mD->log_match(match_value.mD(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case XID__Data__GTPC::ALT_mU:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".mU");
single_value.field_mU->log_match(match_value.mU(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ mU := ");
single_value.field_mU->log_match(match_value.mU(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case XID__Data__GTPC::ALT_kD:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".kD");
single_value.field_kD->log_match(match_value.kD(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ kD := ");
single_value.field_kD->log_match(match_value.kD(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case XID__Data__GTPC::ALT_kU:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".kU");
single_value.field_kU->log_match(match_value.kU(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ kU := ");
single_value.field_kU->log_match(match_value.kU(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case XID__Data__GTPC::ALT_l3param:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".l3param");
single_value.field_l3param->log_match(match_value.l3param(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ l3param := ");
single_value.field_l3param->log_match(match_value.l3param(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case XID__Data__GTPC::ALT_reset:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".reset");
single_value.field_reset->log_match(match_value.reset(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ reset := ");
single_value.field_reset->log_match(match_value.reset(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void XID__Data__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case XID__Data__GTPC::ALT_version:
single_value.field_version->set_implicit_omit(); break;
case XID__Data__GTPC::ALT_iOV__UI:
single_value.field_iOV__UI->set_implicit_omit(); break;
case XID__Data__GTPC::ALT_iOV__I:
single_value.field_iOV__I->set_implicit_omit(); break;
case XID__Data__GTPC::ALT_t200:
single_value.field_t200->set_implicit_omit(); break;
case XID__Data__GTPC::ALT_n200:
single_value.field_n200->set_implicit_omit(); break;
case XID__Data__GTPC::ALT_n201__U:
single_value.field_n201__U->set_implicit_omit(); break;
case XID__Data__GTPC::ALT_n201__I:
single_value.field_n201__I->set_implicit_omit(); break;
case XID__Data__GTPC::ALT_mD:
single_value.field_mD->set_implicit_omit(); break;
case XID__Data__GTPC::ALT_mU:
single_value.field_mU->set_implicit_omit(); break;
case XID__Data__GTPC::ALT_kD:
single_value.field_kD->set_implicit_omit(); break;
case XID__Data__GTPC::ALT_kU:
single_value.field_kU->set_implicit_omit(); break;
case XID__Data__GTPC::ALT_l3param:
single_value.field_l3param->set_implicit_omit(); break;
case XID__Data__GTPC::ALT_reset:
single_value.field_reset->set_implicit_omit(); break;
default: break;
}
}

void XID__Data__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case XID__Data__GTPC::ALT_version:
single_value.field_version->encode_text(text_buf);
break;
case XID__Data__GTPC::ALT_iOV__UI:
single_value.field_iOV__UI->encode_text(text_buf);
break;
case XID__Data__GTPC::ALT_iOV__I:
single_value.field_iOV__I->encode_text(text_buf);
break;
case XID__Data__GTPC::ALT_t200:
single_value.field_t200->encode_text(text_buf);
break;
case XID__Data__GTPC::ALT_n200:
single_value.field_n200->encode_text(text_buf);
break;
case XID__Data__GTPC::ALT_n201__U:
single_value.field_n201__U->encode_text(text_buf);
break;
case XID__Data__GTPC::ALT_n201__I:
single_value.field_n201__I->encode_text(text_buf);
break;
case XID__Data__GTPC::ALT_mD:
single_value.field_mD->encode_text(text_buf);
break;
case XID__Data__GTPC::ALT_mU:
single_value.field_mU->encode_text(text_buf);
break;
case XID__Data__GTPC::ALT_kD:
single_value.field_kD->encode_text(text_buf);
break;
case XID__Data__GTPC::ALT_kU:
single_value.field_kU->encode_text(text_buf);
break;
case XID__Data__GTPC::ALT_l3param:
single_value.field_l3param->encode_text(text_buf);
break;
case XID__Data__GTPC::ALT_reset:
single_value.field_reset->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @GTPC_Types.XID_Data_GTPC.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @GTPC_Types.XID_Data_GTPC.");
}
}

void XID__Data__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = XID__Data__GTPC::UNBOUND_VALUE;
XID__Data__GTPC::union_selection_type new_selection = (XID__Data__GTPC::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case XID__Data__GTPC::ALT_version:
single_value.field_version = new Version__GTPC_template;
single_value.field_version->decode_text(text_buf);
break;
case XID__Data__GTPC::ALT_iOV__UI:
single_value.field_iOV__UI = new OCTETSTRING_template;
single_value.field_iOV__UI->decode_text(text_buf);
break;
case XID__Data__GTPC::ALT_iOV__I:
single_value.field_iOV__I = new OCTETSTRING_template;
single_value.field_iOV__I->decode_text(text_buf);
break;
case XID__Data__GTPC::ALT_t200:
single_value.field_t200 = new T200__GTPC_template;
single_value.field_t200->decode_text(text_buf);
break;
case XID__Data__GTPC::ALT_n200:
single_value.field_n200 = new N200__GTPC_template;
single_value.field_n200->decode_text(text_buf);
break;
case XID__Data__GTPC::ALT_n201__U:
single_value.field_n201__U = new N201__U__GTPC_template;
single_value.field_n201__U->decode_text(text_buf);
break;
case XID__Data__GTPC::ALT_n201__I:
single_value.field_n201__I = new N201__I__GTPC_template;
single_value.field_n201__I->decode_text(text_buf);
break;
case XID__Data__GTPC::ALT_mD:
single_value.field_mD = new MD__GTPC_template;
single_value.field_mD->decode_text(text_buf);
break;
case XID__Data__GTPC::ALT_mU:
single_value.field_mU = new MU__GTPC_template;
single_value.field_mU->decode_text(text_buf);
break;
case XID__Data__GTPC::ALT_kD:
single_value.field_kD = new INTEGER_template;
single_value.field_kD->decode_text(text_buf);
break;
case XID__Data__GTPC::ALT_kU:
single_value.field_kU = new INTEGER_template;
single_value.field_kU->decode_text(text_buf);
break;
case XID__Data__GTPC::ALT_l3param:
single_value.field_l3param = new OCTETSTRING_template;
single_value.field_l3param->decode_text(text_buf);
break;
case XID__Data__GTPC::ALT_reset:
single_value.field_reset = new OCTETSTRING_template;
single_value.field_reset->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @GTPC_Types.XID_Data_GTPC.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new XID__Data__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @GTPC_Types.XID_Data_GTPC.");
}
}

boolean XID__Data__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean XID__Data__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void XID__Data__GTPC_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@GTPC_Types.XID_Data_GTPC'");
    }
    if (strcmp("version", param_field) == 0) {
      version().set_param(param);
      return;
    } else if (strcmp("iOV_UI", param_field) == 0) {
      iOV__UI().set_param(param);
      return;
    } else if (strcmp("iOV_I", param_field) == 0) {
      iOV__I().set_param(param);
      return;
    } else if (strcmp("t200", param_field) == 0) {
      t200().set_param(param);
      return;
    } else if (strcmp("n200", param_field) == 0) {
      n200().set_param(param);
      return;
    } else if (strcmp("n201_U", param_field) == 0) {
      n201__U().set_param(param);
      return;
    } else if (strcmp("n201_I", param_field) == 0) {
      n201__I().set_param(param);
      return;
    } else if (strcmp("mD", param_field) == 0) {
      mD().set_param(param);
      return;
    } else if (strcmp("mU", param_field) == 0) {
      mU().set_param(param);
      return;
    } else if (strcmp("kD", param_field) == 0) {
      kD().set_param(param);
      return;
    } else if (strcmp("kU", param_field) == 0) {
      kU().set_param(param);
      return;
    } else if (strcmp("l3param", param_field) == 0) {
      l3param().set_param(param);
      return;
    } else if (strcmp("reset", param_field) == 0) {
      reset().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@GTPC_Types.XID_Data_GTPC'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    XID__Data__GTPC_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@GTPC_Types.XID_Data_GTPC");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "version")) {
      version().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "iOV_UI")) {
      iOV__UI().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "iOV_I")) {
      iOV__I().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "t200")) {
      t200().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "n200")) {
      n200().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "n201_U")) {
      n201__U().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "n201_I")) {
      n201__I().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "mD")) {
      mD().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "mU")) {
      mU().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "kD")) {
      kD().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "kU")) {
      kU().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "l3param")) {
      l3param().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "reset")) {
      reset().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @GTPC_Types.XID_Data_GTPC.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    XID__Data__GTPC_template* precondition = new XID__Data__GTPC_template;
    precondition->set_param(*m_p->get_elem(0));
    XID__Data__GTPC_template* implied_template = new XID__Data__GTPC_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = XID__Data__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@GTPC_Types.XID_Data_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void XID__Data__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case XID__Data__GTPC::ALT_version:
single_value.field_version->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
return;
case XID__Data__GTPC::ALT_iOV__UI:
single_value.field_iOV__UI->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
return;
case XID__Data__GTPC::ALT_iOV__I:
single_value.field_iOV__I->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
return;
case XID__Data__GTPC::ALT_t200:
single_value.field_t200->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
return;
case XID__Data__GTPC::ALT_n200:
single_value.field_n200->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
return;
case XID__Data__GTPC::ALT_n201__U:
single_value.field_n201__U->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
return;
case XID__Data__GTPC::ALT_n201__I:
single_value.field_n201__I->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
return;
case XID__Data__GTPC::ALT_mD:
single_value.field_mD->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
return;
case XID__Data__GTPC::ALT_mU:
single_value.field_mU->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
return;
case XID__Data__GTPC::ALT_kD:
single_value.field_kD->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
return;
case XID__Data__GTPC::ALT_kU:
single_value.field_kU->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
return;
case XID__Data__GTPC::ALT_l3param:
single_value.field_l3param->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
return;
case XID__Data__GTPC::ALT_reset:
single_value.field_reset->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @GTPC_Types.XID_Data_GTPC.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.XID_Data_GTPC");
}

Version__GTPC::Version__GTPC()
{
}

Version__GTPC::Version__GTPC(const INTEGER& par_version__value,
    const BITSTRING& par_spare)
  :   field_version__value(par_version__value),
  field_spare(par_spare)
{
}

Version__GTPC::Version__GTPC(const Version__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.Version_GTPC.");
if (other_value.version__value().is_bound()) field_version__value = other_value.version__value();
else field_version__value.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void Version__GTPC::clean_up()
{
field_version__value.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* Version__GTPC::get_descriptor() const { return &Version__GTPC_descr_; }
Version__GTPC& Version__GTPC::operator=(const Version__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.Version_GTPC.");
  if (other_value.version__value().is_bound()) field_version__value = other_value.version__value();
  else field_version__value.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean Version__GTPC::operator==(const Version__GTPC& other_value) const
{
return field_version__value==other_value.field_version__value
  && field_spare==other_value.field_spare;
}

boolean Version__GTPC::is_bound() const
{
return (field_version__value.is_bound())
  || (field_spare.is_bound());
}
boolean Version__GTPC::is_value() const
{
return field_version__value.is_value()
  && field_spare.is_value();
}
void Version__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ version_value := ");
field_version__value.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void Version__GTPC::set_implicit_omit()
{
if (version__value().is_bound()) version__value().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void Version__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @GTPC_Types.Version_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) version__value().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "version_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          version__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.Version_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.Version_GTPC");
  }
}

void Version__GTPC::encode_text(Text_Buf& text_buf) const
{
field_version__value.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void Version__GTPC::decode_text(Text_Buf& text_buf)
{
field_version__value.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void Version__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Version__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Version__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, Version__GTPC_version__value_descr_.raw->forceomit);
  decoded_field_length = field_version__value.RAW_decode(Version__GTPC_version__value_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Version__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, Version__GTPC_version__value_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT4_descr_.raw);
  encoded_length += field_version__value.RAW_encode(Version__GTPC_version__value_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct Version__GTPC_template::single_value_struct {
INTEGER_template field_version__value;
BITSTRING_template field_spare;
};

void Version__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_version__value = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void Version__GTPC_template::copy_value(const Version__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.version__value().is_bound()) {
  single_value->field_version__value = other_value.version__value();
} else {
  single_value->field_version__value.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Version__GTPC_template::copy_template(const Version__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.version__value().get_selection()) {
single_value->field_version__value = other_value.version__value();
} else {
single_value->field_version__value.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Version__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Version__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new Version__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.Version_GTPC.");
break;
}
set_selection(other_value);
}

Version__GTPC_template::Version__GTPC_template()
{
}

Version__GTPC_template::Version__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Version__GTPC_template::Version__GTPC_template(const Version__GTPC& other_value)
{
copy_value(other_value);
}

Version__GTPC_template::Version__GTPC_template(const OPTIONAL<Version__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Version__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.Version_GTPC from an unbound optional field.");
}
}

Version__GTPC_template::Version__GTPC_template(Version__GTPC_template* p_precondition, Version__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Version__GTPC_template::Version__GTPC_template(Dynamic_Match_Interface<Version__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Version__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Version__GTPC_template::Version__GTPC_template(const Version__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Version__GTPC_template::~Version__GTPC_template()
{
clean_up();
}

Version__GTPC_template& Version__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Version__GTPC_template& Version__GTPC_template::operator=(const Version__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Version__GTPC_template& Version__GTPC_template::operator=(const OPTIONAL<Version__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Version__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.Version_GTPC.");
}
return *this;
}

Version__GTPC_template& Version__GTPC_template::operator=(const Version__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Version__GTPC_template::match(const Version__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.version__value().is_bound()) return FALSE;
if(!single_value->field_version__value.match(other_value.version__value(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.Version_GTPC.");
}
return FALSE;
}

boolean Version__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_version__value.is_bound()
 || single_value->field_spare.is_bound();
}

boolean Version__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_version__value.is_value()
 && single_value->field_spare.is_value();
}

void Version__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Version__GTPC Version__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.Version_GTPC.");
Version__GTPC ret_val;
if (single_value->field_version__value.is_bound()) {
ret_val.version__value() = single_value->field_version__value.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void Version__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.Version_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Version__GTPC_template[list_length];
}

Version__GTPC_template& Version__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.Version_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.Version_GTPC.");
return value_list.list_value[list_index];
}

INTEGER_template& Version__GTPC_template::version__value()
{
set_specific();
return single_value->field_version__value;
}

const INTEGER_template& Version__GTPC_template::version__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field version_value of a non-specific template of type @GTPC_Types.Version_GTPC.");
return single_value->field_version__value;
}

BITSTRING_template& Version__GTPC_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& Version__GTPC_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @GTPC_Types.Version_GTPC.");
return single_value->field_spare;
}

int Version__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Version_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.Version_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Version_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Version_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Version_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Version_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Version_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Version_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.Version_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.Version_GTPC.");
  }
  return 0;
}

void Version__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ version_value := ");
single_value->field_version__value.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Version__GTPC_template::log_match(const Version__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_version__value.match(match_value.version__value(), legacy)){
TTCN_Logger::log_logmatch_info(".version_value");
single_value->field_version__value.log_match(match_value.version__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ version_value := ");
single_value->field_version__value.log_match(match_value.version__value(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Version__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (version__value().is_bound()) version__value().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void Version__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_version__value.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.Version_GTPC.");
}
}

void Version__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_version__value.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Version__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.Version_GTPC.");
}
}

void Version__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Version__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @GTPC_Types.Version_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) version__value().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "version_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          version__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.Version_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Version__GTPC_template* precondition = new Version__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    Version__GTPC_template* implied_template = new Version__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Version__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.Version_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void Version__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_version__value.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.Version_GTPC");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.Version_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.Version_GTPC");
}

boolean Version__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Version__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

T200__GTPC::T200__GTPC()
{
}

T200__GTPC::T200__GTPC(const BITSTRING& par_spare,
    const INTEGER& par_t200Value)
  :   field_spare(par_spare),
  field_t200Value(par_t200Value)
{
}

T200__GTPC::T200__GTPC(const T200__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.T200_GTPC.");
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.t200Value().is_bound()) field_t200Value = other_value.t200Value();
else field_t200Value.clean_up();
}

void T200__GTPC::clean_up()
{
field_spare.clean_up();
field_t200Value.clean_up();
}

const TTCN_Typedescriptor_t* T200__GTPC::get_descriptor() const { return &T200__GTPC_descr_; }
T200__GTPC& T200__GTPC::operator=(const T200__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.T200_GTPC.");
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.t200Value().is_bound()) field_t200Value = other_value.t200Value();
  else field_t200Value.clean_up();
}
return *this;
}

boolean T200__GTPC::operator==(const T200__GTPC& other_value) const
{
return field_spare==other_value.field_spare
  && field_t200Value==other_value.field_t200Value;
}

boolean T200__GTPC::is_bound() const
{
return (field_spare.is_bound())
  || (field_t200Value.is_bound());
}
boolean T200__GTPC::is_value() const
{
return field_spare.is_value()
  && field_t200Value.is_value();
}
void T200__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", t200Value := ");
field_t200Value.log();
TTCN_Logger::log_event_str(" }");
}

void T200__GTPC::set_implicit_omit()
{
if (spare().is_bound()) spare().set_implicit_omit();
if (t200Value().is_bound()) t200Value().set_implicit_omit();
}

void T200__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @GTPC_Types.T200_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) t200Value().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "t200Value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          t200Value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.T200_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.T200_GTPC");
  }
}

void T200__GTPC::encode_text(Text_Buf& text_buf) const
{
field_spare.encode_text(text_buf);
field_t200Value.encode_text(text_buf);
}

void T200__GTPC::decode_text(Text_Buf& text_buf)
{
field_spare.decode_text(text_buf);
field_t200Value.decode_text(text_buf);
}

void T200__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void T200__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int T200__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, T200__GTPC_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(T200__GTPC_spare_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, T200__GTPC_t200Value_descr_.raw->forceomit);
  decoded_field_length = field_t200Value.RAW_decode(T200__GTPC_t200Value_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int T200__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, T200__GTPC_spare_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, T200__GTPC_t200Value_descr_.raw);
  encoded_length += field_spare.RAW_encode(T200__GTPC_spare_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_t200Value.RAW_encode(T200__GTPC_t200Value_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct T200__GTPC_template::single_value_struct {
BITSTRING_template field_spare;
INTEGER_template field_t200Value;
};

void T200__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_spare = ANY_VALUE;
single_value->field_t200Value = ANY_VALUE;
}
}
}

void T200__GTPC_template::copy_value(const T200__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.t200Value().is_bound()) {
  single_value->field_t200Value = other_value.t200Value();
} else {
  single_value->field_t200Value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void T200__GTPC_template::copy_template(const T200__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.t200Value().get_selection()) {
single_value->field_t200Value = other_value.t200Value();
} else {
single_value->field_t200Value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new T200__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new T200__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new T200__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.T200_GTPC.");
break;
}
set_selection(other_value);
}

T200__GTPC_template::T200__GTPC_template()
{
}

T200__GTPC_template::T200__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

T200__GTPC_template::T200__GTPC_template(const T200__GTPC& other_value)
{
copy_value(other_value);
}

T200__GTPC_template::T200__GTPC_template(const OPTIONAL<T200__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const T200__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.T200_GTPC from an unbound optional field.");
}
}

T200__GTPC_template::T200__GTPC_template(T200__GTPC_template* p_precondition, T200__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

T200__GTPC_template::T200__GTPC_template(Dynamic_Match_Interface<T200__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<T200__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

T200__GTPC_template::T200__GTPC_template(const T200__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

T200__GTPC_template::~T200__GTPC_template()
{
clean_up();
}

T200__GTPC_template& T200__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

T200__GTPC_template& T200__GTPC_template::operator=(const T200__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

T200__GTPC_template& T200__GTPC_template::operator=(const OPTIONAL<T200__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const T200__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.T200_GTPC.");
}
return *this;
}

T200__GTPC_template& T200__GTPC_template::operator=(const T200__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean T200__GTPC_template::match(const T200__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.t200Value().is_bound()) return FALSE;
if(!single_value->field_t200Value.match(other_value.t200Value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.T200_GTPC.");
}
return FALSE;
}

boolean T200__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_spare.is_bound()
 || single_value->field_t200Value.is_bound();
}

boolean T200__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_spare.is_value()
 && single_value->field_t200Value.is_value();
}

void T200__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

T200__GTPC T200__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.T200_GTPC.");
T200__GTPC ret_val;
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_t200Value.is_bound()) {
ret_val.t200Value() = single_value->field_t200Value.valueof();
}
return ret_val;
}

void T200__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.T200_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new T200__GTPC_template[list_length];
}

T200__GTPC_template& T200__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.T200_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.T200_GTPC.");
return value_list.list_value[list_index];
}

BITSTRING_template& T200__GTPC_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& T200__GTPC_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @GTPC_Types.T200_GTPC.");
return single_value->field_spare;
}

INTEGER_template& T200__GTPC_template::t200Value()
{
set_specific();
return single_value->field_t200Value;
}

const INTEGER_template& T200__GTPC_template::t200Value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field t200Value of a non-specific template of type @GTPC_Types.T200_GTPC.");
return single_value->field_t200Value;
}

int T200__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.T200_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.T200_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.T200_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.T200_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.T200_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.T200_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.T200_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.T200_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.T200_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.T200_GTPC.");
  }
  return 0;
}

void T200__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", t200Value := ");
single_value->field_t200Value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void T200__GTPC_template::log_match(const T200__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_t200Value.match(match_value.t200Value(), legacy)){
TTCN_Logger::log_logmatch_info(".t200Value");
single_value->field_t200Value.log_match(match_value.t200Value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", t200Value := ");
single_value->field_t200Value.log_match(match_value.t200Value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void T200__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (spare().is_bound()) spare().set_implicit_omit();
if (t200Value().is_bound()) t200Value().set_implicit_omit();
}

void T200__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_spare.encode_text(text_buf);
single_value->field_t200Value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.T200_GTPC.");
}
}

void T200__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_spare.decode_text(text_buf);
single_value->field_t200Value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new T200__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.T200_GTPC.");
}
}

void T200__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    T200__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @GTPC_Types.T200_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) t200Value().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "t200Value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          t200Value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.T200_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    T200__GTPC_template* precondition = new T200__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    T200__GTPC_template* implied_template = new T200__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = T200__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.T200_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void T200__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.T200_GTPC");
single_value->field_t200Value.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.T200_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.T200_GTPC");
}

boolean T200__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean T200__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

N200__GTPC::N200__GTPC()
{
}

N200__GTPC::N200__GTPC(const INTEGER& par_retransmissions,
    const BITSTRING& par_spare)
  :   field_retransmissions(par_retransmissions),
  field_spare(par_spare)
{
}

N200__GTPC::N200__GTPC(const N200__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.N200_GTPC.");
if (other_value.retransmissions().is_bound()) field_retransmissions = other_value.retransmissions();
else field_retransmissions.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void N200__GTPC::clean_up()
{
field_retransmissions.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* N200__GTPC::get_descriptor() const { return &N200__GTPC_descr_; }
N200__GTPC& N200__GTPC::operator=(const N200__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.N200_GTPC.");
  if (other_value.retransmissions().is_bound()) field_retransmissions = other_value.retransmissions();
  else field_retransmissions.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean N200__GTPC::operator==(const N200__GTPC& other_value) const
{
return field_retransmissions==other_value.field_retransmissions
  && field_spare==other_value.field_spare;
}

boolean N200__GTPC::is_bound() const
{
return (field_retransmissions.is_bound())
  || (field_spare.is_bound());
}
boolean N200__GTPC::is_value() const
{
return field_retransmissions.is_value()
  && field_spare.is_value();
}
void N200__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ retransmissions := ");
field_retransmissions.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void N200__GTPC::set_implicit_omit()
{
if (retransmissions().is_bound()) retransmissions().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void N200__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @GTPC_Types.N200_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) retransmissions().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "retransmissions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          retransmissions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.N200_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.N200_GTPC");
  }
}

void N200__GTPC::encode_text(Text_Buf& text_buf) const
{
field_retransmissions.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void N200__GTPC::decode_text(Text_Buf& text_buf)
{
field_retransmissions.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void N200__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void N200__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int N200__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, N200__GTPC_retransmissions_descr_.raw->forceomit);
  decoded_field_length = field_retransmissions.RAW_decode(N200__GTPC_retransmissions_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int N200__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, N200__GTPC_retransmissions_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT4_descr_.raw);
  encoded_length += field_retransmissions.RAW_encode(N200__GTPC_retransmissions_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct N200__GTPC_template::single_value_struct {
INTEGER_template field_retransmissions;
BITSTRING_template field_spare;
};

void N200__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_retransmissions = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void N200__GTPC_template::copy_value(const N200__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.retransmissions().is_bound()) {
  single_value->field_retransmissions = other_value.retransmissions();
} else {
  single_value->field_retransmissions.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void N200__GTPC_template::copy_template(const N200__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.retransmissions().get_selection()) {
single_value->field_retransmissions = other_value.retransmissions();
} else {
single_value->field_retransmissions.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new N200__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new N200__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new N200__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.N200_GTPC.");
break;
}
set_selection(other_value);
}

N200__GTPC_template::N200__GTPC_template()
{
}

N200__GTPC_template::N200__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

N200__GTPC_template::N200__GTPC_template(const N200__GTPC& other_value)
{
copy_value(other_value);
}

N200__GTPC_template::N200__GTPC_template(const OPTIONAL<N200__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const N200__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.N200_GTPC from an unbound optional field.");
}
}

N200__GTPC_template::N200__GTPC_template(N200__GTPC_template* p_precondition, N200__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

N200__GTPC_template::N200__GTPC_template(Dynamic_Match_Interface<N200__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<N200__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

N200__GTPC_template::N200__GTPC_template(const N200__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

N200__GTPC_template::~N200__GTPC_template()
{
clean_up();
}

N200__GTPC_template& N200__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

N200__GTPC_template& N200__GTPC_template::operator=(const N200__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

N200__GTPC_template& N200__GTPC_template::operator=(const OPTIONAL<N200__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const N200__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.N200_GTPC.");
}
return *this;
}

N200__GTPC_template& N200__GTPC_template::operator=(const N200__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean N200__GTPC_template::match(const N200__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.retransmissions().is_bound()) return FALSE;
if(!single_value->field_retransmissions.match(other_value.retransmissions(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.N200_GTPC.");
}
return FALSE;
}

boolean N200__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_retransmissions.is_bound()
 || single_value->field_spare.is_bound();
}

boolean N200__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_retransmissions.is_value()
 && single_value->field_spare.is_value();
}

void N200__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

N200__GTPC N200__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.N200_GTPC.");
N200__GTPC ret_val;
if (single_value->field_retransmissions.is_bound()) {
ret_val.retransmissions() = single_value->field_retransmissions.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void N200__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.N200_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new N200__GTPC_template[list_length];
}

N200__GTPC_template& N200__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.N200_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.N200_GTPC.");
return value_list.list_value[list_index];
}

INTEGER_template& N200__GTPC_template::retransmissions()
{
set_specific();
return single_value->field_retransmissions;
}

const INTEGER_template& N200__GTPC_template::retransmissions() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field retransmissions of a non-specific template of type @GTPC_Types.N200_GTPC.");
return single_value->field_retransmissions;
}

BITSTRING_template& N200__GTPC_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& N200__GTPC_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @GTPC_Types.N200_GTPC.");
return single_value->field_spare;
}

int N200__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N200_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.N200_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N200_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N200_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N200_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N200_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N200_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N200_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N200_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.N200_GTPC.");
  }
  return 0;
}

void N200__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ retransmissions := ");
single_value->field_retransmissions.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void N200__GTPC_template::log_match(const N200__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_retransmissions.match(match_value.retransmissions(), legacy)){
TTCN_Logger::log_logmatch_info(".retransmissions");
single_value->field_retransmissions.log_match(match_value.retransmissions(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ retransmissions := ");
single_value->field_retransmissions.log_match(match_value.retransmissions(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void N200__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (retransmissions().is_bound()) retransmissions().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void N200__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_retransmissions.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.N200_GTPC.");
}
}

void N200__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_retransmissions.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new N200__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.N200_GTPC.");
}
}

void N200__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    N200__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @GTPC_Types.N200_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) retransmissions().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "retransmissions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          retransmissions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.N200_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    N200__GTPC_template* precondition = new N200__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    N200__GTPC_template* implied_template = new N200__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = N200__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.N200_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void N200__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_retransmissions.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.N200_GTPC");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.N200_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.N200_GTPC");
}

boolean N200__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean N200__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

N201__U__GTPC::N201__U__GTPC()
{
}

N201__U__GTPC::N201__U__GTPC(const BITSTRING& par_spare,
    const INTEGER& par_n201UValue)
  :   field_spare(par_spare),
  field_n201UValue(par_n201UValue)
{
}

N201__U__GTPC::N201__U__GTPC(const N201__U__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.N201_U_GTPC.");
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.n201UValue().is_bound()) field_n201UValue = other_value.n201UValue();
else field_n201UValue.clean_up();
}

void N201__U__GTPC::clean_up()
{
field_spare.clean_up();
field_n201UValue.clean_up();
}

const TTCN_Typedescriptor_t* N201__U__GTPC::get_descriptor() const { return &N201__U__GTPC_descr_; }
N201__U__GTPC& N201__U__GTPC::operator=(const N201__U__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.N201_U_GTPC.");
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.n201UValue().is_bound()) field_n201UValue = other_value.n201UValue();
  else field_n201UValue.clean_up();
}
return *this;
}

boolean N201__U__GTPC::operator==(const N201__U__GTPC& other_value) const
{
return field_spare==other_value.field_spare
  && field_n201UValue==other_value.field_n201UValue;
}

boolean N201__U__GTPC::is_bound() const
{
return (field_spare.is_bound())
  || (field_n201UValue.is_bound());
}
boolean N201__U__GTPC::is_value() const
{
return field_spare.is_value()
  && field_n201UValue.is_value();
}
void N201__U__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", n201UValue := ");
field_n201UValue.log();
TTCN_Logger::log_event_str(" }");
}

void N201__U__GTPC::set_implicit_omit()
{
if (spare().is_bound()) spare().set_implicit_omit();
if (n201UValue().is_bound()) n201UValue().set_implicit_omit();
}

void N201__U__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @GTPC_Types.N201_U_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) n201UValue().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "n201UValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          n201UValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.N201_U_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.N201_U_GTPC");
  }
}

void N201__U__GTPC::encode_text(Text_Buf& text_buf) const
{
field_spare.encode_text(text_buf);
field_n201UValue.encode_text(text_buf);
}

void N201__U__GTPC::decode_text(Text_Buf& text_buf)
{
field_spare.decode_text(text_buf);
field_n201UValue.decode_text(text_buf);
}

void N201__U__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void N201__U__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int N201__U__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, N201__U__GTPC_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(N201__U__GTPC_spare_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, N201__U__GTPC_n201UValue_descr_.raw->forceomit);
  decoded_field_length = field_n201UValue.RAW_decode(N201__U__GTPC_n201UValue_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int N201__U__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, N201__U__GTPC_spare_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, N201__U__GTPC_n201UValue_descr_.raw);
  encoded_length += field_spare.RAW_encode(N201__U__GTPC_spare_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_n201UValue.RAW_encode(N201__U__GTPC_n201UValue_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct N201__U__GTPC_template::single_value_struct {
BITSTRING_template field_spare;
INTEGER_template field_n201UValue;
};

void N201__U__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_spare = ANY_VALUE;
single_value->field_n201UValue = ANY_VALUE;
}
}
}

void N201__U__GTPC_template::copy_value(const N201__U__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.n201UValue().is_bound()) {
  single_value->field_n201UValue = other_value.n201UValue();
} else {
  single_value->field_n201UValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void N201__U__GTPC_template::copy_template(const N201__U__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.n201UValue().get_selection()) {
single_value->field_n201UValue = other_value.n201UValue();
} else {
single_value->field_n201UValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new N201__U__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new N201__U__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new N201__U__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.N201_U_GTPC.");
break;
}
set_selection(other_value);
}

N201__U__GTPC_template::N201__U__GTPC_template()
{
}

N201__U__GTPC_template::N201__U__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

N201__U__GTPC_template::N201__U__GTPC_template(const N201__U__GTPC& other_value)
{
copy_value(other_value);
}

N201__U__GTPC_template::N201__U__GTPC_template(const OPTIONAL<N201__U__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const N201__U__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.N201_U_GTPC from an unbound optional field.");
}
}

N201__U__GTPC_template::N201__U__GTPC_template(N201__U__GTPC_template* p_precondition, N201__U__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

N201__U__GTPC_template::N201__U__GTPC_template(Dynamic_Match_Interface<N201__U__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<N201__U__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

N201__U__GTPC_template::N201__U__GTPC_template(const N201__U__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

N201__U__GTPC_template::~N201__U__GTPC_template()
{
clean_up();
}

N201__U__GTPC_template& N201__U__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

N201__U__GTPC_template& N201__U__GTPC_template::operator=(const N201__U__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

N201__U__GTPC_template& N201__U__GTPC_template::operator=(const OPTIONAL<N201__U__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const N201__U__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.N201_U_GTPC.");
}
return *this;
}

N201__U__GTPC_template& N201__U__GTPC_template::operator=(const N201__U__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean N201__U__GTPC_template::match(const N201__U__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.n201UValue().is_bound()) return FALSE;
if(!single_value->field_n201UValue.match(other_value.n201UValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.N201_U_GTPC.");
}
return FALSE;
}

boolean N201__U__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_spare.is_bound()
 || single_value->field_n201UValue.is_bound();
}

boolean N201__U__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_spare.is_value()
 && single_value->field_n201UValue.is_value();
}

void N201__U__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

N201__U__GTPC N201__U__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.N201_U_GTPC.");
N201__U__GTPC ret_val;
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_n201UValue.is_bound()) {
ret_val.n201UValue() = single_value->field_n201UValue.valueof();
}
return ret_val;
}

void N201__U__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.N201_U_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new N201__U__GTPC_template[list_length];
}

N201__U__GTPC_template& N201__U__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.N201_U_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.N201_U_GTPC.");
return value_list.list_value[list_index];
}

BITSTRING_template& N201__U__GTPC_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& N201__U__GTPC_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @GTPC_Types.N201_U_GTPC.");
return single_value->field_spare;
}

INTEGER_template& N201__U__GTPC_template::n201UValue()
{
set_specific();
return single_value->field_n201UValue;
}

const INTEGER_template& N201__U__GTPC_template::n201UValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field n201UValue of a non-specific template of type @GTPC_Types.N201_U_GTPC.");
return single_value->field_n201UValue;
}

int N201__U__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_U_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.N201_U_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_U_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_U_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_U_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_U_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_U_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_U_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_U_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.N201_U_GTPC.");
  }
  return 0;
}

void N201__U__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", n201UValue := ");
single_value->field_n201UValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void N201__U__GTPC_template::log_match(const N201__U__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_n201UValue.match(match_value.n201UValue(), legacy)){
TTCN_Logger::log_logmatch_info(".n201UValue");
single_value->field_n201UValue.log_match(match_value.n201UValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", n201UValue := ");
single_value->field_n201UValue.log_match(match_value.n201UValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void N201__U__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (spare().is_bound()) spare().set_implicit_omit();
if (n201UValue().is_bound()) n201UValue().set_implicit_omit();
}

void N201__U__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_spare.encode_text(text_buf);
single_value->field_n201UValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.N201_U_GTPC.");
}
}

void N201__U__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_spare.decode_text(text_buf);
single_value->field_n201UValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new N201__U__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.N201_U_GTPC.");
}
}

void N201__U__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    N201__U__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @GTPC_Types.N201_U_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) n201UValue().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "n201UValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          n201UValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.N201_U_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    N201__U__GTPC_template* precondition = new N201__U__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    N201__U__GTPC_template* implied_template = new N201__U__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = N201__U__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.N201_U_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void N201__U__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.N201_U_GTPC");
single_value->field_n201UValue.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.N201_U_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.N201_U_GTPC");
}

boolean N201__U__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean N201__U__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

N201__I__GTPC::N201__I__GTPC()
{
}

N201__I__GTPC::N201__I__GTPC(const BITSTRING& par_spare,
    const INTEGER& par_n201IValue)
  :   field_spare(par_spare),
  field_n201IValue(par_n201IValue)
{
}

N201__I__GTPC::N201__I__GTPC(const N201__I__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.N201_I_GTPC.");
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.n201IValue().is_bound()) field_n201IValue = other_value.n201IValue();
else field_n201IValue.clean_up();
}

void N201__I__GTPC::clean_up()
{
field_spare.clean_up();
field_n201IValue.clean_up();
}

const TTCN_Typedescriptor_t* N201__I__GTPC::get_descriptor() const { return &N201__I__GTPC_descr_; }
N201__I__GTPC& N201__I__GTPC::operator=(const N201__I__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.N201_I_GTPC.");
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.n201IValue().is_bound()) field_n201IValue = other_value.n201IValue();
  else field_n201IValue.clean_up();
}
return *this;
}

boolean N201__I__GTPC::operator==(const N201__I__GTPC& other_value) const
{
return field_spare==other_value.field_spare
  && field_n201IValue==other_value.field_n201IValue;
}

boolean N201__I__GTPC::is_bound() const
{
return (field_spare.is_bound())
  || (field_n201IValue.is_bound());
}
boolean N201__I__GTPC::is_value() const
{
return field_spare.is_value()
  && field_n201IValue.is_value();
}
void N201__I__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", n201IValue := ");
field_n201IValue.log();
TTCN_Logger::log_event_str(" }");
}

void N201__I__GTPC::set_implicit_omit()
{
if (spare().is_bound()) spare().set_implicit_omit();
if (n201IValue().is_bound()) n201IValue().set_implicit_omit();
}

void N201__I__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @GTPC_Types.N201_I_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) n201IValue().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "n201IValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          n201IValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.N201_I_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.N201_I_GTPC");
  }
}

void N201__I__GTPC::encode_text(Text_Buf& text_buf) const
{
field_spare.encode_text(text_buf);
field_n201IValue.encode_text(text_buf);
}

void N201__I__GTPC::decode_text(Text_Buf& text_buf)
{
field_spare.decode_text(text_buf);
field_n201IValue.decode_text(text_buf);
}

void N201__I__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void N201__I__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int N201__I__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, N201__I__GTPC_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(N201__I__GTPC_spare_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, N201__I__GTPC_n201IValue_descr_.raw->forceomit);
  decoded_field_length = field_n201IValue.RAW_decode(N201__I__GTPC_n201IValue_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int N201__I__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, N201__I__GTPC_spare_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, N201__I__GTPC_n201IValue_descr_.raw);
  encoded_length += field_spare.RAW_encode(N201__I__GTPC_spare_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_n201IValue.RAW_encode(N201__I__GTPC_n201IValue_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct N201__I__GTPC_template::single_value_struct {
BITSTRING_template field_spare;
INTEGER_template field_n201IValue;
};

void N201__I__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_spare = ANY_VALUE;
single_value->field_n201IValue = ANY_VALUE;
}
}
}

void N201__I__GTPC_template::copy_value(const N201__I__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.n201IValue().is_bound()) {
  single_value->field_n201IValue = other_value.n201IValue();
} else {
  single_value->field_n201IValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void N201__I__GTPC_template::copy_template(const N201__I__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.n201IValue().get_selection()) {
single_value->field_n201IValue = other_value.n201IValue();
} else {
single_value->field_n201IValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new N201__I__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new N201__I__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new N201__I__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.N201_I_GTPC.");
break;
}
set_selection(other_value);
}

N201__I__GTPC_template::N201__I__GTPC_template()
{
}

N201__I__GTPC_template::N201__I__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

N201__I__GTPC_template::N201__I__GTPC_template(const N201__I__GTPC& other_value)
{
copy_value(other_value);
}

N201__I__GTPC_template::N201__I__GTPC_template(const OPTIONAL<N201__I__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const N201__I__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.N201_I_GTPC from an unbound optional field.");
}
}

N201__I__GTPC_template::N201__I__GTPC_template(N201__I__GTPC_template* p_precondition, N201__I__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

N201__I__GTPC_template::N201__I__GTPC_template(Dynamic_Match_Interface<N201__I__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<N201__I__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

N201__I__GTPC_template::N201__I__GTPC_template(const N201__I__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

N201__I__GTPC_template::~N201__I__GTPC_template()
{
clean_up();
}

N201__I__GTPC_template& N201__I__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

N201__I__GTPC_template& N201__I__GTPC_template::operator=(const N201__I__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

N201__I__GTPC_template& N201__I__GTPC_template::operator=(const OPTIONAL<N201__I__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const N201__I__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.N201_I_GTPC.");
}
return *this;
}

N201__I__GTPC_template& N201__I__GTPC_template::operator=(const N201__I__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean N201__I__GTPC_template::match(const N201__I__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.n201IValue().is_bound()) return FALSE;
if(!single_value->field_n201IValue.match(other_value.n201IValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.N201_I_GTPC.");
}
return FALSE;
}

boolean N201__I__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_spare.is_bound()
 || single_value->field_n201IValue.is_bound();
}

boolean N201__I__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_spare.is_value()
 && single_value->field_n201IValue.is_value();
}

void N201__I__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

N201__I__GTPC N201__I__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.N201_I_GTPC.");
N201__I__GTPC ret_val;
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_n201IValue.is_bound()) {
ret_val.n201IValue() = single_value->field_n201IValue.valueof();
}
return ret_val;
}

void N201__I__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.N201_I_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new N201__I__GTPC_template[list_length];
}

N201__I__GTPC_template& N201__I__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.N201_I_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.N201_I_GTPC.");
return value_list.list_value[list_index];
}

BITSTRING_template& N201__I__GTPC_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& N201__I__GTPC_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @GTPC_Types.N201_I_GTPC.");
return single_value->field_spare;
}

INTEGER_template& N201__I__GTPC_template::n201IValue()
{
set_specific();
return single_value->field_n201IValue;
}

const INTEGER_template& N201__I__GTPC_template::n201IValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field n201IValue of a non-specific template of type @GTPC_Types.N201_I_GTPC.");
return single_value->field_n201IValue;
}

int N201__I__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_I_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.N201_I_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_I_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_I_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_I_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_I_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_I_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_I_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.N201_I_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.N201_I_GTPC.");
  }
  return 0;
}

void N201__I__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", n201IValue := ");
single_value->field_n201IValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void N201__I__GTPC_template::log_match(const N201__I__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_n201IValue.match(match_value.n201IValue(), legacy)){
TTCN_Logger::log_logmatch_info(".n201IValue");
single_value->field_n201IValue.log_match(match_value.n201IValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", n201IValue := ");
single_value->field_n201IValue.log_match(match_value.n201IValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void N201__I__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (spare().is_bound()) spare().set_implicit_omit();
if (n201IValue().is_bound()) n201IValue().set_implicit_omit();
}

void N201__I__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_spare.encode_text(text_buf);
single_value->field_n201IValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.N201_I_GTPC.");
}
}

void N201__I__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_spare.decode_text(text_buf);
single_value->field_n201IValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new N201__I__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.N201_I_GTPC.");
}
}

void N201__I__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    N201__I__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @GTPC_Types.N201_I_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) n201IValue().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "n201IValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          n201IValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.N201_I_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    N201__I__GTPC_template* precondition = new N201__I__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    N201__I__GTPC_template* implied_template = new N201__I__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = N201__I__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.N201_I_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void N201__I__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.N201_I_GTPC");
single_value->field_n201IValue.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.N201_I_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.N201_I_GTPC");
}

boolean N201__I__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean N201__I__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

MD__GTPC::MD__GTPC()
{
}

MD__GTPC::MD__GTPC(const BITSTRING& par_spare,
    const INTEGER& par_mDValue)
  :   field_spare(par_spare),
  field_mDValue(par_mDValue)
{
}

MD__GTPC::MD__GTPC(const MD__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.MD_GTPC.");
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.mDValue().is_bound()) field_mDValue = other_value.mDValue();
else field_mDValue.clean_up();
}

void MD__GTPC::clean_up()
{
field_spare.clean_up();
field_mDValue.clean_up();
}

const TTCN_Typedescriptor_t* MD__GTPC::get_descriptor() const { return &MD__GTPC_descr_; }
MD__GTPC& MD__GTPC::operator=(const MD__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.MD_GTPC.");
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.mDValue().is_bound()) field_mDValue = other_value.mDValue();
  else field_mDValue.clean_up();
}
return *this;
}

boolean MD__GTPC::operator==(const MD__GTPC& other_value) const
{
return field_spare==other_value.field_spare
  && field_mDValue==other_value.field_mDValue;
}

boolean MD__GTPC::is_bound() const
{
return (field_spare.is_bound())
  || (field_mDValue.is_bound());
}
boolean MD__GTPC::is_value() const
{
return field_spare.is_value()
  && field_mDValue.is_value();
}
void MD__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", mDValue := ");
field_mDValue.log();
TTCN_Logger::log_event_str(" }");
}

void MD__GTPC::set_implicit_omit()
{
if (spare().is_bound()) spare().set_implicit_omit();
if (mDValue().is_bound()) mDValue().set_implicit_omit();
}

void MD__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @GTPC_Types.MD_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mDValue().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mDValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mDValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.MD_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.MD_GTPC");
  }
}

void MD__GTPC::encode_text(Text_Buf& text_buf) const
{
field_spare.encode_text(text_buf);
field_mDValue.encode_text(text_buf);
}

void MD__GTPC::decode_text(Text_Buf& text_buf)
{
field_spare.decode_text(text_buf);
field_mDValue.decode_text(text_buf);
}

void MD__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void MD__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int MD__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, MD__GTPC_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(MD__GTPC_spare_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, MD__GTPC_mDValue_descr_.raw->forceomit);
  decoded_field_length = field_mDValue.RAW_decode(MD__GTPC_mDValue_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int MD__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, MD__GTPC_spare_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, MD__GTPC_mDValue_descr_.raw);
  encoded_length += field_spare.RAW_encode(MD__GTPC_spare_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_mDValue.RAW_encode(MD__GTPC_mDValue_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct MD__GTPC_template::single_value_struct {
BITSTRING_template field_spare;
INTEGER_template field_mDValue;
};

void MD__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_spare = ANY_VALUE;
single_value->field_mDValue = ANY_VALUE;
}
}
}

void MD__GTPC_template::copy_value(const MD__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.mDValue().is_bound()) {
  single_value->field_mDValue = other_value.mDValue();
} else {
  single_value->field_mDValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void MD__GTPC_template::copy_template(const MD__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mDValue().get_selection()) {
single_value->field_mDValue = other_value.mDValue();
} else {
single_value->field_mDValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new MD__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new MD__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new MD__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.MD_GTPC.");
break;
}
set_selection(other_value);
}

MD__GTPC_template::MD__GTPC_template()
{
}

MD__GTPC_template::MD__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

MD__GTPC_template::MD__GTPC_template(const MD__GTPC& other_value)
{
copy_value(other_value);
}

MD__GTPC_template::MD__GTPC_template(const OPTIONAL<MD__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MD__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.MD_GTPC from an unbound optional field.");
}
}

MD__GTPC_template::MD__GTPC_template(MD__GTPC_template* p_precondition, MD__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

MD__GTPC_template::MD__GTPC_template(Dynamic_Match_Interface<MD__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<MD__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

MD__GTPC_template::MD__GTPC_template(const MD__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

MD__GTPC_template::~MD__GTPC_template()
{
clean_up();
}

MD__GTPC_template& MD__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

MD__GTPC_template& MD__GTPC_template::operator=(const MD__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

MD__GTPC_template& MD__GTPC_template::operator=(const OPTIONAL<MD__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MD__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.MD_GTPC.");
}
return *this;
}

MD__GTPC_template& MD__GTPC_template::operator=(const MD__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean MD__GTPC_template::match(const MD__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.mDValue().is_bound()) return FALSE;
if(!single_value->field_mDValue.match(other_value.mDValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.MD_GTPC.");
}
return FALSE;
}

boolean MD__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_spare.is_bound()
 || single_value->field_mDValue.is_bound();
}

boolean MD__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_spare.is_value()
 && single_value->field_mDValue.is_value();
}

void MD__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

MD__GTPC MD__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.MD_GTPC.");
MD__GTPC ret_val;
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_mDValue.is_bound()) {
ret_val.mDValue() = single_value->field_mDValue.valueof();
}
return ret_val;
}

void MD__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.MD_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new MD__GTPC_template[list_length];
}

MD__GTPC_template& MD__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.MD_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.MD_GTPC.");
return value_list.list_value[list_index];
}

BITSTRING_template& MD__GTPC_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& MD__GTPC_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @GTPC_Types.MD_GTPC.");
return single_value->field_spare;
}

INTEGER_template& MD__GTPC_template::mDValue()
{
set_specific();
return single_value->field_mDValue;
}

const INTEGER_template& MD__GTPC_template::mDValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mDValue of a non-specific template of type @GTPC_Types.MD_GTPC.");
return single_value->field_mDValue;
}

int MD__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MD_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.MD_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MD_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MD_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MD_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MD_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MD_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MD_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MD_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.MD_GTPC.");
  }
  return 0;
}

void MD__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", mDValue := ");
single_value->field_mDValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void MD__GTPC_template::log_match(const MD__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mDValue.match(match_value.mDValue(), legacy)){
TTCN_Logger::log_logmatch_info(".mDValue");
single_value->field_mDValue.log_match(match_value.mDValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", mDValue := ");
single_value->field_mDValue.log_match(match_value.mDValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void MD__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (spare().is_bound()) spare().set_implicit_omit();
if (mDValue().is_bound()) mDValue().set_implicit_omit();
}

void MD__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_spare.encode_text(text_buf);
single_value->field_mDValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.MD_GTPC.");
}
}

void MD__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_spare.decode_text(text_buf);
single_value->field_mDValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new MD__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.MD_GTPC.");
}
}

void MD__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    MD__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @GTPC_Types.MD_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mDValue().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mDValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mDValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.MD_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    MD__GTPC_template* precondition = new MD__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    MD__GTPC_template* implied_template = new MD__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = MD__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.MD_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void MD__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MD_GTPC");
single_value->field_mDValue.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MD_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.MD_GTPC");
}

boolean MD__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean MD__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

MU__GTPC::MU__GTPC()
{
}

MU__GTPC::MU__GTPC(const BITSTRING& par_spare,
    const INTEGER& par_mUValue)
  :   field_spare(par_spare),
  field_mUValue(par_mUValue)
{
}

MU__GTPC::MU__GTPC(const MU__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.MU_GTPC.");
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.mUValue().is_bound()) field_mUValue = other_value.mUValue();
else field_mUValue.clean_up();
}

void MU__GTPC::clean_up()
{
field_spare.clean_up();
field_mUValue.clean_up();
}

const TTCN_Typedescriptor_t* MU__GTPC::get_descriptor() const { return &MU__GTPC_descr_; }
MU__GTPC& MU__GTPC::operator=(const MU__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.MU_GTPC.");
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.mUValue().is_bound()) field_mUValue = other_value.mUValue();
  else field_mUValue.clean_up();
}
return *this;
}

boolean MU__GTPC::operator==(const MU__GTPC& other_value) const
{
return field_spare==other_value.field_spare
  && field_mUValue==other_value.field_mUValue;
}

boolean MU__GTPC::is_bound() const
{
return (field_spare.is_bound())
  || (field_mUValue.is_bound());
}
boolean MU__GTPC::is_value() const
{
return field_spare.is_value()
  && field_mUValue.is_value();
}
void MU__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", mUValue := ");
field_mUValue.log();
TTCN_Logger::log_event_str(" }");
}

void MU__GTPC::set_implicit_omit()
{
if (spare().is_bound()) spare().set_implicit_omit();
if (mUValue().is_bound()) mUValue().set_implicit_omit();
}

void MU__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @GTPC_Types.MU_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mUValue().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mUValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mUValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.MU_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.MU_GTPC");
  }
}

void MU__GTPC::encode_text(Text_Buf& text_buf) const
{
field_spare.encode_text(text_buf);
field_mUValue.encode_text(text_buf);
}

void MU__GTPC::decode_text(Text_Buf& text_buf)
{
field_spare.decode_text(text_buf);
field_mUValue.decode_text(text_buf);
}

void MU__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void MU__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int MU__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, MU__GTPC_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(MU__GTPC_spare_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, MU__GTPC_mUValue_descr_.raw->forceomit);
  decoded_field_length = field_mUValue.RAW_decode(MU__GTPC_mUValue_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int MU__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, MU__GTPC_spare_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, MU__GTPC_mUValue_descr_.raw);
  encoded_length += field_spare.RAW_encode(MU__GTPC_spare_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_mUValue.RAW_encode(MU__GTPC_mUValue_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct MU__GTPC_template::single_value_struct {
BITSTRING_template field_spare;
INTEGER_template field_mUValue;
};

void MU__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_spare = ANY_VALUE;
single_value->field_mUValue = ANY_VALUE;
}
}
}

void MU__GTPC_template::copy_value(const MU__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.mUValue().is_bound()) {
  single_value->field_mUValue = other_value.mUValue();
} else {
  single_value->field_mUValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void MU__GTPC_template::copy_template(const MU__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mUValue().get_selection()) {
single_value->field_mUValue = other_value.mUValue();
} else {
single_value->field_mUValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new MU__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new MU__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new MU__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.MU_GTPC.");
break;
}
set_selection(other_value);
}

MU__GTPC_template::MU__GTPC_template()
{
}

MU__GTPC_template::MU__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

MU__GTPC_template::MU__GTPC_template(const MU__GTPC& other_value)
{
copy_value(other_value);
}

MU__GTPC_template::MU__GTPC_template(const OPTIONAL<MU__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MU__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.MU_GTPC from an unbound optional field.");
}
}

MU__GTPC_template::MU__GTPC_template(MU__GTPC_template* p_precondition, MU__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

MU__GTPC_template::MU__GTPC_template(Dynamic_Match_Interface<MU__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<MU__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

MU__GTPC_template::MU__GTPC_template(const MU__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

MU__GTPC_template::~MU__GTPC_template()
{
clean_up();
}

MU__GTPC_template& MU__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

MU__GTPC_template& MU__GTPC_template::operator=(const MU__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

MU__GTPC_template& MU__GTPC_template::operator=(const OPTIONAL<MU__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MU__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.MU_GTPC.");
}
return *this;
}

MU__GTPC_template& MU__GTPC_template::operator=(const MU__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean MU__GTPC_template::match(const MU__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.mUValue().is_bound()) return FALSE;
if(!single_value->field_mUValue.match(other_value.mUValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.MU_GTPC.");
}
return FALSE;
}

boolean MU__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_spare.is_bound()
 || single_value->field_mUValue.is_bound();
}

boolean MU__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_spare.is_value()
 && single_value->field_mUValue.is_value();
}

void MU__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

MU__GTPC MU__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.MU_GTPC.");
MU__GTPC ret_val;
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_mUValue.is_bound()) {
ret_val.mUValue() = single_value->field_mUValue.valueof();
}
return ret_val;
}

void MU__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.MU_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new MU__GTPC_template[list_length];
}

MU__GTPC_template& MU__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.MU_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.MU_GTPC.");
return value_list.list_value[list_index];
}

BITSTRING_template& MU__GTPC_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& MU__GTPC_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @GTPC_Types.MU_GTPC.");
return single_value->field_spare;
}

INTEGER_template& MU__GTPC_template::mUValue()
{
set_specific();
return single_value->field_mUValue;
}

const INTEGER_template& MU__GTPC_template::mUValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mUValue of a non-specific template of type @GTPC_Types.MU_GTPC.");
return single_value->field_mUValue;
}

int MU__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MU_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.MU_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MU_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MU_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MU_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MU_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MU_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MU_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MU_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.MU_GTPC.");
  }
  return 0;
}

void MU__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", mUValue := ");
single_value->field_mUValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void MU__GTPC_template::log_match(const MU__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mUValue.match(match_value.mUValue(), legacy)){
TTCN_Logger::log_logmatch_info(".mUValue");
single_value->field_mUValue.log_match(match_value.mUValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", mUValue := ");
single_value->field_mUValue.log_match(match_value.mUValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void MU__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (spare().is_bound()) spare().set_implicit_omit();
if (mUValue().is_bound()) mUValue().set_implicit_omit();
}

void MU__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_spare.encode_text(text_buf);
single_value->field_mUValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.MU_GTPC.");
}
}

void MU__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_spare.decode_text(text_buf);
single_value->field_mUValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new MU__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.MU_GTPC.");
}
}

void MU__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    MU__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @GTPC_Types.MU_GTPC has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mUValue().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mUValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mUValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.MU_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    MU__GTPC_template* precondition = new MU__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    MU__GTPC_template* implied_template = new MU__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = MU__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.MU_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void MU__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MU_GTPC");
single_value->field_mUValue.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MU_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.MU_GTPC");
}

boolean MU__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean MU__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

XID__GTPC::XID__GTPC()
{
}

XID__GTPC::XID__GTPC(const BITSTRING& par_xl,
    const BITSTRING& par_typefield,
    const XID__length__GTPC& par_xID__length,
    const XID__Data__GTPC& par_xID__Data)
  :   field_xl(par_xl),
  field_typefield(par_typefield),
  field_xID__length(par_xID__length),
  field_xID__Data(par_xID__Data)
{
}

XID__GTPC::XID__GTPC(const XID__GTPC& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.XID_GTPC.");
if (other_value.xl().is_bound()) field_xl = other_value.xl();
else field_xl.clean_up();
if (other_value.typefield().is_bound()) field_typefield = other_value.typefield();
else field_typefield.clean_up();
if (other_value.xID__length().is_bound()) field_xID__length = other_value.xID__length();
else field_xID__length.clean_up();
if (other_value.xID__Data().is_bound()) field_xID__Data = other_value.xID__Data();
else field_xID__Data.clean_up();
}

void XID__GTPC::clean_up()
{
field_xl.clean_up();
field_typefield.clean_up();
field_xID__length.clean_up();
field_xID__Data.clean_up();
}

const TTCN_Typedescriptor_t* XID__GTPC::get_descriptor() const { return &XID__GTPC_descr_; }
XID__GTPC& XID__GTPC::operator=(const XID__GTPC& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.XID_GTPC.");
  if (other_value.xl().is_bound()) field_xl = other_value.xl();
  else field_xl.clean_up();
  if (other_value.typefield().is_bound()) field_typefield = other_value.typefield();
  else field_typefield.clean_up();
  if (other_value.xID__length().is_bound()) field_xID__length = other_value.xID__length();
  else field_xID__length.clean_up();
  if (other_value.xID__Data().is_bound()) field_xID__Data = other_value.xID__Data();
  else field_xID__Data.clean_up();
}
return *this;
}

boolean XID__GTPC::operator==(const XID__GTPC& other_value) const
{
return field_xl==other_value.field_xl
  && field_typefield==other_value.field_typefield
  && field_xID__length==other_value.field_xID__length
  && field_xID__Data==other_value.field_xID__Data;
}

boolean XID__GTPC::is_bound() const
{
return (field_xl.is_bound())
  || (field_typefield.is_bound())
  || (field_xID__length.is_bound())
  || (field_xID__Data.is_bound());
}
boolean XID__GTPC::is_value() const
{
return field_xl.is_value()
  && field_typefield.is_value()
  && field_xID__length.is_value()
  && field_xID__Data.is_value();
}
void XID__GTPC::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ xl := ");
field_xl.log();
TTCN_Logger::log_event_str(", typefield := ");
field_typefield.log();
TTCN_Logger::log_event_str(", xID_length := ");
field_xID__length.log();
TTCN_Logger::log_event_str(", xID_Data := ");
field_xID__Data.log();
TTCN_Logger::log_event_str(" }");
}

void XID__GTPC::set_implicit_omit()
{
if (xl().is_bound()) xl().set_implicit_omit();
if (typefield().is_bound()) typefield().set_implicit_omit();
if (xID__length().is_bound()) xID__length().set_implicit_omit();
if (xID__Data().is_bound()) xID__Data().set_implicit_omit();
}

void XID__GTPC::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @GTPC_Types.XID_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) xl().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) typefield().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) xID__length().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) xID__Data().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "xl")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          xl().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "typefield")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          typefield().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "xID_length")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          xID__length().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "xID_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          xID__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.XID_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.XID_GTPC");
  }
}

void XID__GTPC::encode_text(Text_Buf& text_buf) const
{
field_xl.encode_text(text_buf);
field_typefield.encode_text(text_buf);
field_xID__length.encode_text(text_buf);
field_xID__Data.encode_text(text_buf);
}

void XID__GTPC::decode_text(Text_Buf& text_buf)
{
field_xl.decode_text(text_buf);
field_typefield.decode_text(text_buf);
field_xID__length.decode_text(text_buf);
field_xID__Data.decode_text(text_buf);
}

void XID__GTPC::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void XID__GTPC::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int XID__GTPC::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, XID__GTPC_xl_descr_.raw->forceomit);
  decoded_field_length = field_xl.RAW_decode(XID__GTPC_xl_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, XID__GTPC_typefield_descr_.raw->forceomit);
  decoded_field_length = field_typefield.RAW_decode(XID__GTPC_typefield_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_xl ==  bs_24) selected_field = 0;
  else if (field_xl ==  bs_3) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, XID__GTPC_xID__length_descr_.raw->forceomit);
  decoded_field_length = field_xID__length.RAW_decode(XID__GTPC_xID__length_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_xID__length.get_selection()) {
  case XID__length__GTPC::ALT_short__len: {
    INTEGER tmp1 = field_xID__length.short__len().convert_to_Integer(XID__length__GTPC_short__len_descr_);
    field_xID__length.short__len() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case XID__length__GTPC::ALT_long__len: {
    INTEGER tmp2 = field_xID__length.long__len().convert_to_Integer(XID__length__GTPC_long__len_descr_);
    field_xID__length.long__len() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  if (field_typefield ==  bs_11) selected_field = 0;
  else if (field_typefield ==  bs_12) selected_field = 1;
  else if (field_typefield ==  bs_13) selected_field = 2;
  else if (field_typefield ==  bs_14) selected_field = 3;
  else if (field_typefield ==  bs_15) selected_field = 4;
  else if (field_typefield ==  bs_16) selected_field = 5;
  else if (field_typefield ==  bs_17) selected_field = 6;
  else if (field_typefield ==  bs_18) selected_field = 7;
  else if (field_typefield ==  bs_19) selected_field = 8;
  else if (field_typefield ==  bs_20) selected_field = 9;
  else if (field_typefield ==  bs_21) selected_field = 10;
  else if (field_typefield ==  bs_22) selected_field = 11;
  else if (field_typefield ==  bs_23) selected_field = 12;
  else selected_field = -1;
  RAW_Force_Omit field_3_force_omit(3, force_omit, XID__GTPC_xID__Data_descr_.raw->forceomit);
  decoded_field_length = field_xID__Data.RAW_decode(XID__GTPC_xID__Data_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, selected_field, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int XID__GTPC::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, XID__GTPC_xl_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, XID__GTPC_typefield_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, XID__GTPC_xID__length_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, XID__GTPC_xID__Data_descr_.raw);
  encoded_length += field_xl.RAW_encode(XID__GTPC_xl_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_typefield.RAW_encode(XID__GTPC_typefield_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_xID__length.RAW_encode(XID__GTPC_xID__length_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_xID__Data.RAW_encode(XID__GTPC_xID__Data_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_xID__length.get_selection()) {
  case XID__length__GTPC::ALT_short__len:
  if (field_xl !=  bs_24) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_24.RAW_encode(XID__GTPC_xl_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case XID__length__GTPC::ALT_long__len:
  if (field_xl !=  bs_3) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_3.RAW_encode(XID__GTPC_xl_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  switch (field_xID__Data.get_selection()) {
  case XID__Data__GTPC::ALT_version:
  if (field_typefield !=  bs_11) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_11.RAW_encode(XID__GTPC_typefield_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case XID__Data__GTPC::ALT_iOV__UI:
  if (field_typefield !=  bs_12) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_12.RAW_encode(XID__GTPC_typefield_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case XID__Data__GTPC::ALT_iOV__I:
  if (field_typefield !=  bs_13) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_13.RAW_encode(XID__GTPC_typefield_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case XID__Data__GTPC::ALT_t200:
  if (field_typefield !=  bs_14) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_14.RAW_encode(XID__GTPC_typefield_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case XID__Data__GTPC::ALT_n200:
  if (field_typefield !=  bs_15) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_15.RAW_encode(XID__GTPC_typefield_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case XID__Data__GTPC::ALT_n201__U:
  if (field_typefield !=  bs_16) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_16.RAW_encode(XID__GTPC_typefield_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case XID__Data__GTPC::ALT_n201__I:
  if (field_typefield !=  bs_17) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_17.RAW_encode(XID__GTPC_typefield_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case XID__Data__GTPC::ALT_mD:
  if (field_typefield !=  bs_18) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_18.RAW_encode(XID__GTPC_typefield_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case XID__Data__GTPC::ALT_mU:
  if (field_typefield !=  bs_19) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_19.RAW_encode(XID__GTPC_typefield_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case XID__Data__GTPC::ALT_kD:
  if (field_typefield !=  bs_20) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_20.RAW_encode(XID__GTPC_typefield_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case XID__Data__GTPC::ALT_kU:
  if (field_typefield !=  bs_21) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_21.RAW_encode(XID__GTPC_typefield_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case XID__Data__GTPC::ALT_l3param:
  if (field_typefield !=  bs_22) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_22.RAW_encode(XID__GTPC_typefield_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case XID__Data__GTPC::ALT_reset:
  if (field_typefield !=  bs_23) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_23.RAW_encode(XID__GTPC_typefield_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  return myleaf.length = encoded_length;
}

struct XID__GTPC_template::single_value_struct {
BITSTRING_template field_xl;
BITSTRING_template field_typefield;
XID__length__GTPC_template field_xID__length;
XID__Data__GTPC_template field_xID__Data;
};

void XID__GTPC_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_xl = ANY_VALUE;
single_value->field_typefield = ANY_VALUE;
single_value->field_xID__length = ANY_VALUE;
single_value->field_xID__Data = ANY_VALUE;
}
}
}

void XID__GTPC_template::copy_value(const XID__GTPC& other_value)
{
single_value = new single_value_struct;
if (other_value.xl().is_bound()) {
  single_value->field_xl = other_value.xl();
} else {
  single_value->field_xl.clean_up();
}
if (other_value.typefield().is_bound()) {
  single_value->field_typefield = other_value.typefield();
} else {
  single_value->field_typefield.clean_up();
}
if (other_value.xID__length().is_bound()) {
  single_value->field_xID__length = other_value.xID__length();
} else {
  single_value->field_xID__length.clean_up();
}
if (other_value.xID__Data().is_bound()) {
  single_value->field_xID__Data = other_value.xID__Data();
} else {
  single_value->field_xID__Data.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void XID__GTPC_template::copy_template(const XID__GTPC_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.xl().get_selection()) {
single_value->field_xl = other_value.xl();
} else {
single_value->field_xl.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.typefield().get_selection()) {
single_value->field_typefield = other_value.typefield();
} else {
single_value->field_typefield.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.xID__length().get_selection()) {
single_value->field_xID__length = other_value.xID__length();
} else {
single_value->field_xID__length.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.xID__Data().get_selection()) {
single_value->field_xID__Data = other_value.xID__Data();
} else {
single_value->field_xID__Data.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new XID__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new XID__GTPC_template(*other_value.implication_.precondition);
implication_.implied_template = new XID__GTPC_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.XID_GTPC.");
break;
}
set_selection(other_value);
}

XID__GTPC_template::XID__GTPC_template()
{
}

XID__GTPC_template::XID__GTPC_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

XID__GTPC_template::XID__GTPC_template(const XID__GTPC& other_value)
{
copy_value(other_value);
}

XID__GTPC_template::XID__GTPC_template(const OPTIONAL<XID__GTPC>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const XID__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.XID_GTPC from an unbound optional field.");
}
}

XID__GTPC_template::XID__GTPC_template(XID__GTPC_template* p_precondition, XID__GTPC_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

XID__GTPC_template::XID__GTPC_template(Dynamic_Match_Interface<XID__GTPC>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<XID__GTPC>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

XID__GTPC_template::XID__GTPC_template(const XID__GTPC_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

XID__GTPC_template::~XID__GTPC_template()
{
clean_up();
}

XID__GTPC_template& XID__GTPC_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

XID__GTPC_template& XID__GTPC_template::operator=(const XID__GTPC& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

XID__GTPC_template& XID__GTPC_template::operator=(const OPTIONAL<XID__GTPC>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const XID__GTPC&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.XID_GTPC.");
}
return *this;
}

XID__GTPC_template& XID__GTPC_template::operator=(const XID__GTPC_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean XID__GTPC_template::match(const XID__GTPC& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.xl().is_bound()) return FALSE;
if(!single_value->field_xl.match(other_value.xl(), legacy))return FALSE;
if(!other_value.typefield().is_bound()) return FALSE;
if(!single_value->field_typefield.match(other_value.typefield(), legacy))return FALSE;
if(!other_value.xID__length().is_bound()) return FALSE;
if(!single_value->field_xID__length.match(other_value.xID__length(), legacy))return FALSE;
if(!other_value.xID__Data().is_bound()) return FALSE;
if(!single_value->field_xID__Data.match(other_value.xID__Data(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.XID_GTPC.");
}
return FALSE;
}

boolean XID__GTPC_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_xl.is_bound()
 || single_value->field_typefield.is_bound()
 || single_value->field_xID__length.is_bound()
 || single_value->field_xID__Data.is_bound();
}

boolean XID__GTPC_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_xl.is_value()
 && single_value->field_typefield.is_value()
 && single_value->field_xID__length.is_value()
 && single_value->field_xID__Data.is_value();
}

void XID__GTPC_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

XID__GTPC XID__GTPC_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.XID_GTPC.");
XID__GTPC ret_val;
if (single_value->field_xl.is_bound()) {
ret_val.xl() = single_value->field_xl.valueof();
}
if (single_value->field_typefield.is_bound()) {
ret_val.typefield() = single_value->field_typefield.valueof();
}
if (single_value->field_xID__length.is_bound()) {
ret_val.xID__length() = single_value->field_xID__length.valueof();
}
if (single_value->field_xID__Data.is_bound()) {
ret_val.xID__Data() = single_value->field_xID__Data.valueof();
}
return ret_val;
}

void XID__GTPC_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.XID_GTPC.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new XID__GTPC_template[list_length];
}

XID__GTPC_template& XID__GTPC_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.XID_GTPC.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.XID_GTPC.");
return value_list.list_value[list_index];
}

BITSTRING_template& XID__GTPC_template::xl()
{
set_specific();
return single_value->field_xl;
}

const BITSTRING_template& XID__GTPC_template::xl() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field xl of a non-specific template of type @GTPC_Types.XID_GTPC.");
return single_value->field_xl;
}

BITSTRING_template& XID__GTPC_template::typefield()
{
set_specific();
return single_value->field_typefield;
}

const BITSTRING_template& XID__GTPC_template::typefield() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field typefield of a non-specific template of type @GTPC_Types.XID_GTPC.");
return single_value->field_typefield;
}

XID__length__GTPC_template& XID__GTPC_template::xID__length()
{
set_specific();
return single_value->field_xID__length;
}

const XID__length__GTPC_template& XID__GTPC_template::xID__length() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field xID_length of a non-specific template of type @GTPC_Types.XID_GTPC.");
return single_value->field_xID__length;
}

XID__Data__GTPC_template& XID__GTPC_template::xID__Data()
{
set_specific();
return single_value->field_xID__Data;
}

const XID__Data__GTPC_template& XID__GTPC_template::xID__Data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field xID_Data of a non-specific template of type @GTPC_Types.XID_GTPC.");
return single_value->field_xID__Data;
}

int XID__GTPC_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.XID_GTPC which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.XID_GTPC containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.XID_GTPC containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.XID_GTPC containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.XID_GTPC containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.XID_GTPC containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.XID_GTPC containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.XID_GTPC containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.XID_GTPC containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.XID_GTPC.");
  }
  return 0;
}

void XID__GTPC_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ xl := ");
single_value->field_xl.log();
TTCN_Logger::log_event_str(", typefield := ");
single_value->field_typefield.log();
TTCN_Logger::log_event_str(", xID_length := ");
single_value->field_xID__length.log();
TTCN_Logger::log_event_str(", xID_Data := ");
single_value->field_xID__Data.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void XID__GTPC_template::log_match(const XID__GTPC& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_xl.match(match_value.xl(), legacy)){
TTCN_Logger::log_logmatch_info(".xl");
single_value->field_xl.log_match(match_value.xl(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_typefield.match(match_value.typefield(), legacy)){
TTCN_Logger::log_logmatch_info(".typefield");
single_value->field_typefield.log_match(match_value.typefield(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_xID__length.match(match_value.xID__length(), legacy)){
TTCN_Logger::log_logmatch_info(".xID_length");
single_value->field_xID__length.log_match(match_value.xID__length(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_xID__Data.match(match_value.xID__Data(), legacy)){
TTCN_Logger::log_logmatch_info(".xID_Data");
single_value->field_xID__Data.log_match(match_value.xID__Data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ xl := ");
single_value->field_xl.log_match(match_value.xl(), legacy);
TTCN_Logger::log_event_str(", typefield := ");
single_value->field_typefield.log_match(match_value.typefield(), legacy);
TTCN_Logger::log_event_str(", xID_length := ");
single_value->field_xID__length.log_match(match_value.xID__length(), legacy);
TTCN_Logger::log_event_str(", xID_Data := ");
single_value->field_xID__Data.log_match(match_value.xID__Data(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void XID__GTPC_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (xl().is_bound()) xl().set_implicit_omit();
if (typefield().is_bound()) typefield().set_implicit_omit();
if (xID__length().is_bound()) xID__length().set_implicit_omit();
if (xID__Data().is_bound()) xID__Data().set_implicit_omit();
}

void XID__GTPC_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_xl.encode_text(text_buf);
single_value->field_typefield.encode_text(text_buf);
single_value->field_xID__length.encode_text(text_buf);
single_value->field_xID__Data.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.XID_GTPC.");
}
}

void XID__GTPC_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_xl.decode_text(text_buf);
single_value->field_typefield.decode_text(text_buf);
single_value->field_xID__length.decode_text(text_buf);
single_value->field_xID__Data.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new XID__GTPC_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.XID_GTPC.");
}
}

void XID__GTPC_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    XID__GTPC_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @GTPC_Types.XID_GTPC has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) xl().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) typefield().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) xID__length().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) xID__Data().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "xl")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          xl().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "typefield")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          typefield().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "xID_length")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          xID__length().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "xID_Data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          xID__Data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.XID_GTPC: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    XID__GTPC_template* precondition = new XID__GTPC_template;
    precondition->set_param(*param.get_elem(0));
    XID__GTPC_template* implied_template = new XID__GTPC_template;
    implied_template->set_param(*param.get_elem(1));
    *this = XID__GTPC_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.XID_GTPC");
  }
  is_ifpresent = param.get_ifpresent();
}

void XID__GTPC_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_xl.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_GTPC");
single_value->field_typefield.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_GTPC");
single_value->field_xID__length.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_GTPC");
single_value->field_xID__Data.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.XID_GTPC");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.XID_GTPC");
}

boolean XID__GTPC_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean XID__GTPC_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

MS__InfoChangeReportingAction::MS__InfoChangeReportingAction()
{
}

MS__InfoChangeReportingAction::MS__InfoChangeReportingAction(const OCTETSTRING& par_type__gtpc,
    const INTEGER& par_lengthf,
    const OCTETSTRING& par_actionfield)
  :   field_type__gtpc(par_type__gtpc),
  field_lengthf(par_lengthf),
  field_actionfield(par_actionfield)
{
}

MS__InfoChangeReportingAction::MS__InfoChangeReportingAction(const MS__InfoChangeReportingAction& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.MS_InfoChangeReportingAction.");
if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
else field_type__gtpc.clean_up();
if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
else field_lengthf.clean_up();
if (other_value.actionfield().is_bound()) field_actionfield = other_value.actionfield();
else field_actionfield.clean_up();
}

void MS__InfoChangeReportingAction::clean_up()
{
field_type__gtpc.clean_up();
field_lengthf.clean_up();
field_actionfield.clean_up();
}

const TTCN_Typedescriptor_t* MS__InfoChangeReportingAction::get_descriptor() const { return &MS__InfoChangeReportingAction_descr_; }
MS__InfoChangeReportingAction& MS__InfoChangeReportingAction::operator=(const MS__InfoChangeReportingAction& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.MS_InfoChangeReportingAction.");
  if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
  else field_type__gtpc.clean_up();
  if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
  else field_lengthf.clean_up();
  if (other_value.actionfield().is_bound()) field_actionfield = other_value.actionfield();
  else field_actionfield.clean_up();
}
return *this;
}

boolean MS__InfoChangeReportingAction::operator==(const MS__InfoChangeReportingAction& other_value) const
{
return field_type__gtpc==other_value.field_type__gtpc
  && field_lengthf==other_value.field_lengthf
  && field_actionfield==other_value.field_actionfield;
}

boolean MS__InfoChangeReportingAction::is_bound() const
{
return (field_type__gtpc.is_bound())
  || (field_lengthf.is_bound())
  || (field_actionfield.is_bound());
}
boolean MS__InfoChangeReportingAction::is_value() const
{
return field_type__gtpc.is_value()
  && field_lengthf.is_value()
  && field_actionfield.is_value();
}
void MS__InfoChangeReportingAction::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ type_gtpc := ");
field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
field_lengthf.log();
TTCN_Logger::log_event_str(", actionfield := ");
field_actionfield.log();
TTCN_Logger::log_event_str(" }");
}

void MS__InfoChangeReportingAction::set_implicit_omit()
{
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (actionfield().is_bound()) actionfield().set_implicit_omit();
}

void MS__InfoChangeReportingAction::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @GTPC_Types.MS_InfoChangeReportingAction has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) actionfield().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "actionfield")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          actionfield().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.MS_InfoChangeReportingAction: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.MS_InfoChangeReportingAction");
  }
}

void MS__InfoChangeReportingAction::encode_text(Text_Buf& text_buf) const
{
field_type__gtpc.encode_text(text_buf);
field_lengthf.encode_text(text_buf);
field_actionfield.encode_text(text_buf);
}

void MS__InfoChangeReportingAction::decode_text(Text_Buf& text_buf)
{
field_type__gtpc.decode_text(text_buf);
field_lengthf.decode_text(text_buf);
field_actionfield.decode_text(text_buf);
}

void MS__InfoChangeReportingAction::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void MS__InfoChangeReportingAction::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int MS__InfoChangeReportingAction::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_type__gtpc.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, MS__InfoChangeReportingAction_lengthf_descr_.raw->forceomit);
  decoded_field_length = field_lengthf.RAW_decode(MS__InfoChangeReportingAction_lengthf_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthf.convert_to_Integer(MS__InfoChangeReportingAction_lengthf_descr_);
  field_lengthf = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_actionfield.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_type__gtpc !=  os_42) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int MS__InfoChangeReportingAction::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, MS__InfoChangeReportingAction_lengthf_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  encoded_length += field_type__gtpc.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &MS__InfoChangeReportingAction_lengthf_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_actionfield.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  if (field_type__gtpc !=  os_42) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_42.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct MS__InfoChangeReportingAction_template::single_value_struct {
OCTETSTRING_template field_type__gtpc;
INTEGER_template field_lengthf;
OCTETSTRING_template field_actionfield;
};

void MS__InfoChangeReportingAction_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_type__gtpc = ANY_VALUE;
single_value->field_lengthf = ANY_VALUE;
single_value->field_actionfield = ANY_VALUE;
}
}
}

void MS__InfoChangeReportingAction_template::copy_value(const MS__InfoChangeReportingAction& other_value)
{
single_value = new single_value_struct;
if (other_value.type__gtpc().is_bound()) {
  single_value->field_type__gtpc = other_value.type__gtpc();
} else {
  single_value->field_type__gtpc.clean_up();
}
if (other_value.lengthf().is_bound()) {
  single_value->field_lengthf = other_value.lengthf();
} else {
  single_value->field_lengthf.clean_up();
}
if (other_value.actionfield().is_bound()) {
  single_value->field_actionfield = other_value.actionfield();
} else {
  single_value->field_actionfield.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void MS__InfoChangeReportingAction_template::copy_template(const MS__InfoChangeReportingAction_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.type__gtpc().get_selection()) {
single_value->field_type__gtpc = other_value.type__gtpc();
} else {
single_value->field_type__gtpc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthf().get_selection()) {
single_value->field_lengthf = other_value.lengthf();
} else {
single_value->field_lengthf.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.actionfield().get_selection()) {
single_value->field_actionfield = other_value.actionfield();
} else {
single_value->field_actionfield.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new MS__InfoChangeReportingAction_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new MS__InfoChangeReportingAction_template(*other_value.implication_.precondition);
implication_.implied_template = new MS__InfoChangeReportingAction_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.MS_InfoChangeReportingAction.");
break;
}
set_selection(other_value);
}

MS__InfoChangeReportingAction_template::MS__InfoChangeReportingAction_template()
{
}

MS__InfoChangeReportingAction_template::MS__InfoChangeReportingAction_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

MS__InfoChangeReportingAction_template::MS__InfoChangeReportingAction_template(const MS__InfoChangeReportingAction& other_value)
{
copy_value(other_value);
}

MS__InfoChangeReportingAction_template::MS__InfoChangeReportingAction_template(const OPTIONAL<MS__InfoChangeReportingAction>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MS__InfoChangeReportingAction&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.MS_InfoChangeReportingAction from an unbound optional field.");
}
}

MS__InfoChangeReportingAction_template::MS__InfoChangeReportingAction_template(MS__InfoChangeReportingAction_template* p_precondition, MS__InfoChangeReportingAction_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

MS__InfoChangeReportingAction_template::MS__InfoChangeReportingAction_template(Dynamic_Match_Interface<MS__InfoChangeReportingAction>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<MS__InfoChangeReportingAction>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

MS__InfoChangeReportingAction_template::MS__InfoChangeReportingAction_template(const MS__InfoChangeReportingAction_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

MS__InfoChangeReportingAction_template::~MS__InfoChangeReportingAction_template()
{
clean_up();
}

MS__InfoChangeReportingAction_template& MS__InfoChangeReportingAction_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

MS__InfoChangeReportingAction_template& MS__InfoChangeReportingAction_template::operator=(const MS__InfoChangeReportingAction& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

MS__InfoChangeReportingAction_template& MS__InfoChangeReportingAction_template::operator=(const OPTIONAL<MS__InfoChangeReportingAction>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MS__InfoChangeReportingAction&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.MS_InfoChangeReportingAction.");
}
return *this;
}

MS__InfoChangeReportingAction_template& MS__InfoChangeReportingAction_template::operator=(const MS__InfoChangeReportingAction_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean MS__InfoChangeReportingAction_template::match(const MS__InfoChangeReportingAction& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.type__gtpc().is_bound()) return FALSE;
if(!single_value->field_type__gtpc.match(other_value.type__gtpc(), legacy))return FALSE;
if(!other_value.lengthf().is_bound()) return FALSE;
if(!single_value->field_lengthf.match(other_value.lengthf(), legacy))return FALSE;
if(!other_value.actionfield().is_bound()) return FALSE;
if(!single_value->field_actionfield.match(other_value.actionfield(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.MS_InfoChangeReportingAction.");
}
return FALSE;
}

boolean MS__InfoChangeReportingAction_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_type__gtpc.is_bound()
 || single_value->field_lengthf.is_bound()
 || single_value->field_actionfield.is_bound();
}

boolean MS__InfoChangeReportingAction_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_type__gtpc.is_value()
 && single_value->field_lengthf.is_value()
 && single_value->field_actionfield.is_value();
}

void MS__InfoChangeReportingAction_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

MS__InfoChangeReportingAction MS__InfoChangeReportingAction_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.MS_InfoChangeReportingAction.");
MS__InfoChangeReportingAction ret_val;
if (single_value->field_type__gtpc.is_bound()) {
ret_val.type__gtpc() = single_value->field_type__gtpc.valueof();
}
if (single_value->field_lengthf.is_bound()) {
ret_val.lengthf() = single_value->field_lengthf.valueof();
}
if (single_value->field_actionfield.is_bound()) {
ret_val.actionfield() = single_value->field_actionfield.valueof();
}
return ret_val;
}

void MS__InfoChangeReportingAction_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.MS_InfoChangeReportingAction.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new MS__InfoChangeReportingAction_template[list_length];
}

MS__InfoChangeReportingAction_template& MS__InfoChangeReportingAction_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.MS_InfoChangeReportingAction.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.MS_InfoChangeReportingAction.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& MS__InfoChangeReportingAction_template::type__gtpc()
{
set_specific();
return single_value->field_type__gtpc;
}

const OCTETSTRING_template& MS__InfoChangeReportingAction_template::type__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field type_gtpc of a non-specific template of type @GTPC_Types.MS_InfoChangeReportingAction.");
return single_value->field_type__gtpc;
}

INTEGER_template& MS__InfoChangeReportingAction_template::lengthf()
{
set_specific();
return single_value->field_lengthf;
}

const INTEGER_template& MS__InfoChangeReportingAction_template::lengthf() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthf of a non-specific template of type @GTPC_Types.MS_InfoChangeReportingAction.");
return single_value->field_lengthf;
}

OCTETSTRING_template& MS__InfoChangeReportingAction_template::actionfield()
{
set_specific();
return single_value->field_actionfield;
}

const OCTETSTRING_template& MS__InfoChangeReportingAction_template::actionfield() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field actionfield of a non-specific template of type @GTPC_Types.MS_InfoChangeReportingAction.");
return single_value->field_actionfield;
}

int MS__InfoChangeReportingAction_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MS_InfoChangeReportingAction which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.MS_InfoChangeReportingAction containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MS_InfoChangeReportingAction containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MS_InfoChangeReportingAction containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MS_InfoChangeReportingAction containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MS_InfoChangeReportingAction containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MS_InfoChangeReportingAction containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MS_InfoChangeReportingAction containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MS_InfoChangeReportingAction containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.MS_InfoChangeReportingAction.");
  }
  return 0;
}

void MS__InfoChangeReportingAction_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log();
TTCN_Logger::log_event_str(", actionfield := ");
single_value->field_actionfield.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void MS__InfoChangeReportingAction_template::log_match(const MS__InfoChangeReportingAction& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_type__gtpc.match(match_value.type__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".type_gtpc");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthf.match(match_value.lengthf(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthf");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_actionfield.match(match_value.actionfield(), legacy)){
TTCN_Logger::log_logmatch_info(".actionfield");
single_value->field_actionfield.log_match(match_value.actionfield(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::log_event_str(", actionfield := ");
single_value->field_actionfield.log_match(match_value.actionfield(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void MS__InfoChangeReportingAction_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (actionfield().is_bound()) actionfield().set_implicit_omit();
}

void MS__InfoChangeReportingAction_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_type__gtpc.encode_text(text_buf);
single_value->field_lengthf.encode_text(text_buf);
single_value->field_actionfield.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.MS_InfoChangeReportingAction.");
}
}

void MS__InfoChangeReportingAction_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_type__gtpc.decode_text(text_buf);
single_value->field_lengthf.decode_text(text_buf);
single_value->field_actionfield.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new MS__InfoChangeReportingAction_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.MS_InfoChangeReportingAction.");
}
}

void MS__InfoChangeReportingAction_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    MS__InfoChangeReportingAction_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @GTPC_Types.MS_InfoChangeReportingAction has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) actionfield().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "actionfield")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          actionfield().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.MS_InfoChangeReportingAction: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    MS__InfoChangeReportingAction_template* precondition = new MS__InfoChangeReportingAction_template;
    precondition->set_param(*param.get_elem(0));
    MS__InfoChangeReportingAction_template* implied_template = new MS__InfoChangeReportingAction_template;
    implied_template->set_param(*param.get_elem(1));
    *this = MS__InfoChangeReportingAction_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.MS_InfoChangeReportingAction");
  }
  is_ifpresent = param.get_ifpresent();
}

void MS__InfoChangeReportingAction_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_type__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MS_InfoChangeReportingAction");
single_value->field_lengthf.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MS_InfoChangeReportingAction");
single_value->field_actionfield.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MS_InfoChangeReportingAction");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.MS_InfoChangeReportingAction");
}

boolean MS__InfoChangeReportingAction_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean MS__InfoChangeReportingAction_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

DirectTunnelFlags::DirectTunnelFlags()
{
}

DirectTunnelFlags::DirectTunnelFlags(const OCTETSTRING& par_type__gtpc,
    const INTEGER& par_lengthf,
    const BITSTRING& par_dTI,
    const BITSTRING& par_gCSI,
    const BITSTRING& par_eI,
    const BITSTRING& par_spare)
  :   field_type__gtpc(par_type__gtpc),
  field_lengthf(par_lengthf),
  field_dTI(par_dTI),
  field_gCSI(par_gCSI),
  field_eI(par_eI),
  field_spare(par_spare)
{
}

DirectTunnelFlags::DirectTunnelFlags(const DirectTunnelFlags& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.DirectTunnelFlags.");
if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
else field_type__gtpc.clean_up();
if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
else field_lengthf.clean_up();
if (other_value.dTI().is_bound()) field_dTI = other_value.dTI();
else field_dTI.clean_up();
if (other_value.gCSI().is_bound()) field_gCSI = other_value.gCSI();
else field_gCSI.clean_up();
if (other_value.eI().is_bound()) field_eI = other_value.eI();
else field_eI.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void DirectTunnelFlags::clean_up()
{
field_type__gtpc.clean_up();
field_lengthf.clean_up();
field_dTI.clean_up();
field_gCSI.clean_up();
field_eI.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* DirectTunnelFlags::get_descriptor() const { return &DirectTunnelFlags_descr_; }
DirectTunnelFlags& DirectTunnelFlags::operator=(const DirectTunnelFlags& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.DirectTunnelFlags.");
  if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
  else field_type__gtpc.clean_up();
  if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
  else field_lengthf.clean_up();
  if (other_value.dTI().is_bound()) field_dTI = other_value.dTI();
  else field_dTI.clean_up();
  if (other_value.gCSI().is_bound()) field_gCSI = other_value.gCSI();
  else field_gCSI.clean_up();
  if (other_value.eI().is_bound()) field_eI = other_value.eI();
  else field_eI.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean DirectTunnelFlags::operator==(const DirectTunnelFlags& other_value) const
{
return field_type__gtpc==other_value.field_type__gtpc
  && field_lengthf==other_value.field_lengthf
  && field_dTI==other_value.field_dTI
  && field_gCSI==other_value.field_gCSI
  && field_eI==other_value.field_eI
  && field_spare==other_value.field_spare;
}

boolean DirectTunnelFlags::is_bound() const
{
return (field_type__gtpc.is_bound())
  || (field_lengthf.is_bound())
  || (field_dTI.is_bound())
  || (field_gCSI.is_bound())
  || (field_eI.is_bound())
  || (field_spare.is_bound());
}
boolean DirectTunnelFlags::is_value() const
{
return field_type__gtpc.is_value()
  && field_lengthf.is_value()
  && field_dTI.is_value()
  && field_gCSI.is_value()
  && field_eI.is_value()
  && field_spare.is_value();
}
void DirectTunnelFlags::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ type_gtpc := ");
field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
field_lengthf.log();
TTCN_Logger::log_event_str(", dTI := ");
field_dTI.log();
TTCN_Logger::log_event_str(", gCSI := ");
field_gCSI.log();
TTCN_Logger::log_event_str(", eI := ");
field_eI.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void DirectTunnelFlags::set_implicit_omit()
{
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (dTI().is_bound()) dTI().set_implicit_omit();
if (gCSI().is_bound()) gCSI().set_implicit_omit();
if (eI().is_bound()) eI().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void DirectTunnelFlags::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @GTPC_Types.DirectTunnelFlags has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) dTI().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) gCSI().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) eI().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dTI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dTI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gCSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gCSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.DirectTunnelFlags: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.DirectTunnelFlags");
  }
}

void DirectTunnelFlags::encode_text(Text_Buf& text_buf) const
{
field_type__gtpc.encode_text(text_buf);
field_lengthf.encode_text(text_buf);
field_dTI.encode_text(text_buf);
field_gCSI.encode_text(text_buf);
field_eI.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void DirectTunnelFlags::decode_text(Text_Buf& text_buf)
{
field_type__gtpc.decode_text(text_buf);
field_lengthf.decode_text(text_buf);
field_dTI.decode_text(text_buf);
field_gCSI.decode_text(text_buf);
field_eI.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void DirectTunnelFlags::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DirectTunnelFlags::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DirectTunnelFlags::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_type__gtpc.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, DirectTunnelFlags_lengthf_descr_.raw->forceomit);
  decoded_field_length = field_lengthf.RAW_decode(DirectTunnelFlags_lengthf_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthf.convert_to_Integer(DirectTunnelFlags_lengthf_descr_);
  field_lengthf = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_dTI.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_gCSI.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_eI.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::BIT5_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT5_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_type__gtpc !=  os_46) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int DirectTunnelFlags::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, DirectTunnelFlags_lengthf_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::BIT5_descr_.raw);
  encoded_length += field_type__gtpc.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &DirectTunnelFlags_lengthf_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  encoded_length += field_dTI.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_gCSI.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_eI.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT5_descr_, *myleaf.body.node.nodes[5]);
  if (field_type__gtpc !=  os_46) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_46.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct DirectTunnelFlags_template::single_value_struct {
OCTETSTRING_template field_type__gtpc;
INTEGER_template field_lengthf;
BITSTRING_template field_dTI;
BITSTRING_template field_gCSI;
BITSTRING_template field_eI;
BITSTRING_template field_spare;
};

void DirectTunnelFlags_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_type__gtpc = ANY_VALUE;
single_value->field_lengthf = ANY_VALUE;
single_value->field_dTI = ANY_VALUE;
single_value->field_gCSI = ANY_VALUE;
single_value->field_eI = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void DirectTunnelFlags_template::copy_value(const DirectTunnelFlags& other_value)
{
single_value = new single_value_struct;
if (other_value.type__gtpc().is_bound()) {
  single_value->field_type__gtpc = other_value.type__gtpc();
} else {
  single_value->field_type__gtpc.clean_up();
}
if (other_value.lengthf().is_bound()) {
  single_value->field_lengthf = other_value.lengthf();
} else {
  single_value->field_lengthf.clean_up();
}
if (other_value.dTI().is_bound()) {
  single_value->field_dTI = other_value.dTI();
} else {
  single_value->field_dTI.clean_up();
}
if (other_value.gCSI().is_bound()) {
  single_value->field_gCSI = other_value.gCSI();
} else {
  single_value->field_gCSI.clean_up();
}
if (other_value.eI().is_bound()) {
  single_value->field_eI = other_value.eI();
} else {
  single_value->field_eI.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void DirectTunnelFlags_template::copy_template(const DirectTunnelFlags_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.type__gtpc().get_selection()) {
single_value->field_type__gtpc = other_value.type__gtpc();
} else {
single_value->field_type__gtpc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthf().get_selection()) {
single_value->field_lengthf = other_value.lengthf();
} else {
single_value->field_lengthf.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dTI().get_selection()) {
single_value->field_dTI = other_value.dTI();
} else {
single_value->field_dTI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.gCSI().get_selection()) {
single_value->field_gCSI = other_value.gCSI();
} else {
single_value->field_gCSI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.eI().get_selection()) {
single_value->field_eI = other_value.eI();
} else {
single_value->field_eI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DirectTunnelFlags_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DirectTunnelFlags_template(*other_value.implication_.precondition);
implication_.implied_template = new DirectTunnelFlags_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.DirectTunnelFlags.");
break;
}
set_selection(other_value);
}

DirectTunnelFlags_template::DirectTunnelFlags_template()
{
}

DirectTunnelFlags_template::DirectTunnelFlags_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DirectTunnelFlags_template::DirectTunnelFlags_template(const DirectTunnelFlags& other_value)
{
copy_value(other_value);
}

DirectTunnelFlags_template::DirectTunnelFlags_template(const OPTIONAL<DirectTunnelFlags>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const DirectTunnelFlags&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.DirectTunnelFlags from an unbound optional field.");
}
}

DirectTunnelFlags_template::DirectTunnelFlags_template(DirectTunnelFlags_template* p_precondition, DirectTunnelFlags_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DirectTunnelFlags_template::DirectTunnelFlags_template(Dynamic_Match_Interface<DirectTunnelFlags>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DirectTunnelFlags>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DirectTunnelFlags_template::DirectTunnelFlags_template(const DirectTunnelFlags_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

DirectTunnelFlags_template::~DirectTunnelFlags_template()
{
clean_up();
}

DirectTunnelFlags_template& DirectTunnelFlags_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DirectTunnelFlags_template& DirectTunnelFlags_template::operator=(const DirectTunnelFlags& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

DirectTunnelFlags_template& DirectTunnelFlags_template::operator=(const OPTIONAL<DirectTunnelFlags>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const DirectTunnelFlags&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.DirectTunnelFlags.");
}
return *this;
}

DirectTunnelFlags_template& DirectTunnelFlags_template::operator=(const DirectTunnelFlags_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DirectTunnelFlags_template::match(const DirectTunnelFlags& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.type__gtpc().is_bound()) return FALSE;
if(!single_value->field_type__gtpc.match(other_value.type__gtpc(), legacy))return FALSE;
if(!other_value.lengthf().is_bound()) return FALSE;
if(!single_value->field_lengthf.match(other_value.lengthf(), legacy))return FALSE;
if(!other_value.dTI().is_bound()) return FALSE;
if(!single_value->field_dTI.match(other_value.dTI(), legacy))return FALSE;
if(!other_value.gCSI().is_bound()) return FALSE;
if(!single_value->field_gCSI.match(other_value.gCSI(), legacy))return FALSE;
if(!other_value.eI().is_bound()) return FALSE;
if(!single_value->field_eI.match(other_value.eI(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.DirectTunnelFlags.");
}
return FALSE;
}

boolean DirectTunnelFlags_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_type__gtpc.is_bound()
 || single_value->field_lengthf.is_bound()
 || single_value->field_dTI.is_bound()
 || single_value->field_gCSI.is_bound()
 || single_value->field_eI.is_bound()
 || single_value->field_spare.is_bound();
}

boolean DirectTunnelFlags_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_type__gtpc.is_value()
 && single_value->field_lengthf.is_value()
 && single_value->field_dTI.is_value()
 && single_value->field_gCSI.is_value()
 && single_value->field_eI.is_value()
 && single_value->field_spare.is_value();
}

void DirectTunnelFlags_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DirectTunnelFlags DirectTunnelFlags_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.DirectTunnelFlags.");
DirectTunnelFlags ret_val;
if (single_value->field_type__gtpc.is_bound()) {
ret_val.type__gtpc() = single_value->field_type__gtpc.valueof();
}
if (single_value->field_lengthf.is_bound()) {
ret_val.lengthf() = single_value->field_lengthf.valueof();
}
if (single_value->field_dTI.is_bound()) {
ret_val.dTI() = single_value->field_dTI.valueof();
}
if (single_value->field_gCSI.is_bound()) {
ret_val.gCSI() = single_value->field_gCSI.valueof();
}
if (single_value->field_eI.is_bound()) {
ret_val.eI() = single_value->field_eI.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void DirectTunnelFlags_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.DirectTunnelFlags.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DirectTunnelFlags_template[list_length];
}

DirectTunnelFlags_template& DirectTunnelFlags_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.DirectTunnelFlags.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.DirectTunnelFlags.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& DirectTunnelFlags_template::type__gtpc()
{
set_specific();
return single_value->field_type__gtpc;
}

const OCTETSTRING_template& DirectTunnelFlags_template::type__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field type_gtpc of a non-specific template of type @GTPC_Types.DirectTunnelFlags.");
return single_value->field_type__gtpc;
}

INTEGER_template& DirectTunnelFlags_template::lengthf()
{
set_specific();
return single_value->field_lengthf;
}

const INTEGER_template& DirectTunnelFlags_template::lengthf() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthf of a non-specific template of type @GTPC_Types.DirectTunnelFlags.");
return single_value->field_lengthf;
}

BITSTRING_template& DirectTunnelFlags_template::dTI()
{
set_specific();
return single_value->field_dTI;
}

const BITSTRING_template& DirectTunnelFlags_template::dTI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dTI of a non-specific template of type @GTPC_Types.DirectTunnelFlags.");
return single_value->field_dTI;
}

BITSTRING_template& DirectTunnelFlags_template::gCSI()
{
set_specific();
return single_value->field_gCSI;
}

const BITSTRING_template& DirectTunnelFlags_template::gCSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field gCSI of a non-specific template of type @GTPC_Types.DirectTunnelFlags.");
return single_value->field_gCSI;
}

BITSTRING_template& DirectTunnelFlags_template::eI()
{
set_specific();
return single_value->field_eI;
}

const BITSTRING_template& DirectTunnelFlags_template::eI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field eI of a non-specific template of type @GTPC_Types.DirectTunnelFlags.");
return single_value->field_eI;
}

BITSTRING_template& DirectTunnelFlags_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& DirectTunnelFlags_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @GTPC_Types.DirectTunnelFlags.");
return single_value->field_spare;
}

int DirectTunnelFlags_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.DirectTunnelFlags which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 6;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.DirectTunnelFlags containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.DirectTunnelFlags containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.DirectTunnelFlags containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.DirectTunnelFlags containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.DirectTunnelFlags containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.DirectTunnelFlags containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.DirectTunnelFlags containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.DirectTunnelFlags containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.DirectTunnelFlags.");
  }
  return 0;
}

void DirectTunnelFlags_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log();
TTCN_Logger::log_event_str(", dTI := ");
single_value->field_dTI.log();
TTCN_Logger::log_event_str(", gCSI := ");
single_value->field_gCSI.log();
TTCN_Logger::log_event_str(", eI := ");
single_value->field_eI.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DirectTunnelFlags_template::log_match(const DirectTunnelFlags& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_type__gtpc.match(match_value.type__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".type_gtpc");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthf.match(match_value.lengthf(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthf");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_dTI.match(match_value.dTI(), legacy)){
TTCN_Logger::log_logmatch_info(".dTI");
single_value->field_dTI.log_match(match_value.dTI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_gCSI.match(match_value.gCSI(), legacy)){
TTCN_Logger::log_logmatch_info(".gCSI");
single_value->field_gCSI.log_match(match_value.gCSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_eI.match(match_value.eI(), legacy)){
TTCN_Logger::log_logmatch_info(".eI");
single_value->field_eI.log_match(match_value.eI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::log_event_str(", dTI := ");
single_value->field_dTI.log_match(match_value.dTI(), legacy);
TTCN_Logger::log_event_str(", gCSI := ");
single_value->field_gCSI.log_match(match_value.gCSI(), legacy);
TTCN_Logger::log_event_str(", eI := ");
single_value->field_eI.log_match(match_value.eI(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void DirectTunnelFlags_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (dTI().is_bound()) dTI().set_implicit_omit();
if (gCSI().is_bound()) gCSI().set_implicit_omit();
if (eI().is_bound()) eI().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void DirectTunnelFlags_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_type__gtpc.encode_text(text_buf);
single_value->field_lengthf.encode_text(text_buf);
single_value->field_dTI.encode_text(text_buf);
single_value->field_gCSI.encode_text(text_buf);
single_value->field_eI.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.DirectTunnelFlags.");
}
}

void DirectTunnelFlags_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_type__gtpc.decode_text(text_buf);
single_value->field_lengthf.decode_text(text_buf);
single_value->field_dTI.decode_text(text_buf);
single_value->field_gCSI.decode_text(text_buf);
single_value->field_eI.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DirectTunnelFlags_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.DirectTunnelFlags.");
}
}

void DirectTunnelFlags_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DirectTunnelFlags_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @GTPC_Types.DirectTunnelFlags has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) dTI().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) gCSI().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) eI().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dTI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dTI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gCSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gCSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.DirectTunnelFlags: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    DirectTunnelFlags_template* precondition = new DirectTunnelFlags_template;
    precondition->set_param(*param.get_elem(0));
    DirectTunnelFlags_template* implied_template = new DirectTunnelFlags_template;
    implied_template->set_param(*param.get_elem(1));
    *this = DirectTunnelFlags_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.DirectTunnelFlags");
  }
  is_ifpresent = param.get_ifpresent();
}

void DirectTunnelFlags_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_type__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.DirectTunnelFlags");
single_value->field_lengthf.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.DirectTunnelFlags");
single_value->field_dTI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.DirectTunnelFlags");
single_value->field_gCSI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.DirectTunnelFlags");
single_value->field_eI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.DirectTunnelFlags");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.DirectTunnelFlags");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.DirectTunnelFlags");
}

boolean DirectTunnelFlags_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DirectTunnelFlags_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

CorrelationID::CorrelationID()
{
}

CorrelationID::CorrelationID(const OCTETSTRING& par_type__gtpc,
    const INTEGER& par_lengthf,
    const OCTETSTRING& par_correlationIDValue)
  :   field_type__gtpc(par_type__gtpc),
  field_lengthf(par_lengthf),
  field_correlationIDValue(par_correlationIDValue)
{
}

CorrelationID::CorrelationID(const CorrelationID& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.CorrelationID.");
if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
else field_type__gtpc.clean_up();
if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
else field_lengthf.clean_up();
if (other_value.correlationIDValue().is_bound()) field_correlationIDValue = other_value.correlationIDValue();
else field_correlationIDValue.clean_up();
}

void CorrelationID::clean_up()
{
field_type__gtpc.clean_up();
field_lengthf.clean_up();
field_correlationIDValue.clean_up();
}

const TTCN_Typedescriptor_t* CorrelationID::get_descriptor() const { return &CorrelationID_descr_; }
CorrelationID& CorrelationID::operator=(const CorrelationID& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.CorrelationID.");
  if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
  else field_type__gtpc.clean_up();
  if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
  else field_lengthf.clean_up();
  if (other_value.correlationIDValue().is_bound()) field_correlationIDValue = other_value.correlationIDValue();
  else field_correlationIDValue.clean_up();
}
return *this;
}

boolean CorrelationID::operator==(const CorrelationID& other_value) const
{
return field_type__gtpc==other_value.field_type__gtpc
  && field_lengthf==other_value.field_lengthf
  && field_correlationIDValue==other_value.field_correlationIDValue;
}

boolean CorrelationID::is_bound() const
{
return (field_type__gtpc.is_bound())
  || (field_lengthf.is_bound())
  || (field_correlationIDValue.is_bound());
}
boolean CorrelationID::is_value() const
{
return field_type__gtpc.is_value()
  && field_lengthf.is_value()
  && field_correlationIDValue.is_value();
}
void CorrelationID::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ type_gtpc := ");
field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
field_lengthf.log();
TTCN_Logger::log_event_str(", correlationIDValue := ");
field_correlationIDValue.log();
TTCN_Logger::log_event_str(" }");
}

void CorrelationID::set_implicit_omit()
{
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (correlationIDValue().is_bound()) correlationIDValue().set_implicit_omit();
}

void CorrelationID::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @GTPC_Types.CorrelationID has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) correlationIDValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "correlationIDValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          correlationIDValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.CorrelationID: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.CorrelationID");
  }
}

void CorrelationID::encode_text(Text_Buf& text_buf) const
{
field_type__gtpc.encode_text(text_buf);
field_lengthf.encode_text(text_buf);
field_correlationIDValue.encode_text(text_buf);
}

void CorrelationID::decode_text(Text_Buf& text_buf)
{
field_type__gtpc.decode_text(text_buf);
field_lengthf.decode_text(text_buf);
field_correlationIDValue.decode_text(text_buf);
}

void CorrelationID::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CorrelationID::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int CorrelationID::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_type__gtpc.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, CorrelationID_lengthf_descr_.raw->forceomit);
  decoded_field_length = field_lengthf.RAW_decode(CorrelationID_lengthf_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthf.convert_to_Integer(CorrelationID_lengthf_descr_);
  field_lengthf = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_correlationIDValue.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_type__gtpc !=  os_33) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int CorrelationID::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, CorrelationID_lengthf_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  encoded_length += field_type__gtpc.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &CorrelationID_lengthf_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_correlationIDValue.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  if (field_type__gtpc !=  os_33) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_33.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct CorrelationID_template::single_value_struct {
OCTETSTRING_template field_type__gtpc;
INTEGER_template field_lengthf;
OCTETSTRING_template field_correlationIDValue;
};

void CorrelationID_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_type__gtpc = ANY_VALUE;
single_value->field_lengthf = ANY_VALUE;
single_value->field_correlationIDValue = ANY_VALUE;
}
}
}

void CorrelationID_template::copy_value(const CorrelationID& other_value)
{
single_value = new single_value_struct;
if (other_value.type__gtpc().is_bound()) {
  single_value->field_type__gtpc = other_value.type__gtpc();
} else {
  single_value->field_type__gtpc.clean_up();
}
if (other_value.lengthf().is_bound()) {
  single_value->field_lengthf = other_value.lengthf();
} else {
  single_value->field_lengthf.clean_up();
}
if (other_value.correlationIDValue().is_bound()) {
  single_value->field_correlationIDValue = other_value.correlationIDValue();
} else {
  single_value->field_correlationIDValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void CorrelationID_template::copy_template(const CorrelationID_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.type__gtpc().get_selection()) {
single_value->field_type__gtpc = other_value.type__gtpc();
} else {
single_value->field_type__gtpc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthf().get_selection()) {
single_value->field_lengthf = other_value.lengthf();
} else {
single_value->field_lengthf.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.correlationIDValue().get_selection()) {
single_value->field_correlationIDValue = other_value.correlationIDValue();
} else {
single_value->field_correlationIDValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CorrelationID_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CorrelationID_template(*other_value.implication_.precondition);
implication_.implied_template = new CorrelationID_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.CorrelationID.");
break;
}
set_selection(other_value);
}

CorrelationID_template::CorrelationID_template()
{
}

CorrelationID_template::CorrelationID_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CorrelationID_template::CorrelationID_template(const CorrelationID& other_value)
{
copy_value(other_value);
}

CorrelationID_template::CorrelationID_template(const OPTIONAL<CorrelationID>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CorrelationID&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.CorrelationID from an unbound optional field.");
}
}

CorrelationID_template::CorrelationID_template(CorrelationID_template* p_precondition, CorrelationID_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CorrelationID_template::CorrelationID_template(Dynamic_Match_Interface<CorrelationID>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CorrelationID>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CorrelationID_template::CorrelationID_template(const CorrelationID_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

CorrelationID_template::~CorrelationID_template()
{
clean_up();
}

CorrelationID_template& CorrelationID_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CorrelationID_template& CorrelationID_template::operator=(const CorrelationID& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

CorrelationID_template& CorrelationID_template::operator=(const OPTIONAL<CorrelationID>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CorrelationID&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.CorrelationID.");
}
return *this;
}

CorrelationID_template& CorrelationID_template::operator=(const CorrelationID_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CorrelationID_template::match(const CorrelationID& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.type__gtpc().is_bound()) return FALSE;
if(!single_value->field_type__gtpc.match(other_value.type__gtpc(), legacy))return FALSE;
if(!other_value.lengthf().is_bound()) return FALSE;
if(!single_value->field_lengthf.match(other_value.lengthf(), legacy))return FALSE;
if(!other_value.correlationIDValue().is_bound()) return FALSE;
if(!single_value->field_correlationIDValue.match(other_value.correlationIDValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.CorrelationID.");
}
return FALSE;
}

boolean CorrelationID_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_type__gtpc.is_bound()
 || single_value->field_lengthf.is_bound()
 || single_value->field_correlationIDValue.is_bound();
}

boolean CorrelationID_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_type__gtpc.is_value()
 && single_value->field_lengthf.is_value()
 && single_value->field_correlationIDValue.is_value();
}

void CorrelationID_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CorrelationID CorrelationID_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.CorrelationID.");
CorrelationID ret_val;
if (single_value->field_type__gtpc.is_bound()) {
ret_val.type__gtpc() = single_value->field_type__gtpc.valueof();
}
if (single_value->field_lengthf.is_bound()) {
ret_val.lengthf() = single_value->field_lengthf.valueof();
}
if (single_value->field_correlationIDValue.is_bound()) {
ret_val.correlationIDValue() = single_value->field_correlationIDValue.valueof();
}
return ret_val;
}

void CorrelationID_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.CorrelationID.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CorrelationID_template[list_length];
}

CorrelationID_template& CorrelationID_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.CorrelationID.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.CorrelationID.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& CorrelationID_template::type__gtpc()
{
set_specific();
return single_value->field_type__gtpc;
}

const OCTETSTRING_template& CorrelationID_template::type__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field type_gtpc of a non-specific template of type @GTPC_Types.CorrelationID.");
return single_value->field_type__gtpc;
}

INTEGER_template& CorrelationID_template::lengthf()
{
set_specific();
return single_value->field_lengthf;
}

const INTEGER_template& CorrelationID_template::lengthf() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthf of a non-specific template of type @GTPC_Types.CorrelationID.");
return single_value->field_lengthf;
}

OCTETSTRING_template& CorrelationID_template::correlationIDValue()
{
set_specific();
return single_value->field_correlationIDValue;
}

const OCTETSTRING_template& CorrelationID_template::correlationIDValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field correlationIDValue of a non-specific template of type @GTPC_Types.CorrelationID.");
return single_value->field_correlationIDValue;
}

int CorrelationID_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CorrelationID which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.CorrelationID containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CorrelationID containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CorrelationID containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CorrelationID containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CorrelationID containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CorrelationID containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CorrelationID containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CorrelationID containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.CorrelationID.");
  }
  return 0;
}

void CorrelationID_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log();
TTCN_Logger::log_event_str(", correlationIDValue := ");
single_value->field_correlationIDValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CorrelationID_template::log_match(const CorrelationID& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_type__gtpc.match(match_value.type__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".type_gtpc");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthf.match(match_value.lengthf(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthf");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_correlationIDValue.match(match_value.correlationIDValue(), legacy)){
TTCN_Logger::log_logmatch_info(".correlationIDValue");
single_value->field_correlationIDValue.log_match(match_value.correlationIDValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::log_event_str(", correlationIDValue := ");
single_value->field_correlationIDValue.log_match(match_value.correlationIDValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void CorrelationID_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (correlationIDValue().is_bound()) correlationIDValue().set_implicit_omit();
}

void CorrelationID_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_type__gtpc.encode_text(text_buf);
single_value->field_lengthf.encode_text(text_buf);
single_value->field_correlationIDValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.CorrelationID.");
}
}

void CorrelationID_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_type__gtpc.decode_text(text_buf);
single_value->field_lengthf.decode_text(text_buf);
single_value->field_correlationIDValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CorrelationID_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.CorrelationID.");
}
}

void CorrelationID_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CorrelationID_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @GTPC_Types.CorrelationID has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) correlationIDValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "correlationIDValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          correlationIDValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.CorrelationID: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    CorrelationID_template* precondition = new CorrelationID_template;
    precondition->set_param(*param.get_elem(0));
    CorrelationID_template* implied_template = new CorrelationID_template;
    implied_template->set_param(*param.get_elem(1));
    *this = CorrelationID_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.CorrelationID");
  }
  is_ifpresent = param.get_ifpresent();
}

void CorrelationID_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_type__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CorrelationID");
single_value->field_lengthf.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CorrelationID");
single_value->field_correlationIDValue.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CorrelationID");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.CorrelationID");
}

boolean CorrelationID_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CorrelationID_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BearerControlMode::BearerControlMode()
{
}

BearerControlMode::BearerControlMode(const OCTETSTRING& par_type__gtpc,
    const INTEGER& par_lengthf,
    const OCTETSTRING& par_bearerControlModeValue)
  :   field_type__gtpc(par_type__gtpc),
  field_lengthf(par_lengthf),
  field_bearerControlModeValue(par_bearerControlModeValue)
{
}

BearerControlMode::BearerControlMode(const BearerControlMode& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.BearerControlMode.");
if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
else field_type__gtpc.clean_up();
if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
else field_lengthf.clean_up();
if (other_value.bearerControlModeValue().is_bound()) field_bearerControlModeValue = other_value.bearerControlModeValue();
else field_bearerControlModeValue.clean_up();
}

void BearerControlMode::clean_up()
{
field_type__gtpc.clean_up();
field_lengthf.clean_up();
field_bearerControlModeValue.clean_up();
}

const TTCN_Typedescriptor_t* BearerControlMode::get_descriptor() const { return &BearerControlMode_descr_; }
BearerControlMode& BearerControlMode::operator=(const BearerControlMode& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.BearerControlMode.");
  if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
  else field_type__gtpc.clean_up();
  if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
  else field_lengthf.clean_up();
  if (other_value.bearerControlModeValue().is_bound()) field_bearerControlModeValue = other_value.bearerControlModeValue();
  else field_bearerControlModeValue.clean_up();
}
return *this;
}

boolean BearerControlMode::operator==(const BearerControlMode& other_value) const
{
return field_type__gtpc==other_value.field_type__gtpc
  && field_lengthf==other_value.field_lengthf
  && field_bearerControlModeValue==other_value.field_bearerControlModeValue;
}

boolean BearerControlMode::is_bound() const
{
return (field_type__gtpc.is_bound())
  || (field_lengthf.is_bound())
  || (field_bearerControlModeValue.is_bound());
}
boolean BearerControlMode::is_value() const
{
return field_type__gtpc.is_value()
  && field_lengthf.is_value()
  && field_bearerControlModeValue.is_value();
}
void BearerControlMode::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ type_gtpc := ");
field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
field_lengthf.log();
TTCN_Logger::log_event_str(", bearerControlModeValue := ");
field_bearerControlModeValue.log();
TTCN_Logger::log_event_str(" }");
}

void BearerControlMode::set_implicit_omit()
{
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (bearerControlModeValue().is_bound()) bearerControlModeValue().set_implicit_omit();
}

void BearerControlMode::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @GTPC_Types.BearerControlMode has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) bearerControlModeValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerControlModeValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerControlModeValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.BearerControlMode: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.BearerControlMode");
  }
}

void BearerControlMode::encode_text(Text_Buf& text_buf) const
{
field_type__gtpc.encode_text(text_buf);
field_lengthf.encode_text(text_buf);
field_bearerControlModeValue.encode_text(text_buf);
}

void BearerControlMode::decode_text(Text_Buf& text_buf)
{
field_type__gtpc.decode_text(text_buf);
field_lengthf.decode_text(text_buf);
field_bearerControlModeValue.decode_text(text_buf);
}

void BearerControlMode::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BearerControlMode::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BearerControlMode::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_type__gtpc.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BearerControlMode_lengthf_descr_.raw->forceomit);
  decoded_field_length = field_lengthf.RAW_decode(BearerControlMode_lengthf_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthf.convert_to_Integer(BearerControlMode_lengthf_descr_);
  field_lengthf = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_bearerControlModeValue.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_type__gtpc !=  os_43) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BearerControlMode::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BearerControlMode_lengthf_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  encoded_length += field_type__gtpc.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BearerControlMode_lengthf_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_bearerControlModeValue.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  if (field_type__gtpc !=  os_43) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_43.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BearerControlMode_template::single_value_struct {
OCTETSTRING_template field_type__gtpc;
INTEGER_template field_lengthf;
OCTETSTRING_template field_bearerControlModeValue;
};

void BearerControlMode_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_type__gtpc = ANY_VALUE;
single_value->field_lengthf = ANY_VALUE;
single_value->field_bearerControlModeValue = ANY_VALUE;
}
}
}

void BearerControlMode_template::copy_value(const BearerControlMode& other_value)
{
single_value = new single_value_struct;
if (other_value.type__gtpc().is_bound()) {
  single_value->field_type__gtpc = other_value.type__gtpc();
} else {
  single_value->field_type__gtpc.clean_up();
}
if (other_value.lengthf().is_bound()) {
  single_value->field_lengthf = other_value.lengthf();
} else {
  single_value->field_lengthf.clean_up();
}
if (other_value.bearerControlModeValue().is_bound()) {
  single_value->field_bearerControlModeValue = other_value.bearerControlModeValue();
} else {
  single_value->field_bearerControlModeValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BearerControlMode_template::copy_template(const BearerControlMode_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.type__gtpc().get_selection()) {
single_value->field_type__gtpc = other_value.type__gtpc();
} else {
single_value->field_type__gtpc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthf().get_selection()) {
single_value->field_lengthf = other_value.lengthf();
} else {
single_value->field_lengthf.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bearerControlModeValue().get_selection()) {
single_value->field_bearerControlModeValue = other_value.bearerControlModeValue();
} else {
single_value->field_bearerControlModeValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BearerControlMode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BearerControlMode_template(*other_value.implication_.precondition);
implication_.implied_template = new BearerControlMode_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.BearerControlMode.");
break;
}
set_selection(other_value);
}

BearerControlMode_template::BearerControlMode_template()
{
}

BearerControlMode_template::BearerControlMode_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BearerControlMode_template::BearerControlMode_template(const BearerControlMode& other_value)
{
copy_value(other_value);
}

BearerControlMode_template::BearerControlMode_template(const OPTIONAL<BearerControlMode>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BearerControlMode&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.BearerControlMode from an unbound optional field.");
}
}

BearerControlMode_template::BearerControlMode_template(BearerControlMode_template* p_precondition, BearerControlMode_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BearerControlMode_template::BearerControlMode_template(Dynamic_Match_Interface<BearerControlMode>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BearerControlMode>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BearerControlMode_template::BearerControlMode_template(const BearerControlMode_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BearerControlMode_template::~BearerControlMode_template()
{
clean_up();
}

BearerControlMode_template& BearerControlMode_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BearerControlMode_template& BearerControlMode_template::operator=(const BearerControlMode& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BearerControlMode_template& BearerControlMode_template::operator=(const OPTIONAL<BearerControlMode>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BearerControlMode&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.BearerControlMode.");
}
return *this;
}

BearerControlMode_template& BearerControlMode_template::operator=(const BearerControlMode_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BearerControlMode_template::match(const BearerControlMode& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.type__gtpc().is_bound()) return FALSE;
if(!single_value->field_type__gtpc.match(other_value.type__gtpc(), legacy))return FALSE;
if(!other_value.lengthf().is_bound()) return FALSE;
if(!single_value->field_lengthf.match(other_value.lengthf(), legacy))return FALSE;
if(!other_value.bearerControlModeValue().is_bound()) return FALSE;
if(!single_value->field_bearerControlModeValue.match(other_value.bearerControlModeValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.BearerControlMode.");
}
return FALSE;
}

boolean BearerControlMode_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_type__gtpc.is_bound()
 || single_value->field_lengthf.is_bound()
 || single_value->field_bearerControlModeValue.is_bound();
}

boolean BearerControlMode_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_type__gtpc.is_value()
 && single_value->field_lengthf.is_value()
 && single_value->field_bearerControlModeValue.is_value();
}

void BearerControlMode_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BearerControlMode BearerControlMode_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.BearerControlMode.");
BearerControlMode ret_val;
if (single_value->field_type__gtpc.is_bound()) {
ret_val.type__gtpc() = single_value->field_type__gtpc.valueof();
}
if (single_value->field_lengthf.is_bound()) {
ret_val.lengthf() = single_value->field_lengthf.valueof();
}
if (single_value->field_bearerControlModeValue.is_bound()) {
ret_val.bearerControlModeValue() = single_value->field_bearerControlModeValue.valueof();
}
return ret_val;
}

void BearerControlMode_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.BearerControlMode.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BearerControlMode_template[list_length];
}

BearerControlMode_template& BearerControlMode_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.BearerControlMode.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.BearerControlMode.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BearerControlMode_template::type__gtpc()
{
set_specific();
return single_value->field_type__gtpc;
}

const OCTETSTRING_template& BearerControlMode_template::type__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field type_gtpc of a non-specific template of type @GTPC_Types.BearerControlMode.");
return single_value->field_type__gtpc;
}

INTEGER_template& BearerControlMode_template::lengthf()
{
set_specific();
return single_value->field_lengthf;
}

const INTEGER_template& BearerControlMode_template::lengthf() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthf of a non-specific template of type @GTPC_Types.BearerControlMode.");
return single_value->field_lengthf;
}

OCTETSTRING_template& BearerControlMode_template::bearerControlModeValue()
{
set_specific();
return single_value->field_bearerControlModeValue;
}

const OCTETSTRING_template& BearerControlMode_template::bearerControlModeValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bearerControlModeValue of a non-specific template of type @GTPC_Types.BearerControlMode.");
return single_value->field_bearerControlModeValue;
}

int BearerControlMode_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.BearerControlMode which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.BearerControlMode containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.BearerControlMode containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.BearerControlMode containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.BearerControlMode containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.BearerControlMode containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.BearerControlMode containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.BearerControlMode containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.BearerControlMode containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.BearerControlMode.");
  }
  return 0;
}

void BearerControlMode_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log();
TTCN_Logger::log_event_str(", bearerControlModeValue := ");
single_value->field_bearerControlModeValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BearerControlMode_template::log_match(const BearerControlMode& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_type__gtpc.match(match_value.type__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".type_gtpc");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthf.match(match_value.lengthf(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthf");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_bearerControlModeValue.match(match_value.bearerControlModeValue(), legacy)){
TTCN_Logger::log_logmatch_info(".bearerControlModeValue");
single_value->field_bearerControlModeValue.log_match(match_value.bearerControlModeValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::log_event_str(", bearerControlModeValue := ");
single_value->field_bearerControlModeValue.log_match(match_value.bearerControlModeValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BearerControlMode_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (bearerControlModeValue().is_bound()) bearerControlModeValue().set_implicit_omit();
}

void BearerControlMode_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_type__gtpc.encode_text(text_buf);
single_value->field_lengthf.encode_text(text_buf);
single_value->field_bearerControlModeValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.BearerControlMode.");
}
}

void BearerControlMode_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_type__gtpc.decode_text(text_buf);
single_value->field_lengthf.decode_text(text_buf);
single_value->field_bearerControlModeValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BearerControlMode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.BearerControlMode.");
}
}

void BearerControlMode_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BearerControlMode_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @GTPC_Types.BearerControlMode has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) bearerControlModeValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerControlModeValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerControlModeValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.BearerControlMode: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BearerControlMode_template* precondition = new BearerControlMode_template;
    precondition->set_param(*param.get_elem(0));
    BearerControlMode_template* implied_template = new BearerControlMode_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BearerControlMode_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.BearerControlMode");
  }
  is_ifpresent = param.get_ifpresent();
}

void BearerControlMode_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_type__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.BearerControlMode");
single_value->field_lengthf.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.BearerControlMode");
single_value->field_bearerControlModeValue.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.BearerControlMode");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.BearerControlMode");
}

boolean BearerControlMode_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BearerControlMode_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

MBMS__FlowID::MBMS__FlowID()
{
}

MBMS__FlowID::MBMS__FlowID(const OCTETSTRING& par_type__gtpc,
    const INTEGER& par_lengthf,
    const OCTETSTRING& par_mBMS__FlowIDValue)
  :   field_type__gtpc(par_type__gtpc),
  field_lengthf(par_lengthf),
  field_mBMS__FlowIDValue(par_mBMS__FlowIDValue)
{
}

MBMS__FlowID::MBMS__FlowID(const MBMS__FlowID& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.MBMS_FlowID.");
if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
else field_type__gtpc.clean_up();
if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
else field_lengthf.clean_up();
if (other_value.mBMS__FlowIDValue().is_bound()) field_mBMS__FlowIDValue = other_value.mBMS__FlowIDValue();
else field_mBMS__FlowIDValue.clean_up();
}

void MBMS__FlowID::clean_up()
{
field_type__gtpc.clean_up();
field_lengthf.clean_up();
field_mBMS__FlowIDValue.clean_up();
}

const TTCN_Typedescriptor_t* MBMS__FlowID::get_descriptor() const { return &MBMS__FlowID_descr_; }
MBMS__FlowID& MBMS__FlowID::operator=(const MBMS__FlowID& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.MBMS_FlowID.");
  if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
  else field_type__gtpc.clean_up();
  if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
  else field_lengthf.clean_up();
  if (other_value.mBMS__FlowIDValue().is_bound()) field_mBMS__FlowIDValue = other_value.mBMS__FlowIDValue();
  else field_mBMS__FlowIDValue.clean_up();
}
return *this;
}

boolean MBMS__FlowID::operator==(const MBMS__FlowID& other_value) const
{
return field_type__gtpc==other_value.field_type__gtpc
  && field_lengthf==other_value.field_lengthf
  && field_mBMS__FlowIDValue==other_value.field_mBMS__FlowIDValue;
}

boolean MBMS__FlowID::is_bound() const
{
return (field_type__gtpc.is_bound())
  || (field_lengthf.is_bound())
  || (field_mBMS__FlowIDValue.is_bound());
}
boolean MBMS__FlowID::is_value() const
{
return field_type__gtpc.is_value()
  && field_lengthf.is_value()
  && field_mBMS__FlowIDValue.is_value();
}
void MBMS__FlowID::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ type_gtpc := ");
field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
field_lengthf.log();
TTCN_Logger::log_event_str(", mBMS_FlowIDValue := ");
field_mBMS__FlowIDValue.log();
TTCN_Logger::log_event_str(" }");
}

void MBMS__FlowID::set_implicit_omit()
{
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (mBMS__FlowIDValue().is_bound()) mBMS__FlowIDValue().set_implicit_omit();
}

void MBMS__FlowID::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @GTPC_Types.MBMS_FlowID has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) mBMS__FlowIDValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mBMS_FlowIDValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mBMS__FlowIDValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.MBMS_FlowID: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.MBMS_FlowID");
  }
}

void MBMS__FlowID::encode_text(Text_Buf& text_buf) const
{
field_type__gtpc.encode_text(text_buf);
field_lengthf.encode_text(text_buf);
field_mBMS__FlowIDValue.encode_text(text_buf);
}

void MBMS__FlowID::decode_text(Text_Buf& text_buf)
{
field_type__gtpc.decode_text(text_buf);
field_lengthf.decode_text(text_buf);
field_mBMS__FlowIDValue.decode_text(text_buf);
}

void MBMS__FlowID::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void MBMS__FlowID::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int MBMS__FlowID::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_type__gtpc.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, MBMS__FlowID_lengthf_descr_.raw->forceomit);
  decoded_field_length = field_lengthf.RAW_decode(MBMS__FlowID_lengthf_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthf.convert_to_Integer(MBMS__FlowID_lengthf_descr_);
  field_lengthf = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_mBMS__FlowIDValue.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_type__gtpc !=  os_128) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int MBMS__FlowID::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, MBMS__FlowID_lengthf_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, OCTETSTRING_descr_.raw);
  encoded_length += field_type__gtpc.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &MBMS__FlowID_lengthf_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_mBMS__FlowIDValue.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[2]);
  if (field_type__gtpc !=  os_128) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_128.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct MBMS__FlowID_template::single_value_struct {
OCTETSTRING_template field_type__gtpc;
INTEGER_template field_lengthf;
OCTETSTRING_template field_mBMS__FlowIDValue;
};

void MBMS__FlowID_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_type__gtpc = ANY_VALUE;
single_value->field_lengthf = ANY_VALUE;
single_value->field_mBMS__FlowIDValue = ANY_VALUE;
}
}
}

void MBMS__FlowID_template::copy_value(const MBMS__FlowID& other_value)
{
single_value = new single_value_struct;
if (other_value.type__gtpc().is_bound()) {
  single_value->field_type__gtpc = other_value.type__gtpc();
} else {
  single_value->field_type__gtpc.clean_up();
}
if (other_value.lengthf().is_bound()) {
  single_value->field_lengthf = other_value.lengthf();
} else {
  single_value->field_lengthf.clean_up();
}
if (other_value.mBMS__FlowIDValue().is_bound()) {
  single_value->field_mBMS__FlowIDValue = other_value.mBMS__FlowIDValue();
} else {
  single_value->field_mBMS__FlowIDValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void MBMS__FlowID_template::copy_template(const MBMS__FlowID_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.type__gtpc().get_selection()) {
single_value->field_type__gtpc = other_value.type__gtpc();
} else {
single_value->field_type__gtpc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthf().get_selection()) {
single_value->field_lengthf = other_value.lengthf();
} else {
single_value->field_lengthf.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mBMS__FlowIDValue().get_selection()) {
single_value->field_mBMS__FlowIDValue = other_value.mBMS__FlowIDValue();
} else {
single_value->field_mBMS__FlowIDValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new MBMS__FlowID_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new MBMS__FlowID_template(*other_value.implication_.precondition);
implication_.implied_template = new MBMS__FlowID_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.MBMS_FlowID.");
break;
}
set_selection(other_value);
}

MBMS__FlowID_template::MBMS__FlowID_template()
{
}

MBMS__FlowID_template::MBMS__FlowID_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

MBMS__FlowID_template::MBMS__FlowID_template(const MBMS__FlowID& other_value)
{
copy_value(other_value);
}

MBMS__FlowID_template::MBMS__FlowID_template(const OPTIONAL<MBMS__FlowID>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MBMS__FlowID&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.MBMS_FlowID from an unbound optional field.");
}
}

MBMS__FlowID_template::MBMS__FlowID_template(MBMS__FlowID_template* p_precondition, MBMS__FlowID_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

MBMS__FlowID_template::MBMS__FlowID_template(Dynamic_Match_Interface<MBMS__FlowID>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<MBMS__FlowID>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

MBMS__FlowID_template::MBMS__FlowID_template(const MBMS__FlowID_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

MBMS__FlowID_template::~MBMS__FlowID_template()
{
clean_up();
}

MBMS__FlowID_template& MBMS__FlowID_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

MBMS__FlowID_template& MBMS__FlowID_template::operator=(const MBMS__FlowID& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

MBMS__FlowID_template& MBMS__FlowID_template::operator=(const OPTIONAL<MBMS__FlowID>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MBMS__FlowID&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.MBMS_FlowID.");
}
return *this;
}

MBMS__FlowID_template& MBMS__FlowID_template::operator=(const MBMS__FlowID_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean MBMS__FlowID_template::match(const MBMS__FlowID& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.type__gtpc().is_bound()) return FALSE;
if(!single_value->field_type__gtpc.match(other_value.type__gtpc(), legacy))return FALSE;
if(!other_value.lengthf().is_bound()) return FALSE;
if(!single_value->field_lengthf.match(other_value.lengthf(), legacy))return FALSE;
if(!other_value.mBMS__FlowIDValue().is_bound()) return FALSE;
if(!single_value->field_mBMS__FlowIDValue.match(other_value.mBMS__FlowIDValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.MBMS_FlowID.");
}
return FALSE;
}

boolean MBMS__FlowID_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_type__gtpc.is_bound()
 || single_value->field_lengthf.is_bound()
 || single_value->field_mBMS__FlowIDValue.is_bound();
}

boolean MBMS__FlowID_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_type__gtpc.is_value()
 && single_value->field_lengthf.is_value()
 && single_value->field_mBMS__FlowIDValue.is_value();
}

void MBMS__FlowID_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

MBMS__FlowID MBMS__FlowID_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.MBMS_FlowID.");
MBMS__FlowID ret_val;
if (single_value->field_type__gtpc.is_bound()) {
ret_val.type__gtpc() = single_value->field_type__gtpc.valueof();
}
if (single_value->field_lengthf.is_bound()) {
ret_val.lengthf() = single_value->field_lengthf.valueof();
}
if (single_value->field_mBMS__FlowIDValue.is_bound()) {
ret_val.mBMS__FlowIDValue() = single_value->field_mBMS__FlowIDValue.valueof();
}
return ret_val;
}

void MBMS__FlowID_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.MBMS_FlowID.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new MBMS__FlowID_template[list_length];
}

MBMS__FlowID_template& MBMS__FlowID_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.MBMS_FlowID.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.MBMS_FlowID.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& MBMS__FlowID_template::type__gtpc()
{
set_specific();
return single_value->field_type__gtpc;
}

const OCTETSTRING_template& MBMS__FlowID_template::type__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field type_gtpc of a non-specific template of type @GTPC_Types.MBMS_FlowID.");
return single_value->field_type__gtpc;
}

INTEGER_template& MBMS__FlowID_template::lengthf()
{
set_specific();
return single_value->field_lengthf;
}

const INTEGER_template& MBMS__FlowID_template::lengthf() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthf of a non-specific template of type @GTPC_Types.MBMS_FlowID.");
return single_value->field_lengthf;
}

OCTETSTRING_template& MBMS__FlowID_template::mBMS__FlowIDValue()
{
set_specific();
return single_value->field_mBMS__FlowIDValue;
}

const OCTETSTRING_template& MBMS__FlowID_template::mBMS__FlowIDValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mBMS_FlowIDValue of a non-specific template of type @GTPC_Types.MBMS_FlowID.");
return single_value->field_mBMS__FlowIDValue;
}

int MBMS__FlowID_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_FlowID which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.MBMS_FlowID containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_FlowID containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_FlowID containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_FlowID containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_FlowID containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_FlowID containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_FlowID containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_FlowID containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.MBMS_FlowID.");
  }
  return 0;
}

void MBMS__FlowID_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log();
TTCN_Logger::log_event_str(", mBMS_FlowIDValue := ");
single_value->field_mBMS__FlowIDValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void MBMS__FlowID_template::log_match(const MBMS__FlowID& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_type__gtpc.match(match_value.type__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".type_gtpc");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthf.match(match_value.lengthf(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthf");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mBMS__FlowIDValue.match(match_value.mBMS__FlowIDValue(), legacy)){
TTCN_Logger::log_logmatch_info(".mBMS_FlowIDValue");
single_value->field_mBMS__FlowIDValue.log_match(match_value.mBMS__FlowIDValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::log_event_str(", mBMS_FlowIDValue := ");
single_value->field_mBMS__FlowIDValue.log_match(match_value.mBMS__FlowIDValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void MBMS__FlowID_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (mBMS__FlowIDValue().is_bound()) mBMS__FlowIDValue().set_implicit_omit();
}

void MBMS__FlowID_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_type__gtpc.encode_text(text_buf);
single_value->field_lengthf.encode_text(text_buf);
single_value->field_mBMS__FlowIDValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.MBMS_FlowID.");
}
}

void MBMS__FlowID_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_type__gtpc.decode_text(text_buf);
single_value->field_lengthf.decode_text(text_buf);
single_value->field_mBMS__FlowIDValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new MBMS__FlowID_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.MBMS_FlowID.");
}
}

void MBMS__FlowID_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    MBMS__FlowID_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @GTPC_Types.MBMS_FlowID has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) mBMS__FlowIDValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mBMS_FlowIDValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mBMS__FlowIDValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.MBMS_FlowID: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    MBMS__FlowID_template* precondition = new MBMS__FlowID_template;
    precondition->set_param(*param.get_elem(0));
    MBMS__FlowID_template* implied_template = new MBMS__FlowID_template;
    implied_template->set_param(*param.get_elem(1));
    *this = MBMS__FlowID_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.MBMS_FlowID");
  }
  is_ifpresent = param.get_ifpresent();
}

void MBMS__FlowID_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_type__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MBMS_FlowID");
single_value->field_lengthf.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MBMS_FlowID");
single_value->field_mBMS__FlowIDValue.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MBMS_FlowID");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.MBMS_FlowID");
}

boolean MBMS__FlowID_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean MBMS__FlowID_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

GSNAddress::GSNAddress()
{
}

GSNAddress::GSNAddress(const INTEGER& par_lengthf,
    const BITSTRING& par_address__type,
    const iPv4__iPv6__Address& par_ipv__address)
  :   field_lengthf(par_lengthf),
  field_address__type(par_address__type),
  field_ipv__address(par_ipv__address)
{
}

GSNAddress::GSNAddress(const GSNAddress& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.GSNAddress.");
if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
else field_lengthf.clean_up();
if (other_value.address__type().is_bound()) field_address__type = other_value.address__type();
else field_address__type.clean_up();
if (other_value.ipv__address().is_bound()) field_ipv__address = other_value.ipv__address();
else field_ipv__address.clean_up();
}

void GSNAddress::clean_up()
{
field_lengthf.clean_up();
field_address__type.clean_up();
field_ipv__address.clean_up();
}

const TTCN_Typedescriptor_t* GSNAddress::get_descriptor() const { return &GSNAddress_descr_; }
GSNAddress& GSNAddress::operator=(const GSNAddress& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.GSNAddress.");
  if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
  else field_lengthf.clean_up();
  if (other_value.address__type().is_bound()) field_address__type = other_value.address__type();
  else field_address__type.clean_up();
  if (other_value.ipv__address().is_bound()) field_ipv__address = other_value.ipv__address();
  else field_ipv__address.clean_up();
}
return *this;
}

boolean GSNAddress::operator==(const GSNAddress& other_value) const
{
return field_lengthf==other_value.field_lengthf
  && field_address__type==other_value.field_address__type
  && field_ipv__address==other_value.field_ipv__address;
}

boolean GSNAddress::is_bound() const
{
return (field_lengthf.is_bound())
  || (field_address__type.is_bound())
  || (field_ipv__address.is_bound());
}
boolean GSNAddress::is_value() const
{
return field_lengthf.is_value()
  && field_address__type.is_value()
  && field_ipv__address.is_value();
}
void GSNAddress::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lengthf := ");
field_lengthf.log();
TTCN_Logger::log_event_str(", address_type := ");
field_address__type.log();
TTCN_Logger::log_event_str(", ipv_address := ");
field_ipv__address.log();
TTCN_Logger::log_event_str(" }");
}

void GSNAddress::set_implicit_omit()
{
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (address__type().is_bound()) address__type().set_implicit_omit();
if (ipv__address().is_bound()) ipv__address().set_implicit_omit();
}

void GSNAddress::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @GTPC_Types.GSNAddress has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) address__type().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ipv__address().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "address_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          address__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ipv_address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ipv__address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.GSNAddress: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.GSNAddress");
  }
}

void GSNAddress::encode_text(Text_Buf& text_buf) const
{
field_lengthf.encode_text(text_buf);
field_address__type.encode_text(text_buf);
field_ipv__address.encode_text(text_buf);
}

void GSNAddress::decode_text(Text_Buf& text_buf)
{
field_lengthf.decode_text(text_buf);
field_address__type.decode_text(text_buf);
field_ipv__address.decode_text(text_buf);
}

void GSNAddress::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void GSNAddress::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int GSNAddress::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, GSNAddress_lengthf_descr_.raw->forceomit);
  decoded_field_length = field_lengthf.RAW_decode(GSNAddress_lengthf_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_lengthf.convert_to_Integer(GSNAddress_lengthf_descr_);
  field_lengthf = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_address__type.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, iPv4__iPv6__Address_descr_.raw->forceomit);
  decoded_field_length = field_ipv__address.RAW_decode(iPv4__iPv6__Address_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int GSNAddress::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, GSNAddress_lengthf_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, iPv4__iPv6__Address_descr_.raw);
  encoded_length += 6;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &GSNAddress_lengthf_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 6;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_address__type.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_ipv__address.RAW_encode(iPv4__iPv6__Address_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct GSNAddress_template::single_value_struct {
INTEGER_template field_lengthf;
BITSTRING_template field_address__type;
iPv4__iPv6__Address_template field_ipv__address;
};

void GSNAddress_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lengthf = ANY_VALUE;
single_value->field_address__type = ANY_VALUE;
single_value->field_ipv__address = ANY_VALUE;
}
}
}

void GSNAddress_template::copy_value(const GSNAddress& other_value)
{
single_value = new single_value_struct;
if (other_value.lengthf().is_bound()) {
  single_value->field_lengthf = other_value.lengthf();
} else {
  single_value->field_lengthf.clean_up();
}
if (other_value.address__type().is_bound()) {
  single_value->field_address__type = other_value.address__type();
} else {
  single_value->field_address__type.clean_up();
}
if (other_value.ipv__address().is_bound()) {
  single_value->field_ipv__address = other_value.ipv__address();
} else {
  single_value->field_ipv__address.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void GSNAddress_template::copy_template(const GSNAddress_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lengthf().get_selection()) {
single_value->field_lengthf = other_value.lengthf();
} else {
single_value->field_lengthf.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.address__type().get_selection()) {
single_value->field_address__type = other_value.address__type();
} else {
single_value->field_address__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ipv__address().get_selection()) {
single_value->field_ipv__address = other_value.ipv__address();
} else {
single_value->field_ipv__address.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new GSNAddress_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new GSNAddress_template(*other_value.implication_.precondition);
implication_.implied_template = new GSNAddress_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.GSNAddress.");
break;
}
set_selection(other_value);
}

GSNAddress_template::GSNAddress_template()
{
}

GSNAddress_template::GSNAddress_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

GSNAddress_template::GSNAddress_template(const GSNAddress& other_value)
{
copy_value(other_value);
}

GSNAddress_template::GSNAddress_template(const OPTIONAL<GSNAddress>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GSNAddress&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.GSNAddress from an unbound optional field.");
}
}

GSNAddress_template::GSNAddress_template(GSNAddress_template* p_precondition, GSNAddress_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

GSNAddress_template::GSNAddress_template(Dynamic_Match_Interface<GSNAddress>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<GSNAddress>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

GSNAddress_template::GSNAddress_template(const GSNAddress_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

GSNAddress_template::~GSNAddress_template()
{
clean_up();
}

GSNAddress_template& GSNAddress_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

GSNAddress_template& GSNAddress_template::operator=(const GSNAddress& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

GSNAddress_template& GSNAddress_template::operator=(const OPTIONAL<GSNAddress>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GSNAddress&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.GSNAddress.");
}
return *this;
}

GSNAddress_template& GSNAddress_template::operator=(const GSNAddress_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean GSNAddress_template::match(const GSNAddress& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lengthf().is_bound()) return FALSE;
if(!single_value->field_lengthf.match(other_value.lengthf(), legacy))return FALSE;
if(!other_value.address__type().is_bound()) return FALSE;
if(!single_value->field_address__type.match(other_value.address__type(), legacy))return FALSE;
if(!other_value.ipv__address().is_bound()) return FALSE;
if(!single_value->field_ipv__address.match(other_value.ipv__address(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.GSNAddress.");
}
return FALSE;
}

boolean GSNAddress_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lengthf.is_bound()
 || single_value->field_address__type.is_bound()
 || single_value->field_ipv__address.is_bound();
}

boolean GSNAddress_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lengthf.is_value()
 && single_value->field_address__type.is_value()
 && single_value->field_ipv__address.is_value();
}

void GSNAddress_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

GSNAddress GSNAddress_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.GSNAddress.");
GSNAddress ret_val;
if (single_value->field_lengthf.is_bound()) {
ret_val.lengthf() = single_value->field_lengthf.valueof();
}
if (single_value->field_address__type.is_bound()) {
ret_val.address__type() = single_value->field_address__type.valueof();
}
if (single_value->field_ipv__address.is_bound()) {
ret_val.ipv__address() = single_value->field_ipv__address.valueof();
}
return ret_val;
}

void GSNAddress_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.GSNAddress.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new GSNAddress_template[list_length];
}

GSNAddress_template& GSNAddress_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.GSNAddress.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.GSNAddress.");
return value_list.list_value[list_index];
}

INTEGER_template& GSNAddress_template::lengthf()
{
set_specific();
return single_value->field_lengthf;
}

const INTEGER_template& GSNAddress_template::lengthf() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthf of a non-specific template of type @GTPC_Types.GSNAddress.");
return single_value->field_lengthf;
}

BITSTRING_template& GSNAddress_template::address__type()
{
set_specific();
return single_value->field_address__type;
}

const BITSTRING_template& GSNAddress_template::address__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field address_type of a non-specific template of type @GTPC_Types.GSNAddress.");
return single_value->field_address__type;
}

iPv4__iPv6__Address_template& GSNAddress_template::ipv__address()
{
set_specific();
return single_value->field_ipv__address;
}

const iPv4__iPv6__Address_template& GSNAddress_template::ipv__address() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ipv_address of a non-specific template of type @GTPC_Types.GSNAddress.");
return single_value->field_ipv__address;
}

int GSNAddress_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.GSNAddress which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.GSNAddress containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.GSNAddress containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.GSNAddress containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.GSNAddress containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.GSNAddress containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.GSNAddress containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.GSNAddress containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.GSNAddress containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.GSNAddress.");
  }
  return 0;
}

void GSNAddress_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lengthf := ");
single_value->field_lengthf.log();
TTCN_Logger::log_event_str(", address_type := ");
single_value->field_address__type.log();
TTCN_Logger::log_event_str(", ipv_address := ");
single_value->field_ipv__address.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void GSNAddress_template::log_match(const GSNAddress& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lengthf.match(match_value.lengthf(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthf");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_address__type.match(match_value.address__type(), legacy)){
TTCN_Logger::log_logmatch_info(".address_type");
single_value->field_address__type.log_match(match_value.address__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ipv__address.match(match_value.ipv__address(), legacy)){
TTCN_Logger::log_logmatch_info(".ipv_address");
single_value->field_ipv__address.log_match(match_value.ipv__address(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lengthf := ");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::log_event_str(", address_type := ");
single_value->field_address__type.log_match(match_value.address__type(), legacy);
TTCN_Logger::log_event_str(", ipv_address := ");
single_value->field_ipv__address.log_match(match_value.ipv__address(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void GSNAddress_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (address__type().is_bound()) address__type().set_implicit_omit();
if (ipv__address().is_bound()) ipv__address().set_implicit_omit();
}

void GSNAddress_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lengthf.encode_text(text_buf);
single_value->field_address__type.encode_text(text_buf);
single_value->field_ipv__address.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.GSNAddress.");
}
}

void GSNAddress_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lengthf.decode_text(text_buf);
single_value->field_address__type.decode_text(text_buf);
single_value->field_ipv__address.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new GSNAddress_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.GSNAddress.");
}
}

void GSNAddress_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    GSNAddress_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @GTPC_Types.GSNAddress has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) address__type().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ipv__address().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "address_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          address__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ipv_address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ipv__address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.GSNAddress: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    GSNAddress_template* precondition = new GSNAddress_template;
    precondition->set_param(*param.get_elem(0));
    GSNAddress_template* implied_template = new GSNAddress_template;
    implied_template->set_param(*param.get_elem(1));
    *this = GSNAddress_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.GSNAddress");
  }
  is_ifpresent = param.get_ifpresent();
}

void GSNAddress_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lengthf.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.GSNAddress");
single_value->field_address__type.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.GSNAddress");
single_value->field_ipv__address.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.GSNAddress");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.GSNAddress");
}

boolean GSNAddress_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean GSNAddress_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

MBMS__IPMulticastDistribution::MBMS__IPMulticastDistribution()
{
}

MBMS__IPMulticastDistribution::MBMS__IPMulticastDistribution(const OCTETSTRING& par_type__gtpc,
    const INTEGER& par_lengthf,
    const OCTETSTRING& par_commonTEID,
    const GSNAddress& par_iPmulticastDistributionAddress,
    const GSNAddress& par_iPmulticastSourceAddress,
    const OCTETSTRING& par_mBMS__HCIndicator)
  :   field_type__gtpc(par_type__gtpc),
  field_lengthf(par_lengthf),
  field_commonTEID(par_commonTEID),
  field_iPmulticastDistributionAddress(par_iPmulticastDistributionAddress),
  field_iPmulticastSourceAddress(par_iPmulticastSourceAddress),
  field_mBMS__HCIndicator(par_mBMS__HCIndicator)
{
}

MBMS__IPMulticastDistribution::MBMS__IPMulticastDistribution(const MBMS__IPMulticastDistribution& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.MBMS_IPMulticastDistribution.");
if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
else field_type__gtpc.clean_up();
if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
else field_lengthf.clean_up();
if (other_value.commonTEID().is_bound()) field_commonTEID = other_value.commonTEID();
else field_commonTEID.clean_up();
if (other_value.iPmulticastDistributionAddress().is_bound()) field_iPmulticastDistributionAddress = other_value.iPmulticastDistributionAddress();
else field_iPmulticastDistributionAddress.clean_up();
if (other_value.iPmulticastSourceAddress().is_bound()) field_iPmulticastSourceAddress = other_value.iPmulticastSourceAddress();
else field_iPmulticastSourceAddress.clean_up();
if (other_value.mBMS__HCIndicator().is_bound()) field_mBMS__HCIndicator = other_value.mBMS__HCIndicator();
else field_mBMS__HCIndicator.clean_up();
}

void MBMS__IPMulticastDistribution::clean_up()
{
field_type__gtpc.clean_up();
field_lengthf.clean_up();
field_commonTEID.clean_up();
field_iPmulticastDistributionAddress.clean_up();
field_iPmulticastSourceAddress.clean_up();
field_mBMS__HCIndicator.clean_up();
}

const TTCN_Typedescriptor_t* MBMS__IPMulticastDistribution::get_descriptor() const { return &MBMS__IPMulticastDistribution_descr_; }
MBMS__IPMulticastDistribution& MBMS__IPMulticastDistribution::operator=(const MBMS__IPMulticastDistribution& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.MBMS_IPMulticastDistribution.");
  if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
  else field_type__gtpc.clean_up();
  if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
  else field_lengthf.clean_up();
  if (other_value.commonTEID().is_bound()) field_commonTEID = other_value.commonTEID();
  else field_commonTEID.clean_up();
  if (other_value.iPmulticastDistributionAddress().is_bound()) field_iPmulticastDistributionAddress = other_value.iPmulticastDistributionAddress();
  else field_iPmulticastDistributionAddress.clean_up();
  if (other_value.iPmulticastSourceAddress().is_bound()) field_iPmulticastSourceAddress = other_value.iPmulticastSourceAddress();
  else field_iPmulticastSourceAddress.clean_up();
  if (other_value.mBMS__HCIndicator().is_bound()) field_mBMS__HCIndicator = other_value.mBMS__HCIndicator();
  else field_mBMS__HCIndicator.clean_up();
}
return *this;
}

boolean MBMS__IPMulticastDistribution::operator==(const MBMS__IPMulticastDistribution& other_value) const
{
return field_type__gtpc==other_value.field_type__gtpc
  && field_lengthf==other_value.field_lengthf
  && field_commonTEID==other_value.field_commonTEID
  && field_iPmulticastDistributionAddress==other_value.field_iPmulticastDistributionAddress
  && field_iPmulticastSourceAddress==other_value.field_iPmulticastSourceAddress
  && field_mBMS__HCIndicator==other_value.field_mBMS__HCIndicator;
}

boolean MBMS__IPMulticastDistribution::is_bound() const
{
return (field_type__gtpc.is_bound())
  || (field_lengthf.is_bound())
  || (field_commonTEID.is_bound())
  || (field_iPmulticastDistributionAddress.is_bound())
  || (field_iPmulticastSourceAddress.is_bound())
  || (field_mBMS__HCIndicator.is_bound());
}
boolean MBMS__IPMulticastDistribution::is_value() const
{
return field_type__gtpc.is_value()
  && field_lengthf.is_value()
  && field_commonTEID.is_value()
  && field_iPmulticastDistributionAddress.is_value()
  && field_iPmulticastSourceAddress.is_value()
  && field_mBMS__HCIndicator.is_value();
}
void MBMS__IPMulticastDistribution::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ type_gtpc := ");
field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
field_lengthf.log();
TTCN_Logger::log_event_str(", commonTEID := ");
field_commonTEID.log();
TTCN_Logger::log_event_str(", iPmulticastDistributionAddress := ");
field_iPmulticastDistributionAddress.log();
TTCN_Logger::log_event_str(", iPmulticastSourceAddress := ");
field_iPmulticastSourceAddress.log();
TTCN_Logger::log_event_str(", mBMS_HCIndicator := ");
field_mBMS__HCIndicator.log();
TTCN_Logger::log_event_str(" }");
}

void MBMS__IPMulticastDistribution::set_implicit_omit()
{
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (commonTEID().is_bound()) commonTEID().set_implicit_omit();
if (iPmulticastDistributionAddress().is_bound()) iPmulticastDistributionAddress().set_implicit_omit();
if (iPmulticastSourceAddress().is_bound()) iPmulticastSourceAddress().set_implicit_omit();
if (mBMS__HCIndicator().is_bound()) mBMS__HCIndicator().set_implicit_omit();
}

void MBMS__IPMulticastDistribution::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @GTPC_Types.MBMS_IPMulticastDistribution has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) commonTEID().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) iPmulticastDistributionAddress().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) iPmulticastSourceAddress().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) mBMS__HCIndicator().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "commonTEID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          commonTEID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iPmulticastDistributionAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iPmulticastDistributionAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iPmulticastSourceAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iPmulticastSourceAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mBMS_HCIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mBMS__HCIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.MBMS_IPMulticastDistribution: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.MBMS_IPMulticastDistribution");
  }
}

void MBMS__IPMulticastDistribution::encode_text(Text_Buf& text_buf) const
{
field_type__gtpc.encode_text(text_buf);
field_lengthf.encode_text(text_buf);
field_commonTEID.encode_text(text_buf);
field_iPmulticastDistributionAddress.encode_text(text_buf);
field_iPmulticastSourceAddress.encode_text(text_buf);
field_mBMS__HCIndicator.encode_text(text_buf);
}

void MBMS__IPMulticastDistribution::decode_text(Text_Buf& text_buf)
{
field_type__gtpc.decode_text(text_buf);
field_lengthf.decode_text(text_buf);
field_commonTEID.decode_text(text_buf);
field_iPmulticastDistributionAddress.decode_text(text_buf);
field_iPmulticastSourceAddress.decode_text(text_buf);
field_mBMS__HCIndicator.decode_text(text_buf);
}

void MBMS__IPMulticastDistribution::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void MBMS__IPMulticastDistribution::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int MBMS__IPMulticastDistribution::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_type__gtpc.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, MBMS__IPMulticastDistribution_lengthf_descr_.raw->forceomit);
  decoded_field_length = field_lengthf.RAW_decode(MBMS__IPMulticastDistribution_lengthf_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthf.convert_to_Integer(MBMS__IPMulticastDistribution_lengthf_descr_);
  field_lengthf = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT4_descr_.raw->forceomit);
  decoded_field_length = field_commonTEID.RAW_decode(General__Types::OCT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, GSNAddress_descr_.raw->forceomit);
  decoded_field_length = field_iPmulticastDistributionAddress.RAW_decode(GSNAddress_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, GSNAddress_descr_.raw->forceomit);
  decoded_field_length = field_iPmulticastSourceAddress.RAW_decode(GSNAddress_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_mBMS__HCIndicator.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_type__gtpc !=  os_129) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int MBMS__IPMulticastDistribution::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, MBMS__IPMulticastDistribution_lengthf_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT4_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, GSNAddress_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, GSNAddress_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::OCT1_descr_.raw);
  encoded_length += field_type__gtpc.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &MBMS__IPMulticastDistribution_lengthf_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  encoded_length += field_commonTEID.RAW_encode(General__Types::OCT4_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_iPmulticastDistributionAddress.RAW_encode(GSNAddress_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_iPmulticastSourceAddress.RAW_encode(GSNAddress_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_mBMS__HCIndicator.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[5]);
  if (field_type__gtpc !=  os_129) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_129.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct MBMS__IPMulticastDistribution_template::single_value_struct {
OCTETSTRING_template field_type__gtpc;
INTEGER_template field_lengthf;
OCTETSTRING_template field_commonTEID;
GSNAddress_template field_iPmulticastDistributionAddress;
GSNAddress_template field_iPmulticastSourceAddress;
OCTETSTRING_template field_mBMS__HCIndicator;
};

void MBMS__IPMulticastDistribution_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_type__gtpc = ANY_VALUE;
single_value->field_lengthf = ANY_VALUE;
single_value->field_commonTEID = ANY_VALUE;
single_value->field_iPmulticastDistributionAddress = ANY_VALUE;
single_value->field_iPmulticastSourceAddress = ANY_VALUE;
single_value->field_mBMS__HCIndicator = ANY_VALUE;
}
}
}

void MBMS__IPMulticastDistribution_template::copy_value(const MBMS__IPMulticastDistribution& other_value)
{
single_value = new single_value_struct;
if (other_value.type__gtpc().is_bound()) {
  single_value->field_type__gtpc = other_value.type__gtpc();
} else {
  single_value->field_type__gtpc.clean_up();
}
if (other_value.lengthf().is_bound()) {
  single_value->field_lengthf = other_value.lengthf();
} else {
  single_value->field_lengthf.clean_up();
}
if (other_value.commonTEID().is_bound()) {
  single_value->field_commonTEID = other_value.commonTEID();
} else {
  single_value->field_commonTEID.clean_up();
}
if (other_value.iPmulticastDistributionAddress().is_bound()) {
  single_value->field_iPmulticastDistributionAddress = other_value.iPmulticastDistributionAddress();
} else {
  single_value->field_iPmulticastDistributionAddress.clean_up();
}
if (other_value.iPmulticastSourceAddress().is_bound()) {
  single_value->field_iPmulticastSourceAddress = other_value.iPmulticastSourceAddress();
} else {
  single_value->field_iPmulticastSourceAddress.clean_up();
}
if (other_value.mBMS__HCIndicator().is_bound()) {
  single_value->field_mBMS__HCIndicator = other_value.mBMS__HCIndicator();
} else {
  single_value->field_mBMS__HCIndicator.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void MBMS__IPMulticastDistribution_template::copy_template(const MBMS__IPMulticastDistribution_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.type__gtpc().get_selection()) {
single_value->field_type__gtpc = other_value.type__gtpc();
} else {
single_value->field_type__gtpc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthf().get_selection()) {
single_value->field_lengthf = other_value.lengthf();
} else {
single_value->field_lengthf.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.commonTEID().get_selection()) {
single_value->field_commonTEID = other_value.commonTEID();
} else {
single_value->field_commonTEID.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.iPmulticastDistributionAddress().get_selection()) {
single_value->field_iPmulticastDistributionAddress = other_value.iPmulticastDistributionAddress();
} else {
single_value->field_iPmulticastDistributionAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.iPmulticastSourceAddress().get_selection()) {
single_value->field_iPmulticastSourceAddress = other_value.iPmulticastSourceAddress();
} else {
single_value->field_iPmulticastSourceAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mBMS__HCIndicator().get_selection()) {
single_value->field_mBMS__HCIndicator = other_value.mBMS__HCIndicator();
} else {
single_value->field_mBMS__HCIndicator.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new MBMS__IPMulticastDistribution_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new MBMS__IPMulticastDistribution_template(*other_value.implication_.precondition);
implication_.implied_template = new MBMS__IPMulticastDistribution_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
break;
}
set_selection(other_value);
}

MBMS__IPMulticastDistribution_template::MBMS__IPMulticastDistribution_template()
{
}

MBMS__IPMulticastDistribution_template::MBMS__IPMulticastDistribution_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

MBMS__IPMulticastDistribution_template::MBMS__IPMulticastDistribution_template(const MBMS__IPMulticastDistribution& other_value)
{
copy_value(other_value);
}

MBMS__IPMulticastDistribution_template::MBMS__IPMulticastDistribution_template(const OPTIONAL<MBMS__IPMulticastDistribution>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MBMS__IPMulticastDistribution&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.MBMS_IPMulticastDistribution from an unbound optional field.");
}
}

MBMS__IPMulticastDistribution_template::MBMS__IPMulticastDistribution_template(MBMS__IPMulticastDistribution_template* p_precondition, MBMS__IPMulticastDistribution_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

MBMS__IPMulticastDistribution_template::MBMS__IPMulticastDistribution_template(Dynamic_Match_Interface<MBMS__IPMulticastDistribution>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<MBMS__IPMulticastDistribution>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

MBMS__IPMulticastDistribution_template::MBMS__IPMulticastDistribution_template(const MBMS__IPMulticastDistribution_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

MBMS__IPMulticastDistribution_template::~MBMS__IPMulticastDistribution_template()
{
clean_up();
}

MBMS__IPMulticastDistribution_template& MBMS__IPMulticastDistribution_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

MBMS__IPMulticastDistribution_template& MBMS__IPMulticastDistribution_template::operator=(const MBMS__IPMulticastDistribution& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

MBMS__IPMulticastDistribution_template& MBMS__IPMulticastDistribution_template::operator=(const OPTIONAL<MBMS__IPMulticastDistribution>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MBMS__IPMulticastDistribution&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
}
return *this;
}

MBMS__IPMulticastDistribution_template& MBMS__IPMulticastDistribution_template::operator=(const MBMS__IPMulticastDistribution_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean MBMS__IPMulticastDistribution_template::match(const MBMS__IPMulticastDistribution& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.type__gtpc().is_bound()) return FALSE;
if(!single_value->field_type__gtpc.match(other_value.type__gtpc(), legacy))return FALSE;
if(!other_value.lengthf().is_bound()) return FALSE;
if(!single_value->field_lengthf.match(other_value.lengthf(), legacy))return FALSE;
if(!other_value.commonTEID().is_bound()) return FALSE;
if(!single_value->field_commonTEID.match(other_value.commonTEID(), legacy))return FALSE;
if(!other_value.iPmulticastDistributionAddress().is_bound()) return FALSE;
if(!single_value->field_iPmulticastDistributionAddress.match(other_value.iPmulticastDistributionAddress(), legacy))return FALSE;
if(!other_value.iPmulticastSourceAddress().is_bound()) return FALSE;
if(!single_value->field_iPmulticastSourceAddress.match(other_value.iPmulticastSourceAddress(), legacy))return FALSE;
if(!other_value.mBMS__HCIndicator().is_bound()) return FALSE;
if(!single_value->field_mBMS__HCIndicator.match(other_value.mBMS__HCIndicator(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
}
return FALSE;
}

boolean MBMS__IPMulticastDistribution_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_type__gtpc.is_bound()
 || single_value->field_lengthf.is_bound()
 || single_value->field_commonTEID.is_bound()
 || single_value->field_iPmulticastDistributionAddress.is_bound()
 || single_value->field_iPmulticastSourceAddress.is_bound()
 || single_value->field_mBMS__HCIndicator.is_bound();
}

boolean MBMS__IPMulticastDistribution_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_type__gtpc.is_value()
 && single_value->field_lengthf.is_value()
 && single_value->field_commonTEID.is_value()
 && single_value->field_iPmulticastDistributionAddress.is_value()
 && single_value->field_iPmulticastSourceAddress.is_value()
 && single_value->field_mBMS__HCIndicator.is_value();
}

void MBMS__IPMulticastDistribution_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

MBMS__IPMulticastDistribution MBMS__IPMulticastDistribution_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
MBMS__IPMulticastDistribution ret_val;
if (single_value->field_type__gtpc.is_bound()) {
ret_val.type__gtpc() = single_value->field_type__gtpc.valueof();
}
if (single_value->field_lengthf.is_bound()) {
ret_val.lengthf() = single_value->field_lengthf.valueof();
}
if (single_value->field_commonTEID.is_bound()) {
ret_val.commonTEID() = single_value->field_commonTEID.valueof();
}
if (single_value->field_iPmulticastDistributionAddress.is_bound()) {
ret_val.iPmulticastDistributionAddress() = single_value->field_iPmulticastDistributionAddress.valueof();
}
if (single_value->field_iPmulticastSourceAddress.is_bound()) {
ret_val.iPmulticastSourceAddress() = single_value->field_iPmulticastSourceAddress.valueof();
}
if (single_value->field_mBMS__HCIndicator.is_bound()) {
ret_val.mBMS__HCIndicator() = single_value->field_mBMS__HCIndicator.valueof();
}
return ret_val;
}

void MBMS__IPMulticastDistribution_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new MBMS__IPMulticastDistribution_template[list_length];
}

MBMS__IPMulticastDistribution_template& MBMS__IPMulticastDistribution_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& MBMS__IPMulticastDistribution_template::type__gtpc()
{
set_specific();
return single_value->field_type__gtpc;
}

const OCTETSTRING_template& MBMS__IPMulticastDistribution_template::type__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field type_gtpc of a non-specific template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
return single_value->field_type__gtpc;
}

INTEGER_template& MBMS__IPMulticastDistribution_template::lengthf()
{
set_specific();
return single_value->field_lengthf;
}

const INTEGER_template& MBMS__IPMulticastDistribution_template::lengthf() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthf of a non-specific template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
return single_value->field_lengthf;
}

OCTETSTRING_template& MBMS__IPMulticastDistribution_template::commonTEID()
{
set_specific();
return single_value->field_commonTEID;
}

const OCTETSTRING_template& MBMS__IPMulticastDistribution_template::commonTEID() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field commonTEID of a non-specific template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
return single_value->field_commonTEID;
}

GSNAddress_template& MBMS__IPMulticastDistribution_template::iPmulticastDistributionAddress()
{
set_specific();
return single_value->field_iPmulticastDistributionAddress;
}

const GSNAddress_template& MBMS__IPMulticastDistribution_template::iPmulticastDistributionAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iPmulticastDistributionAddress of a non-specific template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
return single_value->field_iPmulticastDistributionAddress;
}

GSNAddress_template& MBMS__IPMulticastDistribution_template::iPmulticastSourceAddress()
{
set_specific();
return single_value->field_iPmulticastSourceAddress;
}

const GSNAddress_template& MBMS__IPMulticastDistribution_template::iPmulticastSourceAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iPmulticastSourceAddress of a non-specific template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
return single_value->field_iPmulticastSourceAddress;
}

OCTETSTRING_template& MBMS__IPMulticastDistribution_template::mBMS__HCIndicator()
{
set_specific();
return single_value->field_mBMS__HCIndicator;
}

const OCTETSTRING_template& MBMS__IPMulticastDistribution_template::mBMS__HCIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mBMS_HCIndicator of a non-specific template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
return single_value->field_mBMS__HCIndicator;
}

int MBMS__IPMulticastDistribution_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_IPMulticastDistribution which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 6;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.MBMS_IPMulticastDistribution containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_IPMulticastDistribution containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_IPMulticastDistribution containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_IPMulticastDistribution containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_IPMulticastDistribution containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_IPMulticastDistribution containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_IPMulticastDistribution containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_IPMulticastDistribution containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
  }
  return 0;
}

void MBMS__IPMulticastDistribution_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log();
TTCN_Logger::log_event_str(", commonTEID := ");
single_value->field_commonTEID.log();
TTCN_Logger::log_event_str(", iPmulticastDistributionAddress := ");
single_value->field_iPmulticastDistributionAddress.log();
TTCN_Logger::log_event_str(", iPmulticastSourceAddress := ");
single_value->field_iPmulticastSourceAddress.log();
TTCN_Logger::log_event_str(", mBMS_HCIndicator := ");
single_value->field_mBMS__HCIndicator.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void MBMS__IPMulticastDistribution_template::log_match(const MBMS__IPMulticastDistribution& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_type__gtpc.match(match_value.type__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".type_gtpc");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthf.match(match_value.lengthf(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthf");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_commonTEID.match(match_value.commonTEID(), legacy)){
TTCN_Logger::log_logmatch_info(".commonTEID");
single_value->field_commonTEID.log_match(match_value.commonTEID(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_iPmulticastDistributionAddress.match(match_value.iPmulticastDistributionAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".iPmulticastDistributionAddress");
single_value->field_iPmulticastDistributionAddress.log_match(match_value.iPmulticastDistributionAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_iPmulticastSourceAddress.match(match_value.iPmulticastSourceAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".iPmulticastSourceAddress");
single_value->field_iPmulticastSourceAddress.log_match(match_value.iPmulticastSourceAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mBMS__HCIndicator.match(match_value.mBMS__HCIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".mBMS_HCIndicator");
single_value->field_mBMS__HCIndicator.log_match(match_value.mBMS__HCIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::log_event_str(", commonTEID := ");
single_value->field_commonTEID.log_match(match_value.commonTEID(), legacy);
TTCN_Logger::log_event_str(", iPmulticastDistributionAddress := ");
single_value->field_iPmulticastDistributionAddress.log_match(match_value.iPmulticastDistributionAddress(), legacy);
TTCN_Logger::log_event_str(", iPmulticastSourceAddress := ");
single_value->field_iPmulticastSourceAddress.log_match(match_value.iPmulticastSourceAddress(), legacy);
TTCN_Logger::log_event_str(", mBMS_HCIndicator := ");
single_value->field_mBMS__HCIndicator.log_match(match_value.mBMS__HCIndicator(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void MBMS__IPMulticastDistribution_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (commonTEID().is_bound()) commonTEID().set_implicit_omit();
if (iPmulticastDistributionAddress().is_bound()) iPmulticastDistributionAddress().set_implicit_omit();
if (iPmulticastSourceAddress().is_bound()) iPmulticastSourceAddress().set_implicit_omit();
if (mBMS__HCIndicator().is_bound()) mBMS__HCIndicator().set_implicit_omit();
}

void MBMS__IPMulticastDistribution_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_type__gtpc.encode_text(text_buf);
single_value->field_lengthf.encode_text(text_buf);
single_value->field_commonTEID.encode_text(text_buf);
single_value->field_iPmulticastDistributionAddress.encode_text(text_buf);
single_value->field_iPmulticastSourceAddress.encode_text(text_buf);
single_value->field_mBMS__HCIndicator.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
}
}

void MBMS__IPMulticastDistribution_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_type__gtpc.decode_text(text_buf);
single_value->field_lengthf.decode_text(text_buf);
single_value->field_commonTEID.decode_text(text_buf);
single_value->field_iPmulticastDistributionAddress.decode_text(text_buf);
single_value->field_iPmulticastSourceAddress.decode_text(text_buf);
single_value->field_mBMS__HCIndicator.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new MBMS__IPMulticastDistribution_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.MBMS_IPMulticastDistribution.");
}
}

void MBMS__IPMulticastDistribution_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    MBMS__IPMulticastDistribution_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @GTPC_Types.MBMS_IPMulticastDistribution has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) commonTEID().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) iPmulticastDistributionAddress().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) iPmulticastSourceAddress().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) mBMS__HCIndicator().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "commonTEID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          commonTEID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iPmulticastDistributionAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iPmulticastDistributionAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iPmulticastSourceAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iPmulticastSourceAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mBMS_HCIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mBMS__HCIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.MBMS_IPMulticastDistribution: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    MBMS__IPMulticastDistribution_template* precondition = new MBMS__IPMulticastDistribution_template;
    precondition->set_param(*param.get_elem(0));
    MBMS__IPMulticastDistribution_template* implied_template = new MBMS__IPMulticastDistribution_template;
    implied_template->set_param(*param.get_elem(1));
    *this = MBMS__IPMulticastDistribution_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.MBMS_IPMulticastDistribution");
  }
  is_ifpresent = param.get_ifpresent();
}

void MBMS__IPMulticastDistribution_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_type__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MBMS_IPMulticastDistribution");
single_value->field_lengthf.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MBMS_IPMulticastDistribution");
single_value->field_commonTEID.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MBMS_IPMulticastDistribution");
single_value->field_iPmulticastDistributionAddress.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MBMS_IPMulticastDistribution");
single_value->field_iPmulticastSourceAddress.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MBMS_IPMulticastDistribution");
single_value->field_mBMS__HCIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MBMS_IPMulticastDistribution");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.MBMS_IPMulticastDistribution");
}

boolean MBMS__IPMulticastDistribution_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean MBMS__IPMulticastDistribution_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

MBMS__DistributionAcknowledgement::MBMS__DistributionAcknowledgement()
{
}

MBMS__DistributionAcknowledgement::MBMS__DistributionAcknowledgement(const OCTETSTRING& par_type__gtpc,
    const INTEGER& par_lengthf,
    const BITSTRING& par_distributionIndication,
    const BITSTRING& par_spare)
  :   field_type__gtpc(par_type__gtpc),
  field_lengthf(par_lengthf),
  field_distributionIndication(par_distributionIndication),
  field_spare(par_spare)
{
}

MBMS__DistributionAcknowledgement::MBMS__DistributionAcknowledgement(const MBMS__DistributionAcknowledgement& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
else field_type__gtpc.clean_up();
if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
else field_lengthf.clean_up();
if (other_value.distributionIndication().is_bound()) field_distributionIndication = other_value.distributionIndication();
else field_distributionIndication.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void MBMS__DistributionAcknowledgement::clean_up()
{
field_type__gtpc.clean_up();
field_lengthf.clean_up();
field_distributionIndication.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* MBMS__DistributionAcknowledgement::get_descriptor() const { return &MBMS__DistributionAcknowledgement_descr_; }
MBMS__DistributionAcknowledgement& MBMS__DistributionAcknowledgement::operator=(const MBMS__DistributionAcknowledgement& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
  if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
  else field_type__gtpc.clean_up();
  if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
  else field_lengthf.clean_up();
  if (other_value.distributionIndication().is_bound()) field_distributionIndication = other_value.distributionIndication();
  else field_distributionIndication.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean MBMS__DistributionAcknowledgement::operator==(const MBMS__DistributionAcknowledgement& other_value) const
{
return field_type__gtpc==other_value.field_type__gtpc
  && field_lengthf==other_value.field_lengthf
  && field_distributionIndication==other_value.field_distributionIndication
  && field_spare==other_value.field_spare;
}

boolean MBMS__DistributionAcknowledgement::is_bound() const
{
return (field_type__gtpc.is_bound())
  || (field_lengthf.is_bound())
  || (field_distributionIndication.is_bound())
  || (field_spare.is_bound());
}
boolean MBMS__DistributionAcknowledgement::is_value() const
{
return field_type__gtpc.is_value()
  && field_lengthf.is_value()
  && field_distributionIndication.is_value()
  && field_spare.is_value();
}
void MBMS__DistributionAcknowledgement::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ type_gtpc := ");
field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
field_lengthf.log();
TTCN_Logger::log_event_str(", distributionIndication := ");
field_distributionIndication.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void MBMS__DistributionAcknowledgement::set_implicit_omit()
{
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (distributionIndication().is_bound()) distributionIndication().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void MBMS__DistributionAcknowledgement::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @GTPC_Types.MBMS_DistributionAcknowledgement has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) distributionIndication().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "distributionIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          distributionIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.MBMS_DistributionAcknowledgement: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.MBMS_DistributionAcknowledgement");
  }
}

void MBMS__DistributionAcknowledgement::encode_text(Text_Buf& text_buf) const
{
field_type__gtpc.encode_text(text_buf);
field_lengthf.encode_text(text_buf);
field_distributionIndication.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void MBMS__DistributionAcknowledgement::decode_text(Text_Buf& text_buf)
{
field_type__gtpc.decode_text(text_buf);
field_lengthf.decode_text(text_buf);
field_distributionIndication.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void MBMS__DistributionAcknowledgement::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void MBMS__DistributionAcknowledgement::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int MBMS__DistributionAcknowledgement::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_type__gtpc.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, MBMS__DistributionAcknowledgement_lengthf_descr_.raw->forceomit);
  decoded_field_length = field_lengthf.RAW_decode(MBMS__DistributionAcknowledgement_lengthf_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthf.convert_to_Integer(MBMS__DistributionAcknowledgement_lengthf_descr_);
  field_lengthf = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_distributionIndication.RAW_decode(General__Types::BIT2_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT6_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_type__gtpc !=  os_130) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int MBMS__DistributionAcknowledgement::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, MBMS__DistributionAcknowledgement_lengthf_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT6_descr_.raw);
  encoded_length += field_type__gtpc.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &MBMS__DistributionAcknowledgement_lengthf_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_distributionIndication.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[3]);
  if (field_type__gtpc !=  os_130) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_130.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct MBMS__DistributionAcknowledgement_template::single_value_struct {
OCTETSTRING_template field_type__gtpc;
INTEGER_template field_lengthf;
BITSTRING_template field_distributionIndication;
BITSTRING_template field_spare;
};

void MBMS__DistributionAcknowledgement_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_type__gtpc = ANY_VALUE;
single_value->field_lengthf = ANY_VALUE;
single_value->field_distributionIndication = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void MBMS__DistributionAcknowledgement_template::copy_value(const MBMS__DistributionAcknowledgement& other_value)
{
single_value = new single_value_struct;
if (other_value.type__gtpc().is_bound()) {
  single_value->field_type__gtpc = other_value.type__gtpc();
} else {
  single_value->field_type__gtpc.clean_up();
}
if (other_value.lengthf().is_bound()) {
  single_value->field_lengthf = other_value.lengthf();
} else {
  single_value->field_lengthf.clean_up();
}
if (other_value.distributionIndication().is_bound()) {
  single_value->field_distributionIndication = other_value.distributionIndication();
} else {
  single_value->field_distributionIndication.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void MBMS__DistributionAcknowledgement_template::copy_template(const MBMS__DistributionAcknowledgement_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.type__gtpc().get_selection()) {
single_value->field_type__gtpc = other_value.type__gtpc();
} else {
single_value->field_type__gtpc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthf().get_selection()) {
single_value->field_lengthf = other_value.lengthf();
} else {
single_value->field_lengthf.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.distributionIndication().get_selection()) {
single_value->field_distributionIndication = other_value.distributionIndication();
} else {
single_value->field_distributionIndication.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new MBMS__DistributionAcknowledgement_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new MBMS__DistributionAcknowledgement_template(*other_value.implication_.precondition);
implication_.implied_template = new MBMS__DistributionAcknowledgement_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
break;
}
set_selection(other_value);
}

MBMS__DistributionAcknowledgement_template::MBMS__DistributionAcknowledgement_template()
{
}

MBMS__DistributionAcknowledgement_template::MBMS__DistributionAcknowledgement_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

MBMS__DistributionAcknowledgement_template::MBMS__DistributionAcknowledgement_template(const MBMS__DistributionAcknowledgement& other_value)
{
copy_value(other_value);
}

MBMS__DistributionAcknowledgement_template::MBMS__DistributionAcknowledgement_template(const OPTIONAL<MBMS__DistributionAcknowledgement>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MBMS__DistributionAcknowledgement&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.MBMS_DistributionAcknowledgement from an unbound optional field.");
}
}

MBMS__DistributionAcknowledgement_template::MBMS__DistributionAcknowledgement_template(MBMS__DistributionAcknowledgement_template* p_precondition, MBMS__DistributionAcknowledgement_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

MBMS__DistributionAcknowledgement_template::MBMS__DistributionAcknowledgement_template(Dynamic_Match_Interface<MBMS__DistributionAcknowledgement>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<MBMS__DistributionAcknowledgement>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

MBMS__DistributionAcknowledgement_template::MBMS__DistributionAcknowledgement_template(const MBMS__DistributionAcknowledgement_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

MBMS__DistributionAcknowledgement_template::~MBMS__DistributionAcknowledgement_template()
{
clean_up();
}

MBMS__DistributionAcknowledgement_template& MBMS__DistributionAcknowledgement_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

MBMS__DistributionAcknowledgement_template& MBMS__DistributionAcknowledgement_template::operator=(const MBMS__DistributionAcknowledgement& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

MBMS__DistributionAcknowledgement_template& MBMS__DistributionAcknowledgement_template::operator=(const OPTIONAL<MBMS__DistributionAcknowledgement>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MBMS__DistributionAcknowledgement&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
}
return *this;
}

MBMS__DistributionAcknowledgement_template& MBMS__DistributionAcknowledgement_template::operator=(const MBMS__DistributionAcknowledgement_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean MBMS__DistributionAcknowledgement_template::match(const MBMS__DistributionAcknowledgement& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.type__gtpc().is_bound()) return FALSE;
if(!single_value->field_type__gtpc.match(other_value.type__gtpc(), legacy))return FALSE;
if(!other_value.lengthf().is_bound()) return FALSE;
if(!single_value->field_lengthf.match(other_value.lengthf(), legacy))return FALSE;
if(!other_value.distributionIndication().is_bound()) return FALSE;
if(!single_value->field_distributionIndication.match(other_value.distributionIndication(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
}
return FALSE;
}

boolean MBMS__DistributionAcknowledgement_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_type__gtpc.is_bound()
 || single_value->field_lengthf.is_bound()
 || single_value->field_distributionIndication.is_bound()
 || single_value->field_spare.is_bound();
}

boolean MBMS__DistributionAcknowledgement_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_type__gtpc.is_value()
 && single_value->field_lengthf.is_value()
 && single_value->field_distributionIndication.is_value()
 && single_value->field_spare.is_value();
}

void MBMS__DistributionAcknowledgement_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

MBMS__DistributionAcknowledgement MBMS__DistributionAcknowledgement_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
MBMS__DistributionAcknowledgement ret_val;
if (single_value->field_type__gtpc.is_bound()) {
ret_val.type__gtpc() = single_value->field_type__gtpc.valueof();
}
if (single_value->field_lengthf.is_bound()) {
ret_val.lengthf() = single_value->field_lengthf.valueof();
}
if (single_value->field_distributionIndication.is_bound()) {
ret_val.distributionIndication() = single_value->field_distributionIndication.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void MBMS__DistributionAcknowledgement_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new MBMS__DistributionAcknowledgement_template[list_length];
}

MBMS__DistributionAcknowledgement_template& MBMS__DistributionAcknowledgement_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& MBMS__DistributionAcknowledgement_template::type__gtpc()
{
set_specific();
return single_value->field_type__gtpc;
}

const OCTETSTRING_template& MBMS__DistributionAcknowledgement_template::type__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field type_gtpc of a non-specific template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
return single_value->field_type__gtpc;
}

INTEGER_template& MBMS__DistributionAcknowledgement_template::lengthf()
{
set_specific();
return single_value->field_lengthf;
}

const INTEGER_template& MBMS__DistributionAcknowledgement_template::lengthf() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthf of a non-specific template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
return single_value->field_lengthf;
}

BITSTRING_template& MBMS__DistributionAcknowledgement_template::distributionIndication()
{
set_specific();
return single_value->field_distributionIndication;
}

const BITSTRING_template& MBMS__DistributionAcknowledgement_template::distributionIndication() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field distributionIndication of a non-specific template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
return single_value->field_distributionIndication;
}

BITSTRING_template& MBMS__DistributionAcknowledgement_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& MBMS__DistributionAcknowledgement_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
return single_value->field_spare;
}

int MBMS__DistributionAcknowledgement_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_DistributionAcknowledgement which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.MBMS_DistributionAcknowledgement containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_DistributionAcknowledgement containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_DistributionAcknowledgement containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_DistributionAcknowledgement containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_DistributionAcknowledgement containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_DistributionAcknowledgement containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_DistributionAcknowledgement containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.MBMS_DistributionAcknowledgement containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
  }
  return 0;
}

void MBMS__DistributionAcknowledgement_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log();
TTCN_Logger::log_event_str(", distributionIndication := ");
single_value->field_distributionIndication.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void MBMS__DistributionAcknowledgement_template::log_match(const MBMS__DistributionAcknowledgement& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_type__gtpc.match(match_value.type__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".type_gtpc");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthf.match(match_value.lengthf(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthf");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_distributionIndication.match(match_value.distributionIndication(), legacy)){
TTCN_Logger::log_logmatch_info(".distributionIndication");
single_value->field_distributionIndication.log_match(match_value.distributionIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::log_event_str(", distributionIndication := ");
single_value->field_distributionIndication.log_match(match_value.distributionIndication(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void MBMS__DistributionAcknowledgement_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (distributionIndication().is_bound()) distributionIndication().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void MBMS__DistributionAcknowledgement_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_type__gtpc.encode_text(text_buf);
single_value->field_lengthf.encode_text(text_buf);
single_value->field_distributionIndication.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
}
}

void MBMS__DistributionAcknowledgement_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_type__gtpc.decode_text(text_buf);
single_value->field_lengthf.decode_text(text_buf);
single_value->field_distributionIndication.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new MBMS__DistributionAcknowledgement_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.MBMS_DistributionAcknowledgement.");
}
}

void MBMS__DistributionAcknowledgement_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    MBMS__DistributionAcknowledgement_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @GTPC_Types.MBMS_DistributionAcknowledgement has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) distributionIndication().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "distributionIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          distributionIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.MBMS_DistributionAcknowledgement: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    MBMS__DistributionAcknowledgement_template* precondition = new MBMS__DistributionAcknowledgement_template;
    precondition->set_param(*param.get_elem(0));
    MBMS__DistributionAcknowledgement_template* implied_template = new MBMS__DistributionAcknowledgement_template;
    implied_template->set_param(*param.get_elem(1));
    *this = MBMS__DistributionAcknowledgement_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.MBMS_DistributionAcknowledgement");
  }
  is_ifpresent = param.get_ifpresent();
}

void MBMS__DistributionAcknowledgement_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_type__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MBMS_DistributionAcknowledgement");
single_value->field_lengthf.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MBMS_DistributionAcknowledgement");
single_value->field_distributionIndication.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MBMS_DistributionAcknowledgement");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.MBMS_DistributionAcknowledgement");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.MBMS_DistributionAcknowledgement");
}

boolean MBMS__DistributionAcknowledgement_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean MBMS__DistributionAcknowledgement_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ReliableInterRATHandoverInfo::ReliableInterRATHandoverInfo()
{
}

ReliableInterRATHandoverInfo::ReliableInterRATHandoverInfo(const OCTETSTRING& par_type__gtpc,
    const INTEGER& par_lengthf,
    const BITSTRING& par_reliableInterRATHandoverInfoIndicator,
    const BITSTRING& par_spare)
  :   field_type__gtpc(par_type__gtpc),
  field_lengthf(par_lengthf),
  field_reliableInterRATHandoverInfoIndicator(par_reliableInterRATHandoverInfoIndicator),
  field_spare(par_spare)
{
}

ReliableInterRATHandoverInfo::ReliableInterRATHandoverInfo(const ReliableInterRATHandoverInfo& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.ReliableInterRATHandoverInfo.");
if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
else field_type__gtpc.clean_up();
if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
else field_lengthf.clean_up();
if (other_value.reliableInterRATHandoverInfoIndicator().is_bound()) field_reliableInterRATHandoverInfoIndicator = other_value.reliableInterRATHandoverInfoIndicator();
else field_reliableInterRATHandoverInfoIndicator.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void ReliableInterRATHandoverInfo::clean_up()
{
field_type__gtpc.clean_up();
field_lengthf.clean_up();
field_reliableInterRATHandoverInfoIndicator.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* ReliableInterRATHandoverInfo::get_descriptor() const { return &ReliableInterRATHandoverInfo_descr_; }
ReliableInterRATHandoverInfo& ReliableInterRATHandoverInfo::operator=(const ReliableInterRATHandoverInfo& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.ReliableInterRATHandoverInfo.");
  if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
  else field_type__gtpc.clean_up();
  if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
  else field_lengthf.clean_up();
  if (other_value.reliableInterRATHandoverInfoIndicator().is_bound()) field_reliableInterRATHandoverInfoIndicator = other_value.reliableInterRATHandoverInfoIndicator();
  else field_reliableInterRATHandoverInfoIndicator.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean ReliableInterRATHandoverInfo::operator==(const ReliableInterRATHandoverInfo& other_value) const
{
return field_type__gtpc==other_value.field_type__gtpc
  && field_lengthf==other_value.field_lengthf
  && field_reliableInterRATHandoverInfoIndicator==other_value.field_reliableInterRATHandoverInfoIndicator
  && field_spare==other_value.field_spare;
}

boolean ReliableInterRATHandoverInfo::is_bound() const
{
return (field_type__gtpc.is_bound())
  || (field_lengthf.is_bound())
  || (field_reliableInterRATHandoverInfoIndicator.is_bound())
  || (field_spare.is_bound());
}
boolean ReliableInterRATHandoverInfo::is_value() const
{
return field_type__gtpc.is_value()
  && field_lengthf.is_value()
  && field_reliableInterRATHandoverInfoIndicator.is_value()
  && field_spare.is_value();
}
void ReliableInterRATHandoverInfo::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ type_gtpc := ");
field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
field_lengthf.log();
TTCN_Logger::log_event_str(", reliableInterRATHandoverInfoIndicator := ");
field_reliableInterRATHandoverInfoIndicator.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void ReliableInterRATHandoverInfo::set_implicit_omit()
{
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (reliableInterRATHandoverInfoIndicator().is_bound()) reliableInterRATHandoverInfoIndicator().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void ReliableInterRATHandoverInfo::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @GTPC_Types.ReliableInterRATHandoverInfo has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reliableInterRATHandoverInfoIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reliableInterRATHandoverInfoIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reliableInterRATHandoverInfoIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.ReliableInterRATHandoverInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.ReliableInterRATHandoverInfo");
  }
}

void ReliableInterRATHandoverInfo::encode_text(Text_Buf& text_buf) const
{
field_type__gtpc.encode_text(text_buf);
field_lengthf.encode_text(text_buf);
field_reliableInterRATHandoverInfoIndicator.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void ReliableInterRATHandoverInfo::decode_text(Text_Buf& text_buf)
{
field_type__gtpc.decode_text(text_buf);
field_lengthf.decode_text(text_buf);
field_reliableInterRATHandoverInfoIndicator.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void ReliableInterRATHandoverInfo::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ReliableInterRATHandoverInfo::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ReliableInterRATHandoverInfo::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_type__gtpc.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, ReliableInterRATHandoverInfo_lengthf_descr_.raw->forceomit);
  decoded_field_length = field_lengthf.RAW_decode(ReliableInterRATHandoverInfo_lengthf_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthf.convert_to_Integer(ReliableInterRATHandoverInfo_lengthf_descr_);
  field_lengthf = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_reliableInterRATHandoverInfoIndicator.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT7_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_type__gtpc !=  os_91) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ReliableInterRATHandoverInfo::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, ReliableInterRATHandoverInfo_lengthf_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT7_descr_.raw);
  encoded_length += field_type__gtpc.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &ReliableInterRATHandoverInfo_lengthf_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_reliableInterRATHandoverInfoIndicator.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[3]);
  if (field_type__gtpc !=  os_91) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_91.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct ReliableInterRATHandoverInfo_template::single_value_struct {
OCTETSTRING_template field_type__gtpc;
INTEGER_template field_lengthf;
BITSTRING_template field_reliableInterRATHandoverInfoIndicator;
BITSTRING_template field_spare;
};

void ReliableInterRATHandoverInfo_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_type__gtpc = ANY_VALUE;
single_value->field_lengthf = ANY_VALUE;
single_value->field_reliableInterRATHandoverInfoIndicator = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void ReliableInterRATHandoverInfo_template::copy_value(const ReliableInterRATHandoverInfo& other_value)
{
single_value = new single_value_struct;
if (other_value.type__gtpc().is_bound()) {
  single_value->field_type__gtpc = other_value.type__gtpc();
} else {
  single_value->field_type__gtpc.clean_up();
}
if (other_value.lengthf().is_bound()) {
  single_value->field_lengthf = other_value.lengthf();
} else {
  single_value->field_lengthf.clean_up();
}
if (other_value.reliableInterRATHandoverInfoIndicator().is_bound()) {
  single_value->field_reliableInterRATHandoverInfoIndicator = other_value.reliableInterRATHandoverInfoIndicator();
} else {
  single_value->field_reliableInterRATHandoverInfoIndicator.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ReliableInterRATHandoverInfo_template::copy_template(const ReliableInterRATHandoverInfo_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.type__gtpc().get_selection()) {
single_value->field_type__gtpc = other_value.type__gtpc();
} else {
single_value->field_type__gtpc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthf().get_selection()) {
single_value->field_lengthf = other_value.lengthf();
} else {
single_value->field_lengthf.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reliableInterRATHandoverInfoIndicator().get_selection()) {
single_value->field_reliableInterRATHandoverInfoIndicator = other_value.reliableInterRATHandoverInfoIndicator();
} else {
single_value->field_reliableInterRATHandoverInfoIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ReliableInterRATHandoverInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ReliableInterRATHandoverInfo_template(*other_value.implication_.precondition);
implication_.implied_template = new ReliableInterRATHandoverInfo_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
break;
}
set_selection(other_value);
}

ReliableInterRATHandoverInfo_template::ReliableInterRATHandoverInfo_template()
{
}

ReliableInterRATHandoverInfo_template::ReliableInterRATHandoverInfo_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ReliableInterRATHandoverInfo_template::ReliableInterRATHandoverInfo_template(const ReliableInterRATHandoverInfo& other_value)
{
copy_value(other_value);
}

ReliableInterRATHandoverInfo_template::ReliableInterRATHandoverInfo_template(const OPTIONAL<ReliableInterRATHandoverInfo>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReliableInterRATHandoverInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.ReliableInterRATHandoverInfo from an unbound optional field.");
}
}

ReliableInterRATHandoverInfo_template::ReliableInterRATHandoverInfo_template(ReliableInterRATHandoverInfo_template* p_precondition, ReliableInterRATHandoverInfo_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ReliableInterRATHandoverInfo_template::ReliableInterRATHandoverInfo_template(Dynamic_Match_Interface<ReliableInterRATHandoverInfo>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ReliableInterRATHandoverInfo>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ReliableInterRATHandoverInfo_template::ReliableInterRATHandoverInfo_template(const ReliableInterRATHandoverInfo_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ReliableInterRATHandoverInfo_template::~ReliableInterRATHandoverInfo_template()
{
clean_up();
}

ReliableInterRATHandoverInfo_template& ReliableInterRATHandoverInfo_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ReliableInterRATHandoverInfo_template& ReliableInterRATHandoverInfo_template::operator=(const ReliableInterRATHandoverInfo& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ReliableInterRATHandoverInfo_template& ReliableInterRATHandoverInfo_template::operator=(const OPTIONAL<ReliableInterRATHandoverInfo>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReliableInterRATHandoverInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
}
return *this;
}

ReliableInterRATHandoverInfo_template& ReliableInterRATHandoverInfo_template::operator=(const ReliableInterRATHandoverInfo_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ReliableInterRATHandoverInfo_template::match(const ReliableInterRATHandoverInfo& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.type__gtpc().is_bound()) return FALSE;
if(!single_value->field_type__gtpc.match(other_value.type__gtpc(), legacy))return FALSE;
if(!other_value.lengthf().is_bound()) return FALSE;
if(!single_value->field_lengthf.match(other_value.lengthf(), legacy))return FALSE;
if(!other_value.reliableInterRATHandoverInfoIndicator().is_bound()) return FALSE;
if(!single_value->field_reliableInterRATHandoverInfoIndicator.match(other_value.reliableInterRATHandoverInfoIndicator(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
}
return FALSE;
}

boolean ReliableInterRATHandoverInfo_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_type__gtpc.is_bound()
 || single_value->field_lengthf.is_bound()
 || single_value->field_reliableInterRATHandoverInfoIndicator.is_bound()
 || single_value->field_spare.is_bound();
}

boolean ReliableInterRATHandoverInfo_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_type__gtpc.is_value()
 && single_value->field_lengthf.is_value()
 && single_value->field_reliableInterRATHandoverInfoIndicator.is_value()
 && single_value->field_spare.is_value();
}

void ReliableInterRATHandoverInfo_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ReliableInterRATHandoverInfo ReliableInterRATHandoverInfo_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
ReliableInterRATHandoverInfo ret_val;
if (single_value->field_type__gtpc.is_bound()) {
ret_val.type__gtpc() = single_value->field_type__gtpc.valueof();
}
if (single_value->field_lengthf.is_bound()) {
ret_val.lengthf() = single_value->field_lengthf.valueof();
}
if (single_value->field_reliableInterRATHandoverInfoIndicator.is_bound()) {
ret_val.reliableInterRATHandoverInfoIndicator() = single_value->field_reliableInterRATHandoverInfoIndicator.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void ReliableInterRATHandoverInfo_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ReliableInterRATHandoverInfo_template[list_length];
}

ReliableInterRATHandoverInfo_template& ReliableInterRATHandoverInfo_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& ReliableInterRATHandoverInfo_template::type__gtpc()
{
set_specific();
return single_value->field_type__gtpc;
}

const OCTETSTRING_template& ReliableInterRATHandoverInfo_template::type__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field type_gtpc of a non-specific template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
return single_value->field_type__gtpc;
}

INTEGER_template& ReliableInterRATHandoverInfo_template::lengthf()
{
set_specific();
return single_value->field_lengthf;
}

const INTEGER_template& ReliableInterRATHandoverInfo_template::lengthf() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthf of a non-specific template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
return single_value->field_lengthf;
}

BITSTRING_template& ReliableInterRATHandoverInfo_template::reliableInterRATHandoverInfoIndicator()
{
set_specific();
return single_value->field_reliableInterRATHandoverInfoIndicator;
}

const BITSTRING_template& ReliableInterRATHandoverInfo_template::reliableInterRATHandoverInfoIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reliableInterRATHandoverInfoIndicator of a non-specific template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
return single_value->field_reliableInterRATHandoverInfoIndicator;
}

BITSTRING_template& ReliableInterRATHandoverInfo_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& ReliableInterRATHandoverInfo_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
return single_value->field_spare;
}

int ReliableInterRATHandoverInfo_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.ReliableInterRATHandoverInfo which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.ReliableInterRATHandoverInfo containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.ReliableInterRATHandoverInfo containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.ReliableInterRATHandoverInfo containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.ReliableInterRATHandoverInfo containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.ReliableInterRATHandoverInfo containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.ReliableInterRATHandoverInfo containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.ReliableInterRATHandoverInfo containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.ReliableInterRATHandoverInfo containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
  }
  return 0;
}

void ReliableInterRATHandoverInfo_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log();
TTCN_Logger::log_event_str(", reliableInterRATHandoverInfoIndicator := ");
single_value->field_reliableInterRATHandoverInfoIndicator.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ReliableInterRATHandoverInfo_template::log_match(const ReliableInterRATHandoverInfo& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_type__gtpc.match(match_value.type__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".type_gtpc");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthf.match(match_value.lengthf(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthf");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reliableInterRATHandoverInfoIndicator.match(match_value.reliableInterRATHandoverInfoIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".reliableInterRATHandoverInfoIndicator");
single_value->field_reliableInterRATHandoverInfoIndicator.log_match(match_value.reliableInterRATHandoverInfoIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::log_event_str(", reliableInterRATHandoverInfoIndicator := ");
single_value->field_reliableInterRATHandoverInfoIndicator.log_match(match_value.reliableInterRATHandoverInfoIndicator(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ReliableInterRATHandoverInfo_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (reliableInterRATHandoverInfoIndicator().is_bound()) reliableInterRATHandoverInfoIndicator().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void ReliableInterRATHandoverInfo_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_type__gtpc.encode_text(text_buf);
single_value->field_lengthf.encode_text(text_buf);
single_value->field_reliableInterRATHandoverInfoIndicator.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
}
}

void ReliableInterRATHandoverInfo_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_type__gtpc.decode_text(text_buf);
single_value->field_lengthf.decode_text(text_buf);
single_value->field_reliableInterRATHandoverInfoIndicator.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ReliableInterRATHandoverInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.ReliableInterRATHandoverInfo.");
}
}

void ReliableInterRATHandoverInfo_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ReliableInterRATHandoverInfo_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @GTPC_Types.ReliableInterRATHandoverInfo has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reliableInterRATHandoverInfoIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reliableInterRATHandoverInfoIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reliableInterRATHandoverInfoIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.ReliableInterRATHandoverInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ReliableInterRATHandoverInfo_template* precondition = new ReliableInterRATHandoverInfo_template;
    precondition->set_param(*param.get_elem(0));
    ReliableInterRATHandoverInfo_template* implied_template = new ReliableInterRATHandoverInfo_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ReliableInterRATHandoverInfo_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.ReliableInterRATHandoverInfo");
  }
  is_ifpresent = param.get_ifpresent();
}

void ReliableInterRATHandoverInfo_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_type__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.ReliableInterRATHandoverInfo");
single_value->field_lengthf.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.ReliableInterRATHandoverInfo");
single_value->field_reliableInterRATHandoverInfoIndicator.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.ReliableInterRATHandoverInfo");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.ReliableInterRATHandoverInfo");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.ReliableInterRATHandoverInfo");
}

boolean ReliableInterRATHandoverInfo_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ReliableInterRATHandoverInfo_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RFSP__Index::RFSP__Index()
{
}

RFSP__Index::RFSP__Index(const OCTETSTRING& par_type__gtpc,
    const INTEGER& par_lengthf,
    const INTEGER& par_rFSPIndexValue)
  :   field_type__gtpc(par_type__gtpc),
  field_lengthf(par_lengthf),
  field_rFSPIndexValue(par_rFSPIndexValue)
{
}

RFSP__Index::RFSP__Index(const RFSP__Index& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.RFSP_Index.");
if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
else field_type__gtpc.clean_up();
if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
else field_lengthf.clean_up();
if (other_value.rFSPIndexValue().is_bound()) field_rFSPIndexValue = other_value.rFSPIndexValue();
else field_rFSPIndexValue.clean_up();
}

void RFSP__Index::clean_up()
{
field_type__gtpc.clean_up();
field_lengthf.clean_up();
field_rFSPIndexValue.clean_up();
}

const TTCN_Typedescriptor_t* RFSP__Index::get_descriptor() const { return &RFSP__Index_descr_; }
RFSP__Index& RFSP__Index::operator=(const RFSP__Index& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.RFSP_Index.");
  if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
  else field_type__gtpc.clean_up();
  if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
  else field_lengthf.clean_up();
  if (other_value.rFSPIndexValue().is_bound()) field_rFSPIndexValue = other_value.rFSPIndexValue();
  else field_rFSPIndexValue.clean_up();
}
return *this;
}

boolean RFSP__Index::operator==(const RFSP__Index& other_value) const
{
return field_type__gtpc==other_value.field_type__gtpc
  && field_lengthf==other_value.field_lengthf
  && field_rFSPIndexValue==other_value.field_rFSPIndexValue;
}

boolean RFSP__Index::is_bound() const
{
return (field_type__gtpc.is_bound())
  || (field_lengthf.is_bound())
  || (field_rFSPIndexValue.is_bound());
}
boolean RFSP__Index::is_value() const
{
return field_type__gtpc.is_value()
  && field_lengthf.is_value()
  && field_rFSPIndexValue.is_value();
}
void RFSP__Index::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ type_gtpc := ");
field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
field_lengthf.log();
TTCN_Logger::log_event_str(", rFSPIndexValue := ");
field_rFSPIndexValue.log();
TTCN_Logger::log_event_str(" }");
}

void RFSP__Index::set_implicit_omit()
{
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (rFSPIndexValue().is_bound()) rFSPIndexValue().set_implicit_omit();
}

void RFSP__Index::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @GTPC_Types.RFSP_Index has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rFSPIndexValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rFSPIndexValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rFSPIndexValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RFSP_Index: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.RFSP_Index");
  }
}

void RFSP__Index::encode_text(Text_Buf& text_buf) const
{
field_type__gtpc.encode_text(text_buf);
field_lengthf.encode_text(text_buf);
field_rFSPIndexValue.encode_text(text_buf);
}

void RFSP__Index::decode_text(Text_Buf& text_buf)
{
field_type__gtpc.decode_text(text_buf);
field_lengthf.decode_text(text_buf);
field_rFSPIndexValue.decode_text(text_buf);
}

void RFSP__Index::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RFSP__Index::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RFSP__Index::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_type__gtpc.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RFSP__Index_lengthf_descr_.raw->forceomit);
  decoded_field_length = field_lengthf.RAW_decode(RFSP__Index_lengthf_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthf.convert_to_Integer(RFSP__Index_lengthf_descr_);
  field_lengthf = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::LIN2__BO__LAST_descr_.raw->forceomit);
  decoded_field_length = field_rFSPIndexValue.RAW_decode(General__Types::LIN2__BO__LAST_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_type__gtpc !=  os_70) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RFSP__Index::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RFSP__Index_lengthf_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::LIN2__BO__LAST_descr_.raw);
  encoded_length += field_type__gtpc.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &RFSP__Index_lengthf_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_rFSPIndexValue.RAW_encode(General__Types::LIN2__BO__LAST_descr_, *myleaf.body.node.nodes[2]);
  if (field_type__gtpc !=  os_70) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_70.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct RFSP__Index_template::single_value_struct {
OCTETSTRING_template field_type__gtpc;
INTEGER_template field_lengthf;
INTEGER_template field_rFSPIndexValue;
};

void RFSP__Index_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_type__gtpc = ANY_VALUE;
single_value->field_lengthf = ANY_VALUE;
single_value->field_rFSPIndexValue = ANY_VALUE;
}
}
}

void RFSP__Index_template::copy_value(const RFSP__Index& other_value)
{
single_value = new single_value_struct;
if (other_value.type__gtpc().is_bound()) {
  single_value->field_type__gtpc = other_value.type__gtpc();
} else {
  single_value->field_type__gtpc.clean_up();
}
if (other_value.lengthf().is_bound()) {
  single_value->field_lengthf = other_value.lengthf();
} else {
  single_value->field_lengthf.clean_up();
}
if (other_value.rFSPIndexValue().is_bound()) {
  single_value->field_rFSPIndexValue = other_value.rFSPIndexValue();
} else {
  single_value->field_rFSPIndexValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RFSP__Index_template::copy_template(const RFSP__Index_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.type__gtpc().get_selection()) {
single_value->field_type__gtpc = other_value.type__gtpc();
} else {
single_value->field_type__gtpc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthf().get_selection()) {
single_value->field_lengthf = other_value.lengthf();
} else {
single_value->field_lengthf.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rFSPIndexValue().get_selection()) {
single_value->field_rFSPIndexValue = other_value.rFSPIndexValue();
} else {
single_value->field_rFSPIndexValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RFSP__Index_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RFSP__Index_template(*other_value.implication_.precondition);
implication_.implied_template = new RFSP__Index_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.RFSP_Index.");
break;
}
set_selection(other_value);
}

RFSP__Index_template::RFSP__Index_template()
{
}

RFSP__Index_template::RFSP__Index_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RFSP__Index_template::RFSP__Index_template(const RFSP__Index& other_value)
{
copy_value(other_value);
}

RFSP__Index_template::RFSP__Index_template(const OPTIONAL<RFSP__Index>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RFSP__Index&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.RFSP_Index from an unbound optional field.");
}
}

RFSP__Index_template::RFSP__Index_template(RFSP__Index_template* p_precondition, RFSP__Index_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RFSP__Index_template::RFSP__Index_template(Dynamic_Match_Interface<RFSP__Index>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RFSP__Index>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RFSP__Index_template::RFSP__Index_template(const RFSP__Index_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RFSP__Index_template::~RFSP__Index_template()
{
clean_up();
}

RFSP__Index_template& RFSP__Index_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RFSP__Index_template& RFSP__Index_template::operator=(const RFSP__Index& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RFSP__Index_template& RFSP__Index_template::operator=(const OPTIONAL<RFSP__Index>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RFSP__Index&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.RFSP_Index.");
}
return *this;
}

RFSP__Index_template& RFSP__Index_template::operator=(const RFSP__Index_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RFSP__Index_template::match(const RFSP__Index& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.type__gtpc().is_bound()) return FALSE;
if(!single_value->field_type__gtpc.match(other_value.type__gtpc(), legacy))return FALSE;
if(!other_value.lengthf().is_bound()) return FALSE;
if(!single_value->field_lengthf.match(other_value.lengthf(), legacy))return FALSE;
if(!other_value.rFSPIndexValue().is_bound()) return FALSE;
if(!single_value->field_rFSPIndexValue.match(other_value.rFSPIndexValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.RFSP_Index.");
}
return FALSE;
}

boolean RFSP__Index_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_type__gtpc.is_bound()
 || single_value->field_lengthf.is_bound()
 || single_value->field_rFSPIndexValue.is_bound();
}

boolean RFSP__Index_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_type__gtpc.is_value()
 && single_value->field_lengthf.is_value()
 && single_value->field_rFSPIndexValue.is_value();
}

void RFSP__Index_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RFSP__Index RFSP__Index_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.RFSP_Index.");
RFSP__Index ret_val;
if (single_value->field_type__gtpc.is_bound()) {
ret_val.type__gtpc() = single_value->field_type__gtpc.valueof();
}
if (single_value->field_lengthf.is_bound()) {
ret_val.lengthf() = single_value->field_lengthf.valueof();
}
if (single_value->field_rFSPIndexValue.is_bound()) {
ret_val.rFSPIndexValue() = single_value->field_rFSPIndexValue.valueof();
}
return ret_val;
}

void RFSP__Index_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.RFSP_Index.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RFSP__Index_template[list_length];
}

RFSP__Index_template& RFSP__Index_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.RFSP_Index.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.RFSP_Index.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& RFSP__Index_template::type__gtpc()
{
set_specific();
return single_value->field_type__gtpc;
}

const OCTETSTRING_template& RFSP__Index_template::type__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field type_gtpc of a non-specific template of type @GTPC_Types.RFSP_Index.");
return single_value->field_type__gtpc;
}

INTEGER_template& RFSP__Index_template::lengthf()
{
set_specific();
return single_value->field_lengthf;
}

const INTEGER_template& RFSP__Index_template::lengthf() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthf of a non-specific template of type @GTPC_Types.RFSP_Index.");
return single_value->field_lengthf;
}

INTEGER_template& RFSP__Index_template::rFSPIndexValue()
{
set_specific();
return single_value->field_rFSPIndexValue;
}

const INTEGER_template& RFSP__Index_template::rFSPIndexValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rFSPIndexValue of a non-specific template of type @GTPC_Types.RFSP_Index.");
return single_value->field_rFSPIndexValue;
}

int RFSP__Index_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RFSP_Index which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.RFSP_Index containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RFSP_Index containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RFSP_Index containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RFSP_Index containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RFSP_Index containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RFSP_Index containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RFSP_Index containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.RFSP_Index containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.RFSP_Index.");
  }
  return 0;
}

void RFSP__Index_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log();
TTCN_Logger::log_event_str(", rFSPIndexValue := ");
single_value->field_rFSPIndexValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RFSP__Index_template::log_match(const RFSP__Index& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_type__gtpc.match(match_value.type__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".type_gtpc");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthf.match(match_value.lengthf(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthf");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rFSPIndexValue.match(match_value.rFSPIndexValue(), legacy)){
TTCN_Logger::log_logmatch_info(".rFSPIndexValue");
single_value->field_rFSPIndexValue.log_match(match_value.rFSPIndexValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::log_event_str(", rFSPIndexValue := ");
single_value->field_rFSPIndexValue.log_match(match_value.rFSPIndexValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RFSP__Index_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (rFSPIndexValue().is_bound()) rFSPIndexValue().set_implicit_omit();
}

void RFSP__Index_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_type__gtpc.encode_text(text_buf);
single_value->field_lengthf.encode_text(text_buf);
single_value->field_rFSPIndexValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.RFSP_Index.");
}
}

void RFSP__Index_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_type__gtpc.decode_text(text_buf);
single_value->field_lengthf.decode_text(text_buf);
single_value->field_rFSPIndexValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RFSP__Index_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.RFSP_Index.");
}
}

void RFSP__Index_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RFSP__Index_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @GTPC_Types.RFSP_Index has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rFSPIndexValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rFSPIndexValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rFSPIndexValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.RFSP_Index: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RFSP__Index_template* precondition = new RFSP__Index_template;
    precondition->set_param(*param.get_elem(0));
    RFSP__Index_template* implied_template = new RFSP__Index_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RFSP__Index_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.RFSP_Index");
  }
  is_ifpresent = param.get_ifpresent();
}

void RFSP__Index_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_type__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RFSP_Index");
single_value->field_lengthf.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RFSP_Index");
single_value->field_rFSPIndexValue.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.RFSP_Index");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.RFSP_Index");
}

boolean RFSP__Index_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RFSP__Index_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const FullyQualifiedDomainName FullyQualifiedDomainName__List::UNBOUND_ELEM;
FullyQualifiedDomainName__List::FullyQualifiedDomainName__List()
{
val_ptr = NULL;
}

FullyQualifiedDomainName__List::FullyQualifiedDomainName__List(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

FullyQualifiedDomainName__List::FullyQualifiedDomainName__List(const FullyQualifiedDomainName__List& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.FullyQualifiedDomainName_List.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

FullyQualifiedDomainName__List::~FullyQualifiedDomainName__List()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void FullyQualifiedDomainName__List::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

FullyQualifiedDomainName__List& FullyQualifiedDomainName__List::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

FullyQualifiedDomainName__List& FullyQualifiedDomainName__List::operator=(const FullyQualifiedDomainName__List& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @GTPC_Types.FullyQualifiedDomainName_List.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean FullyQualifiedDomainName__List::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @GTPC_Types.FullyQualifiedDomainName_List.");
return val_ptr->n_elements == 0 ;
}

boolean FullyQualifiedDomainName__List::operator==(const FullyQualifiedDomainName__List& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @GTPC_Types.FullyQualifiedDomainName_List.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @GTPC_Types.FullyQualifiedDomainName_List.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

FullyQualifiedDomainName& FullyQualifiedDomainName__List::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @GTPC_Types.FullyQualifiedDomainName_List using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (FullyQualifiedDomainName**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new FullyQualifiedDomainName(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new FullyQualifiedDomainName;
}
return *val_ptr->value_elements[index_value];
}

FullyQualifiedDomainName& FullyQualifiedDomainName__List::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @GTPC_Types.FullyQualifiedDomainName_List.");
return (*this)[(int)index_value];
}

const FullyQualifiedDomainName& FullyQualifiedDomainName__List::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @GTPC_Types.FullyQualifiedDomainName_List.");
if (index_value < 0) TTCN_error("Accessing an element of type @GTPC_Types.FullyQualifiedDomainName_List using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @GTPC_Types.FullyQualifiedDomainName_List: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const FullyQualifiedDomainName& FullyQualifiedDomainName__List::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @GTPC_Types.FullyQualifiedDomainName_List.");
return (*this)[(int)index_value];
}

FullyQualifiedDomainName__List FullyQualifiedDomainName__List::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

FullyQualifiedDomainName__List FullyQualifiedDomainName__List::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

FullyQualifiedDomainName__List FullyQualifiedDomainName__List::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

FullyQualifiedDomainName__List FullyQualifiedDomainName__List::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @GTPC_Types.FullyQualifiedDomainName_List.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
FullyQualifiedDomainName__List ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new FullyQualifiedDomainName(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

FullyQualifiedDomainName__List FullyQualifiedDomainName__List::operator+(const FullyQualifiedDomainName__List& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @GTPC_Types.FullyQualifiedDomainName_List concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
FullyQualifiedDomainName__List ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new FullyQualifiedDomainName(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new FullyQualifiedDomainName(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

FullyQualifiedDomainName__List FullyQualifiedDomainName__List::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @GTPC_Types.FullyQualifiedDomainName_List.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@GTPC_Types.FullyQualifiedDomainName_List","element");
FullyQualifiedDomainName__List ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new FullyQualifiedDomainName(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

FullyQualifiedDomainName__List FullyQualifiedDomainName__List::replace(int index, int len, const FullyQualifiedDomainName__List& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @GTPC_Types.FullyQualifiedDomainName_List.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @GTPC_Types.FullyQualifiedDomainName_List.");
check_replace_arguments(val_ptr->n_elements, index, len, "@GTPC_Types.FullyQualifiedDomainName_List","element");
FullyQualifiedDomainName__List ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new FullyQualifiedDomainName(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new FullyQualifiedDomainName(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new FullyQualifiedDomainName(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

FullyQualifiedDomainName__List FullyQualifiedDomainName__List::replace(int index, int len, const FullyQualifiedDomainName__List_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void FullyQualifiedDomainName__List::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @GTPC_Types.FullyQualifiedDomainName_List.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (FullyQualifiedDomainName**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new FullyQualifiedDomainName(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (FullyQualifiedDomainName**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @GTPC_Types.FullyQualifiedDomainName_List: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (FullyQualifiedDomainName**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean FullyQualifiedDomainName__List::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int FullyQualifiedDomainName__List::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @GTPC_Types.FullyQualifiedDomainName_List.");
return val_ptr->n_elements;
}

int FullyQualifiedDomainName__List::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @GTPC_Types.FullyQualifiedDomainName_List.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void FullyQualifiedDomainName__List::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void FullyQualifiedDomainName__List::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void FullyQualifiedDomainName__List::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@GTPC_Types.FullyQualifiedDomainName_List");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@GTPC_Types.FullyQualifiedDomainName_List");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void FullyQualifiedDomainName__List::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @GTPC_Types.FullyQualifiedDomainName_List.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void FullyQualifiedDomainName__List::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @GTPC_Types.FullyQualifiedDomainName_List.");
val_ptr->value_elements = (FullyQualifiedDomainName**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new FullyQualifiedDomainName;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void FullyQualifiedDomainName__List::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void FullyQualifiedDomainName__List::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int FullyQualifiedDomainName__List::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int FullyQualifiedDomainName__List::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void FullyQualifiedDomainName__List_template::copy_value(const FullyQualifiedDomainName__List& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @GTPC_Types.FullyQualifiedDomainName_List with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (FullyQualifiedDomainName_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new FullyQualifiedDomainName_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new FullyQualifiedDomainName_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void FullyQualifiedDomainName__List_template::copy_template(const FullyQualifiedDomainName__List_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (FullyQualifiedDomainName_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new FullyQualifiedDomainName_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new FullyQualifiedDomainName_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new FullyQualifiedDomainName__List_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new FullyQualifiedDomainName__List_template(*other_value.implication_.precondition);
implication_.implied_template = new FullyQualifiedDomainName__List_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.FullyQualifiedDomainName_List.");
break;
}
set_selection(other_value);
}

boolean FullyQualifiedDomainName__List_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const FullyQualifiedDomainName__List_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const FullyQualifiedDomainName__List*)value_ptr)[value_index], legacy);
else return ((const FullyQualifiedDomainName__List_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

FullyQualifiedDomainName__List_template::FullyQualifiedDomainName__List_template()
{
}

FullyQualifiedDomainName__List_template::FullyQualifiedDomainName__List_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

FullyQualifiedDomainName__List_template::FullyQualifiedDomainName__List_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

FullyQualifiedDomainName__List_template::FullyQualifiedDomainName__List_template(const FullyQualifiedDomainName__List& other_value)
{
copy_value(other_value);
}

FullyQualifiedDomainName__List_template::FullyQualifiedDomainName__List_template(const OPTIONAL<FullyQualifiedDomainName__List>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const FullyQualifiedDomainName__List&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.FullyQualifiedDomainName_List from an unbound optional field.");
}
}

FullyQualifiedDomainName__List_template::FullyQualifiedDomainName__List_template(FullyQualifiedDomainName__List_template* p_precondition, FullyQualifiedDomainName__List_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

FullyQualifiedDomainName__List_template::FullyQualifiedDomainName__List_template(Dynamic_Match_Interface<FullyQualifiedDomainName__List>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<FullyQualifiedDomainName__List>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

FullyQualifiedDomainName__List_template::FullyQualifiedDomainName__List_template(const FullyQualifiedDomainName__List_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

FullyQualifiedDomainName__List_template::~FullyQualifiedDomainName__List_template()
{
clean_up();
}

void FullyQualifiedDomainName__List_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

FullyQualifiedDomainName__List_template& FullyQualifiedDomainName__List_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

FullyQualifiedDomainName__List_template& FullyQualifiedDomainName__List_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

FullyQualifiedDomainName__List_template& FullyQualifiedDomainName__List_template::operator=(const FullyQualifiedDomainName__List& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

FullyQualifiedDomainName__List_template& FullyQualifiedDomainName__List_template::operator=(const OPTIONAL<FullyQualifiedDomainName__List>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const FullyQualifiedDomainName__List&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.FullyQualifiedDomainName_List.");
}
return *this;
}

FullyQualifiedDomainName__List_template& FullyQualifiedDomainName__List_template::operator=(const FullyQualifiedDomainName__List_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

FullyQualifiedDomainName_template& FullyQualifiedDomainName__List_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @GTPC_Types.FullyQualifiedDomainName_List using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @GTPC_Types.FullyQualifiedDomainName_List.");
    break;
}
return *single_value.value_elements[index_value];
}

FullyQualifiedDomainName_template& FullyQualifiedDomainName__List_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @GTPC_Types.FullyQualifiedDomainName_List.");
return (*this)[(int)index_value];
}

const FullyQualifiedDomainName_template& FullyQualifiedDomainName__List_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @GTPC_Types.FullyQualifiedDomainName_List using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @GTPC_Types.FullyQualifiedDomainName_List.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @GTPC_Types.FullyQualifiedDomainName_List: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const FullyQualifiedDomainName_template& FullyQualifiedDomainName__List_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @GTPC_Types.FullyQualifiedDomainName_List.");
return (*this)[(int)index_value];
}

void FullyQualifiedDomainName__List_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @GTPC_Types.FullyQualifiedDomainName_List.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (FullyQualifiedDomainName_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new FullyQualifiedDomainName_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new FullyQualifiedDomainName_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (FullyQualifiedDomainName_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int FullyQualifiedDomainName__List_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int FullyQualifiedDomainName__List_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName_List which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName_List containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName_List containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName_List containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName_List containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName_List containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @GTPC_Types.FullyQualifiedDomainName_List.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @GTPC_Types.FullyQualifiedDomainName_List");
}

boolean FullyQualifiedDomainName__List_template::match(const FullyQualifiedDomainName__List& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @GTPC_Types.FullyQualifiedDomainName_List.");
}
return FALSE;
}

boolean FullyQualifiedDomainName__List_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

FullyQualifiedDomainName__List FullyQualifiedDomainName__List_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.FullyQualifiedDomainName_List.");
FullyQualifiedDomainName__List ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

FullyQualifiedDomainName__List FullyQualifiedDomainName__List_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

FullyQualifiedDomainName__List FullyQualifiedDomainName__List_template::replace(int index, int len, const FullyQualifiedDomainName__List_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

FullyQualifiedDomainName__List FullyQualifiedDomainName__List_template::replace(int index, int len, const FullyQualifiedDomainName__List& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void FullyQualifiedDomainName__List_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new FullyQualifiedDomainName__List_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @GTPC_Types.FullyQualifiedDomainName_List.");
}
set_selection(template_type);
}

FullyQualifiedDomainName__List_template& FullyQualifiedDomainName__List_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @GTPC_Types.FullyQualifiedDomainName_List.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @GTPC_Types.FullyQualifiedDomainName_List.");
return value_list.list_value[list_index];
}

void FullyQualifiedDomainName__List_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void FullyQualifiedDomainName__List_template::log_match(const FullyQualifiedDomainName__List& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void FullyQualifiedDomainName__List_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.FullyQualifiedDomainName_List.");
}
}

void FullyQualifiedDomainName__List_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @GTPC_Types.FullyQualifiedDomainName_List.");
single_value.value_elements = (FullyQualifiedDomainName_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new FullyQualifiedDomainName_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new FullyQualifiedDomainName__List_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @GTPC_Types.FullyQualifiedDomainName_List.");
}
}

boolean FullyQualifiedDomainName__List_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean FullyQualifiedDomainName__List_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void FullyQualifiedDomainName__List_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void FullyQualifiedDomainName__List_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    FullyQualifiedDomainName__List_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    FullyQualifiedDomainName__List_template* precondition = new FullyQualifiedDomainName__List_template;
    precondition->set_param(*param.get_elem(0));
    FullyQualifiedDomainName__List_template* implied_template = new FullyQualifiedDomainName__List_template;
    implied_template->set_param(*param.get_elem(1));
    *this = FullyQualifiedDomainName__List_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@GTPC_Types.FullyQualifiedDomainName_List");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void FullyQualifiedDomainName__List_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.FullyQualifiedDomainName_List");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.FullyQualifiedDomainName_List");
}

boolean FullyQualifiedDomainName__List_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
FullyQualifiedDomainName::FullyQualifiedDomainName()
{
}

FullyQualifiedDomainName::FullyQualifiedDomainName(const OCTETSTRING& par_type__gtpc,
    const INTEGER& par_lengthf,
    const OCTETSTRING& par_fQDN__Value)
  :   field_type__gtpc(par_type__gtpc),
  field_lengthf(par_lengthf),
  field_fQDN__Value(par_fQDN__Value)
{
}

FullyQualifiedDomainName::FullyQualifiedDomainName(const FullyQualifiedDomainName& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.FullyQualifiedDomainName.");
if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
else field_type__gtpc.clean_up();
if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
else field_lengthf.clean_up();
if (other_value.fQDN__Value().is_bound()) field_fQDN__Value = other_value.fQDN__Value();
else field_fQDN__Value.clean_up();
}

void FullyQualifiedDomainName::clean_up()
{
field_type__gtpc.clean_up();
field_lengthf.clean_up();
field_fQDN__Value.clean_up();
}

const TTCN_Typedescriptor_t* FullyQualifiedDomainName::get_descriptor() const { return &FullyQualifiedDomainName_descr_; }
FullyQualifiedDomainName& FullyQualifiedDomainName::operator=(const FullyQualifiedDomainName& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.FullyQualifiedDomainName.");
  if (other_value.type__gtpc().is_bound()) field_type__gtpc = other_value.type__gtpc();
  else field_type__gtpc.clean_up();
  if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
  else field_lengthf.clean_up();
  if (other_value.fQDN__Value().is_bound()) field_fQDN__Value = other_value.fQDN__Value();
  else field_fQDN__Value.clean_up();
}
return *this;
}

boolean FullyQualifiedDomainName::operator==(const FullyQualifiedDomainName& other_value) const
{
return field_type__gtpc==other_value.field_type__gtpc
  && field_lengthf==other_value.field_lengthf
  && field_fQDN__Value==other_value.field_fQDN__Value;
}

boolean FullyQualifiedDomainName::is_bound() const
{
return (field_type__gtpc.is_bound())
  || (field_lengthf.is_bound())
  || (field_fQDN__Value.is_bound());
}
boolean FullyQualifiedDomainName::is_value() const
{
return field_type__gtpc.is_value()
  && field_lengthf.is_value()
  && field_fQDN__Value.is_value();
}
void FullyQualifiedDomainName::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ type_gtpc := ");
field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
field_lengthf.log();
TTCN_Logger::log_event_str(", fQDN_Value := ");
field_fQDN__Value.log();
TTCN_Logger::log_event_str(" }");
}

void FullyQualifiedDomainName::set_implicit_omit()
{
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (fQDN__Value().is_bound()) fQDN__Value().set_implicit_omit();
}

void FullyQualifiedDomainName::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @GTPC_Types.FullyQualifiedDomainName has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) fQDN__Value().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "fQDN_Value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          fQDN__Value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.FullyQualifiedDomainName: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.FullyQualifiedDomainName");
  }
}

void FullyQualifiedDomainName::encode_text(Text_Buf& text_buf) const
{
field_type__gtpc.encode_text(text_buf);
field_lengthf.encode_text(text_buf);
field_fQDN__Value.encode_text(text_buf);
}

void FullyQualifiedDomainName::decode_text(Text_Buf& text_buf)
{
field_type__gtpc.decode_text(text_buf);
field_lengthf.decode_text(text_buf);
field_fQDN__Value.decode_text(text_buf);
}

void FullyQualifiedDomainName::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void FullyQualifiedDomainName::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int FullyQualifiedDomainName::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_type__gtpc.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, FullyQualifiedDomainName_lengthf_descr_.raw->forceomit);
  decoded_field_length = field_lengthf.RAW_decode(FullyQualifiedDomainName_lengthf_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthf.convert_to_Integer(FullyQualifiedDomainName_lengthf_descr_);
  field_lengthf = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_fQDN__Value.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_type__gtpc !=  os_71) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int FullyQualifiedDomainName::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, FullyQualifiedDomainName_lengthf_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, OCTETSTRING_descr_.raw);
  encoded_length += field_type__gtpc.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &FullyQualifiedDomainName_lengthf_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 16;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_fQDN__Value.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[2]);
  if (field_type__gtpc !=  os_71) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_71.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct FullyQualifiedDomainName_template::single_value_struct {
OCTETSTRING_template field_type__gtpc;
INTEGER_template field_lengthf;
OCTETSTRING_template field_fQDN__Value;
};

void FullyQualifiedDomainName_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_type__gtpc = ANY_VALUE;
single_value->field_lengthf = ANY_VALUE;
single_value->field_fQDN__Value = ANY_VALUE;
}
}
}

void FullyQualifiedDomainName_template::copy_value(const FullyQualifiedDomainName& other_value)
{
single_value = new single_value_struct;
if (other_value.type__gtpc().is_bound()) {
  single_value->field_type__gtpc = other_value.type__gtpc();
} else {
  single_value->field_type__gtpc.clean_up();
}
if (other_value.lengthf().is_bound()) {
  single_value->field_lengthf = other_value.lengthf();
} else {
  single_value->field_lengthf.clean_up();
}
if (other_value.fQDN__Value().is_bound()) {
  single_value->field_fQDN__Value = other_value.fQDN__Value();
} else {
  single_value->field_fQDN__Value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void FullyQualifiedDomainName_template::copy_template(const FullyQualifiedDomainName_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.type__gtpc().get_selection()) {
single_value->field_type__gtpc = other_value.type__gtpc();
} else {
single_value->field_type__gtpc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthf().get_selection()) {
single_value->field_lengthf = other_value.lengthf();
} else {
single_value->field_lengthf.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.fQDN__Value().get_selection()) {
single_value->field_fQDN__Value = other_value.fQDN__Value();
} else {
single_value->field_fQDN__Value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new FullyQualifiedDomainName_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new FullyQualifiedDomainName_template(*other_value.implication_.precondition);
implication_.implied_template = new FullyQualifiedDomainName_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.FullyQualifiedDomainName.");
break;
}
set_selection(other_value);
}

FullyQualifiedDomainName_template::FullyQualifiedDomainName_template()
{
}

FullyQualifiedDomainName_template::FullyQualifiedDomainName_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

FullyQualifiedDomainName_template::FullyQualifiedDomainName_template(const FullyQualifiedDomainName& other_value)
{
copy_value(other_value);
}

FullyQualifiedDomainName_template::FullyQualifiedDomainName_template(const OPTIONAL<FullyQualifiedDomainName>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const FullyQualifiedDomainName&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.FullyQualifiedDomainName from an unbound optional field.");
}
}

FullyQualifiedDomainName_template::FullyQualifiedDomainName_template(FullyQualifiedDomainName_template* p_precondition, FullyQualifiedDomainName_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

FullyQualifiedDomainName_template::FullyQualifiedDomainName_template(Dynamic_Match_Interface<FullyQualifiedDomainName>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<FullyQualifiedDomainName>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

FullyQualifiedDomainName_template::FullyQualifiedDomainName_template(const FullyQualifiedDomainName_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

FullyQualifiedDomainName_template::~FullyQualifiedDomainName_template()
{
clean_up();
}

FullyQualifiedDomainName_template& FullyQualifiedDomainName_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

FullyQualifiedDomainName_template& FullyQualifiedDomainName_template::operator=(const FullyQualifiedDomainName& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

FullyQualifiedDomainName_template& FullyQualifiedDomainName_template::operator=(const OPTIONAL<FullyQualifiedDomainName>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const FullyQualifiedDomainName&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.FullyQualifiedDomainName.");
}
return *this;
}

FullyQualifiedDomainName_template& FullyQualifiedDomainName_template::operator=(const FullyQualifiedDomainName_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean FullyQualifiedDomainName_template::match(const FullyQualifiedDomainName& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.type__gtpc().is_bound()) return FALSE;
if(!single_value->field_type__gtpc.match(other_value.type__gtpc(), legacy))return FALSE;
if(!other_value.lengthf().is_bound()) return FALSE;
if(!single_value->field_lengthf.match(other_value.lengthf(), legacy))return FALSE;
if(!other_value.fQDN__Value().is_bound()) return FALSE;
if(!single_value->field_fQDN__Value.match(other_value.fQDN__Value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.FullyQualifiedDomainName.");
}
return FALSE;
}

boolean FullyQualifiedDomainName_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_type__gtpc.is_bound()
 || single_value->field_lengthf.is_bound()
 || single_value->field_fQDN__Value.is_bound();
}

boolean FullyQualifiedDomainName_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_type__gtpc.is_value()
 && single_value->field_lengthf.is_value()
 && single_value->field_fQDN__Value.is_value();
}

void FullyQualifiedDomainName_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

FullyQualifiedDomainName FullyQualifiedDomainName_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.FullyQualifiedDomainName.");
FullyQualifiedDomainName ret_val;
if (single_value->field_type__gtpc.is_bound()) {
ret_val.type__gtpc() = single_value->field_type__gtpc.valueof();
}
if (single_value->field_lengthf.is_bound()) {
ret_val.lengthf() = single_value->field_lengthf.valueof();
}
if (single_value->field_fQDN__Value.is_bound()) {
ret_val.fQDN__Value() = single_value->field_fQDN__Value.valueof();
}
return ret_val;
}

void FullyQualifiedDomainName_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.FullyQualifiedDomainName.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new FullyQualifiedDomainName_template[list_length];
}

FullyQualifiedDomainName_template& FullyQualifiedDomainName_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.FullyQualifiedDomainName.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.FullyQualifiedDomainName.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& FullyQualifiedDomainName_template::type__gtpc()
{
set_specific();
return single_value->field_type__gtpc;
}

const OCTETSTRING_template& FullyQualifiedDomainName_template::type__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field type_gtpc of a non-specific template of type @GTPC_Types.FullyQualifiedDomainName.");
return single_value->field_type__gtpc;
}

INTEGER_template& FullyQualifiedDomainName_template::lengthf()
{
set_specific();
return single_value->field_lengthf;
}

const INTEGER_template& FullyQualifiedDomainName_template::lengthf() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthf of a non-specific template of type @GTPC_Types.FullyQualifiedDomainName.");
return single_value->field_lengthf;
}

OCTETSTRING_template& FullyQualifiedDomainName_template::fQDN__Value()
{
set_specific();
return single_value->field_fQDN__Value;
}

const OCTETSTRING_template& FullyQualifiedDomainName_template::fQDN__Value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field fQDN_Value of a non-specific template of type @GTPC_Types.FullyQualifiedDomainName.");
return single_value->field_fQDN__Value;
}

int FullyQualifiedDomainName_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.FullyQualifiedDomainName containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.FullyQualifiedDomainName.");
  }
  return 0;
}

void FullyQualifiedDomainName_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log();
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log();
TTCN_Logger::log_event_str(", fQDN_Value := ");
single_value->field_fQDN__Value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void FullyQualifiedDomainName_template::log_match(const FullyQualifiedDomainName& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_type__gtpc.match(match_value.type__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".type_gtpc");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthf.match(match_value.lengthf(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthf");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_fQDN__Value.match(match_value.fQDN__Value(), legacy)){
TTCN_Logger::log_logmatch_info(".fQDN_Value");
single_value->field_fQDN__Value.log_match(match_value.fQDN__Value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ type_gtpc := ");
single_value->field_type__gtpc.log_match(match_value.type__gtpc(), legacy);
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::log_event_str(", fQDN_Value := ");
single_value->field_fQDN__Value.log_match(match_value.fQDN__Value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void FullyQualifiedDomainName_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (type__gtpc().is_bound()) type__gtpc().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (fQDN__Value().is_bound()) fQDN__Value().set_implicit_omit();
}

void FullyQualifiedDomainName_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_type__gtpc.encode_text(text_buf);
single_value->field_lengthf.encode_text(text_buf);
single_value->field_fQDN__Value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.FullyQualifiedDomainName.");
}
}

void FullyQualifiedDomainName_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_type__gtpc.decode_text(text_buf);
single_value->field_lengthf.decode_text(text_buf);
single_value->field_fQDN__Value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new FullyQualifiedDomainName_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.FullyQualifiedDomainName.");
}
}

void FullyQualifiedDomainName_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    FullyQualifiedDomainName_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @GTPC_Types.FullyQualifiedDomainName has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) type__gtpc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) fQDN__Value().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "type_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          type__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++