/*!
 * \file      NAS_EncDec.cc
 * \brief     CC file for NAS encode/decode functions.
 * \author    ETSI TTF041
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */

#include "NAS_EncdecDeclarations.hh"
#include "NAS_CommonTypeDefs.hh" 
//#include "SMS_TypeDefs.hh" 

namespace NAS__EncdecDeclarations {

  /****************************************************
   * @desc    External function to encode a ... type
   * @param   value to encode
   * @return  encoded value
   ****************************************************/

  BITSTRING fx__enc__PacketFilterComponent(const NAS__CommonTypeDefs::PacketFilterComponent &p){return int2bit(0,0);}
  BITSTRING fx__enc__QoSParametersList(const NAS__CommonTypeDefs::QoSParametersList &p){return int2bit(0,0);}
  BITSTRING fx__enc__EPS__QualityOfService(const NAS__CommonTypeDefs::EPS__QualityOfService &p){return int2bit(0,0);}
  BITSTRING fx__enc__TrafficFlowTemplate(const NAS__CommonTypeDefs::TrafficFlowTemplate &p){return int2bit(0,0);}
 // BITSTRING fx__enc__CP__PDU__Type(const SMS__TypeDefs::CP__PDU__Type &p){return int2bit(0,0);}

  /****************************************************
   * @desc    External function to decode a ... type
   * @param   value to encode
   * @return  encoded value
   ****************************************************/
  INTEGER fx__dec__PacketFilterComponent (BITSTRING &b, NAS__CommonTypeDefs::PacketFilterComponent &p) {return -1;}
  INTEGER fx__dec__QoSParametersList (BITSTRING &b, NAS__CommonTypeDefs::QoSParametersList &p) {return -1;}
  INTEGER fx__dec__EPS__QualityOfService (BITSTRING &b, NAS__CommonTypeDefs::EPS__QualityOfService &p) {return -1;}
  INTEGER fx__dec__TrafficFlowTemplate (BITSTRING &b, NAS__CommonTypeDefs::TrafficFlowTemplate &p) {return -1;}
 // INTEGER fx__dec__CP__PDU__Type (BITSTRING &b, SMS__TypeDefs::CP__PDU__Type &p) {return -1;}


} // namespace NAS__EncdecDeclarations



