/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.ExnHandler;
import com.sun.javacard.offcardverifier.InstrLookupSwitch;
import com.sun.javacard.offcardverifier.InstrTableSwitch;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.VerifierError;

public class Instr {
    public int opcode;
    public int arg;
    public int arg2;
    public int arg3;
    public ExnHandler handler;
    public static final int NOP = 0;
    public static final int ACONST_NULL = 1;
    public static final int SCONST_M1 = 2;
    public static final int SCONST_0 = 3;
    public static final int SCONST_1 = 4;
    public static final int SCONST_2 = 5;
    public static final int SCONST_3 = 6;
    public static final int SCONST_4 = 7;
    public static final int SCONST_5 = 8;
    public static final int ICONST_M1 = 9;
    public static final int ICONST_0 = 10;
    public static final int ICONST_1 = 11;
    public static final int ICONST_2 = 12;
    public static final int ICONST_3 = 13;
    public static final int ICONST_4 = 14;
    public static final int ICONST_5 = 15;
    public static final int BSPUSH = 16;
    public static final int SSPUSH = 17;
    public static final int BIPUSH = 18;
    public static final int SIPUSH = 19;
    public static final int IIPUSH = 20;
    public static final int ALOAD = 21;
    public static final int SLOAD = 22;
    public static final int ILOAD = 23;
    public static final int ALOAD_0 = 24;
    public static final int ALOAD_1 = 25;
    public static final int ALOAD_2 = 26;
    public static final int ALOAD_3 = 27;
    public static final int SLOAD_0 = 28;
    public static final int SLOAD_1 = 29;
    public static final int SLOAD_2 = 30;
    public static final int SLOAD_3 = 31;
    public static final int ILOAD_0 = 32;
    public static final int ILOAD_1 = 33;
    public static final int ILOAD_2 = 34;
    public static final int ILOAD_3 = 35;
    public static final int AALOAD = 36;
    public static final int BALOAD = 37;
    public static final int SALOAD = 38;
    public static final int IALOAD = 39;
    public static final int ASTORE = 40;
    public static final int SSTORE = 41;
    public static final int ISTORE = 42;
    public static final int ASTORE_0 = 43;
    public static final int ASTORE_1 = 44;
    public static final int ASTORE_2 = 45;
    public static final int ASTORE_3 = 46;
    public static final int SSTORE_0 = 47;
    public static final int SSTORE_1 = 48;
    public static final int SSTORE_2 = 49;
    public static final int SSTORE_3 = 50;
    public static final int ISTORE_0 = 51;
    public static final int ISTORE_1 = 52;
    public static final int ISTORE_2 = 53;
    public static final int ISTORE_3 = 54;
    public static final int AASTORE = 55;
    public static final int BASTORE = 56;
    public static final int SASTORE = 57;
    public static final int IASTORE = 58;
    public static final int POP = 59;
    public static final int POP2 = 60;
    public static final int DUP = 61;
    public static final int DUP2 = 62;
    public static final int DUP_X = 63;
    public static final int SWAP_X = 64;
    public static final int SADD = 65;
    public static final int IADD = 66;
    public static final int SSUB = 67;
    public static final int ISUB = 68;
    public static final int SMUL = 69;
    public static final int IMUL = 70;
    public static final int SDIV = 71;
    public static final int IDIV = 72;
    public static final int SREM = 73;
    public static final int IREM = 74;
    public static final int SNEG = 75;
    public static final int INEG = 76;
    public static final int SSHL = 77;
    public static final int ISHL = 78;
    public static final int SSHR = 79;
    public static final int ISHR = 80;
    public static final int SUSHR = 81;
    public static final int IUSHR = 82;
    public static final int SAND = 83;
    public static final int IAND = 84;
    public static final int SOR = 85;
    public static final int IOR = 86;
    public static final int SXOR = 87;
    public static final int IXOR = 88;
    public static final int SINC = 89;
    public static final int IINC = 90;
    public static final int S2B = 91;
    public static final int S2I = 92;
    public static final int I2B = 93;
    public static final int I2S = 94;
    public static final int ICMP = 95;
    public static final int IFEQ = 96;
    public static final int IFNE = 97;
    public static final int IFLT = 98;
    public static final int IFGE = 99;
    public static final int IFGT = 100;
    public static final int IFLE = 101;
    public static final int IFNULL = 102;
    public static final int IFNONNULL = 103;
    public static final int IF_ACMPEQ = 104;
    public static final int IF_ACMPNE = 105;
    public static final int IF_SCMPEQ = 106;
    public static final int IF_SCMPNE = 107;
    public static final int IF_SCMPLT = 108;
    public static final int IF_SCMPGE = 109;
    public static final int IF_SCMPGT = 110;
    public static final int IF_SCMPLE = 111;
    public static final int GOTO = 112;
    public static final int JSR = 113;
    public static final int RET = 114;
    public static final int STABLESWITCH = 115;
    public static final int ITABLESWITCH = 116;
    public static final int SLOOKUPSWITCH = 117;
    public static final int ILOOKUPSWITCH = 118;
    public static final int ARETURN = 119;
    public static final int SRETURN = 120;
    public static final int IRETURN = 121;
    public static final int RETURN = 122;
    public static final int GETSTATIC_A = 123;
    public static final int GETSTATIC_B = 124;
    public static final int GETSTATIC_S = 125;
    public static final int GETSTATIC_I = 126;
    public static final int PUTSTATIC_A = 127;
    public static final int PUTSTATIC_B = 128;
    public static final int PUTSTATIC_S = 129;
    public static final int PUTSTATIC_I = 130;
    public static final int GETFIELD_A = 131;
    public static final int GETFIELD_B = 132;
    public static final int GETFIELD_S = 133;
    public static final int GETFIELD_I = 134;
    public static final int PUTFIELD_A = 135;
    public static final int PUTFIELD_B = 136;
    public static final int PUTFIELD_S = 137;
    public static final int PUTFIELD_I = 138;
    public static final int INVOKEVIRTUAL = 139;
    public static final int INVOKESPECIAL = 140;
    public static final int INVOKESTATIC = 141;
    public static final int INVOKEINTERFACE = 142;
    public static final int NEW = 143;
    public static final int NEWARRAY = 144;
    public static final int ANEWARRAY = 145;
    public static final int ARRAYLENGTH = 146;
    public static final int ATHROW = 147;
    public static final int CHECKCAST = 148;
    public static final int INSTANCEOF = 149;
    public static final int SINC_W = 150;
    public static final int IINC_W = 151;
    public static final int IFEQ_W = 152;
    public static final int IFNE_W = 153;
    public static final int IFLT_W = 154;
    public static final int IFGE_W = 155;
    public static final int IFGT_W = 156;
    public static final int IFLE_W = 157;
    public static final int IFNULL_W = 158;
    public static final int IFNONNULL_W = 159;
    public static final int IF_ACMPEQ_W = 160;
    public static final int IF_ACMPNE_W = 161;
    public static final int IF_SCMPEQ_W = 162;
    public static final int IF_SCMPNE_W = 163;
    public static final int IF_SCMPLT_W = 164;
    public static final int IF_SCMPGE_W = 165;
    public static final int IF_SCMPGT_W = 166;
    public static final int IF_SCMPLE_W = 167;
    public static final int GOTO_W = 168;
    public static final int GETFIELD_A_W = 169;
    public static final int GETFIELD_B_W = 170;
    public static final int GETFIELD_S_W = 171;
    public static final int GETFIELD_I_W = 172;
    public static final int GETFIELD_A_THIS = 173;
    public static final int GETFIELD_B_THIS = 174;
    public static final int GETFIELD_S_THIS = 175;
    public static final int GETFIELD_I_THIS = 176;
    public static final int PUTFIELD_A_W = 177;
    public static final int PUTFIELD_B_W = 178;
    public static final int PUTFIELD_S_W = 179;
    public static final int PUTFIELD_I_W = 180;
    public static final int PUTFIELD_A_THIS = 181;
    public static final int PUTFIELD_B_THIS = 182;
    public static final int PUTFIELD_S_THIS = 183;
    public static final int PUTFIELD_I_THIS = 184;
    public static final int LAST_VALID_OPCODE = 184;
    public static final int T_BOOLEAN = 10;
    public static final int T_BYTE = 11;
    public static final int T_SHORT = 12;
    public static final int T_INT = 13;
    public static final int T_REFERENCE = 14;
    public static final String[] instrName = new String[]{"nop", "aconst_null", "sconst_m1", "sconst_0", "sconst_1", "sconst_2", "sconst_3", "sconst_4", "sconst_5", "iconst_m1", "iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4", "iconst_5", "bspush", "sspush", "bipush", "sipush", "iipush", "aload", "sload", "iload", "aload_0", "aload_1", "aload_2", "aload_3", "sload_0", "sload_1", "sload_2", "sload_3", "iload_0", "iload_1", "iload_2", "iload_3", "aaload", "baload", "saload", "iaload", "astore", "sstore", "istore", "astore_0", "astore_1", "astore_2", "astore_3", "sstore_0", "sstore_1", "sstore_2", "sstore_3", "istore_0", "istore_1", "istore_2", "istore_3", "aastore", "bastore", "sastore", "iastore", "pop", "pop2", "dup", "dup2", "dup_x", "swap_x", "sadd", "iadd", "ssub", "isub", "smul", "imul", "sdiv", "idiv", "srem", "irem", "sneg", "ineg", "sshl", "ishl", "sshr", "ishr", "sushr", "iushr", "sand", "iand", "sor", "ior", "sxor", "ixor", "sinc", "iinc", "s2b", "s2i", "i2b", "i2s", "icmp", "ifeq", "ifne", "iflt", "ifge", "ifgt", "ifle", "ifnull", "ifnonnull", "if_acmpeq", "if_acmpne", "if_scmpeq", "if_scmpne", "if_scmplt", "if_scmpge", "if_scmpgt", "if_scmple", "goto", "jsr", "ret", "stableswitch", "itableswitch", "slookupswitch", "ilookupswitch", "areturn", "sreturn", "ireturn", "return", "getstatic_a", "getstatic_b", "getstatic_s", "getstatic_i", "putstatic_a", "putstatic_b", "putstatic_s", "putstatic_i", "getfield_a", "getfield_b", "getfield_s", "getfield_i", "putfield_a", "putfield_b", "putfield_s", "putfield_i", "invokevirtual", "invokespecial", "invokestatic", "invokeinterface", "new", "newarray", "anewarray", "arraylength", "athrow", "checkcast", "instanceof", "sinc_w", "iinc_w", "ifeq_w", "ifne_w", "iflt_w", "ifge_w", "ifgt_w", "ifle_w", "ifnull_w", "ifnonnull_w", "if_acmpeq_w", "if_acmpne_w", "if_scmpeq_w", "if_scmpne_w", "if_scmplt_w", "if_scmpge_w", "if_scmpgt_w", "if_scmple_w", "goto_w", "getfield_a_w", "getfield_b_w", "getfield_s_w", "getfield_i_w", "getfield_a_this", "getfield_b_this", "getfield_s_this", "getfield_i_this", "putfield_a_w", "putfield_b_w", "putfield_s_w", "putfield_i_w", "putfield_a_this", "putfield_b_this", "putfield_s_this", "putfield_i_this"};
    public static final byte[] instrLength = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 3, 5, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 0, 0, 0, 0, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 5, 3, 2, 3, 1, 1, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 3, 3, 3, 3, 2, 2, 2, 2};
    public static final boolean[] instrInt = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, false, false, true, true, true, false, false, true, false, false, false, false, false, false, false, false, true, true, true, true, false, false, false, true, false, false, true, false, false, false, false, false, false, false, false, true, true, true, true, false, false, false, true, false, false, false, false, false, false, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, true, false, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true};

    public Instr(int n) {
        this.opcode = n;
    }

    public Instr(int n, int n2) {
        this.opcode = n;
        this.arg = n2;
    }

    public Instr(int n, int n2, int n3) {
        this.opcode = n;
        this.arg = n2;
        this.arg2 = n3;
    }

    public Instr(int n, int n2, int n3, int n4) {
        this.opcode = n;
        this.arg = n2;
        this.arg2 = n3;
        this.arg3 = n4;
    }

    public static Instr instrAt(Safeptr safeptr) {
        int n = safeptr.u1(0);
        switch (n) {
            case 21: 
            case 22: 
            case 23: 
            case 40: 
            case 41: 
            case 42: 
            case 114: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 144: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                return new Instr(n, safeptr.u1(1));
            }
            case 16: 
            case 18: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                return new Instr(n, safeptr.s1(1));
            }
            case 63: 
            case 64: {
                return new Instr(n, safeptr.u1(1) >> 4, safeptr.u1(1) & 0xF);
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 145: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 177: 
            case 178: 
            case 179: 
            case 180: {
                return new Instr(n, safeptr.u2(1));
            }
            case 17: 
            case 19: 
            case 113: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                return new Instr(n, safeptr.s2(1));
            }
            case 20: {
                return new Instr(n, safeptr.s4(1));
            }
            case 148: 
            case 149: {
                return new Instr(n, safeptr.u1(1), safeptr.u2(2));
            }
            case 142: {
                return new Instr(n, safeptr.u2(2), safeptr.u1(4), safeptr.u1(1));
            }
            case 89: 
            case 90: {
                return new Instr(n, safeptr.u1(1), safeptr.s1(2));
            }
            case 150: 
            case 151: {
                return new Instr(n, safeptr.u1(1), safeptr.s2(2));
            }
            case 117: {
                InstrLookupSwitch instrLookupSwitch = new InstrLookupSwitch(n);
                instrLookupSwitch.dfl = safeptr.s2(1);
                instrLookupSwitch.ncases = safeptr.u2(3);
                instrLookupSwitch.keys = new int[instrLookupSwitch.ncases];
                instrLookupSwitch.offsets = new int[instrLookupSwitch.ncases];
                for (int i = 0; i < instrLookupSwitch.ncases; ++i) {
                    instrLookupSwitch.keys[i] = safeptr.s2(5 + i * 4);
                    instrLookupSwitch.offsets[i] = safeptr.s2(7 + i * 4);
                }
                return instrLookupSwitch;
            }
            case 118: {
                InstrLookupSwitch instrLookupSwitch = new InstrLookupSwitch(n);
                instrLookupSwitch.dfl = safeptr.s2(1);
                instrLookupSwitch.ncases = safeptr.u2(3);
                instrLookupSwitch.keys = new int[instrLookupSwitch.ncases];
                instrLookupSwitch.offsets = new int[instrLookupSwitch.ncases];
                for (int i = 0; i < instrLookupSwitch.ncases; ++i) {
                    instrLookupSwitch.keys[i] = safeptr.s4(5 + i * 6);
                    instrLookupSwitch.offsets[i] = safeptr.s2(9 + i * 6);
                }
                return instrLookupSwitch;
            }
            case 115: {
                InstrTableSwitch instrTableSwitch = new InstrTableSwitch(n);
                instrTableSwitch.dfl = safeptr.s2(1);
                instrTableSwitch.low = safeptr.s2(3);
                instrTableSwitch.high = safeptr.s2(5);
                if (instrTableSwitch.low > instrTableSwitch.high) {
                    throw new VerifierError("Instr.1", safeptr);
                }
                instrTableSwitch.offsets = new int[instrTableSwitch.high - instrTableSwitch.low + 1];
                for (int i = instrTableSwitch.low; i <= instrTableSwitch.high; ++i) {
                    int n2 = i - instrTableSwitch.low;
                    instrTableSwitch.offsets[n2] = safeptr.s2(7 + n2 * 2);
                }
                return instrTableSwitch;
            }
            case 116: {
                InstrTableSwitch instrTableSwitch = new InstrTableSwitch(n);
                instrTableSwitch.dfl = safeptr.s2(1);
                instrTableSwitch.low = safeptr.s4(3);
                instrTableSwitch.high = safeptr.s4(7);
                if (instrTableSwitch.low > instrTableSwitch.high) {
                    throw new VerifierError("Instr.2", safeptr);
                }
                instrTableSwitch.offsets = new int[instrTableSwitch.high - instrTableSwitch.low + 1];
                for (int i = instrTableSwitch.low; i <= instrTableSwitch.high; ++i) {
                    int n3 = i - instrTableSwitch.low;
                    instrTableSwitch.offsets[n3] = safeptr.s2(11 + n3 * 2);
                }
                return instrTableSwitch;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new Instr(n, n - 24);
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return new Instr(n, n - 28);
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                return new Instr(n, n - 32);
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return new Instr(n, n - 43);
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return new Instr(n, n - 47);
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new Instr(n, n - 51);
            }
        }
        if (n > 184) {
            throw new VerifierError("Instr.3", n, (Object)safeptr);
        }
        return new Instr(n);
    }

    public int length() {
        return instrLength[this.opcode];
    }

    public boolean isBackwardBranch() {
        switch (this.opcode) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                return this.arg < 0;
            }
            case 114: {
                return true;
            }
        }
        return false;
    }

    public static Instr[] instrsBetween(Safeptr safeptr, int n) throws VerifierError {
        int n2;
        Instr instr;
        Instr[] instrArray = new Instr[n];
        for (n2 = 0; n2 < n; n2 += instr.length()) {
            instrArray[n2] = instr = Instr.instrAt(safeptr.offset(n2));
        }
        if (n2 > n) {
            throw new VerifierError("Instr.4", safeptr);
        }
        return instrArray;
    }

    public static int getInstrLength(int n) {
        return instrLength[n];
    }
}

