/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.util;

import com.sun.javacard.converter.ConverterException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class Strings {
    protected static ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/converter/MessagesBundle");

    public static final String toHexString(byte value) {
        return "0x" + Integer.toHexString(value & 0xFF).toUpperCase();
    }

    public static final String toHexString(short value) {
        String hexString = Integer.toHexString(value & 0xFFFF).toUpperCase();
        int addNumZeros = 4 - hexString.length();
        StringBuffer sb = new StringBuffer();
        while (addNumZeros != 0) {
            sb.append("0");
        }
        sb.append(hexString);
        return sb.toString();
    }

    public static final String toHexString(int value) {
        String hexString = Long.toHexString(value & 0xFFFFFFFF).toUpperCase();
        int addNumZeros = 8 - hexString.length();
        StringBuffer sb = new StringBuffer();
        while (addNumZeros != 0) {
            sb.append("0");
            --addNumZeros;
        }
        sb.append(hexString);
        return sb.toString();
    }

    public static final String toHexString(byte[] value, String delimiter) {
        StringBuffer sb = new StringBuffer();
        sb.append(Strings.toHexString(value[0]));
        int i = 1;
        while (i < value.length) {
            sb.append(delimiter);
            sb.append(Strings.toHexString(value[i]));
            ++i;
        }
        return sb.toString();
    }

    public static byte[] toByteArray(String string, String delimiter) throws Exception {
        String[] strings = Strings.toStrings(string, delimiter);
        byte[] bytes = new byte[strings.length];
        int i = 0;
        while (i < strings.length) {
            bytes[i] = Integer.decode(strings[i]).byteValue();
            if (Integer.decode(strings[i]) > 255) {
                throw new ConverterException(messages.getString("other.2"));
            }
            ++i;
        }
        return bytes;
    }

    public static String[] toStrings(String string, String delimiter) {
        StringTokenizer parser = new StringTokenizer(string, delimiter);
        int num_token = parser.countTokens();
        String[] strings = new String[num_token];
        int count = 0;
        while (parser.hasMoreTokens()) {
            strings[count++] = parser.nextToken();
        }
        return strings;
    }

    public static final short computeShortHash(String s) {
        int hash = 0;
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA");
            byte[] value = s.getBytes("UTF-8");
            byte[] hasharray = sha.digest(value);
            hash = hasharray.length >= 2 ? (int)((short)(hasharray[0] << 8 | hasharray[1] & 0xFF)) : -1;
        }
        catch (IOException ignore) {
            hash = -1;
        }
        catch (NoSuchAlgorithmException complain) {
            throw new SecurityException(complain.getMessage());
        }
        return (short)hash;
    }
}

