/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

public class EfClass
extends ClassDefinition {
    public static final short ACC_SHAREABLE = 2048;
    public static final short ACC_REMOTE = 4096;
    private int name_index;
    private int[] super_class_indexes;
    private String[] super_class_names;
    private int[] interface_indexes;
    private String[] interface_names;
    private EfField[] fields;
    private EfMethod[] methods;
    private EfConstantPool constant_pool;

    public EfClass(EfConstantPool cp) {
        this.constant_pool = cp;
    }

    public EfClass(ClassDefinition a_class, boolean shareable_flag, String[] super_class_names, String[] interface_names, EfConstantPool constant_pool, EfField[] fields, EfMethod[] methods) {
        super(a_class);
        this.access_flags &= 0xFFFFFFDF;
        if (shareable_flag) {
            this.access_flags |= 0x800;
        }
        if (a_class.isRemote()) {
            this.access_flags |= 0x1000;
        }
        if (Modifier.isInterface(this.access_flags)) {
            this.access_flags |= 0x400;
        }
        this.constant_pool = constant_pool;
        this.name_index = constant_pool.addConstantClassRef(this.class_name);
        this.super_class_names = super_class_names;
        this.super_class_indexes = new int[super_class_names.length];
        int i = 0;
        while (i < super_class_names.length) {
            this.super_class_indexes[i] = constant_pool.addConstantClassRef(super_class_names[i]);
            ++i;
        }
        this.interface_names = interface_names;
        this.interface_indexes = new int[interface_names.length];
        int i2 = 0;
        while (i2 < interface_names.length) {
            this.interface_indexes[i2] = constant_pool.addConstantClassRef(interface_names[i2]);
            ++i2;
        }
        this.fields = fields;
        this.methods = methods;
    }

    public boolean isShareableType() {
        return (this.access_flags & 0x800) != 0;
    }

    public void parse(DataInputStream dis) throws IOException {
        this.token = dis.readUnsignedByte();
        this.access_flags = dis.readShort();
        this.name_index = dis.readUnsignedShort();
        this.super_class_indexes = new int[dis.readUnsignedShort()];
        int i = 0;
        while (i < this.super_class_indexes.length) {
            this.super_class_indexes[i] = dis.readUnsignedShort();
            ++i;
        }
        this.interface_indexes = new int[dis.readUnsignedByte()];
        int i2 = 0;
        while (i2 < this.interface_indexes.length) {
            this.interface_indexes[i2] = dis.readUnsignedShort();
            ++i2;
        }
        this.fields = new EfField[dis.readUnsignedShort()];
        int i3 = 0;
        while (i3 < this.fields.length) {
            this.fields[i3] = new EfField(this.constant_pool);
            this.fields[i3].parse(dis);
            ++i3;
        }
        this.methods = new EfMethod[dis.readUnsignedShort()];
        int i4 = 0;
        while (i4 < this.methods.length) {
            this.methods[i4] = new EfMethod(this.constant_pool);
            this.methods[i4].parse(dis);
            ++i4;
        }
    }

    public void resolve() {
        this.class_name = this.constant_pool.getConstantClassRef(this.name_index).getClassName();
        this.super_class_names = new String[this.super_class_indexes.length];
        int i = 0;
        while (i < this.super_class_indexes.length) {
            this.super_class_names[i] = this.constant_pool.getConstantClassRef(this.super_class_indexes[i]).getClassName();
            ++i;
        }
        this.interface_names = new String[this.interface_indexes.length];
        int i2 = 0;
        while (i2 < this.interface_indexes.length) {
            this.interface_names[i2] = this.constant_pool.getConstantClassRef(this.interface_indexes[i2]).getClassName();
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.fields.length) {
            this.fields[i3].resolve();
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.methods.length) {
            this.methods[i4].resolve();
            ++i4;
        }
        if (this.isInterfaceType() && !this.isAbstract()) {
            Object[] args = new Object[]{this.getClassName().replace('/', '.')};
            Notifier.warning("flags.1", args);
            this.setAbstract(true);
        }
    }

    public void toText(PrintWriter pw, int tab_level) throws IOException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tab_level) {
            sb.append("\t");
            ++i;
        }
        String indent = sb.toString();
        pw.println(indent + "class_info {" + "\t\t// " + this.class_name);
        pw.println(indent + "\ttoken\t" + this.token);
        boolean shareable = (this.access_flags & 0x800) != 0;
        boolean remote = (this.access_flags & 0x1000) != 0;
        int tmp_access_flags = this.access_flags & 0xFFFFF7FF & 0xFFFFEFFF;
        pw.print(indent + "\taccess_flags\t" + Modifier.toString(tmp_access_flags));
        if (shareable) {
            pw.print(" shareable");
        }
        if (remote) {
            pw.println(" remote");
        } else {
            pw.println();
        }
        pw.println(indent + "\tname_index\t" + this.name_index + "\t\t// " + this.class_name);
        pw.println(indent + "\texport_supers_count\t" + this.super_class_indexes.length);
        pw.println(indent + "\tsupers {");
        int i2 = 0;
        while (i2 < this.super_class_indexes.length) {
            pw.println(indent + "\t\tconstant_pool_index\t" + this.super_class_indexes[i2] + "\t\t// " + this.super_class_names[i2]);
            ++i2;
        }
        pw.println(indent + "\t}");
        pw.println(indent + "\texport_interfaces_count\t" + this.interface_indexes.length);
        pw.println(indent + "\tinterfaces {");
        int i3 = 0;
        while (i3 < this.interface_indexes.length) {
            pw.println(indent + "\t\tconstant_pool_index\t" + this.interface_indexes[i3] + "\t\t// " + this.interface_names[i3]);
            ++i3;
        }
        pw.println(indent + "\t}");
        pw.println(indent + "\texport_fields_count\t" + this.fields.length);
        pw.println(indent + "\tfields {");
        int i4 = 0;
        while (i4 < this.fields.length) {
            this.fields[i4].toText(pw, tab_level + 1);
            ++i4;
        }
        pw.println(indent + "\t}");
        pw.println(indent + "\texport_methods_count\t" + this.methods.length);
        pw.println(indent + "\tmethods {");
        int i5 = 0;
        while (i5 < this.methods.length) {
            this.methods[i5].toText(pw, tab_level + 2);
            ++i5;
        }
        pw.println(indent + "\t}");
        pw.println(indent + "}");
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeByte(this.token);
        dos.writeShort(this.access_flags);
        dos.writeShort(this.name_index);
        dos.writeShort(this.super_class_indexes.length);
        int i = 0;
        while (i < this.super_class_indexes.length) {
            dos.writeShort(this.super_class_indexes[i]);
            ++i;
        }
        dos.writeByte(this.interface_indexes.length);
        int i2 = 0;
        while (i2 < this.interface_indexes.length) {
            dos.writeShort(this.interface_indexes[i2]);
            ++i2;
        }
        dos.writeShort(this.fields.length);
        int i3 = 0;
        while (i3 < this.fields.length) {
            this.fields[i3].toBinary(dos);
            ++i3;
        }
        dos.writeShort(this.methods.length);
        int i4 = 0;
        while (i4 < this.methods.length) {
            this.methods[i4].toBinary(dos);
            ++i4;
        }
        dos.flush();
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public int[] getSuperClasses() {
        return this.super_class_indexes;
    }

    public String[] getSuperClassNames() {
        return this.super_class_names;
    }

    public int[] getInterfaces() {
        return this.interface_indexes;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public EfMethod getMethod(String name, String descriptor) {
        int i = 0;
        while (i < this.methods.length) {
            if (this.methods[i].getMethodName().equals(name) && this.methods[i].getMethodDescriptor().equals(descriptor)) {
                return this.methods[i];
            }
            ++i;
        }
        return null;
    }

    public EfMethod getMethod(int token) {
        int i = 0;
        while (i < this.methods.length) {
            if (this.methods[i].getMethodToken() == token) {
                return this.methods[i];
            }
            ++i;
        }
        return null;
    }

    public EfMethod[] getMethods() {
        return this.methods;
    }

    public EfField getField(String name, String descriptor) {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].getFieldName().equals(name) && this.fields[i].getFieldDescriptor().equals(descriptor)) {
                return this.fields[i];
            }
            ++i;
        }
        return null;
    }

    public EfField[] getFields() {
        return this.fields;
    }

    public boolean hasReferenceAPIField() {
        if (this.getFields().length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.getFields().length) {
            EfField efField = this.getFields()[i];
            if (efField.isReferenceType()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void printFields() {
        System.out.println("\n Fields of " + this.getClassName() + " (in exp file)");
        int i = 0;
        while (i < this.fields.length) {
            EfField f = this.fields[i];
            String s = "" + i + " " + f.getFieldToken() + " " + (f.isPublic() ? "public" : "") + " " + (f.isProtected() ? "protected" : "") + " " + (f.isStatic() ? "static" : "") + " " + (f.isFinal() ? "final" : "") + " " + f.getFieldDescriptor() + " " + f.getFieldName();
            System.out.println(s);
            ++i;
        }
    }

    public void printMethods() {
        System.out.println("\n Methods of " + this.getClassName() + " (in exp file)");
        int i = 0;
        while (i < this.methods.length) {
            EfMethod f = this.methods[i];
            String s = "" + i + " " + f.getMethodToken() + " " + (f.isPublic() ? "public" : "") + " " + (f.isProtected() ? "protected" : "") + " " + (f.isStatic() ? "static" : "") + " " + (f.isFinal() ? "final" : "") + " " + (f.isAbstract() ? "abstract" : "") + " " + f.getMethodDescriptor() + " " + f.getMethodName();
            System.out.println(s);
            ++i;
        }
    }

    public boolean isRemote() {
        return (this.access_flags & 0x1000) != 0;
    }
}

