/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.debugcomponent.LineInfo;
import com.sun.javacard.debugcomponent.VariableInfo;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class MethodDebugInfo
extends MethodDefinition {
    private int name_index;
    private int descriptor_index;
    private int location;
    private int header_size;
    private int bytecode_size;
    private VariableInfo[] var_table;
    private LineInfo[] line_table;

    public MethodDebugInfo(JcMethod jc_method, DebugComponent debug_comp) {
        super(jc_method);
        this.build(jc_method, debug_comp);
    }

    private void build(JcMethod jc_method, DebugComponent debug_comp) {
        JcInstruction jc_code;
        this.name_index = debug_comp.addString(this.method_name);
        this.descriptor_index = debug_comp.addString(this.descriptor);
        this.header_size = 2;
        if (jc_method.getMaxStack() > 15) {
            this.header_size = 4;
        }
        if (jc_method.getNargs() > 15) {
            this.header_size = 4;
        }
        if (jc_method.getMaxLocals() > 15) {
            this.header_size = 4;
        }
        if (jc_method.isAbstract()) {
            this.header_size = 0;
        }
        for (jc_code = jc_method.getCode(); jc_code != null; jc_code = jc_code.getNextInstr()) {
            this.bytecode_size += jc_code.getSizeInBytes();
        }
        JcLocalVariable[] local_vars = jc_method.getLocalVariables();
        Vector<VariableInfo> var_vector = new Vector<VariableInfo>();
        JcLocalVariable[] arr$ = local_vars;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (JcLocalVariable this_local = arr$[i$]; this_local != null; this_local = this_local.getNext()) {
                var_vector.addElement(new VariableInfo(jc_method, this_local, debug_comp));
            }
        }
        this.var_table = new VariableInfo[var_vector.size()];
        var_vector.copyInto(this.var_table);
        jc_code = jc_method.getCode();
        Vector<LineInfo> line_vector = new Vector<LineInfo>(20, 10);
        while (jc_code != null) {
            JcInstruction start_instr = jc_code;
            JcInstruction end_instr = jc_code;
            int source_line = start_instr.getSourceLineNumber();
            while (jc_code != null) {
                end_instr = jc_code;
                if (jc_code.getSourceLineNumber() != source_line) break;
                jc_code = jc_code.getNextInstr();
            }
            int start_pc = start_instr.getPC();
            int end_pc = end_instr.getPC();
            end_pc = jc_code != null ? --end_pc : (end_pc += end_instr.getSizeInBytes() - 1);
            LineInfo line_info = new LineInfo(start_pc, end_pc, source_line);
            line_vector.addElement(line_info);
        }
        this.line_table = new LineInfo[line_vector.size()];
        line_vector.copyInto(this.line_table);
    }

    public int getSize() {
        int size = 0;
        for (VariableInfo variableInfo : this.var_table) {
            size += variableInfo.getSize();
        }
        for (LineInfo lineInfo : this.line_table) {
            size += lineInfo.getSize();
        }
        return size + 15;
    }

    public String toString(int tab_level) {
        StringBuffer tab_sb = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        tab_sb.append("\n");
        for (int i = 0; i < tab_level; ++i) {
            tab_sb.append("\t");
        }
        String indent = tab_sb.toString();
        sb.append(indent + "method_debug_info { ");
        sb.append(indent + "\tname_index " + this.name_index + "\t\t//" + this.method_name);
        sb.append(indent + "\tdescriptor_index " + this.descriptor_index + "\t\t//" + this.descriptor);
        sb.append(indent + "\taccess_flags " + Modifier.toString(this.access_flags));
        sb.append(indent + "\tlocation " + this.location);
        sb.append(indent + "\theader_size " + this.header_size);
        sb.append(indent + "\tbytecode_size " + this.bytecode_size);
        sb.append(indent + "\tvariable_count " + this.var_table.length);
        sb.append(indent + "\tline_count " + this.line_table.length);
        for (VariableInfo variableInfo : this.var_table) {
            sb.append(variableInfo.toString(tab_level + 1));
        }
        for (LineInfo lineInfo : this.line_table) {
            sb.append(lineInfo.toString(tab_level + 1));
        }
        sb.append(indent + "}");
        return sb.toString();
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeShort(this.name_index);
        dos.writeShort(this.descriptor_index);
        dos.writeShort(this.access_flags);
        dos.writeShort(this.location);
        dos.writeByte(this.header_size);
        dos.writeShort(this.bytecode_size);
        dos.writeShort(this.var_table.length);
        dos.writeShort(this.line_table.length);
        for (VariableInfo variableInfo : this.var_table) {
            variableInfo.toBinary(dos);
        }
        for (LineInfo lineInfo : this.line_table) {
            lineInfo.toBinary(dos);
        }
        dos.flush();
    }
}

