/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Globals;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class Msg {
    protected static final ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/jcasm/MessagesBundle");
    public static final String eol = System.getProperty("line.separator", "\n");
    protected static PrintStream out = System.out;
    protected static PrintStream err = System.err;

    public static void error(Exception e) {
        ++Globals.errors;
        err.print(String.valueOf(messages.getString("Msg.error")) + " ");
        err.println(e.getMessage());
    }

    public static void error(String msg) {
        ++Globals.errors;
        err.print(String.valueOf(messages.getString("Msg.error")) + " ");
        err.println(msg);
    }

    public static void error(String key, Object[] args) {
        ++Globals.errors;
        err.print(String.valueOf(messages.getString("Msg.error")) + " ");
        err.println(MessageFormat.format(messages.getString(key), args));
    }

    public static String getMessage(String key) {
        return messages.getString(key);
    }

    public static String getMessage(String key, Object[] args) {
        return MessageFormat.format(messages.getString(key), args);
    }

    public static void info(String msg) {
        out.println(msg);
    }

    public static void info(String key, Object[] args) {
        out.println(MessageFormat.format(messages.getString(key), args));
    }

    public void setErr(PrintStream newErr) {
        err = newErr;
    }

    public void setOut(PrintStream newOut) {
        out = newOut;
    }

    public static String toHexString(byte value) {
        int nvalue = value & 0xFF;
        if (nvalue > 15) {
            return "0x" + Integer.toHexString(nvalue);
        }
        return "0x0" + Integer.toHexString(nvalue);
    }

    public static String toHexString(int value) {
        if (value < 0) {
            return "0x" + Integer.toHexString(value);
        }
        if (value > 0xFFFFFF) {
            return "0x0" + Integer.toHexString(value);
        }
        if (value > 1048575) {
            return "0x00" + Integer.toHexString(value);
        }
        if (value > 65535) {
            return "0x000" + Integer.toHexString(value);
        }
        if (value > 4095) {
            return "0x0000" + Integer.toHexString(value);
        }
        if (value > 255) {
            return "0x00000" + Integer.toHexString(value);
        }
        if (value > 15) {
            return "0x000000" + Integer.toHexString(value);
        }
        return "0x0000000" + Integer.toHexString(value);
    }

    public static String toHexString(short value) {
        int nvalue = value & 0xFFFF;
        if (nvalue > 4095) {
            return "0x" + Integer.toHexString(nvalue);
        }
        if (nvalue > 255) {
            return "0x0" + Integer.toHexString(nvalue);
        }
        if (nvalue > 15) {
            return "0x00" + Integer.toHexString(nvalue);
        }
        return "0x000" + Integer.toHexString(nvalue);
    }

    public static String toHexString(byte[] array) {
        return Msg.toHexString(array, ":");
    }

    public static String toHexString(byte[] array, String delimiter) {
        if (array == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            sb.append(String.valueOf(Msg.toHexString(array[i])) + delimiter);
            ++i;
        }
        sb.setLength(sb.length() - delimiter.length());
        return sb.toString();
    }

    public static void warn(String msg) {
        ++Globals.warnings;
        err.print(String.valueOf(messages.getString("Msg.warning")) + " ");
        err.println(msg);
    }

    public static void warn(String key, Object[] args) {
        ++Globals.warnings;
        err.print(String.valueOf(messages.getString("Msg.warning")) + " ");
        err.println(MessageFormat.format(messages.getString(key), args));
    }
}

