/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask.jrefmask;

import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.mask.jrefmask.MemoryMap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class CardMemory {
    byte isVirginMask;
    MemoryMap memoryConfig;
    private ByteArrayOutputStream ROMBos;
    private ByteArrayOutputStream E2Bos;
    private DataOutputStream ROMDos;
    private DataOutputStream E2Dos;

    public CardMemory(int romSize) {
        this.memoryConfig = new MemoryMap(romSize);
        this.isVirginMask = (byte)-1;
        this.ROMBos = new ByteArrayOutputStream();
        this.ROMDos = new DataOutputStream(this.ROMBos);
        this.E2Bos = new ByteArrayOutputStream();
        this.E2Dos = new DataOutputStream(this.E2Bos);
    }

    void addToE2(byte[] array) {
        try {
            if (this.E2Dos.size() + array.length > this.memoryConfig.getE2Size()) {
                Msg.error("jref.5", null);
                System.exit(1);
            }
            this.E2Dos.write(array, 0, array.length);
            this.E2Dos.flush();
            this.memoryConfig.setNextE2Address((short)this.E2Bos.size());
        }
        catch (IOException e) {
            Msg.error("jref.2", null);
            e.printStackTrace();
            System.exit(1);
        }
    }

    void addToRom(byte[] array) {
        try {
            if (this.ROMDos.size() + array.length > this.memoryConfig.getROMSize()) {
                Msg.error("jref.4", null);
                System.exit(1);
            }
            this.ROMDos.write(array, 0, array.length);
            this.ROMDos.flush();
        }
        catch (IOException e) {
            Msg.error("jref.2", null);
            e.printStackTrace();
            System.exit(1);
        }
    }

    int getE2Base() {
        return this.memoryConfig.getROMSize();
    }

    public short getNextE2Address() {
        return (short)this.E2Bos.size();
    }

    public short getNextRomAddr() {
        return (short)this.ROMBos.size();
    }

    public void write(DataOutputStream os) throws IOException {
        os.writeByte(this.isVirginMask);
        this.memoryConfig.write(os);
        os.writeShort(this.ROMBos.size());
        os.write(this.ROMBos.toByteArray());
        os.writeShort(this.E2Bos.size());
        os.write(this.E2Bos.toByteArray());
        this.ROMDos.close();
        this.ROMBos.close();
        this.E2Dos.close();
        this.E2Bos.close();
    }
}

