/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.events.Kind;
import com.oracle.javacard.jcdebugproxy.events.OnCardEvent;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.VMClassPool;
import com.sun.javacard.debugproxy.types.Location;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class EventFilter {
    public static final byte STEP_MIN = 0;
    public static final byte STEP_LINE = 1;
    public static final byte STEP_INTO = 0;
    public static final byte STEP_OVER = 1;
    public static final byte STEP_OUT = 2;
    private Kind kind;
    public State state = State.Disabled;
    private byte suspendPolicy;
    private EventModifier[] modifiers = new EventModifier[11];
    private int id = -1;
    private ArrayList<FilterEntry> entries = new ArrayList();

    public byte getSuspendPolicy() {
        return this.suspendPolicy;
    }

    public void setSuspendPolicy(byte suspendPolicy) {
        this.suspendPolicy = suspendPolicy;
    }

    public void addModifier(EventModifier current) {
        this.modifiers[current.type] = current;
    }

    public EventModifier getModifier(int type) {
        return this.modifiers[type];
    }

    public void addException(VMClassPool pool, DataInputStream in) throws IOException {
        ExceptionModifier current = new ExceptionModifier(pool);
        current.read((byte)8, in);
        this.entries.add(current);
        this.addModifier(current);
    }

    void addInstanceFilter(int readInt) {
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void addStatic(final boolean value) {
        this.entries.add(new FilterEntryImpl("(" + value + ")"){

            @Override
            public boolean filter(OnCardEvent event) {
                return value;
            }
        });
    }

    public void addThreadFilter(final int threadID) {
        this.entries.add(new FilterEntryImpl("(thread " + Integer.toHexString(threadID) + ")"){

            @Override
            public boolean filter(OnCardEvent event) {
                return event.threadID == threadID;
            }
        });
    }

    public void addClassMatch(String regExp) {
        this.entries.add(this.createClassMatcher(regExp));
    }

    public void addClassExclude(String regExp) {
        final FilterEntry match = this.createClassMatcher(regExp);
        this.entries.add(new FilterEntryImpl("(not " + match + ")"){

            @Override
            public boolean filter(OnCardEvent event) {
                return !match.filter(event);
            }
        });
    }

    static String getClassName(OnCardEvent event) {
        String name = "";
        if (event.clInfo != null) {
            name = event.clInfo.getClassName();
        } else if (event.location != null) {
            name = event.location.cl.getClassName();
        }
        return name == null ? "" : name;
    }

    FilterEntry createClassMatcher(final String regExp) {
        if (regExp.startsWith("*")) {
            final String suffix = regExp.substring(1);
            return new FilterEntryImpl("(class-match \"" + regExp + "\")"){

                @Override
                public boolean filter(OnCardEvent event) {
                    return EventFilter.getClassName(event).endsWith(suffix);
                }
            };
        }
        if (regExp.endsWith("*")) {
            final String prefix = regExp.substring(0, regExp.length() - 1);
            return new FilterEntryImpl("(class-match \"" + regExp + "\")"){

                @Override
                public boolean filter(OnCardEvent event) {
                    return EventFilter.getClassName(event).startsWith(prefix);
                }
            };
        }
        return new FilterEntryImpl("(class-equal \"" + regExp + "\")"){

            @Override
            public boolean filter(OnCardEvent event) {
                return EventFilter.getClassName(event).equals(regExp);
            }
        };
    }

    public boolean hasCountModifier() {
        return this.modifiers[1] != null;
    }

    public boolean filter(OnCardEvent event) {
        for (FilterEntry e : this.entries) {
            if (e.filter(event)) continue;
            return false;
        }
        return true;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    public String toString() {
        StringBuilder out = new StringBuilder("((id=0x");
        out.append(Integer.toHexString(this.id));
        out.append(" kind=").append((Object)this.kind).append(" suspend_policy=").append(this.suspendPolicy).append(")");
        for (FilterEntry e : this.entries) {
            out.append(' ').append(e.toString());
        }
        out.append(")");
        return out.toString();
    }

    static interface FilterEntry {
        public boolean filter(OnCardEvent var1);
    }

    public static abstract class FilterEntryImpl
    implements FilterEntry {
        private String toString;

        public FilterEntryImpl(String toString) {
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }
    }

    public static class LocationModifier
    extends EventModifier {
        public Location location = new Location();

        @Override
        public void read(byte type, DataInputStream in) throws IOException {
            this.type = type;
            this.location.read(in);
        }

        @Override
        public void write(DataOutputStream out) throws IOException {
            this.location.write(out);
        }
    }

    public static class StepModifier
    extends EventModifier {
        int size;
        int depth;

        @Override
        public void read(byte type, DataInputStream in) throws IOException {
            this.type = type;
            if (in.readInt() == -1) {
                throw new IOException("Read failed");
            }
            this.size = in.readInt();
            this.depth = in.readInt();
        }

        public void writeForVM(DataOutputStream out, int until) throws IOException {
            if ((until & 0xFF000000) != 0) {
                this.size = 1;
                this.depth = 2;
            }
            out.write((byte)this.size);
            out.write((byte)this.depth);
            out.write((byte)(until >> 16));
            out.writeShort((short)until);
        }
    }

    public static class ExceptionModifier
    extends EventModifier
    implements FilterEntry {
        public int exceptionOrNull;
        public boolean reportCaught;
        public boolean reportUncaught;
        private VMClassPool pool;

        public ExceptionModifier(VMClassPool pool) {
            this.pool = pool;
            this.type = (byte)8;
        }

        @Override
        public void read(byte type, DataInputStream in) throws IOException {
            super.read(type, in);
            this.exceptionOrNull = in.readInt();
            this.reportCaught = in.readBoolean();
            this.reportUncaught = in.readBoolean();
        }

        @Override
        public void write(DataOutputStream ps) throws IOException {
            super.write(ps);
        }

        @Override
        public boolean filter(OnCardEvent event) {
            if (this.reportCaught && event.catchLocation != null || this.reportUncaught && event.catchLocation == null) {
                return this.checkType(event.exceptionType);
            }
            return false;
        }

        private boolean checkType(ClassDebugInfo info) {
            if (info == null) {
                return true;
            }
            if (this.exceptionOrNull == 0 || info.getClassID() == this.exceptionOrNull) {
                return true;
            }
            String parent = info.getSuperClass();
            if (parent == null || this.pool == null) {
                return false;
            }
            ClassDebugInfo cl = this.pool.getClassBySignature(VMClassPool.getJNISignature(parent));
            return cl != null && this.checkType(cl);
        }
    }

    static class CountModifier
    extends EventModifier {
        private int count;
        private int reached;

        CountModifier() {
        }

        @Override
        public void read(byte type, DataInputStream in) throws IOException {
            this.type = type;
            this.reached = this.count = in.readInt();
        }

        public void resetCount() {
            this.reached = this.count;
        }

        public boolean skipEventAndResumeVM() {
            return this.reached != 0;
        }

        public void decrementCount() {
            if (this.reached > -1) {
                --this.reached;
            }
        }
    }

    public static class EventModifier {
        byte type;

        public void read(byte type, DataInputStream in) throws IOException {
            this.type = type;
        }

        public void write(DataOutputStream ps) throws IOException {
        }
    }

    public static enum State {
        Disabled,
        EnablingInProcess,
        Enabled,
        DisablingInProcess;

    }
}

