/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.events.EventFilter;
import com.oracle.javacard.jcdebugproxy.events.Kind;
import com.oracle.javacard.jcdebugproxy.events.OnCardEvent;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.types.Location;
import com.sun.javacard.debugproxy.types.PacketElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

class JDWPEvent
implements PacketElement {
    private int requestId;
    private OnCardEvent event;
    private Kind kind;

    public JDWPEvent(OnCardEvent event, EventFilter filter) {
        this(event, filter.getKind(), filter.getID());
    }

    public JDWPEvent(OnCardEvent event, Kind kind, int requestId) {
        this.event = event;
        this.kind = kind;
        this.requestId = requestId;
    }

    @Override
    public void read(DataInputStream in) throws IOException {
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        Log.LOG(4, "JDWPEvent to IDE - requestId: " + this.requestId);
        out.writeByte(this.kind.code());
        out.writeInt(this.requestId);
        out.writeInt(-31);
        this.event.location.write(out);
        switch (this.kind) {
            case Exception: {
                out.writeByte(76);
                out.writeInt(this.event.exceptionInstance);
                if (this.event.catchLocation != null) {
                    this.event.catchLocation.write(out);
                    break;
                }
                new Location().write(out);
                break;
            }
            default: {
                Log.LOG(4, "Unknown kind");
            }
        }
    }

    public static Collection<JDWPEvent> convertEvent(OnCardEvent event, Map<Integer, EventFilter> filters) {
        return JDWPEvent.convertEvent(event, filters, new ArrayList<JDWPEvent>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<JDWPEvent> convertEvent(OnCardEvent event, Map<Integer, EventFilter> filters, Collection<JDWPEvent> out) {
        Map<Integer, EventFilter> map = filters;
        synchronized (map) {
            for (EventFilter filter : filters.values()) {
                if (!filter.filter(event)) continue;
                out.add(new JDWPEvent(event, filter));
            }
        }
        return out;
    }
}

