/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classic.InvalidRequestException;
import com.sun.javacard.debugproxy.classic.handlers.ClassInfoPacketHandler;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.LocalVariable;
import com.sun.javacard.debugproxy.classparser.MethodDebugInfo;
import com.sun.javacard.debugproxy.comm.EncodingUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.List;

public class MethodConverters {
    static void registerMethodConverters(ClassicProxyProtocol proxy) {
        proxy.addConverter(6, 1, new ClassInfoPacketHandler("line table"){

            @Override
            public void handleClass(DataInputStream fromIde, DataOutputStream toIdePacket, int cid, ClassDebugInfo classFile) throws Exception {
                int mid = fromIde.readInt();
                Log.LOGN(4, "linetable: class id= " + Integer.toHexString(cid) + ", method id= " + Integer.toHexString(mid));
                MethodDebugInfo mi = classFile.getMethodInfoByIndex(mid);
                if (mi == null) {
                    Log.LOGN(1, "Couldn't find methodinfo for index " + mid);
                    throw new InvalidRequestException(23);
                }
                long endingOffset = mi.getCodeAttributeLength();
                long startingOffset = endingOffset >= 0L ? 0L : (endingOffset = -1L);
                Object codes = mi.getBreakableLineNumbers();
                if (codes == null) {
                    Log.LOGN(1, "No linenumber table found for class " + classFile.getClassName());
                    codes = new int[0][];
                }
                toIdePacket.writeLong(startingOffset);
                toIdePacket.writeLong(endingOffset);
                Log.LOGN(5, "Starting code offset = " + startingOffset + ", Ending code offset = " + endingOffset);
                Log.LOGN(5, "Code Length = " + ((int[][])codes).length);
                toIdePacket.writeInt(((int[][])codes).length);
                for (int[] line : codes) {
                    toIdePacket.writeLong(line[1]);
                    toIdePacket.writeInt(line[0]);
                    Log.LOGN(5, "  index=" + line[1] + " l#=" + line[0]);
                }
            }
        });
        proxy.addConverter(6, 2, new ClassInfoPacketHandler("Variable table"){

            @Override
            public void handleClass(DataInputStream fromIde, DataOutputStream toIdePacket, int cid, ClassDebugInfo classFile) throws Exception {
                int mid = fromIde.readInt();
                Log.LOGN(3, "variable: method id = " + Integer.toHexString(mid));
                List<LocalVariable> table = classFile.getMethodInfoByIndex(mid).getLocalVariables();
                MethodDebugInfo mi = classFile.getMethodInfoByIndex(mid);
                if (mi == null) {
                    throw new InvalidRequestException(20, "couldn't find method info for class " + classFile.getClassName());
                }
                toIdePacket.writeInt(mi.getArgCount());
                if (table != null) {
                    toIdePacket.writeInt(table.size());
                    for (LocalVariable var : table) {
                        toIdePacket.writeLong(var.getCodeIndex());
                        EncodingUtils.writeString(toIdePacket, var.getName());
                        EncodingUtils.writeString(toIdePacket, var.getType());
                        toIdePacket.writeInt(var.getLength());
                        toIdePacket.writeInt(var.getSlot());
                    }
                } else {
                    toIdePacket.writeInt(0);
                }
            }
        });
    }
}

