/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic.handlers;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.InvalidRequestException;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public abstract class ClassInfoPacketHandler
extends ClassicPacketHandlerImpl {
    public static final String RESPONSE_KEY = "class-processing-result";
    private String name;

    public ClassInfoPacketHandler() {
        this("ClassInfoPacketHandler");
    }

    public ClassInfoPacketHandler(String name) {
        super(VMPacketHandler.CommandCode.NONE);
        this.name = name + " cmd";
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleRequest(HandlerState state, DataOutputStream toVm) throws Exception {
        int cid = state.in.readInt();
        try {
            ClassDebugInfo classFile = this.proxy.state().classes().getClassByID(cid);
            Log.LOGN(3, this.name + ": class id = " + Integer.toHexString(cid) + " -> " + classFile);
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            DataOutputStream toIde = new DataOutputStream(buff);
            if (classFile != null) {
                this.handleClass(state.in, toIde, cid, classFile);
            } else if (!this.processNullClass(state.in, toIde, cid)) {
                throw new InvalidRequestException(20);
            }
            toIde.flush();
            state.args.put(RESPONSE_KEY, buff.toByteArray());
            return ClassicPacketHandler.DeliveryType.NONE;
        }
        catch (InvalidRequestException e) {
            throw e;
        }
        catch (Exception e) {
            Log.LOGN(1, this.name + ": exception " + e);
            throw new InvalidRequestException(20, (Throwable)e);
        }
    }

    @Override
    public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
        byte[] data = (byte[])state.args.get(RESPONSE_KEY);
        if (data != null) {
            state.out.write(data, 0, data.length);
        }
    }

    public boolean processNullClass(DataInputStream fromIde, DataOutputStream toIde, int cid) throws Exception {
        Log.LOGN(1, "Couldn't get ClassFile object for " + this.name);
        return false;
    }

    public abstract void handleClass(DataInputStream var1, DataOutputStream var2, int var3, ClassDebugInfo var4) throws Exception;
}

