/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.nbtasks.JCTask;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCToolTask
extends JCTask {
    public JCToolTask(String string) {
        super.setClassname(string);
    }

    public void execute() throws BuildException {
        super.setClasspath(new Path(this.getProject(), this.getProp("javacard.toolClassPath")));
        this.setFork(!Boolean.getBoolean("javacard.ant.unit.test"));
        this.createJvmarg().setValue("-Djc.home=" + this.getProp("javacard.home"));
        this.log("Execute\n" + this.getCommandLine(), 3);
        this.executeJava();
    }

    public final String getProjectProperty(String string) {
        return this.getProject().getProperty(string);
    }

    protected boolean getBool(String string) {
        String string2 = this.getProp(string, false);
        return string2 == null ? false : Boolean.valueOf(string2);
    }

    protected String getProp(String string) throws BuildException {
        return this.getProp(string, true);
    }

    protected String getProp(String string, boolean bl) throws BuildException {
        String string2 = this.getProject().getProperty(string);
        if (bl && string2 == null) {
            throw new BuildException(string + " not set");
        }
        return string2;
    }

    protected File getFileProp(String string) throws BuildException {
        return this.getFileProp(string, true);
    }

    protected File getFileProp(String string, boolean bl) throws BuildException {
        String string2 = this.getProp(string, bl);
        if (string2 != null) {
            string2 = string2.replace('/', File.separatorChar);
            File file = new File(string2);
            File[] fileArray = File.listRoots();
            boolean bl2 = false;
            if (file != null) {
                for (File file2 : fileArray) {
                    String string3;
                    if (string2.startsWith(file2.getAbsolutePath())) {
                        bl2 = true;
                        break;
                    }
                    File file3 = new File(file2.getAbsolutePath().toUpperCase());
                    if (!file3.exists() || !(string3 = string2.toUpperCase()).startsWith(file3.getAbsolutePath())) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                this.log("Resolved " + string + " as absolute file " + file);
                return file;
            }
            file = new File(this.getProject().getBaseDir(), string2);
            this.log("Resolved " + string + " as relative file " + file);
            return file;
        }
        this.log("File prop " + string + " not set: " + string2);
        return null;
    }

    protected String getExportPath() throws BuildException {
        String string = this.getProp("export.path", false);
        string = string == null || string.trim().length() == 0 ? "" : string.trim();
        ArrayList<String> arrayList = new ArrayList<String>();
        Hashtable hashtable = this.getProject().getProperties();
        for (Object k : hashtable.keySet()) {
            String string2 = (String)k;
            if (!(string2 = string2.trim()).endsWith(".expfile")) continue;
            arrayList.add(string2);
        }
        Object object = this.getExportPathForExpFiles(arrayList);
        if (object != null && ((String)object).length() > 0) {
            if (string.length() > 0) {
                object = (String)object + File.pathSeparator + string;
            }
        } else {
            object = string.length() > 0 ? string : "";
        }
        return object;
    }

    private String getExportPathForExpFiles(ArrayList<String> arrayList) throws BuildException {
        String string = "";
        Hashtable hashtable = this.getProject().getProperties();
        for (String string2 : arrayList) {
            String string3;
            String string4 = string2.substring(0, string2.indexOf(".expfile")) + ".origin";
            if (string2.startsWith("dependency..")) {
                string3 = string2.replace("dependency..", "dependency.");
                string4 = string3.substring(0, string3.indexOf(".expfile")) + ".origin";
            }
            if ((string3 = (String)hashtable.get(string4)) == null) {
                throw new BuildException("Couldn't find CAP file corresponding to export file listed in dependencies");
            }
            String string5 = this.getPackagePath(string3);
            if (string5 == null) continue;
            String string6 = (String)hashtable.get(string2);
            int n = string6.indexOf(string5 + "/javacard/");
            String string7 = n >= 0 ? string6.substring(0, n) : string6;
            if (string.length() > 0) {
                string = string + File.pathSeparator;
            }
            this.log("Resolve export path for " + string2 + " to " + string7, 3);
            string = string + string7;
        }
        this.log("Computed export path as " + string, 3);
        return string;
    }

    private String getPackagePath(String string) throws BuildException {
        String string2 = null;
        ZipFile zipFile = null;
        try {
            zipFile = new JarFile(new File(this.getProject().getBaseDir(), string));
            if (zipFile == null) {
                throw new BuildException("Couldn't open file: " + string + " listed in dependencies");
            }
            Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string3 = jarEntry.getName();
                if (!string3.endsWith(".class")) continue;
                string2 = string3.contains("/") ? "/" + string3.substring(0, string3.lastIndexOf(47)) : "/";
                break;
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error while openinig file: " + string + " listed in dependencies");
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string2;
    }
}

