/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.debugcomponent.FieldDebugInfo;
import com.sun.javacard.debugcomponent.MethodDebugInfo;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcMethod;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;

public class ClassDebugInfo
extends ClassDefinition {
    private static final int ACC_SHAREABLE = 2048;
    private static final int ACC_REMOTE = 32;
    private int name_index;
    private int location;
    private int superclass_name_index;
    private int[] interface_names_index;
    private int source_file_name_index;
    FieldDebugInfo[] fields;
    MethodDebugInfo[] methods;

    public ClassDebugInfo(JcClass jc_class, DebugComponent debug_comp) {
        super(jc_class);
        this.build(jc_class, debug_comp);
    }

    private void build(JcClass jc_class, DebugComponent debug_comp) {
        this.name_index = debug_comp.addString(this.class_name);
        this.superclass_name_index = this.super_class_name == null ? debug_comp.addString("null") : debug_comp.addString(this.super_class_name);
        if (this.source_file_name == null) {
            throw new RuntimeException();
        }
        if (jc_class.isShareableType()) {
            this.access_flags |= 0x800;
        }
        if (jc_class.isRemote()) {
            this.access_flags |= 0x20;
        }
        this.source_file_name_index = debug_comp.addString(this.source_file_name);
        String[] interface_names = jc_class.getSuperInterfaces();
        this.interface_names_index = new int[interface_names.length];
        for (int i = 0; i < interface_names.length; ++i) {
            this.interface_names_index[i] = debug_comp.addString(interface_names[i]);
        }
        JcField[] jc_fields = jc_class.getFields();
        this.fields = new FieldDebugInfo[jc_fields.length];
        for (int i = 0; i < jc_fields.length; ++i) {
            this.fields[i] = new FieldDebugInfo(jc_fields[i], debug_comp);
        }
        JcMethod[] jc_methods = jc_class.getMethods();
        this.methods = new MethodDebugInfo[jc_methods.length];
        for (int i = 0; i < jc_methods.length; ++i) {
            this.methods[i] = new MethodDebugInfo(jc_methods[i], debug_comp);
        }
    }

    public int getSize() {
        int size = 0;
        for (FieldDebugInfo fieldDebugInfo : this.fields) {
            size += fieldDebugInfo.getSize();
        }
        for (MethodDebugInfo methodDebugInfo : this.methods) {
            size += methodDebugInfo.getSize();
        }
        return size + 15 + this.interface_names_index.length * 2;
    }

    public String toString(int tab_level) {
        StringBuffer tab_sb = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        tab_sb.append("\n");
        for (int i = 0; i < tab_level; ++i) {
            tab_sb.append("\t");
        }
        String indent = tab_sb.toString();
        sb.append(indent + "class_debug_info { ");
        sb.append(indent + "\tname_index " + this.name_index + "\t\t//" + this.class_name);
        if ((this.access_flags & 0x800) != 0) {
            sb.append(indent + "\taccess_flags " + Modifier.toString(this.access_flags & 0xFFFFF7FF));
            sb.append(" shareable");
        } else {
            sb.append(indent + "\taccess_flags " + Modifier.toString(this.access_flags));
        }
        sb.append(indent + "\tlocation " + this.location);
        sb.append(indent + "\tsuperclass_name_index " + this.superclass_name_index + "\t\t//" + this.super_class_name);
        sb.append(indent + "\tsource_file_name_index " + this.source_file_name_index + "\t\t//" + this.source_file_name);
        sb.append(indent + "\tinterface_count " + this.interface_names_index.length);
        sb.append(indent + "\tfield_count " + this.fields.length);
        sb.append(indent + "\tmethod_count " + this.methods.length);
        if (this.interface_names_index.length != 0) {
            sb.append(indent + "\tinterface_names_index ");
            for (int n : this.interface_names_index) {
                sb.append(n + " ");
            }
            sb.append("\n");
        }
        for (FieldDebugInfo fieldDebugInfo : this.fields) {
            sb.append(fieldDebugInfo.toString(tab_level + 1));
        }
        for (MethodDebugInfo methodDebugInfo : this.methods) {
            sb.append(methodDebugInfo.toString(tab_level + 1));
        }
        sb.append(indent + "}");
        return sb.toString();
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeShort(this.name_index);
        dos.writeShort(this.access_flags);
        dos.writeShort(this.location);
        dos.writeShort(this.superclass_name_index);
        dos.writeShort(this.source_file_name_index);
        dos.writeByte(this.interface_names_index.length);
        dos.writeShort(this.fields.length);
        dos.writeShort(this.methods.length);
        for (int element : this.interface_names_index) {
            dos.writeShort(element);
        }
        for (FieldDebugInfo element : this.fields) {
            element.toBinary(dos);
        }
        for (MethodDebugInfo element : this.methods) {
            element.toBinary(dos);
        }
        dos.flush();
    }
}

