/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.mask.AppletInfo;
import com.sun.javacard.jcasm.mask.ComponentLocInfo;
import com.sun.javacard.jcasm.mask.CrefOutputFormatter;
import com.sun.javacard.jcasm.mask.Main;
import com.sun.javacard.jcasm.mask.PackageTableManager;
import java.util.StringTokenizer;

class PackageTableEntry {
    int PACKAGE_LOCATION_INFORMATION_SIZE = Main.FLAG_32_BIT ? 24 : 16;
    JCPackage packageInfo;
    static final int importCount = 0;
    static final int importedPkgsArrayRef = 0;
    int pkgAID;
    int pkgMinor;
    int pkgMajor;
    int staticRefFieldCount;
    int appletCount;
    AppletInfo[] applets;
    int pkgNameLength;
    byte[] pkgName;
    ComponentLocInfo[] componentInfoReference;
    int comInfoTableAddress;
    int appletIndex = 0;
    int appTableRef = 0;
    int nameArrayRef = 0;

    PackageTableEntry(JCPackage p) {
        this.packageInfo = p;
        PackageIdentifier pid = p.getIdentifier();
        this.pkgMinor = pid.getMinorVersion();
        this.pkgMajor = pid.getMajorVersion();
        this.appletCount = p.appletCount();
        if (this.appletCount > 0) {
            this.applets = new AppletInfo[this.appletCount];
        }
        this.componentInfoReference = new ComponentLocInfo[4];
    }

    void setStaticRefFieldCount(int fieldCount) {
        this.staticRefFieldCount = fieldCount;
    }

    public static String[] getTokens(String str, String delim) {
        StringTokenizer st = new StringTokenizer(str, delim);
        String[] tokens = new String[st.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = st.nextToken().trim();
        }
        return tokens;
    }

    void setAppletInformation(AppletDeclarator applet) {
        String fullyQualifiedAppletClassName = this.packageInfo.getName() + "/" + applet.getName();
        byte[] appletAid = applet.getAid().toByteArray();
        JCMethod m = applet.resolve();
        int installMethodAddr = m.getRelocAddr();
        if (installMethodAddr > Short.MAX_VALUE) {
            installMethodAddr = CrefOutputFormatter.exportedRefManager.getExportedReference(m);
        }
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append("/* AID for Applet in package " + this.packageInfo.getName() + " */" + Msg.eol);
        int appletAIDRef = PackageTableManager.createAIDObject(appletAid, true);
        this.applets[this.appletIndex] = new AppletInfo(appletAIDRef, installMethodAddr);
        ++this.appletIndex;
    }

    void setPkgNameInfo(byte[] nameBytes) {
        this.pkgNameLength = nameBytes.length;
        this.pkgName = nameBytes;
    }

    void setPackageComponentLocation(int componentId, int componentLocation, int componentSize) {
        this.componentInfoReference[componentId] = new ComponentLocInfo(componentLocation, componentSize);
    }

    void addAppletInfoArrayToMask() {
        if (this.appletCount > 0) {
            byte[] appInfoObject = new byte[10 + this.appletCount * 2];
            int i = 0;
            int j = 0;
            while (i < this.appletCount) {
                int ref = this.applets[i].addToMask();
                appInfoObject[10 + j] = (byte)(ref >> 8);
                appInfoObject[10 + (j + 1)] = (byte)ref;
                ++i;
                j += 2;
            }
            PackageTableManager.createRefArrayObjectHeader(appInfoObject, this.appletCount, (byte)0, PackageTableManager.appletEntryClassOffset, PackageTableManager.appletEntryPkgId);
            int currentROMAddr = CrefOutputFormatter.cof.currentRomAddr;
            CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.eol + "/* Applet Table Information for " + this.packageInfo.getName() + "@" + Msg.toAddressString(currentROMAddr) + " */" + Msg.eol);
            for (int i2 = 0; i2 < appInfoObject.length; ++i2) {
                CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString(appInfoObject[i2]) + ", ");
                if (i2 % 12 != 11) continue;
                CrefOutputFormatter.cof.rom.append(Msg.eol);
            }
            this.appTableRef = CrefOutputFormatter.objectManager.addObject(currentROMAddr);
            CrefOutputFormatter.cof.currentRomAddr += appInfoObject.length;
        }
    }

    void addNameArrayToMask() {
        if (this.pkgNameLength > 0) {
            int currentROMAddr = CrefOutputFormatter.cof.currentRomAddr;
            byte[] nameArray = PackageTableManager.createByteArrayObject((short)this.pkgNameLength, this.pkgName, (byte)0, false);
            CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.eol + "/* Package name array object for " + this.packageInfo.getName() + "@" + Msg.toAddressString(currentROMAddr) + " */" + Msg.eol);
            for (int i = 0; i < nameArray.length; ++i) {
                CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString(nameArray[i]) + ", ");
                if (i % 12 != 11) continue;
                CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.eol);
            }
            this.nameArrayRef = CrefOutputFormatter.objectManager.addObject(currentROMAddr);
            CrefOutputFormatter.cof.currentRomAddr += nameArray.length;
        }
    }

    int addToMask() {
        this.addAppletInfoArrayToMask();
        this.addNameArrayToMask();
        int packageEntryRef = 0;
        byte[] packageEntryHeader = new byte[5];
        PackageTableManager.createSimpleObjectHeader(packageEntryHeader, PackageTableManager.packageEntryClassRef, (byte)0, false, PackageTableManager.pkgEntryPkgId);
        int currentROMAddr = CrefOutputFormatter.cof.currentRomAddr;
        int entrySize = 5;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.eol + "/* Package Table entry for " + this.packageInfo.getName() + "@" + Msg.toAddressString(currentROMAddr) + " */ " + Msg.eol);
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString(packageEntryHeader, ", ") + ",/*Header*/" + Msg.eol);
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)(this.pkgAID >> 8)) + " ,");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.pkgAID) + " , /*AID reference*/" + Msg.eol);
        entrySize += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)0) + " ,");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)0) + " , /*imported packages info*/" + Msg.eol);
        entrySize += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)(this.appTableRef >> 8)) + " , ");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.appTableRef) + " , /*applet table ref*/" + Msg.eol);
        entrySize += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)(this.nameArrayRef >> 8)) + " ,");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.nameArrayRef) + " , /*Package Name Object Ref*/" + Msg.eol);
        entrySize += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.pkgMinor) + ", " + "0x00, ");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.pkgMajor) + ", " + "0x00, " + " /*Minor and Major versions*/" + Msg.eol);
        entrySize += 4;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)(this.staticRefFieldCount >> 8)) + " ,");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.staticRefFieldCount) + " , /*Static ref field count*/" + Msg.eol);
        entrySize += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)0) + ", " + "0x00, " + " /*import count*/" + Msg.eol);
        entrySize += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.appletCount) + ", " + "0x00, " + "/*applet count*/" + Msg.eol);
        entrySize += 2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString((byte)this.pkgNameLength) + ", " + "0x00, " + "/*Package Name Length*/" + Msg.eol);
        packageEntryRef = CrefOutputFormatter.objectManager.addObject(CrefOutputFormatter.cof.currentRomAddr);
        CrefOutputFormatter.cof.currentRomAddr += (entrySize += 2);
        return packageEntryRef;
    }

    int addPackageLocInfoToMask(StringBuffer buffer, int memLoc) {
        this.comInfoTableAddress = memLoc;
        buffer.append("/* Component Location Structure for " + this.packageInfo.getName() + " @" + Msg.toAddressString(this.comInfoTableAddress) + " */" + Msg.eol);
        for (int i = 0; i < 4; ++i) {
            if (Main.FLAG_32_BIT) {
                buffer.append(Msg.to32BitHexString(this.componentInfoReference[i].compLocation));
            } else {
                buffer.append(Msg.to16BitHexString(this.componentInfoReference[i].compLocation));
            }
            buffer.append(Msg.to16BitHexString(this.componentInfoReference[i].compSize));
            buffer.append(Msg.eol);
        }
        return this.PACKAGE_LOCATION_INFORMATION_SIZE;
    }
}

