/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.File;

class VerifyExp {
    static int verbose = 1;
    static boolean printTrace = false;

    VerifyExp() {
    }

    public static void main(String[] argv) {
        int i;
        boolean banner = true;
        for (i = 0; i < argv.length && argv[i].length() > 0 && argv[i].charAt(0) == '-'; ++i) {
            String s = argv[i];
            if (s.equals("-verbose")) {
                ++verbose;
                continue;
            }
            if (s.equals("-nobanner")) {
                banner = false;
                continue;
            }
            if (s.equals("-nowarn")) {
                VerifierError.noWarn = true;
                continue;
            }
            if (s.equals("-help")) {
                VerifyExp.printUsageAndExit();
                continue;
            }
            if (s.equals("-version")) {
                Messages.println("MainExp.3");
                Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
                Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
                System.exit(2);
                continue;
            }
            VerifyExp.printUsageAndExit();
        }
        if (i + 1 != argv.length) {
            VerifyExp.printUsageAndExit();
        }
        if (verbose >= 1 && banner) {
            Messages.println("MainExp.3", ToolsVersion.getVersion(2));
        }
        Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
        String ef_name = argv[i];
        if (!ef_name.endsWith(".exp")) {
            VerifyExp.printUsageAndExit();
        }
        File ef_file = new File(ef_name);
        if (verbose >= 1) {
            Messages.println("MainExp.4", ef_name);
        }
        try {
            ExportFile ef = ExportFile.readFromFile(ef_file);
            ef.verify();
        }
        catch (VerifierError e) {
            Messages.printSevere("MainExp.2", Messages.numWarning, e.getMessage(), Messages.format("MainExp.6"));
            System.exit(2);
        }
        Messages.println("MainExp.5", Messages.numWarning);
    }

    private static void printUsageAndExit() {
        Messages.printTo(System.err);
        Messages.println("MainExp.1");
        System.exit(2);
    }
}

