/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl.jcrd;

import com.sun.javacard.cm.impl.jcrd.ClientRole;
import com.sun.javacard.cm.impl.jcrd.FormatErrorException;
import com.sun.javacard.cm.impl.jcrd.JCRuntimeDesc;
import com.sun.javacard.cm.impl.jcrd.UserRole;
import com.sun.javacard.cm.impl.jcrd.Util;
import com.sun.javacard.cm.registries.SecureCommunicationInfoRegistry;
import com.sun.javacard.jcre.Card;
import com.sun.javacard.util.APDUUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ModuleInfo {
    static final String CLIENT_URI_MAPPING_SUFFIX = "-mapped-to-client-uri";
    static final String CLIENT_PD_MAPPING_SUFFIX = "-mapped-to-domain-name";
    static final String CLIENT_AUTH_CREDENTIAL_MAPPING_SUFFIX = "-mapped-to-auth-credential";
    static final String CLIENT_CREDENTIAL_AUTH_TYPE_MAPPING_SUFFIX = "-credential-auth-type";
    static final String CLIENT_CREDENTIAL_AUTH_DURATION_MAPPING_SUFFIX = "-credential-auth-duration";
    static final String USER_AUTH_URI_MAPPING_SUFFIX = "-mapped-to-auth-uri";
    static final String CLIENT_URI_MAPPING_SUFFIX_CAP = "-Mapped-To-Client-URI";
    static final String CLIENT_PD_MAPPING_SUFFIX_CAP = "-Mapped-To-Domain-Name";
    static final String CLIENT_AUTH_CREDENTIAL_MAPPING_SUFFIX_CAP = "-Mapped-To-Auth-Credential";
    static final String CLIENT_CREDENTIAL_AUTH_TYPE_MAPPING_SUFFIX_CAP = "-Credential-Auth-Type";
    static final String CLIENT_CREDENTIAL_AUTH_DURATION_MAPPING_SUFFIX_CAP = "-Credential-Auth-Duration";
    static final String USER_AUTH_URI_MAPPING_SUFFIX_CAP = "-Mapped-To-Auth-URI";
    static final String[] CLIENT_MAPPING_ATTRIBUTES_LIST = new String[]{"-mapped-to-client-uri", "-mapped-to-domain-name", "-mapped-to-auth-credential", "-credential-auth-type", "-credential-auth-duration"};
    public static final String CARD_SESSION_DURATION = "card-session";
    public static final String CLIENT_LIFETIME_DURATION = "client-lifetime";
    public static final String ACCESS_DURATION = "access";
    static final int IANA_PORT_LOW = 49152;
    static final int IANA_PORT_HI = 65535;
    private String moduleName;
    private int webSecurePort = -1;
    private boolean webClientAuthRequired = false;
    private boolean webSecureAccessOnly = false;
    private boolean sealed = false;
    private Vector<String> unexposedSIOs;
    private Vector<ClientRole> onCardClientRoles;
    private String onCardClientsCredentialAuthType = "client-only";
    private String onCardClientsCredentialAuthDuration = "card-session";
    private Vector<UserRole> userRoles;
    byte appType;
    private Hashtable<String, String> moduleAttributes;

    public ModuleInfo(String name) {
        this.moduleName = name;
        this.moduleAttributes = new Hashtable();
        this.unexposedSIOs = new Vector();
        this.onCardClientRoles = new Vector();
        this.userRoles = new Vector();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getModuleDisplayName() {
        return this.moduleAttributes.get("module-display-name");
    }

    public String getModuleDescription() {
        String aid = null;
        aid = this.moduleAttributes.get("module-description");
        return aid == null ? "" : aid;
    }

    public String getAID() {
        return this.moduleAttributes.get("classic-package-aid");
    }

    public String getWebContextPath() {
        return this.moduleAttributes.get("web-context-path");
    }

    public int getWebSecurePort() {
        return this.webSecurePort;
    }

    public boolean isWebClientAuthRequired() {
        return this.webClientAuthRequired;
    }

    public boolean isWebSecureAccessOnly() {
        return this.webSecureAccessOnly;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public ClientRole getClientRoleByRoleName(String roleName) {
        for (ClientRole cr : this.onCardClientRoles) {
            if (!cr.getClientRoleName().equalsIgnoreCase(roleName)) continue;
            return cr;
        }
        return null;
    }

    public UserRole getUserRoleByRoleName(String roleName) {
        for (UserRole ur : this.userRoles) {
            if (!roleName.equalsIgnoreCase(ur.getUserRoleName())) continue;
            return ur;
        }
        return null;
    }

    public Vector<String> getUnexposedSIOsList() {
        return this.unexposedSIOs;
    }

    public Vector<ClientRole> getClientRoleList() {
        return this.onCardClientRoles;
    }

    public String getOnCardClientsCredentialAuthType() {
        return this.onCardClientsCredentialAuthType;
    }

    public String getOnCardClientsCredentialAuthDuration() {
        return this.onCardClientsCredentialAuthDuration;
    }

    public Vector<UserRole> getUserRoleList() {
        return this.userRoles;
    }

    void setSingleModuleInfo(Hashtable<String, String> attrValues, byte appType) throws FormatErrorException {
        this.appType = appType;
        this.moduleAttributes = attrValues;
        this.populateModuleAttributes(true);
    }

    void parseModuleinfo(BufferedReader br, byte appType, StringBuffer name, StringBuffer value, StringBuffer lastLine, boolean isStandAlone) throws IOException, FormatErrorException {
        this.appType = appType;
        Util.startReadNewSection();
        while (!Util.atSectionEnd() && !Util.fileEndReached) {
            boolean isSet = false;
            Util.readAttribute(br, name, value, lastLine);
            for (String mappingPropertyName : JCRuntimeDesc.MAPPING_ATTRIBUTES_LIST) {
                if (!name.toString().toLowerCase().endsWith(mappingPropertyName)) continue;
                int index = name.toString().toLowerCase().indexOf(mappingPropertyName);
                String role = name.toString().substring(0, index);
                if (role.equalsIgnoreCase("on-card-clients")) continue;
                this.moduleAttributes.put(role + mappingPropertyName, value.toString());
                isSet = true;
            }
            if (isSet) continue;
            this.moduleAttributes.put(name.toString().toLowerCase(), value.toString());
        }
        this.populateModuleAttributes(isStandAlone);
    }

    private void populateModuleAttributes(boolean isStandAlone) throws FormatErrorException {
        if (!isStandAlone) {
            this.moduleName = this.moduleAttributes.get("name");
            if (this.moduleName == null) {
                Util.fatalError("4070", "Name");
            }
        }
        if (this.appType == 10) {
            String secureAccess;
            String sealedValue;
            String clientAuth;
            String port;
            String webContextPath = this.moduleAttributes.get("web-context-path");
            if (webContextPath == null) {
                Util.fatalError("4077", "");
            }
            if (!webContextPath.startsWith("/")) {
                Util.fatalError("4095", "");
            }
            if (Card.isCMInitialized() && (webContextPath.startsWith("/cardmanager") || webContextPath.startsWith("/platform") || webContextPath.startsWith("/standard") || webContextPath.startsWith("/default"))) {
                Util.fatalError("4096", webContextPath);
            }
            if ((port = this.moduleAttributes.get("web-secure-port-number")) != null) {
                try {
                    this.webSecurePort = Integer.parseInt(port);
                }
                catch (Exception e) {
                    Util.fatalError("4078", port);
                }
                if (this.webSecurePort == -1) {
                    Util.fatalError("4078", "-1");
                }
                if (this.webSecurePort != 443 && (this.webSecurePort < 49152 || this.webSecurePort > 65535)) {
                    Util.fatalError("4081", Integer.toString(this.webSecurePort));
                }
                if (SecureCommunicationInfoRegistry.isPortReserved(this.webSecurePort)) {
                    Util.fatalError("4082", Integer.toString(this.webSecurePort));
                }
                if (SecureCommunicationInfoRegistry.isPortInRedirectTable(this.webSecurePort)) {
                    Util.fatalError("4083", Integer.toString(this.webSecurePort));
                }
                SecureCommunicationInfoRegistry.addToReservedList(this.webSecurePort);
            }
            if ((clientAuth = this.moduleAttributes.get("web-client-auth-required")) != null) {
                if (!clientAuth.equals("true") && !clientAuth.equals("false")) {
                    throw new FormatErrorException("4080", clientAuth + "\nWeb-Client-Auth-Required");
                }
                boolean bl = this.webClientAuthRequired = clientAuth.equals("true");
            }
            if ((sealedValue = this.moduleAttributes.get("sealed")) != null) {
                if (!sealedValue.equalsIgnoreCase("true") && !sealedValue.equalsIgnoreCase("false")) {
                    throw new FormatErrorException("4080", sealedValue + "\nSealed");
                }
                boolean bl = this.sealed = sealedValue.equalsIgnoreCase("true");
            }
            if ((secureAccess = this.moduleAttributes.get("web-secure-access-only")) != null) {
                if (!secureAccess.equals("true") && !secureAccess.equals("false")) {
                    throw new FormatErrorException("4080", secureAccess + "\nWeb-Secure-Access-Only");
                }
                boolean bl = this.webSecureAccessOnly = secureAccess.equals("true");
            }
        }
        if ((this.appType == 10 || this.appType == 11) && this.moduleAttributes.get("classic-package-aid") != null) {
            Util.fatalError("4084", "");
        }
        if (this.appType == 12) {
            String classicPkgAID = this.moduleAttributes.get("classic-package-aid");
            if (classicPkgAID == null) {
                Util.fatalError("4076", "");
            }
            if (!APDUUtil.isValidAID(classicPkgAID)) {
                Util.fatalError("4309", classicPkgAID);
            }
        }
        this.setUnexposedSIOs(this.moduleAttributes.get("unexposed-shareable-interface"));
        this.setClientRoles(this.moduleAttributes.get("on-card-client-role-list"));
        this.setOnCardClientsCredentialAuthType(this.moduleAttributes.get("on-card-clients-credential-auth-type"));
        this.setOnCardClientsCredentialAuthDuration(this.moduleAttributes.get("on-card-clients-credential-auth-duration"));
        this.setUserRoles(this.moduleAttributes.get("user-role-list"));
        this.verifyRoleOfMappedAttributes();
    }

    private void verifyRoleOfMappedAttributes() throws FormatErrorException {
        Vector<String> userRoleList = new Vector<String>();
        Vector<String> onCardClientRoleList = new Vector<String>();
        for (UserRole ur : this.userRoles) {
            if (ur == null) continue;
            userRoleList.addElement(ur.getUserRoleName());
        }
        for (ClientRole cr : this.onCardClientRoles) {
            if (cr == null) continue;
            onCardClientRoleList.addElement(cr.getClientRoleName());
        }
        Enumeration<String> keys = this.moduleAttributes.keys();
        while (keys.hasMoreElements()) {
            int index;
            String role;
            String attribute = keys.nextElement();
            if (attribute.endsWith(USER_AUTH_URI_MAPPING_SUFFIX) && !userRoleList.contains(role = attribute.substring(0, index = attribute.indexOf(USER_AUTH_URI_MAPPING_SUFFIX)))) {
                Util.fatalError("4134", attribute + "\nuser-role-list");
            }
            for (String mappingPropertyName : CLIENT_MAPPING_ATTRIBUTES_LIST) {
                int index2;
                String role2;
                if (!attribute.endsWith(mappingPropertyName) || (role2 = attribute.substring(0, index2 = attribute.indexOf(mappingPropertyName))).equalsIgnoreCase("on-card-clients") || onCardClientRoleList.contains(role2)) continue;
                Util.fatalError("4134", attribute + "\non-card-client-list");
            }
        }
    }

    private void setClientRoles(String clientRoleList) throws FormatErrorException {
        if (clientRoleList == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(clientRoleList, ", ");
        while (tokenizer.hasMoreTokens()) {
            String authDuration;
            String authType;
            String authCredentials;
            String protectionDomains;
            boolean isMapped = false;
            String client = tokenizer.nextToken();
            ClientRole cr = new ClientRole(client);
            String clientURIs = this.moduleAttributes.get(client + CLIENT_URI_MAPPING_SUFFIX);
            if (clientURIs != null) {
                this.onCardClientRoles.addElement(cr);
                if (!cr.setClientURIs(clientURIs)) {
                    Util.fatalError("4079", client + CLIENT_URI_MAPPING_SUFFIX_CAP);
                }
                isMapped = true;
            }
            if ((protectionDomains = this.moduleAttributes.get(client + CLIENT_PD_MAPPING_SUFFIX)) != null) {
                if (protectionDomains.equals("") || protectionDomains.indexOf(32) > 0 || !protectionDomains.startsWith("pd:")) {
                    Util.fatalError("4080", protectionDomains + "\n" + client + CLIENT_PD_MAPPING_SUFFIX_CAP);
                }
                this.onCardClientRoles.addElement(cr);
                if (!cr.setProtectionDomains(protectionDomains)) {
                    Util.fatalError("4079", client + CLIENT_PD_MAPPING_SUFFIX_CAP);
                }
                isMapped = true;
            }
            if ((authCredentials = this.moduleAttributes.get(client + CLIENT_AUTH_CREDENTIAL_MAPPING_SUFFIX)) != null) {
                this.onCardClientRoles.addElement(cr);
                if (!cr.setAuthCredentials(authCredentials)) {
                    Util.fatalError("4079", client + CLIENT_AUTH_CREDENTIAL_MAPPING_SUFFIX_CAP);
                }
                isMapped = true;
            }
            if ((authType = this.moduleAttributes.get(client + CLIENT_CREDENTIAL_AUTH_TYPE_MAPPING_SUFFIX)) != null) {
                if (!authType.equals("client-only")) {
                    Util.fatalError("4080", authType + "\n" + client + CLIENT_CREDENTIAL_AUTH_TYPE_MAPPING_SUFFIX_CAP);
                }
                if (!cr.setCredentialAuthType(authType)) {
                    Util.fatalError("4079", client + CLIENT_CREDENTIAL_AUTH_TYPE_MAPPING_SUFFIX_CAP);
                }
            }
            if ((authDuration = this.moduleAttributes.get(client + CLIENT_CREDENTIAL_AUTH_DURATION_MAPPING_SUFFIX)) != null) {
                if (!(authDuration.equals(ACCESS_DURATION) || authDuration.equals(CARD_SESSION_DURATION) || authDuration.equals(CLIENT_LIFETIME_DURATION))) {
                    Util.fatalError("4080", authDuration + "\n" + client + CLIENT_CREDENTIAL_AUTH_DURATION_MAPPING_SUFFIX_CAP);
                }
                if (!cr.setCredentialAuthDuration(authDuration)) {
                    Util.fatalError("4079", client + CLIENT_CREDENTIAL_AUTH_DURATION_MAPPING_SUFFIX_CAP);
                }
            }
            if (isMapped) continue;
            Util.fatalError("4133", client);
        }
    }

    private void setOnCardClientsCredentialAuthType(String authType) throws FormatErrorException {
        if (authType != null) {
            if (!authType.equals("client-only")) {
                Util.fatalError("4080", authType + "\nOn-Card-Clients-Credential-Auth-Type");
            }
            this.onCardClientsCredentialAuthType = authType;
        }
    }

    private void setOnCardClientsCredentialAuthDuration(String authDuration) throws FormatErrorException {
        if (authDuration != null) {
            if (!(authDuration.equals(ACCESS_DURATION) || authDuration.equals(CARD_SESSION_DURATION) || authDuration.equals(CLIENT_LIFETIME_DURATION))) {
                Util.fatalError("4080", authDuration + "\nOn-Card-Clients-Credential-Auth-Duration");
            }
            this.onCardClientsCredentialAuthDuration = authDuration;
        }
    }

    private void setUserRoles(String userRoleList) throws FormatErrorException {
        if (userRoleList == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(userRoleList, ", ");
        while (tokenizer.hasMoreTokens()) {
            String user = tokenizer.nextToken();
            String mappedAuthURIs = this.moduleAttributes.get(user + USER_AUTH_URI_MAPPING_SUFFIX);
            if (mappedAuthURIs == null) {
                Util.fatalError("4126", user + "\n" + user + USER_AUTH_URI_MAPPING_SUFFIX_CAP);
            }
            UserRole ur = new UserRole(user);
            this.userRoles.addElement(ur);
            if (ur.setAuthURIs(mappedAuthURIs)) continue;
            Util.fatalError("4079", user + USER_AUTH_URI_MAPPING_SUFFIX_CAP);
        }
    }

    private void setUnexposedSIOs(String sioList) {
        if (sioList == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(sioList, ", ");
        while (tokenizer.hasMoreTokens()) {
            this.unexposedSIOs.addElement(tokenizer.nextToken().trim());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t\tName: " + this.moduleName + "\n");
        sb.append("\t\tModule-Display-Name: " + this.getModuleDisplayName() + "\n");
        sb.append("\t\tModule-Description: " + this.getModuleDescription() + "\n");
        if (this.appType == 12 || this.appType == 11) {
            sb.append("\t\tClassic-Package-AID: " + this.getAID() + "\n");
        }
        if (this.appType == 10) {
            sb.append("\t\tWeb-Context-Path: " + this.getWebContextPath() + "\n");
            sb.append("\t\tWeb-Secure-Port-Number: " + this.webSecurePort + "\n");
        }
        if (this.unexposedSIOs != null) {
            for (String sio : this.unexposedSIOs) {
                sb.append("\t\tUnexposed-Shareable-Interface: " + sio + "\n");
            }
        }
        if (this.onCardClientRoles != null) {
            for (ClientRole cr : this.onCardClientRoles) {
                sb.append("\t\tOn-Card-Client-Role: " + cr.getClientRoleName() + "\n" + cr.toString());
            }
        }
        sb.append("\t\tOn-Card-Clients-Creadential-Auth-Type: " + this.onCardClientsCredentialAuthType + "\n");
        sb.append("\t\tOn-Card-Clients-Creadential-Auth-Duration: " + this.onCardClientsCredentialAuthDuration + "\n");
        if (this.userRoles != null) {
            for (UserRole ur : this.userRoles) {
                sb.append("\t\tUser-Role: " + ur.getUserRoleName() + "\n" + ur.toString());
            }
        }
        return sb.toString();
    }
}

