/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.sun.javacard.impl.NativeMethods;
import java.security.Permission;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public abstract class BasicPermission
extends Permission {
    private transient boolean wildcard;
    private transient String path;

    private void init(String name) {
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        int len = name.length();
        if (len == 0) {
            throw new IllegalArgumentException("name can't be empty");
        }
        char last = name.charAt(len - 1);
        if (last == '*' && (len == 1 || name.charAt(len - 2) == '.')) {
            this.wildcard = true;
            this.path = len == 1 ? "" : name.substring(0, len - 1);
        } else {
            this.path = name;
        }
    }

    public BasicPermission(String name) {
        super(name);
        name.equals(null);
        this.init(name);
    }

    public BasicPermission(String name, String actions) {
        super(name);
        name.equals(null);
        this.init(name);
    }

    @Override
    public boolean implies(Permission p) {
        if (p != null) {
            NativeMethods.checkPreviousContextAccess(p);
        }
        if (p == null || p.getClass() != this.getClass()) {
            return false;
        }
        BasicPermission that = (BasicPermission)p;
        String path2 = new String(that.path);
        boolean wildcard2 = that.wildcard;
        if (this.wildcard) {
            if (wildcard2) {
                return path2.startsWith(this.path);
            }
            return path2.length() > this.path.length() && path2.startsWith(this.path);
        }
        if (wildcard2) {
            return false;
        }
        return this.path.equals(path2);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            NativeMethods.checkPreviousContextAccess(obj);
        }
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BasicPermission bp = (BasicPermission)obj;
        return this.getName().equals(bp.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getActions() {
        return "";
    }
}

