/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Hashtable<K, V> {
    private HashtableEntry<K, V>[] table;
    private int count;
    private int threshold;
    private static final int loadFactorPercent = 75;

    public Hashtable(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.table = new HashtableEntry[initialCapacity];
        this.threshold = initialCapacity * 75 / 100;
    }

    public Hashtable() {
        this(11);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration<K> keys() {
        return new HashtableEnumerator(this.table, true);
    }

    public synchronized Enumeration<V> elements() {
        return new HashtableEnumerator(this.table, false);
    }

    public synchronized boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        HashtableEntry<K, V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            HashtableEntry<K, V> e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(Object key) {
        HashtableEntry<K, V>[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashtableEntry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized V get(K key) {
        HashtableEntry<K, V>[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashtableEntry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        HashtableEntry<K, V>[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        HashtableEntry[] newTable = new HashtableEntry[newCapacity];
        this.threshold = newCapacity * 75 / 100;
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            HashtableEntry<K, V> old = oldTable[i];
            while (old != null) {
                HashtableEntry<K, V> e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public synchronized V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        HashtableEntry<K, V>[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashtableEntry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        e = new HashtableEntry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    public synchronized V remove(K key) {
        HashtableEntry<K, V>[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashtableEntry<K, V> e = tab[index];
        HashtableEntry<K, V> prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void clear() {
        HashtableEntry<K, V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration<K> k = this.keys();
        Enumeration<V> e = this.elements();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            String s1 = k.nextElement().toString();
            String s2 = e.nextElement().toString();
            buf.append(s1 + "=" + s2);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public synchronized boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Hashtable)) {
            return false;
        }
        Hashtable t = (Hashtable)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            HashtableEntry<K, V>[] tab = this.table;
            int index = tab.length;
            while (--index >= 0) {
                HashtableEntry<K, V> e = tab[index];
                if (e == null) continue;
                Object key = e.key;
                Object value = e.value;
                if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    public synchronized int hashCode() {
        int h = 0;
        if (this.count <= 0) {
            return h;
        }
        this.count = -this.count;
        HashtableEntry<K, V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            HashtableEntry<K, V> e = tab[i];
            while (e != null) {
                h += e.key.hashCode() ^ e.value.hashCode();
                e = e.next;
            }
        }
        this.count = -this.count;
        return h;
    }

    static class HashtableEntry<K, V> {
        int hash;
        K key;
        V value;
        HashtableEntry<K, V> next;

        HashtableEntry() {
        }
    }

    private class HashtableEnumerator<E>
    implements Enumeration<E> {
        boolean keys;
        int index;
        HashtableEntry<K, V>[] etable;
        HashtableEntry<K, V> entry;

        HashtableEnumerator(HashtableEntry<K, V>[] table, boolean keys) {
            this.etable = table;
            this.keys = keys;
            this.index = table.length;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.etable[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public E nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.etable[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                HashtableEntry e = this.entry;
                this.entry = e.next;
                return (E)(this.keys ? e.key : e.value);
            }
            throw new NoSuchElementException("HashtableEnumerator");
        }
    }
}

