/*
 * Decompiled with CFR 0.152.
 */
package javacardx.facilities;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.util.JCSystemAccessor;
import com.sun.javacard.util.PathLookupTable;
import com.sun.javacard.util.URIUtils;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Vector;
import javacardx.facilities.Event;
import javacardx.facilities.EventNotificationListener;
import javacardx.facilities.EventRegistryPermission;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public final class EventRegistry {
    private static final String EVENT_ROOT_AID_URI = "event://aid/";
    private static final String EVENT_ROOT_URI = "event:///";
    public static final String SOURCE_PLATFORM = "///platform";
    private static final String EVENT_SCHEME = "event";
    private static PathLookupTable<EventNotificationListener> registry;
    private static EventRegistry eventRegistry;
    private static final String SOURCE_STANDARD = "///standard";

    public static final synchronized EventRegistry getEventRegistry() {
        if (eventRegistry == null) {
            eventRegistry = new EventRegistry();
            NativeMethods.setJCREentry(eventRegistry, false);
        }
        return eventRegistry;
    }

    private EventRegistry() {
        registry = new PathLookupTable();
        JCSystemAccessor.getJCSystemAccessor().setEventRegistry(registry);
    }

    public void register(String sourceURI, String eventURI, EventNotificationListener listener) {
        if (sourceURI != null) {
            NativeMethods.checkPreviousContextAccess(sourceURI);
        }
        if (eventURI != null) {
            NativeMethods.checkPreviousContextAccess(eventURI);
        }
        if (listener != null) {
            NativeMethods.checkPreviousContextAccess(listener);
        }
        this.doRegister(sourceURI, eventURI, listener);
    }

    private void doRegister(String sourceURI, String eventURI, EventNotificationListener listener) {
        int objectContext;
        if (eventURI == null || listener == null) {
            throw new NullPointerException();
        }
        if (SOURCE_STANDARD.equals(sourceURI)) {
            throw new IllegalArgumentException();
        }
        if (URIUtils.isOpaque(eventURI)) {
            throw new IllegalArgumentException();
        }
        boolean isEventAbsolute = URIUtils.isAbsolute(eventURI);
        if (sourceURI == null) {
            if (!isEventAbsolute) {
                eventURI = URIUtils.resolveWithScheme(EVENT_SCHEME, eventURI);
            }
        } else if (!isEventAbsolute) {
            String appURI;
            if (URIUtils.isAbsolute(sourceURI)) {
                appURI = JCSystemAccessor.getJCSystemAccessor().getBaseAppURI(NativeMethods.getPreviousContext(), sourceURI);
                if (appURI == null) {
                    throw new IllegalArgumentException();
                }
                eventURI = URIUtils.resolve(appURI, eventURI);
            } else {
                if (!URIUtils.isAppURI(URIUtils.normalize(sourceURI))) {
                    appURI = URIUtils.getAppURI();
                    sourceURI = URIUtils.resolve(appURI, sourceURI);
                }
                eventURI = URIUtils.resolve(sourceURI, eventURI);
            }
            StringBuilder sb = new StringBuilder(EVENT_SCHEME);
            sb.append(":");
            eventURI = sb.append(eventURI).toString();
        } else {
            boolean valid;
            boolean a = URIUtils.isInPlatformNamespace(eventURI) && (sourceURI == null || SOURCE_PLATFORM.equals(sourceURI));
            boolean b = URIUtils.isAppURI(sourceURI) && URIUtils.isInNamespace(eventURI, sourceURI);
            boolean c = URIUtils.haveSamePathPrefix(eventURI, sourceURI);
            boolean d = URIUtils.isInStandardNamespace(eventURI);
            boolean bl = valid = a || b || c || d;
            if (!valid) {
                throw new IllegalArgumentException();
            }
        }
        if (sourceURI != null) {
            sourceURI = URIUtils.normalize(sourceURI);
            sourceURI = URIUtils.normalizeReservedURI(sourceURI);
        }
        eventURI = URIUtils.normalize(eventURI);
        if (!URIUtils.hasScheme(eventURI = URIUtils.normalizeReservedURI(eventURI), EVENT_SCHEME)) {
            throw new IllegalArgumentException();
        }
        byte previousContext = NativeMethods.getPreviousContext();
        if (previousContext != (objectContext = NativeMethods.objectContext(listener))) {
            throw new SecurityException();
        }
        AccessController.checkPermission(new EventRegistryPermission(eventURI, "register"));
        registry.insert(URIUtils.getAppURI(), eventURI, listener, sourceURI);
    }

    public void register(String eventURI, EventNotificationListener listener) {
        if (eventURI != null) {
            NativeMethods.checkPreviousContextAccess(eventURI);
        }
        if (listener != null) {
            NativeMethods.checkPreviousContextAccess(listener);
        }
        this.doRegister(null, eventURI, listener);
    }

    public Enumeration<EventNotificationListener> list() {
        byte previousContext = NativeMethods.getPreviousContext();
        Vector<EventNotificationListener> w = new Vector<EventNotificationListener>();
        NativeMethods.transferOwnershipToPreviousContext(w);
        Enumeration<EventNotificationListener> e = registry.elements();
        while (e.hasMoreElements()) {
            EventNotificationListener listener = e.nextElement();
            int objectContext = NativeMethods.objectContext(listener);
            if (previousContext != objectContext) continue;
            w.addElement(listener);
        }
        return w.elements();
    }

    public void notifyListeners(Event event) {
        if (event != null) {
            NativeMethods.checkPreviousContextAccess(event);
        }
        this.doNotifyListenersInRole(event, null, false);
    }

    public void notifyListeners(Event event, boolean noWait) {
        if (event != null) {
            NativeMethods.checkPreviousContextAccess(event);
        }
        this.doNotifyListenersInRole(event, null, noWait);
    }

    public void notifyListenersInRole(Event event, String role) {
        if (event != null) {
            NativeMethods.checkPreviousContextAccess(event);
        }
        if (role != null) {
            NativeMethods.checkPreviousContextAccess(role);
        }
        this.doNotifyListenersInRole(event, role, false);
    }

    public void notifyListenersInRole(Event event, String role, boolean noWait) {
        if (event != null) {
            NativeMethods.checkPreviousContextAccess(event);
        }
        if (role != null) {
            NativeMethods.checkPreviousContextAccess(role);
        }
        this.doNotifyListenersInRole(event, role, noWait);
    }

    private void doNotifyListenersInRole(Event event, String role, boolean noWait) {
        boolean calledByCMOrJCRE;
        AccessController.checkPermission(new EventRegistryPermission(event.getURI(), "notify"));
        String appURI = URIUtils.getAppURI();
        boolean bl = calledByCMOrJCRE = appURI == null || appURI.equals("///cardmanager");
        if (!calledByCMOrJCRE && !URIUtils.isInAppNamespace(event.getSourceURI())) {
            throw new SecurityException();
        }
        String eventURI = event.getURI();
        if (calledByCMOrJCRE ? !URIUtils.isInStandardNamespace(eventURI) : !URIUtils.isInAppNamespace(eventURI) && !URIUtils.isInStandardNamespace(eventURI)) {
            throw new SecurityException();
        }
        String sourceURI = event.getSourceURI();
        sourceURI = URIUtils.normalize(sourceURI);
        sourceURI = URIUtils.normalizeReservedURI(sourceURI);
        final Enumeration<PathLookupTable.Entry> e = registry.lookup(eventURI);
        final String theSourceURI = sourceURI;
        final String theRole = role;
        final Event theEvent = event;
        final String serverURI = URIUtils.getAppURI();
        Thread t = new Thread(){

            @Override
            public void run() {
                while (e.hasMoreElements()) {
                    PathLookupTable.Entry entry = (PathLookupTable.Entry)e.nextElement();
                    EventNotificationListener listener = (EventNotificationListener)entry.getResource();
                    if (entry.getSourceURI() != null && !entry.getSourceURI().equals(theSourceURI) || theRole != null && !EventRegistry.this.isListenerInRole(listener, serverURI, theRole, new String(theEvent.getURI()))) continue;
                    try {
                        listener.notify(theEvent);
                    }
                    catch (Throwable throwable) {}
                }
            }
        };
        t.start();
        if (!noWait) {
            try {
                t.join();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    public void unregister(String sourceURI, String eventURI, EventNotificationListener listener) {
        if (sourceURI != null) {
            NativeMethods.checkPreviousContextAccess(sourceURI);
        }
        if (eventURI != null) {
            NativeMethods.checkPreviousContextAccess(eventURI);
        }
        if (listener != null) {
            NativeMethods.checkPreviousContextAccess(listener);
        }
        this.doUnregister(sourceURI, eventURI, listener);
    }

    private void doUnregister(String sourceURI, String eventURI, EventNotificationListener listener) {
        int objectContext;
        byte previousContext;
        if (SOURCE_STANDARD.equals(sourceURI)) {
            throw new IllegalArgumentException();
        }
        if (eventURI == null) {
            throw new NullPointerException();
        }
        if (URIUtils.isOpaque(eventURI)) {
            throw new IllegalArgumentException();
        }
        boolean isEventAbsolute = URIUtils.isAbsolute(eventURI);
        if (sourceURI == null) {
            if (!isEventAbsolute) {
                eventURI = URIUtils.resolveWithScheme(EVENT_SCHEME, eventURI);
            }
        } else if (!isEventAbsolute) {
            String appURI;
            if (URIUtils.isAbsolute(sourceURI)) {
                appURI = JCSystemAccessor.getJCSystemAccessor().getBaseAppURI(NativeMethods.getPreviousContext(), sourceURI);
                if (appURI == null) {
                    throw new IllegalArgumentException();
                }
                eventURI = URIUtils.resolve(appURI, eventURI);
            } else {
                if (!URIUtils.isAppURI(URIUtils.normalize(sourceURI))) {
                    appURI = URIUtils.getAppURI();
                    sourceURI = URIUtils.resolve(appURI, sourceURI);
                }
                eventURI = URIUtils.resolve(sourceURI, eventURI);
            }
            StringBuilder sb = new StringBuilder(EVENT_SCHEME);
            sb.append(":");
            eventURI = sb.append(eventURI).toString();
        } else {
            boolean valid;
            boolean a = URIUtils.isInPlatformNamespace(eventURI) && (sourceURI == null || SOURCE_PLATFORM.equals(sourceURI));
            boolean b = URIUtils.isAppURI(sourceURI) && URIUtils.isInNamespace(eventURI, sourceURI);
            boolean c = URIUtils.haveSamePathPrefix(eventURI, sourceURI);
            boolean d = URIUtils.isInStandardNamespace(eventURI);
            boolean bl = valid = a || b || c || d;
            if (!valid) {
                throw new IllegalArgumentException();
            }
        }
        if (sourceURI != null) {
            sourceURI = URIUtils.normalize(sourceURI);
            sourceURI = URIUtils.normalizeReservedURI(sourceURI);
        }
        eventURI = URIUtils.normalize(eventURI);
        if (!URIUtils.hasScheme(eventURI = URIUtils.normalizeReservedURI(eventURI), EVENT_SCHEME)) {
            throw new IllegalArgumentException();
        }
        if (listener != null && (previousContext = NativeMethods.getPreviousContext()) != (objectContext = NativeMethods.objectContext(listener))) {
            throw new SecurityException();
        }
        AccessController.checkPermission(new EventRegistryPermission(eventURI, "unregister"));
        if (listener == null) {
            registry.remove(URIUtils.getAppURI(), sourceURI, eventURI);
        } else {
            registry.remove(URIUtils.getAppURI(), eventURI, listener, sourceURI);
        }
    }

    public void unregister(String eventURI, EventNotificationListener listener) {
        if (eventURI != null) {
            NativeMethods.checkPreviousContextAccess(eventURI);
        }
        if (listener != null) {
            NativeMethods.checkPreviousContextAccess(listener);
        }
        this.doUnregister(null, eventURI, listener);
    }

    private boolean isListenerInRole(EventNotificationListener listener, String serverURI, String role, String resource) {
        JCSystemAccessor jcSystemAccessor = JCSystemAccessor.getJCSystemAccessor();
        String appURI = serverURI;
        byte id = NativeMethods.getObjectOwnerId(listener);
        String listenerURI = jcSystemAccessor.getURI(id);
        return jcSystemAccessor.isClientInRole(appURI, serverURI, listenerURI, role, resource);
    }

    static {
        eventRegistry = null;
    }
}

